/*###############################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_POWERMANAGEMENTSERVICEACCESS_H_
#define OPENDRIM_POWERMANAGEMENTSERVICEACCESS_H_

#include "PowerManagement_Common.h"

#include "OpenDRIM_PowerManagementService.h"

int PowerManagement_OpenDRIM_PowerManagementService_load(const CMPIBroker* broker, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementService_unload(string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementService_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PowerManagementService>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_PowerManagementService_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PowerManagementService& instance, const char** properties, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementService_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& newInstance, const OpenDRIM_PowerManagementService& oldInstance, const char** properties, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementService_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& instance, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementService_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& instance, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementService_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& instance, unsigned int& returnValue, const OpenDRIM_PowerManagementService_RequestStateChange_In& in, OpenDRIM_PowerManagementService_RequestStateChange_Out& out, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementService_StartService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& instance, unsigned int& returnValue, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementService_StopService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& instance, unsigned int& returnValue, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementService_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& instance, unsigned int& returnValue, const OpenDRIM_PowerManagementService_SetPowerState_In& in, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementService_RequestPowerStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& instance, unsigned int& returnValue, const OpenDRIM_PowerManagementService_RequestPowerStateChange_In& in, OpenDRIM_PowerManagementService_RequestPowerStateChange_Out& out, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementService_populate(OpenDRIM_PowerManagementService& instance, string& errorMessage);

#endif /*OPENDRIM_POWERMANAGEMENTSERVICEACCESS_H_*/
