/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_HARDWARETHREADACCESS_H_
#define OPENDRIM_HARDWARETHREADACCESS_H_

#include "CPU_Common.h"
#include <SMBIOS.h>

#include "OpenDRIM_HardwareThread.h"

int CPU_OpenDRIM_HardwareThread_load(const CMPIBroker* broker, string& errorMessage);

int CPU_OpenDRIM_HardwareThread_unload(string& errorMessage);

int CPU_OpenDRIM_HardwareThread_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_HardwareThread>& instances, const char** properties, string& errorMessage, const string& discriminant);

int CPU_OpenDRIM_HardwareThread_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_HardwareThread& instance, const char** properties, string& errorMessage);

int CPU_OpenDRIM_HardwareThread_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_HardwareThread& newInstance, const OpenDRIM_HardwareThread& oldInstance, const char** properties, string& errorMessage);

int CPU_OpenDRIM_HardwareThread_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_HardwareThread& instance, string& errorMessage);

int CPU_OpenDRIM_HardwareThread_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_HardwareThread& instance, string& errorMessage);

int CPU_OpenDRIM_HardwareThread_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_HardwareThread& instance, unsigned int& returnValue, const OpenDRIM_HardwareThread_RequestStateChange_In& in, OpenDRIM_HardwareThread_RequestStateChange_Out& out, string& errorMessage);

int CPU_OpenDRIM_HardwareThread_populate(OpenDRIM_HardwareThread& instance, const _processor_topology& cpu_info_processor_information, unsigned int core_id, unsigned int thread_id, string& errorMessage);

#endif /*OPENDRIM_HARDWARETHREADACCESS_H_*/
