/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.variant;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.index.DynamicIndexCreator;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.tribble.index.interval.IntervalIndexCreator;
import htsjdk.tribble.index.linear.LinearIndexCreator;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndexCreator;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFSimpleHeaderLine;
import htsjdk.variant.vcf.VCFUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.engine.CommandLineGATK;
import org.broadinstitute.gatk.engine.GenomeAnalysisEngine;
import org.broadinstitute.gatk.engine.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.gatk.engine.io.stubs.VCFWriterArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.collections.Pair;
import org.broadinstitute.gatk.utils.commandline.RodBinding;
import org.broadinstitute.gatk.utils.variant.GATKVCFIndexType;

public class GATKVCFUtils {
    public static final Logger logger = Logger.getLogger(GATKVCFUtils.class);
    public static final String GATK_COMMAND_LINE_KEY = "GATKCommandLine";
    public static final GATKVCFIndexType DEFAULT_INDEX_TYPE = GATKVCFIndexType.DYNAMIC_SEEK;
    public static final Integer DEFAULT_INDEX_PARAMETER = -1;

    private GATKVCFUtils() {
    }

    public static VCFHeaderLine getCommandLineArgumentHeaderLine(GenomeAnalysisEngine engine, Collection<Object> argumentSources) {
        if (engine == null) {
            throw new IllegalArgumentException("engine cannot be null");
        }
        if (argumentSources == null) {
            throw new IllegalArgumentException("argumentSources cannot be null");
        }
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("ID", engine.getWalkerName());
        attributes.put("Version", CommandLineGATK.getVersionNumber());
        Date date = new Date();
        attributes.put("Date", date.toString());
        attributes.put("Epoch", Long.toString(date.getTime()));
        attributes.put("CommandLineOptions", engine.createApproximateCommandLineArgumentString(argumentSources.toArray()));
        return new VCFSimpleHeaderLine(GATK_COMMAND_LINE_KEY, attributes);
    }

    public static <T extends Feature> Map<String, VCFHeader> getVCFHeadersFromRods(GenomeAnalysisEngine toolkit, List<RodBinding<T>> rodBindings) {
        TreeSet<String> names = new TreeSet<String>();
        for (RodBinding<T> evalRod : rodBindings) {
            names.add(evalRod.getName());
        }
        return GATKVCFUtils.getVCFHeadersFromRods(toolkit, names);
    }

    public static Map<String, VCFHeader> getVCFHeadersFromRods(GenomeAnalysisEngine toolkit) {
        return GATKVCFUtils.getVCFHeadersFromRods(toolkit, (Collection<String>)null);
    }

    public static Map<String, VCFHeader> getVCFHeadersFromRods(GenomeAnalysisEngine toolkit, Collection<String> rodNames) {
        HashMap<String, VCFHeader> data = new HashMap<String, VCFHeader>();
        List dataSources = toolkit.getRodDataSources();
        for (ReferenceOrderedDataSource source : dataSources) {
            if (rodNames != null && !rodNames.contains(source.getName()) || source.getHeader() == null || !(source.getHeader() instanceof VCFHeader)) continue;
            data.put(source.getName(), (VCFHeader)source.getHeader());
        }
        return data;
    }

    public static Map<String, VCFHeader> getVCFHeadersFromRodPrefix(GenomeAnalysisEngine toolkit, String prefix) {
        HashMap<String, VCFHeader> data = new HashMap<String, VCFHeader>();
        List dataSources = toolkit.getRodDataSources();
        for (ReferenceOrderedDataSource source : dataSources) {
            if (!source.getName().startsWith(prefix) || source.getHeader() == null || !(source.getHeader() instanceof VCFHeader)) continue;
            data.put(source.getName(), (VCFHeader)source.getHeader());
        }
        return data;
    }

    public static Set<VCFHeaderLine> getHeaderFields(GenomeAnalysisEngine toolkit) {
        return GATKVCFUtils.getHeaderFields(toolkit, null);
    }

    public static Set<VCFHeaderLine> getHeaderFields(GenomeAnalysisEngine toolkit, Collection<String> rodNames) {
        TreeSet<VCFHeaderLine> fields = new TreeSet<VCFHeaderLine>();
        List dataSources = toolkit.getRodDataSources();
        for (ReferenceOrderedDataSource source : dataSources) {
            VCFHeader header;
            if (rodNames != null && !rodNames.contains(source.getName()) || !source.getRecordType().equals(VariantContext.class) || (header = (VCFHeader)source.getHeader()) == null) continue;
            fields.addAll(header.getMetaDataInSortedOrder());
        }
        return fields;
    }

    public static VCFHeader withUpdatedContigs(VCFHeader header, GenomeAnalysisEngine engine) {
        return VCFUtils.withUpdatedContigs((VCFHeader)header, (File)engine.getArguments().referenceFile, (SAMSequenceDictionary)engine.getMasterSequenceDictionary());
    }

    public static IndexCreator getIndexCreator(GATKVCFIndexType type, int parameter, File outFile) {
        return GATKVCFUtils.getIndexCreator(type, parameter, outFile, null);
    }

    public static IndexCreator getIndexCreator(GATKVCFIndexType type, int parameter, File outFile, SAMSequenceDictionary sequenceDictionary) {
        DynamicIndexCreator idxCreator;
        if (VCFWriterArgumentTypeDescriptor.isCompressed((String)outFile.toString())) {
            if (type != DEFAULT_INDEX_TYPE || parameter != DEFAULT_INDEX_PARAMETER) {
                logger.warn((Object)("Creating Tabix index for " + outFile + ", ignoring user-specified index type and parameter"));
            }
            if (sequenceDictionary == null) {
                return new TabixIndexCreator(TabixFormat.VCF);
            }
            return new TabixIndexCreator(sequenceDictionary, TabixFormat.VCF);
        }
        switch (type) {
            case DYNAMIC_SEEK: {
                idxCreator = new DynamicIndexCreator(outFile, IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME);
                break;
            }
            case DYNAMIC_SIZE: {
                idxCreator = new DynamicIndexCreator(outFile, IndexFactory.IndexBalanceApproach.FOR_SIZE);
                break;
            }
            case LINEAR: {
                idxCreator = new LinearIndexCreator(outFile, parameter);
                break;
            }
            case INTERVAL: {
                idxCreator = new IntervalIndexCreator(outFile, parameter);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IndexCreator type: " + (Object)((Object)type));
            }
        }
        return idxCreator;
    }

    public static final <SOURCE> Pair<VCFHeader, VCIterable<SOURCE>> readAllVCs(File file, FeatureCodec<VariantContext, SOURCE> codec) throws IOException {
        Object source = codec.makeSourceFromStream((InputStream)new FileInputStream(file));
        FeatureCodecHeader header = codec.readHeader(source);
        VCFHeader vcfHeader = (VCFHeader)header.getHeaderValue();
        return new Pair(vcfHeader, new VCIterable(source, codec, vcfHeader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<VCFHeader, List<VariantContext>> readVCF(File source) throws IOException {
        ArrayList<VariantContext> vcs = new ArrayList<VariantContext>();
        VCFCodec codec = new VCFCodec();
        PositionalBufferedStream pbs = new PositionalBufferedStream((InputStream)new FileInputStream(source));
        LineIterator vcfSource = codec.makeSourceFromStream((InputStream)pbs);
        try {
            VCFHeader vcfHeader = (VCFHeader)codec.readActualHeader(vcfSource);
            while (vcfSource.hasNext()) {
                VariantContext vc = (VariantContext)codec.decode(vcfSource);
                if (vc == null) continue;
                vcs.add(vc);
            }
            Pair<VCFHeader, List<VariantContext>> pair = new Pair<VCFHeader, List<VariantContext>>(vcfHeader, vcs);
            return pair;
        }
        finally {
            codec.close(vcfSource);
        }
    }

    public static class VCIterable<SOURCE>
    implements Iterable<VariantContext>,
    Iterator<VariantContext> {
        final SOURCE source;
        final FeatureCodec<VariantContext, SOURCE> codec;
        final VCFHeader header;

        private VCIterable(SOURCE source, FeatureCodec<VariantContext, SOURCE> codec, VCFHeader header) {
            this.source = source;
            this.codec = codec;
            this.header = header;
        }

        @Override
        public Iterator<VariantContext> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return !this.codec.isDone(this.source);
        }

        @Override
        public VariantContext next() {
            try {
                VariantContext vc = (VariantContext)this.codec.decode(this.source);
                return vc == null ? null : vc.fullyDecode(this.header, false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
        }
    }
}

