/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JTableHeaderDriver;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.JComponentFixture;
import org.fest.swing.fixture.JPopupMenuFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableHeaderFixture
extends ComponentFixture<JTableHeader>
implements JComponentFixture {
    private JTableHeaderDriver driver;

    public JTableHeaderFixture(Robot robot, JTableHeader target) {
        super(robot, target);
        this.driver(new JTableHeaderDriver(robot));
    }

    protected final void driver(JTableHeaderDriver newDriver) {
        JTableHeaderFixture.validateNotNull(newDriver);
        this.driver = newDriver;
    }

    public JTableHeaderFixture clickColumn(int index) {
        this.driver.clickColumn((JTableHeader)this.target, index);
        return this;
    }

    public JPopupMenuFixture showPopupMenuAt(int columnIndex) {
        JPopupMenu popupMenu = this.driver.showPopupMenu((JTableHeader)this.target, columnIndex);
        return new JPopupMenuFixture(this.robot, popupMenu);
    }

    public JPopupMenuFixture showPopupMenuAt(String columnName) {
        JPopupMenu popupMenu = this.driver.showPopupMenu((JTableHeader)this.target, columnName);
        return new JPopupMenuFixture(this.robot, popupMenu);
    }

    public JPopupMenuFixture showPopupMenuAt(Pattern columnNamePattern) {
        JPopupMenu popupMenu = this.driver.showPopupMenu((JTableHeader)this.target, columnNamePattern);
        return new JPopupMenuFixture(this.robot, popupMenu);
    }

    public JTableHeaderFixture clickColumn(int index, MouseClickInfo mouseClickInfo) {
        this.validateNotNull(mouseClickInfo);
        this.driver.clickColumn((JTableHeader)this.target, index, mouseClickInfo.button(), mouseClickInfo.times());
        return this;
    }

    public JTableHeaderFixture clickColumn(String columnName) {
        this.driver.clickColumn((JTableHeader)this.target, columnName);
        return this;
    }

    public JTableHeaderFixture clickColumn(Pattern columnNamePattern) {
        this.driver.clickColumn((JTableHeader)this.target, columnNamePattern);
        return this;
    }

    public JTableHeaderFixture clickColumn(String columnName, MouseClickInfo mouseClickInfo) {
        this.validateNotNull(mouseClickInfo);
        this.driver.clickColumn((JTableHeader)this.target, columnName, mouseClickInfo.button(), mouseClickInfo.times());
        return this;
    }

    public JTableHeaderFixture clickColumn(Pattern columnNamePattern, MouseClickInfo mouseClickInfo) {
        this.validateNotNull(mouseClickInfo);
        this.driver.clickColumn((JTableHeader)this.target, columnNamePattern, mouseClickInfo.button(), mouseClickInfo.times());
        return this;
    }

    private void validateNotNull(MouseClickInfo mouseClickInfo) {
        if (mouseClickInfo == null) {
            throw new NullPointerException("The given MouseClickInfo should not be null");
        }
    }

    @Override
    public JTableHeaderFixture requireToolTip(String expected) {
        this.driver.requireToolTip((JComponent)this.target, expected);
        return this;
    }

    @Override
    public JTableHeaderFixture requireToolTip(Pattern pattern) {
        this.driver.requireToolTip((JComponent)this.target, pattern);
        return this;
    }

    @Override
    public Object clientProperty(Object key) {
        return this.driver.clientProperty((JComponent)this.target, key);
    }
}

