/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasConstrainedValue;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SimpleKeyProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueListBox<T>
extends Composite
implements HasConstrainedValue<T>,
IsEditor<TakesValueEditor<T>> {
    private final List<T> values = new ArrayList<T>();
    private final Map<Object, Integer> valueKeyToIndex = new HashMap<Object, Integer>();
    private final Renderer<T> renderer;
    private final ProvidesKey<T> keyProvider;
    private TakesValueEditor<T> editor;
    private T value;

    public ValueListBox(Renderer<T> renderer) {
        this(renderer, new SimpleKeyProvider());
    }

    public ValueListBox(Renderer<T> renderer, ProvidesKey<T> keyProvider) {
        this.keyProvider = keyProvider;
        this.renderer = renderer;
        this.initWidget(new ListBox());
        this.getListBox().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int selectedIndex = ValueListBox.this.getListBox().getSelectedIndex();
                if (selectedIndex < 0) {
                    return;
                }
                Object newValue = ValueListBox.this.values.get(selectedIndex);
                ValueListBox.this.setValue(newValue, true);
            }
        });
    }

    @Override
    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<T> handler) {
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    @Override
    public TakesValueEditor<T> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of(this);
        }
        return this.editor;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setAcceptableValues(Collection<T> newValues) {
        this.values.clear();
        this.valueKeyToIndex.clear();
        ListBox listBox = this.getListBox();
        listBox.clear();
        for (T nextNewValue : newValues) {
            this.addValue(nextNewValue);
        }
        this.updateListBox();
    }

    @Override
    public void setValue(T value) {
        this.setValue(value, false);
    }

    @Override
    public void setValue(T value, boolean fireEvents) {
        if (value == this.value || this.value != null && this.value.equals(value)) {
            return;
        }
        T before = this.value;
        this.value = value;
        this.updateListBox();
        if (fireEvents) {
            ValueChangeEvent.fireIfNotEqual(this, before, value);
        }
    }

    private void addValue(T value) {
        Object key = this.keyProvider.getKey(value);
        if (this.valueKeyToIndex.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate value: " + value);
        }
        this.valueKeyToIndex.put(key, this.values.size());
        this.values.add(value);
        this.getListBox().addItem(this.renderer.render(value));
        assert (this.values.size() == this.getListBox().getItemCount());
    }

    private ListBox getListBox() {
        return (ListBox)this.getWidget();
    }

    private void updateListBox() {
        Object key = this.keyProvider.getKey(this.value);
        Integer index = this.valueKeyToIndex.get(key);
        if (index == null) {
            this.addValue(this.value);
        }
        index = this.valueKeyToIndex.get(key);
        this.getListBox().setSelectedIndex(index);
    }
}

