/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright 2014 Freescale Semiconductor, Inc.
 * Copyright 2019 NXP
 */

#ifndef __CONFIG_H
#define __CONFIG_H

#define CFG_SYS_INIT_RAM_ADDR	OCRAM_BASE_ADDR
#define CFG_SYS_INIT_RAM_SIZE	OCRAM_SIZE

#ifdef CONFIG_NAND_BOOT
#define CFG_SYS_NAND_U_BOOT_SIZE	(400 << 10)
#define CFG_SYS_NAND_U_BOOT_DST	CONFIG_TEXT_BASE
#define CFG_SYS_NAND_U_BOOT_START	CONFIG_TEXT_BASE

#endif

#define SPD_EEPROM_ADDRESS		0x51

#define CFG_SYS_DDR_SDRAM_BASE	0x80000000UL
#define CFG_SYS_SDRAM_BASE		CFG_SYS_DDR_SDRAM_BASE

/*
 * IFC Definitions
 */
#if !defined(CONFIG_QSPI_BOOT) && !defined(CONFIG_SD_BOOT_QSPI)
#define CFG_SYS_FLASH_BASE		0x60000000
#define CFG_SYS_FLASH_BASE_PHYS	CFG_SYS_FLASH_BASE

#define CFG_SYS_NOR0_CSPR_EXT	(0x0)
#define CFG_SYS_NOR0_CSPR	(CSPR_PHYS_ADDR(CFG_SYS_FLASH_BASE_PHYS) | \
				CSPR_PORT_SIZE_16 | \
				CSPR_MSEL_NOR | \
				CSPR_V)
#define CFG_SYS_NOR1_CSPR_EXT	(0x0)
#define CFG_SYS_NOR1_CSPR	(CSPR_PHYS_ADDR(CFG_SYS_FLASH_BASE_PHYS \
				+ 0x8000000) | \
				CSPR_PORT_SIZE_16 | \
				CSPR_MSEL_NOR | \
				CSPR_V)
#define CFG_SYS_NOR_AMASK		IFC_AMASK(128 * 1024 * 1024)

#define CFG_SYS_NOR_CSOR		(CSOR_NOR_ADM_SHIFT(4) | \
					CSOR_NOR_TRHZ_80)
#define CFG_SYS_NOR_FTIM0		(FTIM0_NOR_TACSE(0x4) | \
					FTIM0_NOR_TEADC(0x5) | \
					FTIM0_NOR_TEAHC(0x5))
#define CFG_SYS_NOR_FTIM1		(FTIM1_NOR_TACO(0x35) | \
					FTIM1_NOR_TRAD_NOR(0x1a) | \
					FTIM1_NOR_TSEQRAD_NOR(0x13))
#define CFG_SYS_NOR_FTIM2		(FTIM2_NOR_TCS(0x4) | \
					FTIM2_NOR_TCH(0x4) | \
					FTIM2_NOR_TWPH(0xe) | \
					FTIM2_NOR_TWP(0x1c))
#define CFG_SYS_NOR_FTIM3		0

#define CFG_SYS_WRITE_SWAPPED_DATA

#define CFG_SYS_FLASH_BANKS_LIST	{CFG_SYS_FLASH_BASE_PHYS, \
					CFG_SYS_FLASH_BASE_PHYS + 0x8000000}

/*
 * NAND Flash Definitions
 */

#define CFG_SYS_NAND_BASE		0x7e800000
#define CFG_SYS_NAND_BASE_PHYS	CFG_SYS_NAND_BASE

#define CFG_SYS_NAND_CSPR_EXT	(0x0)

#define CFG_SYS_NAND_CSPR	(CSPR_PHYS_ADDR(CFG_SYS_NAND_BASE_PHYS) \
				| CSPR_PORT_SIZE_8	\
				| CSPR_MSEL_NAND	\
				| CSPR_V)
#define CFG_SYS_NAND_AMASK	IFC_AMASK(64*1024)
#define CFG_SYS_NAND_CSOR	(CSOR_NAND_ECC_ENC_EN	/* ECC on encode */ \
				| CSOR_NAND_ECC_DEC_EN	/* ECC on decode */ \
				| CSOR_NAND_ECC_MODE_4	/* 4-bit ECC */ \
				| CSOR_NAND_RAL_3	/* RAL = 3 Bytes */ \
				| CSOR_NAND_PGS_2K	/* Page Size = 2K */ \
				| CSOR_NAND_SPRZ_64	/* Spare size = 64 */ \
				| CSOR_NAND_PB(64))	/* 64 Pages Per Block */

#define CFG_SYS_NAND_FTIM0		(FTIM0_NAND_TCCST(0x7) | \
					FTIM0_NAND_TWP(0x18)   | \
					FTIM0_NAND_TWCHT(0x7) | \
					FTIM0_NAND_TWH(0xa))
#define CFG_SYS_NAND_FTIM1		(FTIM1_NAND_TADLE(0x32) | \
					FTIM1_NAND_TWBE(0x39)  | \
					FTIM1_NAND_TRR(0xe)   | \
					FTIM1_NAND_TRP(0x18))
#define CFG_SYS_NAND_FTIM2		(FTIM2_NAND_TRAD(0xf) | \
					FTIM2_NAND_TREH(0xa) | \
					FTIM2_NAND_TWHRE(0x1e))
#define CFG_SYS_NAND_FTIM3           0x0

#define CFG_SYS_NAND_BASE_LIST	{ CFG_SYS_NAND_BASE }
#endif

/*
 * QIXIS Definitions
 */

#ifdef CONFIG_FSL_QIXIS
#define QIXIS_BASE			0x7fb00000
#define QIXIS_BASE_PHYS			QIXIS_BASE
#define CFG_SYS_I2C_FPGA_ADDR	0x66
#define QIXIS_LBMAP_SWITCH		6
#define QIXIS_LBMAP_MASK		0x0f
#define QIXIS_LBMAP_SHIFT		0
#define QIXIS_LBMAP_DFLTBANK		0x00
#define QIXIS_LBMAP_ALTBANK		0x04
#define QIXIS_PWR_CTL			0x21
#define QIXIS_PWR_CTL_POWEROFF		0x80
#define QIXIS_RST_CTL_RESET		0x44
#define QIXIS_RCFG_CTL_RECONFIG_IDLE	0x20
#define QIXIS_RCFG_CTL_RECONFIG_START	0x21
#define QIXIS_RCFG_CTL_WATCHDOG_ENBLE	0x08
#define QIXIS_CTL_SYS			0x5
#define QIXIS_CTL_SYS_EVTSW_MASK	0x0c
#define QIXIS_CTL_SYS_EVTSW_IRQ		0x04
#define QIXIS_RST_FORCE_3		0x45
#define QIXIS_RST_FORCE_3_PCIESLOT1	0x80
#define QIXIS_PWR_CTL2			0x21
#define QIXIS_PWR_CTL2_PCTL		0x2

#define CFG_SYS_FPGA_CSPR_EXT	(0x0)
#define CFG_SYS_FPGA_CSPR		(CSPR_PHYS_ADDR(QIXIS_BASE_PHYS) | \
					CSPR_PORT_SIZE_8 | \
					CSPR_MSEL_GPCM | \
					CSPR_V)
#define CFG_SYS_FPGA_AMASK		IFC_AMASK(64 * 1024)
#define CFG_SYS_FPGA_CSOR		(CSOR_NOR_ADM_SHIFT(4) | \
					CSOR_NOR_NOR_MODE_AVD_NOR | \
					CSOR_NOR_TRHZ_80)

/*
 * QIXIS Timing parameters for IFC GPCM
 */
#define CFG_SYS_FPGA_FTIM0		(FTIM0_GPCM_TACSE(0xe) | \
					FTIM0_GPCM_TEADC(0xe) | \
					FTIM0_GPCM_TEAHC(0xe))
#define CFG_SYS_FPGA_FTIM1		(FTIM1_GPCM_TACO(0xe) | \
					FTIM1_GPCM_TRAD(0x1f))
#define CFG_SYS_FPGA_FTIM2		(FTIM2_GPCM_TCS(0xe) | \
					FTIM2_GPCM_TCH(0xe) | \
					FTIM2_GPCM_TWP(0xf0))
#define CFG_SYS_FPGA_FTIM3		0x0
#endif

#if defined(CONFIG_NAND_BOOT)
#define CFG_SYS_CSPR0_EXT		CFG_SYS_NAND_CSPR_EXT
#define CFG_SYS_CSPR0		CFG_SYS_NAND_CSPR
#define CFG_SYS_AMASK0		CFG_SYS_NAND_AMASK
#define CFG_SYS_CSOR0		CFG_SYS_NAND_CSOR
#define CFG_SYS_CS0_FTIM0		CFG_SYS_NAND_FTIM0
#define CFG_SYS_CS0_FTIM1		CFG_SYS_NAND_FTIM1
#define CFG_SYS_CS0_FTIM2		CFG_SYS_NAND_FTIM2
#define CFG_SYS_CS0_FTIM3		CFG_SYS_NAND_FTIM3
#define CFG_SYS_CSPR1_EXT		CFG_SYS_NOR0_CSPR_EXT
#define CFG_SYS_CSPR1		CFG_SYS_NOR0_CSPR
#define CFG_SYS_AMASK1		CFG_SYS_NOR_AMASK
#define CFG_SYS_CSOR1		CFG_SYS_NOR_CSOR
#define CFG_SYS_CS1_FTIM0		CFG_SYS_NOR_FTIM0
#define CFG_SYS_CS1_FTIM1		CFG_SYS_NOR_FTIM1
#define CFG_SYS_CS1_FTIM2		CFG_SYS_NOR_FTIM2
#define CFG_SYS_CS1_FTIM3		CFG_SYS_NOR_FTIM3
#define CFG_SYS_CSPR2_EXT		CFG_SYS_NOR1_CSPR_EXT
#define CFG_SYS_CSPR2		CFG_SYS_NOR1_CSPR
#define CFG_SYS_AMASK2		CFG_SYS_NOR_AMASK
#define CFG_SYS_CSOR2		CFG_SYS_NOR_CSOR
#define CFG_SYS_CS2_FTIM0		CFG_SYS_NOR_FTIM0
#define CFG_SYS_CS2_FTIM1		CFG_SYS_NOR_FTIM1
#define CFG_SYS_CS2_FTIM2		CFG_SYS_NOR_FTIM2
#define CFG_SYS_CS2_FTIM3		CFG_SYS_NOR_FTIM3
#define CFG_SYS_CSPR3_EXT		CFG_SYS_FPGA_CSPR_EXT
#define CFG_SYS_CSPR3		CFG_SYS_FPGA_CSPR
#define CFG_SYS_AMASK3		CFG_SYS_FPGA_AMASK
#define CFG_SYS_CSOR3		CFG_SYS_FPGA_CSOR
#define CFG_SYS_CS3_FTIM0		CFG_SYS_FPGA_FTIM0
#define CFG_SYS_CS3_FTIM1		CFG_SYS_FPGA_FTIM1
#define CFG_SYS_CS3_FTIM2		CFG_SYS_FPGA_FTIM2
#define CFG_SYS_CS3_FTIM3		CFG_SYS_FPGA_FTIM3
#else
#define CFG_SYS_CSPR0_EXT		CFG_SYS_NOR0_CSPR_EXT
#define CFG_SYS_CSPR0		CFG_SYS_NOR0_CSPR
#define CFG_SYS_AMASK0		CFG_SYS_NOR_AMASK
#define CFG_SYS_CSOR0		CFG_SYS_NOR_CSOR
#define CFG_SYS_CS0_FTIM0		CFG_SYS_NOR_FTIM0
#define CFG_SYS_CS0_FTIM1		CFG_SYS_NOR_FTIM1
#define CFG_SYS_CS0_FTIM2		CFG_SYS_NOR_FTIM2
#define CFG_SYS_CS0_FTIM3		CFG_SYS_NOR_FTIM3
#define CFG_SYS_CSPR1_EXT		CFG_SYS_NOR1_CSPR_EXT
#define CFG_SYS_CSPR1		CFG_SYS_NOR1_CSPR
#define CFG_SYS_AMASK1		CFG_SYS_NOR_AMASK
#define CFG_SYS_CSOR1		CFG_SYS_NOR_CSOR
#define CFG_SYS_CS1_FTIM0		CFG_SYS_NOR_FTIM0
#define CFG_SYS_CS1_FTIM1		CFG_SYS_NOR_FTIM1
#define CFG_SYS_CS1_FTIM2		CFG_SYS_NOR_FTIM2
#define CFG_SYS_CS1_FTIM3		CFG_SYS_NOR_FTIM3
#define CFG_SYS_CSPR2_EXT		CFG_SYS_NAND_CSPR_EXT
#define CFG_SYS_CSPR2		CFG_SYS_NAND_CSPR
#define CFG_SYS_AMASK2		CFG_SYS_NAND_AMASK
#define CFG_SYS_CSOR2		CFG_SYS_NAND_CSOR
#define CFG_SYS_CS2_FTIM0		CFG_SYS_NAND_FTIM0
#define CFG_SYS_CS2_FTIM1		CFG_SYS_NAND_FTIM1
#define CFG_SYS_CS2_FTIM2		CFG_SYS_NAND_FTIM2
#define CFG_SYS_CS2_FTIM3		CFG_SYS_NAND_FTIM3
#define CFG_SYS_CSPR3_EXT		CFG_SYS_FPGA_CSPR_EXT
#define CFG_SYS_CSPR3		CFG_SYS_FPGA_CSPR
#define CFG_SYS_AMASK3		CFG_SYS_FPGA_AMASK
#define CFG_SYS_CSOR3		CFG_SYS_FPGA_CSOR
#define CFG_SYS_CS3_FTIM0		CFG_SYS_FPGA_FTIM0
#define CFG_SYS_CS3_FTIM1		CFG_SYS_FPGA_FTIM1
#define CFG_SYS_CS3_FTIM2		CFG_SYS_FPGA_FTIM2
#define CFG_SYS_CS3_FTIM3		CFG_SYS_FPGA_FTIM3
#endif

/*
 * Serial Port
 */
#ifndef CONFIG_LPUART
#define CFG_SYS_NS16550_CLK		get_serial_clock()
#endif

/*
 * I2C
 */

/* GPIO */

/*
 * I2C bus multiplexer
 */
#define I2C_MUX_PCA_ADDR_PRI		0x77
#define I2C_MUX_CH_DEFAULT		0x8
#define I2C_MUX_CH_CH7301		0xC

/*
 * MMC
 */

#define CFG_SMP_PEN_ADDR		0x01ee0200

#define HWCONFIG_BUFFER_SIZE		256

#ifdef CONFIG_LPUART
#define CFG_EXTRA_ENV_SETTINGS       \
	"bootargs=root=/dev/ram0 rw console=ttyLP0,115200\0" \
	"initrd_high=0xffffffff\0"      \
	"hwconfig=fsl_ddr:ctlr_intlv=null,bank_intlv=null\0"
#else
#define CFG_EXTRA_ENV_SETTINGS	\
	"bootargs=root=/dev/ram0 rw console=ttyS0,115200\0" \
	"initrd_high=0xffffffff\0"      \
	"hwconfig=fsl_ddr:ctlr_intlv=null,bank_intlv=null\0"
#endif

/*
 * Miscellaneous configurable options
 */
#define CFG_SYS_BOOTMAPSZ		(256 << 20)

/*
 * Environment
 */

#include <asm/fsl_secure_boot.h>

#endif
