/* VideoSupport.c generated by valac 0.36.6, the Vala compiler
 * generated from VideoSupport.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>
#include <signal.h>
#include <sys/types.h>
#include <gio/gunixinputstream.h>
#include <sys/wait.h>
#include <glib/gstdio.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_VIDEO_IMPORT_PARAMS (video_import_params_get_type ())
#define VIDEO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParams))
#define VIDEO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParamsClass))
#define IS_VIDEO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_IMPORT_PARAMS))
#define IS_VIDEO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_IMPORT_PARAMS))
#define VIDEO_IMPORT_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParamsClass))

typedef struct _VideoImportParams VideoImportParams;
typedef struct _VideoImportParamsClass VideoImportParamsClass;
typedef struct _VideoImportParamsPrivate VideoImportParamsPrivate;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_THUMBNAILS (thumbnails_get_type ())
#define THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAILS, Thumbnails))
#define THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAILS, ThumbnailsClass))
#define IS_THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAILS))
#define IS_THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAILS))
#define THUMBNAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAILS, ThumbnailsClass))

typedef struct _Thumbnails Thumbnails;
typedef struct _ThumbnailsClass ThumbnailsClass;

#define TYPE_VIDEO_ROW (video_row_get_type ())
#define VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_ROW, VideoRow))
#define VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_ROW, VideoRowClass))
#define IS_VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_ROW))
#define IS_VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_ROW))
#define VIDEO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_ROW, VideoRowClass))

typedef struct _VideoRow VideoRow;
typedef struct _VideoRowClass VideoRowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _thumbnails_unref0(var) ((var == NULL) ? NULL : (var = (thumbnails_unref (var), NULL)))
#define _video_row_unref0(var) ((var == NULL) ? NULL : (var = (video_row_unref (var), NULL)))
typedef struct _ParamSpecVideoImportParams ParamSpecVideoImportParams;

#define TYPE_VIDEO_READER (video_reader_get_type ())
#define VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_READER, VideoReader))
#define VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_READER, VideoReaderClass))
#define IS_VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_READER))
#define IS_VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_READER))
#define VIDEO_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_READER, VideoReaderClass))

typedef struct _VideoReader VideoReader;
typedef struct _VideoReaderClass VideoReaderClass;
typedef struct _VideoReaderPrivate VideoReaderPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_IMPORT_RESULT (import_result_get_type ())
#define _video_reader_unref0(var) ((var == NULL) ? NULL : (var = (video_reader_unref (var), NULL)))

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_VIDEO_METADATA (video_metadata_get_type ())
#define VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_METADATA, VideoMetadata))
#define VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_METADATA, VideoMetadataClass))
#define IS_VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_METADATA))
#define IS_VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_METADATA))
#define VIDEO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_METADATA, VideoMetadataClass))

typedef struct _VideoMetadata VideoMetadata;
typedef struct _VideoMetadataClass VideoMetadataClass;

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
typedef struct _VideoRowPrivate VideoRowPrivate;

#define TYPE_VIDEO_ID (video_id_get_type ())
typedef struct _VideoID VideoID;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_RATING (rating_get_type ())
typedef struct _ParamSpecVideoReader ParamSpecVideoReader;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef struct _ThumbnailSourcePrivate ThumbnailSourcePrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef struct _MediaSourcePrivate MediaSourcePrivate;

#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;
typedef struct _VideoSourcePrivate VideoSourcePrivate;

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;

#define TYPE_DATEABLE (dateable_get_type ())
#define DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATEABLE, Dateable))
#define IS_DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATEABLE))
#define DATEABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATEABLE, DateableIface))

typedef struct _Dateable Dateable;
typedef struct _DateableIface DateableIface;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
typedef struct _VideoPrivate VideoPrivate;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define TYPE_VIDEO_SOURCE_COLLECTION (video_source_collection_get_type ())
#define VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection))
#define VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))
#define IS_VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE_COLLECTION))
#define IS_VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE_COLLECTION))
#define VIDEO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))

typedef struct _VideoSourceCollection VideoSourceCollection;
typedef struct _VideoSourceCollectionClass VideoSourceCollectionClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_VIDEO_TABLE (video_table_get_type ())
#define VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_TABLE, VideoTable))
#define VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_TABLE, VideoTableClass))
#define IS_VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_TABLE))
#define IS_VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_TABLE))
#define VIDEO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_TABLE, VideoTableClass))

typedef struct _VideoTable VideoTable;
typedef struct _VideoTableClass VideoTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_EXPORTER (exporter_get_type ())
#define EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER, Exporter))
#define EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER, ExporterClass))
#define IS_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER))
#define IS_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER))
#define EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER, ExporterClass))

typedef struct _Exporter Exporter;
typedef struct _ExporterClass ExporterClass;

#define TYPE_EXPORTER_UI (exporter_ui_get_type ())
#define EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER_UI, ExporterUI))
#define EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER_UI, ExporterUIClass))
#define IS_EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER_UI))
#define IS_EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER_UI))
#define EXPORTER_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER_UI, ExporterUIClass))

typedef struct _ExporterUI ExporterUI;
typedef struct _ExporterUIClass ExporterUIClass;

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;
#define _exporter_ui_unref0(var) ((var == NULL) ? NULL : (var = (exporter_ui_unref (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
#define _backing_file_state_unref0(var) ((var == NULL) ? NULL : (var = (backing_file_state_unref (var), NULL)))

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))

#define VIDEO_TYPE_INTERPRETABLE_RESULTS (video_interpretable_results_get_type ())
#define VIDEO_INTERPRETABLE_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResults))
#define VIDEO_INTERPRETABLE_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResultsClass))
#define VIDEO_IS_INTERPRETABLE_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS))
#define VIDEO_IS_INTERPRETABLE_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIDEO_TYPE_INTERPRETABLE_RESULTS))
#define VIDEO_INTERPRETABLE_RESULTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResultsClass))

typedef struct _VideoInterpretableResults VideoInterpretableResults;
typedef struct _VideoInterpretableResultsClass VideoInterpretableResultsClass;
#define _video_interpretable_results_unref0(var) ((var == NULL) ? NULL : (var = (video_interpretable_results_unref (var), NULL)))
typedef struct _VideoInterpretableResultsPrivate VideoInterpretableResultsPrivate;
typedef struct _VideoParamSpecInterpretableResults VideoParamSpecInterpretableResults;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;
typedef struct _MediaSourceCollectionPrivate MediaSourceCollectionPrivate;

#define TYPE_DATABASE_SOURCE_HOLDING_TANK (database_source_holding_tank_get_type ())
#define DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank))
#define DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))
#define IS_DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define IS_DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define DATABASE_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))

typedef struct _DatabaseSourceHoldingTank DatabaseSourceHoldingTank;
typedef struct _DatabaseSourceHoldingTankClass DatabaseSourceHoldingTankClass;

#define TYPE_MEDIA_SOURCE_HOLDING_TANK (media_source_holding_tank_get_type ())
#define MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank))
#define MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))
#define IS_MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define IS_MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define MEDIA_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))

typedef struct _MediaSourceHoldingTank MediaSourceHoldingTank;
typedef struct _MediaSourceHoldingTankClass MediaSourceHoldingTankClass;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;
typedef struct _VideoSourceCollectionPrivate VideoSourceCollectionPrivate;

#define VIDEO_SOURCE_COLLECTION_TYPE_STATE (video_source_collection_state_get_type ())
#define _transaction_controller_unref0(var) ((var == NULL) ? NULL : (var = (transaction_controller_unref (var), NULL)))
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))

#define TYPE_VIDEO_MONITOR (video_monitor_get_type ())
#define VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_MONITOR, VideoMonitor))
#define VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_MONITOR, VideoMonitorClass))
#define IS_VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_MONITOR))
#define IS_VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_MONITOR))
#define VIDEO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_MONITOR, VideoMonitorClass))

typedef struct _VideoMonitor VideoMonitor;
typedef struct _VideoMonitorClass VideoMonitorClass;

#define TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER (media_source_transaction_controller_get_type ())
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))

typedef struct _MediaSourceTransactionController MediaSourceTransactionController;
typedef struct _MediaSourceTransactionControllerClass MediaSourceTransactionControllerClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	VIDEO_ERROR_FILE,
	VIDEO_ERROR_CONTENTS
} VideoError;
#define VIDEO_ERROR video_error_quark ()
struct _ImportID {
	gint64 id;
};

struct _VideoImportParams {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoImportParamsPrivate * priv;
	GFile* file;
	ImportID import_id;
	gchar* md5;
	time_t exposure_time_override;
	Thumbnails* thumbnails;
	VideoRow* row;
};

struct _VideoImportParamsClass {
	GTypeClass parent_class;
	void (*finalize) (VideoImportParams *self);
};

struct _ParamSpecVideoImportParams {
	GParamSpec parent_instance;
};

struct _VideoReader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoReaderPrivate * priv;
};

struct _VideoReaderClass {
	GTypeClass parent_class;
	void (*finalize) (VideoReader *self);
};

struct _VideoReaderPrivate {
	gdouble clip_duration;
	GdkPixbuf* preview_frame;
	GFile* file;
	GPid thumbnailer_pid;
	GDateTime* _timestamp;
};

typedef enum  {
	IMPORT_RESULT_SUCCESS,
	IMPORT_RESULT_FILE_ERROR,
	IMPORT_RESULT_DECODE_ERROR,
	IMPORT_RESULT_DATABASE_ERROR,
	IMPORT_RESULT_USER_ABORT,
	IMPORT_RESULT_NOT_A_FILE,
	IMPORT_RESULT_PHOTO_EXISTS,
	IMPORT_RESULT_UNSUPPORTED_FORMAT,
	IMPORT_RESULT_NOT_AN_IMAGE,
	IMPORT_RESULT_DISK_FAILURE,
	IMPORT_RESULT_DISK_FULL,
	IMPORT_RESULT_CAMERA_ERROR,
	IMPORT_RESULT_FILE_WRITE_ERROR,
	IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE
} ImportResult;

struct _VideoID {
	gint64 id;
};

struct _EventID {
	gint64 id;
};

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _VideoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoRowPrivate * priv;
	VideoID video_id;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	gint width;
	gint height;
	gdouble clip_duration;
	gboolean is_interpretable;
	time_t exposure_time;
	ImportID import_id;
	EventID event_id;
	gchar* md5;
	time_t time_created;
	Rating rating;
	gchar* title;
	gchar* backlinks;
	time_t time_reimported;
	guint64 flags;
	gchar* comment;
};

struct _VideoRowClass {
	GTypeClass parent_class;
	void (*finalize) (VideoRow *self);
};

struct _ParamSpecVideoReader {
	GParamSpec parent_instance;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _ThumbnailSource {
	DataSource parent_instance;
	ThumbnailSourcePrivate * priv;
};

struct _ThumbnailSourceClass {
	DataSourceClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailSource* self);
	GdkPixbuf* (*get_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	GdkPixbuf* (*create_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	gchar* (*get_representative_id) (ThumbnailSource* self);
	PhotoFileFormat (*get_preferred_thumbnail_format) (ThumbnailSource* self);
	void (*thumbnail_altered) (ThumbnailSource* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _MediaSource {
	ThumbnailSource parent_instance;
	MediaSourcePrivate * priv;
};

struct _MediaSourceClass {
	ThumbnailSourceClass parent_class;
	void (*notify_master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
	gboolean (*set_event_id) (MediaSource* self, EventID* id);
	gchar* (*get_basename) (MediaSource* self);
	GFile* (*get_file) (MediaSource* self);
	GFile* (*get_master_file) (MediaSource* self);
	guint64 (*get_master_filesize) (MediaSource* self);
	guint64 (*get_filesize) (MediaSource* self);
	time_t (*get_timestamp) (MediaSource* self);
	BackingFileState** (*get_backing_files_state) (MediaSource* self, int* result_length1);
	gchar* (*get_title) (MediaSource* self);
	gchar* (*get_comment) (MediaSource* self);
	void (*set_title) (MediaSource* self, const gchar* title);
	gboolean (*set_comment) (MediaSource* self, const gchar* comment);
	Rating (*get_rating) (MediaSource* self);
	void (*set_rating) (MediaSource* self, Rating rating);
	void (*increase_rating) (MediaSource* self);
	void (*decrease_rating) (MediaSource* self);
	void (*get_dimensions) (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
	GdkPixbuf* (*get_preview_pixbuf) (MediaSource* self, Scaling* scaling, GError** error);
	gboolean (*is_trashed) (MediaSource* self);
	void (*trash) (MediaSource* self);
	void (*untrash) (MediaSource* self);
	gboolean (*is_offline) (MediaSource* self);
	void (*mark_offline) (MediaSource* self);
	void (*mark_online) (MediaSource* self);
	gchar* (*get_master_md5) (MediaSource* self);
	void (*get_event_id) (MediaSource* self, EventID* result);
	time_t (*get_exposure_time) (MediaSource* self);
	void (*get_import_id) (MediaSource* self, ImportID* result);
	void (*master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
};

struct _VideoSource {
	MediaSource parent_instance;
	VideoSourcePrivate * priv;
};

struct _VideoSourceClass {
	MediaSourceClass parent_class;
};

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _DateableIface {
	GTypeInterface parent_iface;
	void (*set_exposure_time) (Dateable* self, time_t target_time);
	time_t (*get_exposure_time) (Dateable* self);
};

struct _Video {
	VideoSource parent_instance;
	VideoPrivate * priv;
};

struct _VideoClass {
	VideoSourceClass parent_class;
};

struct _VideoPrivate {
	VideoRow* backing_row;
	GRecMutex __lock_backing_row;
};

typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
typedef void (*ExporterCompletionCallback) (Exporter* exporter, gboolean is_cancelled, void* user_data);
typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 360,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

struct _VideoInterpretableResults {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoInterpretableResultsPrivate * priv;
	Video* video;
	gboolean update_interpretable;
	gboolean is_interpretable;
	GdkPixbuf* new_thumbnail;
};

struct _VideoInterpretableResultsClass {
	GTypeClass parent_class;
	void (*finalize) (VideoInterpretableResults *self);
};

struct _VideoParamSpecInterpretableResults {
	GParamSpec parent_instance;
};

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _MediaSourceCollection {
	DatabaseSourceCollection parent_instance;
	MediaSourceCollectionPrivate * priv;
};

struct _MediaSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
	MediaSourceHoldingTank* (*create_trashcan) (MediaSourceCollection* self);
	MediaSourceHoldingTank* (*create_offline_bin) (MediaSourceCollection* self);
	MediaMonitor* (*create_media_monitor) (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable);
	gchar* (*get_typename) (MediaSourceCollection* self);
	gboolean (*is_file_recognized) (MediaSourceCollection* self, GFile* file);
	MediaSource* (*fetch_by_numeric_id) (MediaSourceCollection* self, gint64 numeric_id);
	void (*notify_import_roll_altered) (MediaSourceCollection* self);
	void (*notify_flagged_contents_altered) (MediaSourceCollection* self);
	void (*notify_media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*notify_media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	MediaSource* (*fetch_by_source_id) (MediaSourceCollection* self, const gchar* source_id);
	GeeCollection* (*get_event_source_ids) (MediaSourceCollection* self, EventID* event_id);
	void (*import_many) (MediaSourceCollection* self, GeeCollection* media);
	void (*postprocess_imported_media) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	void (*master_file_replaced) (MediaSourceCollection* self, MediaSource* media, GFile* old_file, GFile* new_file);
	void (*trashcan_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*import_roll_altered) (MediaSourceCollection* self);
	void (*offline_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*flagged_contents_altered) (MediaSourceCollection* self);
	TransactionController* (*get_transaction_controller) (MediaSourceCollection* self);
};

struct _VideoSourceCollection {
	MediaSourceCollection parent_instance;
	VideoSourceCollectionPrivate * priv;
};

struct _VideoSourceCollectionClass {
	MediaSourceCollectionClass parent_class;
};

struct _VideoSourceCollectionPrivate {
	TransactionController* _transaction_controller;
	GeeMultiMap* filesize_to_video;
};

typedef enum  {
	VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN,
	VIDEO_SOURCE_COLLECTION_STATE_ONLINE,
	VIDEO_SOURCE_COLLECTION_STATE_OFFLINE,
	VIDEO_SOURCE_COLLECTION_STATE_TRASH
} VideoSourceCollectionState;

typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, void* user_data);
typedef gboolean (*SourceHoldingTankCheckToKeep) (DataSource* source, Alteration* alteration, void* user_data);

static gpointer video_import_params_parent_class = NULL;
static gpointer video_reader_parent_class = NULL;
static gpointer video_parent_class = NULL;
static gboolean video_interpreter_state_changed;
static gboolean video_interpreter_state_changed = FALSE;
static gint video_current_state;
static gint video_current_state = 0;
static gboolean video_normal_regen_complete;
static gboolean video_normal_regen_complete = FALSE;
static gboolean video_offline_regen_complete;
static gboolean video_offline_regen_complete = FALSE;
extern VideoSourceCollection* video_global;
VideoSourceCollection* video_global = NULL;
static gpointer video_interpretable_results_parent_class = NULL;
static FlaggableIface * video_flaggable_parent_iface = NULL;
static MonitorableIface * video_monitorable_parent_iface = NULL;
static DateableIface * video_dateable_parent_iface = NULL;
static gpointer video_source_collection_parent_class = NULL;

GQuark video_error_quark (void);
gpointer video_import_params_ref (gpointer instance);
void video_import_params_unref (gpointer instance);
GParamSpec* param_spec_video_import_params (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_video_import_params (GValue* value, gpointer v_object);
void value_take_video_import_params (GValue* value, gpointer v_object);
gpointer value_get_video_import_params (const GValue* value);
GType video_import_params_get_type (void) G_GNUC_CONST;
GType import_id_get_type (void) G_GNUC_CONST;
ImportID* import_id_dup (const ImportID* self);
void import_id_free (ImportID* self);
gpointer thumbnails_ref (gpointer instance);
void thumbnails_unref (gpointer instance);
GParamSpec* param_spec_thumbnails (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_thumbnails (GValue* value, gpointer v_object);
void value_take_thumbnails (GValue* value, gpointer v_object);
gpointer value_get_thumbnails (const GValue* value);
GType thumbnails_get_type (void) G_GNUC_CONST;
gpointer video_row_ref (gpointer instance);
void video_row_unref (gpointer instance);
GParamSpec* param_spec_video_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_video_row (GValue* value, gpointer v_object);
void value_take_video_row (GValue* value, gpointer v_object);
gpointer value_get_video_row (const GValue* value);
GType video_row_get_type (void) G_GNUC_CONST;
enum  {
	VIDEO_IMPORT_PARAMS_DUMMY_PROPERTY
};
#define IMPORT_ID_INVALID ((gint64) 0)
void import_id_init (ImportID *self, gint64 id);
VideoRow* video_row_new (void);
VideoRow* video_row_construct (GType object_type);
VideoImportParams* video_import_params_new (GFile* file, ImportID* import_id, const gchar* md5, Thumbnails* thumbnails, time_t exposure_time_override);
VideoImportParams* video_import_params_construct (GType object_type, GFile* file, ImportID* import_id, const gchar* md5, Thumbnails* thumbnails, time_t exposure_time_override);
static void video_import_params_finalize (VideoImportParams * obj);
gpointer video_reader_ref (gpointer instance);
void video_reader_unref (gpointer instance);
GParamSpec* param_spec_video_reader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_video_reader (GValue* value, gpointer v_object);
void value_take_video_reader (GValue* value, gpointer v_object);
gpointer value_get_video_reader (const GValue* value);
GType video_reader_get_type (void) G_GNUC_CONST;
#define VIDEO_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VIDEO_READER, VideoReaderPrivate))
enum  {
	VIDEO_READER_DUMMY_PROPERTY
};
#define VIDEO_READER_UNKNOWN_CLIP_DURATION (-1.0)
#define VIDEO_READER_THUMBNAILER_TIMEOUT ((guint) 10000)
VideoReader* video_reader_new (GFile* file);
VideoReader* video_reader_construct (GType object_type, GFile* file);
gboolean video_reader_is_supported_video_file (GFile* file);
gboolean video_reader_is_supported_video_filename (const gchar* filename);
void disassemble_filename (const gchar* basename, gchar* * name, gchar* * ext);
gint utf8_ci_compare (void* a, void* b);
GType import_result_get_type (void) G_GNUC_CONST;
ImportResult video_reader_prepare_for_import (VideoImportParams* params);
#define UTIL_FILE_ATTRIBUTES "standard::*,time::*,id::file,id::filesystem,etag::value"
#define DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES UTIL_FILE_ATTRIBUTES
GdkPixbuf* video_reader_read_preview_frame (VideoReader* self);
gdouble video_reader_read_clip_duration (VideoReader* self, GError** error);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType video_metadata_get_type (void) G_GNUC_CONST;
VideoMetadata* video_reader_read_metadata (VideoReader* self, GError** error);
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_metadata_date_time (GValue* value, gpointer v_object);
void value_take_metadata_date_time (GValue* value, gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
MetadataDateTime* media_metadata_get_creation_date_time (MediaMetadata* self);
time_t metadata_date_time_get_timestamp (MetadataDateTime* self);
gchar* media_metadata_get_title (MediaMetadata* self);
gchar* media_metadata_get_comment (MediaMetadata* self);
GDateTime* video_reader_get_timestamp (VideoReader* self);
GType video_id_get_type (void) G_GNUC_CONST;
VideoID* video_id_dup (const VideoID* self);
void video_id_free (VideoID* self);
GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
GType rating_get_type (void) G_GNUC_CONST;
#define VIDEO_ID_INVALID ((gint64) -1)
void video_id_init (VideoID *self, gint64 id);
#define EVENT_ID_INVALID ((gint64) -1)
void event_id_init (EventID *self, gint64 id);
Thumbnails* thumbnails_new (void);
Thumbnails* thumbnails_construct (GType object_type);
void thumbnail_cache_generate_for_video_frame (Thumbnails* thumbnails, GdkPixbuf* preview_frame);
static void video_reader_read_internal (VideoReader* self, GError** error);
static gboolean video_reader_does_file_exist (VideoReader* self);
static GDate* _g_date_dup (GDate* self);
static void video_reader_set_timestamp (VideoReader* self, GDateTime* value);
static gboolean video_reader_on_thumbnailer_timer (VideoReader* self);
static GdkPixbuf* video_reader_thumbnailer (VideoReader* self, const gchar* video_file);
GFile* app_dirs_get_thumbnailer_bin (void);
static gboolean _video_reader_on_thumbnailer_timer_gsource_func (gpointer self);
GdkPixbuf* resources_get_noninterpretable_badge_pixbuf (void);
VideoMetadata* video_metadata_new (void);
VideoMetadata* video_metadata_construct (GType object_type);
void media_metadata_read_from_file (MediaMetadata* self, GFile* file, GError** error);
static void video_reader_finalize (VideoReader * obj);
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_holding_tank (GValue* value, gpointer v_object);
void value_take_source_holding_tank (GValue* value, gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
gpointer source_snapshot_ref (gpointer instance);
void source_snapshot_unref (gpointer instance);
GParamSpec* param_spec_source_snapshot (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_snapshot (GValue* value, gpointer v_object);
void value_take_source_snapshot (GValue* value, gpointer v_object);
gpointer value_get_source_snapshot (const GValue* value);
GType source_snapshot_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType indexable_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
gpointer backing_file_state_ref (gpointer instance);
void backing_file_state_unref (gpointer instance);
GParamSpec* param_spec_backing_file_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_file_state (GValue* value, gpointer v_object);
void value_take_backing_file_state (GValue* value, gpointer v_object);
gpointer value_get_backing_file_state (const GValue* value);
GType backing_file_state_get_type (void) G_GNUC_CONST;
GType photo_exception_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
GType video_source_get_type (void) G_GNUC_CONST;
GType flaggable_get_type (void) G_GNUC_CONST;
GType monitorable_get_type (void) G_GNUC_CONST;
GType dateable_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
#define VIDEO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VIDEO, VideoPrivate))
enum  {
	VIDEO_DUMMY_PROPERTY
};
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType media_source_collection_get_type (void) G_GNUC_CONST;
GType video_source_collection_get_type (void) G_GNUC_CONST;
#define VIDEO_TYPENAME "video"
#define VIDEO_FLAG_TRASH ((guint64) 0x0000000000000001)
#define VIDEO_FLAG_OFFLINE ((guint64) 0x0000000000000002)
#define VIDEO_FLAG_FLAGGED ((guint64) 0x0000000000000004)
Video* video_new (VideoRow* row);
Video* video_construct (GType object_type, VideoRow* row);
VideoSource* video_source_construct (GType object_type);
gchar* media_source_prep_title (const gchar* title);
void data_source_rehydrate_backlinks (DataSource* self, SourceCollection* unlinked_from, const gchar* dehydrated);
void video_init (ProgressMonitor monitor, void* monitor_target);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gint configuration_facade_get_video_interpreter_state_cookie (ConfigurationFacade* self);
#define CONFIG_FACADE_NO_VIDEO_INTERPRETER_STATE -1
static gboolean __lambda12_ (GstPluginFeature* f);
static gboolean ___lambda12__gst_plugin_feature_filter (GstPluginFeature* feature, gpointer self);
VideoSourceCollection* video_source_collection_new (void);
VideoSourceCollection* video_source_collection_construct (GType object_type);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType video_table_get_type (void) G_GNUC_CONST;
VideoTable* video_table_get_instance (void);
GeeArrayList* video_table_get_all (VideoTable* self);
static void video_set_is_interpretable (Video* self, gboolean is_interpretable);
gboolean media_source_is_trashed (MediaSource* self);
gboolean media_source_is_offline (MediaSource* self);
void media_source_collection_add_many_to_trash (MediaSourceCollection* self, GeeCollection* sources);
void media_source_collection_add_many_to_offline (MediaSourceCollection* self, GeeCollection* sources);
GeeCollection* data_collection_add_many (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gboolean video_has_interpreter_state_changed (void);
void video_notify_normal_thumbs_regenerated (void);
static void video_save_interpreter_state (void);
void video_notify_offline_thumbs_regenerated (void);
void configuration_facade_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie);
void video_terminate (void);
GType exporter_get_type (void) G_GNUC_CONST;
gpointer exporter_ui_ref (gpointer instance);
void exporter_ui_unref (gpointer instance);
GParamSpec* param_spec_exporter_ui (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_exporter_ui (GValue* value, gpointer v_object);
void value_take_exporter_ui (GValue* value, gpointer v_object);
gpointer value_get_exporter_ui (const GValue* value);
GType exporter_ui_get_type (void) G_GNUC_CONST;
ExporterUI* video_export_many (GeeCollection* videos, ExporterCompletionCallback done, void* done_target, gboolean export_in_place);
void scaling_for_original (Scaling* result);
GType export_format_parameters_get_type (void) G_GNUC_CONST;
GType export_format_mode_get_type (void) G_GNUC_CONST;
GType jpeg_quality_get_type (void) G_GNUC_CONST;
ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
void export_format_parameters_free (ExportFormatParameters* self);
void export_format_parameters_unmodified (ExportFormatParameters* result);
Exporter* exporter_new_for_temp_file (GeeCollection* to_export, Scaling* scaling, ExportFormatParameters* export_params);
Exporter* exporter_construct_for_temp_file (GType object_type, GeeCollection* to_export, Scaling* scaling, ExportFormatParameters* export_params);
ExporterUI* exporter_ui_new (Exporter* exporter);
ExporterUI* exporter_ui_construct (GType object_type, Exporter* exporter);
void exporter_ui_export (ExporterUI* self, ExporterCompletionCallback completion_callback, void* completion_callback_target);
GFile* export_ui_choose_file (const gchar* current_file_basename);
gchar* media_source_get_basename (MediaSource* self);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
void page_window_set_busy_cursor (PageWindow* self);
void video_export (Video* self, GFile* dest_file, GError** error);
void page_window_set_normal_cursor (PageWindow* self);
GtkResponseType export_error_dialog (GFile* dest, gboolean photos_remaining);
GFile* export_ui_choose_dir (const gchar* user_title);
Exporter* exporter_new (GeeCollection* to_export, GFile* dir, Scaling* scaling, ExportFormatParameters* export_params, gboolean auto_replace_all);
Exporter* exporter_construct (GType object_type, GeeCollection* to_export, GFile* dir, Scaling* scaling, ExportFormatParameters* export_params, gboolean auto_replace_all);
static void video_real_commit_backlinks (DataSource* base, SourceCollection* sources, const gchar* backlinks);
GQuark database_error_quark (void);
void video_table_update_backlinks (VideoTable* self, VideoID* video_id, const gchar* backlinks, GError** error);
void video_get_video_id (Video* self, VideoID* result);
gchar* data_object_to_string (DataObject* self);
static gboolean video_real_set_event_id (MediaSource* base, EventID* event_id);
gboolean video_table_set_event (VideoTable* self, VideoID* video_id, EventID* event_id);
gboolean video_is_duplicate (GFile* file, const gchar* full_md5);
gboolean video_table_has_duplicate (VideoTable* self, GFile* file, const gchar* md5);
ImportResult video_import_create (VideoImportParams* params, Video* * video);
void video_table_add (VideoTable* self, VideoRow* video_row, VideoID* result, GError** error);
gboolean video_id_is_invalid (VideoID *self);
void video_import_failed (Video* video);
void video_table_remove (VideoTable* self, VideoID* videoID, GError** error);
void app_window_database_error (GError* err);
static BackingFileState** video_real_get_backing_files_state (MediaSource* base, int* result_length1);
BackingFileState* backing_file_state_new (const gchar* filepath, gint64 filesize, time_t modification_time, const gchar* md5);
BackingFileState* backing_file_state_construct (GType object_type, const gchar* filepath, gint64 filesize, time_t modification_time, const gchar* md5);
static GdkPixbuf* video_real_get_thumbnail (ThumbnailSource* base, gint scale, GError** error);
GdkPixbuf* thumbnail_cache_fetch (ThumbnailSource* source, gint scale, GError** error);
static gchar* video_real_get_master_md5 (MediaSource* base);
static GdkPixbuf* video_real_get_preview_pixbuf (MediaSource* base, Scaling* scaling, GError** error);
GdkPixbuf* thumbnail_source_get_thumbnail (ThumbnailSource* self, gint scale, GError** error);
GType thumbnail_cache_size_get_type (void) G_GNUC_CONST;
GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self, GdkPixbuf* pixbuf, GdkInterpType interp, gboolean scale_up);
static GdkPixbuf* video_real_create_thumbnail (ThumbnailSource* base, gint scale, GError** error);
GFile* media_source_get_file (MediaSource* self);
static gchar* video_real_get_typename (DataSource* base);
static gint64 video_real_get_instance_id (DataSource* base);
static void video_real_get_import_id (MediaSource* base, ImportID* result);
static PhotoFileFormat video_real_get_preferred_thumbnail_format (ThumbnailSource* base);
PhotoFileFormat photo_file_format_get_system_default_format (void);
static gchar* video_real_get_title (MediaSource* base);
static void video_real_set_title (MediaSource* base, const gchar* title);
void video_table_set_title (VideoTable* self, VideoID* video_id, const gchar* new_title, GError** error);
void data_object_notify_altered (DataObject* self, Alteration* alteration);
Alteration* alteration_new (const gchar* subject, const gchar* detail);
Alteration* alteration_construct (GType object_type, const gchar* subject, const gchar* detail);
static gchar* video_real_get_comment (MediaSource* base);
static gboolean video_real_set_comment (MediaSource* base, const gchar* comment);
void video_table_set_comment (VideoTable* self, VideoID* video_id, const gchar* new_comment, GError** error);
static Rating video_real_get_rating (MediaSource* base);
static void video_real_set_rating (MediaSource* base, Rating rating);
gboolean rating_is_valid (Rating self);
void video_table_set_rating (VideoTable* self, VideoID* video_id, Rating rating, GError** error);
static void video_real_increase_rating (MediaSource* base);
void media_source_set_rating (MediaSource* self, Rating rating);
Rating rating_increase (Rating self);
static void video_real_decrease_rating (MediaSource* base);
Rating rating_decrease (Rating self);
static gboolean video_real_is_trashed (MediaSource* base);
gboolean video_is_flag_set (Video* self, guint64 flag);
static gboolean video_real_is_offline (Monitorable* base);
static void video_real_mark_offline (Monitorable* base);
guint64 video_add_flags (Video* self, guint64 flags_to_add, Alteration* additional_alteration);
static void video_real_mark_online (Monitorable* base);
guint64 video_remove_flags (Video* self, guint64 flags_to_remove, Alteration* additional_alteration);
gboolean video_get_is_interpretable (Video* self);
gpointer video_interpretable_results_ref (gpointer instance);
void video_interpretable_results_unref (gpointer instance);
GParamSpec* video_param_spec_interpretable_results (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void video_value_set_interpretable_results (GValue* value, gpointer v_object);
void video_value_take_interpretable_results (GValue* value, gpointer v_object);
gpointer video_value_get_interpretable_results (const GValue* value);
GType video_interpretable_results_get_type (void) G_GNUC_CONST;
VideoInterpretableResults* video_check_is_interpretable (Video* self);
void video_interpretable_results_foreground_finish (VideoInterpretableResults* self);
static void video_real_trash (MediaSource* base);
static void video_real_untrash (MediaSource* base);
static gboolean video_real_is_flagged (Flaggable* base);
static void video_real_mark_flagged (Flaggable* base);
static void video_real_mark_unflagged (Flaggable* base);
static void video_real_get_event_id (MediaSource* base, EventID* result);
static gchar* video_real_to_string (DataObject* base);
static time_t video_real_get_exposure_time (Dateable* base);
static void video_real_set_exposure_time (Dateable* base, time_t time);
void video_table_set_exposure_time (VideoTable* self, VideoID* video_id, time_t time, GError** error);
void video_get_frame_dimensions (Video* self, Dimensions* result);
void dimensions_init (Dimensions *self, gint width, gint height);
static void video_real_get_dimensions (MediaSource* base, PhotoException disallowed_steps, Dimensions* result);
static guint64 video_real_get_filesize (MediaSource* base);
guint64 media_source_get_master_filesize (MediaSource* self);
static guint64 video_real_get_master_filesize (MediaSource* base);
static time_t video_real_get_timestamp (MediaSource* base);
static void video_real_set_master_timestamp (Monitorable* base, GFileInfo* info);
void video_table_set_timestamp (VideoTable* self, VideoID* video_id, time_t timestamp, GError** error);
gchar* video_get_filename (Video* self);
static GFile* video_real_get_file (MediaSource* base);
static GFile* video_real_get_master_file (MediaSource* base);
gdouble video_get_clip_duration (Video* self);
void video_table_update_is_interpretable (VideoTable* self, VideoID* video_id, gboolean is_interpretable, GError** error);
VideoInterpretableResults* video_interpretable_results_new (Video* video);
VideoInterpretableResults* video_interpretable_results_construct (GType object_type, Video* video);
static void video_real_destroy (DataSource* base);
void thumbnail_cache_remove (ThumbnailSource* source);
void data_source_destroy (DataSource* self);
static gboolean video_real_internal_delete_backing (DataSource* base, GError** error);
gboolean media_source_delete_original_file (MediaSource* self);
gboolean data_source_internal_delete_backing (DataSource* self, GError** error);
static void video_notify_flags_altered (Video* self, Alteration* additional_alteration);
Alteration* alteration_compress (Alteration* self, Alteration* other);
guint64 media_source_internal_add_flags (guint64 flags, guint64 selector);
void video_table_set_flags (VideoTable* self, VideoID* video_id, guint64 flags, GError** error);
guint64 media_source_internal_remove_flags (guint64 flags, guint64 selector);
gboolean media_source_internal_is_flag_set (guint64 flags, guint64 selector);
static void video_real_set_master_file (Monitorable* base, GFile* file);
void video_table_set_filepath (VideoTable* self, VideoID* video_id, const gchar* filepath, GError** error);
void media_source_notify_master_replaced (MediaSource* self, GFile* old_file, GFile* new_file);
Alteration* alteration_new_from_list (const gchar* list);
Alteration* alteration_construct_from_list (GType object_type, const gchar* list);
VideoMetadata* video_read_metadata (Video* self, GError** error);
enum  {
	VIDEO_INTERPRETABLE_RESULTS_DUMMY_PROPERTY
};
void thumbnail_cache_replace (ThumbnailSource* source, ThumbnailCacheSize size, GdkPixbuf* replacement, GError** error);
void thumbnail_source_notify_thumbnail_altered (ThumbnailSource* self);
static void video_interpretable_results_finalize (VideoInterpretableResults * obj);
static void video_finalize (GObject * obj);
GType marker_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_backlink (GValue* value, gpointer v_object);
void value_take_source_backlink (GValue* value, gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType database_source_holding_tank_get_type (void) G_GNUC_CONST;
GType media_source_holding_tank_get_type (void) G_GNUC_CONST;
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_workers (GValue* value, gpointer v_object);
void value_take_workers (GValue* value, gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
GType media_monitor_get_type (void) G_GNUC_CONST;
gpointer transaction_controller_ref (gpointer instance);
void transaction_controller_unref (gpointer instance);
GParamSpec* param_spec_transaction_controller (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_transaction_controller (GValue* value, gpointer v_object);
void value_take_transaction_controller (GValue* value, gpointer v_object);
gpointer value_get_transaction_controller (const GValue* value);
GType transaction_controller_get_type (void) G_GNUC_CONST;
#define VIDEO_SOURCE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionPrivate))
enum  {
	VIDEO_SOURCE_COLLECTION_DUMMY_PROPERTY
};
GType video_source_collection_state_get_type (void) G_GNUC_CONST;
gint uint64_compare (guint64* a, guint64* b);
static gint _uint64_compare_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static guint64* _uint64_dup (guint64* self);
gint64 video_source_collection_get_video_key (DataSource* source);
static gint64 _video_source_collection_get_video_key_get_source_database_key (DataSource* source, gpointer self);
MediaSourceCollection* media_source_collection_construct (GType object_type, const gchar* name, GetSourceDatabaseKey source_key_func, void* source_key_func_target);
MediaSourceHoldingTank* media_source_collection_get_trashcan (MediaSourceCollection* self);
static void video_source_collection_on_trashcan_contents_altered (VideoSourceCollection* self, GeeCollection* added, GeeCollection* removed);
static void _video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender, GeeCollection* added, GeeCollection* removed, gpointer self);
MediaSourceHoldingTank* media_source_collection_get_offline_bin (MediaSourceCollection* self);
static void video_source_collection_on_offline_contents_altered (VideoSourceCollection* self, GeeCollection* added, GeeCollection* removed);
static void _video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender, GeeCollection* added, GeeCollection* removed, gpointer self);
static MediaSourceHoldingTank* video_source_collection_real_create_trashcan (MediaSourceCollection* base);
gboolean video_source_collection_is_video_trashed (DataSource* source);
static gboolean _video_source_collection_is_video_trashed_source_holding_tank_check_to_keep (DataSource* source, Alteration* alteration, gpointer self);
MediaSourceHoldingTank* media_source_holding_tank_new (MediaSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
MediaSourceHoldingTank* media_source_holding_tank_construct (GType object_type, MediaSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
static MediaSourceHoldingTank* video_source_collection_real_create_offline_bin (MediaSourceCollection* base);
gboolean video_source_collection_is_video_offline (DataSource* source);
static gboolean _video_source_collection_is_video_offline_source_holding_tank_check_to_keep (DataSource* source, Alteration* alteration, gpointer self);
static MediaMonitor* video_source_collection_real_create_media_monitor (MediaSourceCollection* base, Workers* workers, GCancellable* cancellable);
VideoMonitor* video_monitor_new (GCancellable* cancellable);
VideoMonitor* video_monitor_construct (GType object_type, GCancellable* cancellable);
GType video_monitor_get_type (void) G_GNUC_CONST;
static gboolean video_source_collection_real_holds_type_of_source (SourceCollection* base, DataSource* source);
static gchar* video_source_collection_real_get_typename (MediaSourceCollection* base);
static gboolean video_source_collection_real_is_file_recognized (MediaSourceCollection* base, GFile* file);
static MediaSource* video_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base, gint64 numeric_id);
Video* video_source_collection_fetch (VideoSourceCollection* self, VideoID* video_id);
DataSource* database_source_collection_fetch_by_key (DatabaseSourceCollection* self, gint64 key);
static GeeCollection* video_source_collection_real_get_event_source_ids (MediaSourceCollection* base, EventID* event_id);
GeeArrayList* video_table_get_event_source_ids (VideoTable* self, EventID* event_id);
Video* video_source_collection_get_state_by_file (VideoSourceCollection* self, GFile* file, VideoSourceCollectionState* state);
MediaSource* media_source_collection_fetch_by_master_file (MediaSourceCollection* self, GFile* file);
MediaSource* media_source_holding_tank_fetch_by_master_file (MediaSourceHoldingTank* self, GFile* file);
static void video_source_collection_compare_backing (VideoSourceCollection* self, Video* video, GFileInfo* info, GeeCollection* matching_master);
guint64 media_source_get_filesize (MediaSource* self);
time_t media_source_get_timestamp (MediaSource* self);
void video_source_collection_fetch_by_matching_backing (VideoSourceCollection* self, GFileInfo* info, GeeCollection* matching_master);
GeeCollection* data_collection_get_all (DataCollection* self);
GeeCollection* media_source_collection_get_offline_bin_contents (MediaSourceCollection* self);
static void video_source_collection_real_notify_contents_altered (DataCollection* base, GeeIterable* added, GeeIterable* removed);
void data_collection_notify_contents_altered (DataCollection* self, GeeIterable* added, GeeIterable* removed);
void video_source_collection_get_basename_filesize_duplicate (VideoSourceCollection* self, const gchar* basename, guint64 filesize, VideoID* result);
GFile* media_source_get_master_file (MediaSource* self);
gboolean video_source_collection_has_basename_filesize_duplicate (VideoSourceCollection* self, const gchar* basename, guint64 filesize);
gboolean video_id_is_valid (VideoID *self);
MediaSourceTransactionController* media_source_transaction_controller_new (MediaSourceCollection* sources);
MediaSourceTransactionController* media_source_transaction_controller_construct (GType object_type, MediaSourceCollection* sources);
GType media_source_transaction_controller_get_type (void) G_GNUC_CONST;
static void video_source_collection_finalize (DataCollection * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS[4] = {"bdm", "bdmv", "cpi", "mpl"};

GQuark video_error_quark (void) {
	return g_quark_from_static_string ("video_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 30 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? g_object_ref (self) : NULL;
#line 1520 "VideoSupport.c"
}


static gpointer _thumbnails_ref0 (gpointer self) {
#line 33 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? thumbnails_ref (self) : NULL;
#line 1527 "VideoSupport.c"
}


VideoImportParams* video_import_params_construct (GType object_type, GFile* file, ImportID* import_id, const gchar* md5, Thumbnails* thumbnails, time_t exposure_time_override) {
	VideoImportParams* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	ImportID _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	Thumbnails* _tmp5_;
	Thumbnails* _tmp6_;
	time_t _tmp7_;
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (import_id != NULL, NULL);
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail ((thumbnails == NULL) || IS_THUMBNAILS (thumbnails), NULL);
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (VideoImportParams*) g_type_create_instance (object_type);
#line 30 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = file;
#line 30 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 30 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->file);
#line 30 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->file = _tmp1_;
#line 31 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = *import_id;
#line 31 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->import_id = _tmp2_;
#line 32 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = md5;
#line 32 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 32 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (self->md5);
#line 32 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->md5 = _tmp4_;
#line 33 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = thumbnails;
#line 33 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = _thumbnails_ref0 (_tmp5_);
#line 33 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 33 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->thumbnails = _tmp6_;
#line 34 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = exposure_time_override;
#line 34 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->exposure_time_override = _tmp7_;
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 1583 "VideoSupport.c"
}


VideoImportParams* video_import_params_new (GFile* file, ImportID* import_id, const gchar* md5, Thumbnails* thumbnails, time_t exposure_time_override) {
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_import_params_construct (TYPE_VIDEO_IMPORT_PARAMS, file, import_id, md5, thumbnails, exposure_time_override);
#line 1590 "VideoSupport.c"
}


static void value_video_import_params_init (GValue* value) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	value->data[0].v_pointer = NULL;
#line 1597 "VideoSupport.c"
}


static void value_video_import_params_free_value (GValue* value) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (value->data[0].v_pointer) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_import_params_unref (value->data[0].v_pointer);
#line 1606 "VideoSupport.c"
	}
}


static void value_video_import_params_copy_value (const GValue* src_value, GValue* dest_value) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (src_value->data[0].v_pointer) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = video_import_params_ref (src_value->data[0].v_pointer);
#line 1616 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1620 "VideoSupport.c"
	}
}


static gpointer value_video_import_params_peek_pointer (const GValue* value) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 1628 "VideoSupport.c"
}


static gchar* value_video_import_params_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (collect_values[0].v_pointer) {
#line 1635 "VideoSupport.c"
		VideoImportParams * object;
		object = collect_values[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (object->parent_instance.g_class == NULL) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1642 "VideoSupport.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1646 "VideoSupport.c"
		}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = video_import_params_ref (object);
#line 1650 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 1654 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 1658 "VideoSupport.c"
}


static gchar* value_video_import_params_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	VideoImportParams ** object_p;
	object_p = collect_values[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!object_p) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1669 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!value->data[0].v_pointer) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = NULL;
#line 1675 "VideoSupport.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = value->data[0].v_pointer;
#line 1679 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = video_import_params_ref (value->data[0].v_pointer);
#line 1683 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 1687 "VideoSupport.c"
}


GParamSpec* param_spec_video_import_params (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecVideoImportParams* spec;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIDEO_IMPORT_PARAMS), NULL);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return G_PARAM_SPEC (spec);
#line 1701 "VideoSupport.c"
}


gpointer value_get_video_import_params (const GValue* value) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_IMPORT_PARAMS), NULL);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 1710 "VideoSupport.c"
}


void value_set_video_import_params (GValue* value, gpointer v_object) {
	VideoImportParams * old;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_IMPORT_PARAMS));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_IMPORT_PARAMS));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_import_params_ref (value->data[0].v_pointer);
#line 1730 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 1734 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_import_params_unref (old);
#line 1740 "VideoSupport.c"
	}
}


void value_take_video_import_params (GValue* value, gpointer v_object) {
	VideoImportParams * old;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_IMPORT_PARAMS));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_IMPORT_PARAMS));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 1759 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 1763 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_import_params_unref (old);
#line 1769 "VideoSupport.c"
	}
}


static void video_import_params_class_init (VideoImportParamsClass * klass) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_import_params_parent_class = g_type_class_peek_parent (klass);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((VideoImportParamsClass *) klass)->finalize = video_import_params_finalize;
#line 1779 "VideoSupport.c"
}


static void video_import_params_instance_init (VideoImportParams * self) {
	VideoRow* _tmp0_;
#line 18 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	import_id_init (&self->import_id, IMPORT_ID_INVALID);
#line 26 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_row_new ();
#line 26 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->row = _tmp0_;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->ref_count = 1;
#line 1793 "VideoSupport.c"
}


static void video_import_params_finalize (VideoImportParams * obj) {
	VideoImportParams * self;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_IMPORT_PARAMS, VideoImportParams);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_handlers_destroy (self);
#line 17 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->file);
#line 19 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (self->md5);
#line 23 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 26 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_row_unref0 (self->row);
#line 1811 "VideoSupport.c"
}


GType video_import_params_get_type (void) {
	static volatile gsize video_import_params_type_id__volatile = 0;
	if (g_once_init_enter (&video_import_params_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_video_import_params_init, value_video_import_params_free_value, value_video_import_params_copy_value, value_video_import_params_peek_pointer, "p", value_video_import_params_collect_value, "p", value_video_import_params_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (VideoImportParamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_import_params_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoImportParams), 0, (GInstanceInitFunc) video_import_params_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType video_import_params_type_id;
		video_import_params_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoImportParams", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&video_import_params_type_id__volatile, video_import_params_type_id);
	}
	return video_import_params_type_id__volatile;
}


gpointer video_import_params_ref (gpointer instance) {
	VideoImportParams * self;
	self = instance;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_atomic_int_inc (&self->ref_count);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return instance;
#line 1836 "VideoSupport.c"
}


void video_import_params_unref (gpointer instance) {
	VideoImportParams * self;
	self = instance;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		VIDEO_IMPORT_PARAMS_GET_CLASS (self)->finalize (self);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1849 "VideoSupport.c"
	}
}


VideoReader* video_reader_construct (GType object_type, GFile* file) {
	VideoReader* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
#line 51 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 51 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (VideoReader*) g_type_create_instance (object_type);
#line 52 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = file;
#line 52 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 52 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->file);
#line 52 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->file = _tmp1_;
#line 51 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 1872 "VideoSupport.c"
}


VideoReader* video_reader_new (GFile* file) {
#line 51 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_reader_construct (TYPE_VIDEO_READER, file);
#line 1879 "VideoSupport.c"
}


gboolean video_reader_is_supported_video_file (GFile* file) {
	gboolean result = FALSE;
	gchar* mime_type = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	guchar* _tmp3_;
	guchar* _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	GFile* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	GError * _inner_error_ = NULL;
#line 55 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = file;
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = g_file_get_basename (_tmp0_);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = g_new0 (guchar, 0);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4__length1 = 0;
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = g_content_type_guess (_tmp2_, _tmp4_, (gsize) 0, NULL);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = _tmp5_;
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = (g_free (_tmp4_), NULL);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp2_);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	mime_type = _tmp6_;
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = mime_type;
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (g_strcmp0 (_tmp8_, "audio/ogg") == 0) {
#line 1930 "VideoSupport.c"
		GFile* _tmp9_;
		gboolean _tmp10_;
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = file;
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = g_file_has_uri_scheme (_tmp9_, "file");
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = _tmp10_;
#line 1939 "VideoSupport.c"
	} else {
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = FALSE;
#line 1943 "VideoSupport.c"
	}
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp7_) {
#line 1947 "VideoSupport.c"
		{
			GFileInfo* info = NULL;
			GFile* _tmp11_;
			GFileInfo* _tmp12_;
			gchar* content_type = NULL;
			GFileInfo* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gboolean _tmp16_ = FALSE;
			const gchar* _tmp17_;
#line 60 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = file;
#line 60 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = g_file_query_info (_tmp11_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 60 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			info = _tmp12_;
#line 60 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1966 "VideoSupport.c"
				goto __catch503_g_error;
			}
#line 62 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp13_ = info;
#line 62 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp14_ = g_file_info_get_content_type (_tmp13_);
#line 62 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp15_ = g_strdup (_tmp14_);
#line 62 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			content_type = _tmp15_;
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = content_type;
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp17_ != NULL) {
#line 1981 "VideoSupport.c"
				const gchar* _tmp18_;
				gboolean _tmp19_;
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp18_ = content_type;
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp19_ = g_str_has_prefix (_tmp18_, "video/");
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = _tmp19_;
#line 1990 "VideoSupport.c"
			} else {
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = FALSE;
#line 1994 "VideoSupport.c"
			}
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp16_) {
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = TRUE;
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (content_type);
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (info);
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (mime_type);
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 2008 "VideoSupport.c"
			}
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (content_type);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (info);
#line 2014 "VideoSupport.c"
		}
		goto __finally503;
		__catch503_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp20_;
			const gchar* _tmp21_;
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_error_ = _inner_error_;
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_inner_error_ = NULL;
#line 67 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp20_ = _error_;
#line 67 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_ = _tmp20_->message;
#line 67 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_debug ("VideoSupport.vala:67: Failed to query content type: %s", _tmp21_);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_error_free0 (_error_);
#line 2034 "VideoSupport.c"
		}
		__finally503:
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2039 "VideoSupport.c"
			gboolean _tmp22_ = FALSE;
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (mime_type);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return _tmp22_;
#line 2049 "VideoSupport.c"
		}
	}
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_ = file;
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = g_file_get_basename (_tmp23_);
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp25_ = _tmp24_;
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp26_ = video_reader_is_supported_video_filename (_tmp25_);
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = _tmp26_;
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp25_);
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp27_;
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (mime_type);
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 2070 "VideoSupport.c"
}


gboolean video_reader_is_supported_video_filename (const gchar* filename) {
	gboolean result = FALSE;
	gchar* mime_type = NULL;
	const gchar* _tmp0_;
	guchar* _tmp1_;
	guchar* _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp6_;
#line 74 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (filename != NULL, FALSE);
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = filename;
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = g_new0 (guchar, 0);
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2__length1 = 0;
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = g_content_type_guess (_tmp0_, _tmp2_, (gsize) 0, NULL);
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (mime_type);
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	mime_type = _tmp3_;
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = (g_free (_tmp2_), NULL);
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = mime_type;
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = g_str_has_prefix (_tmp5_, "video/");
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp6_) {
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = TRUE;
#line 2111 "VideoSupport.c"
	} else {
		const gchar* _tmp7_;
		gboolean _tmp8_;
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = mime_type;
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = g_str_has_suffix (_tmp7_, "mp4");
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = _tmp8_;
#line 2121 "VideoSupport.c"
	}
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp4_) {
#line 2125 "VideoSupport.c"
		gchar* extension = NULL;
		gchar* name = NULL;
		const gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
#line 79 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		extension = NULL;
#line 80 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		name = NULL;
#line 81 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = filename;
#line 81 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		disassemble_filename (_tmp9_, &_tmp10_, &_tmp11_);
#line 81 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (name);
#line 81 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		name = _tmp10_;
#line 81 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (extension);
#line 81 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		extension = _tmp11_;
#line 83 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = extension;
#line 83 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp12_ == NULL) {
#line 84 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = TRUE;
#line 84 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (name);
#line 84 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (extension);
#line 84 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (mime_type);
#line 84 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 2162 "VideoSupport.c"
		}
		{
			const gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			s_collection = VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS;
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			s_collection_length1 = G_N_ELEMENTS (VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS);
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			for (s_it = 0; s_it < G_N_ELEMENTS (VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS); s_it = s_it + 1) {
#line 2175 "VideoSupport.c"
				gchar* _tmp13_;
				gchar* s = NULL;
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = g_strdup (s_collection[s_it]);
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				s = _tmp13_;
#line 2182 "VideoSupport.c"
				{
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					gint _tmp16_;
#line 87 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp14_ = s;
#line 87 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp15_ = extension;
#line 87 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp16_ = utf8_ci_compare (_tmp14_, _tmp15_);
#line 87 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_tmp16_ == 0) {
#line 88 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						result = FALSE;
#line 88 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_g_free0 (s);
#line 88 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_g_free0 (name);
#line 88 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_g_free0 (extension);
#line 88 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_g_free0 (mime_type);
#line 88 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						return result;
#line 2207 "VideoSupport.c"
					}
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (s);
#line 2211 "VideoSupport.c"
				}
			}
		}
#line 91 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = TRUE;
#line 91 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (name);
#line 91 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (extension);
#line 91 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (mime_type);
#line 91 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2225 "VideoSupport.c"
	} else {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
#line 93 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp17_ = filename;
#line 93 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp18_ = mime_type;
#line 93 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:93: Skipping %s, unsupported mime type %s", _tmp17_, _tmp18_);
#line 94 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = FALSE;
#line 94 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (mime_type);
#line 94 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2241 "VideoSupport.c"
	}
#line 74 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (mime_type);
#line 2245 "VideoSupport.c"
}


ImportResult video_reader_prepare_for_import (VideoImportParams* params) {
	ImportResult result = 0;
	GFile* file = NULL;
	VideoImportParams* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFileInfo* info = NULL;
	GFileInfo* _tmp7_;
	GFileType _tmp8_;
	GFile* _tmp9_;
	gboolean _tmp10_;
	GTimeVal timestamp = {0};
	GFileInfo* _tmp14_;
	GTimeVal _tmp15_ = {0};
	VideoImportParams* _tmp16_;
	const gchar* _tmp17_;
	time_t exposure_time = 0;
	VideoImportParams* _tmp18_;
	time_t _tmp19_;
	gchar* title = NULL;
	gchar* _tmp20_;
	gchar* comment = NULL;
	gchar* _tmp21_;
	VideoReader* reader = NULL;
	GFile* _tmp22_;
	VideoReader* _tmp23_;
	gboolean is_interpretable = FALSE;
	gdouble clip_duration = 0.0;
	GdkPixbuf* preview_frame = NULL;
	VideoReader* _tmp24_;
	GdkPixbuf* _tmp25_;
	time_t _tmp53_;
	VideoImportParams* _tmp60_;
	VideoRow* _tmp61_;
	VideoImportParams* _tmp62_;
	VideoRow* _tmp63_;
	GFile* _tmp64_;
	gchar* _tmp65_;
	VideoImportParams* _tmp66_;
	VideoRow* _tmp67_;
	GFileInfo* _tmp68_;
	gint64 _tmp69_;
	VideoImportParams* _tmp70_;
	VideoRow* _tmp71_;
	GTimeVal _tmp72_;
	glong _tmp73_;
	VideoImportParams* _tmp74_;
	VideoRow* _tmp75_;
	GdkPixbuf* _tmp76_;
	gint _tmp77_;
	gint _tmp78_;
	VideoImportParams* _tmp79_;
	VideoRow* _tmp80_;
	GdkPixbuf* _tmp81_;
	gint _tmp82_;
	gint _tmp83_;
	VideoImportParams* _tmp84_;
	VideoRow* _tmp85_;
	gdouble _tmp86_;
	VideoImportParams* _tmp87_;
	VideoRow* _tmp88_;
	gboolean _tmp89_;
	VideoImportParams* _tmp90_;
	VideoRow* _tmp91_;
	time_t _tmp92_;
	VideoImportParams* _tmp93_;
	VideoRow* _tmp94_;
	VideoImportParams* _tmp95_;
	ImportID _tmp96_;
	VideoImportParams* _tmp97_;
	VideoRow* _tmp98_;
	VideoImportParams* _tmp99_;
	VideoRow* _tmp100_;
	VideoImportParams* _tmp101_;
	const gchar* _tmp102_;
	gchar* _tmp103_;
	VideoImportParams* _tmp104_;
	VideoRow* _tmp105_;
	VideoImportParams* _tmp106_;
	VideoRow* _tmp107_;
	const gchar* _tmp108_;
	gchar* _tmp109_;
	VideoImportParams* _tmp110_;
	VideoRow* _tmp111_;
	const gchar* _tmp112_;
	gchar* _tmp113_;
	VideoImportParams* _tmp114_;
	VideoRow* _tmp115_;
	gchar* _tmp116_;
	VideoImportParams* _tmp117_;
	VideoRow* _tmp118_;
	VideoImportParams* _tmp119_;
	VideoRow* _tmp120_;
	VideoImportParams* _tmp121_;
	Thumbnails* _tmp122_;
	GError * _inner_error_ = NULL;
#line 98 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_IMPORT_PARAMS (params), 0);
#line 102 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = params;
#line 102 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_->file;
#line 102 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 102 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	file = _tmp2_;
#line 104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	info = NULL;
#line 2357 "VideoSupport.c"
	{
		GFileInfo* _tmp3_ = NULL;
		GFile* _tmp4_;
		GFileInfo* _tmp5_;
		GFileInfo* _tmp6_;
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = file;
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = g_file_query_info (_tmp4_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = _tmp5_;
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2371 "VideoSupport.c"
			goto __catch504_g_error;
		}
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = _tmp3_;
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = NULL;
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		info = _tmp6_;
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp3_);
#line 2384 "VideoSupport.c"
	}
	goto __finally504;
	__catch504_g_error:
	{
		GError* err = NULL;
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = IMPORT_RESULT_FILE_ERROR;
#line 109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2404 "VideoSupport.c"
	}
	__finally504:
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 2419 "VideoSupport.c"
	}
#line 112 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = info;
#line 112 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = g_file_info_get_file_type (_tmp7_);
#line 112 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp8_ != G_FILE_TYPE_REGULAR) {
#line 113 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = IMPORT_RESULT_NOT_A_FILE;
#line 113 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 113 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 113 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2435 "VideoSupport.c"
	}
#line 115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_ = file;
#line 115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10_ = video_reader_is_supported_video_file (_tmp9_);
#line 115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!_tmp10_) {
#line 2443 "VideoSupport.c"
		GFile* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
#line 116 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = file;
#line 116 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = g_file_get_path (_tmp11_);
#line 116 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp13_ = _tmp12_;
#line 116 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_message ("Not importing %s: file is marked as a video file but doesn't have a" "supported extension", _tmp13_);
#line 116 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp13_);
#line 119 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
#line 119 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 119 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 119 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2465 "VideoSupport.c"
	}
#line 122 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp14_ = info;
#line 122 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_file_info_get_modification_time (_tmp14_, &_tmp15_);
#line 122 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	timestamp = _tmp15_;
#line 125 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp16_ = params;
#line 125 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp17_ = _tmp16_->md5;
#line 125 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_assert (_tmp17_ != NULL, "params.md5 != null");
#line 127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp18_ = params;
#line 127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp19_ = _tmp18_->exposure_time_override;
#line 127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	exposure_time = _tmp19_;
#line 128 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = g_strdup ("");
#line 128 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	title = _tmp20_;
#line 129 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp21_ = g_strdup ("");
#line 129 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	comment = _tmp21_;
#line 131 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp22_ = file;
#line 131 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_ = video_reader_new (_tmp22_);
#line 131 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	reader = _tmp23_;
#line 132 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	is_interpretable = TRUE;
#line 133 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	clip_duration = 0.0;
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = reader;
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp25_ = video_reader_read_preview_frame (_tmp24_);
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	preview_frame = _tmp25_;
#line 2509 "VideoSupport.c"
	{
		gdouble _tmp26_ = 0.0;
		VideoReader* _tmp27_;
		gdouble _tmp28_;
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp27_ = reader;
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp28_ = video_reader_read_clip_duration (_tmp27_, &_inner_error_);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp26_ = _tmp28_;
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == VIDEO_ERROR) {
#line 2524 "VideoSupport.c"
				goto __catch505_video_error;
			}
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (preview_frame);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_reader_unref0 (reader);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (comment);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (title);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (info);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (file);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return 0;
#line 2545 "VideoSupport.c"
		}
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		clip_duration = _tmp26_;
#line 2549 "VideoSupport.c"
	}
	goto __finally505;
	__catch505_video_error:
	{
		GError* err = NULL;
		GError* _tmp29_;
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp29_ = err;
#line 138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (g_error_matches (_tmp29_, VIDEO_ERROR, VIDEO_ERROR_FILE)) {
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = IMPORT_RESULT_FILE_ERROR;
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_error_free0 (err);
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (preview_frame);
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_reader_unref0 (reader);
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (comment);
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (title);
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (info);
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (file);
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 2582 "VideoSupport.c"
		} else {
			GError* _tmp30_;
#line 140 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp30_ = err;
#line 140 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (g_error_matches (_tmp30_, VIDEO_ERROR, VIDEO_ERROR_CONTENTS)) {
#line 141 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				is_interpretable = FALSE;
#line 142 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				clip_duration = 0.0;
#line 2593 "VideoSupport.c"
			} else {
#line 144 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_error ("VideoSupport.vala:144: can't prepare video for import: an unknown kind" \
" of video error occurred");
#line 2597 "VideoSupport.c"
			}
		}
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 2602 "VideoSupport.c"
	}
	__finally505:
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (reader);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (comment);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (title);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 2625 "VideoSupport.c"
	}
	{
		VideoMetadata* metadata = NULL;
		VideoReader* _tmp31_;
		VideoMetadata* _tmp32_;
		MetadataDateTime* creation_date_time = NULL;
		VideoMetadata* _tmp33_;
		MetadataDateTime* _tmp34_;
		gboolean _tmp35_ = FALSE;
		MetadataDateTime* _tmp36_;
		gchar* video_title = NULL;
		VideoMetadata* _tmp41_;
		gchar* _tmp42_;
		gchar* video_comment = NULL;
		VideoMetadata* _tmp43_;
		gchar* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp48_;
#line 149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp31_ = reader;
#line 149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp32_ = video_reader_read_metadata (_tmp31_, &_inner_error_);
#line 149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		metadata = _tmp32_;
#line 149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2652 "VideoSupport.c"
			goto __catch506_g_error;
		}
#line 150 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp33_ = metadata;
#line 150 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp34_ = media_metadata_get_creation_date_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 150 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		creation_date_time = _tmp34_;
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp36_ = creation_date_time;
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp36_ != NULL) {
#line 2665 "VideoSupport.c"
			MetadataDateTime* _tmp37_;
			time_t _tmp38_;
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp37_ = creation_date_time;
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp38_ = metadata_date_time_get_timestamp (_tmp37_);
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp35_ = _tmp38_ != ((time_t) 0);
#line 2674 "VideoSupport.c"
		} else {
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp35_ = FALSE;
#line 2678 "VideoSupport.c"
		}
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp35_) {
#line 2682 "VideoSupport.c"
			MetadataDateTime* _tmp39_;
			time_t _tmp40_;
#line 153 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp39_ = creation_date_time;
#line 153 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp40_ = metadata_date_time_get_timestamp (_tmp39_);
#line 153 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			exposure_time = _tmp40_;
#line 2691 "VideoSupport.c"
		}
#line 155 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp41_ = metadata;
#line 155 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp42_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 155 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_title = _tmp42_;
#line 156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp43_ = metadata;
#line 156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp44_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_comment = _tmp44_;
#line 157 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp45_ = video_title;
#line 157 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp45_ != NULL) {
#line 2709 "VideoSupport.c"
			const gchar* _tmp46_;
			gchar* _tmp47_;
#line 158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp46_ = video_title;
#line 158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp47_ = g_strdup (_tmp46_);
#line 158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (title);
#line 158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			title = _tmp47_;
#line 2720 "VideoSupport.c"
		}
#line 159 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp48_ = video_comment;
#line 159 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp48_ != NULL) {
#line 2726 "VideoSupport.c"
			const gchar* _tmp49_;
			gchar* _tmp50_;
#line 160 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp49_ = video_comment;
#line 160 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp50_ = g_strdup (_tmp49_);
#line 160 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (comment);
#line 160 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			comment = _tmp50_;
#line 2737 "VideoSupport.c"
		}
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (video_comment);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (video_title);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_metadata_date_time_unref0 (creation_date_time);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_media_metadata_unref0 (metadata);
#line 2747 "VideoSupport.c"
	}
	goto __finally506;
	__catch506_g_error:
	{
		GError* err = NULL;
		GError* _tmp51_;
		const gchar* _tmp52_;
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 162 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp51_ = err;
#line 162 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp52_ = _tmp51_->message;
#line 162 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_warning ("VideoSupport.vala:162: Unable to read video metadata: %s", _tmp52_);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 2767 "VideoSupport.c"
	}
	__finally506:
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (reader);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (comment);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (title);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 2790 "VideoSupport.c"
	}
#line 165 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp53_ = exposure_time;
#line 165 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp53_ == ((time_t) 0)) {
#line 2796 "VideoSupport.c"
		gint64 _tmp54_ = 0LL;
		VideoReader* _tmp55_;
		GDateTime* _tmp56_;
#line 167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp55_ = reader;
#line 167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp56_ = _tmp55_->priv->_timestamp;
#line 167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp56_ != NULL) {
#line 2806 "VideoSupport.c"
			VideoReader* _tmp57_;
			GDateTime* _tmp58_;
			gint64 _tmp59_;
#line 168 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp57_ = reader;
#line 168 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp58_ = _tmp57_->priv->_timestamp;
#line 168 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp59_ = g_date_time_to_unix (_tmp58_);
#line 168 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp54_ = _tmp59_;
#line 2818 "VideoSupport.c"
		} else {
#line 168 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp54_ = (gint64) 0;
#line 2822 "VideoSupport.c"
		}
#line 167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		exposure_time = (time_t) _tmp54_;
#line 2826 "VideoSupport.c"
	}
#line 171 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp60_ = params;
#line 171 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp61_ = _tmp60_->row;
#line 171 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id_init (&_tmp61_->video_id, VIDEO_ID_INVALID);
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp62_ = params;
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp63_ = _tmp62_->row;
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp64_ = file;
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp65_ = g_file_get_path (_tmp64_);
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp63_->filepath);
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp63_->filepath = _tmp65_;
#line 173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp66_ = params;
#line 173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp67_ = _tmp66_->row;
#line 173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp68_ = info;
#line 173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp69_ = g_file_info_get_size (_tmp68_);
#line 173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp67_->filesize = _tmp69_;
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp70_ = params;
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp71_ = _tmp70_->row;
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp72_ = timestamp;
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp73_ = _tmp72_.tv_sec;
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp71_->timestamp = (time_t) _tmp73_;
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp74_ = params;
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp75_ = _tmp74_->row;
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp76_ = preview_frame;
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp77_ = gdk_pixbuf_get_width (_tmp76_);
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp78_ = _tmp77_;
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp75_->width = _tmp78_;
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp79_ = params;
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp80_ = _tmp79_->row;
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp81_ = preview_frame;
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp82_ = gdk_pixbuf_get_height (_tmp81_);
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp83_ = _tmp82_;
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp80_->height = _tmp83_;
#line 177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp84_ = params;
#line 177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp85_ = _tmp84_->row;
#line 177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp86_ = clip_duration;
#line 177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp85_->clip_duration = _tmp86_;
#line 178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp87_ = params;
#line 178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp88_ = _tmp87_->row;
#line 178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp89_ = is_interpretable;
#line 178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp88_->is_interpretable = _tmp89_;
#line 179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp90_ = params;
#line 179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp91_ = _tmp90_->row;
#line 179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp92_ = exposure_time;
#line 179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp91_->exposure_time = _tmp92_;
#line 180 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp93_ = params;
#line 180 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp94_ = _tmp93_->row;
#line 180 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp95_ = params;
#line 180 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp96_ = _tmp95_->import_id;
#line 180 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp94_->import_id = _tmp96_;
#line 181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp97_ = params;
#line 181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp98_ = _tmp97_->row;
#line 181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	event_id_init (&_tmp98_->event_id, EVENT_ID_INVALID);
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp99_ = params;
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp100_ = _tmp99_->row;
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp101_ = params;
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp102_ = _tmp101_->md5;
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp103_ = g_strdup (_tmp102_);
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp100_->md5);
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp100_->md5 = _tmp103_;
#line 183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp104_ = params;
#line 183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp105_ = _tmp104_->row;
#line 183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp105_->time_created = (time_t) 0;
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp106_ = params;
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp107_ = _tmp106_->row;
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp108_ = title;
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp109_ = g_strdup (_tmp108_);
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp107_->title);
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp107_->title = _tmp109_;
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp110_ = params;
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp111_ = _tmp110_->row;
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp112_ = comment;
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp113_ = g_strdup (_tmp112_);
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp111_->comment);
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp111_->comment = _tmp113_;
#line 186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp114_ = params;
#line 186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp115_ = _tmp114_->row;
#line 186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp116_ = g_strdup ("");
#line 186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp115_->backlinks);
#line 186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp115_->backlinks = _tmp116_;
#line 187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp117_ = params;
#line 187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp118_ = _tmp117_->row;
#line 187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp118_->time_reimported = (time_t) 0;
#line 188 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp119_ = params;
#line 188 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp120_ = _tmp119_->row;
#line 188 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp120_->flags = (guint64) 0;
#line 190 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp121_ = params;
#line 190 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp122_ = _tmp121_->thumbnails;
#line 190 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp122_ != NULL) {
#line 3002 "VideoSupport.c"
		VideoImportParams* _tmp123_;
		Thumbnails* _tmp124_;
		VideoImportParams* _tmp125_;
		Thumbnails* _tmp126_;
		GdkPixbuf* _tmp127_;
#line 191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp123_ = params;
#line 191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp124_ = thumbnails_new ();
#line 191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_thumbnails_unref0 (_tmp123_->thumbnails);
#line 191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp123_->thumbnails = _tmp124_;
#line 192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp125_ = params;
#line 192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp126_ = _tmp125_->thumbnails;
#line 192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp127_ = preview_frame;
#line 192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		thumbnail_cache_generate_for_video_frame (_tmp126_, _tmp127_);
#line 3024 "VideoSupport.c"
	}
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = IMPORT_RESULT_SUCCESS;
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (preview_frame);
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_reader_unref0 (reader);
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (comment);
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (title);
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (info);
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (file);
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3042 "VideoSupport.c"
}


static GDate* _g_date_dup (GDate* self) {
	GDate* dup;
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	dup = g_new0 (GDate, 1);
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	memcpy (dup, self, sizeof (GDate));
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return dup;
#line 3054 "VideoSupport.c"
}


static gpointer __g_date_dup0 (gpointer self) {
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? _g_date_dup (self) : NULL;
#line 3061 "VideoSupport.c"
}


static void video_reader_read_internal (VideoReader* self, GError** error) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
#line 201 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_READER (self));
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_reader_does_file_exist (self);
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!_tmp0_) {
#line 3074 "VideoSupport.c"
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->priv->file;
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = g_file_get_path (_tmp1_);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = _tmp2_;
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = g_strdup_printf ("video file '%s' does not exist or is inaccessible", _tmp3_);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = _tmp4_;
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = g_error_new_literal (VIDEO_ERROR, VIDEO_ERROR_FILE, _tmp5_);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = _tmp6_;
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp5_);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp3_);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = _tmp7_;
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_inner_error_->domain == VIDEO_ERROR) {
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_propagate_error (error, _inner_error_);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 3108 "VideoSupport.c"
		} else {
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 3116 "VideoSupport.c"
		}
	}
	{
		GstDiscoverer* d = NULL;
		GstDiscoverer* _tmp8_;
		GstDiscovererInfo* info = NULL;
		GstDiscoverer* _tmp9_;
		GFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GstDiscovererInfo* _tmp13_;
		GstDiscovererInfo* _tmp14_;
		GstDiscovererInfo* _tmp15_;
		GstClockTime _tmp16_;
		GDate* video_date = NULL;
		gboolean _tmp17_ = FALSE;
		GstDiscovererInfo* _tmp18_;
		GstTagList* _tmp19_;
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = gst_discoverer_new ((GstClockTime) (GST_SECOND * 5), &_inner_error_);
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		d = _tmp8_;
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3141 "VideoSupport.c"
			goto __catch507_g_error;
		}
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = d;
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = self->priv->file;
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = g_file_get_uri (_tmp10_);
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = _tmp11_;
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp13_ = gst_discoverer_discover_uri (_tmp9_, _tmp12_, &_inner_error_);
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp14_ = _tmp13_;
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp12_);
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		info = _tmp14_;
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (d);
#line 3164 "VideoSupport.c"
			goto __catch507_g_error;
		}
#line 210 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp15_ = info;
#line 210 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp16_ = gst_discoverer_info_get_duration (_tmp15_);
#line 210 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		self->priv->clip_duration = ((gdouble) _tmp16_) / 1000000000.0;
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_date = NULL;
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp18_ = info;
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp19_ = gst_discoverer_info_get_tags (_tmp18_);
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp19_ != NULL) {
#line 3181 "VideoSupport.c"
			GstDiscovererInfo* _tmp20_;
			GstTagList* _tmp21_;
			GDate _tmp22_ = {0};
			gboolean _tmp23_;
			GDate _tmp24_;
			GDate* _tmp25_;
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp20_ = info;
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_ = gst_discoverer_info_get_tags (_tmp20_);
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_ = gst_tag_list_get_date (_tmp21_, GST_TAG_DATE, &_tmp22_);
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (video_date);
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp24_ = _tmp22_;
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp25_ = __g_date_dup0 (&_tmp24_);
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_date = _tmp25_;
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = _tmp23_;
#line 3204 "VideoSupport.c"
		} else {
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = FALSE;
#line 3208 "VideoSupport.c"
		}
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp17_) {
#line 3212 "VideoSupport.c"
			GDate* _tmp26_;
#line 218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp26_ = video_date;
#line 218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp26_ != NULL) {
#line 3218 "VideoSupport.c"
				GDate* _tmp27_;
				GDateYear _tmp28_;
				GDate* _tmp29_;
				GDateMonth _tmp30_;
				GDate* _tmp31_;
				GDateDay _tmp32_;
				GDateTime* _tmp33_;
				GDateTime* _tmp34_;
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp27_ = video_date;
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp28_ = g_date_get_year (_tmp27_);
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp29_ = video_date;
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp30_ = g_date_get_month (_tmp29_);
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp31_ = video_date;
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp32_ = g_date_get_day (_tmp31_);
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp33_ = g_date_time_new_local ((gint) _tmp28_, (gint) _tmp30_, (gint) _tmp32_, 0, 0, (gdouble) 0);
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp34_ = _tmp33_;
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_reader_set_timestamp (self, _tmp34_);
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_date_time_unref0 (_tmp34_);
#line 3247 "VideoSupport.c"
			}
		}
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (video_date);
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (d);
#line 3256 "VideoSupport.c"
	}
	goto __finally507;
	__catch507_g_error:
	{
		GError* e = NULL;
		GError* _tmp35_;
		const gchar* _tmp36_;
		GError* _tmp37_;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		GError* _tmp41_;
		GError* _tmp42_;
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp35_ = e;
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp36_ = _tmp35_->message;
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:224: Video read error: %s", _tmp36_);
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp37_ = e;
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp38_ = _tmp37_->message;
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp39_ = g_strdup_printf ("GStreamer couldn't extract clip information: %s", _tmp38_);
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp40_ = _tmp39_;
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp41_ = g_error_new_literal (VIDEO_ERROR, VIDEO_ERROR_CONTENTS, _tmp40_);
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp42_ = _tmp41_;
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp40_);
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = _tmp42_;
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 3298 "VideoSupport.c"
		goto __finally507;
	}
	__finally507:
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_inner_error_->domain == VIDEO_ERROR) {
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_propagate_error (error, _inner_error_);
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 3310 "VideoSupport.c"
		} else {
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 3318 "VideoSupport.c"
		}
	}
}


static gboolean video_reader_on_thumbnailer_timer (VideoReader* self) {
	gboolean result = FALSE;
	GPid _tmp0_;
#line 231 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), FALSE);
#line 232 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_debug ("VideoSupport.vala:232: Thumbnailer timer called");
#line 233 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->thumbnailer_pid;
#line 233 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_ != ((GPid) 0)) {
#line 3335 "VideoSupport.c"
		GPid _tmp1_;
		GPid _tmp2_;
#line 234 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->priv->thumbnailer_pid;
#line 234 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:234: Killing thumbnailer process: %d", (gint) _tmp1_);
#line 235 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = self->priv->thumbnailer_pid;
#line 235 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		kill ((pid_t) _tmp2_, SIGKILL);
#line 3346 "VideoSupport.c"
	}
#line 237 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = FALSE;
#line 237 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3352 "VideoSupport.c"
}


static gboolean _video_reader_on_thumbnailer_timer_gsource_func (gpointer self) {
	gboolean result;
	result = video_reader_on_thumbnailer_timer ((VideoReader*) self);
#line 260 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3361 "VideoSupport.c"
}


static GdkPixbuf* video_reader_thumbnailer (VideoReader* self, const gchar* video_file) {
	GdkPixbuf* result = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** argv = NULL;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint argv_length1;
	gint _argv_size_;
	gint child_stdout = 0;
	GdkPixbuf* buf = NULL;
	gint child_status = 0;
	gint ret_waitpid = 0;
	GPid _tmp27_;
	gint _tmp28_ = 0;
	pid_t _tmp29_;
	gint _tmp30_;
	GPid _tmp36_;
	GError * _inner_error_ = NULL;
#line 242 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
#line 242 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (video_file != NULL, NULL);
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = app_dirs_get_thumbnailer_bin ();
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_file_get_path (_tmp1_);
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_debug ("VideoSupport.vala:244: Launching thumbnailer process: %s", _tmp3_);
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp3_);
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp1_);
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = app_dirs_get_thumbnailer_bin ();
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = _tmp4_;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = g_file_get_path (_tmp5_);
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = video_file;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_ = g_new0 (gchar*, 2 + 1);
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_[0] = _tmp6_;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_[1] = _tmp8_;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10_ = _tmp9_;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10__length1 = 2;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp5_);
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	argv = _tmp10_;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	argv_length1 = _tmp10__length1;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_argv_size_ = argv_length1;
#line 3438 "VideoSupport.c"
	{
		gchar** _tmp11_;
		gint _tmp11__length1;
		GPid _tmp12_ = 0;
		gint _tmp13_ = 0;
		GPid _tmp14_;
#line 248 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = argv;
#line 248 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11__length1 = argv_length1;
#line 248 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_spawn_async_with_pipes (NULL, _tmp11_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp12_, NULL, &_tmp13_, NULL, &_inner_error_);
#line 248 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		self->priv->thumbnailer_pid = _tmp12_;
#line 248 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		child_stdout = _tmp13_;
#line 248 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3457 "VideoSupport.c"
			goto __catch508_g_error;
		}
#line 251 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp14_ = self->priv->thumbnailer_pid;
#line 251 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:251: Spawned thumbnailer, child pid: %d", (gint) _tmp14_);
#line 3464 "VideoSupport.c"
	}
	goto __finally508;
	__catch508_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		GPid _tmp17_;
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 253 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp15_ = e;
#line 253 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp16_ = _tmp15_->message;
#line 253 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:253: Error spawning process: %s", _tmp16_);
#line 254 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp17_ = self->priv->thumbnailer_pid;
#line 254 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp17_ != ((GPid) 0)) {
#line 3487 "VideoSupport.c"
			GPid _tmp18_;
#line 255 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_ = self->priv->thumbnailer_pid;
#line 255 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_spawn_close_pid (_tmp18_);
#line 3493 "VideoSupport.c"
		}
#line 256 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 256 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 256 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 256 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 3503 "VideoSupport.c"
	}
	__finally508:
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 3516 "VideoSupport.c"
	}
#line 260 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, VIDEO_READER_THUMBNAILER_TIMEOUT, _video_reader_on_thumbnailer_timer_gsource_func, video_reader_ref (self), video_reader_unref);
#line 263 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	buf = NULL;
#line 3522 "VideoSupport.c"
	{
		GUnixInputStream* unix_input = NULL;
		gint _tmp19_;
		GUnixInputStream* _tmp20_;
		GdkPixbuf* _tmp21_ = NULL;
		GUnixInputStream* _tmp22_;
		GdkPixbuf* _tmp23_;
		GdkPixbuf* _tmp24_;
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp19_ = child_stdout;
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp20_ = (GUnixInputStream*) g_unix_input_stream_new (_tmp19_, TRUE);
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		unix_input = _tmp20_;
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp22_ = unix_input;
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp23_ = gdk_pixbuf_new_from_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp21_ = _tmp23_;
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (unix_input);
#line 3547 "VideoSupport.c"
			goto __catch509_g_error;
		}
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp24_ = _tmp21_;
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp21_ = NULL;
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (buf);
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		buf = _tmp24_;
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp21_);
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (unix_input);
#line 3562 "VideoSupport.c"
	}
	goto __finally509;
	__catch509_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 268 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp25_ = e;
#line 268 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp26_ = _tmp25_->message;
#line 268 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:268: Error creating pixbuf: %s", _tmp26_);
#line 269 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (buf);
#line 269 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		buf = NULL;
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 3586 "VideoSupport.c"
	}
	__finally509:
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (buf);
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 3601 "VideoSupport.c"
	}
#line 273 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	child_status = 0;
#line 274 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = self->priv->thumbnailer_pid;
#line 274 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp29_ = waitpid ((pid_t) _tmp27_, &_tmp28_, 0);
#line 274 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	child_status = _tmp28_;
#line 274 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	ret_waitpid = (gint) _tmp29_;
#line 275 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp30_ = ret_waitpid;
#line 275 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp30_ < 0) {
#line 3617 "VideoSupport.c"
		gint _tmp31_;
#line 276 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp31_ = ret_waitpid;
#line 276 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:276: waitpid returned error code: %d", _tmp31_);
#line 277 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (buf);
#line 277 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		buf = NULL;
#line 3627 "VideoSupport.c"
	} else {
		gint _tmp32_;
		gint _tmp33_;
#line 278 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp32_ = child_status;
#line 278 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp33_ = WEXITSTATUS (_tmp32_);
#line 278 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (0 != _tmp33_) {
#line 3637 "VideoSupport.c"
			gint _tmp34_;
			gint _tmp35_;
#line 279 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp34_ = child_status;
#line 279 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp35_ = WEXITSTATUS (_tmp34_);
#line 279 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_debug ("VideoSupport.vala:279: Thumbnailer exited with error code: %d", _tmp35_);
#line 281 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (buf);
#line 281 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			buf = NULL;
#line 3650 "VideoSupport.c"
		}
	}
#line 284 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp36_ = self->priv->thumbnailer_pid;
#line 284 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_spawn_close_pid (_tmp36_);
#line 285 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->thumbnailer_pid = (GPid) 0;
#line 286 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = buf;
#line 286 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 286 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3665 "VideoSupport.c"
}


static gboolean video_reader_does_file_exist (VideoReader* self) {
	gboolean result = FALSE;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
#line 289 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), FALSE);
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->file;
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = g_file_test (_tmp2_, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_REGULAR);
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp2_);
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp4_;
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3694 "VideoSupport.c"
}


GdkPixbuf* video_reader_read_preview_frame (VideoReader* self) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	gboolean _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
#line 293 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
#line 294 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->preview_frame;
#line 294 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_ != NULL) {
#line 3715 "VideoSupport.c"
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
#line 295 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->priv->preview_frame;
#line 295 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 295 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = _tmp2_;
#line 295 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 3726 "VideoSupport.c"
	}
#line 297 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_reader_does_file_exist (self);
#line 297 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!_tmp3_) {
#line 298 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 298 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 3736 "VideoSupport.c"
	}
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = self->priv->file;
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = g_file_get_path (_tmp4_);
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = _tmp5_;
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = video_reader_thumbnailer (self, _tmp6_);
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->preview_frame);
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->preview_frame = _tmp7_;
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp6_);
#line 302 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = self->priv->preview_frame;
#line 302 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (NULL == _tmp8_) {
#line 3756 "VideoSupport.c"
		GdkPixbuf* _tmp9_;
#line 303 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = resources_get_noninterpretable_badge_pixbuf ();
#line 303 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (self->priv->preview_frame);
#line 303 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		self->priv->preview_frame = _tmp9_;
#line 3764 "VideoSupport.c"
	}
#line 305 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10_ = self->priv->preview_frame;
#line 305 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 305 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp11_;
#line 305 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3774 "VideoSupport.c"
}


gdouble video_reader_read_clip_duration (VideoReader* self, GError** error) {
	gdouble result = 0.0;
	gdouble _tmp0_;
	gdouble _tmp3_;
	GError * _inner_error_ = NULL;
#line 308 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), 0.0);
#line 309 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->clip_duration;
#line 309 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_ == VIDEO_READER_UNKNOWN_CLIP_DURATION) {
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_read_internal (self, &_inner_error_);
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == VIDEO_ERROR) {
#line 3795 "VideoSupport.c"
				gdouble _tmp1_ = 0.0;
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_propagate_error (error, _inner_error_);
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp1_;
#line 3801 "VideoSupport.c"
			} else {
				gdouble _tmp2_ = 0.0;
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp2_;
#line 3810 "VideoSupport.c"
			}
		}
	}
#line 312 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = self->priv->clip_duration;
#line 312 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp3_;
#line 312 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3820 "VideoSupport.c"
}


VideoMetadata* video_reader_read_metadata (VideoReader* self, GError** error) {
	VideoMetadata* result = NULL;
	VideoMetadata* metadata = NULL;
	VideoMetadata* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError * _inner_error_ = NULL;
#line 315 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_metadata_new ();
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	metadata = _tmp0_;
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = self->priv->file;
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_file_get_path (_tmp1_);
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = g_file_new_for_path (_tmp3_);
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = _tmp4_;
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (metadata, TYPE_MEDIA_METADATA, MediaMetadata), _tmp5_, &_inner_error_);
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp5_);
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp3_);
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_media_metadata_unref0 (metadata);
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 3864 "VideoSupport.c"
	}
#line 319 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = metadata;
#line 319 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3870 "VideoSupport.c"
}


GDateTime* video_reader_get_timestamp (VideoReader* self) {
	GDateTime* result;
	GDateTime* _tmp0_;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->_timestamp;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3885 "VideoSupport.c"
}


static gpointer _g_date_time_ref0 (gpointer self) {
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? g_date_time_ref (self) : NULL;
#line 3892 "VideoSupport.c"
}


static void video_reader_set_timestamp (VideoReader* self, GDateTime* value) {
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_READER (self));
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = value;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_date_time_unref0 (self->priv->_timestamp);
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->_timestamp = _tmp1_;
#line 3909 "VideoSupport.c"
}


static void value_video_reader_init (GValue* value) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	value->data[0].v_pointer = NULL;
#line 3916 "VideoSupport.c"
}


static void value_video_reader_free_value (GValue* value) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (value->data[0].v_pointer) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_unref (value->data[0].v_pointer);
#line 3925 "VideoSupport.c"
	}
}


static void value_video_reader_copy_value (const GValue* src_value, GValue* dest_value) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (src_value->data[0].v_pointer) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = video_reader_ref (src_value->data[0].v_pointer);
#line 3935 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3939 "VideoSupport.c"
	}
}


static gpointer value_video_reader_peek_pointer (const GValue* value) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 3947 "VideoSupport.c"
}


static gchar* value_video_reader_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (collect_values[0].v_pointer) {
#line 3954 "VideoSupport.c"
		VideoReader * object;
		object = collect_values[0].v_pointer;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (object->parent_instance.g_class == NULL) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3961 "VideoSupport.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3965 "VideoSupport.c"
		}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = video_reader_ref (object);
#line 3969 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 3973 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 3977 "VideoSupport.c"
}


static gchar* value_video_reader_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	VideoReader ** object_p;
	object_p = collect_values[0].v_pointer;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!object_p) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3988 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!value->data[0].v_pointer) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = NULL;
#line 3994 "VideoSupport.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = value->data[0].v_pointer;
#line 3998 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = video_reader_ref (value->data[0].v_pointer);
#line 4002 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 4006 "VideoSupport.c"
}


GParamSpec* param_spec_video_reader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecVideoReader* spec;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIDEO_READER), NULL);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return G_PARAM_SPEC (spec);
#line 4020 "VideoSupport.c"
}


gpointer value_get_video_reader (const GValue* value) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER), NULL);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 4029 "VideoSupport.c"
}


void value_set_video_reader (GValue* value, gpointer v_object) {
	VideoReader * old;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_READER));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_ref (value->data[0].v_pointer);
#line 4049 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 4053 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_unref (old);
#line 4059 "VideoSupport.c"
	}
}


void value_take_video_reader (GValue* value, gpointer v_object) {
	VideoReader * old;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_READER));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 4078 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 4082 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_unref (old);
#line 4088 "VideoSupport.c"
	}
}


static void video_reader_class_init (VideoReaderClass * klass) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_reader_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((VideoReaderClass *) klass)->finalize = video_reader_finalize;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_type_class_add_private (klass, sizeof (VideoReaderPrivate));
#line 4100 "VideoSupport.c"
}


static void video_reader_instance_init (VideoReader * self) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv = VIDEO_READER_GET_PRIVATE (self);
#line 45 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->clip_duration = VIDEO_READER_UNKNOWN_CLIP_DURATION;
#line 46 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->preview_frame = NULL;
#line 47 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->file = NULL;
#line 48 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->thumbnailer_pid = (GPid) 0;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->_timestamp = NULL;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->ref_count = 1;
#line 4119 "VideoSupport.c"
}


static void video_reader_finalize (VideoReader * obj) {
	VideoReader * self;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_READER, VideoReader);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_handlers_destroy (self);
#line 46 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->preview_frame);
#line 47 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->file);
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_date_time_unref0 (self->priv->_timestamp);
#line 4135 "VideoSupport.c"
}


GType video_reader_get_type (void) {
	static volatile gsize video_reader_type_id__volatile = 0;
	if (g_once_init_enter (&video_reader_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_video_reader_init, value_video_reader_free_value, value_video_reader_copy_value, value_video_reader_peek_pointer, "p", value_video_reader_collect_value, "p", value_video_reader_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (VideoReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoReader), 0, (GInstanceInitFunc) video_reader_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType video_reader_type_id;
		video_reader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoReader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&video_reader_type_id__volatile, video_reader_type_id);
	}
	return video_reader_type_id__volatile;
}


gpointer video_reader_ref (gpointer instance) {
	VideoReader * self;
	self = instance;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_atomic_int_inc (&self->ref_count);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return instance;
#line 4160 "VideoSupport.c"
}


void video_reader_unref (gpointer instance) {
	VideoReader * self;
	self = instance;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		VIDEO_READER_GET_CLASS (self)->finalize (self);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4173 "VideoSupport.c"
	}
}


static gpointer _video_row_ref0 (gpointer self) {
#line 367 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? video_row_ref (self) : NULL;
#line 4181 "VideoSupport.c"
}


Video* video_construct (GType object_type, VideoRow* row) {
	Video * self = NULL;
	VideoRow* _tmp0_;
	VideoRow* _tmp1_;
	VideoRow* _tmp2_;
	VideoRow* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	VideoRow* _tmp7_;
	guint64 _tmp8_;
#line 366 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_ROW (row), NULL);
#line 366 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (Video*) video_source_construct (object_type);
#line 367 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = row;
#line 367 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _video_row_ref0 (_tmp0_);
#line 367 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_row_unref0 (self->priv->backing_row);
#line 367 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->backing_row = _tmp1_;
#line 370 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = self->priv->backing_row;
#line 370 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = self->priv->backing_row;
#line 370 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_->title;
#line 370 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = media_source_prep_title (_tmp4_);
#line 370 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp2_->title);
#line 370 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_->title = _tmp5_;
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = row;
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = _tmp7_->flags;
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if ((_tmp8_ & VIDEO_FLAG_TRASH) != ((guint64) 0)) {
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = TRUE;
#line 4228 "VideoSupport.c"
	} else {
		VideoRow* _tmp9_;
		guint64 _tmp10_;
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = row;
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = _tmp9_->flags;
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = (_tmp10_ & VIDEO_FLAG_OFFLINE) != ((guint64) 0);
#line 4238 "VideoSupport.c"
	}
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp6_) {
#line 4242 "VideoSupport.c"
		VideoSourceCollection* _tmp11_;
		VideoRow* _tmp12_;
		const gchar* _tmp13_;
#line 373 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = video_global;
#line 373 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = row;
#line 373 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp13_ = _tmp12_->backlinks;
#line 373 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		data_source_rehydrate_backlinks (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp13_);
#line 4254 "VideoSupport.c"
	}
#line 366 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 4258 "VideoSupport.c"
}


Video* video_new (VideoRow* row) {
#line 366 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_construct (TYPE_VIDEO, row);
#line 4265 "VideoSupport.c"
}


static gboolean __lambda12_ (GstPluginFeature* f) {
	gboolean result = FALSE;
	GstPluginFeature* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
#line 407 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (GST_IS_PLUGIN_FEATURE (f), FALSE);
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = f;
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = gst_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gst_object_get_type (), GstObject));
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = g_str_has_prefix (_tmp2_, "vaapi");
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp2_);
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp4_;
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 4294 "VideoSupport.c"
}


static gboolean ___lambda12__gst_plugin_feature_filter (GstPluginFeature* feature, gpointer self) {
	gboolean result;
	result = __lambda12_ (feature);
#line 407 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 4303 "VideoSupport.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 4310 "VideoSupport.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_list_free (self);
#line 4319 "VideoSupport.c"
}


void video_init (ProgressMonitor monitor, void* monitor_target) {
	gchar** args = NULL;
	gint args_length1;
	gint _args_size_;
	GstRegistry* registry = NULL;
	GstRegistry* _tmp0_;
	GstRegistry* _tmp1_;
	gint saved_state = 0;
	ConfigFacade* _tmp2_;
	ConfigFacade* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GstRegistry* _tmp6_;
	guint32 _tmp7_;
	gint _tmp8_;
	GList* features = NULL;
	GstRegistry* _tmp11_;
	GList* _tmp12_;
	GList* _tmp13_;
	VideoSourceCollection* _tmp20_;
	GeeArrayList* all = NULL;
	VideoTable* _tmp21_;
	VideoTable* _tmp22_;
	GeeArrayList* _tmp23_;
	GeeArrayList* _tmp24_;
	GeeArrayList* all_videos = NULL;
	GeeArrayList* _tmp25_;
	GeeArrayList* trashed_videos = NULL;
	GeeArrayList* _tmp26_;
	GeeArrayList* offline_videos = NULL;
	GeeArrayList* _tmp27_;
	gint count = 0;
	GeeArrayList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	VideoSourceCollection* _tmp57_;
	GeeArrayList* _tmp58_;
	VideoSourceCollection* _tmp59_;
	GeeArrayList* _tmp60_;
	VideoSourceCollection* _tmp61_;
	GeeArrayList* _tmp62_;
	GeeCollection* _tmp63_;
	GeeCollection* _tmp64_;
#line 380 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_interpreter_state_changed = FALSE;
#line 381 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_current_state = -1;
#line 382 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_normal_regen_complete = FALSE;
#line 383 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_offline_regen_complete = FALSE;
#line 387 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	args = NULL;
#line 387 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	args_length1 = 0;
#line 387 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_args_size_ = args_length1;
#line 388 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	gst_init (&args_length1, &args);
#line 390 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = gst_registry_get ();
#line 390 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 390 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	registry = _tmp1_;
#line 391 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = config_facade_get_instance ();
#line 391 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 391 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = configuration_facade_get_video_interpreter_state_cookie (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 391 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = _tmp4_;
#line 391 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp3_);
#line 391 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	saved_state = _tmp5_;
#line 392 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = registry;
#line 392 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = gst_registry_get_feature_list_cookie (_tmp6_);
#line 392 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_current_state = (gint) _tmp7_;
#line 393 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = saved_state;
#line 393 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp8_ == CONFIG_FACADE_NO_VIDEO_INTERPRETER_STATE) {
#line 394 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_message ("VideoSupport.vala:394: interpreter state cookie not found; assuming al" \
"l video thumbnails are out of date");
#line 395 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpreter_state_changed = TRUE;
#line 4414 "VideoSupport.c"
	} else {
		gint _tmp9_;
		gint _tmp10_;
#line 396 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = saved_state;
#line 396 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = video_current_state;
#line 396 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp9_ != _tmp10_) {
#line 397 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_message ("VideoSupport.vala:397: interpreter state has changed; video thumbnails" \
" may be out of date");
#line 398 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_interpreter_state_changed = TRUE;
#line 4428 "VideoSupport.c"
		}
	}
#line 407 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp11_ = registry;
#line 407 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp12_ = gst_registry_feature_filter (_tmp11_, ___lambda12__gst_plugin_feature_filter, FALSE, NULL);
#line 407 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	features = _tmp12_;
#line 411 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = features;
#line 4439 "VideoSupport.c"
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
#line 411 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		feature_collection = _tmp13_;
#line 411 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
#line 4447 "VideoSupport.c"
			GstPluginFeature* _tmp14_;
			GstPluginFeature* feature = NULL;
#line 411 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp14_ = _g_object_ref0 ((GstPluginFeature*) feature_it->data);
#line 411 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			feature = _tmp14_;
#line 4454 "VideoSupport.c"
			{
				GstPluginFeature* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				GstRegistry* _tmp18_;
				GstPluginFeature* _tmp19_;
#line 412 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_ = feature;
#line 412 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = gst_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gst_object_get_type (), GstObject));
#line 412 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = _tmp16_;
#line 412 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_debug ("VideoSupport.vala:412: Removing registry feature %s", _tmp17_);
#line 412 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (_tmp17_);
#line 413 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp18_ = registry;
#line 413 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp19_ = feature;
#line 413 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				gst_registry_remove_feature (_tmp18_, _tmp19_);
#line 411 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (feature);
#line 4479 "VideoSupport.c"
			}
		}
	}
#line 416 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = video_source_collection_new ();
#line 416 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_data_collection_unref0 (video_global);
#line 416 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_global = _tmp20_;
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp21_ = video_table_get_instance ();
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp22_ = _tmp21_;
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_ = video_table_get_all (_tmp22_);
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = _tmp23_;
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_database_table_unref0 (_tmp22_);
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	all = _tmp24_;
#line 419 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp25_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 419 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	all_videos = _tmp25_;
#line 420 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp26_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 420 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	trashed_videos = _tmp26_;
#line 421 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 421 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	offline_videos = _tmp27_;
#line 422 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp28_ = all;
#line 422 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp29_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 422 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp30_ = _tmp29_;
#line 422 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	count = _tmp30_;
#line 4521 "VideoSupport.c"
	{
		gint ctr = 0;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		ctr = 0;
#line 4526 "VideoSupport.c"
		{
			gboolean _tmp31_ = FALSE;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp31_ = TRUE;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			while (TRUE) {
#line 4533 "VideoSupport.c"
				gint _tmp33_;
				gint _tmp34_;
				Video* video = NULL;
				GeeArrayList* _tmp35_;
				gint _tmp36_;
				gpointer _tmp37_;
				VideoRow* _tmp38_;
				Video* _tmp39_;
				Video* _tmp40_;
				gboolean _tmp41_;
				Video* _tmp43_;
				gboolean _tmp44_;
				ProgressMonitor _tmp53_;
				void* _tmp53__target;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!_tmp31_) {
#line 4550 "VideoSupport.c"
					gint _tmp32_;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp32_ = ctr;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					ctr = _tmp32_ + 1;
#line 4556 "VideoSupport.c"
				}
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp31_ = FALSE;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp33_ = ctr;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp34_ = count;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!(_tmp33_ < _tmp34_)) {
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					break;
#line 4568 "VideoSupport.c"
				}
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp35_ = all;
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp36_ = ctr;
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp37_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp36_);
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp38_ = (VideoRow*) _tmp37_;
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp39_ = video_new (_tmp38_);
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp40_ = _tmp39_;
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_video_row_unref0 (_tmp38_);
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video = _tmp40_;
#line 426 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp41_ = video_interpreter_state_changed;
#line 426 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_tmp41_) {
#line 4590 "VideoSupport.c"
					Video* _tmp42_;
#line 427 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp42_ = video;
#line 427 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					video_set_is_interpretable (_tmp42_, FALSE);
#line 4596 "VideoSupport.c"
				}
#line 429 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp43_ = video;
#line 429 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp44_ = media_source_is_trashed (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, TYPE_MEDIA_SOURCE, MediaSource));
#line 429 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_tmp44_) {
#line 4604 "VideoSupport.c"
					GeeArrayList* _tmp45_;
					Video* _tmp46_;
#line 430 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp45_ = trashed_videos;
#line 430 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp46_ = video;
#line 430 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp46_);
#line 4613 "VideoSupport.c"
				} else {
					Video* _tmp47_;
					gboolean _tmp48_;
#line 431 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp47_ = video;
#line 431 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp48_ = media_source_is_offline (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_MEDIA_SOURCE, MediaSource));
#line 431 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_tmp48_) {
#line 4623 "VideoSupport.c"
						GeeArrayList* _tmp49_;
						Video* _tmp50_;
#line 432 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp49_ = offline_videos;
#line 432 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp50_ = video;
#line 432 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp50_);
#line 4632 "VideoSupport.c"
					} else {
						GeeArrayList* _tmp51_;
						Video* _tmp52_;
#line 434 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp51_ = all_videos;
#line 434 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp52_ = video;
#line 434 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp52_);
#line 4642 "VideoSupport.c"
					}
				}
#line 436 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp53_ = monitor;
#line 436 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp53__target = monitor_target;
#line 436 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_tmp53_ != NULL) {
#line 4651 "VideoSupport.c"
					ProgressMonitor _tmp54_;
					void* _tmp54__target;
					gint _tmp55_;
					gint _tmp56_;
#line 437 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp54_ = monitor;
#line 437 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp54__target = monitor_target;
#line 437 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp55_ = ctr;
#line 437 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp56_ = count;
#line 437 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp54_ ((guint64) _tmp55_, (guint64) _tmp56_, TRUE, _tmp54__target);
#line 4666 "VideoSupport.c"
				}
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 4670 "VideoSupport.c"
			}
		}
	}
#line 440 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp57_ = video_global;
#line 440 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp58_ = trashed_videos;
#line 440 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	media_source_collection_add_many_to_trash (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GEE_TYPE_COLLECTION, GeeCollection));
#line 441 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp59_ = video_global;
#line 441 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp60_ = offline_videos;
#line 441 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	media_source_collection_add_many_to_offline (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, GEE_TYPE_COLLECTION, GeeCollection));
#line 442 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp61_ = video_global;
#line 442 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp62_ = all_videos;
#line 442 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp63_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
#line 442 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp64_ = _tmp63_;
#line 442 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp64_);
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (offline_videos);
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (trashed_videos);
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (all_videos);
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (all);
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	__g_list_free__g_object_unref0_0 (features);
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (registry);
#line 4708 "VideoSupport.c"
}


gboolean video_has_interpreter_state_changed (void) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 446 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_interpreter_state_changed;
#line 446 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 446 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 4721 "VideoSupport.c"
}


void video_notify_normal_thumbs_regenerated (void) {
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
#line 450 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_normal_regen_complete;
#line 450 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 451 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 4735 "VideoSupport.c"
	}
#line 453 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_message ("VideoSupport.vala:453: normal video thumbnail regeneration completed");
#line 455 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_normal_regen_complete = TRUE;
#line 456 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = video_normal_regen_complete;
#line 456 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp2_) {
#line 4745 "VideoSupport.c"
		gboolean _tmp3_;
#line 456 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = video_offline_regen_complete;
#line 456 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp3_;
#line 4751 "VideoSupport.c"
	} else {
#line 456 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = FALSE;
#line 4755 "VideoSupport.c"
	}
#line 456 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_) {
#line 457 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_save_interpreter_state ();
#line 4761 "VideoSupport.c"
	}
}


void video_notify_offline_thumbs_regenerated (void) {
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
#line 461 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_offline_regen_complete;
#line 461 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 462 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 4776 "VideoSupport.c"
	}
#line 464 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_message ("VideoSupport.vala:464: offline video thumbnail regeneration completed");
#line 466 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_offline_regen_complete = TRUE;
#line 467 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = video_normal_regen_complete;
#line 467 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp2_) {
#line 4786 "VideoSupport.c"
		gboolean _tmp3_;
#line 467 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = video_offline_regen_complete;
#line 467 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp3_;
#line 4792 "VideoSupport.c"
	} else {
#line 467 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = FALSE;
#line 4796 "VideoSupport.c"
	}
#line 467 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_) {
#line 468 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_save_interpreter_state ();
#line 4802 "VideoSupport.c"
	}
}


static void video_save_interpreter_state (void) {
	gboolean _tmp0_;
#line 472 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_interpreter_state_changed;
#line 472 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 4813 "VideoSupport.c"
		ConfigFacade* _tmp1_;
		ConfigFacade* _tmp2_;
		gint _tmp3_;
#line 473 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_message ("VideoSupport.vala:473: saving video interpreter state to configuration" \
" system");
#line 475 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = config_facade_get_instance ();
#line 475 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _tmp1_;
#line 475 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = video_current_state;
#line 475 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		configuration_facade_set_video_interpreter_state_cookie (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp3_);
#line 475 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp2_);
#line 476 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpreter_state_changed = FALSE;
#line 4831 "VideoSupport.c"
	}
}


void video_terminate (void) {
}


ExporterUI* video_export_many (GeeCollection* videos, ExporterCompletionCallback done, void* done_target, gboolean export_in_place) {
	ExporterUI* result = NULL;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	GeeCollection* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GFile* export_dir = NULL;
	GFile* _tmp39_;
	GFile* _tmp40_;
	ExporterUI* exporter = NULL;
	GeeCollection* _tmp41_;
	GFile* _tmp42_;
	Scaling _tmp43_ = {0};
	ExportFormatParameters _tmp44_ = {0};
	Exporter* _tmp45_;
	Exporter* _tmp46_;
	ExporterUI* _tmp47_;
	ExporterUI* _tmp48_;
	ExporterUI* _tmp49_;
	ExporterCompletionCallback _tmp50_;
	void* _tmp50__target;
	GError * _inner_error_ = NULL;
#line 483 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (videos), NULL);
#line 485 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = videos;
#line 485 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 485 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 485 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp2_ == 0) {
#line 486 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 486 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 4879 "VideoSupport.c"
	}
#line 489 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = export_in_place;
#line 489 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp3_) {
#line 4885 "VideoSupport.c"
		ExporterUI* temp_exporter = NULL;
		GeeCollection* _tmp4_;
		Scaling _tmp5_ = {0};
		ExportFormatParameters _tmp6_ = {0};
		Exporter* _tmp7_;
		Exporter* _tmp8_;
		ExporterUI* _tmp9_;
		ExporterUI* _tmp10_;
		ExporterUI* _tmp11_;
		ExporterCompletionCallback _tmp12_;
		void* _tmp12__target;
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = videos;
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		scaling_for_original (&_tmp5_);
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		export_format_parameters_unmodified (&_tmp6_);
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = exporter_new_for_temp_file (_tmp4_, &_tmp5_, &_tmp6_);
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = _tmp7_;
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = exporter_ui_new (_tmp8_);
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = _tmp9_;
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp8_);
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		temp_exporter = _tmp10_;
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = temp_exporter;
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = done;
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12__target = done_target;
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		exporter_ui_export (_tmp11_, _tmp12_, _tmp12__target);
#line 493 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = temp_exporter;
#line 493 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 4927 "VideoSupport.c"
	}
#line 497 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = videos;
#line 497 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp14_ = gee_collection_get_size (_tmp13_);
#line 497 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp15_ = _tmp14_;
#line 497 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp15_ == 1) {
#line 4937 "VideoSupport.c"
		Video* video = NULL;
		GFile* save_as = NULL;
		Video* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		GFile* _tmp27_;
		GFile* _tmp28_;
		GFile* _tmp29_;
#line 498 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video = NULL;
#line 4948 "VideoSupport.c"
		{
			GeeIterator* _v_it = NULL;
			GeeCollection* _tmp16_;
			GeeIterator* _tmp17_;
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_ = videos;
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ITERABLE, GeeIterable));
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_v_it = _tmp17_;
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			while (TRUE) {
#line 4961 "VideoSupport.c"
				GeeIterator* _tmp18_;
				gboolean _tmp19_;
				Video* v = NULL;
				GeeIterator* _tmp20_;
				gpointer _tmp21_;
				Video* _tmp22_;
				Video* _tmp23_;
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp18_ = _v_it;
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp19_ = gee_iterator_next (_tmp18_);
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!_tmp19_) {
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					break;
#line 4977 "VideoSupport.c"
				}
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp20_ = _v_it;
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp21_ = gee_iterator_get (_tmp20_);
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				v = (Video*) _tmp21_;
#line 500 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp22_ = v;
#line 500 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp23_ = _g_object_ref0 (_tmp22_);
#line 500 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 500 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video = _tmp23_;
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (v);
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				break;
#line 4997 "VideoSupport.c"
			}
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_v_it);
#line 5001 "VideoSupport.c"
		}
#line 504 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp24_ = video;
#line 504 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp25_ = media_source_get_basename (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_MEDIA_SOURCE, MediaSource));
#line 504 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp26_ = _tmp25_;
#line 504 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp27_ = export_ui_choose_file (_tmp26_);
#line 504 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp28_ = _tmp27_;
#line 504 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp26_);
#line 504 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		save_as = _tmp28_;
#line 505 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp29_ = save_as;
#line 505 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp29_ == NULL) {
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = NULL;
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (save_as);
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (video);
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 5029 "VideoSupport.c"
		}
		{
			AppWindow* _tmp30_;
			AppWindow* _tmp31_;
			Video* _tmp32_;
			GFile* _tmp33_;
			AppWindow* _tmp34_;
			AppWindow* _tmp35_;
#line 509 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp30_ = app_window_get_instance ();
#line 509 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp31_ = _tmp30_;
#line 509 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			page_window_set_busy_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_PAGE_WINDOW, PageWindow));
#line 509 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_tmp31_);
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp32_ = video;
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp33_ = save_as;
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_export (_tmp32_, _tmp33_, &_inner_error_);
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5054 "VideoSupport.c"
				goto __catch510_g_error;
			}
#line 511 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp34_ = app_window_get_instance ();
#line 511 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp35_ = _tmp34_;
#line 511 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, TYPE_PAGE_WINDOW, PageWindow));
#line 511 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_tmp35_);
#line 5065 "VideoSupport.c"
		}
		goto __finally510;
		__catch510_g_error:
		{
			GError* err = NULL;
			AppWindow* _tmp36_;
			AppWindow* _tmp37_;
			GFile* _tmp38_;
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			err = _inner_error_;
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_inner_error_ = NULL;
#line 513 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp36_ = app_window_get_instance ();
#line 513 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp37_ = _tmp36_;
#line 513 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, TYPE_PAGE_WINDOW, PageWindow));
#line 513 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_tmp37_);
#line 514 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp38_ = save_as;
#line 514 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			export_error_dialog (_tmp38_, FALSE);
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_error_free0 (err);
#line 5092 "VideoSupport.c"
		}
		__finally510:
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (save_as);
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (video);
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return NULL;
#line 5107 "VideoSupport.c"
		}
#line 517 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 517 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (save_as);
#line 517 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (video);
#line 517 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 5117 "VideoSupport.c"
	}
#line 521 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp39_ = export_ui_choose_dir (_ ("Export Videos"));
#line 521 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	export_dir = _tmp39_;
#line 522 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp40_ = export_dir;
#line 522 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp40_ == NULL) {
#line 523 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 523 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (export_dir);
#line 523 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 5133 "VideoSupport.c"
	}
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp41_ = videos;
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp42_ = export_dir;
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	scaling_for_original (&_tmp43_);
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	export_format_parameters_unmodified (&_tmp44_);
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp45_ = exporter_new (_tmp41_, _tmp42_, &_tmp43_, &_tmp44_, FALSE);
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp46_ = _tmp45_;
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp47_ = exporter_ui_new (_tmp46_);
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp48_ = _tmp47_;
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp46_);
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	exporter = _tmp48_;
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp49_ = exporter;
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp50_ = done;
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp50__target = done_target;
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	exporter_ui_export (_tmp49_, _tmp50_, _tmp50__target);
#line 529 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = exporter;
#line 529 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (export_dir);
#line 529 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5169 "VideoSupport.c"
}


static void video_real_commit_backlinks (DataSource* base, SourceCollection* sources, const gchar* backlinks) {
	Video * self;
	GError * _inner_error_ = NULL;
#line 532 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 532 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((sources == NULL) || IS_SOURCE_COLLECTION (sources));
#line 5180 "VideoSupport.c"
	{
		VideoTable* _tmp0_;
		VideoTable* _tmp1_;
		VideoID _tmp2_ = {0};
		const gchar* _tmp3_;
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = video_table_get_instance ();
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp0_;
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_get_video_id (self, &_tmp2_);
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = backlinks;
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_update_backlinks (_tmp1_, &_tmp2_, _tmp3_, &_inner_error_);
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp1_);
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 5202 "VideoSupport.c"
				goto __catch511_database_error;
			}
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 5211 "VideoSupport.c"
		}
		{
			VideoRow* _tmp4_;
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 5219 "VideoSupport.c"
			{
				VideoRow* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = self->priv->backing_row;
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = backlinks;
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = g_strdup (_tmp6_);
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (_tmp5_->backlinks);
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_->backlinks = _tmp7_;
#line 5234 "VideoSupport.c"
			}
			__finally512:
			{
				VideoRow* _tmp8_;
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = self->priv->backing_row;
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5243 "VideoSupport.c"
			}
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 5249 "VideoSupport.c"
					goto __catch511_database_error;
				}
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 5258 "VideoSupport.c"
			}
		}
	}
	goto __finally511;
	__catch511_database_error:
	{
		GError* err = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 533 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 533 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 539 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 539 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = _tmp9_;
#line 539 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = err;
#line 539 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = _tmp11_->message;
#line 539 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_warning ("VideoSupport.vala:539: Unable to update link state for %s: %s", _tmp10_, _tmp12_);
#line 539 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp10_);
#line 533 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 5288 "VideoSupport.c"
	}
	__finally511:
#line 533 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 533 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 533 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 533 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 5299 "VideoSupport.c"
	}
}


static gboolean video_real_set_event_id (MediaSource* base, EventID* event_id) {
	Video * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 543 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 543 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 5312 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
		gboolean _tmp13_ = FALSE;
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 5320 "VideoSupport.c"
		{
			gboolean committed = FALSE;
			VideoTable* _tmp1_;
			VideoTable* _tmp2_;
			VideoRow* _tmp3_;
			VideoID _tmp4_;
			EventID _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = video_table_get_instance ();
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_;
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _tmp3_->video_id;
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = *event_id;
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = video_table_set_event (_tmp2_, &_tmp4_, &_tmp5_);
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = _tmp6_;
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_database_table_unref0 (_tmp2_);
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			committed = _tmp7_;
#line 547 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = committed;
#line 547 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp8_) {
#line 5353 "VideoSupport.c"
				VideoRow* _tmp9_;
				EventID _tmp10_;
#line 548 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = self->priv->backing_row;
#line 548 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = *event_id;
#line 548 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_->event_id = _tmp10_;
#line 5362 "VideoSupport.c"
			}
#line 550 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = committed;
#line 5366 "VideoSupport.c"
			{
				VideoRow* _tmp11_;
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = self->priv->backing_row;
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5373 "VideoSupport.c"
			}
#line 550 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 5377 "VideoSupport.c"
		}
		__finally513:
		{
			VideoRow* _tmp12_;
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = self->priv->backing_row;
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5386 "VideoSupport.c"
		}
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp13_;
#line 5394 "VideoSupport.c"
	}
}


gboolean video_is_duplicate (GFile* file, const gchar* full_md5) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	VideoTable* _tmp3_;
	VideoTable* _tmp4_;
	GFile* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
#line 554 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), FALSE);
#line 555 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = file;
#line 555 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_ != NULL) {
#line 555 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = TRUE;
#line 5417 "VideoSupport.c"
	} else {
		const gchar* _tmp2_;
#line 555 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = full_md5;
#line 555 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 5424 "VideoSupport.c"
	}
#line 555 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_assert (_tmp0_, "file != null || full_md5 != null");
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_table_get_instance ();
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = file;
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = full_md5;
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = video_table_has_duplicate (_tmp4_, _tmp5_, _tmp6_);
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = _tmp7_;
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_database_table_unref0 (_tmp4_);
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp8_;
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5446 "VideoSupport.c"
}


ImportResult video_import_create (VideoImportParams* params, Video* * video) {
	Video* _vala_video = NULL;
	ImportResult result = 0;
	VideoImportParams* _tmp8_;
	VideoRow* _tmp9_;
	Video* _tmp10_;
	GError * _inner_error_ = NULL;
#line 563 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_IMPORT_PARAMS (params), 0);
#line 564 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_vala_video);
#line 564 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_video = NULL;
#line 5463 "VideoSupport.c"
	{
		VideoID _tmp0_ = {0};
		VideoTable* _tmp1_;
		VideoTable* _tmp2_;
		VideoImportParams* _tmp3_;
		VideoRow* _tmp4_;
		VideoID _tmp5_ = {0};
		VideoID _tmp6_;
		gboolean _tmp7_;
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = video_table_get_instance ();
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _tmp1_;
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = params;
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = _tmp3_->row;
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_add (_tmp2_, _tmp4_, &_tmp5_, &_inner_error_);
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = _tmp5_;
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp2_);
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = _tmp6_;
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 5493 "VideoSupport.c"
				goto __catch514_database_error;
			}
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return 0;
#line 5502 "VideoSupport.c"
		}
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = video_id_is_invalid (&_tmp0_);
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp7_) {
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = IMPORT_RESULT_DATABASE_ERROR;
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (video) {
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				*video = _vala_video;
#line 5514 "VideoSupport.c"
			} else {
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (_vala_video);
#line 5518 "VideoSupport.c"
			}
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 5522 "VideoSupport.c"
		}
	}
	goto __finally514;
	__catch514_database_error:
	{
		GError* err = NULL;
#line 567 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 567 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = IMPORT_RESULT_DATABASE_ERROR;
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (video) {
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*video = _vala_video;
#line 5541 "VideoSupport.c"
		} else {
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_vala_video);
#line 5545 "VideoSupport.c"
		}
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 5549 "VideoSupport.c"
	}
	__finally514:
#line 567 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 567 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 567 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 567 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 5560 "VideoSupport.c"
	}
#line 575 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = params;
#line 575 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_ = _tmp8_->row;
#line 575 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10_ = video_new (_tmp9_);
#line 575 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_vala_video);
#line 575 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_video = _tmp10_;
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = IMPORT_RESULT_SUCCESS;
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (video) {
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*video = _vala_video;
#line 5578 "VideoSupport.c"
	} else {
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_vala_video);
#line 5582 "VideoSupport.c"
	}
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5586 "VideoSupport.c"
}


void video_import_failed (Video* video) {
	GError * _inner_error_ = NULL;
#line 580 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (video));
#line 5594 "VideoSupport.c"
	{
		VideoTable* _tmp0_;
		VideoTable* _tmp1_;
		Video* _tmp2_;
		VideoID _tmp3_ = {0};
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = video_table_get_instance ();
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp0_;
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = video;
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_get_video_id (_tmp2_, &_tmp3_);
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_remove (_tmp1_, &_tmp3_, &_inner_error_);
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp1_);
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 5616 "VideoSupport.c"
				goto __catch515_database_error;
			}
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 5625 "VideoSupport.c"
		}
	}
	goto __finally515;
	__catch515_database_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
#line 581 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 581 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = err;
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		app_window_database_error (_tmp4_);
#line 581 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 5643 "VideoSupport.c"
	}
	__finally515:
#line 581 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 581 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 581 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 581 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 5654 "VideoSupport.c"
	}
}


static BackingFileState** video_real_get_backing_files_state (MediaSource* base, int* result_length1) {
	Video * self;
	BackingFileState** result = NULL;
	BackingFileState** backing = NULL;
	BackingFileState** _tmp0_;
	gint backing_length1;
	gint _backing_size_;
	BackingFileState** _tmp13_;
	gint _tmp13__length1;
	GError * _inner_error_ = NULL;
#line 588 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 589 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = g_new0 (BackingFileState*, 1 + 1);
#line 589 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	backing = _tmp0_;
#line 589 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	backing_length1 = 1;
#line 589 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_backing_size_ = backing_length1;
#line 5679 "VideoSupport.c"
	{
		VideoRow* _tmp1_;
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->priv->backing_row;
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 5686 "VideoSupport.c"
		{
			VideoRow* _tmp2_;
			const gchar* _tmp3_;
			VideoRow* _tmp4_;
			gint64 _tmp5_;
			VideoRow* _tmp6_;
			time_t _tmp7_;
			VideoRow* _tmp8_;
			const gchar* _tmp9_;
			BackingFileState* _tmp10_;
			BackingFileState* _tmp11_;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = self->priv->backing_row;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = _tmp2_->filepath;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = _tmp4_->filesize;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = self->priv->backing_row;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = _tmp6_->timestamp;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = self->priv->backing_row;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = _tmp8_->md5;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = backing_file_state_new (_tmp3_, _tmp5_, _tmp7_, _tmp9_);
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_backing_file_state_unref0 (backing[0]);
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			backing[0] = _tmp10_;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = backing[0];
#line 5722 "VideoSupport.c"
		}
		__finally516:
		{
			VideoRow* _tmp12_;
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = self->priv->backing_row;
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5731 "VideoSupport.c"
		}
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			backing = (_vala_array_free (backing, backing_length1, (GDestroyNotify) backing_file_state_unref), NULL);
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return NULL;
#line 5743 "VideoSupport.c"
		}
	}
#line 595 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = backing;
#line 595 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13__length1 = backing_length1;
#line 595 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (result_length1) {
#line 595 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*result_length1 = _tmp13__length1;
#line 5754 "VideoSupport.c"
	}
#line 595 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp13_;
#line 595 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5760 "VideoSupport.c"
}


static GdkPixbuf* video_real_get_thumbnail (ThumbnailSource* base, gint scale, GError** error) {
	Video * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	gint _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError * _inner_error_ = NULL;
#line 598 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = scale;
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = thumbnail_cache_fetch (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), _tmp1_, &_inner_error_);
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = _tmp2_;
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 5786 "VideoSupport.c"
	}
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp0_;
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = NULL;
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp3_;
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp0_);
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5798 "VideoSupport.c"
}


static gchar* video_real_get_master_md5 (MediaSource* base) {
	Video * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 602 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 5808 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 5815 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
#line 604 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 604 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->md5;
#line 604 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 604 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp3_;
#line 5828 "VideoSupport.c"
			{
				VideoRow* _tmp4_;
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = self->priv->backing_row;
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5835 "VideoSupport.c"
			}
#line 604 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 5839 "VideoSupport.c"
		}
		__finally517:
		{
			VideoRow* _tmp5_;
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5848 "VideoSupport.c"
		}
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 5856 "VideoSupport.c"
	}
}


static GdkPixbuf* video_real_get_preview_pixbuf (MediaSource* base, Scaling* scaling, GError** error) {
	Video * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GError * _inner_error_ = NULL;
#line 608 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 608 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 609 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = thumbnail_source_get_thumbnail (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), (gint) THUMBNAIL_CACHE_SIZE_BIG, &_inner_error_);
#line 609 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	pixbuf = _tmp0_;
#line 609 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 609 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 609 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 5882 "VideoSupport.c"
	}
#line 611 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = scaling_perform_on_pixbuf (scaling, pixbuf, GDK_INTERP_NEAREST, TRUE);
#line 611 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp1_;
#line 611 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (pixbuf);
#line 611 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5892 "VideoSupport.c"
}


static GdkPixbuf* video_real_create_thumbnail (ThumbnailSource* base, gint scale, GError** error) {
	Video * self;
	GdkPixbuf* result = NULL;
	VideoReader* reader = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	VideoReader* _tmp2_;
	VideoReader* _tmp3_;
	GdkPixbuf* frame = NULL;
	VideoReader* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_ = NULL;
	GdkPixbuf* _tmp7_;
#line 614 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 615 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 615 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 615 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = video_reader_new (_tmp1_);
#line 615 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 615 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp1_);
#line 615 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	reader = _tmp3_;
#line 616 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = reader;
#line 616 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = video_reader_read_preview_frame (_tmp4_);
#line 616 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	frame = _tmp5_;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = frame;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp7_ != NULL) {
#line 5933 "VideoSupport.c"
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = frame;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp6_);
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = _tmp9_;
#line 5944 "VideoSupport.c"
	} else {
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = resources_get_noninterpretable_badge_pixbuf ();
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = _tmp10_;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = gdk_pixbuf_copy (_tmp11_);
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp6_);
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = _tmp12_;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp11_);
#line 5961 "VideoSupport.c"
	}
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp6_;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (frame);
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_reader_unref0 (reader);
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5971 "VideoSupport.c"
}


static gchar* video_real_get_typename (DataSource* base) {
	Video * self;
	gchar* result = NULL;
	gchar* _tmp0_;
#line 621 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 622 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = g_strdup (VIDEO_TYPENAME);
#line 622 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 622 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5987 "VideoSupport.c"
}


static gint64 video_real_get_instance_id (DataSource* base) {
	Video * self;
	gint64 result = 0LL;
	VideoID _tmp0_ = {0};
	gint64 _tmp1_;
#line 625 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 626 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_get_video_id (self, &_tmp0_);
#line 626 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_.id;
#line 626 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp1_;
#line 626 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6006 "VideoSupport.c"
}


static void video_real_get_import_id (MediaSource* base, ImportID* result) {
	Video * self;
	GError * _inner_error_ = NULL;
#line 629 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6015 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6022 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			ImportID _tmp2_;
#line 631 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 631 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->import_id;
#line 631 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*result = _tmp2_;
#line 6032 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6039 "VideoSupport.c"
			}
#line 631 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 6043 "VideoSupport.c"
		}
		__finally518:
		{
			VideoRow* _tmp4_;
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6052 "VideoSupport.c"
		}
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 6060 "VideoSupport.c"
	}
}


static PhotoFileFormat video_real_get_preferred_thumbnail_format (ThumbnailSource* base) {
	Video * self;
	PhotoFileFormat result = 0;
	PhotoFileFormat _tmp0_;
#line 635 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 636 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = photo_file_format_get_system_default_format ();
#line 636 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 636 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6077 "VideoSupport.c"
}


static gchar* video_real_get_title (MediaSource* base) {
	Video * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 639 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6087 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6094 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
#line 641 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 641 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->title;
#line 641 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 641 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp3_;
#line 6107 "VideoSupport.c"
			{
				VideoRow* _tmp4_;
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = self->priv->backing_row;
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6114 "VideoSupport.c"
			}
#line 641 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 6118 "VideoSupport.c"
		}
		__finally519:
		{
			VideoRow* _tmp5_;
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6127 "VideoSupport.c"
		}
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 6135 "VideoSupport.c"
	}
}


static void video_real_set_title (MediaSource* base, const gchar* title) {
	Video * self;
	gchar* new_title = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	Alteration* _tmp20_;
	Alteration* _tmp21_;
	GError * _inner_error_ = NULL;
#line 645 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 646 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = title;
#line 646 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_prep_title (_tmp0_);
#line 646 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	new_title = _tmp1_;
#line 6156 "VideoSupport.c"
	{
		VideoRow* _tmp2_;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = self->priv->backing_row;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6163 "VideoSupport.c"
		{
			VideoRow* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			VideoRow* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
#line 649 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 649 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _tmp3_->title;
#line 649 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = new_title;
#line 649 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
#line 6179 "VideoSupport.c"
				{
					VideoRow* _tmp6_;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp6_ = self->priv->backing_row;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6186 "VideoSupport.c"
				}
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_title);
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6192 "VideoSupport.c"
			}
			{
				VideoTable* _tmp7_;
				VideoTable* _tmp8_;
				VideoRow* _tmp9_;
				VideoID _tmp10_;
				const gchar* _tmp11_;
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = video_table_get_instance ();
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = _tmp7_;
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = self->priv->backing_row;
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = _tmp9_->video_id;
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = new_title;
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_title (_tmp8_, &_tmp10_, _tmp11_, &_inner_error_);
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp8_);
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 6218 "VideoSupport.c"
						goto __catch521_database_error;
					}
					{
						VideoRow* _tmp12_;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp12_ = self->priv->backing_row;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6227 "VideoSupport.c"
					}
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (new_title);
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return;
#line 6237 "VideoSupport.c"
				}
			}
			goto __finally521;
			__catch521_database_error:
			{
				GError* e = NULL;
				GError* _tmp13_;
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = e;
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp13_);
#line 656 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 6255 "VideoSupport.c"
				{
					VideoRow* _tmp14_;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp14_ = self->priv->backing_row;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6262 "VideoSupport.c"
				}
#line 656 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_title);
#line 656 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6268 "VideoSupport.c"
			}
			__finally521:
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6273 "VideoSupport.c"
				{
					VideoRow* _tmp15_;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp15_ = self->priv->backing_row;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6280 "VideoSupport.c"
				}
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_title);
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6290 "VideoSupport.c"
			}
#line 660 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_ = self->priv->backing_row;
#line 660 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = new_title;
#line 660 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_ = g_strdup (_tmp17_);
#line 660 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (_tmp16_->title);
#line 660 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_->title = _tmp18_;
#line 6302 "VideoSupport.c"
		}
		__finally520:
		{
			VideoRow* _tmp19_;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp19_ = self->priv->backing_row;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6311 "VideoSupport.c"
		}
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (new_title);
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 6323 "VideoSupport.c"
		}
	}
#line 663 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = alteration_new ("metadata", "name");
#line 663 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp21_ = _tmp20_;
#line 663 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp21_);
#line 663 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp21_);
#line 645 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (new_title);
#line 6336 "VideoSupport.c"
}


static gchar* video_real_get_comment (MediaSource* base) {
	Video * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 666 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6346 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6353 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
#line 668 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 668 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->comment;
#line 668 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 668 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp3_;
#line 6366 "VideoSupport.c"
			{
				VideoRow* _tmp4_;
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = self->priv->backing_row;
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6373 "VideoSupport.c"
			}
#line 668 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 6377 "VideoSupport.c"
		}
		__finally522:
		{
			VideoRow* _tmp5_;
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6386 "VideoSupport.c"
		}
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 6394 "VideoSupport.c"
	}
}


static gboolean video_real_set_comment (MediaSource* base, const gchar* comment) {
	Video * self;
	gboolean result = FALSE;
	gchar* new_comment = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	Alteration* _tmp23_;
	Alteration* _tmp24_;
	GError * _inner_error_ = NULL;
#line 672 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 673 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = comment;
#line 673 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_prep_title (_tmp0_);
#line 673 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	new_comment = _tmp1_;
#line 6416 "VideoSupport.c"
	{
		VideoRow* _tmp2_;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = self->priv->backing_row;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6423 "VideoSupport.c"
		{
			VideoRow* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			VideoRow* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
#line 676 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 676 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _tmp3_->comment;
#line 676 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = new_comment;
#line 676 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = TRUE;
#line 6441 "VideoSupport.c"
				{
					VideoRow* _tmp6_;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp6_ = self->priv->backing_row;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6448 "VideoSupport.c"
				}
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_comment);
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 6454 "VideoSupport.c"
			}
			{
				VideoTable* _tmp7_;
				VideoTable* _tmp8_;
				VideoRow* _tmp9_;
				VideoID _tmp10_;
				const gchar* _tmp11_;
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = video_table_get_instance ();
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = _tmp7_;
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = self->priv->backing_row;
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = _tmp9_->video_id;
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = new_comment;
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_comment (_tmp8_, &_tmp10_, _tmp11_, &_inner_error_);
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp8_);
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6478 "VideoSupport.c"
					gboolean _tmp13_ = FALSE;
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 6482 "VideoSupport.c"
						goto __catch524_database_error;
					}
					{
						VideoRow* _tmp12_;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp12_ = self->priv->backing_row;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6491 "VideoSupport.c"
					}
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (new_comment);
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return _tmp13_;
#line 6501 "VideoSupport.c"
				}
			}
			goto __finally524;
			__catch524_database_error:
			{
				GError* e = NULL;
				GError* _tmp14_;
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = e;
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp14_);
#line 683 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = FALSE;
#line 683 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 6521 "VideoSupport.c"
				{
					VideoRow* _tmp15_;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp15_ = self->priv->backing_row;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6528 "VideoSupport.c"
				}
#line 683 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_comment);
#line 683 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 6534 "VideoSupport.c"
			}
			__finally524:
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6539 "VideoSupport.c"
				gboolean _tmp17_ = FALSE;
				{
					VideoRow* _tmp16_;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp16_ = self->priv->backing_row;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6547 "VideoSupport.c"
				}
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_comment);
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp17_;
#line 6557 "VideoSupport.c"
			}
#line 687 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_ = self->priv->backing_row;
#line 687 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp19_ = new_comment;
#line 687 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp20_ = g_strdup (_tmp19_);
#line 687 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (_tmp18_->comment);
#line 687 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_->comment = _tmp20_;
#line 6569 "VideoSupport.c"
		}
		__finally523:
		{
			VideoRow* _tmp21_;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_ = self->priv->backing_row;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6578 "VideoSupport.c"
		}
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6582 "VideoSupport.c"
			gboolean _tmp22_ = FALSE;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (new_comment);
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return _tmp22_;
#line 6592 "VideoSupport.c"
		}
	}
#line 690 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_ = alteration_new ("metadata", "comment");
#line 690 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = _tmp23_;
#line 690 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp24_);
#line 690 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp24_);
#line 692 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = TRUE;
#line 692 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (new_comment);
#line 692 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6609 "VideoSupport.c"
}


static Rating video_real_get_rating (MediaSource* base) {
	Video * self;
	Rating result = 0;
	GError * _inner_error_ = NULL;
#line 696 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6619 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6626 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			Rating _tmp2_;
#line 698 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 698 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->rating;
#line 698 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 6636 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6643 "VideoSupport.c"
			}
#line 698 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 6647 "VideoSupport.c"
		}
		__finally525:
		{
			VideoRow* _tmp4_;
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6656 "VideoSupport.c"
		}
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 6664 "VideoSupport.c"
	}
}


static void video_real_set_rating (MediaSource* base, Rating rating) {
	Video * self;
	Alteration* _tmp19_;
	Alteration* _tmp20_;
	GError * _inner_error_ = NULL;
#line 702 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6676 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6683 "VideoSupport.c"
		{
			gboolean _tmp1_ = FALSE;
			Rating _tmp2_;
			gboolean _tmp3_;
			VideoRow* _tmp16_;
			Rating _tmp17_;
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = rating;
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = rating_is_valid (_tmp2_);
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (!_tmp3_) {
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp1_ = TRUE;
#line 6698 "VideoSupport.c"
			} else {
				Rating _tmp4_;
				VideoRow* _tmp5_;
				Rating _tmp6_;
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = rating;
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = self->priv->backing_row;
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = _tmp5_->rating;
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp1_ = _tmp4_ == _tmp6_;
#line 6711 "VideoSupport.c"
			}
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp1_) {
#line 6715 "VideoSupport.c"
				{
					VideoRow* _tmp7_;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp7_ = self->priv->backing_row;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6722 "VideoSupport.c"
				}
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6726 "VideoSupport.c"
			}
			{
				VideoTable* _tmp8_;
				VideoTable* _tmp9_;
				VideoID _tmp10_ = {0};
				Rating _tmp11_;
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = video_table_get_instance ();
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = _tmp8_;
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_get_video_id (self, &_tmp10_);
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = rating;
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_rating (_tmp9_, &_tmp10_, _tmp11_, &_inner_error_);
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp9_);
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 6749 "VideoSupport.c"
						goto __catch527_database_error;
					}
					{
						VideoRow* _tmp12_;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp12_ = self->priv->backing_row;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6758 "VideoSupport.c"
					}
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return;
#line 6766 "VideoSupport.c"
				}
			}
			goto __finally527;
			__catch527_database_error:
			{
				GError* e = NULL;
				GError* _tmp13_;
#line 707 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 707 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = e;
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp13_);
#line 711 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 6784 "VideoSupport.c"
				{
					VideoRow* _tmp14_;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp14_ = self->priv->backing_row;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6791 "VideoSupport.c"
				}
#line 711 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6795 "VideoSupport.c"
			}
			__finally527:
#line 707 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6800 "VideoSupport.c"
				{
					VideoRow* _tmp15_;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp15_ = self->priv->backing_row;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6807 "VideoSupport.c"
				}
#line 707 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 707 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 707 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6815 "VideoSupport.c"
			}
#line 715 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_ = self->priv->backing_row;
#line 715 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = rating;
#line 715 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_->rating = _tmp17_;
#line 6823 "VideoSupport.c"
		}
		__finally526:
		{
			VideoRow* _tmp18_;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_ = self->priv->backing_row;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6832 "VideoSupport.c"
		}
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 6842 "VideoSupport.c"
		}
	}
#line 718 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp19_ = alteration_new ("metadata", "rating");
#line 718 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = _tmp19_;
#line 718 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp20_);
#line 718 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp20_);
#line 6853 "VideoSupport.c"
}


static void video_real_increase_rating (MediaSource* base) {
	Video * self;
	GError * _inner_error_ = NULL;
#line 721 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6862 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6869 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			Rating _tmp2_;
			Rating _tmp3_;
#line 723 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 723 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->rating;
#line 723 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = rating_increase (_tmp2_);
#line 723 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp3_);
#line 6882 "VideoSupport.c"
		}
		__finally528:
		{
			VideoRow* _tmp4_;
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6891 "VideoSupport.c"
		}
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 6901 "VideoSupport.c"
		}
	}
}


static void video_real_decrease_rating (MediaSource* base) {
	Video * self;
	GError * _inner_error_ = NULL;
#line 727 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6912 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6919 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			Rating _tmp2_;
			Rating _tmp3_;
#line 729 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 729 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->rating;
#line 729 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = rating_decrease (_tmp2_);
#line 729 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp3_);
#line 6932 "VideoSupport.c"
		}
		__finally529:
		{
			VideoRow* _tmp4_;
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6941 "VideoSupport.c"
		}
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 6951 "VideoSupport.c"
		}
	}
}


static gboolean video_real_is_trashed (MediaSource* base) {
	Video * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 733 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 734 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_is_flag_set (self, VIDEO_FLAG_TRASH);
#line 734 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 734 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6969 "VideoSupport.c"
}


static gboolean video_real_is_offline (Monitorable* base) {
	Video * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 737 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 738 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_is_flag_set (self, VIDEO_FLAG_OFFLINE);
#line 738 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 738 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6985 "VideoSupport.c"
}


static void video_real_mark_offline (Monitorable* base) {
	Video * self;
#line 741 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 742 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_add_flags (self, VIDEO_FLAG_OFFLINE, NULL);
#line 6995 "VideoSupport.c"
}


static void video_real_mark_online (Monitorable* base) {
	Video * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
#line 745 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 746 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_remove_flags (self, VIDEO_FLAG_OFFLINE, NULL);
#line 748 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = video_get_is_interpretable (self);
#line 748 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!_tmp1_) {
#line 7011 "VideoSupport.c"
		gboolean _tmp2_;
#line 748 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = video_has_interpreter_state_changed ();
#line 748 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = _tmp2_;
#line 7017 "VideoSupport.c"
	} else {
#line 748 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = FALSE;
#line 7021 "VideoSupport.c"
	}
#line 748 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 7025 "VideoSupport.c"
		VideoInterpretableResults* _tmp3_;
		VideoInterpretableResults* _tmp4_;
#line 749 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = video_check_is_interpretable (self);
#line 749 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = _tmp3_;
#line 749 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_foreground_finish (_tmp4_);
#line 749 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_interpretable_results_unref0 (_tmp4_);
#line 7036 "VideoSupport.c"
	}
}


static void video_real_trash (MediaSource* base) {
	Video * self;
#line 752 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 753 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_add_flags (self, VIDEO_FLAG_TRASH, NULL);
#line 7047 "VideoSupport.c"
}


static void video_real_untrash (MediaSource* base) {
	Video * self;
#line 756 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 757 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_remove_flags (self, VIDEO_FLAG_TRASH, NULL);
#line 7057 "VideoSupport.c"
}


static gboolean video_real_is_flagged (Flaggable* base) {
	Video * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 760 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 761 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_is_flag_set (self, VIDEO_FLAG_FLAGGED);
#line 761 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 761 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 7073 "VideoSupport.c"
}


static void video_real_mark_flagged (Flaggable* base) {
	Video * self;
	Alteration* _tmp0_;
	Alteration* _tmp1_;
#line 764 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 765 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = alteration_new ("metadata", "flagged");
#line 765 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 765 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_add_flags (self, VIDEO_FLAG_FLAGGED, _tmp1_);
#line 765 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp1_);
#line 7091 "VideoSupport.c"
}


static void video_real_mark_unflagged (Flaggable* base) {
	Video * self;
	Alteration* _tmp0_;
	Alteration* _tmp1_;
#line 768 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 769 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = alteration_new ("metadata", "flagged");
#line 769 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 769 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_remove_flags (self, VIDEO_FLAG_FLAGGED, _tmp1_);
#line 769 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp1_);
#line 7109 "VideoSupport.c"
}


static void video_real_get_event_id (MediaSource* base, EventID* result) {
	Video * self;
	GError * _inner_error_ = NULL;
#line 772 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7118 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7125 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			EventID _tmp2_;
#line 774 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 774 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->event_id;
#line 774 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*result = _tmp2_;
#line 7135 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7142 "VideoSupport.c"
			}
#line 774 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7146 "VideoSupport.c"
		}
		__finally530:
		{
			VideoRow* _tmp4_;
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7155 "VideoSupport.c"
		}
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 7163 "VideoSupport.c"
	}
}


static gchar* video_real_to_string (DataObject* base) {
	Video * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 778 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7174 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7181 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			VideoID _tmp2_;
			gint64 _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			VideoRow* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->video_id;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = _tmp2_.id;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = _tmp4_;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = self->priv->backing_row;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = _tmp6_->filepath;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = g_strdup_printf ("[%s] %s", _tmp5_, _tmp7_);
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = _tmp8_;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (_tmp5_);
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp9_;
#line 7214 "VideoSupport.c"
			{
				VideoRow* _tmp10_;
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = self->priv->backing_row;
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7221 "VideoSupport.c"
			}
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 7225 "VideoSupport.c"
		}
		__finally531:
		{
			VideoRow* _tmp11_;
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = self->priv->backing_row;
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7234 "VideoSupport.c"
		}
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 7242 "VideoSupport.c"
	}
}


void video_get_video_id (Video* self, VideoID* result) {
	GError * _inner_error_ = NULL;
#line 784 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 7251 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7258 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			VideoID _tmp2_;
#line 786 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 786 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->video_id;
#line 786 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*result = _tmp2_;
#line 7268 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7275 "VideoSupport.c"
			}
#line 786 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7279 "VideoSupport.c"
		}
		__finally532:
		{
			VideoRow* _tmp4_;
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7288 "VideoSupport.c"
		}
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 7296 "VideoSupport.c"
	}
}


static time_t video_real_get_exposure_time (Dateable* base) {
	Video * self;
	time_t result = 0;
	GError * _inner_error_ = NULL;
#line 790 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7307 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
		time_t _tmp5_ = 0;
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7315 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			time_t _tmp2_;
#line 792 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 792 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->exposure_time;
#line 792 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 7325 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7332 "VideoSupport.c"
			}
#line 792 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 7336 "VideoSupport.c"
		}
		__finally533:
		{
			VideoRow* _tmp4_;
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7345 "VideoSupport.c"
		}
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 7353 "VideoSupport.c"
	}
}


static void video_real_set_exposure_time (Dateable* base, time_t time) {
	Video * self;
	Alteration* _tmp12_;
	Alteration* _tmp13_;
	GError * _inner_error_ = NULL;
#line 796 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7365 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7372 "VideoSupport.c"
		{
			VideoRow* _tmp9_;
			time_t _tmp10_;
			{
				VideoTable* _tmp1_;
				VideoTable* _tmp2_;
				VideoRow* _tmp3_;
				VideoID _tmp4_;
				time_t _tmp5_;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp1_ = video_table_get_instance ();
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp2_ = _tmp1_;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = _tmp3_->video_id;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = time;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_exposure_time (_tmp2_, &_tmp4_, _tmp5_, &_inner_error_);
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp2_);
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7398 "VideoSupport.c"
					goto __catch535_g_error;
				}
			}
			goto __finally535;
			__catch535_g_error:
			{
				GError* e = NULL;
				GError* _tmp6_;
				const gchar* _tmp7_;
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 801 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = e;
#line 801 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = _tmp6_->message;
#line 801 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_debug ("VideoSupport.vala:801: Warning - %s", _tmp7_);
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 7420 "VideoSupport.c"
			}
			__finally535:
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7425 "VideoSupport.c"
				{
					VideoRow* _tmp8_;
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp8_ = self->priv->backing_row;
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7432 "VideoSupport.c"
				}
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 7440 "VideoSupport.c"
			}
#line 803 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = self->priv->backing_row;
#line 803 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = time;
#line 803 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_->exposure_time = _tmp10_;
#line 7448 "VideoSupport.c"
		}
		__finally534:
		{
			VideoRow* _tmp11_;
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = self->priv->backing_row;
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7457 "VideoSupport.c"
		}
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7467 "VideoSupport.c"
		}
	}
#line 806 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp12_ = alteration_new ("metadata", "exposure-time");
#line 806 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = _tmp12_;
#line 806 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp13_);
#line 806 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp13_);
#line 7478 "VideoSupport.c"
}


void video_get_frame_dimensions (Video* self, Dimensions* result) {
	GError * _inner_error_ = NULL;
#line 809 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 7486 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7493 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			gint _tmp2_;
			VideoRow* _tmp3_;
			gint _tmp4_;
			Dimensions _tmp5_ = {0};
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->width;
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _tmp3_->height;
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			dimensions_init (&_tmp5_, _tmp2_, _tmp4_);
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*result = _tmp5_;
#line 7512 "VideoSupport.c"
			{
				VideoRow* _tmp6_;
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = self->priv->backing_row;
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7519 "VideoSupport.c"
			}
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7523 "VideoSupport.c"
		}
		__finally536:
		{
			VideoRow* _tmp7_;
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = self->priv->backing_row;
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7532 "VideoSupport.c"
		}
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 7540 "VideoSupport.c"
	}
}


static void video_real_get_dimensions (MediaSource* base, PhotoException disallowed_steps, Dimensions* result) {
	Video * self;
	Dimensions _tmp0_ = {0};
#line 815 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 816 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_get_frame_dimensions (self, &_tmp0_);
#line 816 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	*result = _tmp0_;
#line 816 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return;
#line 7556 "VideoSupport.c"
}


static guint64 video_real_get_filesize (MediaSource* base) {
	Video * self;
	guint64 result = 0ULL;
	guint64 _tmp0_;
#line 819 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 820 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_get_master_filesize (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 820 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 820 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 7572 "VideoSupport.c"
}


static guint64 video_real_get_master_filesize (MediaSource* base) {
	Video * self;
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 823 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7582 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
		guint64 _tmp5_ = 0ULL;
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7590 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			gint64 _tmp2_;
#line 825 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 825 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->filesize;
#line 825 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = (guint64) _tmp2_;
#line 7600 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7607 "VideoSupport.c"
			}
#line 825 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 7611 "VideoSupport.c"
		}
		__finally537:
		{
			VideoRow* _tmp4_;
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7620 "VideoSupport.c"
		}
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 7628 "VideoSupport.c"
	}
}


static time_t video_real_get_timestamp (MediaSource* base) {
	Video * self;
	time_t result = 0;
	GError * _inner_error_ = NULL;
#line 829 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7639 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
		time_t _tmp5_ = 0;
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7647 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			time_t _tmp2_;
#line 831 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 831 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->timestamp;
#line 831 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 7657 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7664 "VideoSupport.c"
			}
#line 831 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 7668 "VideoSupport.c"
		}
		__finally538:
		{
			VideoRow* _tmp4_;
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7677 "VideoSupport.c"
		}
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 7685 "VideoSupport.c"
	}
}


static void video_real_set_master_timestamp (Monitorable* base, GFileInfo* info) {
	Video * self;
	GTimeVal time_val = {0};
	GFileInfo* _tmp0_;
	GTimeVal _tmp1_ = {0};
	Alteration* _tmp19_;
	Alteration* _tmp20_;
	GError * _inner_error_ = NULL;
#line 835 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 835 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 836 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = info;
#line 836 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_file_info_get_modification_time (_tmp0_, &_tmp1_);
#line 836 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	time_val = _tmp1_;
#line 7708 "VideoSupport.c"
	{
		{
			VideoRow* _tmp2_;
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = self->priv->backing_row;
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7716 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
				time_t _tmp4_;
				GTimeVal _tmp5_;
				glong _tmp6_;
				VideoTable* _tmp8_;
				VideoTable* _tmp9_;
				VideoRow* _tmp10_;
				VideoID _tmp11_;
				GTimeVal _tmp12_;
				glong _tmp13_;
				VideoRow* _tmp14_;
				GTimeVal _tmp15_;
				glong _tmp16_;
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = _tmp3_->timestamp;
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = time_val;
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = _tmp5_.tv_sec;
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_tmp4_ == ((time_t) _tmp6_)) {
#line 7741 "VideoSupport.c"
					{
						VideoRow* _tmp7_;
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp7_ = self->priv->backing_row;
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7748 "VideoSupport.c"
					}
#line 841 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return;
#line 7752 "VideoSupport.c"
				}
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = video_table_get_instance ();
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = _tmp8_;
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = self->priv->backing_row;
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = _tmp10_->video_id;
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = time_val;
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = _tmp12_.tv_sec;
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_timestamp (_tmp9_, &_tmp11_, (time_t) _tmp13_, &_inner_error_);
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp9_);
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7772 "VideoSupport.c"
					goto __finally540;
				}
#line 844 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = self->priv->backing_row;
#line 844 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_ = time_val;
#line 844 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = _tmp15_.tv_sec;
#line 844 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_->timestamp = (time_t) _tmp16_;
#line 7783 "VideoSupport.c"
			}
			__finally540:
			{
				VideoRow* _tmp17_;
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = self->priv->backing_row;
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7792 "VideoSupport.c"
			}
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 7798 "VideoSupport.c"
					goto __catch539_database_error;
				}
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 7807 "VideoSupport.c"
			}
		}
	}
	goto __finally539;
	__catch539_database_error:
	{
		GError* err = NULL;
		GError* _tmp18_;
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 847 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp18_ = err;
#line 847 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		app_window_database_error (_tmp18_);
#line 849 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 849 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 7828 "VideoSupport.c"
	}
	__finally539:
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 7839 "VideoSupport.c"
	}
#line 852 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp19_ = alteration_new ("metadata", "master-timestamp");
#line 852 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = _tmp19_;
#line 852 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp20_);
#line 852 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp20_);
#line 7849 "VideoSupport.c"
}


gchar* video_get_filename (Video* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 855 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), NULL);
#line 7858 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7865 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
#line 857 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 857 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->filepath;
#line 857 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 857 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp3_;
#line 7878 "VideoSupport.c"
			{
				VideoRow* _tmp4_;
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = self->priv->backing_row;
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7885 "VideoSupport.c"
			}
#line 857 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 7889 "VideoSupport.c"
		}
		__finally541:
		{
			VideoRow* _tmp5_;
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7898 "VideoSupport.c"
		}
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 7906 "VideoSupport.c"
	}
}


static GFile* video_real_get_file (MediaSource* base) {
	Video * self;
	GFile* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
#line 861 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 862 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_get_filename (self);
#line 862 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 862 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 862 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 862 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp1_);
#line 862 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp3_;
#line 862 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 7934 "VideoSupport.c"
}


static GFile* video_real_get_master_file (MediaSource* base) {
	Video * self;
	GFile* result = NULL;
	GFile* _tmp0_;
#line 865 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 866 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 866 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 866 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 7950 "VideoSupport.c"
}


void video_export (Video* self, GFile* dest_file, GError** error) {
	GFile* source_file = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError * _inner_error_ = NULL;
#line 869 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 869 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE (dest_file));
#line 870 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_get_filename (self);
#line 870 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 870 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 870 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 870 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp1_);
#line 870 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	source_file = _tmp3_;
#line 871 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = dest_file;
#line 871 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_file_copy (source_file, _tmp4_, G_FILE_COPY_OVERWRITE | G_FILE_COPY_TARGET_DEFAULT_PERMS, NULL, NULL, NULL, &_inner_error_);
#line 871 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 871 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 871 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (source_file);
#line 871 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 7990 "VideoSupport.c"
	}
#line 869 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (source_file);
#line 7994 "VideoSupport.c"
}


gdouble video_get_clip_duration (Video* self) {
	gdouble result = 0.0;
	GError * _inner_error_ = NULL;
#line 875 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), 0.0);
#line 8003 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
		gdouble _tmp5_ = 0.0;
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8011 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			gdouble _tmp2_;
#line 877 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 877 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->clip_duration;
#line 877 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 8021 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8028 "VideoSupport.c"
			}
#line 877 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 8032 "VideoSupport.c"
		}
		__finally542:
		{
			VideoRow* _tmp4_;
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8041 "VideoSupport.c"
		}
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 8049 "VideoSupport.c"
	}
}


gboolean video_get_is_interpretable (Video* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 881 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), FALSE);
#line 8059 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
		gboolean _tmp5_ = FALSE;
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8067 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			gboolean _tmp2_;
#line 883 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 883 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->is_interpretable;
#line 883 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 8077 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8084 "VideoSupport.c"
			}
#line 883 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 8088 "VideoSupport.c"
		}
		__finally543:
		{
			VideoRow* _tmp4_;
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8097 "VideoSupport.c"
		}
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 8105 "VideoSupport.c"
	}
}


static void video_set_is_interpretable (Video* self, gboolean is_interpretable) {
	GError * _inner_error_ = NULL;
#line 887 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 8114 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8121 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			gboolean _tmp2_;
			gboolean _tmp3_;
			VideoRow* _tmp5_;
			gboolean _tmp6_;
#line 889 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 889 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->is_interpretable;
#line 889 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = is_interpretable;
#line 889 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp2_ == _tmp3_) {
#line 8136 "VideoSupport.c"
				{
					VideoRow* _tmp4_;
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp4_ = self->priv->backing_row;
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8143 "VideoSupport.c"
				}
#line 890 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 8147 "VideoSupport.c"
			}
#line 892 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 892 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = is_interpretable;
#line 892 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_->is_interpretable = _tmp6_;
#line 8155 "VideoSupport.c"
		}
		__finally544:
		{
			VideoRow* _tmp7_;
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = self->priv->backing_row;
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8164 "VideoSupport.c"
		}
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 8174 "VideoSupport.c"
		}
	}
	{
		VideoTable* _tmp8_;
		VideoTable* _tmp9_;
		VideoID _tmp10_ = {0};
		gboolean _tmp11_;
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = video_table_get_instance ();
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = _tmp8_;
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_get_video_id (self, &_tmp10_);
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = is_interpretable;
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_update_is_interpretable (_tmp9_, &_tmp10_, _tmp11_, &_inner_error_);
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp9_);
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 8198 "VideoSupport.c"
				goto __catch545_database_error;
			}
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 8207 "VideoSupport.c"
		}
	}
	goto __finally545;
	__catch545_database_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
#line 895 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 895 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = e;
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		app_window_database_error (_tmp12_);
#line 895 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 8225 "VideoSupport.c"
	}
	__finally545:
#line 895 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 895 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 895 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 895 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 8236 "VideoSupport.c"
	}
}


VideoInterpretableResults* video_check_is_interpretable (Video* self) {
	VideoInterpretableResults* result = NULL;
	VideoInterpretableResults* results = NULL;
	VideoInterpretableResults* _tmp0_;
	gdouble clip_duration = 0.0;
	GdkPixbuf* preview_frame = NULL;
	VideoReader* backing_file_reader = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	VideoReader* _tmp3_;
	VideoReader* _tmp4_;
	gboolean _tmp13_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	VideoInterpretableResults* _tmp24_;
	VideoInterpretableResults* _tmp25_;
	VideoInterpretableResults* _tmp26_;
	GdkPixbuf* _tmp27_;
	GdkPixbuf* _tmp28_;
	GError * _inner_error_ = NULL;
#line 905 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), NULL);
#line 906 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_interpretable_results_new (self);
#line 906 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	results = _tmp0_;
#line 908 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	clip_duration = -1.0;
#line 909 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	preview_frame = NULL;
#line 911 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 911 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 911 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_reader_new (_tmp2_);
#line 911 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 911 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp2_);
#line 911 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	backing_file_reader = _tmp4_;
#line 8285 "VideoSupport.c"
	{
		gdouble _tmp5_ = 0.0;
		VideoReader* _tmp6_;
		gdouble _tmp7_;
		VideoReader* _tmp8_;
		GdkPixbuf* _tmp9_;
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = backing_file_reader;
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = video_reader_read_clip_duration (_tmp6_, &_inner_error_);
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = _tmp7_;
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == VIDEO_ERROR) {
#line 8302 "VideoSupport.c"
				goto __catch546_video_error;
			}
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_reader_unref0 (backing_file_reader);
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (preview_frame);
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_interpretable_results_unref0 (results);
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return NULL;
#line 8317 "VideoSupport.c"
		}
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		clip_duration = _tmp5_;
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = backing_file_reader;
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = video_reader_read_preview_frame (_tmp8_);
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		preview_frame = _tmp9_;
#line 8329 "VideoSupport.c"
	}
	goto __finally546;
	__catch546_video_error:
	{
		GError* e = NULL;
		VideoInterpretableResults* _tmp10_;
		gboolean _tmp11_;
		VideoInterpretableResults* _tmp12_;
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 918 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = results;
#line 918 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = video_get_is_interpretable (self);
#line 918 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_->update_interpretable = _tmp11_;
#line 919 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = results;
#line 919 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_->is_interpretable = FALSE;
#line 921 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = results;
#line 921 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 921 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (backing_file_reader);
#line 921 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 921 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 8362 "VideoSupport.c"
	}
	__finally546:
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (backing_file_reader);
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_interpretable_results_unref0 (results);
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 8379 "VideoSupport.c"
	}
#line 925 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = video_get_is_interpretable (self);
#line 925 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp13_) {
#line 8385 "VideoSupport.c"
		VideoInterpretableResults* _tmp14_;
		VideoInterpretableResults* _tmp15_;
#line 926 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp14_ = results;
#line 926 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp14_->update_interpretable = FALSE;
#line 927 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp15_ = results;
#line 927 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp15_->is_interpretable = TRUE;
#line 929 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = results;
#line 929 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (backing_file_reader);
#line 929 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 929 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 8404 "VideoSupport.c"
	}
#line 932 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp16_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 932 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp17_ = _tmp16_;
#line 932 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp18_ = g_file_get_basename (_tmp17_);
#line 932 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp19_ = _tmp18_;
#line 932 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_debug ("VideoSupport.vala:932: video %s has become interpretable", _tmp19_);
#line 932 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp19_);
#line 932 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp17_);
#line 8420 "VideoSupport.c"
	{
		VideoRow* _tmp20_;
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp20_ = self->priv->backing_row;
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8427 "VideoSupport.c"
		{
			VideoRow* _tmp21_;
			gdouble _tmp22_;
#line 936 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_ = self->priv->backing_row;
#line 936 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp22_ = clip_duration;
#line 936 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_->clip_duration = _tmp22_;
#line 8437 "VideoSupport.c"
		}
		__finally547:
		{
			VideoRow* _tmp23_;
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_ = self->priv->backing_row;
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8446 "VideoSupport.c"
		}
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_reader_unref0 (backing_file_reader);
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (preview_frame);
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_interpretable_results_unref0 (results);
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return NULL;
#line 8462 "VideoSupport.c"
		}
	}
#line 939 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = results;
#line 939 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_->update_interpretable = TRUE;
#line 940 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp25_ = results;
#line 940 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp25_->is_interpretable = TRUE;
#line 941 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp26_ = results;
#line 941 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = preview_frame;
#line 941 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp28_ = _g_object_ref0 (_tmp27_);
#line 941 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp26_->new_thumbnail);
#line 941 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp26_->new_thumbnail = _tmp28_;
#line 943 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = results;
#line 943 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_reader_unref0 (backing_file_reader);
#line 943 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (preview_frame);
#line 943 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 8491 "VideoSupport.c"
}


static void video_real_destroy (DataSource* base) {
	Video * self;
	VideoID video_id = {0};
	VideoID _tmp0_ = {0};
	GError * _inner_error_ = NULL;
#line 946 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 947 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_get_video_id (self, &_tmp0_);
#line 947 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id = _tmp0_;
#line 949 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	thumbnail_cache_remove (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
#line 8508 "VideoSupport.c"
	{
		VideoTable* _tmp1_;
		VideoTable* _tmp2_;
		VideoID _tmp3_;
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = video_table_get_instance ();
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _tmp1_;
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = video_id;
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_remove (_tmp2_, &_tmp3_, &_inner_error_);
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp2_);
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 8527 "VideoSupport.c"
				goto __catch548_database_error;
			}
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 8536 "VideoSupport.c"
		}
	}
	goto __finally548;
	__catch548_database_error:
	{
		GError* err = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = _tmp4_;
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_error ("VideoSupport.vala:954: failed to remove video %s from video table", _tmp5_);
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp5_);
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 8559 "VideoSupport.c"
	}
	__finally548:
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 8570 "VideoSupport.c"
	}
#line 957 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	DATA_SOURCE_CLASS (video_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_VIDEO_SOURCE, VideoSource), TYPE_DATA_SOURCE, DataSource));
#line 8574 "VideoSupport.c"
}


static gboolean video_real_internal_delete_backing (DataSource* base, GError** error) {
	Video * self;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 960 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 961 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_delete_original_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 961 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	ret = _tmp0_;
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = DATA_SOURCE_CLASS (video_parent_class)->internal_delete_backing (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_VIDEO_SOURCE, VideoSource), TYPE_DATA_SOURCE, DataSource), &_inner_error_);
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp3_;
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8599 "VideoSupport.c"
		gboolean _tmp4_ = FALSE;
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp4_;
#line 8605 "VideoSupport.c"
	}
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp2_) {
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = ret;
#line 8611 "VideoSupport.c"
	} else {
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = FALSE;
#line 8615 "VideoSupport.c"
	}
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp1_;
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 8621 "VideoSupport.c"
}


static void video_notify_flags_altered (Video* self, Alteration* additional_alteration) {
	Alteration* alteration = NULL;
	Alteration* _tmp0_;
	Alteration* _tmp1_;
	Alteration* _tmp5_;
#line 967 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 967 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration));
#line 968 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = alteration_new ("metadata", "flags");
#line 968 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	alteration = _tmp0_;
#line 969 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = additional_alteration;
#line 969 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_ != NULL) {
#line 8642 "VideoSupport.c"
		Alteration* _tmp2_;
		Alteration* _tmp3_;
		Alteration* _tmp4_;
#line 970 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = alteration;
#line 970 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = additional_alteration;
#line 970 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = alteration_compress (_tmp2_, _tmp3_);
#line 970 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_alteration_unref0 (alteration);
#line 970 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		alteration = _tmp4_;
#line 8656 "VideoSupport.c"
	}
#line 972 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = alteration;
#line 972 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp5_);
#line 967 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (alteration);
#line 8664 "VideoSupport.c"
}


guint64 video_add_flags (Video* self, guint64 flags_to_add, Alteration* additional_alteration) {
	guint64 result = 0ULL;
	guint64 new_flags = 0ULL;
	Alteration* _tmp27_;
	GError * _inner_error_ = NULL;
#line 975 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), 0ULL);
#line 975 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 8677 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8684 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			guint64 _tmp2_;
			guint64 _tmp3_;
			guint64 _tmp4_;
			VideoRow* _tmp5_;
			guint64 _tmp6_;
			guint64 _tmp7_;
			VideoRow* _tmp23_;
			guint64 _tmp24_;
#line 978 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 978 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->flags;
#line 978 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = flags_to_add;
#line 978 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = media_source_internal_add_flags (_tmp2_, _tmp3_);
#line 978 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			new_flags = _tmp4_;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = _tmp5_->flags;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = new_flags;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp6_ == _tmp7_) {
#line 8713 "VideoSupport.c"
				VideoRow* _tmp8_;
				guint64 _tmp9_;
#line 980 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = self->priv->backing_row;
#line 980 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = _tmp8_->flags;
#line 980 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = _tmp9_;
#line 8722 "VideoSupport.c"
				{
					VideoRow* _tmp10_;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp10_ = self->priv->backing_row;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8729 "VideoSupport.c"
				}
#line 980 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 8733 "VideoSupport.c"
			}
			{
				VideoTable* _tmp11_;
				VideoTable* _tmp12_;
				VideoID _tmp13_ = {0};
				guint64 _tmp14_;
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = video_table_get_instance ();
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = _tmp11_;
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_get_video_id (self, &_tmp13_);
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = new_flags;
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_flags (_tmp12_, &_tmp13_, _tmp14_, &_inner_error_);
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp12_);
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8754 "VideoSupport.c"
					guint64 _tmp16_ = 0ULL;
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 8758 "VideoSupport.c"
						goto __catch550_database_error;
					}
					{
						VideoRow* _tmp15_;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp15_ = self->priv->backing_row;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8767 "VideoSupport.c"
					}
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return _tmp16_;
#line 8775 "VideoSupport.c"
				}
			}
			goto __finally550;
			__catch550_database_error:
			{
				GError* e = NULL;
				GError* _tmp17_;
				VideoRow* _tmp18_;
				guint64 _tmp19_;
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = e;
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp17_);
#line 986 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp18_ = self->priv->backing_row;
#line 986 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp19_ = _tmp18_->flags;
#line 986 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = _tmp19_;
#line 986 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 8801 "VideoSupport.c"
				{
					VideoRow* _tmp20_;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp20_ = self->priv->backing_row;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8808 "VideoSupport.c"
				}
#line 986 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 8812 "VideoSupport.c"
			}
			__finally550:
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8817 "VideoSupport.c"
				guint64 _tmp22_ = 0ULL;
				{
					VideoRow* _tmp21_;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp21_ = self->priv->backing_row;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8825 "VideoSupport.c"
				}
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp22_;
#line 8833 "VideoSupport.c"
			}
#line 989 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_ = self->priv->backing_row;
#line 989 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp24_ = new_flags;
#line 989 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_->flags = _tmp24_;
#line 8841 "VideoSupport.c"
		}
		__finally549:
		{
			VideoRow* _tmp25_;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp25_ = self->priv->backing_row;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8850 "VideoSupport.c"
		}
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8854 "VideoSupport.c"
			guint64 _tmp26_ = 0ULL;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return _tmp26_;
#line 8862 "VideoSupport.c"
		}
	}
#line 992 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = additional_alteration;
#line 992 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_notify_flags_altered (self, _tmp27_);
#line 994 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = new_flags;
#line 994 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 8873 "VideoSupport.c"
}


guint64 video_remove_flags (Video* self, guint64 flags_to_remove, Alteration* additional_alteration) {
	guint64 result = 0ULL;
	guint64 new_flags = 0ULL;
	Alteration* _tmp27_;
	GError * _inner_error_ = NULL;
#line 997 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), 0ULL);
#line 997 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 8886 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8893 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			guint64 _tmp2_;
			guint64 _tmp3_;
			guint64 _tmp4_;
			VideoRow* _tmp5_;
			guint64 _tmp6_;
			guint64 _tmp7_;
			VideoRow* _tmp23_;
			guint64 _tmp24_;
#line 1000 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 1000 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->flags;
#line 1000 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = flags_to_remove;
#line 1000 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = media_source_internal_remove_flags (_tmp2_, _tmp3_);
#line 1000 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			new_flags = _tmp4_;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = _tmp5_->flags;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = new_flags;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp6_ == _tmp7_) {
#line 8922 "VideoSupport.c"
				VideoRow* _tmp8_;
				guint64 _tmp9_;
#line 1002 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = self->priv->backing_row;
#line 1002 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = _tmp8_->flags;
#line 1002 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = _tmp9_;
#line 8931 "VideoSupport.c"
				{
					VideoRow* _tmp10_;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp10_ = self->priv->backing_row;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8938 "VideoSupport.c"
				}
#line 1002 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 8942 "VideoSupport.c"
			}
			{
				VideoTable* _tmp11_;
				VideoTable* _tmp12_;
				VideoID _tmp13_ = {0};
				guint64 _tmp14_;
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = video_table_get_instance ();
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = _tmp11_;
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_get_video_id (self, &_tmp13_);
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = new_flags;
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_flags (_tmp12_, &_tmp13_, _tmp14_, &_inner_error_);
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp12_);
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8963 "VideoSupport.c"
					guint64 _tmp16_ = 0ULL;
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 8967 "VideoSupport.c"
						goto __catch552_database_error;
					}
					{
						VideoRow* _tmp15_;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp15_ = self->priv->backing_row;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8976 "VideoSupport.c"
					}
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return _tmp16_;
#line 8984 "VideoSupport.c"
				}
			}
			goto __finally552;
			__catch552_database_error:
			{
				GError* e = NULL;
				GError* _tmp17_;
				VideoRow* _tmp18_;
				guint64 _tmp19_;
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = e;
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp17_);
#line 1008 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp18_ = self->priv->backing_row;
#line 1008 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp19_ = _tmp18_->flags;
#line 1008 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = _tmp19_;
#line 1008 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 9010 "VideoSupport.c"
				{
					VideoRow* _tmp20_;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp20_ = self->priv->backing_row;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9017 "VideoSupport.c"
				}
#line 1008 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 9021 "VideoSupport.c"
			}
			__finally552:
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9026 "VideoSupport.c"
				guint64 _tmp22_ = 0ULL;
				{
					VideoRow* _tmp21_;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp21_ = self->priv->backing_row;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9034 "VideoSupport.c"
				}
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp22_;
#line 9042 "VideoSupport.c"
			}
#line 1011 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_ = self->priv->backing_row;
#line 1011 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp24_ = new_flags;
#line 1011 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_->flags = _tmp24_;
#line 9050 "VideoSupport.c"
		}
		__finally551:
		{
			VideoRow* _tmp25_;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp25_ = self->priv->backing_row;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9059 "VideoSupport.c"
		}
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9063 "VideoSupport.c"
			guint64 _tmp26_ = 0ULL;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return _tmp26_;
#line 9071 "VideoSupport.c"
		}
	}
#line 1014 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = additional_alteration;
#line 1014 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_notify_flags_altered (self, _tmp27_);
#line 1016 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = new_flags;
#line 1016 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 9082 "VideoSupport.c"
}


gboolean video_is_flag_set (Video* self, guint64 flag) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1019 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), FALSE);
#line 9091 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
		gboolean _tmp7_ = FALSE;
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 9099 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			guint64 _tmp2_;
			guint64 _tmp3_;
			gboolean _tmp4_;
#line 1021 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 1021 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->flags;
#line 1021 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = flag;
#line 1021 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = media_source_internal_is_flag_set (_tmp2_, _tmp3_);
#line 1021 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp4_;
#line 9115 "VideoSupport.c"
			{
				VideoRow* _tmp5_;
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = self->priv->backing_row;
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9122 "VideoSupport.c"
			}
#line 1021 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 9126 "VideoSupport.c"
		}
		__finally553:
		{
			VideoRow* _tmp6_;
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = self->priv->backing_row;
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9135 "VideoSupport.c"
		}
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp7_;
#line 9143 "VideoSupport.c"
	}
}


static void video_real_set_master_file (Monitorable* base, GFile* file) {
	Video * self;
	gchar* new_filepath = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* old_filepath = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	Alteration* _tmp25_;
	Alteration* _tmp26_;
	GError * _inner_error_ = NULL;
#line 1025 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 1025 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 1026 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = file;
#line 1026 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 1026 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	new_filepath = _tmp1_;
#line 1027 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old_filepath = NULL;
#line 9174 "VideoSupport.c"
	{
		{
			VideoRow* _tmp2_;
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = self->priv->backing_row;
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 9182 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				VideoRow* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				VideoTable* _tmp10_;
				VideoTable* _tmp11_;
				VideoRow* _tmp12_;
				VideoID _tmp13_;
				const gchar* _tmp14_;
				VideoRow* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = _tmp3_->filepath;
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = new_filepath;
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
#line 9206 "VideoSupport.c"
					{
						VideoRow* _tmp6_;
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp6_ = self->priv->backing_row;
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9213 "VideoSupport.c"
					}
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (old_filepath);
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (new_filepath);
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return;
#line 9221 "VideoSupport.c"
				}
#line 1033 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = self->priv->backing_row;
#line 1033 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = _tmp7_->filepath;
#line 1033 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = g_strdup (_tmp8_);
#line 1033 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (old_filepath);
#line 1033 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				old_filepath = _tmp9_;
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = video_table_get_instance ();
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = _tmp10_;
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = self->priv->backing_row;
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = _tmp12_->video_id;
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = new_filepath;
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_filepath (_tmp11_, &_tmp13_, _tmp14_, &_inner_error_);
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp11_);
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9249 "VideoSupport.c"
					goto __finally555;
				}
#line 1036 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_ = self->priv->backing_row;
#line 1036 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = new_filepath;
#line 1036 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = g_strdup (_tmp16_);
#line 1036 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (_tmp15_->filepath);
#line 1036 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_->filepath = _tmp17_;
#line 9262 "VideoSupport.c"
			}
			__finally555:
			{
				VideoRow* _tmp18_;
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp18_ = self->priv->backing_row;
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9271 "VideoSupport.c"
			}
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 9277 "VideoSupport.c"
					goto __catch554_database_error;
				}
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (old_filepath);
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_filepath);
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 9290 "VideoSupport.c"
			}
		}
	}
	goto __finally554;
	__catch554_database_error:
	{
		GError* err = NULL;
		GError* _tmp19_;
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 1039 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp19_ = err;
#line 1039 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		app_window_database_error (_tmp19_);
#line 1041 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 1041 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (old_filepath);
#line 1041 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (new_filepath);
#line 1041 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 9315 "VideoSupport.c"
	}
	__finally554:
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (old_filepath);
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (new_filepath);
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 9330 "VideoSupport.c"
	}
#line 1044 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = old_filepath;
#line 1044 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_assert (_tmp20_ != NULL, "old_filepath != null");
#line 1045 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp21_ = old_filepath;
#line 1045 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp22_ = g_file_new_for_path (_tmp21_);
#line 1045 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_ = _tmp22_;
#line 1045 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = file;
#line 1045 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	media_source_notify_master_replaced (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp23_, _tmp24_);
#line 1045 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp23_);
#line 1047 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp25_ = alteration_new_from_list ("backing:master,metadata:name");
#line 1047 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp26_ = _tmp25_;
#line 1047 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp26_);
#line 1047 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp26_);
#line 1025 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (old_filepath);
#line 1025 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (new_filepath);
#line 9360 "VideoSupport.c"
}


VideoMetadata* video_read_metadata (Video* self, GError** error) {
	VideoMetadata* result = NULL;
	VideoMetadata* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	VideoReader* _tmp3_;
	VideoReader* _tmp4_;
	VideoMetadata* _tmp5_;
	VideoMetadata* _tmp6_;
	VideoMetadata* _tmp7_;
	GError * _inner_error_ = NULL;
#line 1050 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), NULL);
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_reader_new (_tmp2_);
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = video_reader_read_metadata (_tmp4_, &_inner_error_);
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = _tmp5_;
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_reader_unref0 (_tmp4_);
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp2_);
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = _tmp6_;
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 9401 "VideoSupport.c"
	}
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = _tmp0_;
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = NULL;
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp7_;
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_media_metadata_unref0 (_tmp0_);
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 9413 "VideoSupport.c"
}


VideoInterpretableResults* video_interpretable_results_construct (GType object_type, Video* video) {
	VideoInterpretableResults* self = NULL;
	Video* _tmp0_;
	Video* _tmp1_;
#line 336 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (video), NULL);
#line 336 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (VideoInterpretableResults*) g_type_create_instance (object_type);
#line 337 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video;
#line 337 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 337 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->video);
#line 337 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->video = _tmp1_;
#line 336 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 9435 "VideoSupport.c"
}


VideoInterpretableResults* video_interpretable_results_new (Video* video) {
#line 336 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_interpretable_results_construct (VIDEO_TYPE_INTERPRETABLE_RESULTS, video);
#line 9442 "VideoSupport.c"
}


void video_interpretable_results_foreground_finish (VideoInterpretableResults* self) {
	gboolean _tmp0_;
	GdkPixbuf* _tmp3_;
	GError * _inner_error_ = NULL;
#line 340 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (VIDEO_IS_INTERPRETABLE_RESULTS (self));
#line 341 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->update_interpretable;
#line 341 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 9456 "VideoSupport.c"
		Video* _tmp1_;
		gboolean _tmp2_;
#line 342 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->video;
#line 342 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = self->is_interpretable;
#line 342 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_set_is_interpretable (_tmp1_, _tmp2_);
#line 9465 "VideoSupport.c"
	}
#line 344 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = self->new_thumbnail;
#line 344 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp3_ != NULL) {
#line 9471 "VideoSupport.c"
		{
			Video* _tmp4_;
			GdkPixbuf* _tmp5_;
			Video* _tmp6_;
			GdkPixbuf* _tmp7_;
			Video* _tmp8_;
#line 346 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->video;
#line 346 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->new_thumbnail;
#line 346 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			thumbnail_cache_replace (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), THUMBNAIL_CACHE_SIZE_BIG, _tmp5_, &_inner_error_);
#line 346 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9486 "VideoSupport.c"
				goto __catch556_g_error;
			}
#line 347 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = self->video;
#line 347 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = self->new_thumbnail;
#line 347 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			thumbnail_cache_replace (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), THUMBNAIL_CACHE_SIZE_MEDIUM, _tmp7_, &_inner_error_);
#line 347 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9497 "VideoSupport.c"
				goto __catch556_g_error;
			}
#line 349 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = self->video;
#line 349 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			thumbnail_source_notify_thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
#line 9504 "VideoSupport.c"
		}
		goto __finally556;
		__catch556_g_error:
		{
			GError* err = NULL;
			Video* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			GError* _tmp12_;
			const gchar* _tmp13_;
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			err = _inner_error_;
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_inner_error_ = NULL;
#line 351 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = self->video;
#line 351 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_OBJECT, DataObject));
#line 351 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = _tmp10_;
#line 351 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = err;
#line 351 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp13_ = _tmp12_->message;
#line 351 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_message ("VideoSupport.vala:351: Unable to update video thumbnails for %s: %s", _tmp11_, _tmp13_);
#line 351 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (_tmp11_);
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_error_free0 (err);
#line 9535 "VideoSupport.c"
		}
		__finally556:
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 9546 "VideoSupport.c"
		}
	}
}


static void video_value_interpretable_results_init (GValue* value) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	value->data[0].v_pointer = NULL;
#line 9555 "VideoSupport.c"
}


static void video_value_interpretable_results_free_value (GValue* value) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (value->data[0].v_pointer) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_unref (value->data[0].v_pointer);
#line 9564 "VideoSupport.c"
	}
}


static void video_value_interpretable_results_copy_value (const GValue* src_value, GValue* dest_value) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (src_value->data[0].v_pointer) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = video_interpretable_results_ref (src_value->data[0].v_pointer);
#line 9574 "VideoSupport.c"
	} else {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = NULL;
#line 9578 "VideoSupport.c"
	}
}


static gpointer video_value_interpretable_results_peek_pointer (const GValue* value) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 9586 "VideoSupport.c"
}


static gchar* video_value_interpretable_results_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (collect_values[0].v_pointer) {
#line 9593 "VideoSupport.c"
		VideoInterpretableResults * object;
		object = collect_values[0].v_pointer;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (object->parent_instance.g_class == NULL) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 9600 "VideoSupport.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 9604 "VideoSupport.c"
		}
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = video_interpretable_results_ref (object);
#line 9608 "VideoSupport.c"
	} else {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 9612 "VideoSupport.c"
	}
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 9616 "VideoSupport.c"
}


static gchar* video_value_interpretable_results_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	VideoInterpretableResults ** object_p;
	object_p = collect_values[0].v_pointer;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!object_p) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 9627 "VideoSupport.c"
	}
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!value->data[0].v_pointer) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = NULL;
#line 9633 "VideoSupport.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = value->data[0].v_pointer;
#line 9637 "VideoSupport.c"
	} else {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = video_interpretable_results_ref (value->data[0].v_pointer);
#line 9641 "VideoSupport.c"
	}
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 9645 "VideoSupport.c"
}


GParamSpec* video_param_spec_interpretable_results (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	VideoParamSpecInterpretableResults* spec;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (g_type_is_a (object_type, VIDEO_TYPE_INTERPRETABLE_RESULTS), NULL);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return G_PARAM_SPEC (spec);
#line 9659 "VideoSupport.c"
}


gpointer video_value_get_interpretable_results (const GValue* value) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS), NULL);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 9668 "VideoSupport.c"
}


void video_value_set_interpretable_results (GValue* value, gpointer v_object) {
	VideoInterpretableResults * old;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS));
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIDEO_TYPE_INTERPRETABLE_RESULTS));
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_ref (value->data[0].v_pointer);
#line 9688 "VideoSupport.c"
	} else {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 9692 "VideoSupport.c"
	}
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_unref (old);
#line 9698 "VideoSupport.c"
	}
}


void video_value_take_interpretable_results (GValue* value, gpointer v_object) {
	VideoInterpretableResults * old;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS));
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIDEO_TYPE_INTERPRETABLE_RESULTS));
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 9717 "VideoSupport.c"
	} else {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 9721 "VideoSupport.c"
	}
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_unref (old);
#line 9727 "VideoSupport.c"
	}
}


static void video_interpretable_results_class_init (VideoInterpretableResultsClass * klass) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_interpretable_results_parent_class = g_type_class_peek_parent (klass);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((VideoInterpretableResultsClass *) klass)->finalize = video_interpretable_results_finalize;
#line 9737 "VideoSupport.c"
}


static void video_interpretable_results_instance_init (VideoInterpretableResults * self) {
#line 332 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->update_interpretable = FALSE;
#line 333 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->is_interpretable = FALSE;
#line 334 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->new_thumbnail = NULL;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->ref_count = 1;
#line 9750 "VideoSupport.c"
}


static void video_interpretable_results_finalize (VideoInterpretableResults * obj) {
	VideoInterpretableResults * self;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResults);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_handlers_destroy (self);
#line 331 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->video);
#line 334 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->new_thumbnail);
#line 9764 "VideoSupport.c"
}


GType video_interpretable_results_get_type (void) {
	static volatile gsize video_interpretable_results_type_id__volatile = 0;
	if (g_once_init_enter (&video_interpretable_results_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { video_value_interpretable_results_init, video_value_interpretable_results_free_value, video_value_interpretable_results_copy_value, video_value_interpretable_results_peek_pointer, "p", video_value_interpretable_results_collect_value, "p", video_value_interpretable_results_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (VideoInterpretableResultsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_interpretable_results_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoInterpretableResults), 0, (GInstanceInitFunc) video_interpretable_results_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType video_interpretable_results_type_id;
		video_interpretable_results_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoInterpretableResults", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&video_interpretable_results_type_id__volatile, video_interpretable_results_type_id);
	}
	return video_interpretable_results_type_id__volatile;
}


gpointer video_interpretable_results_ref (gpointer instance) {
	VideoInterpretableResults * self;
	self = instance;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_atomic_int_inc (&self->ref_count);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return instance;
#line 9789 "VideoSupport.c"
}


void video_interpretable_results_unref (gpointer instance) {
	VideoInterpretableResults * self;
	self = instance;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		VIDEO_INTERPRETABLE_RESULTS_GET_CLASS (self)->finalize (self);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 9802 "VideoSupport.c"
	}
}


static void video_class_init (VideoClass * klass) {
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_parent_class = g_type_class_peek_parent (klass);
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_type_class_add_private (klass, sizeof (VideoPrivate));
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->commit_backlinks = (void (*) (DataSource *, SourceCollection*, const gchar*)) video_real_commit_backlinks;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->set_event_id = (gboolean (*) (MediaSource *, EventID*)) video_real_set_event_id;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_backing_files_state = (BackingFileState** (*) (MediaSource *, int*)) video_real_get_backing_files_state;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*) (ThumbnailSource *, gint, GError**)) video_real_get_thumbnail;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_master_md5 = (gchar* (*) (MediaSource *)) video_real_get_master_md5;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_preview_pixbuf = (GdkPixbuf* (*) (MediaSource *, Scaling*, GError**)) video_real_get_preview_pixbuf;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((ThumbnailSourceClass *) klass)->create_thumbnail = (GdkPixbuf* (*) (ThumbnailSource *, gint, GError**)) video_real_create_thumbnail;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource *)) video_real_get_typename;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource *)) video_real_get_instance_id;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_import_id = (void (*) (MediaSource *, ImportID*)) video_real_get_import_id;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((ThumbnailSourceClass *) klass)->get_preferred_thumbnail_format = (PhotoFileFormat (*) (ThumbnailSource *)) video_real_get_preferred_thumbnail_format;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_title = (gchar* (*) (MediaSource *)) video_real_get_title;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->set_title = (void (*) (MediaSource *, const gchar*)) video_real_set_title;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_comment = (gchar* (*) (MediaSource *)) video_real_get_comment;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->set_comment = (gboolean (*) (MediaSource *, const gchar*)) video_real_set_comment;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_rating = (Rating (*) (MediaSource *)) video_real_get_rating;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->set_rating = (void (*) (MediaSource *, Rating)) video_real_set_rating;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->increase_rating = (void (*) (MediaSource *)) video_real_increase_rating;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->decrease_rating = (void (*) (MediaSource *)) video_real_decrease_rating;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->is_trashed = (gboolean (*) (MediaSource *)) video_real_is_trashed;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->is_offline = (gboolean (*) (MediaSource *)) video_real_is_offline;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->mark_offline = (void (*) (MediaSource *)) video_real_mark_offline;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->mark_online = (void (*) (MediaSource *)) video_real_mark_online;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->trash = (void (*) (MediaSource *)) video_real_trash;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->untrash = (void (*) (MediaSource *)) video_real_untrash;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_event_id = (void (*) (MediaSource *, EventID*)) video_real_get_event_id;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject *)) video_real_to_string;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_exposure_time = (time_t (*) (MediaSource *)) video_real_get_exposure_time;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_dimensions = (void (*) (MediaSource *, PhotoException, Dimensions*)) video_real_get_dimensions;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_filesize = (guint64 (*) (MediaSource *)) video_real_get_filesize;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_master_filesize = (guint64 (*) (MediaSource *)) video_real_get_master_filesize;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_timestamp = (time_t (*) (MediaSource *)) video_real_get_timestamp;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_file = (GFile* (*) (MediaSource *)) video_real_get_file;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_master_file = (GFile* (*) (MediaSource *)) video_real_get_master_file;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->destroy = (void (*) (DataSource *)) video_real_destroy;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->internal_delete_backing = (gboolean (*) (DataSource *, GError**)) video_real_internal_delete_backing;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_OBJECT_CLASS (klass)->finalize = video_finalize;
#line 9886 "VideoSupport.c"
}


static void video_flaggable_interface_init (FlaggableIface * iface) {
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_flaggable_parent_iface = g_type_interface_peek_parent (iface);
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->is_flagged = (gboolean (*) (Flaggable *)) video_real_is_flagged;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->mark_flagged = (void (*) (Flaggable *)) video_real_mark_flagged;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->mark_unflagged = (void (*) (Flaggable *)) video_real_mark_unflagged;
#line 9899 "VideoSupport.c"
}


static void video_monitorable_interface_init (MonitorableIface * iface) {
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_monitorable_parent_iface = g_type_interface_peek_parent (iface);
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->is_offline = (gboolean (*) (Monitorable *)) video_real_is_offline;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->mark_offline = (void (*) (Monitorable *)) video_real_mark_offline;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->mark_online = (void (*) (Monitorable *)) video_real_mark_online;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->set_master_timestamp = (void (*) (Monitorable *, GFileInfo*)) video_real_set_master_timestamp;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->set_master_file = (void (*) (Monitorable *, GFile*)) video_real_set_master_file;
#line 9916 "VideoSupport.c"
}


static void video_dateable_interface_init (DateableIface * iface) {
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_dateable_parent_iface = g_type_interface_peek_parent (iface);
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->get_exposure_time = (time_t (*) (Dateable *)) video_real_get_exposure_time;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->set_exposure_time = (void (*) (Dateable *, time_t)) video_real_set_exposure_time;
#line 9927 "VideoSupport.c"
}


static void video_instance_init (Video * self) {
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv = VIDEO_GET_PRIVATE (self);
#line 364 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_rec_mutex_init (&self->priv->__lock_backing_row);
#line 9936 "VideoSupport.c"
}


static void video_finalize (GObject * obj) {
	Video * self;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO, Video);
#line 364 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_rec_mutex_clear (&self->priv->__lock_backing_row);
#line 364 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_row_unref0 (self->priv->backing_row);
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_OBJECT_CLASS (video_parent_class)->finalize (obj);
#line 9950 "VideoSupport.c"
}


GType video_get_type (void) {
	static volatile gsize video_type_id__volatile = 0;
	if (g_once_init_enter (&video_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VideoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Video), 0, (GInstanceInitFunc) video_instance_init, NULL };
		static const GInterfaceInfo flaggable_info = { (GInterfaceInitFunc) video_flaggable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo monitorable_info = { (GInterfaceInitFunc) video_monitorable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo dateable_info = { (GInterfaceInitFunc) video_dateable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType video_type_id;
		video_type_id = g_type_register_static (TYPE_VIDEO_SOURCE, "Video", &g_define_type_info, 0);
		g_type_add_interface_static (video_type_id, TYPE_FLAGGABLE, &flaggable_info);
		g_type_add_interface_static (video_type_id, TYPE_MONITORABLE, &monitorable_info);
		g_type_add_interface_static (video_type_id, TYPE_DATEABLE, &dateable_info);
		g_once_init_leave (&video_type_id__volatile, video_type_id);
	}
	return video_type_id__volatile;
}


GType video_source_collection_state_get_type (void) {
	static volatile gsize video_source_collection_state_type_id__volatile = 0;
	if (g_once_init_enter (&video_source_collection_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN, "VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN", "unknown"}, {VIDEO_SOURCE_COLLECTION_STATE_ONLINE, "VIDEO_SOURCE_COLLECTION_STATE_ONLINE", "online"}, {VIDEO_SOURCE_COLLECTION_STATE_OFFLINE, "VIDEO_SOURCE_COLLECTION_STATE_OFFLINE", "offline"}, {VIDEO_SOURCE_COLLECTION_STATE_TRASH, "VIDEO_SOURCE_COLLECTION_STATE_TRASH", "trash"}, {0, NULL, NULL}};
		GType video_source_collection_state_type_id;
		video_source_collection_state_type_id = g_enum_register_static ("VideoSourceCollectionState", values);
		g_once_init_leave (&video_source_collection_state_type_id__volatile, video_source_collection_state_type_id);
	}
	return video_source_collection_state_type_id__volatile;
}


static gint _uint64_compare_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = uint64_compare ((guint64*) a, (guint64*) b);
#line 1073 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 9989 "VideoSupport.c"
}


static guint64* _uint64_dup (guint64* self) {
	guint64* dup;
#line 1073 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	dup = g_new0 (guint64, 1);
#line 1073 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	memcpy (dup, self, sizeof (guint64));
#line 1073 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return dup;
#line 10001 "VideoSupport.c"
}


static gint64 _video_source_collection_get_video_key_get_source_database_key (DataSource* source, gpointer self) {
	gint64 result;
	result = video_source_collection_get_video_key (source);
#line 1077 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10010 "VideoSupport.c"
}


static void _video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender, GeeCollection* added, GeeCollection* removed, gpointer self) {
#line 1079 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_source_collection_on_trashcan_contents_altered ((VideoSourceCollection*) self, added, removed);
#line 10017 "VideoSupport.c"
}


static void _video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender, GeeCollection* added, GeeCollection* removed, gpointer self) {
#line 1080 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_source_collection_on_offline_contents_altered ((VideoSourceCollection*) self, added, removed);
#line 10024 "VideoSupport.c"
}


VideoSourceCollection* video_source_collection_construct (GType object_type) {
	VideoSourceCollection* self = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSourceHoldingTank* _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
#line 1077 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (VideoSourceCollection*) media_source_collection_construct (object_type, "VideoSourceCollection", _video_source_collection_get_video_key_get_source_database_key, NULL);
#line 1079 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_collection_get_trashcan (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1079 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 1079 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), "contents-altered", (GCallback) _video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered, self);
#line 1079 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_source_holding_tank_unref0 (_tmp1_);
#line 1080 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1080 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 1080 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), "contents-altered", (GCallback) _video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered, self);
#line 1080 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_source_holding_tank_unref0 (_tmp3_);
#line 1076 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 10054 "VideoSupport.c"
}


VideoSourceCollection* video_source_collection_new (void) {
#line 1076 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_source_collection_construct (TYPE_VIDEO_SOURCE_COLLECTION);
#line 10061 "VideoSupport.c"
}


static gboolean _video_source_collection_is_video_trashed_source_holding_tank_check_to_keep (DataSource* source, Alteration* alteration, gpointer self) {
	gboolean result;
	result = video_source_collection_is_video_trashed (source);
#line 1084 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10070 "VideoSupport.c"
}


static MediaSourceHoldingTank* video_source_collection_real_create_trashcan (MediaSourceCollection* base) {
	VideoSourceCollection * self;
	MediaSourceHoldingTank* result = NULL;
	MediaSourceHoldingTank* _tmp0_;
#line 1083 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1084 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_holding_tank_new (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), _video_source_collection_is_video_trashed_source_holding_tank_check_to_keep, NULL, _video_source_collection_get_video_key_get_source_database_key, NULL);
#line 1084 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 1084 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10086 "VideoSupport.c"
}


static gboolean _video_source_collection_is_video_offline_source_holding_tank_check_to_keep (DataSource* source, Alteration* alteration, gpointer self) {
	gboolean result;
	result = video_source_collection_is_video_offline (source);
#line 1088 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10095 "VideoSupport.c"
}


static MediaSourceHoldingTank* video_source_collection_real_create_offline_bin (MediaSourceCollection* base) {
	VideoSourceCollection * self;
	MediaSourceHoldingTank* result = NULL;
	MediaSourceHoldingTank* _tmp0_;
#line 1087 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1088 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_holding_tank_new (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), _video_source_collection_is_video_offline_source_holding_tank_check_to_keep, NULL, _video_source_collection_get_video_key_get_source_database_key, NULL);
#line 1088 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 1088 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10111 "VideoSupport.c"
}


static MediaMonitor* video_source_collection_real_create_media_monitor (MediaSourceCollection* base, Workers* workers, GCancellable* cancellable) {
	VideoSourceCollection * self;
	MediaMonitor* result = NULL;
	GCancellable* _tmp0_;
	VideoMonitor* _tmp1_;
#line 1091 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1091 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_WORKERS (workers), NULL);
#line 1091 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_CANCELLABLE (cancellable), NULL);
#line 1092 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = cancellable;
#line 1092 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = video_monitor_new (_tmp0_);
#line 1092 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_MEDIA_MONITOR, MediaMonitor);
#line 1092 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10134 "VideoSupport.c"
}


static gboolean video_source_collection_real_holds_type_of_source (SourceCollection* base, DataSource* source) {
	VideoSourceCollection * self;
	gboolean result = FALSE;
	DataSource* _tmp0_;
#line 1095 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1095 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 1096 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = source;
#line 1096 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_VIDEO);
#line 1096 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10152 "VideoSupport.c"
}


static gchar* video_source_collection_real_get_typename (MediaSourceCollection* base) {
	VideoSourceCollection * self;
	gchar* result = NULL;
	gchar* _tmp0_;
#line 1099 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1100 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = g_strdup (VIDEO_TYPENAME);
#line 1100 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 1100 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10168 "VideoSupport.c"
}


static gboolean video_source_collection_real_is_file_recognized (MediaSourceCollection* base, GFile* file) {
	VideoSourceCollection * self;
	gboolean result = FALSE;
	GFile* _tmp0_;
	gboolean _tmp1_;
#line 1103 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1103 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 1104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = file;
#line 1104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = video_reader_is_supported_video_file (_tmp0_);
#line 1104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp1_;
#line 1104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10189 "VideoSupport.c"
}


static void video_source_collection_on_trashcan_contents_altered (VideoSourceCollection* self, GeeCollection* added, GeeCollection* removed) {
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
#line 1107 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1107 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 1107 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 1109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = added;
#line 1109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = removed;
#line 1109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), "trashcan-contents-altered", G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 10208 "VideoSupport.c"
}


static void video_source_collection_on_offline_contents_altered (VideoSourceCollection* self, GeeCollection* added, GeeCollection* removed) {
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
#line 1113 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1113 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 1113 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 1115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = added;
#line 1115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = removed;
#line 1115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), "offline-contents-altered", G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 10227 "VideoSupport.c"
}


static MediaSource* video_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base, gint64 numeric_id) {
	VideoSourceCollection * self;
	MediaSource* result = NULL;
	gint64 _tmp0_;
	VideoID _tmp1_ = {0};
	Video* _tmp2_;
#line 1119 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1120 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = numeric_id;
#line 1120 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id_init (&_tmp1_, _tmp0_);
#line 1120 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = video_source_collection_fetch (self, &_tmp1_);
#line 1120 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_MEDIA_SOURCE, MediaSource);
#line 1120 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10249 "VideoSupport.c"
}


gint64 video_source_collection_get_video_key (DataSource* source) {
	gint64 result = 0LL;
	Video* video = NULL;
	DataSource* _tmp0_;
	Video* _tmp1_;
	VideoID video_id = {0};
	VideoID _tmp2_ = {0};
	VideoID _tmp3_;
	gint64 _tmp4_;
#line 1123 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0LL);
#line 1124 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = source;
#line 1124 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_VIDEO, Video));
#line 1124 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video = _tmp1_;
#line 1125 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_get_video_id (video, &_tmp2_);
#line 1125 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id = _tmp2_;
#line 1127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_id;
#line 1127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_.id;
#line 1127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp4_;
#line 1127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (video);
#line 1127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10284 "VideoSupport.c"
}


gboolean video_source_collection_is_video_trashed (DataSource* source) {
	gboolean result = FALSE;
	DataSource* _tmp0_;
	gboolean _tmp1_;
#line 1130 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 1131 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = source;
#line 1131 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_is_trashed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_VIDEO, Video), TYPE_MEDIA_SOURCE, MediaSource));
#line 1131 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp1_;
#line 1131 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10302 "VideoSupport.c"
}


gboolean video_source_collection_is_video_offline (DataSource* source) {
	gboolean result = FALSE;
	DataSource* _tmp0_;
	gboolean _tmp1_;
#line 1134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 1135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = source;
#line 1135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_is_offline (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_VIDEO, Video), TYPE_MEDIA_SOURCE, MediaSource));
#line 1135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp1_;
#line 1135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10320 "VideoSupport.c"
}


Video* video_source_collection_fetch (VideoSourceCollection* self, VideoID* video_id) {
	Video* result = NULL;
	VideoID _tmp0_;
	gint64 _tmp1_;
	DataSource* _tmp2_;
#line 1138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_SOURCE_COLLECTION (self), NULL);
#line 1138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (video_id != NULL, NULL);
#line 1139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = *video_id;
#line 1139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_.id;
#line 1139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = database_source_collection_fetch_by_key (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), _tmp1_);
#line 1139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_VIDEO, Video);
#line 1139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10343 "VideoSupport.c"
}


static GeeCollection* video_source_collection_real_get_event_source_ids (MediaSourceCollection* base, EventID* event_id) {
	VideoSourceCollection * self;
	GeeCollection* result = NULL;
	VideoTable* _tmp0_;
	VideoTable* _tmp1_;
	EventID _tmp2_;
	GeeArrayList* _tmp3_;
	GeeCollection* _tmp4_;
#line 1142 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1142 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (event_id != NULL, NULL);
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_table_get_instance ();
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = *event_id;
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_table_get_event_source_ids (_tmp1_, &_tmp2_);
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_database_table_unref0 (_tmp1_);
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp4_;
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10375 "VideoSupport.c"
}


Video* video_source_collection_get_state_by_file (VideoSourceCollection* self, GFile* file, VideoSourceCollectionState* state) {
	VideoSourceCollectionState _vala_state = 0;
	Video* result = NULL;
	Video* video = NULL;
	GFile* _tmp0_;
	MediaSource* _tmp1_;
	Video* _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
	MediaSourceHoldingTank* _tmp4_;
	GFile* _tmp5_;
	MediaSource* _tmp6_;
	Video* _tmp7_;
	MediaSourceHoldingTank* _tmp8_;
	MediaSourceHoldingTank* _tmp9_;
	GFile* _tmp10_;
	MediaSource* _tmp11_;
	Video* _tmp12_;
#line 1146 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_SOURCE_COLLECTION (self), NULL);
#line 1146 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 1147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = file;
#line 1147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_collection_fetch_by_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), _tmp0_);
#line 1147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_VIDEO, Video);
#line 1148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = video;
#line 1148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp2_ != NULL) {
#line 1149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_ONLINE;
#line 1151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = video;
#line 1151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (state) {
#line 1151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*state = _vala_state;
#line 10418 "VideoSupport.c"
		}
#line 1151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 10422 "VideoSupport.c"
	}
#line 1154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = media_source_collection_get_trashcan (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 1154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = file;
#line 1154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = media_source_holding_tank_fetch_by_master_file (_tmp4_, _tmp5_);
#line 1154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (video);
#line 1154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_VIDEO, Video);
#line 1154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_source_holding_tank_unref0 (_tmp4_);
#line 1155 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = video;
#line 1155 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp7_ != NULL) {
#line 1156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_TRASH;
#line 1158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = video;
#line 1158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (state) {
#line 1158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*state = _vala_state;
#line 10450 "VideoSupport.c"
		}
#line 1158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 10454 "VideoSupport.c"
	}
#line 1161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_ = _tmp8_;
#line 1161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10_ = file;
#line 1161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp11_ = media_source_holding_tank_fetch_by_master_file (_tmp9_, _tmp10_);
#line 1161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (video);
#line 1161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_VIDEO, Video);
#line 1161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_source_holding_tank_unref0 (_tmp9_);
#line 1162 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp12_ = video;
#line 1162 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp12_ != NULL) {
#line 1163 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_OFFLINE;
#line 1165 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = video;
#line 1165 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (state) {
#line 1165 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*state = _vala_state;
#line 10482 "VideoSupport.c"
		}
#line 1165 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 10486 "VideoSupport.c"
	}
#line 1168 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_state = VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN;
#line 1170 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = NULL;
#line 1170 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (video);
#line 1170 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (state) {
#line 1170 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*state = _vala_state;
#line 10498 "VideoSupport.c"
	}
#line 1170 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10502 "VideoSupport.c"
}


static void video_source_collection_compare_backing (VideoSourceCollection* self, Video* video, GFileInfo* info, GeeCollection* matching_master) {
	Video* _tmp0_;
	guint64 _tmp1_;
	GFileInfo* _tmp2_;
	gint64 _tmp3_;
	Video* _tmp4_;
	time_t _tmp5_;
	GFileInfo* _tmp6_;
	GTimeVal _tmp7_ = {0};
	glong _tmp8_;
#line 1173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (video));
#line 1173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 1173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (GEE_IS_COLLECTION (matching_master));
#line 1174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video;
#line 1174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_get_filesize (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE, MediaSource));
#line 1174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = info;
#line 1174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = g_file_info_get_size (_tmp2_);
#line 1174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_ != ((guint64) _tmp3_)) {
#line 1175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 10536 "VideoSupport.c"
	}
#line 1177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = video;
#line 1177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = media_source_get_timestamp (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MEDIA_SOURCE, MediaSource));
#line 1177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = info;
#line 1177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_file_info_get_modification_time (_tmp6_, &_tmp7_);
#line 1177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = _tmp7_.tv_sec;
#line 1177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp5_ == ((time_t) _tmp8_)) {
#line 10550 "VideoSupport.c"
		GeeCollection* _tmp9_;
		Video* _tmp10_;
#line 1178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = matching_master;
#line 1178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = video;
#line 1178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		gee_collection_add (_tmp9_, _tmp10_);
#line 10559 "VideoSupport.c"
	}
}


void video_source_collection_fetch_by_matching_backing (VideoSourceCollection* self, GFileInfo* info, GeeCollection* matching_master) {
#line 1181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 1181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (GEE_IS_COLLECTION (matching_master));
#line 10571 "VideoSupport.c"
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp0_;
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = _tmp2_;
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp1_);
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_object_it = _tmp3_;
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		while (TRUE) {
#line 10592 "VideoSupport.c"
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			DataObject* _tmp8_;
			GFileInfo* _tmp9_;
			GeeCollection* _tmp10_;
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _object_it;
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (!_tmp5_) {
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				break;
#line 10609 "VideoSupport.c"
			}
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = _object_it;
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			object = (DataObject*) _tmp7_;
#line 1183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = object;
#line 1183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = info;
#line 1183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = matching_master;
#line 1183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_source_collection_compare_backing (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_VIDEO, Video), _tmp9_, _tmp10_);
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (object);
#line 10627 "VideoSupport.c"
		}
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_object_it);
#line 10631 "VideoSupport.c"
	}
	{
		GeeIterator* _media_it = NULL;
		GeeCollection* _tmp11_;
		GeeCollection* _tmp12_;
		GeeIterator* _tmp13_;
		GeeIterator* _tmp14_;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = media_source_collection_get_offline_bin_contents (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = _tmp11_;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp14_ = _tmp13_;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp12_);
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_media_it = _tmp14_;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		while (TRUE) {
#line 10653 "VideoSupport.c"
			GeeIterator* _tmp15_;
			gboolean _tmp16_;
			MediaSource* media = NULL;
			GeeIterator* _tmp17_;
			gpointer _tmp18_;
			MediaSource* _tmp19_;
			GFileInfo* _tmp20_;
			GeeCollection* _tmp21_;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp15_ = _media_it;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_ = gee_iterator_next (_tmp15_);
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (!_tmp16_) {
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				break;
#line 10670 "VideoSupport.c"
			}
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = _media_it;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_ = gee_iterator_get (_tmp17_);
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			media = (MediaSource*) _tmp18_;
#line 1186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp19_ = media;
#line 1186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp20_ = info;
#line 1186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_ = matching_master;
#line 1186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_source_collection_compare_backing (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_VIDEO, Video), _tmp20_, _tmp21_);
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (media);
#line 10688 "VideoSupport.c"
		}
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_media_it);
#line 10692 "VideoSupport.c"
	}
}


static void video_source_collection_real_notify_contents_altered (DataCollection* base, GeeIterable* added, GeeIterable* removed) {
	VideoSourceCollection * self;
	GeeIterable* _tmp0_;
	GeeIterable* _tmp13_;
	GeeIterable* _tmp26_;
	GeeIterable* _tmp27_;
#line 1189 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1189 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_ITERABLE (added));
#line 1189 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_ITERABLE (removed));
#line 1191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = added;
#line 1191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_ != NULL) {
#line 10713 "VideoSupport.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterable* _tmp1_;
			GeeIterator* _tmp2_;
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = added;
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = gee_iterable_iterator (_tmp1_);
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_object_it = _tmp2_;
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			while (TRUE) {
#line 10726 "VideoSupport.c"
				GeeIterator* _tmp3_;
				gboolean _tmp4_;
				DataObject* object = NULL;
				GeeIterator* _tmp5_;
				gpointer _tmp6_;
				Video* video = NULL;
				DataObject* _tmp7_;
				Video* _tmp8_;
				GeeMultiMap* _tmp9_;
				Video* _tmp10_;
				guint64 _tmp11_;
				Video* _tmp12_;
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = _object_it;
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = gee_iterator_next (_tmp3_);
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!_tmp4_) {
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					break;
#line 10747 "VideoSupport.c"
				}
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = _object_it;
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				object = (DataObject*) _tmp6_;
#line 1193 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = object;
#line 1193 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_VIDEO, Video));
#line 1193 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video = _tmp8_;
#line 1195 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = self->priv->filesize_to_video;
#line 1195 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = video;
#line 1195 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = media_source_get_master_filesize (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MEDIA_SOURCE, MediaSource));
#line 1195 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = video;
#line 1195 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				gee_multi_map_set (_tmp9_, &_tmp11_, _tmp12_);
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (object);
#line 10775 "VideoSupport.c"
			}
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_object_it);
#line 10779 "VideoSupport.c"
		}
	}
#line 1199 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = removed;
#line 1199 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp13_ != NULL) {
#line 10786 "VideoSupport.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterable* _tmp14_;
			GeeIterator* _tmp15_;
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp14_ = removed;
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp15_ = gee_iterable_iterator (_tmp14_);
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_object_it = _tmp15_;
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			while (TRUE) {
#line 10799 "VideoSupport.c"
				GeeIterator* _tmp16_;
				gboolean _tmp17_;
				DataObject* object = NULL;
				GeeIterator* _tmp18_;
				gpointer _tmp19_;
				Video* video = NULL;
				DataObject* _tmp20_;
				Video* _tmp21_;
				GeeMultiMap* _tmp22_;
				Video* _tmp23_;
				guint64 _tmp24_;
				Video* _tmp25_;
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = _object_it;
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = gee_iterator_next (_tmp16_);
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!_tmp17_) {
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					break;
#line 10820 "VideoSupport.c"
				}
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp18_ = _object_it;
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp19_ = gee_iterator_get (_tmp18_);
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				object = (DataObject*) _tmp19_;
#line 1201 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp20_ = object;
#line 1201 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_VIDEO, Video));
#line 1201 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video = _tmp21_;
#line 1203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp22_ = self->priv->filesize_to_video;
#line 1203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp23_ = video;
#line 1203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp24_ = media_source_get_master_filesize (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_MEDIA_SOURCE, MediaSource));
#line 1203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp25_ = video;
#line 1203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				gee_multi_map_remove (_tmp22_, &_tmp24_, _tmp25_);
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (object);
#line 10848 "VideoSupport.c"
			}
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_object_it);
#line 10852 "VideoSupport.c"
		}
	}
#line 1207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp26_ = added;
#line 1207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = removed;
#line 1207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	DATA_COLLECTION_CLASS (video_source_collection_parent_class)->notify_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), TYPE_DATA_COLLECTION, DataCollection), _tmp26_, _tmp27_);
#line 10861 "VideoSupport.c"
}


void video_source_collection_get_basename_filesize_duplicate (VideoSourceCollection* self, const gchar* basename, guint64 filesize, VideoID* result) {
	VideoID _tmp19_ = {0};
#line 1210 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1210 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (basename != NULL);
#line 10871 "VideoSupport.c"
	{
		GeeIterator* _video_it = NULL;
		GeeMultiMap* _tmp0_;
		guint64 _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->filesize_to_video;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = filesize;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = gee_multi_map_get (_tmp0_, &_tmp1_);
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = _tmp2_;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = _tmp4_;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp3_);
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_it = _tmp5_;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		while (TRUE) {
#line 10898 "VideoSupport.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_;
			Video* video = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			Video* _tmp10_;
			GFile* _tmp11_;
			GFile* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gboolean _tmp16_;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = _video_it;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (!_tmp7_) {
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				break;
#line 10919 "VideoSupport.c"
			}
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = _video_it;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video = (Video*) _tmp9_;
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = video;
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MEDIA_SOURCE, MediaSource));
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = _tmp11_;
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp13_ = g_file_get_basename (_tmp12_);
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp14_ = basename;
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp15_ = utf8_ci_compare (_tmp13_, _tmp14_);
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_ = _tmp15_ == 0;
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_tmp12_);
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp16_) {
#line 10945 "VideoSupport.c"
				Video* _tmp17_;
				VideoID _tmp18_ = {0};
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = video;
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_get_video_id (_tmp17_, &_tmp18_);
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				*result = _tmp18_;
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (_video_it);
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 10960 "VideoSupport.c"
			}
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (video);
#line 10964 "VideoSupport.c"
		}
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_video_it);
#line 10968 "VideoSupport.c"
	}
#line 1216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id_init (&_tmp19_, VIDEO_ID_INVALID);
#line 1216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	*result = _tmp19_;
#line 1216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return;
#line 10976 "VideoSupport.c"
}


gboolean video_source_collection_has_basename_filesize_duplicate (VideoSourceCollection* self, const gchar* basename, guint64 filesize) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	guint64 _tmp1_;
	VideoID _tmp2_ = {0};
	gboolean _tmp3_;
#line 1220 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_SOURCE_COLLECTION (self), FALSE);
#line 1220 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (basename != NULL, FALSE);
#line 1221 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = basename;
#line 1221 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = filesize;
#line 1221 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_source_collection_get_basename_filesize_duplicate (self, _tmp0_, _tmp1_, &_tmp2_);
#line 1221 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_id_is_valid (&_tmp2_);
#line 1221 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp3_;
#line 1221 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 11002 "VideoSupport.c"
}


static TransactionController* video_source_collection_real_get_transaction_controller (MediaSourceCollection* base) {
	TransactionController* result;
	VideoSourceCollection* self;
	TransactionController* _tmp0_;
	TransactionController* _tmp2_;
#line 1064 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1065 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->_transaction_controller;
#line 1065 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_ == NULL) {
#line 11017 "VideoSupport.c"
		MediaSourceTransactionController* _tmp1_;
#line 1066 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = media_source_transaction_controller_new (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1066 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_transaction_controller_unref0 (self->priv->_transaction_controller);
#line 1066 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		self->priv->_transaction_controller = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TRANSACTION_CONTROLLER, TransactionController);
#line 11025 "VideoSupport.c"
	}
#line 1068 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = self->priv->_transaction_controller;
#line 1068 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp2_;
#line 1068 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 11033 "VideoSupport.c"
}


static void video_source_collection_class_init (VideoSourceCollectionClass * klass) {
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_source_collection_parent_class = g_type_class_peek_parent (klass);
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataCollectionClass *) klass)->finalize = video_source_collection_finalize;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_type_class_add_private (klass, sizeof (VideoSourceCollectionPrivate));
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->create_trashcan = (MediaSourceHoldingTank* (*) (MediaSourceCollection *)) video_source_collection_real_create_trashcan;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->create_offline_bin = (MediaSourceHoldingTank* (*) (MediaSourceCollection *)) video_source_collection_real_create_offline_bin;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->create_media_monitor = (MediaMonitor* (*) (MediaSourceCollection *, Workers*, GCancellable*)) video_source_collection_real_create_media_monitor;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection *, DataSource*)) video_source_collection_real_holds_type_of_source;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->get_typename = (gchar* (*) (MediaSourceCollection *)) video_source_collection_real_get_typename;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->is_file_recognized = (gboolean (*) (MediaSourceCollection *, GFile*)) video_source_collection_real_is_file_recognized;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->fetch_by_numeric_id = (MediaSource* (*) (MediaSourceCollection *, gint64)) video_source_collection_real_fetch_by_numeric_id;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->get_event_source_ids = (GeeCollection* (*) (MediaSourceCollection *, EventID*)) video_source_collection_real_get_event_source_ids;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataCollectionClass *) klass)->notify_contents_altered = (void (*) (DataCollection *, GeeIterable*, GeeIterable*)) video_source_collection_real_notify_contents_altered;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	MEDIA_SOURCE_COLLECTION_CLASS (klass)->get_transaction_controller = video_source_collection_real_get_transaction_controller;
#line 11064 "VideoSupport.c"
}


static void video_source_collection_instance_init (VideoSourceCollection * self) {
	GeeTreeMultiMap* _tmp0_;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv = VIDEO_SOURCE_COLLECTION_GET_PRIVATE (self);
#line 1072 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->_transaction_controller = NULL;
#line 1073 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = gee_tree_multi_map_new (G_TYPE_UINT64, (GBoxedCopyFunc) _uint64_dup, (GDestroyNotify) g_free, TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _uint64_compare_gcompare_data_func, NULL, NULL, NULL, NULL, NULL);
#line 1073 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->filesize_to_video = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
#line 11078 "VideoSupport.c"
}


static void video_source_collection_finalize (DataCollection * obj) {
	VideoSourceCollection * self;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1072 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_transaction_controller_unref0 (self->priv->_transaction_controller);
#line 1073 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->filesize_to_video);
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	DATA_COLLECTION_CLASS (video_source_collection_parent_class)->finalize (obj);
#line 11092 "VideoSupport.c"
}


GType video_source_collection_get_type (void) {
	static volatile gsize video_source_collection_type_id__volatile = 0;
	if (g_once_init_enter (&video_source_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VideoSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoSourceCollection), 0, (GInstanceInitFunc) video_source_collection_instance_init, NULL };
		GType video_source_collection_type_id;
		video_source_collection_type_id = g_type_register_static (TYPE_MEDIA_SOURCE_COLLECTION, "VideoSourceCollection", &g_define_type_info, 0);
		g_once_init_leave (&video_source_collection_type_id__volatile, video_source_collection_type_id);
	}
	return video_source_collection_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



