===========
Request IDs
===========

All logs on the system, by default, include the global request ID and
the local request ID when available.
The local request ID is a unique ID locally generated by each service,
and thus different for each service (Nova, Cinder, Glance, Neutron, etc.)
involved in that operation. The format is ``req-`` + UUID (UUID4).
The global request ID is a user-specified request ID which is utilized as
a common identifier by all services. This request ID is same among all
services involved in that operation. The format is ``req-`` + UUID (UUID4).
This allows an administrator to track
the API request processing as it transitions between all the different
nova services or between nova and other component services called by Nova
during that request.

Even if specifying a global request ID in a request, users receive always
a local request ID as the response.

For more details about request IDs, please reference: `Faults
<https://developer.openstack.org/api-guide/compute/faults.html>`_
(It is *not* for Placement APIs, but there are some common points.)

**Request**

.. NOTE(takashin): The 'rest_parameters' directive needs the 'rest_method'
                   directive before itself. But this file does not contain
                   the 'rest_method' directive.
                   So the 'rest_parameters' directive is not used.

.. list-table::
  :widths: 20 10 10 60
  :header-rows: 1

  * - Name
    - In
    - Type
    - Description
  * - X-Openstack-Request-Id (Optional)
    - header
    - string
    - The global request ID, which is a unique common ID for tracking each
      request in OpenStack components. The format of the global request ID
      must be ``req-`` + UUID (UUID4). If not in accordance with the format,
      it is ignored. It is associated with the request and appears in the log
      lines for that request. By default, the middleware configuration ensures
      that the global request ID appears in the log files.

**Response**

.. list-table::
  :widths: 20 10 10 60
  :header-rows: 1

  * - Name
    - In
    - Type
    - Description
  * - X-Openstack-Request-Id
    - header
    - string
    - The local request ID, which is a unique ID generated automatically for
      tracking each request to nova. It is associated with the request and
      appears in the log lines for that request. By default, the middleware
      configuration ensures that the local request ID appears in the log files.
