/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;

public class PaletteLayout
implements LayoutManager {
    private int fGap;
    private Point fBorder;
    private boolean fVerticalLayout;

    public PaletteLayout(int n) {
        this(n, new Point(0, 0), true);
    }

    public PaletteLayout(int n, Point point) {
        this(n, point, true);
    }

    public PaletteLayout(int n, Point point, boolean bl) {
        this.fGap = n;
        this.fBorder = point;
        this.fVerticalLayout = bl;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getMinimumSize();
            if (this.fVerticalLayout) {
                dimension.width = Math.max(dimension.width, dimension2.width);
                if (i > 0) {
                    dimension.height += this.fGap;
                }
                dimension.height += dimension2.height;
                continue;
            }
            dimension.height = Math.max(dimension.height, dimension2.height);
            if (i > 0) {
                dimension.width += this.fGap;
            }
            dimension.width += dimension2.width;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.width += 2 * this.fBorder.x;
        dimension.height += insets.top + insets.bottom;
        dimension.height += 2 * this.fBorder.y;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = insets.left + this.fBorder.x;
        int n3 = insets.top + this.fBorder.y;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getMinimumSize();
            component.setBounds(n2, n3, dimension.width, dimension.height);
            if (this.fVerticalLayout) {
                n3 += dimension.height;
                n3 += this.fGap;
                continue;
            }
            n2 += dimension.width;
            n2 += this.fGap;
        }
    }
}

