/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-context.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#ifndef __UNITY_WEBAPPS_CONTEXT_H
#define __UNITY_WEBAPPS_CONTEXT_H


#include "unity-webapps-service.h"

#define UNITY_WEBAPPS_TYPE_CONTEXT              (unity_webapps_context_get_type())
#define UNITY_WEBAPPS_CONTEXT(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_CONTEXT, UnityWebappsContext))
#define UNITY_WEBAPPS_CONTEXT_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_CONTEXT, UnityWebappsContextClass))
#define UNITY_WEBAPPS_IS_CONTEXT(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_CONTEXT))
#define UNITY_WEBAPPS_IS_CONTEXT_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_CONTEXT))
#define UNITY_WEBAPPS_CONTEXT_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_CONTEXT, UnityWebappsContextClass))

typedef struct _UnityWebappsContextPrivate UnityWebappsContextPrivate;

typedef struct _UnityWebappsContext UnityWebappsContext;

#include "unity-webapps-notification-context.h"
#include "unity-webapps-indicator-context.h"
#include "unity-webapps-music-player-context.h"
#include "unity-webapps-launcher-context.h"

typedef void (*UnityWebappsContextAcceptDataChanged) (UnityWebappsContext *context, const gchar **file, gpointer user_data);

struct _UnityWebappsContext {
	GObject object;
	UnityWebappsContextPrivate *priv;
};

typedef struct _UnityWebappsContextClass UnityWebappsContextClass;

struct _UnityWebappsContextClass
{
	GObjectClass parent_class;

	UnityWebappsContextAcceptDataChanged accept_data_changed;
};

typedef struct
{
	const gchar *str;
} UnityWebappsStrWrapperDesc;

typedef void (*UnityWebappsContextReadyCallback) (UnityWebappsContext *, gpointer user_data);
typedef void (*UnityWebappsContextRaiseCallback) (UnityWebappsContext *context, const gchar *file, gpointer user_data);
typedef void (*UnityWebappsContextCloseCallback) (UnityWebappsContext *context, gpointer user_data);

typedef void (*UnityWebappsContextNotifyCallback) (UnityWebappsContext *, gint, gpointer);
typedef void (*UnityWebappsContextViewNotifyCallback) (UnityWebappsContext *, gint, gboolean, gpointer);
typedef void (*UnityWebappsContextLocationNotifyCallback) (UnityWebappsContext *, gint, const gchar *, gpointer);
typedef void (*UnityWebappsContextWindowNotifyCallback) (UnityWebappsContext *, gint, guint64, gpointer);
typedef const gchar * (*UnityWebappsContextPreviewCallback) (UnityWebappsContext *context, gpointer user_data);
typedef void (*UnityWebappsContextPreviewReadyCallback) (UnityWebappsContext *context, gint interest_id, const gchar *preview_data, gpointer user_data);
typedef void (*UnityWebappsContextActionCallback) (UnityWebappsContext *context, gpointer user_data);

typedef struct
{
	const gchar *path;
	UnityWebappsContextActionCallback callback;
	gpointer user_data;
} UnityWebappsApplicationActionDesc;

#define UNITY_WEBAPPS_CONTEXT_MENU_PATH "/com/canonical/Unity/Webapps/Context/ApplicationActions"

GType unity_webapps_context_get_type (void) G_GNUC_CONST;

void unity_webapps_context_new (UnityWebappsService *service,
								const gchar *name,
								const gchar *domain,
								const gchar *icon_url,
								const gchar *mime_types,
								UnityWebappsContextReadyCallback callback,
								gpointer user_data);

UnityWebappsContext * unity_webapps_context_new_lazy (UnityWebappsService *service,
													  const gchar *name,
													  const gchar *domain,
													  const gchar *icon_url,
													  const gchar *mime_types);

UnityWebappsContext *unity_webapps_context_new_sync (UnityWebappsService *service,
													 const gchar *name,
													 const gchar *domain,
													 const gchar *icon_url,
													 const gchar *mime_types);

void unity_webapps_context_destroy (UnityWebappsContext *context, gboolean user_abandoned);

const gchar *unity_webapps_context_get_context_name (UnityWebappsContext *context);

const gchar *unity_webapps_context_get_name (UnityWebappsContext *context);
const gchar *unity_webapps_context_get_domain (UnityWebappsContext *context);
const gchar *unity_webapps_context_get_desktop_name (UnityWebappsContext *context);
gint unity_webapps_context_get_interest_id (UnityWebappsContext *context);
gchar *unity_webapps_context_get_icon_name (UnityWebappsContext *context);

void unity_webapps_context_add_icon (UnityWebappsContext *context, const gchar *url, gint size);

void unity_webapps_context_on_raise_callback (UnityWebappsContext *context, UnityWebappsContextRaiseCallback callback, gpointer user_data);
void unity_webapps_context_on_close_callback (UnityWebappsContext *context, UnityWebappsContextCloseCallback callback, gpointer user_data);

gboolean unity_webapps_context_get_view_is_active (UnityWebappsContext *context, gint interest_id);
void unity_webapps_context_set_view_is_active (UnityWebappsContext *context, gboolean active);

void unity_webapps_context_on_view_is_active_changed (UnityWebappsContext *context,
													  UnityWebappsContextViewNotifyCallback callback,
													  gpointer user_data);

UnityWebappsContext * unity_webapps_context_new_for_context_name (UnityWebappsService *service,
																  const gchar *context_name);

GVariant *unity_webapps_context_list_interests (UnityWebappsContext *context);

void unity_webapps_context_on_interest_appeared (UnityWebappsContext *context,
												 UnityWebappsContextNotifyCallback callback,
												 gpointer user_data);
void unity_webapps_context_on_interest_vanished (UnityWebappsContext *context,
												 UnityWebappsContextNotifyCallback callback,
												 gpointer user_data);

void unity_webapps_context_raise (UnityWebappsContext *context);
void unity_webapps_context_raise_interest (UnityWebappsContext *context, gint interest_id);
void unity_webapps_context_close (UnityWebappsContext *context);
void unity_webapps_context_close_interest (UnityWebappsContext *context, gint interest_id);


gchar *unity_webapps_context_get_interest_owner (UnityWebappsContext *context, gint interest_id);

gchar * unity_webapps_context_get_view_location (UnityWebappsContext *context, gint interest_id);
void unity_webapps_context_set_view_location (UnityWebappsContext *context, const gchar *location);

void unity_webapps_context_on_view_location_changed (UnityWebappsContext *context,
													 UnityWebappsContextLocationNotifyCallback callback,
													 gpointer user_data);

guint64  unity_webapps_context_get_view_window (UnityWebappsContext *context, gint interest_id);
void unity_webapps_context_set_view_window (UnityWebappsContext *context, guint64 window);

void unity_webapps_context_on_view_window_changed (UnityWebappsContext *context,
													 UnityWebappsContextWindowNotifyCallback callback,
													 gpointer user_data);

void unity_webapps_context_set_preview_requested_callback (UnityWebappsContext *context,
														   UnityWebappsContextPreviewCallback callback,
														   gpointer user_data);

void unity_webapps_context_request_preview (UnityWebappsContext *context,
											gint interest_id,
											UnityWebappsContextPreviewReadyCallback callback,
											gpointer user_data);

gchar** unity_webapps_context_get_application_accept_data (UnityWebappsContext *context);

void unity_webapps_context_set_application_accept_data (UnityWebappsContext *context,
                                                        UnityWebappsStrWrapperDesc *mimes,
														gint len);

void unity_webapps_context_add_application_actions (UnityWebappsContext *context,
													UnityWebappsApplicationActionDesc *actions,
													gint len);

void unity_webapps_context_remove_application_action (UnityWebappsContext *context,
													  const gchar *label);
void unity_webapps_context_remove_application_actions (UnityWebappsContext *context);


UnityWebappsService *unity_webapps_context_get_service (UnityWebappsContext *context);

void unity_webapps_context_set_homepage (UnityWebappsContext *context,
										 const gchar *homepage);

void unity_webapps_service_set_xid_for_browser_window_id (UnityWebappsService *service,
														  UnityWebappsContext *context,
														  int window_id);

void unity_webapps_context_prepare (UnityWebappsContext *context, 
									UnityWebappsContextReadyCallback callback,
									gpointer user_data);

gint unity_webapps_context_get_focus_interest (UnityWebappsContext *context);

#endif
