; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mcpu=bdver1 | FileCheck %s

; clang -Oz -c test1.cpp -emit-llvm -S -o
; Verify that we generate shld insruction when we are optimizing for size,
; even for X86_64 processors that are known to have poor latency double
; precision shift instructions.
; uint64_t lshift10(uint64_t a, uint64_t b)
; {
;     return (a << 10) | (b >> 54);
; }

; Function Attrs: minsize nounwind readnone uwtable
define i64 @_Z8lshift10mm(i64 %a, i64 %b) #0 {
; CHECK-LABEL: _Z8lshift10mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rdi, %rax
; CHECK-NEXT:    shldq $10, %rsi, %rax
; CHECK-NEXT:    retq
entry:
  %shl = shl i64 %a, 10
  %shr = lshr i64 %b, 54
  %or = or i64 %shr, %shl
  ret i64 %or
}

attributes #0 = { minsize nounwind readnone uwtable "less-precise-fpmad"="false" "frame-pointer"="none" "no-infs-fp-math"="false" "no-nans-fp-math"="false" "stack-protector-buffer-size"="8" "unsafe-fp-math"="false" "use-soft-float"="false" }


; clang -Os -c test2.cpp -emit-llvm -S
; Verify that we generate shld insruction when we are optimizing for size,
; even for X86_64 processors that are known to have poor latency double
; precision shift instructions.
; uint64_t lshift11(uint64_t a, uint64_t b)
; {
;     return (a << 11) | (b >> 53);
; }

; Function Attrs: nounwind optsize readnone uwtable
define i64 @_Z8lshift11mm(i64 %a, i64 %b) #1 {
; CHECK-LABEL: _Z8lshift11mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rdi, %rax
; CHECK-NEXT:    shldq $11, %rsi, %rax
; CHECK-NEXT:    retq
entry:
  %shl = shl i64 %a, 11
  %shr = lshr i64 %b, 53
  %or = or i64 %shr, %shl
  ret i64 %or
}

define i64 @_Z8lshift11mm_pgso(i64 %a, i64 %b) !prof !14 {
; CHECK-LABEL: _Z8lshift11mm_pgso:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rdi, %rax
; CHECK-NEXT:    shldq $11, %rsi, %rax
; CHECK-NEXT:    retq
entry:
  %shl = shl i64 %a, 11
  %shr = lshr i64 %b, 53
  %or = or i64 %shr, %shl
  ret i64 %or
}

attributes #1 = { nounwind optsize readnone uwtable "less-precise-fpmad"="false" "frame-pointer"="none" "no-infs-fp-math"="false" "no-nans-fp-math"="false" "stack-protector-buffer-size"="8" "unsafe-fp-math"="false" "use-soft-float"="false" }

; clang -O2 -c test2.cpp -emit-llvm -S
; Verify that we do not generate shld insruction when we are not optimizing
; for size for X86_64 processors that are known to have poor latency double
; precision shift instructions.
; uint64_t lshift12(uint64_t a, uint64_t b)
; {
;     return (a << 12) | (b >> 52);
; }

; Function Attrs: nounwind optsize readnone uwtable
define i64 @_Z8lshift12mm(i64 %a, i64 %b) #2 {
; CHECK-LABEL: _Z8lshift12mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shlq $12, %rdi
; CHECK-NEXT:    shrq $52, %rsi
; CHECK-NEXT:    leaq (%rsi,%rdi), %rax
; CHECK-NEXT:    retq
entry:
  %shl = shl i64 %a, 12
  %shr = lshr i64 %b, 52
  %or = or i64 %shr, %shl
  ret i64 %or
}

attributes #2= { nounwind readnone uwtable "less-precise-fpmad"="false" "frame-pointer"="none" "no-infs-fp-math"="false" "no-nans-fp-math"="false" "stack-protector-buffer-size"="8" "unsafe-fp-math"="false" "use-soft-float"="false" }

!llvm.module.flags = !{!0}
!0 = !{i32 1, !"ProfileSummary", !1}
!1 = !{!2, !3, !4, !5, !6, !7, !8, !9}
!2 = !{!"ProfileFormat", !"InstrProf"}
!3 = !{!"TotalCount", i64 10000}
!4 = !{!"MaxCount", i64 10}
!5 = !{!"MaxInternalCount", i64 1}
!6 = !{!"MaxFunctionCount", i64 1000}
!7 = !{!"NumCounts", i64 3}
!8 = !{!"NumFunctions", i64 3}
!9 = !{!"DetailedSummary", !10}
!10 = !{!11, !12, !13}
!11 = !{i32 10000, i64 100, i32 1}
!12 = !{i32 999000, i64 100, i32 1}
!13 = !{i32 999999, i64 1, i32 2}
!14 = !{!"function_entry_count", i64 0}
