#include "mr_rr.h"

namespace ADNS {

	MR_RR::MR_RR()
	{
		rr_type = RR_TYPE::MR;
		rr_class = RR_CLASS::IN;
		newname = gcnew DOMAIN_NAME();
		UpdateRdata();
	}

	Void MR_RR::SetNewname(DOMAIN_NAME^ dn)
	{
		newname = gcnew DOMAIN_NAME(dn->GetName());
		UpdateRdata();
		return;
	}

	DOMAIN_NAME^ MR_RR::GetNewname()
	{
		return newname->Clone();
	}

	String^ MR_RR::Print()
	{
		String^ output;
		output = PrintHeader();
		output += newname->Print();

		return output;
	}

	Void MR_RR::UpdateRdata()
	{
		if (!rdata)
			rdata = gcnew array<Byte>(newname->GetName()->Length);
		else
			rdata->Resize(rdata,newname->GetName()->Length);

		newname->GetName()->CopyTo(rdata,0);

		return;
	}

	Void MR_RR::ToCanonical()
	{
		newname->MakeCanonical();
		owner->MakeCanonical();
		UpdateRdata();
		return;
	}

	MR_RR^ MR_RR::Clone()
	{
		MR_RR^ newrr = gcnew MR_RR();
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->newname = newname->Clone();
		newrr->UpdateRdata();
		return newrr;
	}
	
	ResourceRecord^ MR_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		MR_RR^ mrout;
		array<Byte>^ tmparray;
		int reallen;

		mrout = gcnew MR_RR();
		mrout->owner = gcnew DOMAIN_NAME(domainname);
		mrout->rr_class = (RR_CLASS) rr_class;
		mrout->ttl = ttl;
		tmparray = ReadDomainFromPacket(packet, rdata_start, reallen);
		mrout->SetNewname(gcnew DOMAIN_NAME(tmparray));
		return mrout;
	}

	String^ MR_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<MR_RR^>(rec)->Print();
	}

	ResourceRecord^ MR_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<MR_RR^>(rec)->Clone();
	}
}