KBD (Linux keyboard tools) [![CI](https://github.com/legionus/kbd/actions/workflows/ci.yml/badge.svg)](https://github.com/legionus/kbd/actions/workflows/ci.yml)
--------------------------

This package contains tools for managing Linux console (Linux console, virtual
terminals, keyboard, etc.) – mainly, what they do is loading console fonts and
keyboard maps.

This distribution contains no binaries - the sources depend on the kernel
version - compile them yourself.

The home site of this package:
 * https://kbd-project.org/


Mailing list
------------

* E-mail:  kbd@lists.altlinux.org
* URL:     https://lists.altlinux.org/mailman/listinfo/kbd
* Archive: https://lore.altlinux.org/kbd/

To protect subscribers from spam, the mailing list requires a subscription.


Bug reporting
-------------

* E-mail: kbd@lists.altlinux.org
* Web:    https://github.com/legionus/kbd/issues

Report problems with this package to the mailing list or
directly to the `Alexey Gladkov <gladkov.alexey@gmail.com>`.


Source code
-----------

The latest stable version of kbd can always be found on:
* https://www.kernel.org/pub/linux/utils/kbd/

Web interface:
 * https://git.kernel.org/pub/scm/linux/kernel/git/legion/kbd.git
 * https://github.com/legionus/kbd

Versioning:

* Standard releases: `<major>.<minor>[.<maint>]`
  - `major` -- fatal and deep changes;
  - `minor` -- typical release with new features;
  - `maint` -- bug fixes.

* Development releases: `<major>.<minor>-rc<N>`

To summarize, the stable release is `2.1.0` while `2.0.9x` is a pre-releases.

Git repository:
* Primary: git://git.kernel.org/pub/scm/linux/kernel/git/legion/kbd.git
* Mirror:  git://github.com/legionus/kbd.git

Git Branches: `git branch -a`

* `master` branch
  - current development.
  - the source for stable releases when deemed ready.

* `for-master` branch
  - unstable changes for master. These changes can be reversed or rolled back.

Tags: `git tag`

- a new tag object is created for every release.
- tag name: `v<version>`.
- all tags are signed by the maintainer's PGP key.


See also:
* [how to contribute](docs/process/howto-contribute.md),
* [how to pull-request](docs/process/howto-pull-request.md).


NLS (PO translations)
---------------------

PO files are maintained by:
https://translationproject.org/domain/kbd.html


License
-------

Kbd is licensed under the GNU General Public License (GPL), version 2, or at
your option any later version.
