/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.RangeVariable;
import org.hsqldb.TableDerived;

public interface RangeGroup {
    public static final RangeGroup emptyGroup = new RangeGroupEmpty();
    public static final RangeGroup[] emptyArray = new RangeGroup[]{emptyGroup};

    public RangeVariable[] getRangeVariables();

    public void setCorrelated();

    public static class RangeGroupEmpty
    implements RangeGroup {
        RangeGroupEmpty() {
        }

        @Override
        public RangeVariable[] getRangeVariables() {
            return RangeVariable.emptyArray;
        }

        @Override
        public void setCorrelated() {
        }
    }

    public static class RangeGroupSimple
    implements RangeGroup {
        RangeVariable[] ranges;
        RangeGroup baseGroup;
        TableDerived table;

        public RangeGroupSimple(TableDerived tableDerived) {
            this.ranges = RangeVariable.emptyArray;
            this.table = tableDerived;
        }

        public RangeGroupSimple(RangeVariable[] rangeVariableArray, RangeGroup rangeGroup) {
            this.ranges = rangeVariableArray;
            this.baseGroup = rangeGroup;
        }

        public RangeGroupSimple(RangeVariable[] rangeVariableArray) {
            this.ranges = rangeVariableArray;
        }

        @Override
        public RangeVariable[] getRangeVariables() {
            return this.ranges;
        }

        @Override
        public void setCorrelated() {
            if (this.baseGroup != null) {
                this.baseGroup.setCorrelated();
            }
            if (this.table != null) {
                this.table.setCorrelated();
            }
        }
    }
}

