// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, EventController, Gesture, GestureSingle, PropagationLimit, PropagationPhase};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkDragSource")]
    pub struct DragSource(Object<ffi::GtkDragSource, ffi::GtkDragSourceClass>) @extends GestureSingle, Gesture, EventController;

    match fn {
        type_ => || ffi::gtk_drag_source_get_type(),
    }
}

impl DragSource {
    #[doc(alias = "gtk_drag_source_new")]
    pub fn new() -> DragSource {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_drag_source_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`DragSource`] objects.
    ///
    /// This method returns an instance of [`DragSourceBuilder`](crate::builders::DragSourceBuilder) which can be used to create [`DragSource`] objects.
    pub fn builder() -> DragSourceBuilder {
        DragSourceBuilder::new()
    }

    #[doc(alias = "gtk_drag_source_drag_cancel")]
    pub fn drag_cancel(&self) {
        unsafe {
            ffi::gtk_drag_source_drag_cancel(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_drag_source_get_actions")]
    #[doc(alias = "get_actions")]
    pub fn actions(&self) -> gdk::DragAction {
        unsafe { from_glib(ffi::gtk_drag_source_get_actions(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_drag_source_get_content")]
    #[doc(alias = "get_content")]
    pub fn content(&self) -> Option<gdk::ContentProvider> {
        unsafe { from_glib_none(ffi::gtk_drag_source_get_content(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_drag_source_get_drag")]
    #[doc(alias = "get_drag")]
    pub fn drag(&self) -> Option<gdk::Drag> {
        unsafe { from_glib_none(ffi::gtk_drag_source_get_drag(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_drag_source_set_actions")]
    #[doc(alias = "actions")]
    pub fn set_actions(&self, actions: gdk::DragAction) {
        unsafe {
            ffi::gtk_drag_source_set_actions(self.to_glib_none().0, actions.into_glib());
        }
    }

    #[doc(alias = "gtk_drag_source_set_content")]
    #[doc(alias = "content")]
    pub fn set_content(&self, content: Option<&impl IsA<gdk::ContentProvider>>) {
        unsafe {
            ffi::gtk_drag_source_set_content(
                self.to_glib_none().0,
                content.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_drag_source_set_icon")]
    pub fn set_icon(&self, paintable: Option<&impl IsA<gdk::Paintable>>, hot_x: i32, hot_y: i32) {
        unsafe {
            ffi::gtk_drag_source_set_icon(
                self.to_glib_none().0,
                paintable.map(|p| p.as_ref()).to_glib_none().0,
                hot_x,
                hot_y,
            );
        }
    }

    #[doc(alias = "drag-begin")]
    pub fn connect_drag_begin<F: Fn(&Self, &gdk::Drag) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn drag_begin_trampoline<F: Fn(&DragSource, &gdk::Drag) + 'static>(
            this: *mut ffi::GtkDragSource,
            drag: *mut gdk::ffi::GdkDrag,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(drag))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-begin\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    drag_begin_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "drag-cancel")]
    pub fn connect_drag_cancel<
        F: Fn(&Self, &gdk::Drag, gdk::DragCancelReason) -> bool + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn drag_cancel_trampoline<
            F: Fn(&DragSource, &gdk::Drag, gdk::DragCancelReason) -> bool + 'static,
        >(
            this: *mut ffi::GtkDragSource,
            drag: *mut gdk::ffi::GdkDrag,
            reason: gdk::ffi::GdkDragCancelReason,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &from_glib_borrow(drag),
                from_glib(reason),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-cancel\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    drag_cancel_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "drag-end")]
    pub fn connect_drag_end<F: Fn(&Self, &gdk::Drag, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn drag_end_trampoline<F: Fn(&DragSource, &gdk::Drag, bool) + 'static>(
            this: *mut ffi::GtkDragSource,
            drag: *mut gdk::ffi::GdkDrag,
            delete_data: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &from_glib_borrow(drag),
                from_glib(delete_data),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-end\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    drag_end_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "prepare")]
    pub fn connect_prepare<F: Fn(&Self, f64, f64) -> Option<gdk::ContentProvider> + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn prepare_trampoline<
            F: Fn(&DragSource, f64, f64) -> Option<gdk::ContentProvider> + 'static,
        >(
            this: *mut ffi::GtkDragSource,
            x: libc::c_double,
            y: libc::c_double,
            f: glib::ffi::gpointer,
        ) -> *mut gdk::ffi::GdkContentProvider {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), x, y).to_glib_full()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"prepare\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    prepare_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "actions")]
    pub fn connect_actions_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_actions_trampoline<F: Fn(&DragSource) + 'static>(
            this: *mut ffi::GtkDragSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::actions\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_actions_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "content")]
    pub fn connect_content_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_content_trampoline<F: Fn(&DragSource) + 'static>(
            this: *mut ffi::GtkDragSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::content\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_content_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for DragSource {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`DragSource`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct DragSourceBuilder {
    builder: glib::object::ObjectBuilder<'static, DragSource>,
}

impl DragSourceBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn actions(self, actions: gdk::DragAction) -> Self {
        Self {
            builder: self.builder.property("actions", actions),
        }
    }

    pub fn content(self, content: &impl IsA<gdk::ContentProvider>) -> Self {
        Self {
            builder: self.builder.property("content", content.clone().upcast()),
        }
    }

    pub fn button(self, button: u32) -> Self {
        Self {
            builder: self.builder.property("button", button),
        }
    }

    pub fn exclusive(self, exclusive: bool) -> Self {
        Self {
            builder: self.builder.property("exclusive", exclusive),
        }
    }

    pub fn touch_only(self, touch_only: bool) -> Self {
        Self {
            builder: self.builder.property("touch-only", touch_only),
        }
    }

    pub fn n_points(self, n_points: u32) -> Self {
        Self {
            builder: self.builder.property("n-points", n_points),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn propagation_limit(self, propagation_limit: PropagationLimit) -> Self {
        Self {
            builder: self
                .builder
                .property("propagation-limit", propagation_limit),
        }
    }

    pub fn propagation_phase(self, propagation_phase: PropagationPhase) -> Self {
        Self {
            builder: self
                .builder
                .property("propagation-phase", propagation_phase),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`DragSource`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> DragSource {
        self.builder.build()
    }
}
