<!--
SPDX-License-Identifier: CC-BY-SA-4.0
SPDX-FileCopyrightText: Michael Terry
-->

# Packaging Déjà Dup

If you help package Déjà Dup for a distribution, let me first say:
Thank you so much! ❤️

This guide is designed to answer your most pressing concerns for how to package
the current release.
There is also a wiki page explaining the [history of packaging changes][changes]
which may be helpful if you are trying to update to the latest release and
just want to know what the *delta* is.
And if you have any further questions, ask away in our [chat room][chat].

If you are merely building Déjà Dup for yourself or hacking on it to make a
patch, try reading [CONTRIBUTING.md](CONTRIBUTING.md) instead.

[changes]: https://gitlab.gnome.org/World/deja-dup/-/wikis/Packaging-Changes
[chat]: https://matrix.to/#/#deja-dup:gnome.org

## Required Dependencies

### Build-time Libraries

You can also see these listed in [meson.build](meson.build), but for your
convenience:

- Adwaita 1.7
- Blueprint Compiler 0.14
- GLib 2.80
- GTK 4.18
- JSON-GLib 1.2
- libsecret 0.18.6
- libsoup 3.0

### Runtime Dependencies

- Restic (0.17.1 or greater)
- Duplicity (2.1.0 or greater)
- Rclone
- GVfs, its FUSE layer, and its backends (it'd be nice to ensure the `afp`,
  `dav`, `ftp`, `nfs`, `sftp`, and `smb` backends at least are installed)
- FUSE and fusermount (or fusermount3)

### Duplicity

Duplicity was the previous default backend.

It is still used when reading / writing to existing Duplicity repositories.
Because of this, it is still necessary to depend on Duplicity.

Over time, it may be less and less necessary.
If you want to avoid a hard-dependency on it,
you can enable PackageKit support (see below).

## Optional Dependencies

### PackageKit

Some runtime dependencies may be difficult for you to directly depend on.
As an example, let's say that you're packaging Déjà Dup for Ubuntu and some
dependencies are in `universe`, but `deja-dup` itself is in `main` (which is
the actual historical impetus for this feature). You couldn't just directly
depend on those `universe` dependencies from a `main` package.

However, if you enable PackageKit support, Déjà Dup can prompt the user to
install missing dependencies on the fly, relatively seamlessly as part of the
backup or restore process.

This is optional because it is not the preferred user experience.
Users may reasonably get weirded out by apps that are "missing" dependencies or
that ask for permission to install "arbitrary" packages.
That's not a typical thing for a user to see and might make them distrust their
backup software (which is normally supposed to be a secure and trustworthy
guardian of their data).

So while it's recommended that most runtime dependencies should be hard
dependencies, PackageKit can help in the "soft-depend on Duplicity" case or
if other programs are annoying to hard-depend on.

It's easy to enable:

- Add `libpackagekit-glib2` as a build dependency
- Set `-Dpackagekit=enabled` when building (may not be needed, as `auto` is the
  default)
- Set any or all of the following option flags. If you need multiple packages
  for a single option, separate their names with commas.
    - `duplicity_pkgs`: defaults to `duplicity`
    - `gvfs_pkgs`: specify packages for GVfs **(no default)**
    - `rclone_pkgs`: defaults to `rclone`
    - `restic_pkgs`: defaults to `restic`

An example for a Debian-style distro:

```
-Dpackagekit=enabled
-Dgvfs_pkgs=gvfs-backends,gvfs-fuse
```

## Dependencies Outside of PATH

If your distro installs packages in non-standard locations or with non-standard
names, you can still tell Déjà Dup where to find them.

For example, NixOS does not even have a global `/usr/bin`, instead installing
packages in namespaced directories for parallel installation.
Or maybe the Duplicity command gets installed as `duplicity.bin` on your distro.
I don't judge.

That's easy to tell us about. Just set the following option flags:

- `duplicity_command`
- `fusermount_command`
- `rclone_command`
- `restic_command`

Absolute paths will be used directly, while bare command names will be searched
for in `PATH`.

An example:

```
-Dduplicity_command=/opt/duplicity/bin/duplicity
```

## Monitoring for New Releases

All releases and tarballs can be found as [tags][tags] on our source repository
in GitLab.

If any packaging changes happen, they will always be mentioned in the release
notes (on the GitLab tag and in [NEWS.md](NEWS.md)).

Version numbers follow [GNOME style][versions] (but not their release schedule).
So a notable new release (like a redesigned UI or new dependencies) will get a
bumped major version number.
For example, we went from 43 to 44 because we bumped Adwaita's minimum version
and changed how a build option worked.
Development releases will look like 44.alpha and 44.beta (though not every
major release will bother with a full alpha/beta test cycle).

[tags]: https://gitlab.gnome.org/World/deja-dup/tags
[versions]: https://discourse.gnome.org/t/new-gnome-versioning-scheme/4235
