/* original parser id follows */
/* yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93" */
/* (use YYMAJOR/YYMINOR for ifdefs dependent on parser version) */

#define YYBYACC 1
#define YYMAJOR 2
#define YYMINOR 0
#define YYPATCH 20230201

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)
#define YYENOMEM       (-2)
#define YYEOF          0
#define YYPREFIX "yy"

#define YYPURE 0

#line 2 "attack_parser.y"

/*
 * Copyright (c) 2007,2008,2009,2010 Mij <mij@sshguard.net>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * SSHGuard. See http://www.sshguard.net
 */

#include <string.h>

#include "parser.h"

#define DEFAULT_ATTACKS_DANGEROUSNESS           10

 /* stuff exported by the scanner */
extern void scanner_init(char *);
extern void scanner_fin();
extern int yylex();

static void yyerror(attack_t *, const char *);

#ifdef YYSTYPE
#undef  YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#endif
#ifndef YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#line 43 "attack_parser.y"
typedef union {
    char *str;
    int num;
} YYSTYPE;
#endif /* !YYSTYPE_IS_DECLARED */
#line 68 "attack_parser.c"

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
# ifdef YYPARSE_PARAM_TYPE
#  define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
# else
#  define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
# endif
#else
# define YYPARSE_DECL() yyparse(attack_t *attack)
#endif

/* Parameters sent to lex. */
#ifdef YYLEX_PARAM
# define YYLEX_DECL() yylex(void *YYLEX_PARAM)
# define YYLEX yylex(YYLEX_PARAM)
#else
# define YYLEX_DECL() yylex(void)
# define YYLEX yylex()
#endif

#if !(defined(yylex) || defined(YYSTATE))
int YYLEX_DECL();
#endif

/* Parameters sent to yyerror. */
#ifndef YYERROR_DECL
#define YYERROR_DECL() yyerror(attack_t *attack, const char *s)
#endif
#ifndef YYERROR_CALL
#define YYERROR_CALL(msg) yyerror(attack, msg)
#endif

extern int YYPARSE_DECL();

#define IPv4 257
#define IPv6 258
#define HOSTADDR 259
#define WORD 260
#define STRING 261
#define INTEGER 262
#define SYSLOG_BANNER 263
#define TIMESTAMP_SYSLOG 264
#define TIMESTAMP_ISO8601 265
#define TIMESTAMP_TAI64 266
#define AT_TIMESTAMP_TAI64 267
#define RFC_5234_BANNER 268
#define METALOG_BANNER 269
#define SOCKLOG_BANNER 270
#define BUSYBOX_SYSLOG_BANNER 271
#define REPETITIONS 272
#define SSH_INVALUSERPREF 273
#define SSH_NOTALLOWEDPREF 274
#define SSH_NOTALLOWEDSUFF 275
#define SSH_LOGINERR_PREF 276
#define SSH_LOGINERR_PAM 277
#define SSH_VIA 278
#define SSH_MAXAUTH 279
#define SSH_ADDR_SUFF 280
#define SSH_NOIDENTIFSTR 281
#define SSH_BADPROTOCOLIDENTIF 282
#define SSH_BADPROTOCOLIDENTIF_SUFF 283
#define SSH_INVALIDFORMAT_PREF 284
#define SSH_INVALIDFORMAT_SUFF 285
#define SSH_BADKEX_PREF 286
#define SSH_BADKEX_SUFF 287
#define SSH_DISCONNECT_PREF 288
#define SSH_CONNECTION_CLOSED 289
#define SSH_PREAUTH_SUFF 290
#define SSHGUARD_ATTACK_PREF 291
#define SSHGUARD_ATTACK_SUFF 292
#define SSHGUARD_BLOCK_PREF 293
#define SSHGUARD_BLOCK_SUFF 294
#define BIND_PREF 295
#define BIND_QUERY_DENIED 296
#define DOVECOT_IMAP_LOGINERR_PREF 297
#define DOVECOT_IMAP_LOGINERR_SUFF 298
#define UWIMAP_LOGINERR 299
#define CYRUSIMAP_SASL_LOGINERR_PREF 300
#define CYRUSIMAP_SASL_LOGINERR_SUFF 301
#define CUCIPOP_AUTHFAIL 302
#define EXIM_ESMTP_AUTHFAIL_PREF 303
#define EXIM_ESMTP_AUTHFAIL_SUFF 304
#define EXIM_ESMTP_LOGINFAIL_PREF 305
#define EXIM_ESMTP_LOGINFAIL_SUFF 306
#define SENDMAIL_RELAYDENIED_PREF 307
#define SENDMAIL_RELAYDENIED_SUFF 308
#define SENDMAIL_AUTHFAILURE_PREF 309
#define SENDMAIL_AUTHFAILURE_SUFF 310
#define POSTFIX_NO_AUTH_PREF 311
#define POSTFIX_SASL_LOGINERR_PREF 312
#define POSTFIX_SASL_LOGINERR_SUFF 313
#define POSTFIX_NONSMTP 314
#define POSTFIX_NONSMTP_SUFF 315
#define POSTFIX_GREYLIST 316
#define POSTFIX_GREYLIST_SUFF 317
#define POSTSCREEN_PREF 318
#define POSTSCREEN_SUFF 319
#define FREEBSDFTPD_LOGINERR_PREF 320
#define FREEBSDFTPD_LOGINERR_SUFF 321
#define PROFTPD_LOGINERR_PREF 322
#define PROFTPD_LOGINERR_SUFF 323
#define PUREFTPD_LOGINERR_PREF 324
#define PUREFTPD_LOGINERR_SUFF 325
#define VSFTPD_LOGINERR_PREF 326
#define VSFTPD_LOGINERR_SUFF 327
#define COCKPIT_AUTHFAIL_PREF 328
#define COCKPIT_AUTHFAIL_SUFF 329
#define CLF_TIMESTAMP 330
#define CLF_SUFFIX 331
#define CLF_WEB_PROBE 332
#define CLF_CMS_LOGIN 333
#define OPENSMTPD_FAILED_CMD_PREF 334
#define OPENSMTPD_AUTHFAIL_SUFF 335
#define OPENSMTPD_UNSUPPORTED_CMD_SUFF 336
#define COURIER_AUTHFAIL_PREF 337
#define OPENVPN_TLS_ERR_SUFF 338
#define GITEA_ERR_PREF 339
#define GITEA_ERR_SUFF 340
#define OPENVPN_PS_TERM_PREF 341
#define OPENVPN_PS_TERM_SUFF 342
#define MSSQL_AUTHFAIL_PREF 343
#define PROXMOXVE_AUTHFAIL_PREF 344
#define PROXMOXVE_AUTHFAIL_SUFF 345
#define YYERRCODE 256
typedef int YYINT;
static const YYINT yylhs[] = {                           -1,
    0,    0,    1,    1,    1,    1,    1,    1,    4,    4,
    4,    5,    6,    7,    8,    3,    3,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
   32,   32,   32,   32,    9,    9,    9,    9,    9,    9,
   33,   33,   33,   34,   34,   34,   34,   35,   35,   35,
   35,   36,   37,   38,   10,   10,   11,   12,   13,   14,
   15,   16,   16,   17,   17,   18,   18,   18,   18,   18,
   39,   40,   40,   19,   20,   21,   22,   23,   23,   24,
   45,   45,   46,   46,   41,   41,   41,   42,   42,   42,
   43,   44,   44,   25,   25,   26,   27,   27,   28,   28,
   28,   28,   30,   29,   29,   31,
};
static const YYINT yylen[] = {                            2,
    3,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    2,    1,    1,    1,    1,    0,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    3,    1,    1,    1,    1,    1,    1,    1,
    2,    3,    3,    3,    2,    3,    3,    2,    3,    3,
    3,    3,    3,    3,    3,    3,    3,    3,    4,    3,
    2,    3,    3,    3,    3,    3,    2,    3,    3,    3,
    3,    0,    2,    3,    3,    3,    3,    3,    2,    9,
    0,    2,    0,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    3,    3,    4,    2,    4,    2,    3,
    4,    5,    3,    3,    5,    3,
};
static const YYINT yydefred[] = {                         0,
   41,    0,   44,    9,    0,   12,    5,   13,   14,   15,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    2,    3,    4,    6,    7,    8,   18,   19,   20,
   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
   31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
    0,   45,   46,   47,   48,   49,   50,    0,   11,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   71,    0,    0,    0,
    0,    0,   77,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   96,   95,  107,   97,    0,   43,   52,   53,
   54,   56,   57,   59,   62,   63,   64,   60,   61,   65,
   66,   67,   68,    0,   70,   72,   73,   74,   75,    0,
   76,   79,   78,   80,   84,   85,   86,   87,   88,  104,
  105,    0,    0,  110,    0,  114,  113,  116,    0,   17,
    1,    0,   69,    0,   81,  106,    0,    0,  108,    0,
   83,  112,  115,  100,   98,   99,    0,  101,    0,  102,
  103,    0,    0,    0,   92,   94,   90,
};
static const YYINT yydgoto[] = {                         50,
   51,   52,  181,   53,   54,   55,   56,   57,   58,   59,
   60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,  112,   82,   83,   84,   85,   86,   87,  113,  185,
  203,  197,  199,  202,  204,  207,
};
static const YYINT yysindex[] = {                        90,
    0,  -17,    0,    0, -238,    0,    0,    0,    0,    0,
 -193, -193, -193, -193, -193, -193, -193, -193, -193, -193,
 -193, -193, -193, -193, -193,  -53, -193, -193, -193, -193,
 -193, -193, -193, -193, -193, -193, -193, -193, -193, -193,
 -193, -193, -193,  -46,  -87,  -82, -193, -193, -193,    0,
  162,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  -42,    0,    0,    0,    0,    0,    0, -213,    0, -231,
 -219, -218, -209, -208, -207, -212, -211, -210, -215, -214,
 -206, -216, -217, -205, -193, -221,    0, -223, -224, -225,
 -226,   -8,    0, -222, -220, -228, -229, -203, -227, -233,
 -230, -204, -268, -193, -193, -242, -193, -243,    7, -244,
    9, -169,    0,    0,    0,    0,  -38,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   14,    0,    0,    0,    0,    0,   46,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   16,   18,    0,   19,    0,    0,    0, -232,    0,
    0, -202,    0, -157,    0,    0, -200, -234,    0, -245,
    0,    0,    0,    0,    0,    0, -152,    0,  -45,    0,
    0,  -38,  -38, -201,    0,    0,    0,
};
static const YYINT yyrindex[] = {                         0,
    0,    1,    0,    0,  236,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    5,
    0,    0,    8,    0,   10,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   11,    0,    0,    0,   13,    0,    0,    0,    0,
    0,  113,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    6,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   15,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    2,    2,   17,    0,    0,    0,
};
static const YYINT yygindex[] = {                         0,
    0,   63,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   12,    0,    0,    0,    0,    0,    0,  -16,    0,
  -67,    0,    0,    0,  -88,    0,
};
#define YYTABLESIZE 580
static const YYINT yytable[] = {                        136,
   42,   91,  136,  125,   51,   82,  136,   55,  127,   58,
   89,   81,  109,  137,  111,  194,   93,  114,  115,   88,
  117,   89,   90,   91,   92,   93,   94,   95,   96,   97,
   98,   99,  100,  101,  102,  103,  104,  105,  106,  107,
  108,  109,  110,  111,  124,   42,  138,  116,  139,  118,
  119,  120,  121,  122,  123,  140,  126,  128,  129,  130,
  131,  141,   81,    1,    2,    3,  170,  171,  142,  182,
  145,  143,  144,  146,  148,  149,  147,  151,  152,  155,
  156,  157,  158,  159,  160,  150,  195,  196,  163,  164,
  161,  167,  153,   42,  162,  166,  168,  174,  176,  177,
  178,  179,  180,  184,  191,  189,  183,  193,  186,  198,
  187,  188,   16,  132,  205,    0,  154,  165,    0,    0,
    0,    0,    0,    0,  169,    0,    0,  190,    0,  206,
    0,  201,    0,    0,    0,  172,  173,    0,  175,  192,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    1,
    2,    3,    0,    0,    1,    2,    3,    0,    0,    0,
   49,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  133,  134,  200,  133,  134,    0,
    0,  133,  134,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   49,    0,    0,    0,    0,    0,    0,    0,
   42,   42,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   42,   91,    0,   42,   51,   82,   42,   55,
   42,   58,   89,   42,  109,   42,  111,   42,   93,    0,
   42,    0,   42,    0,   42,  135,   42,    0,   42,    0,
    0,   42,    0,    0,   42,    0,   42,    0,   42,    0,
   42,    0,    0,    0,    0,    0,    0,   42,   82,    0,
   82,   42,    0,   42,   82,   42,   10,   42,    0,   42,
    0,    0,   91,    0,    0,   42,   42,    0,   42,    0,
   42,    0,   42,    0,    0,   42,    1,    2,    3,    0,
    0,    0,    4,    0,    5,    0,    6,    7,    8,    9,
   10,    0,   11,   12,    0,   13,   14,    0,   15,    0,
   16,   17,    0,   18,    0,   19,    0,   20,   21,    0,
   22,    0,   23,    0,   24,    0,   25,    0,   26,   27,
    0,   28,   29,    0,   30,    0,   31,    0,   32,    0,
   33,   34,    0,   35,    0,   36,    0,   37,    0,   38,
    0,   39,    0,   40,    0,   41,    0,   42,    1,    2,
    3,    0,    0,   43,    0,    0,   44,    0,   45,    0,
   46,    0,   47,   48,   11,   12,    0,   13,   14,    0,
   15,    0,   16,   17,    0,   18,    0,   19,    0,   20,
   21,    0,   22,    0,   23,    0,   24,    0,   25,    0,
   26,   27,    0,   28,   29,    0,   30,    0,   31,    0,
   32,    0,   33,   34,    0,   35,    0,   36,    0,   37,
    0,   38,    0,   39,    0,   40,    0,   41,    0,   42,
    0,    0,   10,   10,   10,   43,    0,    0,   44,    0,
   45,    0,   46,    0,   47,   48,    0,    0,   10,   10,
    0,   10,   10,    0,   10,    0,   10,   10,    0,   10,
    0,   10,    0,   10,   10,    0,   10,    0,   10,    0,
   10,    0,   10,    0,   10,   10,    0,   10,   10,    0,
   10,    0,   10,    0,   10,    0,   10,   10,    0,   10,
    0,   10,    0,   10,    0,   10,    0,   10,    0,   10,
    0,   10,    0,   10,    0,    0,    0,    0,    0,   10,
    0,    0,   10,    0,   10,    0,   10,    0,   10,   10,
};
static const YYINT yycheck[] = {                         45,
    0,    0,   45,   91,    0,    0,   45,    0,   91,    0,
    0,    0,    0,   81,    0,  261,    0,   34,   35,   37,
   37,  260,   11,   12,   13,   14,   15,   16,   17,   18,
   19,   20,   21,   22,   23,   24,   25,   91,   27,   28,
   29,   30,   31,   32,   91,   45,  260,   36,  280,   38,
   39,   40,   41,   42,   43,  275,   45,   46,   47,   48,
   49,  280,   51,  257,  258,  259,  335,  336,  278,  137,
  283,  280,  280,  285,  290,  290,  287,  294,  296,  301,
  304,  306,  308,  310,   93,  292,  332,  333,  317,  319,
  313,  325,  298,   93,  315,  323,  327,  340,  342,   93,
  345,   93,  272,   58,  262,  338,   93,  342,   93,  262,
   93,   93,    0,   51,  203,   -1,  105,  321,   -1,   -1,
   -1,   -1,   -1,   -1,  329,   -1,   -1,  330,   -1,  331,
   -1,  199,   -1,   -1,   -1,  124,  125,   -1,  127,  340,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,
  258,  259,   -1,   -1,  257,  258,  259,   -1,   -1,   -1,
   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  260,  261,  262,  260,  261,   -1,
   -1,  260,  261,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  260,  261,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  272,  272,   -1,  275,  272,  272,  278,  272,
  280,  272,  272,  283,  272,  285,  272,  287,  272,   -1,
  290,   -1,  292,   -1,  294,  338,  296,   -1,  298,   -1,
   -1,  301,   -1,   -1,  304,   -1,  306,   -1,  308,   -1,
  310,   -1,   -1,   -1,   -1,   -1,   -1,  317,  313,   -1,
  315,  321,   -1,  323,  319,  325,   91,  327,   -1,  329,
   -1,   -1,  331,   -1,   -1,  335,  336,   -1,  338,   -1,
  340,   -1,  342,   -1,   -1,  345,  257,  258,  259,   -1,
   -1,   -1,  263,   -1,  265,   -1,  267,  268,  269,  270,
  271,   -1,  273,  274,   -1,  276,  277,   -1,  279,   -1,
  281,  282,   -1,  284,   -1,  286,   -1,  288,  289,   -1,
  291,   -1,  293,   -1,  295,   -1,  297,   -1,  299,  300,
   -1,  302,  303,   -1,  305,   -1,  307,   -1,  309,   -1,
  311,  312,   -1,  314,   -1,  316,   -1,  318,   -1,  320,
   -1,  322,   -1,  324,   -1,  326,   -1,  328,  257,  258,
  259,   -1,   -1,  334,   -1,   -1,  337,   -1,  339,   -1,
  341,   -1,  343,  344,  273,  274,   -1,  276,  277,   -1,
  279,   -1,  281,  282,   -1,  284,   -1,  286,   -1,  288,
  289,   -1,  291,   -1,  293,   -1,  295,   -1,  297,   -1,
  299,  300,   -1,  302,  303,   -1,  305,   -1,  307,   -1,
  309,   -1,  311,  312,   -1,  314,   -1,  316,   -1,  318,
   -1,  320,   -1,  322,   -1,  324,   -1,  326,   -1,  328,
   -1,   -1,  257,  258,  259,  334,   -1,   -1,  337,   -1,
  339,   -1,  341,   -1,  343,  344,   -1,   -1,  273,  274,
   -1,  276,  277,   -1,  279,   -1,  281,  282,   -1,  284,
   -1,  286,   -1,  288,  289,   -1,  291,   -1,  293,   -1,
  295,   -1,  297,   -1,  299,  300,   -1,  302,  303,   -1,
  305,   -1,  307,   -1,  309,   -1,  311,  312,   -1,  314,
   -1,  316,   -1,  318,   -1,  320,   -1,  322,   -1,  324,
   -1,  326,   -1,  328,   -1,   -1,   -1,   -1,   -1,  334,
   -1,   -1,  337,   -1,  339,   -1,  341,   -1,  343,  344,
};
#define YYFINAL 50
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 345
#define YYUNDFTOKEN 394
#define YYTRANSLATE(a) ((a) > YYMAXTOKEN ? YYUNDFTOKEN : (a))
#if YYDEBUG
static const char *const yyname[] = {

"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,"'%'",0,0,0,0,0,0,0,"'-'",0,0,0,0,0,0,0,0,0,0,0,0,"':'",0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'['",0,"']'",0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"IPv4","IPv6",
"HOSTADDR","WORD","STRING","INTEGER","SYSLOG_BANNER","TIMESTAMP_SYSLOG",
"TIMESTAMP_ISO8601","TIMESTAMP_TAI64","AT_TIMESTAMP_TAI64","RFC_5234_BANNER",
"METALOG_BANNER","SOCKLOG_BANNER","BUSYBOX_SYSLOG_BANNER","REPETITIONS",
"SSH_INVALUSERPREF","SSH_NOTALLOWEDPREF","SSH_NOTALLOWEDSUFF",
"SSH_LOGINERR_PREF","SSH_LOGINERR_PAM","SSH_VIA","SSH_MAXAUTH","SSH_ADDR_SUFF",
"SSH_NOIDENTIFSTR","SSH_BADPROTOCOLIDENTIF","SSH_BADPROTOCOLIDENTIF_SUFF",
"SSH_INVALIDFORMAT_PREF","SSH_INVALIDFORMAT_SUFF","SSH_BADKEX_PREF",
"SSH_BADKEX_SUFF","SSH_DISCONNECT_PREF","SSH_CONNECTION_CLOSED",
"SSH_PREAUTH_SUFF","SSHGUARD_ATTACK_PREF","SSHGUARD_ATTACK_SUFF",
"SSHGUARD_BLOCK_PREF","SSHGUARD_BLOCK_SUFF","BIND_PREF","BIND_QUERY_DENIED",
"DOVECOT_IMAP_LOGINERR_PREF","DOVECOT_IMAP_LOGINERR_SUFF","UWIMAP_LOGINERR",
"CYRUSIMAP_SASL_LOGINERR_PREF","CYRUSIMAP_SASL_LOGINERR_SUFF",
"CUCIPOP_AUTHFAIL","EXIM_ESMTP_AUTHFAIL_PREF","EXIM_ESMTP_AUTHFAIL_SUFF",
"EXIM_ESMTP_LOGINFAIL_PREF","EXIM_ESMTP_LOGINFAIL_SUFF",
"SENDMAIL_RELAYDENIED_PREF","SENDMAIL_RELAYDENIED_SUFF",
"SENDMAIL_AUTHFAILURE_PREF","SENDMAIL_AUTHFAILURE_SUFF","POSTFIX_NO_AUTH_PREF",
"POSTFIX_SASL_LOGINERR_PREF","POSTFIX_SASL_LOGINERR_SUFF","POSTFIX_NONSMTP",
"POSTFIX_NONSMTP_SUFF","POSTFIX_GREYLIST","POSTFIX_GREYLIST_SUFF",
"POSTSCREEN_PREF","POSTSCREEN_SUFF","FREEBSDFTPD_LOGINERR_PREF",
"FREEBSDFTPD_LOGINERR_SUFF","PROFTPD_LOGINERR_PREF","PROFTPD_LOGINERR_SUFF",
"PUREFTPD_LOGINERR_PREF","PUREFTPD_LOGINERR_SUFF","VSFTPD_LOGINERR_PREF",
"VSFTPD_LOGINERR_SUFF","COCKPIT_AUTHFAIL_PREF","COCKPIT_AUTHFAIL_SUFF",
"CLF_TIMESTAMP","CLF_SUFFIX","CLF_WEB_PROBE","CLF_CMS_LOGIN",
"OPENSMTPD_FAILED_CMD_PREF","OPENSMTPD_AUTHFAIL_SUFF",
"OPENSMTPD_UNSUPPORTED_CMD_SUFF","COURIER_AUTHFAIL_PREF","OPENVPN_TLS_ERR_SUFF",
"GITEA_ERR_PREF","GITEA_ERR_SUFF","OPENVPN_PS_TERM_PREF","OPENVPN_PS_TERM_SUFF",
"MSSQL_AUTHFAIL_PREF","PROXMOXVE_AUTHFAIL_PREF","PROXMOXVE_AUTHFAIL_SUFF",0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,"illegal-symbol",
};
static const char *const yyrule[] = {
"$accept : text",
"text : log_prefix msg_single repetition_suffix",
"text : msg_single",
"log_prefix : syslogent",
"log_prefix : multilogent",
"log_prefix : RFC_5234_BANNER",
"log_prefix : metalogent",
"log_prefix : socklogent",
"log_prefix : busyboxent",
"syslogent : SYSLOG_BANNER",
"syslogent : TIMESTAMP_ISO8601",
"syslogent : TIMESTAMP_ISO8601 WORD",
"multilogent : AT_TIMESTAMP_TAI64",
"metalogent : METALOG_BANNER",
"socklogent : SOCKLOG_BANNER",
"busyboxent : BUSYBOX_SYSLOG_BANNER",
"repetition_suffix :",
"repetition_suffix : REPETITIONS",
"msg_single : sshmsg",
"msg_single : sshguardmsg",
"msg_single : bindmsg",
"msg_single : dovecotmsg",
"msg_single : uwimapmsg",
"msg_single : cyrusimapmsg",
"msg_single : cucipopmsg",
"msg_single : eximmsg",
"msg_single : sendmailmsg",
"msg_single : postfixmsg",
"msg_single : freebsdftpdmsg",
"msg_single : proftpdmsg",
"msg_single : pureftpdmsg",
"msg_single : vsftpdmsg",
"msg_single : cockpitmsg",
"msg_single : clfmsg",
"msg_single : opensmtpdmsg",
"msg_single : couriermsg",
"msg_single : openvpnmsg",
"msg_single : giteamsg",
"msg_single : openvpnpsmsg",
"msg_single : sqlservrmsg",
"msg_single : proxmoxvemsg",
"addr : IPv4",
"addr : IPv6",
"addr : IPv6 '%' WORD",
"addr : HOSTADDR",
"sshmsg : ssh_illegaluser",
"sshmsg : ssh_authfail",
"sshmsg : ssh_noidentifstring",
"sshmsg : ssh_badprotocol",
"sshmsg : ssh_invalid_format",
"sshmsg : ssh_badkex",
"ssh_illegaluser : SSH_INVALUSERPREF addr",
"ssh_illegaluser : SSH_INVALUSERPREF addr SSH_ADDR_SUFF",
"ssh_illegaluser : SSH_NOTALLOWEDPREF addr SSH_NOTALLOWEDSUFF",
"ssh_authfail : SSH_LOGINERR_PREF addr SSH_ADDR_SUFF",
"ssh_authfail : SSH_LOGINERR_PAM addr",
"ssh_authfail : SSH_LOGINERR_PAM addr SSH_VIA",
"ssh_authfail : SSH_MAXAUTH addr SSH_ADDR_SUFF",
"ssh_noidentifstring : SSH_NOIDENTIFSTR addr",
"ssh_noidentifstring : SSH_NOIDENTIFSTR addr SSH_ADDR_SUFF",
"ssh_noidentifstring : SSH_DISCONNECT_PREF addr SSH_PREAUTH_SUFF",
"ssh_noidentifstring : SSH_CONNECTION_CLOSED addr SSH_PREAUTH_SUFF",
"ssh_badprotocol : SSH_BADPROTOCOLIDENTIF addr SSH_BADPROTOCOLIDENTIF_SUFF",
"ssh_invalid_format : SSH_INVALIDFORMAT_PREF addr SSH_INVALIDFORMAT_SUFF",
"ssh_badkex : SSH_BADKEX_PREF addr SSH_BADKEX_SUFF",
"sshguardmsg : SSHGUARD_ATTACK_PREF addr SSHGUARD_ATTACK_SUFF",
"sshguardmsg : SSHGUARD_BLOCK_PREF addr SSHGUARD_BLOCK_SUFF",
"bindmsg : BIND_PREF addr BIND_QUERY_DENIED",
"dovecotmsg : DOVECOT_IMAP_LOGINERR_PREF addr DOVECOT_IMAP_LOGINERR_SUFF",
"uwimapmsg : UWIMAP_LOGINERR '[' addr ']'",
"cyrusimapmsg : CYRUSIMAP_SASL_LOGINERR_PREF addr CYRUSIMAP_SASL_LOGINERR_SUFF",
"cucipopmsg : CUCIPOP_AUTHFAIL addr",
"eximmsg : EXIM_ESMTP_AUTHFAIL_PREF addr EXIM_ESMTP_AUTHFAIL_SUFF",
"eximmsg : EXIM_ESMTP_LOGINFAIL_PREF addr EXIM_ESMTP_LOGINFAIL_SUFF",
"sendmailmsg : SENDMAIL_RELAYDENIED_PREF addr SENDMAIL_RELAYDENIED_SUFF",
"sendmailmsg : SENDMAIL_AUTHFAILURE_PREF addr SENDMAIL_AUTHFAILURE_SUFF",
"postfixmsg : POSTFIX_SASL_LOGINERR_PREF postfixsrc POSTFIX_SASL_LOGINERR_SUFF",
"postfixmsg : POSTFIX_NO_AUTH_PREF postfixsrc",
"postfixmsg : POSTFIX_GREYLIST addr POSTFIX_GREYLIST_SUFF",
"postfixmsg : POSTFIX_NONSMTP postfixsrc POSTFIX_NONSMTP_SUFF",
"postfixmsg : POSTSCREEN_PREF postfixsrc POSTSCREEN_SUFF",
"postfixsrc : addr ']' optport",
"optport :",
"optport : ':' INTEGER",
"freebsdftpdmsg : FREEBSDFTPD_LOGINERR_PREF addr FREEBSDFTPD_LOGINERR_SUFF",
"proftpdmsg : PROFTPD_LOGINERR_PREF addr PROFTPD_LOGINERR_SUFF",
"pureftpdmsg : PUREFTPD_LOGINERR_PREF addr PUREFTPD_LOGINERR_SUFF",
"vsftpdmsg : VSFTPD_LOGINERR_PREF addr VSFTPD_LOGINERR_SUFF",
"cockpitmsg : COCKPIT_AUTHFAIL_PREF addr COCKPIT_AUTHFAIL_SUFF",
"cockpitmsg : COCKPIT_AUTHFAIL_PREF addr",
"clfmsg : addr clffield clffield CLF_TIMESTAMP clfrequest clfstatus clfbytes clfext clfsuffix",
"clfext :",
"clfext : clffield clfext",
"clfsuffix :",
"clfsuffix : CLF_SUFFIX",
"clffield : STRING",
"clffield : WORD",
"clffield : '-'",
"clfrequest : CLF_WEB_PROBE",
"clfrequest : CLF_CMS_LOGIN",
"clfrequest : STRING",
"clfstatus : INTEGER",
"clfbytes : INTEGER",
"clfbytes : clffield",
"opensmtpdmsg : OPENSMTPD_FAILED_CMD_PREF addr OPENSMTPD_AUTHFAIL_SUFF",
"opensmtpdmsg : OPENSMTPD_FAILED_CMD_PREF addr OPENSMTPD_UNSUPPORTED_CMD_SUFF",
"couriermsg : COURIER_AUTHFAIL_PREF '[' addr ']'",
"openvpnmsg : addr OPENVPN_TLS_ERR_SUFF",
"openvpnmsg : '[' addr ']' OPENVPN_TLS_ERR_SUFF",
"giteamsg : GITEA_ERR_PREF addr",
"giteamsg : GITEA_ERR_PREF addr GITEA_ERR_SUFF",
"giteamsg : GITEA_ERR_PREF '[' addr ']'",
"giteamsg : GITEA_ERR_PREF '[' addr ']' GITEA_ERR_SUFF",
"sqlservrmsg : MSSQL_AUTHFAIL_PREF addr ']'",
"openvpnpsmsg : OPENVPN_PS_TERM_PREF addr OPENVPN_PS_TERM_SUFF",
"openvpnpsmsg : OPENVPN_PS_TERM_PREF '[' addr ']' OPENVPN_PS_TERM_SUFF",
"proxmoxvemsg : PROXMOXVE_AUTHFAIL_PREF addr PROXMOXVE_AUTHFAIL_SUFF",

};
#endif

#if YYDEBUG
int      yydebug;
#endif

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;
int      yynerrs;

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH  10000
#endif
#endif

#define YYINITSTACKSIZE 200

typedef struct {
    unsigned stacksize;
    YYINT    *s_base;
    YYINT    *s_mark;
    YYINT    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
} YYSTACKDATA;
/* variables for the parser stack */
static YYSTACKDATA yystack;
#line 425 "attack_parser.y"

static void yyerror(__attribute__((unused)) attack_t *a,
    __attribute__((unused)) const char *s) { /* do nothing */ }

int parse_line(char *str, attack_t *attack) {
    attack->service = -1; // invalid service
    attack->dangerousness = DEFAULT_ATTACKS_DANGEROUSNESS;

    scanner_init(str);
    int ret = yyparse(attack);
    scanner_fin();
    if (attack->service == -1)
        return 1; // successful parse but no service (e.g. successful CLF)

    return ret;
}
#line 649 "attack_parser.c"

#if YYDEBUG
#include <stdio.h>	/* needed for printf */
#endif

#include <stdlib.h>	/* needed for malloc, etc */
#include <string.h>	/* needed for memset */

/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    YYINT *newss;
    YYSTYPE *newvs;

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return YYENOMEM;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = (int) (data->s_mark - data->s_base);
    newss = (YYINT *)realloc(data->s_base, newsize * sizeof(*newss));
    if (newss == NULL)
        return YYENOMEM;

    data->s_base = newss;
    data->s_mark = newss + i;

    newvs = (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs));
    if (newvs == NULL)
        return YYENOMEM;

    data->l_base = newvs;
    data->l_mark = newvs + i;

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab

int
YYPARSE_DECL()
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != NULL)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    /* yym is set below */
    /* yyn is set below */
    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        yychar = YYLEX;
        if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if (((yyn = yysindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if (((yyn = yyrindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag != 0) goto yyinrecovery;

    YYERROR_CALL("syntax error");

    goto yyerrlab; /* redundant goto avoids 'unused label' warning */
yyerrlab:
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if (((yyn = yysindex[*yystack.s_mark]) != 0) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
                --yystack.s_mark;
                --yystack.l_mark;
            }
        }
    }
    else
    {
        if (yychar == YYEOF) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym > 0)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);

    switch (yyn)
    {
case 18:
#line 165 "attack_parser.y"
	{ attack->service = SERVICES_SSH; }
#line 851 "attack_parser.c"
break;
case 19:
#line 166 "attack_parser.y"
	{ attack->service = SERVICES_SSHGUARD; }
#line 856 "attack_parser.c"
break;
case 20:
#line 167 "attack_parser.y"
	{ attack->service = SERVICES_BIND; }
#line 861 "attack_parser.c"
break;
case 21:
#line 168 "attack_parser.y"
	{ attack->service = SERVICES_DOVECOT; }
#line 866 "attack_parser.c"
break;
case 22:
#line 169 "attack_parser.y"
	{ attack->service = SERVICES_UWIMAP; }
#line 871 "attack_parser.c"
break;
case 23:
#line 170 "attack_parser.y"
	{ attack->service = SERVICES_CYRUSIMAP; }
#line 876 "attack_parser.c"
break;
case 24:
#line 171 "attack_parser.y"
	{ attack->service = SERVICES_CUCIPOP; }
#line 881 "attack_parser.c"
break;
case 25:
#line 172 "attack_parser.y"
	{ attack->service = SERVICES_EXIM; }
#line 886 "attack_parser.c"
break;
case 26:
#line 173 "attack_parser.y"
	{ attack->service = SERVICES_SENDMAIL; }
#line 891 "attack_parser.c"
break;
case 27:
#line 174 "attack_parser.y"
	{ attack->service = SERVICES_POSTFIX; }
#line 896 "attack_parser.c"
break;
case 28:
#line 175 "attack_parser.y"
	{ attack->service = SERVICES_FREEBSDFTPD; }
#line 901 "attack_parser.c"
break;
case 29:
#line 176 "attack_parser.y"
	{ attack->service = SERVICES_PROFTPD; }
#line 906 "attack_parser.c"
break;
case 30:
#line 177 "attack_parser.y"
	{ attack->service = SERVICES_PUREFTPD; }
#line 911 "attack_parser.c"
break;
case 31:
#line 178 "attack_parser.y"
	{ attack->service = SERVICES_VSFTPD; }
#line 916 "attack_parser.c"
break;
case 32:
#line 179 "attack_parser.y"
	{ attack->service = SERVICES_COCKPIT; }
#line 921 "attack_parser.c"
break;
case 34:
#line 181 "attack_parser.y"
	{ attack->service = SERVICES_OPENSMTPD; }
#line 926 "attack_parser.c"
break;
case 35:
#line 182 "attack_parser.y"
	{ attack->service = SERVICES_COURIER; }
#line 931 "attack_parser.c"
break;
case 36:
#line 183 "attack_parser.y"
	{ attack->service = SERVICES_OPENVPN; }
#line 936 "attack_parser.c"
break;
case 37:
#line 184 "attack_parser.y"
	{ attack->service = SERVICES_GITEA; }
#line 941 "attack_parser.c"
break;
case 38:
#line 185 "attack_parser.y"
	{ attack->service = SERVICES_OPENVPN_PS; }
#line 946 "attack_parser.c"
break;
case 39:
#line 186 "attack_parser.y"
	{ attack->service = SERVICES_MSSQL; }
#line 951 "attack_parser.c"
break;
case 40:
#line 187 "attack_parser.y"
	{ attack->service = SERVICES_PROXMOXVE; }
#line 956 "attack_parser.c"
break;
case 41:
#line 192 "attack_parser.y"
	{
                        attack->address.kind = ADDRKIND_IPv4;
                        strcpy(attack->address.value, yystack.l_mark[0].str);
                    }
#line 964 "attack_parser.c"
break;
case 42:
#line 196 "attack_parser.y"
	{
                        attack->address.kind = ADDRKIND_IPv6;
                        strcpy(attack->address.value, yystack.l_mark[0].str);
                    }
#line 972 "attack_parser.c"
break;
case 43:
#line 200 "attack_parser.y"
	{   /* IPv6 address with interface name */
                        attack->address.kind = ADDRKIND_IPv6;
                        strcpy(attack->address.value, yystack.l_mark[-2].str);
                    }
#line 980 "attack_parser.c"
break;
case 44:
#line 204 "attack_parser.y"
	{
                        if (!attack_from_hostname(attack, yystack.l_mark[0].str)) {
                            YYABORT;
                        }
                    }
#line 989 "attack_parser.c"
break;
case 61:
#line 242 "attack_parser.y"
	{ attack->dangerousness = 2; }
#line 994 "attack_parser.c"
break;
case 98:
#line 349 "attack_parser.y"
	{ attack->service = SERVICES_CLF_PROBES; }
#line 999 "attack_parser.c"
break;
case 99:
#line 350 "attack_parser.y"
	{ attack->service = SERVICES_CLF_LOGIN_URL; }
#line 1004 "attack_parser.c"
break;
case 101:
#line 354 "attack_parser.y"
	{
    if (yylval.num == 401) {
        attack->service = SERVICES_CLF_UNAUTH;
    } else if (attack->service == SERVICES_CLF_LOGIN_URL) {
        /* HTTP 200 OK responses via POST are failed requests*/
        if (yylval.num != 200) {
            attack->service = -1;
        }
    } else if (attack->service == SERVICES_CLF_PROBES) {
        /* Probes with good status codes aren't probes, just legitimate requests*/
        switch (yylval.num) { /* fall through all good response codes*/
        case 200: /* OK*/
        case 301: /* permanent redirect*/
        case 302: /* redirect*/
            attack->service = -1;
            break;
        }
    } else if (yylval.num == 444) {
        /* Some admins configure their web servers to return special status*/
        /* codes when they receive requests for spammy/proby paths. See*/
        /* https://bitbucket.org/sshguard/sshguard/issues/157*/
        attack->service = SERVICES_CLF_PROBES;
    }
}
#line 1032 "attack_parser.c"
break;
#line 1034 "attack_parser.c"
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
        if (yychar < 0)
        {
            yychar = YYLEX;
            if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
            if (yydebug)
            {
                if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == YYEOF) goto yyaccept;
        goto yyloop;
    }
    if (((yyn = yygindex[yym]) != 0) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yystack.s_mark, yystate);
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    *++yystack.s_mark = (YYINT) yystate;
    *++yystack.l_mark = yyval;
    goto yyloop;

yyoverflow:
    YYERROR_CALL("yacc stack overflow");

yyabort:
    yyfreestack(&yystack);
    return (1);

yyaccept:
    yyfreestack(&yystack);
    return (0);
}
