% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe.R
\name{\%$\%}
\alias{\%$\%}
\title{Exposition pipe}
\usage{
lhs \%$\% rhs
}
\arguments{
\item{lhs}{A list, environment, or a data.frame.}

\item{rhs}{An expression where the names in lhs is available.}
}
\description{
Expose the names in \code{lhs} to the \code{rhs} expression. This is useful when functions
do not have a built-in data argument.
}
\details{
Some functions, e.g. \code{lm} and \code{aggregate}, have a
data argument, which allows the direct use of names inside the data as part
of the call. This operator exposes the contents of the left-hand side object
to the expression on the right to give a similar benefit, see the examples.
}
\examples{
iris \%>\%
  subset(Sepal.Length > mean(Sepal.Length)) \%$\%
  cor(Sepal.Length, Sepal.Width)
  
data.frame(z = rnorm(100)) \%$\% 
  ts.plot(z)
  
}
\seealso{
\code{\link{\%>\%}}, \code{\link{\%<>\%}}, \code{\link{\%T>\%}}
}
