# ITK 1.0 Release: Welcome!

This is the third public release of ITK (Release-1-0). The ITK developer
community appreciates any feedback that you may have regarding this
software. Join the ITK user mailing list (instructions later) and post your
feedback there. Warning: since the software is young, and this is an early
release, the API to the software will likely change in the future.

Here are suggested steps for the ITK beginner. Please refer to
http://www.itk.org for more information. Another document, found in
Insight/Documentation/InsightStart.pdf is highly recommended.

1) Get the software. We strongly suggest that you obtain the pre-packaged
   source code distributions (binaries/executables are not yet available).

     http://www.itk.org/HTML/Download.php

   You may also obtain CVS access. (This requires the CVS executable and
   access to ITK's source code through your repository.) To check out the ITK
   version 1,0 release, use the following procedure:

     cvs -d :pserver:anonymous@www.itk.org:/cvsroot/Insight login
         (respond with password "insight")
     cvs -d :pserver:anonymous@www.itk.org:/cvsroot/Insight co \
            -r Release-1-0 Insight

   The current development version of ITK is available using the following
   process. Please realize that the development version is inherently less
   stable than official releases. If you access the development version, you
   will want to monitor code quality at the ITK Dashboard
   http://public.kitware.com/dashboard.php?name=itk.

     cvs -d :pserver:anonymous@www.itk.org:/cvsroot/Insight login
         (respond with password "insight")
     cvs -d :pserver:anonymous@www.itk.org:/cvsroot/Insight co Insight


2) The software is compiled using CMake http://www.cmake.org. CMake
   generates Makefiles on Unix platforms, and Windows workspaces (or
   appropriate) build files according to your compiler, operating
   system, and other system variables.

   If at all possible, obtain the pre-compiled CMake binaries. Binaries
   for Windows and various Unix flavors are available from
   http://www.cmake.org/CMake/HTML/Download.html. On Windows, run the
   CMSetup.exe to install CMake. On Unix, uncompress and untar the
   package and place the executable in a location in your path.

   On Windows, run CMake by clicking on CMakeSetup.exe. You have to point
   CMake to the source directory (e.g., Insight), a build directory (where
   the binaries and object files go), and choose the compiler. The GUI allows
   you to choose build options and configure the build. Rerun CMake (by
   selecting "Configure") until all "red" entries disappear. Then select
   "Ok". This will produce a compiler workspace in the directory that you
   selected.

   On Unix, run "ccmake". This simple, curses-based GUI to CMake allows
   you to configure the build process. First create a build directory
   in which to generate object code and executables. Cd into this
   directory and specify your C and C++ compilers with the environment
   variables

        setenv CC your-c-compiler
        setenv CXX your-c++-compiler

   Next invoke "ccmake ../Insight" assuming that your build
   directory is a sibling directory to Insight/. While running
   ccmake, changes are made using the arrow keys to move over an
   option, and the "Enter" key to edit it. Type "C" to configure
   the build. As long as "*" appear next to any entries, keep
   running CMake until none exist. Then type "G" to generate
   makefiles and exit. Then run "make" in the build directory.

   If you have difficulty with CMake, please refer to http://www.cmake.org
   for additional instructions. It is possible to obtain CVS access and
   compile CMake if absolutely necessary.


3) Join the mailing list. Go to
   http://www.itk.org/mailman/listinfo/insight-users and follow the
   instructions there. You may choose to receive a digest version of the
   mail to minimize traffic.


4) Learn the system. Start by looking at the examples in
   http://www.itk.org/HTML/Examples.htm. The source code is found in the
   Insight/Examples source code directory. (To build the examples, make sure
   the CMake flag "BUILD_EXAMPLES" is on.) You may also wish to peruse the
   many tests found in Insight/Testing/Code.

ITK resources are available at the following locations.
  + http://www.itk.org - main web page
  + http://www.itk.org/mailman/listinfo/insight-users - mailing list
  + Insight/README.html - in the source code distribution
  + Insight/Documentation/InsightStart.pdf - oriented towards developers
    but contains useful information about compiling and building ITK.
  + http://public.kitware.com/dashboard.php?name=itk - the ITK software
    quality dashboard
  + http://public.kitware.com/Dart - what manages the testing process in ITK
  + http://public.kitware.com/Cable - the automated C++ wrapping system
