// Code generated by tools/cmd/genjwt/main.go. DO NOT EDIT.

package jwt

import (
	"fmt"
	"sync"
	"time"
)

// Builder is a convenience wrapper around the New() constructor
// and the Set() methods to assign values to Token claims.
// Users can successively call Claim() on the Builder, and have it
// construct the Token when Build() is called. This alleviates the
// need for the user to check for the return value of every single
// Set() method call.
// Note that each call to Claim() overwrites the value set from the
// previous call.
type Builder struct {
	mu     sync.Mutex
	claims map[string]any
}

func NewBuilder() *Builder {
	return &Builder{}
}

func (b *Builder) init() {
	if b.claims == nil {
		b.claims = make(map[string]any)
	}
}

func (b *Builder) Claim(name string, value any) *Builder {
	b.mu.Lock()
	defer b.mu.Unlock()
	b.init()
	b.claims[name] = value
	return b
}

func (b *Builder) Audience(v []string) *Builder {
	return b.Claim(AudienceKey, v)
}

func (b *Builder) Expiration(v time.Time) *Builder {
	return b.Claim(ExpirationKey, v)
}

func (b *Builder) IssuedAt(v time.Time) *Builder {
	return b.Claim(IssuedAtKey, v)
}

func (b *Builder) Issuer(v string) *Builder {
	return b.Claim(IssuerKey, v)
}

func (b *Builder) JwtID(v string) *Builder {
	return b.Claim(JwtIDKey, v)
}

func (b *Builder) NotBefore(v time.Time) *Builder {
	return b.Claim(NotBeforeKey, v)
}

func (b *Builder) Subject(v string) *Builder {
	return b.Claim(SubjectKey, v)
}

// Build creates a new token based on the claims that the builder has received
// so far. If a claim cannot be set, then the method returns a nil Token with
// a en error as a second return value
//
// Once `Build()` is called, all claims are cleared from the Builder, and the
// Builder can be reused to build another token
func (b *Builder) Build() (Token, error) {
	b.mu.Lock()
	claims := b.claims
	b.claims = nil
	b.mu.Unlock()
	tok := New()
	for k, v := range claims {
		if err := tok.Set(k, v); err != nil {
			return nil, fmt.Errorf(`failed to set claim %q: %w`, k, err)
		}
	}
	return tok, nil
}
