/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import spec.jbb.Customer;
import spec.jbb.Infrastructure;
import spec.jbb.Item;
import spec.jbb.JBBDataStorage;
import spec.jbb.JBBSortedStorage;
import spec.jbb.JBBmain;
import spec.jbb.JBButil;
import spec.jbb.NewOrderTransaction;
import spec.jbb.TimerData;
import spec.jbb.Transaction;
import spec.jbb.TransactionManager;
import spec.jbb.Warehouse;

public class Company {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private static PrintStream outPropFile;
    private static PrintStream outDeliveriesFile;
    private String propPrefix = null;
    private Object[] warehouseTable;
    private JBBDataStorage customerTable;
    private JBBSortedStorage lastNameCustomerTable;
    private JBBDataStorage itemTable;
    private Object[] timerdataTable;
    private Object[] warehouseContainers;
    private long rampup_time;
    private long measurement_time;
    private TimerData companyTimerData;
    private long elapsed_time;
    private short PreviousMaxWarehouses;
    private short MaxWarehouses;
    private short MaxDistrictsPerWarehouse;
    private int MaxCustomersPerDistrict;
    private int MaxItems;
    private int MaxStock;
    private int InitialOrders;
    private int InitialNewOrders;
    private int InitialHistories;
    private int warehouseCapacity = JBBmain.maxWh;
    private ArrayList warehouseThreads;
    private long jvm_instances = 0L;
    private float per_jvm_warehouse_rampup = 0.5f;
    private float per_jvm_warehouse_rampdown = 0.5f;
    Object initThreadsStateChange = null;
    Object initThreadsCountMonitor = null;
    int initThreadsCount = 0;
    Object threadsDoneCountMonitor = null;
    int threadsDoneCount = 0;
    Object stopThreadsCountMonitor = null;
    int stopThreadsCount = 0;
    private volatile runModes mode = runModes.DEFAULT_MODE;

    static void setOutputs(PrintStream printStream, PrintStream printStream2) {
        outPropFile = printStream;
        outDeliveriesFile = printStream2;
    }

    public Company() {
        JBButil.random_init(this.warehouseCapacity);
        System.out.println("Constructing the company now   Hang....on");
        System.out.println("");
        this.warehouseContainers = new Object[this.warehouseCapacity];
        this.warehouseTable = new Object[this.warehouseCapacity];
        this.customerTable = Infrastructure.createStorage();
        this.lastNameCustomerTable = Infrastructure.createSortedStorage();
        this.itemTable = Infrastructure.createStorage();
        this.timerdataTable = new Object[this.warehouseCapacity];
        this.companyTimerData = new TimerData();
        this.MaxWarehouses = 0;
        this.initThreadsStateChange = new Object();
        this.initThreadsCountMonitor = new Object();
        this.initThreadsCount = 0;
        this.threadsDoneCountMonitor = new Object();
        this.threadsDoneCount = 0;
        this.stopThreadsCountMonitor = new Object();
        this.stopThreadsCount = 0;
        this.warehouseThreads = new ArrayList(this.warehouseCapacity);
    }

    PrintStream getOutDeliveriesFile() {
        return outDeliveriesFile;
    }

    public short getMaxWarehouses() {
        return this.MaxWarehouses;
    }

    public short getMaxDistrictsPerWarehouse() {
        return this.MaxDistrictsPerWarehouse;
    }

    public int getMaxCustomersPerDistrict() {
        return this.MaxCustomersPerDistrict;
    }

    public int getMaxItems() {
        return this.MaxItems;
    }

    public int getInitialOrders() {
        return this.InitialOrders;
    }

    public int getInitialNewOrders() {
        return this.InitialNewOrders;
    }

    public synchronized void primeWithDummyData(short s, int n) {
        switch (n) {
            case 0: {
                this.PreviousMaxWarehouses = this.MaxWarehouses;
                this.MaxWarehouses = this.PreviousMaxWarehouses == 0 ? s : (short)(this.MaxWarehouses + 1);
                String string = "Loading Warehouse " + this.MaxWarehouses + "...";
                System.out.println(string);
                JBButil.getLog().info(string);
                if (this.PreviousMaxWarehouses == 0) {
                    this.loadItemTable();
                }
                this.loadWarehouseTable();
                this.loadCustomerTable();
                this.loadWarehouseHistoryTable();
                this.loadInitialOrders();
                System.out.println("");
                System.out.println("");
                break;
            }
            case 1: {
                this.PreviousMaxWarehouses = this.MaxWarehouses;
                this.MaxWarehouses = this.PreviousMaxWarehouses == 0 ? s : (short)(this.MaxWarehouses + 1);
                String string = "Loading Warehouse " + this.MaxWarehouses + "...";
                System.out.println(string);
                JBButil.getLog().info(string);
                if (this.PreviousMaxWarehouses != 0) break;
                this.loadItemTable();
                break;
            }
            case 2: {
                this.loadWarehouseTable();
                break;
            }
            case 3: {
                this.loadCustomerTable();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.loadInitialOrders();
                System.out.println("");
                System.out.println("");
            }
        }
    }

    public synchronized void startAutomated(short s, int n, int n2) {
        this.companyTimerData.zeroTimerData();
        this.rampup_time = n;
        this.measurement_time = n2;
        TimerData timerData = this.getTimerDataPtr(s);
        timerData.zeroTimerData();
        timerData.setRampUpTime(n);
        timerData.setMeasurementTime(n2);
    }

    public synchronized void startValidation(short s) {
        this.companyTimerData.zeroTimerData();
        TimerData timerData = this.getTimerDataPtr(s);
        timerData.zeroTimerData();
    }

    public synchronized void addWarehouseThread(TransactionManager transactionManager) {
        this.warehouseThreads.add(transactionManager);
    }

    public synchronized void prepareForStart() {
        this.initThreadsCount = 0;
        this.threadsDoneCount = 0;
        this.stopThreadsCount = 0;
        this.mode = runModes.DEFAULT_MODE;
        this.warehouseThreads.clear();
    }

    long getElapsedTime() {
        return this.elapsed_time;
    }

    public Warehouse getWarehousePtr(short s, boolean bl) {
        Warehouse warehouse = (Warehouse)this.warehouseTable[s];
        return warehouse;
    }

    public Customer getCustomer(long l, boolean bl) {
        Customer customer = (Customer)this.customerTable.get(l);
        if (JBButil.getLog().isLoggable(Level.FINEST)) {
            Logger logger = JBButil.getLog();
            logger.finest("Company::getCustomer");
            logger.finest("  customerId=" + l);
            logger.finest("  Customer=" + customer);
        }
        return customer;
    }

    public boolean isCustomer(long l) {
        return this.customerTable.containsKey(l);
    }

    public long buildUniqueCustomerKey(short s, byte by, short s2) {
        long l = s;
        l <<= 12;
        l += (long)by;
        l <<= 40;
        return l += (long)s2;
    }

    public Customer getCustomerByLastName(short s, byte by, String string) {
        String string2 = Integer.toString(s) + "_" + Integer.toString(by) + "_" + string;
        String string3 = string2 + "_~";
        Long l = (Long)this.lastNameCustomerTable.getMedianValue(string2, string3);
        return (Customer)this.customerTable.get(l);
    }

    public synchronized void setJVMInstanceValues(long l) {
        this.jvm_instances = l;
    }

    public synchronized void setMultiJVMRampingValues(float f, float f2) {
        this.per_jvm_warehouse_rampup = f;
        this.per_jvm_warehouse_rampdown = f2;
    }

    public synchronized void setPopulationValues(int n) {
        if (n > 0) {
            this.MaxDistrictsPerWarehouse = (short)10;
            this.MaxCustomersPerDistrict = n;
            this.MaxItems = JBBmain.overrideItemTableSize > 0 ? JBBmain.overrideItemTableSize : 20000;
        } else {
            this.MaxDistrictsPerWarehouse = (short)5;
            this.MaxCustomersPerDistrict = 30;
            this.MaxItems = 100;
        }
        this.MaxStock = this.MaxItems;
        this.InitialOrders = this.MaxCustomersPerDistrict;
        this.InitialNewOrders = (short)((double)this.MaxCustomersPerDistrict * 0.3);
        this.InitialHistories = this.MaxCustomersPerDistrict;
    }

    public synchronized void setPopulationValues(int n, int n2) {
        if (n > 0) {
            this.MaxDistrictsPerWarehouse = (short)10;
            this.MaxCustomersPerDistrict = n;
            this.MaxItems = n2;
        } else {
            this.MaxDistrictsPerWarehouse = (short)5;
            this.MaxCustomersPerDistrict = 30;
            this.MaxItems = 100;
        }
        this.MaxStock = this.MaxItems;
        this.InitialOrders = this.MaxCustomersPerDistrict;
        this.InitialNewOrders = (short)((double)this.MaxCustomersPerDistrict * 0.3);
        this.InitialHistories = this.MaxCustomersPerDistrict;
    }

    public synchronized TimerData getTimerDataPtr(short s) {
        TimerData timerData = s == 0 ? this.companyTimerData : (TimerData)this.timerdataTable[s];
        return timerData;
    }

    public synchronized void trimOrdersForSteadyState() {
        int n = this.getInitialOrders();
        int n2 = this.getInitialNewOrders();
        for (short s = 1; s <= this.MaxWarehouses; s = (short)(s + 1)) {
            Warehouse warehouse = this.getWarehousePtr(s, false);
            warehouse.trimOrdersForSteadyState(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayResultTotals(boolean bl) {
        Object object = this.initThreadsStateChange;
        synchronized (object) {
            while (this.initThreadsCount != this.MaxWarehouses) {
                try {
                    this.initThreadsStateChange.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (JBBmain.multiJVMMode) {
            System.out.println(JBBmain.instanceId + ":READY");
            JBBmain.socOut.println(JBBmain.instanceId + ":READY");
            JBBmain.socOut.flush();
            object = "NULL";
            String string = JBBmain.instanceId + ":START";
            try {
                while (!((String)object).matches(string)) {
                    object = JBBmain.socIn.readLine();
                }
            }
            catch (IOException iOException) {
                JBButil.getLog().log(Level.WARNING, iOException + ": Unable to read from socket", iOException);
                System.exit(1);
            }
            String string2 = ">>>>>>>> Got Message: " + (String)object;
            JBButil.getLog().info(string2);
            System.out.println(string2);
        }
        this.setrunMode(runModes.RAMP_UP);
        object = this.initThreadsCountMonitor;
        synchronized (object) {
            this.initThreadsCountMonitor.notifyAll();
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        DecimalFormat decimalFormat = new DecimalFormat("#####.##");
        long l5 = 0L;
        if (JBBmain.multiJVMMode) {
            this.setrunMode(runModes.MULTI_RAMP);
            l3 = System.currentTimeMillis();
            l5 = (long)this.per_jvm_warehouse_rampup;
            object = "User Thread Multi-JVM Rampup padding began " + new Date().toString() + " for " + l5 + " seconds";
            JBButil.getLog().info((String)object);
            System.out.println((String)object);
            JBButil.SecondsToSleep((int)l5);
        }
        if (this.rampup_time > 0L) {
            object = "User Thread Rampup began " + new Date().toString() + " for " + decimalFormat.format((double)this.rampup_time / 60.0) + " minutes";
            JBButil.getLog().info((String)object);
            System.out.println((String)object);
            JBButil.SecondsToSleep((int)this.rampup_time);
        }
        if (this.measurement_time > 0L) {
            object = "Timing Measurement began " + new Date().toString() + " for " + decimalFormat.format((double)this.measurement_time / 60.0) + " minutes";
            this.setrunMode(runModes.RECORDING);
            l = System.currentTimeMillis();
            JBButil.getLog().info((String)object);
            System.out.println((String)object);
            JBButil.SecondsToSleep((int)this.measurement_time);
        }
        l2 = System.currentTimeMillis();
        object = "Timing Measurement ended " + new Date().toString();
        JBButil.getLog().info((String)object);
        System.out.println((String)object);
        if (JBBmain.multiJVMMode) {
            this.setrunMode(runModes.MULTI_RAMP);
            l5 = (long)this.per_jvm_warehouse_rampdown;
            object = "User Thread Multi-JVM Rampdown padding began " + new Date().toString() + " for " + l5 + " seconds";
            JBButil.getLog().info((String)object);
            System.out.println((String)object);
            JBButil.SecondsToSleep((int)l5);
            l4 = System.currentTimeMillis();
        }
        this.setrunMode(runModes.RAMP_DOWN);
        this.elapsed_time = l2 - l;
        System.out.println("");
        Object object2 = this.threadsDoneCountMonitor;
        synchronized (object2) {
            while (this.threadsDoneCount != this.MaxWarehouses) {
                try {
                    this.threadsDoneCountMonitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.setrunMode(runModes.STOP);
        object2 = this.stopThreadsCountMonitor;
        synchronized (object2) {
            while (this.stopThreadsCount != this.MaxWarehouses) {
                try {
                    this.stopThreadsCountMonitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        outPropFile.println(this.propPrefix + "warehouses=" + this.MaxWarehouses);
        if (JBBmain.multiJVMMode) {
            outPropFile.println(this.propPrefix + "start_rampup_time_milliseconds=" + l3);
            outPropFile.println(this.propPrefix + "end_rampdown_time_milliseconds=" + l4);
        }
        outPropFile.println(this.propPrefix + "start_time_milliseconds=" + l);
        outPropFile.println(this.propPrefix + "end_time_milliseconds=" + l2);
        outPropFile.println(this.propPrefix + "elapsed_milliseconds=" + this.elapsed_time);
        System.out.println("");
        int n = 0;
        long l6 = Long.MAX_VALUE;
        long l7 = Long.MIN_VALUE;
        for (short s = 1; s <= this.MaxWarehouses; s = (short)(s + 1)) {
            TimerData timerData = this.getTimerDataPtr(s);
            timerData.calculateResponseTimeStats();
            if (bl) {
                timerData.propResults(this.propPrefix + "warehouse_" + s + ".", outPropFile);
            }
            n = 0;
            for (int i = 0; i < Transaction.maxTxnTypes; ++i) {
                n = (int)((long)n + timerData.getTransactionCount(i));
            }
            if ((long)n < l6) {
                l6 = n;
            }
            if ((long)n <= l7) continue;
            l7 = n;
        }
        System.out.println("Calculating results");
        this.companyTimerData.calculateResponseTimeStats();
        this.companyTimerData.displayThreadResults();
        long l8 = l7 - l6;
        float f = 100.0f * (float)l8 / (float)l7;
        System.out.println("");
        System.out.println("Minimum transactions by a warehouse = " + l6);
        System.out.println("Maximum transactions by a warehouse = " + l7);
        System.out.println("Difference (thread spread) = " + l8 + " (" + decimalFormat.format(f) + "%)");
        System.out.println("");
        this.companyTimerData.displayResults("COMPANY with " + this.MaxWarehouses + " warehouses ", JBButil.currentTotalMem(), JBButil.currentFreeMem());
        this.companyTimerData.propResults(this.propPrefix + "company.", outPropFile, JBButil.currentTotalMem(), JBButil.currentFreeMem());
        this.companyTimerData.propThreadResults(this.propPrefix + "company.", outPropFile);
        outPropFile.println(this.propPrefix + "company.min_warehouse_transactions=" + l6);
        outPropFile.println(this.propPrefix + "company.max_warehouse_transactions=" + l7);
        if (Transaction.steadyStateMem) {
            this.trimOrdersForSteadyState();
        }
        this.setrunMode(runModes.DEFAULT_MODE);
    }

    public synchronized void loadWarehouseTable() {
        for (short s = (short)(this.PreviousMaxWarehouses + 1); s <= this.MaxWarehouses; s = (short)(s + 1)) {
            Warehouse warehouse = new Warehouse();
            warehouse.initWarehouse(this, this.itemTable, s);
            warehouse.setUsingRandom(s);
            this.warehouseTable[s] = warehouse;
            TimerData timerData = new TimerData();
            this.timerdataTable[s] = timerData;
        }
    }

    public synchronized void loadCustomerTable() {
        long l = 0L;
        for (short s = (short)(this.PreviousMaxWarehouses + 1); s <= this.MaxWarehouses; s = (short)(s + 1)) {
            for (byte by = 1; by <= this.MaxDistrictsPerWarehouse; by = (byte)(by + 1)) {
                short s2;
                for (s2 = 1; s2 <= this.MaxCustomersPerDistrict; s2 = (short)(s2 + 1)) {
                    Customer customer = new Customer();
                    customer.setUsingRandom(s2, s, by);
                    long l2 = this.buildUniqueCustomerKey(s, by, s2);
                    this.customerTable.put(l2, customer);
                    String string = Integer.toString(s) + "_" + Integer.toString(by) + "_" + customer.getLastName() + "_" + Integer.toString(s2);
                    this.lastNameCustomerTable.put(string, l2);
                    if (!JBButil.getLog().isLoggable(Level.FINEST)) continue;
                    Logger logger = JBButil.getLog();
                    logger.finest("Company::loadCustomerTable");
                    logger.finest("  newCustomer=" + customer);
                    logger.finest("  customerId=" + s2);
                    logger.finest("  districtId=" + by);
                    logger.finest("  warehouseId=" + s);
                    logger.finest("  uniqueCustomerNumber=" + l2);
                    logger.finest("  custNameKey=" + string);
                }
                l += (long)(s2 - 1);
            }
        }
    }

    public void setrunMode(runModes runModes2) {
        for (int i = 0; i < this.warehouseThreads.size(); ++i) {
            TransactionManager transactionManager = (TransactionManager)this.warehouseThreads.get(i);
            transactionManager.setrunMode(runModes2);
        }
        this.mode = runModes2;
    }

    public synchronized void loadItemTable() {
        for (int i = 1; i <= this.MaxItems; ++i) {
            Item item = new Item();
            item.setUsingRandom(i);
            this.itemTable.put(i, item);
        }
    }

    public synchronized void dumpWarehouseTable() {
    }

    public synchronized void dumpCustomerTable() {
    }

    public synchronized void dumpItemTable() {
    }

    public synchronized void loadWarehouseHistoryTable() {
        for (short s = (short)(this.PreviousMaxWarehouses + 1); s <= this.MaxWarehouses; s = (short)(s + 1)) {
            ((Warehouse)this.warehouseTable[s]).loadHistoryTable();
        }
    }

    public synchronized void loadInitialOrders() {
        for (short s = (short)(this.PreviousMaxWarehouses + 1); s <= this.MaxWarehouses; s = (short)(s + 1)) {
            NewOrderTransaction newOrderTransaction = new NewOrderTransaction(this, s);
            for (byte by = 1; by <= this.MaxDistrictsPerWarehouse; by = (byte)((byte)(by + 1))) {
                for (short s2 = 1; s2 <= this.MaxCustomersPerDistrict; s2 = (short)(s2 + 1)) {
                    newOrderTransaction.init();
                    newOrderTransaction.setDistrictandCustomer(by, s2);
                    newOrderTransaction.processPreloadedOrders();
                }
            }
        }
    }

    void setPropOutputPrefix(String string) {
        this.propPrefix = string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum runModes {
        DEFAULT_MODE,
        MULTI_RAMP,
        RAMP_UP,
        RECORDING,
        RAMP_DOWN,
        STOP;

    }
}

