/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.BaseHash;
import cds.healpix.CompassPoint;
import java.util.EnumMap;
import java.util.EnumSet;

final class BaseHashNorthPolarCap
extends BaseHash {
    private static final EnumSet<CompassPoint.MainWind> noNeighbour = EnumSet.of(CompassPoint.MainWind.E, CompassPoint.MainWind.W);
    private static final EnumMap<CompassPoint.MainWind, CompassPoint.MainWind> dirFromNeighbour = new EnumMap(CompassPoint.MainWind.class);

    protected BaseHashNorthPolarCap(int baseHash) {
        super(baseHash);
    }

    @Override
    protected void fillNeighbours(int d0h, int[] neighbours) {
        int hm1Modulo4;
        assert (0 <= d0h && d0h < 4);
        int hModulo4 = d0h & 3;
        int hp1Modulo4 = d0h + 1 & 3;
        neighbours[CompassPoint.MainWind.SE.getIndex()] = hp1Modulo4 + 4;
        neighbours[CompassPoint.MainWind.E.getIndex()] = -1;
        neighbours[CompassPoint.MainWind.NE.getIndex()] = hp1Modulo4;
        int hp2Modulo4 = d0h + 2 & 3;
        neighbours[CompassPoint.MainWind.S.getIndex()] = d0h + 8;
        neighbours[CompassPoint.MainWind.C.getIndex()] = d0h;
        neighbours[CompassPoint.MainWind.N.getIndex()] = hp2Modulo4;
        neighbours[CompassPoint.MainWind.NW.getIndex()] = hm1Modulo4 = d0h - 1 & 3;
        neighbours[CompassPoint.MainWind.W.getIndex()] = -1;
        neighbours[CompassPoint.MainWind.SW.getIndex()] = hModulo4 + 4;
    }

    @Override
    CompassPoint.MainWind getDirectionFromNeighbour(CompassPoint.MainWind neighbourMainWind) {
        if (noNeighbour.contains((Object)neighbourMainWind)) {
            throw new IllegalArgumentException("No neighbour in direction " + (Object)((Object)neighbourMainWind));
        }
        return dirFromNeighbour.get((Object)neighbourMainWind);
    }

    @Override
    CompassPoint.MainWind getEdgeCellDirectionFromNeighbour(CompassPoint.MainWind innerDirection, CompassPoint.MainWind neighbourDirection) {
        switch (neighbourDirection) {
            case C: {
                new IllegalArgumentException("No neighbour in direction " + (Object)((Object)neighbourDirection));
            }
            case E: {
                switch (innerDirection) {
                    case N: 
                    case NE: {
                        return CompassPoint.MainWind.N;
                    }
                    case E: {
                        new IllegalArgumentException("No neighbour in direction " + (Object)((Object)neighbourDirection));
                    }
                    case S: 
                    case SE: {
                        return neighbourDirection.getOppositeDirection();
                    }
                }
                assert (false);
            }
            case W: {
                switch (innerDirection) {
                    case N: 
                    case NW: {
                        return CompassPoint.MainWind.N;
                    }
                    case W: {
                        new IllegalArgumentException("No neighbour in direction " + (Object)((Object)neighbourDirection));
                    }
                    case S: 
                    case SW: {
                        return neighbourDirection.getOppositeDirection();
                    }
                }
                assert (false);
            }
            case NE: {
                return CompassPoint.MainWind.NW;
            }
            case NW: {
                return CompassPoint.MainWind.NE;
            }
            case N: {
                switch (innerDirection) {
                    case N: {
                        return CompassPoint.MainWind.N;
                    }
                    case NE: 
                    case E: {
                        return CompassPoint.MainWind.W;
                    }
                    case NW: 
                    case W: {
                        return CompassPoint.MainWind.E;
                    }
                }
                assert (false);
                break;
            }
        }
        return neighbourDirection.getOppositeDirection();
    }

    @Override
    int pickRightIndexOnNeighbourSouthToEastAxis(CompassPoint.MainWind neighbourDirection, int iAxisSE, int iAxisSW, int nsideMinus1) {
        return neighbourDirection.pickRightIntValue(nsideMinus1, nsideMinus1, iAxisSW, -1, iAxisSE, -1, nsideMinus1, nsideMinus1, iAxisSE);
    }

    @Override
    long pickRightIndexBitsOnNeighbourSouthToEastAxis(CompassPoint.MainWind neighbourDirection, long iAxisSEBits, long jAxiSWBits, long nsideMinus1Bits) {
        return neighbourDirection.pickRightLongValue(nsideMinus1Bits, nsideMinus1Bits, jAxiSWBits, -1L, iAxisSEBits, -1L, nsideMinus1Bits, nsideMinus1Bits, iAxisSEBits);
    }

    @Override
    int pickRightIndexOnNeighbourSouthToWestAxis(CompassPoint.MainWind neighbourDirection, int iAxisSE, int iAxisSW, int nsideMinus1) {
        return neighbourDirection.pickRightIntValue(iAxisSE, nsideMinus1, nsideMinus1, -1, iAxisSW, -1, iAxisSW, nsideMinus1, nsideMinus1);
    }

    @Override
    long pickRightIndexSWBits(CompassPoint.MainWind neighbourDirection, long iAxisSEBits, long jAxisSWBits, long nsideMinus1Bits) {
        return neighbourDirection.pickRightLongValue(iAxisSEBits, nsideMinus1Bits, nsideMinus1Bits, -1L, jAxisSWBits, -1L, jAxisSWBits, nsideMinus1Bits, nsideMinus1Bits);
    }

    static {
        dirFromNeighbour.put(CompassPoint.MainWind.NE, CompassPoint.MainWind.NW);
        dirFromNeighbour.put(CompassPoint.MainWind.N, CompassPoint.MainWind.N);
        dirFromNeighbour.put(CompassPoint.MainWind.NW, CompassPoint.MainWind.NE);
        dirFromNeighbour.put(CompassPoint.MainWind.C, CompassPoint.MainWind.C.getOppositeDirection());
        dirFromNeighbour.put(CompassPoint.MainWind.SE, CompassPoint.MainWind.SE.getOppositeDirection());
        dirFromNeighbour.put(CompassPoint.MainWind.S, CompassPoint.MainWind.S.getOppositeDirection());
        dirFromNeighbour.put(CompassPoint.MainWind.SW, CompassPoint.MainWind.SW.getOppositeDirection());
    }
}

