# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `test-unit` gem.
# Please instead update this file by running `bin/tapioca gem test-unit`.


class Object < ::BasicObject
  include ::Kernel
  include ::PP::ObjectMixin

  private

  # source://test-unit//lib/test-unit.rb#15
  def run_test; end
end

# source://test-unit//lib/test-unit.rb#5
module Test; end

# source://test-unit//lib/test-unit.rb#6
module Test::Unit; end

# Thrown by Test::Unit::Assertions when an assertion fails.
#
# source://test-unit//lib/test/unit/assertion-failed-error.rb#11
class Test::Unit::AssertionFailedError < ::StandardError
  # @return [AssertionFailedError] a new instance of AssertionFailedError
  #
  # source://test-unit//lib/test/unit/assertion-failed-error.rb#25
  def initialize(message = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the value of attribute actual.
  #
  # source://test-unit//lib/test/unit/assertion-failed-error.rb#23
  def actual; end

  # Sets the attribute actual
  #
  # @param value the value to set the attribute actual to.
  #
  # source://test-unit//lib/test/unit/assertion-failed-error.rb#23
  def actual=(_arg0); end

  # Returns the value of attribute expected.
  #
  # source://test-unit//lib/test/unit/assertion-failed-error.rb#23
  def expected; end

  # Sets the attribute expected
  #
  # @param value the value to set the attribute expected to.
  #
  # source://test-unit//lib/test/unit/assertion-failed-error.rb#23
  def expected=(_arg0); end

  # Returns the value of attribute inspected_actual.
  #
  # source://test-unit//lib/test/unit/assertion-failed-error.rb#24
  def inspected_actual; end

  # Sets the attribute inspected_actual
  #
  # @param value the value to set the attribute inspected_actual to.
  #
  # source://test-unit//lib/test/unit/assertion-failed-error.rb#24
  def inspected_actual=(_arg0); end

  # Returns the value of attribute inspected_expected.
  #
  # source://test-unit//lib/test/unit/assertion-failed-error.rb#24
  def inspected_expected; end

  # Sets the attribute inspected_expected
  #
  # @param value the value to set the attribute inspected_expected to.
  #
  # source://test-unit//lib/test/unit/assertion-failed-error.rb#24
  def inspected_expected=(_arg0); end

  # Returns the value of attribute user_message.
  #
  # source://test-unit//lib/test/unit/assertion-failed-error.rb#23
  def user_message; end

  # Sets the attribute user_message
  #
  # @param value the value to set the attribute user_message to.
  #
  # source://test-unit//lib/test/unit/assertion-failed-error.rb#23
  def user_message=(_arg0); end

  private

  # source://test-unit//lib/test/unit/assertion-failed-error.rb#37
  def debug_on_failure; end

  class << self
    # source://test-unit//lib/test/unit/assertion-failed-error.rb#14
    def debug_on_failure=(boolean); end

    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/assertion-failed-error.rb#18
    def debug_on_failure?; end
  end
end

# Test::Unit::Assertions contains the standard Test::Unit assertions.
# Assertions is included in Test::Unit::TestCase.
#
# To include it in your own code and use its functionality, you simply
# need to rescue Test::Unit::AssertionFailedError. Additionally you may
# override add_assertion to get notified whenever an assertion is made.
#
# Notes:
#
# * The message to each assertion, if given, will be propagated with the
#   failure.
# * It is easy to add your own assertions based on assert_block().
#
# @example Example Custom Assertion
#
#   def deny(boolean, message=nil)
#   message = build_message(message, '<?> is not false or nil.', boolean)
#   assert_block(message) do
#   not boolean
#   end
#   end
#
# source://test-unit//lib/test/unit/assertions.rb#43
module Test::Unit::Assertions
  # Called whenever an assertion is made. Define this in classes
  # that include Test::Unit::Assertions to record assertion
  # counts.
  #
  # This is a public API for developers who extend test-unit.
  #
  # @return [void]
  #
  # source://test-unit//lib/test/unit/assertions.rb#1933
  def add_assertion; end

  # @overload assert
  # @overload assert
  #
  # source://test-unit//lib/test/unit/assertions.rb#134
  def assert(object = T.unsafe(nil), message = T.unsafe(nil), &block); end

  # Passes if `object`#`alias_name` is an alias method of
  # `object`#`original_name`.
  #
  # @example
  #   assert_alias_method([], :length, :size)  # -> pass
  #   assert_alias_method([], :size, :length)  # -> pass
  #   assert_alias_method([], :each, :size)    # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1587
  def assert_alias_method(object, alias_name, original_name, message = T.unsafe(nil)); end

  # @overload assert_all
  # @since 3.4.4
  #
  # source://test-unit//lib/test/unit/assertions.rb#1797
  def assert_all(collection, message = T.unsafe(nil)); end

  # Just for Ruby's tool/lib/test/unit compatibility.
  #
  # @overload assert_all
  # @since 3.4.4
  # @since 3.4.3
  #
  # source://test-unit//lib/test/unit/assertions.rb#1823
  def assert_all?(collection, message = T.unsafe(nil)); end

  # The assertion upon which all other assertions are based. Passes if the
  # block yields not false nor nil.
  #
  # @example
  #   assert_block "Couldn't do the thing" do
  #   do_the_thing
  #   end
  #
  # source://test-unit//lib/test/unit/assertions.rb#53
  def assert_block(message = T.unsafe(nil)); end

  # Passes if `actual` is a boolean value.
  #
  # @example
  #   assert_boolean(true) # -> pass
  #   assert_boolean(nil)  # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1358
  def assert_boolean(actual, message = T.unsafe(nil)); end

  # Passes if expression "`expected` `operator`
  # `actual`" is not false nor nil.
  #
  # @example
  #   assert_compare(1, "<", 10)  # -> pass
  #   assert_compare(1, ">=", 10) # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1407
  def assert_compare(expected, operator, actual, message = T.unsafe(nil)); end

  # Passes if `object`.const_defined?(`constant_name`)
  #
  # @example
  #   assert_const_defined(Test, :Unit)          # -> pass
  #   assert_const_defined(Object, :Nonexistent) # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1502
  def assert_const_defined(object, constant_name, message = T.unsafe(nil)); end

  # Passes if `object` is empty.
  #
  # @example
  #   assert_empty("")                       # -> pass
  #   assert_empty([])                       # -> pass
  #   assert_empty({})                       # -> pass
  #   assert_empty(" ")                      # -> fail
  #   assert_empty([nil])                    # -> fail
  #   assert_empty({1 => 2})                 # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1732
  def assert_empty(object, message = T.unsafe(nil)); end

  # Passes if `expected` == `actual`.
  #
  # Note that the ordering of arguments is important, since a helpful
  # error message is generated when this one fails that tells you the
  # values of expected and actual.
  #
  # @example
  #   assert_equal 'MY STRING', 'my string'.upcase
  #
  # source://test-unit//lib/test/unit/assertions.rb#225
  def assert_equal(expected, actual, message = T.unsafe(nil)); end

  # Passes if assertion is failed in block.
  #
  # @example
  #   assert_fail_assertion {assert_equal("A", "B")}  # -> pass
  #   assert_fail_assertion {assert_equal("A", "A")}  # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1440
  def assert_fail_assertion(message = T.unsafe(nil)); end

  # Passes if `actual` is false.
  #
  # @example
  #   assert_false(false)  # -> pass
  #   assert_false(nil)    # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1390
  def assert_false(actual, message = T.unsafe(nil)); end

  # Passes if `expected_float` and `actual_float` are equal
  # within `delta` tolerance.
  #
  # @example
  #   assert_in_delta 0.05, (50000.0 / 10**6), 0.00001
  #
  # source://test-unit//lib/test/unit/assertions.rb#927
  def assert_in_delta(expected_float, actual_float, delta = T.unsafe(nil), message = T.unsafe(nil)); end

  # Passes if `expected_float` and `actual_float` are equal
  # within `epsilon` relative error of `expected_float`.
  #
  # @example
  #   assert_in_epsilon(10000.0, 9900.0, 0.1) # -> pass
  #   assert_in_epsilon(10000.0, 9899.0, 0.1) # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1089
  def assert_in_epsilon(expected_float, actual_float, epsilon = T.unsafe(nil), message = T.unsafe(nil)); end

  # Passes if `collection` includes `object`.
  #
  # @example
  #   assert_include([1, 10], 1)            # -> pass
  #   assert_include(1..10, 5)              # -> pass
  #   assert_include([1, 10], 5)            # -> fail
  #   assert_include(1..10, 20)             # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1671
  def assert_include(collection, object, message = T.unsafe(nil)); end

  # Passes if `collection` includes `object`.
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_include([1, 10], 1)            # -> pass
  #   assert_include(1..10, 5)              # -> pass
  #   assert_include([1, 10], 5)            # -> fail
  #   assert_include(1..10, 20)             # -> fail
  # @since 2.5.3
  #
  # source://test-unit//lib/test/unit/assertions.rb#1688
  def assert_includes(collection, object, message = T.unsafe(nil)); end

  # Passes if `object`.instance_of?(`klass`). When `klass` is
  # an array of classes, it passes if any class
  # satisfies +object.instance_of?(class).
  #
  # @example
  #   assert_instance_of(String, 'foo')            # -> pass
  #   assert_instance_of([Fixnum, NilClass], 100)  # -> pass
  #   assert_instance_of([Numeric, NilClass], 100) # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#391
  def assert_instance_of(klass, object, message = T.unsafe(nil)); end

  # Passes if `object`.kind_of?(`klass`). When `klass` is
  # an array of classes or modules, it passes if any
  # class or module satisfies +object.kind_of?(class_or_module).
  #
  # @example
  #   assert_kind_of(Object, 'foo')                # -> pass
  #   assert_kind_of([Fixnum, NilClass], 100)      # -> pass
  #   assert_kind_of([Fixnum, NilClass], "string") # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#478
  def assert_kind_of(klass, object, message = T.unsafe(nil)); end

  # Passes if `pattern` =~ `string`.
  #
  # @example
  #   assert_match(/\d+/, 'five, 6, seven')
  #
  # source://test-unit//lib/test/unit/assertions.rb#601
  def assert_match(pattern, string, message = T.unsafe(nil)); end

  # Passes if `object`.nil?.
  #
  # @example
  #   assert_nil [1, 2].uniq!
  #
  # source://test-unit//lib/test/unit/assertions.rb#462
  def assert_nil(object, message = T.unsafe(nil)); end

  # Passes if `regexp` !~ `string`
  #
  # @deprecated Use {#assert_not_match} instead.
  # @example
  #   assert_no_match(/two/, 'one 2 three')   # -> pass
  #   assert_no_match(/three/, 'one 2 three') # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#798
  def assert_no_match(regexp, string, message = T.unsafe(nil)); end

  # Passes if !`object`.const_defined?(`constant_name`)
  #
  # @example
  #   assert_not_const_defined(Object, :Nonexistent) # -> pass
  #   assert_not_const_defined(Test, :Unit)          # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1519
  def assert_not_const_defined(object, constant_name, message = T.unsafe(nil)); end

  # Passes if `object` is not empty.
  #
  # @example
  #   assert_not_empty(" ")                      # -> pass
  #   assert_not_empty([nil])                    # -> pass
  #   assert_not_empty({1 => 2})                 # -> pass
  #   assert_not_empty("")                       # -> fail
  #   assert_not_empty([])                       # -> fail
  #   assert_not_empty({})                       # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1755
  def assert_not_empty(object, message = T.unsafe(nil)); end

  # Passes if `expected` != `actual`
  #
  # @example
  #   assert_not_equal 'some string', 5
  #
  # source://test-unit//lib/test/unit/assertions.rb#740
  def assert_not_equal(expected, actual, message = T.unsafe(nil)); end

  # Passes if `expected_float` and `actual_float` are
  # not equal within `delta` tolerance.
  #
  # @example
  #   assert_not_in_delta(0.05, (50000.0 / 10**6), 0.00002) # -> pass
  #   assert_not_in_delta(0.05, (50000.0 / 10**6), 0.00001) # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#971
  def assert_not_in_delta(expected_float, actual_float, delta = T.unsafe(nil), message = T.unsafe(nil)); end

  # Passes if `expected_float` and `actual_float` are
  # not equal within `epsilon` relative error of
  # `expected_float`.
  #
  # @example
  #   assert_not_in_epsilon(10000.0, 9900.0, 0.1) # -> fail
  #   assert_not_in_epsilon(10000.0, 9899.0, 0.1) # -> pass
  #
  # source://test-unit//lib/test/unit/assertions.rb#1150
  def assert_not_in_epsilon(expected_float, actual_float, epsilon = T.unsafe(nil), message = T.unsafe(nil)); end

  # Passes if `collection` doesn't include `object`.
  #
  # @example
  #   assert_not_include([1, 10], 5)            # -> pass
  #   assert_not_include(1..10, 20)             # -> pass
  #   assert_not_include([1, 10], 1)            # -> fail
  #   assert_not_include(1..10, 5)              # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1698
  def assert_not_include(collection, object, message = T.unsafe(nil)); end

  # Passes if `collection` doesn't include `object`.
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_not_include([1, 10], 5)            # -> pass
  #   assert_not_include(1..10, 20)             # -> pass
  #   assert_not_include([1, 10], 1)            # -> fail
  #   assert_not_include(1..10, 5)              # -> fail
  # @since 3.0.0
  #
  # source://test-unit//lib/test/unit/assertions.rb#1715
  def assert_not_includes(collection, object, message = T.unsafe(nil)); end

  # Passes if `object`.instance_of?(`klass`) does not hold.
  # When `klass` is an array of classes, it passes if no class
  # satisfies +object.instance_of?(class).
  #
  # @example
  #   assert_not_instance_of(String, 100)                # -> pass
  #   assert_not_instance_of([Fixnum, NilClass], '100')  # -> pass
  #   assert_not_instance_of([Numeric, NilClass], 100)   # -> fail
  # @since 3.0.0
  #
  # source://test-unit//lib/test/unit/assertions.rb#427
  def assert_not_instance_of(klass, object, message = T.unsafe(nil)); end

  # Passes if `object`.kind_of?(`klass`) does not hold.
  # When `klass` is an array of classes or modules, it passes only if all
  # classes (and modules) do not satisfy +object.kind_of?(class_or_module).
  #
  # @example
  #   assert_not_kind_of(Fixnum, 'foo')           # -> pass
  #   assert_not_kind_of([Fixnum, NilClass], '0') # -> pass
  #   assert_not_kind_of([Fixnum, NilClass], 100) # -> fail
  # @since 3.0.0
  #
  # source://test-unit//lib/test/unit/assertions.rb#516
  def assert_not_kind_of(klass, object, message = T.unsafe(nil)); end

  # Passes if `regexp` !~ `string`
  #
  # @example
  #   assert_not_match(/two/, 'one 2 three')   # -> pass
  #   assert_not_match(/three/, 'one 2 three') # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#775
  def assert_not_match(pattern, string, message = T.unsafe(nil)); end

  # Passes if ! `object` .nil?
  #
  # @example
  #   assert_not_nil '1 two 3'.sub!(/two/, '2')
  #
  # source://test-unit//lib/test/unit/assertions.rb#757
  def assert_not_nil(object, message = T.unsafe(nil)); end

  # Compares the `object1` with `object2` using `operator`.
  #
  # Passes if object1.__send__(operator, object2) is false or nil.
  #
  # @example
  #   assert_not_operator(5, :<, 4) # => pass
  #   assert_not_operator(5, :>, 4) # => fail
  # @since 3.0.0
  #
  # source://test-unit//lib/test/unit/assertions.rb#658
  def assert_not_operator(object1, operator, object2, message = T.unsafe(nil)); end

  # Passes if `object`.`predicate` is false or nil.
  #
  # @example
  #   assert_not_predicate([1], :empty?) # -> pass
  #   assert_not_predicate([], :empty?)  # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1558
  def assert_not_predicate(object, predicate, message = T.unsafe(nil)); end

  # Passes if `object` does not .respond_to? `method`.
  #
  # @example
  #   assert_not_respond_to('bugbear', :nonexistence) # -> pass
  #   assert_not_respond_to('bugbear', :size)         # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#574
  def assert_not_respond_to(object, method, message = T.unsafe(nil)); end

  # Passes if ! `actual` .equal? `expected`
  #
  # @example
  #   assert_not_same Object.new, Object.new
  #
  # source://test-unit//lib/test/unit/assertions.rb#720
  def assert_not_same(expected, actual, message = T.unsafe(nil)); end

  # Passes if the method `__send__` returns false or nil.
  #
  # `send_array` is composed of:
  # * A receiver
  # * A method
  # * Arguments to the method
  #
  # @example
  #   assert_not_send([[1, 2], :member?, 1]) # -> fail
  #   assert_not_send([[1, 2], :member?, 4]) # -> pass
  #
  # source://test-unit//lib/test/unit/assertions.rb#1323
  def assert_not_send(send_array, message = T.unsafe(nil)); end

  # @overload assert_nothing_leaked_memory
  # @since 3.4.5
  #
  # source://test-unit//lib/test/unit/assertions.rb#1871
  def assert_nothing_leaked_memory(max_increasable_size, target = T.unsafe(nil), message = T.unsafe(nil)); end

  # Passes if block does not raise an exception.
  #
  # @example
  #   assert_nothing_raised do
  #   [1, 2].uniq
  #   end
  #
  # source://test-unit//lib/test/unit/assertions.rb#683
  def assert_nothing_raised(*args); end

  # Passes if block does not throw anything.
  #
  # @example
  #   assert_nothing_thrown do
  #   [1, 2].uniq
  #   end
  #
  # source://test-unit//lib/test/unit/assertions.rb#903
  def assert_nothing_thrown(message = T.unsafe(nil), &proc); end

  # Compares the `object1` with `object2` using `operator`.
  #
  # Passes if object1.__send__(operator, object2) is not false nor nil.
  #
  # @example
  #   assert_operator 5, :>=, 4
  #
  # source://test-unit//lib/test/unit/assertions.rb#635
  def assert_operator(object1, operator, object2, message = T.unsafe(nil)); end

  # Passes if `path` exists.
  #
  # @example
  #   assert_path_exist("/tmp")          # -> pass
  #   assert_path_exist("/bin/sh")       # -> pass
  #   assert_path_exist("/nonexistent")  # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1634
  def assert_path_exist(path, message = T.unsafe(nil)); end

  # Passes if `path` doesn't exist.
  #
  # @example
  #   assert_path_not_exist("/nonexistent")  # -> pass
  #   assert_path_not_exist("/tmp")          # -> fail
  #   assert_path_not_exist("/bin/sh")       # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1652
  def assert_path_not_exist(path, message = T.unsafe(nil)); end

  # Passes if `object`.`predicate` is not false nor nil.
  #
  # @example
  #   assert_predicate([], :empty?)  # -> pass
  #   assert_predicate([1], :empty?) # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1536
  def assert_predicate(object, predicate, message = T.unsafe(nil)); end

  # Passes if the block raises one of the expected
  # exceptions. When an expected exception is an Exception
  # object, passes if expected_exception == actual_exception.
  #
  # @example
  #   assert_raise(RuntimeError, LoadError) do
  #   raise 'Boom!!!'
  #   end # -> pass
  #
  #   assert_raise do
  #   raise Exception, 'Any exception should be raised!!!'
  #   end # -> pass
  #
  #   assert_raise(RuntimeError.new("XXX")) {raise "XXX"} # -> pass
  #   assert_raise(MyError.new("XXX"))      {raise "XXX"} # -> fail
  #   assert_raise(RuntimeError.new("ZZZ")) {raise "XXX"} # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#269
  def assert_raise(*args, &block); end

  # Passes if the block raises one of the given
  # exceptions or sub exceptions of the given exceptions.
  #
  # @example
  #   assert_raise_kind_of(SystemCallError) do
  #   raise Errno::EACCES
  #   end
  #
  # source://test-unit//lib/test/unit/assertions.rb#366
  def assert_raise_kind_of(*args, &block); end

  # Passes if an exception is raised in block and its
  # message is `expected`.
  #
  # @example
  #   assert_raise_message("exception") {raise "exception"}  # -> pass
  #   assert_raise_message(/exc/i) {raise "exception"}       # -> pass
  #   assert_raise_message("exception") {raise "EXCEPTION"}  # -> fail
  #   assert_raise_message("exception") {}                   # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1464
  def assert_raise_message(expected, message = T.unsafe(nil)); end

  # Passes if the block raises `expected_exception` with
  # `expected_message`. `expected_message` can be a `String` or
  # `Regexp`.
  #
  # @example Failure pattern: Exception class isn't matched
  #   assert_raise_with_message(RuntimeError, "Boom!!!") do
  #   raise ArgumentError, "Boom!!!"
  #   end # -> failure
  # @example Failure pattern: Exception message isn't matched
  #   assert_raise_with_message(RuntimeError, "Boom!!!") do
  #   raise "Hello"
  #   end # -> failure
  # @example Pass pattern: Regexp
  #   assert_raise_with_message(RuntimeError, /!!!/) do
  #   raise "Boom!!!"
  #   end # -> pass
  # @example Pass pattern: String
  #   assert_raise_with_message(RuntimeError, "Boom!!!") do
  #   raise "Boom!!!"
  #   end # -> pass
  # @since 3.4.3
  #
  # source://test-unit//lib/test/unit/assertions.rb#318
  def assert_raise_with_message(expected_exception_class, expected_message, message = T.unsafe(nil), &block); end

  # Passes if the block raises one of the expected
  # exceptions. When an expected exception is an Exception
  # object, passes if expected_exception == actual_exception.
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_raise(RuntimeError, LoadError) do
  #   raise 'Boom!!!'
  #   end # -> pass
  #
  #   assert_raise do
  #   raise Exception, 'Any exception should be raised!!!'
  #   end # -> pass
  #
  #   assert_raise(RuntimeError.new("XXX")) {raise "XXX"} # -> pass
  #   assert_raise(MyError.new("XXX"))      {raise "XXX"} # -> fail
  #   assert_raise(RuntimeError.new("ZZZ")) {raise "XXX"} # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#291
  def assert_raises(*args, &block); end

  # Passes if `object` .respond_to? `method`
  #
  # @example
  #   assert_respond_to 'bugbear', :slice
  #
  # source://test-unit//lib/test/unit/assertions.rb#551
  def assert_respond_to(object, method, message = T.unsafe(nil)); end

  # Passes if `actual` .equal? `expected` (i.e. they are the same
  # instance).
  #
  # @example
  #   o = Object.new
  #   assert_same o, o
  #
  # source://test-unit//lib/test/unit/assertions.rb#618
  def assert_same(expected, actual, message = T.unsafe(nil)); end

  # Passes if the method `__send__` returns not false nor nil.
  #
  # `send_array` is composed of:
  # * A receiver
  # * A method
  # * Arguments to the method
  #
  # @example
  #   assert_send([[1, 2], :member?, 1]) # -> pass
  #   assert_send([[1, 2], :member?, 4]) # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1283
  def assert_send(send_array, message = T.unsafe(nil)); end

  # Passes if the block throws `expected_object`
  #
  # @example
  #   assert_throw(:done) do
  #   throw(:done)
  #   end
  #
  # source://test-unit//lib/test/unit/assertions.rb#857
  def assert_throw(expected_object, message = T.unsafe(nil), &proc); end

  # Passes if the block throws `expected_object`
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_throw(:done) do
  #   throw(:done)
  #   end
  # @since 2.5.3
  #
  # source://test-unit//lib/test/unit/assertions.rb#894
  def assert_throws(expected_object, message = T.unsafe(nil), &proc); end

  # Passes if `actual` is true.
  #
  # @example
  #   assert_true(true)  # -> pass
  #   assert_true(:true) # -> fail
  #
  # source://test-unit//lib/test/unit/assertions.rb#1374
  def assert_true(actual, message = T.unsafe(nil)); end

  # Builds a failure message.  `user_message` is added before the
  # `template` and `arguments` replaces the '?'s positionally in
  # the template.
  #
  # source://test-unit//lib/test/unit/assertions.rb#1904
  def build_message(user_message, template = T.unsafe(nil), *arguments); end

  # Flunk always fails.
  #
  # @example
  #   flunk 'Not done testing yet.'
  #
  # source://test-unit//lib/test/unit/assertions.rb#711
  def flunk(message = T.unsafe(nil)); end

  # Asserts that `object` is false or nil.
  #
  # @example Failure patterns
  #   refute(true)     # => failure
  #   refute("string") # => failure
  # @example Pass patterns
  #   refute(false)    # => pass
  #   refute(nil)      # => pass
  # @note Just for minitest compatibility. :<
  # @param object [Object] The object to be asserted.
  # @return [void]
  # @since 2.5.3
  #
  # source://test-unit//lib/test/unit/assertions.rb#191
  def refute(object, message = T.unsafe(nil)); end

  # Passes if `object` is not empty.
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_not_empty(" ")                      # -> pass
  #   assert_not_empty([nil])                    # -> pass
  #   assert_not_empty({1 => 2})                 # -> pass
  #   assert_not_empty("")                       # -> fail
  #   assert_not_empty([])                       # -> fail
  #   assert_not_empty({})                       # -> fail
  # @since 3.0.0
  #
  # source://test-unit//lib/test/unit/assertions.rb#1771
  def refute_empty(object, message = T.unsafe(nil)); end

  # Passes if `expected` != `actual`
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_not_equal 'some string', 5
  # @since 2.5.3
  #
  # source://test-unit//lib/test/unit/assertions.rb#750
  def refute_equal(expected, actual, message = T.unsafe(nil)); end

  # Passes if `expected_float` and `actual_float` are
  # not equal within `delta` tolerance.
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_not_in_delta(0.05, (50000.0 / 10**6), 0.00002) # -> pass
  #   assert_not_in_delta(0.05, (50000.0 / 10**6), 0.00001) # -> fail
  # @since 2.5.3
  #
  # source://test-unit//lib/test/unit/assertions.rb#1009
  def refute_in_delta(expected_float, actual_float, delta = T.unsafe(nil), message = T.unsafe(nil)); end

  # Passes if `expected_float` and `actual_float` are
  # not equal within `epsilon` relative error of
  # `expected_float`.
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_not_in_epsilon(10000.0, 9900.0, 0.1) # -> fail
  #   assert_not_in_epsilon(10000.0, 9899.0, 0.1) # -> pass
  # @since 3.0.0
  #
  # source://test-unit//lib/test/unit/assertions.rb#1197
  def refute_in_epsilon(expected_float, actual_float, epsilon = T.unsafe(nil), message = T.unsafe(nil)); end

  # Passes if `collection` doesn't include `object`.
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_not_include([1, 10], 5)            # -> pass
  #   assert_not_include(1..10, 20)             # -> pass
  #   assert_not_include([1, 10], 1)            # -> fail
  #   assert_not_include(1..10, 5)              # -> fail
  # @since 3.0.0
  #
  # source://test-unit//lib/test/unit/assertions.rb#1720
  def refute_includes(collection, object, message = T.unsafe(nil)); end

  # Passes if `object`.instance_of?(`klass`) does not hold.
  # When `klass` is an array of classes, it passes if no class
  # satisfies +object.instance_of?(class).
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_not_instance_of(String, 100)                # -> pass
  #   assert_not_instance_of([Fixnum, NilClass], '100')  # -> pass
  #   assert_not_instance_of([Numeric, NilClass], 100)   # -> fail
  # @since 3.0.0
  # @since 3.0.0
  #
  # source://test-unit//lib/test/unit/assertions.rb#455
  def refute_instance_of(klass, object, message = T.unsafe(nil)); end

  # Passes if `object`.kind_of?(`klass`) does not hold.
  # When `klass` is an array of classes or modules, it passes only if all
  # classes (and modules) do not satisfy +object.kind_of?(class_or_module).
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_not_kind_of(Fixnum, 'foo')           # -> pass
  #   assert_not_kind_of([Fixnum, NilClass], '0') # -> pass
  #   assert_not_kind_of([Fixnum, NilClass], 100) # -> fail
  # @since 3.0.0
  # @since 3.0.0
  #
  # source://test-unit//lib/test/unit/assertions.rb#544
  def refute_kind_of(klass, object, message = T.unsafe(nil)); end

  # Passes if `regexp` !~ `string`
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_not_match(/two/, 'one 2 three')   # -> pass
  #   assert_not_match(/three/, 'one 2 three') # -> fail
  # @since 2.5.3
  #
  # source://test-unit//lib/test/unit/assertions.rb#788
  def refute_match(pattern, string, message = T.unsafe(nil)); end

  # Passes if ! `object` .nil?
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_not_nil '1 two 3'.sub!(/two/, '2')
  # @since 2.5.3
  #
  # source://test-unit//lib/test/unit/assertions.rb#767
  def refute_nil(object, message = T.unsafe(nil)); end

  # Compares the `object1` with `object2` using `operator`.
  #
  # Passes if object1.__send__(operator, object2) is false or nil.
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_not_operator(5, :<, 4) # => pass
  #   assert_not_operator(5, :>, 4) # => fail
  # @since 3.0.0
  # @since 3.0.0
  #
  # source://test-unit//lib/test/unit/assertions.rb#674
  def refute_operator(object1, operator, object2, message = T.unsafe(nil)); end

  # Passes if `object`.`predicate` is false or nil.
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_not_predicate([1], :empty?) # -> pass
  #   assert_not_predicate([], :empty?)  # -> fail
  # @since 3.0.0
  #
  # source://test-unit//lib/test/unit/assertions.rb#1577
  def refute_predicate(object, predicate, message = T.unsafe(nil)); end

  # Passes if `object` does not .respond_to? `method`.
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_not_respond_to('bugbear', :nonexistence) # -> pass
  #   assert_not_respond_to('bugbear', :size)         # -> fail
  # @since 2.5.3
  #
  # source://test-unit//lib/test/unit/assertions.rb#594
  def refute_respond_to(object, method, message = T.unsafe(nil)); end

  # Passes if ! `actual` .equal? `expected`
  # Just for minitest compatibility. :<
  #
  # @example
  #   assert_not_same Object.new, Object.new
  # @since 2.5.3
  #
  # source://test-unit//lib/test/unit/assertions.rb#733
  def refute_same(expected, actual, message = T.unsafe(nil)); end

  private

  # source://test-unit//lib/test/unit/assertions.rb#1028
  def _assert_in_delta_message(expected_float, normalized_expected, actual_float, normalized_actual, delta, normalized_delta, message, options = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/assertions.rb#1012
  def _assert_in_delta_validate_arguments(expected_float, actual_float, delta); end

  # source://test-unit//lib/test/unit/assertions.rb#1216
  def _assert_in_epsilon_message(expected_float, normalized_expected, actual_float, normalized_actual, epsilon, normalized_epsilon, delta, message, options = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/assertions.rb#1200
  def _assert_in_epsilon_validate_arguments(expected_float, actual_float, epsilon); end

  # source://test-unit//lib/test/unit/assertions.rb#1944
  def _assert_raise(assert_expected_exception, *args, &block); end

  # source://test-unit//lib/test/unit/assertions.rb#1973
  def _set_failed_information(failure, expected, actual); end

  # source://test-unit//lib/test/unit/assertions.rb#1910
  def _wrap_assertion(&block); end

  class << self
    # Select whether or not to use the pretty-printer. If this option is set
    # to false before any assertions are made, pp.rb will not be required.
    #
    # source://test-unit//lib/test/unit/assertions.rb#1939
    def use_pp=(value); end
  end
end

# source://test-unit//lib/test/unit/assertions.rb#2393
class Test::Unit::Assertions::AssertExceptionHelper
  # @return [AssertExceptionHelper] a new instance of AssertExceptionHelper
  #
  # source://test-unit//lib/test/unit/assertions.rb#2432
  def initialize(test_case, expected_exceptions); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/assertions.rb#2454
  def expected?(actual_exception, equality = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/assertions.rb#2439
  def expected_exceptions; end

  private

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/assertions.rb#2498
  def exception_class?(exception_type); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/assertions.rb#2488
  def exception_object?(exception_type); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/assertions.rb#2508
  def expected_class?(actual_exception, equality); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/assertions.rb#2514
  def expected_module?(actual_exception); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/assertions.rb#2520
  def expected_object?(actual_exception); end

  # source://test-unit//lib/test/unit/assertions.rb#2527
  def fallback_exception_object_equal(expected_object, actual_exception); end

  # source://test-unit//lib/test/unit/assertions.rb#2462
  def split_expected_exceptions(expected_exceptions); end
end

# source://test-unit//lib/test/unit/assertions.rb#2394
class Test::Unit::Assertions::AssertExceptionHelper::WrappedException
  # @return [WrappedException] a new instance of WrappedException
  #
  # source://test-unit//lib/test/unit/assertions.rb#2396
  def initialize(exception); end

  # Returns the value of attribute exception.
  #
  # source://test-unit//lib/test/unit/assertions.rb#2395
  def exception; end

  # source://test-unit//lib/test/unit/assertions.rb#2400
  def inspect; end

  # source://test-unit//lib/test/unit/assertions.rb#2415
  def method_missing(name, *args, &block); end

  private

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/assertions.rb#2420
  def default_inspect?; end
end

# source://test-unit//lib/test/unit/assertions.rb#1980
class Test::Unit::Assertions::AssertionMessage
  include ::Test::Unit::Util::BacktraceFilter

  # @return [AssertionMessage] a new instance of AssertionMessage
  #
  # source://test-unit//lib/test/unit/assertions.rb#2355
  def initialize(user_message, template_string, parameters); end

  # source://test-unit//lib/test/unit/assertions.rb#2361
  def convert(object); end

  # source://test-unit//lib/test/unit/assertions.rb#2365
  def template; end

  # source://test-unit//lib/test/unit/assertions.rb#2376
  def to_s; end

  # source://test-unit//lib/test/unit/assertions.rb#2369
  def user_message; end

  private

  # source://test-unit//lib/test/unit/assertions.rb#2388
  def add_period(string); end

  class << self
    # source://test-unit//lib/test/unit/assertions.rb#2071
    def convert(object); end

    # source://test-unit//lib/test/unit/assertions.rb#2048
    def delayed_diff(from, to); end

    # source://test-unit//lib/test/unit/assertions.rb#1989
    def delayed_literal(&block); end

    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/assertions.rb#2017
    def diff_target_string?(string); end

    # source://test-unit//lib/test/unit/assertions.rb#2025
    def ensure_diffable_string(string); end

    # source://test-unit//lib/test/unit/assertions.rb#1985
    def literal(value); end

    # source://test-unit//lib/test/unit/assertions.rb#1998
    def max_diff_target_string_size; end

    # source://test-unit//lib/test/unit/assertions.rb#2013
    def max_diff_target_string_size=(size); end

    # source://test-unit//lib/test/unit/assertions.rb#1993
    def maybe_container(value, &formatter); end

    # source://test-unit//lib/test/unit/assertions.rb#2033
    def prepare_for_diff(from, to); end

    # Returns the value of attribute use_pp.
    #
    # source://test-unit//lib/test/unit/assertions.rb#1983
    def use_pp; end

    # Sets the attribute use_pp
    #
    # @param value the value to set the attribute use_pp to.
    #
    # source://test-unit//lib/test/unit/assertions.rb#1983
    def use_pp=(_arg0); end
  end
end

# source://test-unit//lib/test/unit/assertions.rb#2235
class Test::Unit::Assertions::AssertionMessage::ArrayInspector
  # @return [ArrayInspector] a new instance of ArrayInspector
  #
  # source://test-unit//lib/test/unit/assertions.rb#2244
  def initialize(array, inspected_objects); end

  # source://test-unit//lib/test/unit/assertions.rb#2267
  def each(&block); end

  # source://test-unit//lib/test/unit/assertions.rb#2251
  def inspect; end

  # source://test-unit//lib/test/unit/assertions.rb#2255
  def pretty_print(q); end

  # source://test-unit//lib/test/unit/assertions.rb#2263
  def pretty_print_cycle(q); end

  class << self
    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/assertions.rb#2239
    def target?(object); end
  end
end

# source://test-unit//lib/test/unit/assertions.rb#2282
class Test::Unit::Assertions::AssertionMessage::DelayedLiteral
  # @return [DelayedLiteral] a new instance of DelayedLiteral
  #
  # source://test-unit//lib/test/unit/assertions.rb#2283
  def initialize(value); end

  # source://test-unit//lib/test/unit/assertions.rb#2287
  def inspect; end
end

# source://test-unit//lib/test/unit/assertions.rb#2181
class Test::Unit::Assertions::AssertionMessage::HashInspector
  # @return [HashInspector] a new instance of HashInspector
  #
  # source://test-unit//lib/test/unit/assertions.rb#2190
  def initialize(hash, inspected_objects); end

  # source://test-unit//lib/test/unit/assertions.rb#2223
  def each_pair; end

  # source://test-unit//lib/test/unit/assertions.rb#2200
  def inspect; end

  # source://test-unit//lib/test/unit/assertions.rb#2204
  def pretty_print(q); end

  # source://test-unit//lib/test/unit/assertions.rb#2219
  def pretty_print_cycle(q); end

  class << self
    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/assertions.rb#2185
    def target?(object); end
  end
end

# source://test-unit//lib/test/unit/assertions.rb#2091
class Test::Unit::Assertions::AssertionMessage::Inspector
  include ::Comparable

  # @return [Inspector] a new instance of Inspector
  #
  # source://test-unit//lib/test/unit/assertions.rb#2115
  def initialize(object, inspected_objects = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/assertions.rb#2135
  def <=>(other); end

  # source://test-unit//lib/test/unit/assertions.rb#2123
  def inspect; end

  # source://test-unit//lib/test/unit/assertions.rb#2122
  def native_inspect; end

  # Returns the value of attribute object.
  #
  # source://test-unit//lib/test/unit/assertions.rb#2114
  def object; end

  # source://test-unit//lib/test/unit/assertions.rb#2127
  def pretty_print(q); end

  # source://test-unit//lib/test/unit/assertions.rb#2131
  def pretty_print_cycle(q); end

  private

  # source://test-unit//lib/test/unit/assertions.rb#2144
  def inspect_target; end

  class << self
    # source://test-unit//lib/test/unit/assertions.rb#2095
    def cached_new(object, inspected_objects); end

    # source://test-unit//lib/test/unit/assertions.rb#2101
    def inspector_classes; end

    # source://test-unit//lib/test/unit/assertions.rb#2105
    def register_inspector_class(inspector_class); end

    # source://test-unit//lib/test/unit/assertions.rb#2109
    def unregister_inspector_class(inspector_class); end
  end
end

# source://test-unit//lib/test/unit/assertions.rb#2272
class Test::Unit::Assertions::AssertionMessage::Literal
  # @return [Literal] a new instance of Literal
  #
  # source://test-unit//lib/test/unit/assertions.rb#2273
  def initialize(value); end

  # source://test-unit//lib/test/unit/assertions.rb#2277
  def inspect; end
end

# source://test-unit//lib/test/unit/assertions.rb#2292
class Test::Unit::Assertions::AssertionMessage::MaybeContainer
  # @return [MaybeContainer] a new instance of MaybeContainer
  #
  # source://test-unit//lib/test/unit/assertions.rb#2293
  def initialize(value, &formatter); end

  # source://test-unit//lib/test/unit/assertions.rb#2298
  def inspect; end
end

# source://test-unit//lib/test/unit/assertions.rb#2154
class Test::Unit::Assertions::AssertionMessage::NumericInspector
  # @return [NumericInspector] a new instance of NumericInspector
  #
  # source://test-unit//lib/test/unit/assertions.rb#2163
  def initialize(numeric, inspected_objects); end

  # source://test-unit//lib/test/unit/assertions.rb#2168
  def inspect; end

  # source://test-unit//lib/test/unit/assertions.rb#2172
  def pretty_print(q); end

  # source://test-unit//lib/test/unit/assertions.rb#2176
  def pretty_print_cycle(q); end

  class << self
    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/assertions.rb#2158
    def target?(object); end
  end
end

# source://test-unit//lib/test/unit/assertions.rb#2310
class Test::Unit::Assertions::AssertionMessage::Template
  # @return [Template] a new instance of Template
  #
  # source://test-unit//lib/test/unit/assertions.rb#2318
  def initialize(parts); end

  # Returns the value of attribute count.
  #
  # source://test-unit//lib/test/unit/assertions.rb#2316
  def count; end

  # source://test-unit//lib/test/unit/assertions.rb#2323
  def result(parameters); end

  private

  # source://test-unit//lib/test/unit/assertions.rb#2344
  def concatenatable(text, encoding); end

  class << self
    # source://test-unit//lib/test/unit/assertions.rb#2311
    def create(string); end
  end
end

# @private
#
# source://test-unit//lib/test/unit/assertions.rb#66
Test::Unit::Assertions::NOT_SPECIFIED = T.let(T.unsafe(nil), Object)

# @private
#
# source://test-unit//lib/test/unit/assertions.rb#808
class Test::Unit::Assertions::ThrowTagExtractor
  # @return [ThrowTagExtractor] a new instance of ThrowTagExtractor
  #
  # source://test-unit//lib/test/unit/assertions.rb#817
  def initialize(error); end

  # source://test-unit//lib/test/unit/assertions.rb#821
  def extract_tag; end

  private

  # source://test-unit//lib/test/unit/assertions.rb#836
  def normalize_tag(tag); end
end

# source://test-unit//lib/test/unit/assertions.rb#811
Test::Unit::Assertions::ThrowTagExtractor::UncaughtThrowPatterns = T.let(T.unsafe(nil), Hash)

# source://test-unit//lib/test/unit/attribute.rb#3
module Test::Unit::Attribute
  mixes_in_class_methods ::Test::Unit::Attribute::BaseClassMethods
  mixes_in_class_methods ::Test::Unit::Attribute::ClassMethods

  # source://test-unit//lib/test/unit/attribute.rb#223
  def [](name); end

  # source://test-unit//lib/test/unit/attribute.rb#219
  def attributes; end

  class << self
    # @private
    #
    # source://test-unit//lib/test/unit/attribute.rb#25
    def included(base); end
  end
end

# source://test-unit//lib/test/unit/attribute.rb#31
module Test::Unit::Attribute::BaseClassMethods
  # source://test-unit//lib/test/unit/attribute.rb#32
  def attributes_table; end
end

# source://test-unit//lib/test/unit/attribute.rb#37
module Test::Unit::Attribute::ClassMethods
  # Set an attribute to test methods.
  #
  # @overload attribute
  # @overload attribute
  # @overload attribute
  # @overload attribute
  #
  # source://test-unit//lib/test/unit/attribute.rb#120
  def attribute(name, value, options = T.unsafe(nil), *method_names); end

  # source://test-unit//lib/test/unit/attribute.rb#214
  def attribute_observers(attribute_name); end

  # source://test-unit//lib/test/unit/attribute.rb#165
  def attributes(method_name); end

  # source://test-unit//lib/test/unit/attribute.rb#142
  def attributes_table; end

  # source://test-unit//lib/test/unit/attribute.rb#138
  def current_attribute(name); end

  # source://test-unit//lib/test/unit/attribute.rb#134
  def current_attributes; end

  # source://test-unit//lib/test/unit/attribute.rb#182
  def find_attribute(method_name, name, options = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/attribute.rb#38
  def method_added(name); end

  # source://test-unit//lib/test/unit/attribute.rb#208
  def register_attribute_observer(attribute_name, observer = T.unsafe(nil), &block); end

  # source://test-unit//lib/test/unit/attribute.rb#147
  def set_attributes(method_name, new_attributes); end
end

# source://test-unit//lib/test/unit/attribute.rb#4
class Test::Unit::Attribute::StringifyKeyHash < ::Hash
  # source://test-unit//lib/test/unit/attribute.rb#15
  def [](key); end

  # source://test-unit//lib/test/unit/attribute.rb#19
  def []=(key, value); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/attribute.rb#11
  def key?(key); end

  class << self
    # source://test-unit//lib/test/unit/attribute.rb#6
    def stringify(object); end
  end
end

# source://test-unit//lib/test/unit/attribute-matcher.rb#3
class Test::Unit::AttributeMatcher
  # @return [AttributeMatcher] a new instance of AttributeMatcher
  #
  # source://test-unit//lib/test/unit/attribute-matcher.rb#4
  def initialize(test); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/attribute-matcher.rb#8
  def match?(expression); end

  # source://test-unit//lib/test/unit/attribute-matcher.rb#17
  def method_missing(name, *args); end
end

# source://test-unit//lib/test/unit/autorunner.rb#13
class Test::Unit::AutoRunner
  # @return [AutoRunner] a new instance of AutoRunner
  # @yield [_self]
  # @yieldparam _self [Test::Unit::AutoRunner] the object that the method was called on
  #
  # source://test-unit//lib/test/unit/autorunner.rb#153
  def initialize(standalone); end

  # Returns the value of attribute base.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#146
  def base; end

  # Sets the attribute base
  #
  # @param value the value to set the attribute base to.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#146
  def base=(_arg0); end

  # Sets the attribute collector
  #
  # @param value the value to set the attribute collector to.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#151
  def collector=(_arg0); end

  # Returns the value of attribute color_scheme.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#147
  def color_scheme; end

  # Sets the attribute color_scheme
  #
  # @param value the value to set the attribute color_scheme to.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#147
  def color_scheme=(_arg0); end

  # Sets the attribute debug_on_failure
  #
  # @param value the value to set the attribute debug_on_failure to.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#149
  def debug_on_failure=(_arg0); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/autorunner.rb#186
  def debug_on_failure?; end

  # Returns the value of attribute default_test_paths.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#145
  def default_test_paths; end

  # Sets the attribute default_test_paths
  #
  # @param value the value to set the attribute default_test_paths to.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#145
  def default_test_paths=(_arg0); end

  # Returns the value of attribute exclude.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#146
  def exclude; end

  # Sets the attribute exclude
  #
  # @param value the value to set the attribute exclude to.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#146
  def exclude=(_arg0); end

  # Returns the value of attribute filters.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#144
  def filters; end

  # Sets the attribute filters
  #
  # @param value the value to set the attribute filters to.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#144
  def filters=(_arg0); end

  # Sets the attribute gc_stress
  #
  # @param value the value to set the attribute gc_stress to.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#150
  def gc_stress=(_arg0); end

  # source://test-unit//lib/test/unit/autorunner.rb#463
  def keyword_display(keywords); end

  # Returns the value of attribute listeners.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#147
  def listeners; end

  # Sets the attribute listeners
  #
  # @param value the value to set the attribute listeners to.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#147
  def listeners=(_arg0); end

  # source://test-unit//lib/test/unit/autorunner.rb#503
  def load_config(file); end

  # source://test-unit//lib/test/unit/autorunner.rb#525
  def load_plain_text_config(file); end

  # source://test-unit//lib/test/unit/autorunner.rb#208
  def options; end

  # Returns the value of attribute pattern.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#146
  def pattern; end

  # Sets the attribute pattern
  #
  # @param value the value to set the attribute pattern to.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#146
  def pattern=(_arg0); end

  # source://test-unit//lib/test/unit/autorunner.rb#190
  def prepare; end

  # source://test-unit//lib/test/unit/autorunner.rb#196
  def process_args(args = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/autorunner.rb#481
  def run; end

  # Sets the attribute runner
  #
  # @param value the value to set the attribute runner to.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#151
  def runner=(_arg0); end

  # Returns the value of attribute runner_options.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#143
  def runner_options; end

  # Sets the attribute stop_on_failure
  #
  # @param value the value to set the attribute stop_on_failure to.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#148
  def stop_on_failure=(_arg0); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/autorunner.rb#182
  def stop_on_failure?; end

  # Returns the value of attribute suite.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#143
  def suite; end

  # Returns the value of attribute to_run.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#144
  def to_run; end

  # Sets the attribute to_run
  #
  # @param value the value to set the attribute to_run to.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#144
  def to_run=(_arg0); end

  # Returns the value of attribute workdir.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#146
  def workdir; end

  # Sets the attribute workdir
  #
  # @param value the value to set the attribute workdir to.
  #
  # source://test-unit//lib/test/unit/autorunner.rb#146
  def workdir=(_arg0); end

  private

  # source://test-unit//lib/test/unit/autorunner.rb#610
  def add_location_filter(path, line); end

  # source://test-unit//lib/test/unit/autorunner.rb#601
  def add_test_path(path); end

  # source://test-unit//lib/test/unit/autorunner.rb#560
  def change_work_directory(&block); end

  # source://test-unit//lib/test/unit/autorunner.rb#545
  def default_collector; end

  # source://test-unit//lib/test/unit/autorunner.rb#535
  def default_runner; end

  # source://test-unit//lib/test/unit/autorunner.rb#549
  def global_config_file; end

  # source://test-unit//lib/test/unit/autorunner.rb#555
  def load_global_config; end

  # source://test-unit//lib/test/unit/autorunner.rb#593
  def match_test_case_name(test, pattern); end

  # source://test-unit//lib/test/unit/autorunner.rb#583
  def match_test_name(test, pattern); end

  # source://test-unit//lib/test/unit/autorunner.rb#568
  def prepare_name(name); end

  class << self
    # source://test-unit//lib/test/unit/autorunner.rb#45
    def collector(id); end

    # source://test-unit//lib/test/unit/autorunner.rb#31
    def default_runner; end

    # source://test-unit//lib/test/unit/autorunner.rb#35
    def default_runner=(id); end

    # source://test-unit//lib/test/unit/autorunner.rb#84
    def need_auto_run=(need); end

    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/autorunner.rb#80
    def need_auto_run?; end

    # source://test-unit//lib/test/unit/autorunner.rb#58
    def prepare(hook = T.unsafe(nil), &block); end

    # source://test-unit//lib/test/unit/autorunner.rb#39
    def register_collector(id, collector_builder = T.unsafe(nil), &block); end

    # source://test-unit//lib/test/unit/autorunner.rb#49
    def register_color_scheme(id, scheme); end

    # source://test-unit//lib/test/unit/autorunner.rb#20
    def register_runner(id, runner_builder = T.unsafe(nil), &block); end

    # source://test-unit//lib/test/unit/autorunner.rb#63
    def run(force_standalone = T.unsafe(nil), default_dir = T.unsafe(nil), argv = T.unsafe(nil), &block); end

    # source://test-unit//lib/test/unit/autorunner.rb#26
    def runner(id); end

    # source://test-unit//lib/test/unit/autorunner.rb#53
    def setup_option(option_builder = T.unsafe(nil), &block); end

    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/autorunner.rb#71
    def standalone?; end
  end
end

# source://test-unit//lib/test/unit/autorunner.rb#16
Test::Unit::AutoRunner::ADDITIONAL_OPTIONS = T.let(T.unsafe(nil), Array)

# source://test-unit//lib/test/unit/autorunner.rb#15
Test::Unit::AutoRunner::COLLECTORS = T.let(T.unsafe(nil), Hash)

# source://test-unit//lib/test/unit/autorunner.rb#626
class Test::Unit::AutoRunner::GCStressListener
  # source://test-unit//lib/test/unit/autorunner.rb#627
  def attach_to_mediator(mediator); end
end

# source://test-unit//lib/test/unit/autorunner.rb#17
Test::Unit::AutoRunner::PREPARE_HOOKS = T.let(T.unsafe(nil), Array)

# source://test-unit//lib/test/unit/autorunner.rb#14
Test::Unit::AutoRunner::RUNNERS = T.let(T.unsafe(nil), Hash)

# source://test-unit//lib/test/unit/autorunner.rb#618
class Test::Unit::AutoRunner::StopOnFailureListener
  # source://test-unit//lib/test/unit/autorunner.rb#619
  def attach_to_mediator(mediator); end
end

# source://test-unit//lib/test/unit/auto-runner-loader.rb#5
module Test::Unit::AutoRunnerLoader
  class << self
    # source://test-unit//lib/test/unit/auto-runner-loader.rb#8
    def check(test_case, method_name); end
  end
end

# source://test-unit//lib/test/unit/code-snippet-fetcher.rb#3
class Test::Unit::CodeSnippetFetcher
  # @return [CodeSnippetFetcher] a new instance of CodeSnippetFetcher
  #
  # source://test-unit//lib/test/unit/code-snippet-fetcher.rb#4
  def initialize; end

  # source://test-unit//lib/test/unit/code-snippet-fetcher.rb#8
  def fetch(path, line, options = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/code-snippet-fetcher.rb#21
  def source(path); end

  private

  # source://test-unit//lib/test/unit/code-snippet-fetcher.rb#43
  def detect_encoding(first_line); end

  # source://test-unit//lib/test/unit/code-snippet-fetcher.rb#26
  def read_source(path); end
end

# source://test-unit//lib/test/unit/color.rb#3
class Test::Unit::Color
  # @return [Color] a new instance of Color
  #
  # source://test-unit//lib/test/unit/color.rb#28
  def initialize(name, options = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/color.rb#104
  def +(other); end

  # source://test-unit//lib/test/unit/color.rb#69
  def ==(other); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/color.rb#49
  def background?; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/color.rb#57
  def bold?; end

  # source://test-unit//lib/test/unit/color.rb#100
  def escape_sequence; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/color.rb#45
  def foreground?; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/color.rb#53
  def intensity?; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/color.rb#61
  def italic?; end

  # Returns the value of attribute name.
  #
  # source://test-unit//lib/test/unit/color.rb#27
  def name; end

  # source://test-unit//lib/test/unit/color.rb#77
  def sequence; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/color.rb#65
  def underline?; end

  class << self
    # source://test-unit//lib/test/unit/color.rb#11
    def parse_256_color(string); end
  end
end

# source://test-unit//lib/test/unit/color.rb#4
class Test::Unit::Color::Error < ::StandardError; end

# source://test-unit//lib/test/unit/color.rb#24
Test::Unit::Color::NAMES = T.let(T.unsafe(nil), Array)

# source://test-unit//lib/test/unit/color.rb#7
class Test::Unit::Color::ParseError < ::Test::Unit::Color::Error; end

# source://test-unit//lib/test/unit/color-scheme.rb#5
class Test::Unit::ColorScheme
  include ::Enumerable

  # @return [ColorScheme] a new instance of ColorScheme
  #
  # source://test-unit//lib/test/unit/color-scheme.rb#178
  def initialize(scheme_spec); end

  # source://test-unit//lib/test/unit/color-scheme.rb#185
  def [](name); end

  # source://test-unit//lib/test/unit/color-scheme.rb#189
  def []=(name, color_spec); end

  # source://test-unit//lib/test/unit/color-scheme.rb#193
  def each(&block); end

  # source://test-unit//lib/test/unit/color-scheme.rb#197
  def to_hash; end

  private

  # source://test-unit//lib/test/unit/color-scheme.rb#206
  def make_color(color_spec); end

  class << self
    # source://test-unit//lib/test/unit/color-scheme.rb#112
    def [](id); end

    # source://test-unit//lib/test/unit/color-scheme.rb#116
    def []=(id, scheme_or_spec); end

    # source://test-unit//lib/test/unit/color-scheme.rb#108
    def all; end

    # source://test-unit//lib/test/unit/color-scheme.rb#125
    def available_colors; end

    # source://test-unit//lib/test/unit/color-scheme.rb#25
    def default; end

    # source://test-unit//lib/test/unit/color-scheme.rb#71
    def default_for_256_colors; end

    # source://test-unit//lib/test/unit/color-scheme.rb#34
    def default_for_8_colors; end

    private

    # source://test-unit//lib/test/unit/color-scheme.rb#149
    def guess_available_colors_from_colorterm_env; end

    # source://test-unit//lib/test/unit/color-scheme.rb#169
    def guess_available_colors_from_github_actions_env; end

    # source://test-unit//lib/test/unit/color-scheme.rb#158
    def guess_available_colors_from_term_env; end

    # source://test-unit//lib/test/unit/color-scheme.rb#134
    def guess_available_colors_from_vte_version_env; end
  end
end

# source://test-unit//lib/test/unit/color-scheme.rb#8
Test::Unit::ColorScheme::TERM_256 = T.let(T.unsafe(nil), Regexp)

# source://test-unit//lib/test/unit/data.rb#5
module Test::Unit::Data
  mixes_in_class_methods ::Test::Unit::Data::ClassMethods

  class << self
    # @private
    #
    # source://test-unit//lib/test/unit/data.rb#7
    def included(base); end
  end
end

# source://test-unit//lib/test/unit/data.rb#12
module Test::Unit::Data::ClassMethods
  # This method provides Data-Driven-Test functionality.
  #
  # Define test data in the test code.
  #
  # @overload data
  # @overload data
  # @overload data
  # @overload data
  # @overload data
  #
  # source://test-unit//lib/test/unit/data.rb#129
  def data(*arguments, &block); end

  # This method provides Data-Driven-Test functionality.
  #
  # Load test data from the file. This is shorthand to load
  # test data from file.  If you want to load complex file, you
  # can use {#data} with block.
  #
  # @example Load data from CSV file
  #   load_data("/path/to/test-data.csv")
  #   def test_empty?(data)
  #   assert_equal(data["expected"], data["target"].empty?)
  #   end
  # @param file_name [String] full path to test data file.
  #   File format is automatically detected from filename extension.
  # @raise [ArgumentError] if `file_name` is not supported file format.
  # @see Loader#load
  #
  # source://test-unit//lib/test/unit/data.rb#199
  def load_data(file_name); end
end

# source://test-unit//lib/test/unit/data.rb#204
class Test::Unit::Data::ClassMethods::Loader
  # @api private
  # @return [Loader] a new instance of Loader
  #
  # source://test-unit//lib/test/unit/data.rb#206
  def initialize(test_case); end

  # Load data from file.
  #
  # @api private
  # @param file_name [String] full path to test data file.
  #   File format is automatically detected from filename extension.
  # @raise [ArgumentError] if `file_name` is not supported file format.
  # @see #load_csv
  # @see #load_tsv
  #
  # source://test-unit//lib/test/unit/data.rb#218
  def load(file_name); end

  # Load data from CSV file.
  #
  # There are 2 types of CSV file as following examples.
  # First, there is a header on first row and it's first column is "label".
  # Another, there is no header in the file.
  #
  # @api private
  # @example Load data from CSV file with header
  #   # test-data.csv:
  #   #  label,expected,target
  #   #  empty string,true,""
  #   #  plain string,false,hello
  #   #
  #   load_data("/path/to/test-data.csv")
  #   def test_empty?(data)
  #   assert_equal(data["expected"], data["target"].empty?)
  #   end
  # @example Load data from CSV file without header
  #   # test-data-without-header.csv:
  #   #  empty string,true,""
  #   #  plain string,false,hello
  #   #
  #   load_data("/path/to/test-data-without-header.csv")
  #   def test_empty?(data)
  #   expected, target = data
  #   assert_equal(expected, target.empty?)
  #   end
  #
  # source://test-unit//lib/test/unit/data.rb#258
  def load_csv(file_name); end

  # Load data from TSV file.
  #
  # There are 2 types of TSV file as following examples.
  # First, there is a header on first row and it's first column is "label".
  # Another, there is no header in the file.
  #
  # @api private
  # @example Load data from TSV file with header
  #   # test-data.tsv:
  #   #  label	expected	target
  #   #  empty string	true	""
  #   #  plain string	false	hello
  #   #
  #   load_data("/path/to/test-data.tsv")
  #   def test_empty?(data)
  #   assert_equal(data["expected"], data["target"].empty?)
  #   end
  # @example Load data from TSV file without header
  #   # test-data-without-header.tsv:
  #   #  empty string	true	""
  #   #  plain string	false	hello
  #   #
  #   load_data("/path/to/test-data-without-header.tsv")
  #   def test_empty?(data)
  #   expected, target = data
  #   assert_equal(expected, target.empty?)
  #   end
  #
  # source://test-unit//lib/test/unit/data.rb#304
  def load_tsv(file_name); end

  private

  # source://test-unit//lib/test/unit/data.rb#339
  def normalize_value(value); end

  # source://test-unit//lib/test/unit/data.rb#353
  def set_test_data(header, row); end
end

# source://test-unit//lib/test/unit/data-sets.rb#3
class Test::Unit::DataSets
  # @return [DataSets] a new instance of DataSets
  #
  # source://test-unit//lib/test/unit/data-sets.rb#4
  def initialize; end

  # source://test-unit//lib/test/unit/data-sets.rb#21
  def <<(data_set); end

  # source://test-unit//lib/test/unit/data-sets.rb#66
  def ==(other); end

  # source://test-unit//lib/test/unit/data-sets.rb#10
  def add(data_set, options = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/data-sets.rb#42
  def each; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/data-sets.rb#72
  def eql?(other); end

  # source://test-unit//lib/test/unit/data-sets.rb#76
  def hash; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/data-sets.rb#25
  def have_keep?; end

  # source://test-unit//lib/test/unit/data-sets.rb#32
  def keep; end

  private

  # source://test-unit//lib/test/unit/data-sets.rb#81
  def each_data_set(&block); end

  # source://test-unit//lib/test/unit/data-sets.rb#87
  def each_pattern(variables); end

  # source://test-unit//lib/test/unit/data-sets.rb#106
  def each_raw_pattern(variables, &block); end
end

# source://test-unit//lib/test/unit/diff.rb#11
module Test::Unit::Diff
  private

  # source://test-unit//lib/test/unit/diff.rb#724
  def diff(differ_class, from, to, options = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/diff.rb#706
  def fold(string); end

  # source://test-unit//lib/test/unit/diff.rb#712
  def folded_readable(from, to, options = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/diff.rb#702
  def need_fold?(diff); end

  # source://test-unit//lib/test/unit/diff.rb#716
  def readable(from, to, options = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/diff.rb#720
  def unified(from, to, options = T.unsafe(nil)); end

  class << self
    # source://test-unit//lib/test/unit/diff.rb#724
    def diff(differ_class, from, to, options = T.unsafe(nil)); end

    # source://test-unit//lib/test/unit/diff.rb#706
    def fold(string); end

    # source://test-unit//lib/test/unit/diff.rb#712
    def folded_readable(from, to, options = T.unsafe(nil)); end

    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/diff.rb#702
    def need_fold?(diff); end

    # source://test-unit//lib/test/unit/diff.rb#716
    def readable(from, to, options = T.unsafe(nil)); end

    # source://test-unit//lib/test/unit/diff.rb#720
    def unified(from, to, options = T.unsafe(nil)); end
  end
end

# source://test-unit//lib/test/unit/diff.rb#263
class Test::Unit::Diff::Differ
  # @return [Differ] a new instance of Differ
  #
  # source://test-unit//lib/test/unit/diff.rb#264
  def initialize(from, to); end

  private

  # source://test-unit//lib/test/unit/diff.rb#270
  def tag(mark, contents); end
end

# source://test-unit//lib/test/unit/diff.rb#412
class Test::Unit::Diff::ReadableDiffer < ::Test::Unit::Diff::Differ
  # source://test-unit//lib/test/unit/diff.rb#413
  def diff(options = T.unsafe(nil)); end

  private

  # source://test-unit//lib/test/unit/diff.rb#528
  def _diff_lines(from_start, from_end, to_start, to_end); end

  # source://test-unit//lib/test/unit/diff.rb#550
  def compute_width(line, start, _end); end

  # source://test-unit//lib/test/unit/diff.rb#446
  def cut_off_ratio; end

  # source://test-unit//lib/test/unit/diff.rb#442
  def default_ratio; end

  # source://test-unit//lib/test/unit/diff.rb#570
  def diff_line(from_line, to_line); end

  # source://test-unit//lib/test/unit/diff.rb#500
  def diff_lines(from_start, from_end, to_start, to_end); end

  # source://test-unit//lib/test/unit/diff.rb#472
  def find_diff_line_info(from_start, from_end, to_start, to_end); end

  # source://test-unit//lib/test/unit/diff.rb#595
  def format_diff_point(from_line, to_line, from_tags, to_tags); end

  # source://test-unit//lib/test/unit/diff.rb#540
  def line_operations(from_line, to_line); end

  # source://test-unit//lib/test/unit/diff.rb#613
  def n_leading_characters(string, character); end

  # source://test-unit//lib/test/unit/diff.rb#433
  def operations; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/diff.rb#621
  def space_character?(character); end

  # source://test-unit//lib/test/unit/diff.rb#450
  def tag(mark, contents); end

  # source://test-unit//lib/test/unit/diff.rb#456
  def tag_deleted(contents); end

  # source://test-unit//lib/test/unit/diff.rb#468
  def tag_difference(contents); end

  # source://test-unit//lib/test/unit/diff.rb#464
  def tag_equal(contents); end

  # source://test-unit//lib/test/unit/diff.rb#460
  def tag_inserted(contents); end
end

# source://test-unit//lib/test/unit/diff.rb#12
class Test::Unit::Diff::SequenceMatcher
  # @return [SequenceMatcher] a new instance of SequenceMatcher
  #
  # source://test-unit//lib/test/unit/diff.rb#13
  def initialize(from, to, &junk_predicate); end

  # source://test-unit//lib/test/unit/diff.rb#34
  def blocks; end

  # source://test-unit//lib/test/unit/diff.rb#42
  def grouped_operations(context_size = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/diff.rb#20
  def longest_match(from_start, from_end, to_start, to_end); end

  # source://test-unit//lib/test/unit/diff.rb#38
  def operations; end

  # source://test-unit//lib/test/unit/diff.rb#69
  def ratio; end

  private

  # source://test-unit//lib/test/unit/diff.rb#117
  def adjust_best_info_with_junk_predicate(should_junk, best_info, from_start, from_end, to_start, to_end); end

  # source://test-unit//lib/test/unit/diff.rb#173
  def compute_blocks; end

  # source://test-unit//lib/test/unit/diff.rb#147
  def compute_matches; end

  # source://test-unit//lib/test/unit/diff.rb#197
  def compute_operations; end

  # source://test-unit//lib/test/unit/diff.rb#219
  def compute_ratio; end

  # source://test-unit//lib/test/unit/diff.rb#229
  def determine_tag(from_index, to_index, match_from_index, match_to_index); end

  # source://test-unit//lib/test/unit/diff.rb#242
  def expand_edge_equal_operations!(_operations, context_size); end

  # source://test-unit//lib/test/unit/diff.rb#97
  def find_best_match_position(from_start, from_end, to_start, to_end); end

  # source://test-unit//lib/test/unit/diff.rb#143
  def matches; end

  # source://test-unit//lib/test/unit/diff.rb#74
  def update_to_indexes; end
end

# source://test-unit//lib/test/unit/diff.rb#275
class Test::Unit::Diff::UTF8Line
  # @return [UTF8Line] a new instance of UTF8Line
  #
  # source://test-unit//lib/test/unit/diff.rb#373
  def initialize(line); end

  # source://test-unit//lib/test/unit/diff.rb#378
  def [](*args); end

  # source://test-unit//lib/test/unit/diff.rb#399
  def compute_width(start, _end); end

  # source://test-unit//lib/test/unit/diff.rb#387
  def each(&block); end

  # source://test-unit//lib/test/unit/diff.rb#391
  def size; end

  # source://test-unit//lib/test/unit/diff.rb#395
  def to_s; end

  class << self
    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/diff.rb#348
    def wide_character?(character); end

    private

    # source://test-unit//lib/test/unit/diff.rb#354
    def binary_search_ranges(character, ranges); end
  end
end

# source://test-unit//lib/test/unit/diff.rb#626
class Test::Unit::Diff::UnifiedDiffer < ::Test::Unit::Diff::Differ
  # source://test-unit//lib/test/unit/diff.rb#627
  def diff(options = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/diff.rb#696
  def define_line?(line); end

  # source://test-unit//lib/test/unit/diff.rb#682
  def find_interesting_line(from_start, to_start, predicate); end

  # source://test-unit//lib/test/unit/diff.rb#666
  def format_summary(operations, show_context); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/diff.rb#657
  def same_content?(groups); end
end

# Encapsulates an error in a test. Created by
# Test::Unit::TestCase when it rescues an exception thrown
# during the processing of a test.
#
# source://test-unit//lib/test/unit/error.rb#15
class Test::Unit::Error
  include ::Test::Unit::Util::BacktraceFilter

  # Creates a new Error with the given test_name and
  # exception.
  #
  # @return [Error] a new instance of Error
  #
  # source://test-unit//lib/test/unit/error.rb#26
  def initialize(test_name, exception, options = T.unsafe(nil)); end

  # Deprecated
  #
  # source://test-unit//lib/test/unit/error.rb#60
  def backtrace; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/error.rb#67
  def critical?; end

  # Returns the value of attribute exception.
  #
  # source://test-unit//lib/test/unit/error.rb#18
  def exception; end

  # source://test-unit//lib/test/unit/error.rb#37
  def label; end

  # source://test-unit//lib/test/unit/error.rb#57
  def location; end

  # Returns a verbose version of the error description.
  #
  # source://test-unit//lib/test/unit/error.rb#52
  def long_display; end

  # Returns the message associated with the error.
  #
  # source://test-unit//lib/test/unit/error.rb#42
  def message; end

  # Returns the value of attribute method_name.
  #
  # source://test-unit//lib/test/unit/error.rb#19
  def method_name; end

  # Returns a brief version of the error description.
  #
  # source://test-unit//lib/test/unit/error.rb#47
  def short_display; end

  # Returns a single character representation of an error.
  #
  # source://test-unit//lib/test/unit/error.rb#33
  def single_character_display; end

  # Returns the value of attribute test_name.
  #
  # source://test-unit//lib/test/unit/error.rb#18
  def test_name; end

  # Overridden to return long_display.
  #
  # source://test-unit//lib/test/unit/error.rb#63
  def to_s; end
end

# source://test-unit//lib/test/unit/error.rb#22
Test::Unit::Error::LABEL = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/error.rb#21
Test::Unit::Error::SINGLE_CHARACTER = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/error.rb#72
module Test::Unit::ErrorHandler
  private

  # source://test-unit//lib/test/unit/error.rb#119
  def add_error(exception); end

  # source://test-unit//lib/test/unit/error.rb#89
  def handle_all_exception(exception); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/error.rb#97
  def pass_through_exception?(exception); end

  class << self
    # @private
    #
    # source://test-unit//lib/test/unit/error.rb#74
    def included(base); end
  end
end

# source://test-unit//lib/test/unit/error.rb#79
Test::Unit::ErrorHandler::NOT_PASS_THROUGH_EXCEPTIONS = T.let(T.unsafe(nil), Array)

# source://test-unit//lib/test/unit/error.rb#80
Test::Unit::ErrorHandler::NOT_PASS_THROUGH_EXCEPTION_NAMES = T.let(T.unsafe(nil), Array)

# source://test-unit//lib/test/unit/error.rb#81
Test::Unit::ErrorHandler::PASS_THROUGH_EXCEPTIONS = T.let(T.unsafe(nil), Array)

# source://test-unit//lib/test/unit/error.rb#87
Test::Unit::ErrorHandler::PASS_THROUGH_EXCEPTION_NAMES = T.let(T.unsafe(nil), Array)

# source://test-unit//lib/test/unit/exception-handler.rb#3
module Test::Unit::ExceptionHandler
  mixes_in_class_methods ::Test::Unit::ExceptionHandler::ClassMethods

  class << self
    # source://test-unit//lib/test/unit/exception-handler.rb#6
    def exception_handlers; end

    # @private
    #
    # source://test-unit//lib/test/unit/exception-handler.rb#10
    def included(base); end
  end
end

# source://test-unit//lib/test/unit/exception-handler.rb#24
module Test::Unit::ExceptionHandler::ClassMethods
  # This is a public API for developers who extend test-unit.
  #
  # @overload exception_handler
  # @overload exception_handler
  #
  # source://test-unit//lib/test/unit/exception-handler.rb#52
  def exception_handler(*method_name_or_handlers, &block); end

  # source://test-unit//lib/test/unit/exception-handler.rb#25
  def exception_handlers; end

  # source://test-unit//lib/test/unit/exception-handler.rb#68
  def unregister_exception_handler(*method_name_or_handlers); end
end

# Encapsulates a test failure. Created by Test::Unit::TestCase
# when an assertion fails.
#
# source://test-unit//lib/test/unit/failure.rb#12
class Test::Unit::Failure
  # Creates a new Failure with the given location and
  # message.
  #
  # @return [Failure] a new instance of Failure
  #
  # source://test-unit//lib/test/unit/failure.rb#23
  def initialize(test_name, location, message, options = T.unsafe(nil)); end

  # Returns the value of attribute actual.
  #
  # source://test-unit//lib/test/unit/failure.rb#15
  def actual; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/failure.rb#65
  def critical?; end

  # source://test-unit//lib/test/unit/failure.rb#69
  def diff; end

  # Returns the value of attribute expected.
  #
  # source://test-unit//lib/test/unit/failure.rb#15
  def expected; end

  # Returns the value of attribute inspected_actual.
  #
  # source://test-unit//lib/test/unit/failure.rb#16
  def inspected_actual; end

  # Returns the value of attribute inspected_expected.
  #
  # source://test-unit//lib/test/unit/failure.rb#16
  def inspected_expected; end

  # source://test-unit//lib/test/unit/failure.rb#41
  def label; end

  # Returns the value of attribute location.
  #
  # source://test-unit//lib/test/unit/failure.rb#13
  def location; end

  # Returns a verbose version of the error description.
  #
  # source://test-unit//lib/test/unit/failure.rb#51
  def long_display; end

  # Returns the value of attribute message.
  #
  # source://test-unit//lib/test/unit/failure.rb#13
  def message; end

  # Returns the value of attribute method_name.
  #
  # source://test-unit//lib/test/unit/failure.rb#14
  def method_name; end

  # Returns a brief version of the error description.
  #
  # source://test-unit//lib/test/unit/failure.rb#46
  def short_display; end

  # Returns a single character representation of a failure.
  #
  # source://test-unit//lib/test/unit/failure.rb#37
  def single_character_display; end

  # Returns the value of attribute source_location.
  #
  # source://test-unit//lib/test/unit/failure.rb#14
  def source_location; end

  # Returns the value of attribute test_name.
  #
  # source://test-unit//lib/test/unit/failure.rb#13
  def test_name; end

  # Overridden to return long_display.
  #
  # source://test-unit//lib/test/unit/failure.rb#61
  def to_s; end

  # Returns the value of attribute user_message.
  #
  # source://test-unit//lib/test/unit/failure.rb#15
  def user_message; end

  private

  # source://test-unit//lib/test/unit/failure.rb#74
  def compute_diff; end
end

# source://test-unit//lib/test/unit/failure.rb#19
Test::Unit::Failure::LABEL = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/failure.rb#18
Test::Unit::Failure::SINGLE_CHARACTER = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/failure.rb#79
module Test::Unit::FailureHandler
  # Report a failure.
  #
  # This is a public API for developers who extend test-unit.
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param backtrace [Array<String>] The backtrace for the failure.
  # @param message [String] The description about the failure.
  # @param options [Hash] a customizable set of options
  # @return [void]
  #
  # source://test-unit//lib/test/unit/failure.rb#112
  def add_failure(message, backtrace, options = T.unsafe(nil)); end

  private

  # source://test-unit//lib/test/unit/failure.rb#123
  def handle_assertion_failed_error(exception); end

  class << self
    # @private
    #
    # source://test-unit//lib/test/unit/failure.rb#81
    def included(base); end
  end
end

# source://test-unit//lib/test/unit/fault-location-detector.rb#9
class Test::Unit::FaultLocationDetector
  # @return [FaultLocationDetector] a new instance of FaultLocationDetector
  #
  # source://test-unit//lib/test/unit/fault-location-detector.rb#10
  def initialize(fault, code_snippet_fetcher); end

  # source://test-unit//lib/test/unit/fault-location-detector.rb#16
  def split_backtrace_entry(entry); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/fault-location-detector.rb#32
  def target?(backtrace_entry); end

  private

  # source://test-unit//lib/test/unit/fault-location-detector.rb#89
  def extract_fault_information; end

  # source://test-unit//lib/test/unit/fault-location-detector.rb#81
  def guess_indent_level(line); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/fault-location-detector.rb#73
  def target_method?(method_name); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/fault-location-detector.rb#48
  def target_source_location?(file, line_number, method_name); end
end

# source://test-unit//lib/test/unit/fixture.rb#3
module Test::Unit::Fixture
  mixes_in_class_methods ::Test::Unit::Fixture::ClassMethods

  private

  # source://test-unit//lib/test/unit/fixture.rb#265
  def create_fixtures_runner(fixtures, options, &block); end

  # source://test-unit//lib/test/unit/fixture.rb#295
  def run_cleanup; end

  # source://test-unit//lib/test/unit/fixture.rb#249
  def run_fixture(type, options = T.unsafe(nil), &block); end

  # source://test-unit//lib/test/unit/fixture.rb#281
  def run_fixture_callback(method_name, options, &block); end

  # source://test-unit//lib/test/unit/fixture.rb#291
  def run_setup(&block); end

  # source://test-unit//lib/test/unit/fixture.rb#299
  def run_teardown; end

  class << self
    # @private
    #
    # source://test-unit//lib/test/unit/fixture.rb#5
    def included(base); end
  end
end

# source://test-unit//lib/test/unit/fixture.rb#205
module Test::Unit::Fixture::ClassMethods
  # source://test-unit//lib/test/unit/fixture.rb#218
  def cleanup(*method_names, &callback); end

  # source://test-unit//lib/test/unit/fixture.rb#206
  def fixture; end

  # source://test-unit//lib/test/unit/fixture.rb#210
  def setup(*method_names, &callback); end

  # source://test-unit//lib/test/unit/fixture.rb#226
  def teardown(*method_names, &callback); end

  # source://test-unit//lib/test/unit/fixture.rb#222
  def unregister_cleanup(*method_names_or_callbacks); end

  # source://test-unit//lib/test/unit/fixture.rb#214
  def unregister_setup(*method_names_or_callbacks); end

  # source://test-unit//lib/test/unit/fixture.rb#230
  def unregister_teardown(*method_names_or_callbacks); end

  private

  # source://test-unit//lib/test/unit/fixture.rb#235
  def register_fixture(fixture, *method_names, &callback); end

  # source://test-unit//lib/test/unit/fixture.rb#243
  def unregister_fixture(fixture, *method_names_or_callbacks); end
end

# source://test-unit//lib/test/unit/fixture.rb#21
class Test::Unit::Fixture::Fixture
  # @return [Fixture] a new instance of Fixture
  #
  # source://test-unit//lib/test/unit/fixture.rb#25
  def initialize(test_case); end

  # source://test-unit//lib/test/unit/fixture.rb#34
  def [](type); end

  # source://test-unit//lib/test/unit/fixture.rb#49
  def after_callbacks(type); end

  # source://test-unit//lib/test/unit/fixture.rb#45
  def before_callbacks(type); end

  # Returns the value of attribute cleanup.
  #
  # source://test-unit//lib/test/unit/fixture.rb#23
  def cleanup; end

  # Returns the value of attribute setup.
  #
  # source://test-unit//lib/test/unit/fixture.rb#22
  def setup; end

  # Returns the value of attribute teardown.
  #
  # source://test-unit//lib/test/unit/fixture.rb#24
  def teardown; end

  private

  # source://test-unit//lib/test/unit/fixture.rb#69
  def collect_after_callbacks(type); end

  # source://test-unit//lib/test/unit/fixture.rb#58
  def collect_before_callbacks(type); end

  # source://test-unit//lib/test/unit/fixture.rb#80
  def collect_target_test_cases; end

  # source://test-unit//lib/test/unit/fixture.rb#89
  def merge_callbacks(prepend_callbacks, append_callbacks); end

  # source://test-unit//lib/test/unit/fixture.rb#54
  def target_test_cases; end
end

# source://test-unit//lib/test/unit/fixture.rb#101
class Test::Unit::Fixture::HookPoint
  # @return [HookPoint] a new instance of HookPoint
  #
  # source://test-unit//lib/test/unit/fixture.rb#102
  def initialize(test_case, type, default_options); end

  # source://test-unit//lib/test/unit/fixture.rb#168
  def after_append_callbacks; end

  # source://test-unit//lib/test/unit/fixture.rb#164
  def after_prepend_callbacks; end

  # source://test-unit//lib/test/unit/fixture.rb#160
  def before_append_callbacks; end

  # source://test-unit//lib/test/unit/fixture.rb#156
  def before_prepend_callbacks; end

  # source://test-unit//lib/test/unit/fixture.rb#114
  def register(method_name_or_callback, options = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/fixture.rb#146
  def unregister(method_name_or_callback); end

  private

  # source://test-unit//lib/test/unit/fixture.rb#186
  def add_callback(method_name_or_callback, before_how, after_how); end

  # source://test-unit//lib/test/unit/fixture.rb#182
  def callback_method_name(callback); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/fixture.rb#173
  def valid_register_options?(options); end
end

# source://test-unit//lib/test/unit/color.rb#109
class Test::Unit::MixColor
  # @return [MixColor] a new instance of MixColor
  #
  # source://test-unit//lib/test/unit/color.rb#111
  def initialize(colors); end

  # source://test-unit//lib/test/unit/color.rb#125
  def +(other); end

  # source://test-unit//lib/test/unit/color.rb#129
  def ==(other); end

  # Returns the value of attribute colors.
  #
  # source://test-unit//lib/test/unit/color.rb#110
  def colors; end

  # source://test-unit//lib/test/unit/color.rb#121
  def escape_sequence; end

  # source://test-unit//lib/test/unit/color.rb#115
  def sequence; end
end

# source://test-unit//lib/test/unit/notification.rb#5
class Test::Unit::Notification
  include ::Test::Unit::Util::BacktraceFilter

  # Creates a new Notification with the given location and
  # message.
  #
  # @return [Notification] a new instance of Notification
  #
  # source://test-unit//lib/test/unit/notification.rb#15
  def initialize(test_name, location, message, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/notification.rb#47
  def critical?; end

  # source://test-unit//lib/test/unit/notification.rb#27
  def label; end

  # Returns the value of attribute location.
  #
  # source://test-unit//lib/test/unit/notification.rb#7
  def location; end

  # Returns a verbose version of the error description.
  #
  # source://test-unit//lib/test/unit/notification.rb#37
  def long_display; end

  # Returns the value of attribute message.
  #
  # source://test-unit//lib/test/unit/notification.rb#7
  def message; end

  # Returns the value of attribute method_name.
  #
  # source://test-unit//lib/test/unit/notification.rb#8
  def method_name; end

  # Returns a brief version of the error description.
  #
  # source://test-unit//lib/test/unit/notification.rb#32
  def short_display; end

  # Returns a single character representation of a notification.
  #
  # source://test-unit//lib/test/unit/notification.rb#23
  def single_character_display; end

  # Returns the value of attribute test_name.
  #
  # source://test-unit//lib/test/unit/notification.rb#7
  def test_name; end

  # Overridden to return long_display.
  #
  # source://test-unit//lib/test/unit/notification.rb#43
  def to_s; end
end

# source://test-unit//lib/test/unit/notification.rb#11
Test::Unit::Notification::LABEL = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/notification.rb#10
Test::Unit::Notification::SINGLE_CHARACTER = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/notification.rb#92
module Test::Unit::NotificationHandler
  private

  # source://test-unit//lib/test/unit/notification.rb#100
  def handle_notified_error(exception); end

  class << self
    # @private
    #
    # source://test-unit//lib/test/unit/notification.rb#94
    def included(base); end
  end
end

# source://test-unit//lib/test/unit/notification.rb#52
class Test::Unit::NotifiedError < ::StandardError; end

# source://test-unit//lib/test/unit/testresult.rb#15
module Test::Unit::NullResultContainerInitializer
  private

  # source://test-unit//lib/test/unit/testresult.rb#17
  def initialize_containers; end
end

# source://test-unit//lib/test/unit/omission.rb#5
class Test::Unit::Omission
  include ::Test::Unit::Util::BacktraceFilter

  # Creates a new Omission with the given location and
  # message.
  #
  # @return [Omission] a new instance of Omission
  #
  # source://test-unit//lib/test/unit/omission.rb#15
  def initialize(test_name, location, message, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/omission.rb#47
  def critical?; end

  # source://test-unit//lib/test/unit/omission.rb#27
  def label; end

  # Returns the value of attribute location.
  #
  # source://test-unit//lib/test/unit/omission.rb#7
  def location; end

  # Returns a verbose version of the error description.
  #
  # source://test-unit//lib/test/unit/omission.rb#37
  def long_display; end

  # Returns the value of attribute message.
  #
  # source://test-unit//lib/test/unit/omission.rb#7
  def message; end

  # Returns the value of attribute method_name.
  #
  # source://test-unit//lib/test/unit/omission.rb#8
  def method_name; end

  # Returns a brief version of the error description.
  #
  # source://test-unit//lib/test/unit/omission.rb#32
  def short_display; end

  # Returns a single character representation of a omission.
  #
  # source://test-unit//lib/test/unit/omission.rb#23
  def single_character_display; end

  # Returns the value of attribute test_name.
  #
  # source://test-unit//lib/test/unit/omission.rb#7
  def test_name; end

  # Overridden to return long_display.
  #
  # source://test-unit//lib/test/unit/omission.rb#43
  def to_s; end
end

# source://test-unit//lib/test/unit/omission.rb#11
Test::Unit::Omission::LABEL = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/omission.rb#10
Test::Unit::Omission::SINGLE_CHARACTER = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/omission.rb#151
module Test::Unit::OmissionHandler
  private

  # source://test-unit//lib/test/unit/omission.rb#159
  def handle_omitted_error(exception); end

  class << self
    # @private
    #
    # source://test-unit//lib/test/unit/omission.rb#153
    def included(base); end
  end
end

# source://test-unit//lib/test/unit/omission.rb#52
class Test::Unit::OmittedError < ::StandardError; end

# source://test-unit//lib/test/unit/pending.rb#52
class Test::Unit::PendedError < ::StandardError; end

# source://test-unit//lib/test/unit/pending.rb#5
class Test::Unit::Pending
  include ::Test::Unit::Util::BacktraceFilter

  # Creates a new Pending with the given location and
  # message.
  #
  # @return [Pending] a new instance of Pending
  #
  # source://test-unit//lib/test/unit/pending.rb#15
  def initialize(test_name, location, message, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/pending.rb#47
  def critical?; end

  # source://test-unit//lib/test/unit/pending.rb#27
  def label; end

  # Returns the value of attribute location.
  #
  # source://test-unit//lib/test/unit/pending.rb#7
  def location; end

  # Returns a verbose version of the error description.
  #
  # source://test-unit//lib/test/unit/pending.rb#37
  def long_display; end

  # Returns the value of attribute message.
  #
  # source://test-unit//lib/test/unit/pending.rb#7
  def message; end

  # Returns the value of attribute method_name.
  #
  # source://test-unit//lib/test/unit/pending.rb#8
  def method_name; end

  # Returns a brief version of the error description.
  #
  # source://test-unit//lib/test/unit/pending.rb#32
  def short_display; end

  # Returns a single character representation of a pending.
  #
  # source://test-unit//lib/test/unit/pending.rb#23
  def single_character_display; end

  # Returns the value of attribute test_name.
  #
  # source://test-unit//lib/test/unit/pending.rb#7
  def test_name; end

  # Overridden to return long_display.
  #
  # source://test-unit//lib/test/unit/pending.rb#43
  def to_s; end
end

# source://test-unit//lib/test/unit/pending.rb#11
Test::Unit::Pending::LABEL = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/pending.rb#10
Test::Unit::Pending::SINGLE_CHARACTER = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/pending.rb#108
module Test::Unit::PendingHandler
  private

  # source://test-unit//lib/test/unit/pending.rb#116
  def handle_pended_error(exception); end

  class << self
    # @private
    #
    # source://test-unit//lib/test/unit/pending.rb#110
    def included(base); end
  end
end

# source://test-unit//lib/test/unit/priority.rb#3
module Test::Unit::Priority
  mixes_in_class_methods ::Test::Unit::Priority::ClassMethods

  # source://test-unit//lib/test/unit/priority.rb#183
  def priority_setup(&_); end

  # source://test-unit//lib/test/unit/priority.rb#188
  def priority_teardown; end

  class << self
    # source://test-unit//lib/test/unit/priority.rb#38
    def available_values; end

    # source://test-unit//lib/test/unit/priority.rb#30
    def default; end

    # source://test-unit//lib/test/unit/priority.rb#34
    def default=(default); end

    # source://test-unit//lib/test/unit/priority.rb#25
    def disable; end

    # source://test-unit//lib/test/unit/priority.rb#19
    def enable; end

    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/priority.rb#15
    def enabled?; end

    # @private
    #
    # source://test-unit//lib/test/unit/priority.rb#5
    def included(base); end
  end
end

# source://test-unit//lib/test/unit/priority.rb#43
class Test::Unit::Priority::Checker
  # @return [Checker] a new instance of Checker
  #
  # source://test-unit//lib/test/unit/priority.rb#97
  def initialize(test); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/priority.rb#113
  def need_to_run?; end

  # source://test-unit//lib/test/unit/priority.rb#101
  def setup; end

  # source://test-unit//lib/test/unit/priority.rb#105
  def teardown; end

  # Returns the value of attribute test.
  #
  # source://test-unit//lib/test/unit/priority.rb#96
  def test; end

  private

  # source://test-unit//lib/test/unit/priority.rb#148
  def escape_class_name(class_name); end

  # source://test-unit//lib/test/unit/priority.rb#156
  def escape_name(name); end

  # source://test-unit//lib/test/unit/priority.rb#152
  def escaped_method_name; end

  # source://test-unit//lib/test/unit/priority.rb#144
  def passed_file; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/priority.rb#118
  def previous_test_success?; end

  # @raise [Errno::EACCES]
  #
  # source://test-unit//lib/test/unit/priority.rb#122
  def result_dir; end

  class << self
    # source://test-unit//lib/test/unit/priority.rb#59
    def available_priorities; end

    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/priority.rb#45
    def have_priority?(name); end

    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/priority.rb#50
    def need_to_run?(test); end

    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/priority.rb#74
    def run_priority_high?(test); end

    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/priority.rb#70
    def run_priority_important?(test); end

    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/priority.rb#82
    def run_priority_low?(test); end

    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/priority.rb#66
    def run_priority_must?(test); end

    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/priority.rb#86
    def run_priority_never?(test); end

    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/priority.rb#78
    def run_priority_normal?(test); end

    private

    # source://test-unit//lib/test/unit/priority.rb#91
    def priority_check_method_name(priority_name); end
  end
end

# source://test-unit//lib/test/unit/priority.rb#174
module Test::Unit::Priority::ClassMethods
  # source://test-unit//lib/test/unit/priority.rb#175
  def priority(name, *tests); end
end

# source://test-unit//lib/test/unit/sub-test-result.rb#9
class Test::Unit::SubTestResult
  # @return [SubTestResult] a new instance of SubTestResult
  #
  # source://test-unit//lib/test/unit/sub-test-result.rb#12
  def initialize(parent_test_result); end

  # Records an individual assertion.
  #
  # source://test-unit//lib/test/unit/sub-test-result.rb#26
  def add_assertion; end

  # source://test-unit//lib/test/unit/sub-test-result.rb#30
  def add_error(error); end

  # source://test-unit//lib/test/unit/sub-test-result.rb#34
  def add_failure(failure); end

  # source://test-unit//lib/test/unit/sub-test-result.rb#46
  def add_notification(notification); end

  # source://test-unit//lib/test/unit/sub-test-result.rb#42
  def add_omission(omission); end

  # source://test-unit//lib/test/unit/sub-test-result.rb#21
  def add_pass; end

  # source://test-unit//lib/test/unit/sub-test-result.rb#38
  def add_pending(pending); end

  # source://test-unit//lib/test/unit/sub-test-result.rb#17
  def add_run(result = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/sub-test-result.rb#50
  def passed?; end

  # source://test-unit//lib/test/unit/sub-test-result.rb#54
  def stop; end

  # Returns the value of attribute stop_tag.
  #
  # source://test-unit//lib/test/unit/sub-test-result.rb#10
  def stop_tag; end

  # Sets the attribute stop_tag
  #
  # @param value the value to set the attribute stop_tag to.
  #
  # source://test-unit//lib/test/unit/sub-test-result.rb#10
  def stop_tag=(_arg0); end
end

# Ties everything together. If you subclass and add your own
# test methods, it takes care of making them into tests and
# wrapping those tests into a suite. It also does the
# nitty-gritty of actually running an individual test and
# collecting its results into a Test::Unit::TestResult object.
#
# You can run two hooks before/after a TestCase run.
#
# Example:
#
#     class TestMyClass < Test::Unit::TestCase
#       class << self
#         def startup
#           ...
#         end
#
#         def shutdown
#           ...
#         end
#       end
#
#       def setup
#         ...
#       end
#
#       def cleanup
#         ...
#       end
#
#       def teardown
#         ...
#       end
#
#       def test_my_method1
#         ...
#       end
#
#       def test_my_method2
#         ...
#       end
#     end
#
# Here is a call order:
#
# 1. startup
# 1. setup
# 1. test_my_method1
# 1. cleanup
# 1. teardown
# 1. setup
# 1. test_my_method2
# 1. cleanup
# 1. teardown
# 1. shutdown
#
# You can set an attribute to each test.
#
# Example:
#
#     class TestMyClass < Test::Unit::TestCase
#       attribute :speed, :fast
#       def test_my_fast_method
#         # You can get the attribute via `self[]`
#         self[:speed] # => :fast
#         ...
#       end
#
#       attribute :speed, :slow
#       def test_my_slow_method
#         self[:speed] # => :slow
#         ...
#       end
#     end
#
# source://test-unit//lib/test/unit/testcase.rb#104
class Test::Unit::TestCase
  include ::Test::Unit::Attribute
  include ::Test::Unit::Fixture
  include ::Test::Unit::ExceptionHandler
  include ::Test::Unit::ErrorHandler
  include ::Test::Unit::FailureHandler
  include ::Test::Unit::TestCasePendingSupport
  include ::Test::Unit::PendingHandler
  include ::Test::Unit::TestCaseOmissionSupport
  include ::Test::Unit::OmissionHandler
  include ::Test::Unit::TestCaseNotificationSupport
  include ::Test::Unit::NotificationHandler
  include ::Test::Unit::Priority
  include ::Test::Unit::Data
  include ::Test::Unit::Assertions
  include ::Test::Unit::Util::BacktraceFilter
  include ::Test::Unit::Util::Output
  extend ::Test::Unit::Attribute::BaseClassMethods
  extend ::Test::Unit::Attribute::ClassMethods
  extend ::Test::Unit::Fixture::ClassMethods
  extend ::Test::Unit::ExceptionHandler::ClassMethods
  extend ::Test::Unit::Priority::ClassMethods
  extend ::Test::Unit::Data::ClassMethods

  # Creates a new instance of the fixture for running the
  # test represented by test_method_name.
  #
  # @return [TestCase] a new instance of TestCase
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def initialize(test_method_name); end

  # It's handy to be able to compare TestCase instances.
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def ==(other); end

  # Notify that the test is passed. Normally, it is not needed
  # because #run calls it automatically. If you want to override
  # #run, it is not a good idea. Please contact test-unit
  # developers. We will help you without your custom #run. For
  # example, we may add a new hook in #run.
  #
  # This is a public API for developers who extend test-unit.
  #
  # @return [void]
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def add_pass; end

  # Assigns test data to the test. It is used in internal.
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def assign_test_data(label, data); end

  # Called after every test method runs but the test
  # method isn't marked as 'passed'. Can be used to
  # clean up and/or verify tested condition.
  # e.g. Can be used to verify mock.
  #
  # You can add additional cleanup tasks by the following
  # code:
  #
  #     class TestMyClass < Test::Unit::TestCase
  #       def cleanup
  #         ...
  #       end
  #
  #       cleanup
  #       def my_cleanup1
  #         ...
  #       end
  #
  #       cleanup do
  #         ... # cleanup callback1
  #       end
  #
  #       cleanup
  #       def my_cleanup2
  #         ...
  #       end
  #
  #       cleanup do
  #         ... # cleanup callback2
  #       end
  #
  #       def test_my_class
  #         ...
  #       end
  #     end
  #
  # Here is a call order:
  #
  # * test_my_class
  # * cleanup callback2
  # * my_cleanup2
  # * cleanup callback1
  # * my_cleanup1
  # * cleanup
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def cleanup; end

  # Returns test data for the test. If the test isn't associated
  # with any test data, it returns `nil`.
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def data; end

  # Returns a label of test data for the test. If the
  # test isn't associated with any test data, it returns
  # `nil`.
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def data_label; end

  # source://test-unit//lib/test/unit/testcase.rb#170
  def default_test; end

  # Returns a description for the test. A description
  # will be associated by Test::Unit::TestCase.test or
  # Test::Unit::TestCase.description.
  #
  # Returns a name for the test for no description test.
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def description; end

  # Returns elapsed time for the test was ran.
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def elapsed_time; end

  # Returns whether the test is interrupted.
  #
  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def interrupted?; end

  # Returns a human-readable name for the specific test that this
  # instance of TestCase represents.
  #
  # `#local_name` doesn't include class name. `#name` includes
  # class name.
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def local_name; end

  # Returns the value of attribute method_name.
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def method_name; end

  # Returns a human-readable name for the specific test that
  # this instance of TestCase represents.
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def name; end

  # Returns whether this individual test passed or
  # not. Primarily for use in teardown so that artifacts
  # can be left behind if the test fails.
  #
  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def passed?; end

  # Notify that a problem is occurred in the test. It means that
  # the test is a failed test. If any failed tests exist in test
  # suites, the test process exits with failure exit status.
  #
  # This is a public API for developers who extend test-unit.
  #
  # @return [void]
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def problem_occurred; end

  # Runs the individual test method represented by this
  # instance of the fixture, collecting statistics, failures
  # and errors in result.
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def run(result, run_context: T.unsafe(nil)); end

  # Returns test suite runner class for easy to test.
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def runner_class; end

  # Called before every test method runs. Can be used
  # to set up fixture information.
  #
  # You can add additional setup tasks by the following
  # code:
  #
  #     class TestMyClass < Test::Unit::TestCase
  #       def setup
  #         ...
  #       end
  #
  #       setup
  #       def my_setup1
  #         ...
  #       end
  #
  #       setup do
  #         ... # setup callback1
  #       end
  #
  #       setup
  #       def my_setup2
  #         ...
  #       end
  #
  #       setup do
  #         ... # setup callback2
  #       end
  #
  #       def test_my_class
  #         ...
  #       end
  #     end
  #
  # Here is a call order:
  #
  # * setup
  # * my_setup1
  # * setup callback1
  # * my_setup2
  # * setup callback2
  # * test_my_class
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def setup; end

  # source://test-unit//lib/test/unit/testcase.rb#170
  def size; end

  # Returns a Time at the test was started.
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def start_time; end

  # Called after every test method runs. Can be used to tear
  # down fixture information.
  #
  # You can add additional teardown tasks by the following
  # code:
  #
  #     class TestMyClass < Test::Unit::TestCase
  #       def teardown
  #         ...
  #       end
  #
  #       teardown
  #       def my_teardown1
  #         ...
  #       end
  #
  #       teardown do
  #         ... # teardown callback1
  #       end
  #
  #       teardown
  #       def my_teardown2
  #         ...
  #       end
  #
  #       teardown do
  #         ... # teardown callback2
  #       end
  #
  #       def test_my_class
  #         ...
  #       end
  #     end
  #
  # Here is a call order:
  #
  # * test_my_class
  # * teardown callback2
  # * my_teardown2
  # * teardown callback1
  # * my_teardown1
  # * teardown
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def teardown; end

  # Overridden to return #name.
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def to_s; end

  # Returns the test is valid test. It is used in internal.
  #
  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/testcase.rb#170
  def valid?; end

  private

  # source://test-unit//lib/test/unit/testcase.rb#170
  def add_assertion; end

  # source://test-unit//lib/test/unit/testcase.rb#170
  def current_result; end

  # source://test-unit//lib/test/unit/testcase.rb#170
  def handle_exception(exception); end

  # source://test-unit//lib/test/unit/testcase.rb#170
  def run_test; end

  class << self
    # source://test-unit//lib/test/unit/testcase.rb#198
    def added_method_names; end

    # Describes a test.
    #
    # The following example associates "register a
    # normal user" description with "test_register"
    # test.
    #
    #     description "register a normal user"
    #     def test_register
    #       ...
    #     end
    #
    # source://test-unit//lib/test/unit/testcase.rb#374
    def description(value, target = T.unsafe(nil)); end

    # source://test-unit//lib/test/unit/testcase.rb#474
    def find_locations(query); end

    # source://test-unit//lib/test/unit/testcase.rb#158
    def include(*modules, &block); end

    # source://test-unit//lib/test/unit/testcase.rb#153
    def inherited(sub_class); end

    # source://test-unit//lib/test/unit/testcase.rb#169
    def method_added(name); end

    # Indicates whether the test is parallel safe.
    #
    # Tests that this method returns `false` are executed sequentially
    # before parallel safe tests run. This only works when the `--parallel`
    # option is specified.
    #
    # @example Indicates that test_parallel_unsafe is parallel unsafe
    #
    #   class TestMyClass < Test::Unit::TestCase
    #   class << self
    #   def parallel_safe?
    #   false
    #   end
    #   end
    #
    #   def test_parallel_unsafe
    #   # ...
    #   end
    #   end
    # @return [Boolean]
    # @since 3.6.3
    #
    # source://test-unit//lib/test/unit/testcase.rb#149
    def parallel_safe?; end

    # Declares that the following test uses Ractor.
    #
    # Tests that use Ractor are executed at the end. Because multi
    # Ractor mode is enabled in the current process and it's not
    # disabled even when only one Ractor is running after running
    # a test that uses Ractor on Ruby 3.0. It will be solved in
    # the future.
    #
    # This is implemented by setting the `:ractor` attribute of
    # the test to `true`.
    #
    # @example Declares that test_do_something_with_ractor uses Ractor
    #
    #   ractor
    #   def test_do_something_with_ractor
    #   Ractor.new do
    #   # ...
    #   end
    #   end
    # @example Declares that test_do_something_with_ractor uses Ractor in one line
    #
    #   ractor def test_do_something_with_ractor
    #   Ractor.new do
    #   # ...
    #   end
    #   end
    # @param options [Hash] See {Attribute::ClassMethods#attribute}
    #   for details.
    # @return [void]
    # @since 3.4.6
    #
    # source://test-unit//lib/test/unit/testcase.rb#413
    def ractor(options = T.unsafe(nil)); end

    # Called after every test case runs. Can be used to tear
    # down fixture information used in test case scope.
    #
    # Here is an example test case:
    #
    #     class TestMyClass < Test::Unit::TestCase
    #       class << self
    #         def shutdown
    #           ...
    #         end
    #       end
    #
    #       def teardown
    #         ...
    #       end
    #
    #       def test_my_class1
    #         ...
    #       end
    #
    #       def test_my_class2
    #         ...
    #       end
    #     end
    #
    # Here is a call order:
    #
    # * test_my_class1 (or test_my_class2)
    # * teardown
    # * test_my_class2 (or test_my_class1)
    # * teardown
    # * shutdown
    #
    # Note that you should not assume test order. Tests
    # should be worked in any order.
    #
    # source://test-unit//lib/test/unit/testcase.rb#284
    def shutdown; end

    # Called before every test case runs. Can be used
    # to set up fixture information used in test case
    # scope.
    #
    # Here is an example test case:
    #
    #     class TestMyClass < Test::Unit::TestCase
    #       class << self
    #         def startup
    #           ...
    #         end
    #       end
    #
    #       def setup
    #         ...
    #       end
    #
    #       def test_my_class1
    #         ...
    #       end
    #
    #       def test_my_class2
    #         ...
    #       end
    #     end
    #
    # Here is a call order:
    #
    # * startup
    # * setup
    # * test_my_class1 (or test_my_class2)
    # * setup
    # * test_my_class2 (or test_my_class1)
    #
    # Note that you should not assume test order. Tests
    # should be worked in any order.
    #
    # source://test-unit//lib/test/unit/testcase.rb#246
    def startup; end

    # Defines a sub test case.
    #
    # This is a syntax sugar. The both of the following codes are
    # the same in meaning:
    #
    # Standard:
    #
    #     class TestParent < Test::Unit::TestCase
    #       class TestChild < self
    #         def test_in_child
    #         end
    #       end
    #     end
    #
    # Syntax sugar:
    #
    #     class TestParent < Test::Unit::TestCase
    #       sub_test_case("TestChild") do
    #         def test_in_child
    #         end
    #       end
    #     end
    #
    # The difference of them are the following:
    #
    # * Test case created by {sub_test_case} is an anonymous class.
    #   So you can't refer the test case by name.
    # * The class name of class style must follow
    #   constant naming rule in Ruby. But the name of test case
    #   created by {sub_test_case} doesn't need to follow the rule.
    #   For example, you can use a space in name such as "child test".
    #
    # @param name [String] The name of newly created sub test case.
    # @return [Test::Unit::TestCase] Created sub test case class.
    # @yield The block is evaluated under the newly created sub test
    #   case class context.
    #
    # source://test-unit//lib/test/unit/testcase.rb#454
    def sub_test_case(name, &block); end

    # Rolls up all of the test* methods in the fixture into
    # one suite, creating a new instance of the fixture for
    # each method.
    #
    # source://test-unit//lib/test/unit/testcase.rb#205
    def suite; end

    # Defines a test in declarative syntax or marks
    # following method as a test method.
    #
    # In declarative syntax usage, the following two
    # test definitions are the almost same:
    #
    #     description "register user"
    #     def test_register_user
    #       ...
    #     end
    #
    #     test "register user" do
    #       ...
    #     end
    #
    # In test method mark usage, the "my_test_method" is
    # treated as a test method:
    #
    #     test
    #     def my_test_method
    #       assert_equal("call me", ...)
    #     end
    #
    # source://test-unit//lib/test/unit/testcase.rb#337
    def test(*test_description_or_targets, &block); end

    # Checks whether a test that is matched the query is
    # defined.
    #
    # @option query
    # @option query
    # @option query
    # @param query [Hash] a customizable set of options
    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/testcase.rb#469
    def test_defined?(query); end

    # Returns the current test order. This returns
    # `:alphabetic` by default.
    #
    # source://test-unit//lib/test/unit/testcase.rb#291
    def test_order; end

    # Sets the current test order.
    #
    # Here are the available _order_:
    #
    # :alphabetic
    #
    # :random
    #
    # :defined
    #
    # source://test-unit//lib/test/unit/testcase.rb#311
    def test_order=(order); end

    private

    # @private
    #
    # source://test-unit//lib/test/unit/testcase.rb#515
    def add_method_location(location); end

    # @private
    #
    # source://test-unit//lib/test/unit/testcase.rb#510
    def method_locations; end

    # @private
    #
    # source://test-unit//lib/test/unit/testcase.rb#546
    def sub_test_case_class(name); end

    # @private
    #
    # source://test-unit//lib/test/unit/testcase.rb#522
    def target_method_locations(path); end
  end
end

# source://test-unit//lib/test/unit/testcase.rb#125
Test::Unit::TestCase::AVAILABLE_ORDERS = T.let(T.unsafe(nil), Array)

# source://test-unit//lib/test/unit/testcase.rb#124
Test::Unit::TestCase::DESCENDANTS = T.let(T.unsafe(nil), Array)

# source://test-unit//lib/test/unit/testcase.rb#120
Test::Unit::TestCase::FINISHED = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/testcase.rb#122
Test::Unit::TestCase::FINISHED_OBJECT = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/testcase.rb#934
class Test::Unit::TestCase::InternalData
  # @return [InternalData] a new instance of InternalData
  #
  # source://test-unit//lib/test/unit/testcase.rb#938
  def initialize; end

  # source://test-unit//lib/test/unit/testcase.rb#956
  def assign_test_data(label, data); end

  # Returns the value of attribute elapsed_time.
  #
  # source://test-unit//lib/test/unit/testcase.rb#935
  def elapsed_time; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/testcase.rb#961
  def have_test_data?; end

  # source://test-unit//lib/test/unit/testcase.rb#977
  def interrupted; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/testcase.rb#952
  def interrupted?; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/testcase.rb#948
  def passed?; end

  # source://test-unit//lib/test/unit/testcase.rb#973
  def problem_occurred; end

  # Returns the value of attribute run_context.
  #
  # source://test-unit//lib/test/unit/testcase.rb#937
  def run_context; end

  # Sets the attribute run_context
  #
  # @param value the value to set the attribute run_context to.
  #
  # source://test-unit//lib/test/unit/testcase.rb#937
  def run_context=(_arg0); end

  # Returns the value of attribute start_time.
  #
  # source://test-unit//lib/test/unit/testcase.rb#935
  def start_time; end

  # Returns the value of attribute test_data.
  #
  # source://test-unit//lib/test/unit/testcase.rb#936
  def test_data; end

  # Returns the value of attribute test_data_label.
  #
  # source://test-unit//lib/test/unit/testcase.rb#936
  def test_data_label; end

  # source://test-unit//lib/test/unit/testcase.rb#969
  def test_finished; end

  # source://test-unit//lib/test/unit/testcase.rb#965
  def test_started; end
end

# source://test-unit//lib/test/unit/testcase.rb#119
Test::Unit::TestCase::STARTED = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/testcase.rb#121
Test::Unit::TestCase::STARTED_OBJECT = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/notification.rb#56
module Test::Unit::TestCaseNotificationSupport
  include ::Test::Unit::NotificationHandler

  # Notify some information.
  #
  # Example:
  #
  #     def test_notification
  #       notify("I'm here!")
  #       # Reached here
  #       notify("Special!") if special_case?
  #       # Reached here too
  #     end
  #
  # options:
  #
  #     :backtrace override backtrace.
  #
  # source://test-unit//lib/test/unit/notification.rb#79
  def notify(message, options = T.unsafe(nil), &block); end

  private

  # source://test-unit//lib/test/unit/notification.rb#87
  def add_notification(notification); end

  class << self
    # @private
    #
    # source://test-unit//lib/test/unit/notification.rb#58
    def included(base); end
  end
end

# source://test-unit//lib/test/unit/omission.rb#56
module Test::Unit::TestCaseOmissionSupport
  include ::Test::Unit::OmissionHandler

  # Omit the test or part of the test.
  #
  # Example:
  #
  #     def test_omission
  #       omit
  #       # Not reached here
  #     end
  #
  #     def test_omission_with_here
  #       omit do
  #         # Not ran here
  #       end
  #       # Reached here
  #     end
  #
  # source://test-unit//lib/test/unit/omission.rb#80
  def omit(message = T.unsafe(nil), &block); end

  # Omit the test or part of the test if _condition_ is
  # true.
  #
  # Example:
  #
  #     def test_omission
  #       omit_if("".empty?)
  #       # Not reached here
  #     end
  #
  #     def test_omission_with_here
  #       omit_if(true) do
  #         # Not ran here
  #       end
  #       omit_if(false) do
  #         # Reached here
  #       end
  #       # Reached here too
  #     end
  #
  # source://test-unit//lib/test/unit/omission.rb#110
  def omit_if(condition, *args, &block); end

  # Omit the test or part of the test if _condition_ is
  # not true.
  #
  # Example:
  #
  #     def test_omission
  #       omit_unless("string".empty?)
  #       # Not reached here
  #     end
  #
  #     def test_omission_with_here
  #       omit_unless(true) do
  #         # Reached here
  #       end
  #       omit_unless(false) do
  #         # Not ran here
  #       end
  #       # Reached here too
  #     end
  #
  # source://test-unit//lib/test/unit/omission.rb#137
  def omit_unless(condition, *args, &block); end

  private

  # source://test-unit//lib/test/unit/omission.rb#146
  def add_omission(omission); end

  class << self
    # @private
    #
    # source://test-unit//lib/test/unit/omission.rb#58
    def included(base); end
  end
end

# source://test-unit//lib/test/unit/pending.rb#56
module Test::Unit::TestCasePendingSupport
  include ::Test::Unit::PendingHandler

  # Marks the test or part of the test is pending.
  #
  # Example:
  #
  #     def test_pending
  #       pend
  #       # Not reached here
  #     end
  #
  #     def test_pending_with_here
  #       pend do
  #         # Ran here
  #         # Fails if the block doesn't raise any error.
  #         # Because it means the block is passed unexpectedly.
  #       end
  #       # Reached here
  #     end
  #
  # source://test-unit//lib/test/unit/pending.rb#82
  def pend(message = T.unsafe(nil), &block); end

  private

  # source://test-unit//lib/test/unit/pending.rb#102
  def add_pending(pending); end

  class << self
    # @private
    #
    # source://test-unit//lib/test/unit/pending.rb#58
    def included(base); end
  end
end

# Collects Test::Unit::Failure and Test::Unit::Error so that
# they can be displayed to the user. To this end, observers
# can be added to it, allowing the dynamic updating of, say, a
# UI.
#
# source://test-unit//lib/test/unit/testresult.rb#25
class Test::Unit::TestResult
  include ::Test::Unit::Util::Observable
  include ::Test::Unit::NullResultContainerInitializer
  include ::Test::Unit::TestResultFailureSupport
  include ::Test::Unit::TestResultErrorSupport
  include ::Test::Unit::TestResultPendingSupport
  include ::Test::Unit::TestResultOmissionSupport
  include ::Test::Unit::TestResultNotificationSupport

  # Constructs a new, empty TestResult.
  #
  # @return [TestResult] a new instance of TestResult
  #
  # source://test-unit//lib/test/unit/testresult.rb#44
  def initialize; end

  # Records an individual assertion.
  #
  # source://test-unit//lib/test/unit/testresult.rb#65
  def add_assertion; end

  # source://test-unit//lib/test/unit/testresult.rb#60
  def add_pass; end

  # Records a test run.
  #
  # source://test-unit//lib/test/unit/testresult.rb#54
  def add_run(result = T.unsafe(nil)); end

  # Returns the value of attribute assertion_count.
  #
  # source://test-unit//lib/test/unit/testresult.rb#39
  def assertion_count; end

  # Returns the value of attribute faults.
  #
  # source://test-unit//lib/test/unit/testresult.rb#39
  def faults; end

  # Returns the value of attribute pass_count.
  #
  # source://test-unit//lib/test/unit/testresult.rb#39
  def pass_count; end

  # source://test-unit//lib/test/unit/testresult.rb#112
  def pass_percentage; end

  # Returns whether or not this TestResult represents
  # successful completion.
  #
  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/testresult.rb#108
  def passed?; end

  # Returns the value of attribute run_count.
  #
  # source://test-unit//lib/test/unit/testresult.rb#39
  def run_count; end

  # Returns a string that shows result status.
  #
  # source://test-unit//lib/test/unit/testresult.rb#80
  def status; end

  # source://test-unit//lib/test/unit/testresult.rb#98
  def stop; end

  # Returns the value of attribute stop_tag.
  #
  # source://test-unit//lib/test/unit/testresult.rb#41
  def stop_tag; end

  # Sets the attribute stop_tag
  #
  # @param value the value to set the attribute stop_tag to.
  #
  # source://test-unit//lib/test/unit/testresult.rb#41
  def stop_tag=(_arg0); end

  # Returns a string contain the recorded runs, assertions,
  # failures and errors in this TestResult.
  #
  # source://test-unit//lib/test/unit/testresult.rb#73
  def summary; end

  # source://test-unit//lib/test/unit/testresult.rb#102
  def to_s; end

  private

  # source://test-unit//lib/test/unit/testresult.rb#122
  def notify_changed; end

  # source://test-unit//lib/test/unit/testresult.rb#126
  def notify_fault(fault); end
end

# source://test-unit//lib/test/unit/testresult.rb#35
Test::Unit::TestResult::CHANGED = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/testresult.rb#37
Test::Unit::TestResult::FAULT = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/testresult.rb#34
Test::Unit::TestResult::FINISHED = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/testresult.rb#36
Test::Unit::TestResult::PASS_ASSERTION = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/error.rb#125
module Test::Unit::TestResultErrorSupport
  # Records a Test::Unit::Error.
  #
  # source://test-unit//lib/test/unit/error.rb#129
  def add_error(error); end

  # Returns the number of errors this TestResult has
  # recorded.
  #
  # source://test-unit//lib/test/unit/error.rb#137
  def error_count; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/error.rb#141
  def error_occurred?; end

  # Returns the value of attribute errors.
  #
  # source://test-unit//lib/test/unit/error.rb#126
  def errors; end

  private

  # source://test-unit//lib/test/unit/error.rb#153
  def error_summary; end

  # source://test-unit//lib/test/unit/error.rb#146
  def initialize_containers; end
end

# source://test-unit//lib/test/unit/failure.rb#136
module Test::Unit::TestResultFailureSupport
  # Records a Test::Unit::Failure.
  #
  # source://test-unit//lib/test/unit/failure.rb#140
  def add_failure(failure); end

  # Returns the number of failures this TestResult has
  # recorded.
  #
  # source://test-unit//lib/test/unit/failure.rb#148
  def failure_count; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/failure.rb#152
  def failure_occurred?; end

  # Returns the value of attribute failures.
  #
  # source://test-unit//lib/test/unit/failure.rb#137
  def failures; end

  private

  # source://test-unit//lib/test/unit/failure.rb#164
  def failure_summary; end

  # source://test-unit//lib/test/unit/failure.rb#157
  def initialize_containers; end
end

# source://test-unit//lib/test/unit/notification.rb#110
module Test::Unit::TestResultNotificationSupport
  # Records a Test::Unit::Notification.
  #
  # source://test-unit//lib/test/unit/notification.rb#114
  def add_notification(notification); end

  # Returns the number of notifications this TestResult has
  # recorded.
  #
  # source://test-unit//lib/test/unit/notification.rb#122
  def notification_count; end

  # Returns the value of attribute notifications.
  #
  # source://test-unit//lib/test/unit/notification.rb#111
  def notifications; end

  private

  # source://test-unit//lib/test/unit/notification.rb#127
  def initialize_containers; end

  # source://test-unit//lib/test/unit/notification.rb#133
  def notification_summary; end
end

# source://test-unit//lib/test/unit/omission.rb#170
module Test::Unit::TestResultOmissionSupport
  # Records a Test::Unit::Omission.
  #
  # source://test-unit//lib/test/unit/omission.rb#174
  def add_omission(omission); end

  # Returns the number of omissions this TestResult has
  # recorded.
  #
  # source://test-unit//lib/test/unit/omission.rb#182
  def omission_count; end

  # Returns the value of attribute omissions.
  #
  # source://test-unit//lib/test/unit/omission.rb#171
  def omissions; end

  private

  # source://test-unit//lib/test/unit/omission.rb#187
  def initialize_containers; end

  # source://test-unit//lib/test/unit/omission.rb#193
  def omission_summary; end
end

# source://test-unit//lib/test/unit/pending.rb#127
module Test::Unit::TestResultPendingSupport
  # Records a Test::Unit::Pending.
  #
  # source://test-unit//lib/test/unit/pending.rb#131
  def add_pending(pending); end

  # Returns the number of pendings this TestResult has
  # recorded.
  #
  # source://test-unit//lib/test/unit/pending.rb#139
  def pending_count; end

  # Returns the value of attribute pendings.
  #
  # source://test-unit//lib/test/unit/pending.rb#128
  def pendings; end

  private

  # source://test-unit//lib/test/unit/pending.rb#144
  def initialize_containers; end

  # source://test-unit//lib/test/unit/pending.rb#150
  def pending_summary; end
end

# source://test-unit//lib/test/unit/test-run-context.rb#9
class Test::Unit::TestRunContext
  # @return [TestRunContext] a new instance of TestRunContext
  #
  # source://test-unit//lib/test/unit/test-run-context.rb#11
  def initialize(runner_class); end

  # Returns the value of attribute runner_class.
  #
  # source://test-unit//lib/test/unit/test-run-context.rb#10
  def runner_class; end
end

# A collection of tests which can be #run.
#
# Note: It is easy to confuse a TestSuite instance with
# something that has a static suite method; I know because _I_
# have trouble keeping them straight. Think of something that
# has a suite method as simply providing a way to get a
# meaningful TestSuite instance.
#
# source://test-unit//lib/test/unit/testsuite.rb#21
class Test::Unit::TestSuite
  # Creates a new TestSuite with the given name.
  #
  # @return [TestSuite] a new instance of TestSuite
  #
  # source://test-unit//lib/test/unit/testsuite.rb#34
  def initialize(name = T.unsafe(nil), test_case = T.unsafe(nil)); end

  # Adds the test to the suite.
  #
  # source://test-unit//lib/test/unit/testsuite.rb#68
  def <<(test); end

  # It's handy to be able to compare TestSuite instances.
  #
  # source://test-unit//lib/test/unit/testsuite.rb#101
  def ==(other); end

  # source://test-unit//lib/test/unit/testsuite.rb#73
  def delete(test); end

  # source://test-unit//lib/test/unit/testsuite.rb#77
  def delete_tests(tests); end

  # Returns the value of attribute elapsed_time.
  #
  # source://test-unit//lib/test/unit/testsuite.rb#22
  def elapsed_time; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/testsuite.rb#90
  def empty?; end

  # Returns the value of attribute name.
  #
  # source://test-unit//lib/test/unit/testsuite.rb#22
  def name; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/testsuite.rb#43
  def parallel_safe?; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/testsuite.rb#107
  def passed?; end

  # Test suite that has higher priority is ran prior to
  # test suites that have lower priority.
  #
  # source://test-unit//lib/test/unit/testsuite.rb#26
  def priority; end

  # Test suite that has higher priority is ran prior to
  # test suites that have lower priority.
  #
  # source://test-unit//lib/test/unit/testsuite.rb#26
  def priority=(_arg0); end

  # Runs the tests and/or suites contained in this
  # TestSuite.
  #
  # source://test-unit//lib/test/unit/testsuite.rb#50
  def run(result, run_context: T.unsafe(nil), &progress_block); end

  # Returns the rolled up number of tests in this suite;
  # i.e. if the suite contains other suites, it counts the
  # tests within those suites, not the suites themselves.
  #
  # source://test-unit//lib/test/unit/testsuite.rb#84
  def size; end

  # Returns the value of attribute start_time.
  #
  # source://test-unit//lib/test/unit/testsuite.rb#22
  def start_time; end

  # Returns the value of attribute test_case.
  #
  # source://test-unit//lib/test/unit/testsuite.rb#22
  def test_case; end

  # Returns the value of attribute tests.
  #
  # source://test-unit//lib/test/unit/testsuite.rb#22
  def tests; end

  # Overridden to return the name given the suite at
  # creation.
  #
  # source://test-unit//lib/test/unit/testsuite.rb#96
  def to_s; end
end

# source://test-unit//lib/test/unit/testsuite.rb#30
Test::Unit::TestSuite::FINISHED = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/testsuite.rb#31
Test::Unit::TestSuite::FINISHED_OBJECT = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/testsuite.rb#28
Test::Unit::TestSuite::STARTED = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/testsuite.rb#29
Test::Unit::TestSuite::STARTED_OBJECT = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/test-suite-creator.rb#12
class Test::Unit::TestSuiteCreator
  # @return [TestSuiteCreator] a new instance of TestSuiteCreator
  #
  # source://test-unit//lib/test/unit/test-suite-creator.rb#20
  def initialize(test_case); end

  # source://test-unit//lib/test/unit/test-suite-creator.rb#24
  def create; end

  private

  # @yield [test]
  #
  # source://test-unit//lib/test/unit/test-suite-creator.rb#59
  def append_test(suite, test_name); end

  # source://test-unit//lib/test/unit/test-suite-creator.rb#65
  def collect_test_names; end

  # source://test-unit//lib/test/unit/test-suite-creator.rb#43
  def extract_data_sets(test_name); end

  # source://test-unit//lib/test/unit/test-suite-creator.rb#77
  def sort_test_names_in_alphabetic_order(test_names); end

  # source://test-unit//lib/test/unit/test-suite-creator.rb#85
  def sort_test_names_in_defined_order(test_names); end

  # source://test-unit//lib/test/unit/test-suite-creator.rb#81
  def sort_test_names_in_random_order(test_names); end

  class << self
    # @return [Boolean]
    #
    # source://test-unit//lib/test/unit/test-suite-creator.rb#14
    def test_method?(test_case, method_name); end
  end
end

# source://test-unit//lib/test/unit/test-suite-runner.rb#15
class Test::Unit::TestSuiteRunner
  # @return [TestSuiteRunner] a new instance of TestSuiteRunner
  #
  # source://test-unit//lib/test/unit/test-suite-runner.rb#31
  def initialize(test_suite); end

  # source://test-unit//lib/test/unit/test-suite-runner.rb#35
  def run(result, run_context: T.unsafe(nil), &progress_block); end

  private

  # source://test-unit//lib/test/unit/test-suite-runner.rb#118
  def handle_exception(exception, result); end

  # source://test-unit//lib/test/unit/test-suite-runner.rb#108
  def run_shutdown(result); end

  # source://test-unit//lib/test/unit/test-suite-runner.rb#50
  def run_startup(result); end

  # source://test-unit//lib/test/unit/test-suite-runner.rb#66
  def run_test(test, result, run_context: T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/test-suite-runner.rb#60
  def run_tests(result, run_context: T.unsafe(nil), &progress_block); end

  class << self
    # source://test-unit//lib/test/unit/test-suite-runner.rb#22
    def n_workers; end

    # source://test-unit//lib/test/unit/test-suite-runner.rb#26
    def n_workers=(n); end

    # @yield [TestRunContext.new(self)]
    #
    # source://test-unit//lib/test/unit/test-suite-runner.rb#18
    def run_all_tests; end
  end
end

# source://test-unit//lib/test/unit/test-suite-thread-runner.rb#13
class Test::Unit::TestSuiteThreadRunner < ::Test::Unit::TestSuiteRunner
  # source://test-unit//lib/test/unit/test-suite-thread-runner.rb#51
  def run(result, run_context: T.unsafe(nil), &progress_block); end

  private

  # source://test-unit//lib/test/unit/test-suite-thread-runner.rb#68
  def run_tests(result, run_context: T.unsafe(nil), &progress_block); end

  class << self
    # @yield [TestThreadRunContext.new(self, queue, shutdowns)]
    #
    # source://test-unit//lib/test/unit/test-suite-thread-runner.rb#15
    def run_all_tests; end
  end
end

# source://test-unit//lib/test/unit/test-thread-run-context.rb#11
class Test::Unit::TestThreadRunContext < ::Test::Unit::TestRunContext
  # @return [TestThreadRunContext] a new instance of TestThreadRunContext
  #
  # source://test-unit//lib/test/unit/test-thread-run-context.rb#13
  def initialize(runner_class, queue, shutdowns); end

  # Returns the value of attribute queue.
  #
  # source://test-unit//lib/test/unit/test-thread-run-context.rb#12
  def queue; end

  # Returns the value of attribute shutdowns.
  #
  # source://test-unit//lib/test/unit/test-thread-run-context.rb#12
  def shutdowns; end
end

# source://test-unit//lib/test/unit/ui/testrunnerutilities.rb#9
module Test::Unit::UI; end

# source://test-unit//lib/test/unit/ui/console/outputlevel.rb#4
module Test::Unit::UI::Console; end

# source://test-unit//lib/test/unit/ui/console/testrunner.rb#721
class Test::Unit::UI::Console::ColorizedReadableDiffer < ::Test::Unit::Diff::ReadableDiffer
  # @return [ColorizedReadableDiffer] a new instance of ColorizedReadableDiffer
  #
  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#722
  def initialize(from, to, runner); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#727
  def need_diff?(options = T.unsafe(nil)); end

  private

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#756
  def color(name); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#760
  def cut_off_ratio; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#764
  def default_ratio; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#793
  def diff_line(from_line, to_line); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#736
  def one_line_all_change?; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#752
  def output(something, color = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#748
  def output_single(something, color = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#768
  def tag(mark, color_name, contents); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#777
  def tag_deleted(contents); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#789
  def tag_difference(contents); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#785
  def tag_equal(contents); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#781
  def tag_inserted(contents); end
end

# source://test-unit//lib/test/unit/ui/console/outputlevel.rb#5
module Test::Unit::UI::Console::OutputLevel; end

# source://test-unit//lib/test/unit/ui/console/outputlevel.rb#8
Test::Unit::UI::Console::OutputLevel::IMPORTANT_FAULTS_ONLY = T.let(T.unsafe(nil), Integer)

# source://test-unit//lib/test/unit/ui/console/outputlevel.rb#9
Test::Unit::UI::Console::OutputLevel::NORMAL = T.let(T.unsafe(nil), Integer)

# source://test-unit//lib/test/unit/ui/console/outputlevel.rb#7
Test::Unit::UI::Console::OutputLevel::PROGRESS_ONLY = T.let(T.unsafe(nil), Integer)

# source://test-unit//lib/test/unit/ui/console/outputlevel.rb#6
Test::Unit::UI::Console::OutputLevel::SILENT = T.let(T.unsafe(nil), Integer)

# source://test-unit//lib/test/unit/ui/console/outputlevel.rb#10
Test::Unit::UI::Console::OutputLevel::VERBOSE = T.let(T.unsafe(nil), Integer)

# Runs a Test::Unit::TestSuite on the console.
#
# source://test-unit//lib/test/unit/ui/console/testrunner.rb#29
class Test::Unit::UI::Console::TestRunner < ::Test::Unit::UI::TestRunner
  include ::Test::Unit::UI::Console::OutputLevel

  # Creates a new TestRunner for running the passed
  # suite. If quiet_mode is true, the output while
  # running is limited to progress dots, errors and
  # failures, and the final result. io specifies
  # where runner output should go to; defaults to
  # STDOUT.
  #
  # @return [TestRunner] a new instance of TestRunner
  #
  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#40
  def initialize(suite, options = T.unsafe(nil)); end

  private

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#103
  def add_fault(fault); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#86
  def attach_to_mediator; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#181
  def categorize_fault(fault); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#171
  def categorize_faults; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#68
  def change_output_level(level); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#597
  def color(name); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#224
  def detect_target_location_on_github_actions(fault); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#608
  def fault_class_color(fault_class); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#604
  def fault_class_color_name(fault_class); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#612
  def fault_color(fault); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#616
  def fault_marker_color(fault); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#309
  def fetch_code_snippet(file, line_number); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#120
  def finished(elapsed_time); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#390
  def format_fault(fault); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#647
  def guess_color_availability; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#624
  def guess_output_level; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#680
  def guess_progress_row_max; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#662
  def guess_progress_style; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#693
  def guess_term_width; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#709
  def guess_term_width_from_env; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#697
  def guess_term_width_from_io; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#520
  def indent; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#145
  def max_digit(max_number); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#528
  def nl(level = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#532
  def output(something, color = T.unsafe(nil), level = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#593
  def output?(level); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#313
  def output_code_snippet(lines, target_line_color = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#329
  def output_failure_message(failure); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#281
  def output_fault_backtrace(fault); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#192
  def output_fault_in_detail(fault); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#383
  def output_fault_in_short(fault); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#267
  def output_fault_message(fault); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#248
  def output_fault_on_github_actions(fault); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#134
  def output_faults; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#149
  def output_faults_in_detail(faults); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#159
  def output_faults_in_short(label, fault_class, faults); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#552
  def output_progress(mark, color = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#572
  def output_progress_in_detail(fault); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#567
  def output_progress_in_detail_marker(fault); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#80
  def output_setup_end; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#538
  def output_single(something, color = T.unsafe(nil), level = T.unsafe(nil)); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#116
  def output_started; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#394
  def output_statistics(elapsed_time); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#431
  def output_summary_marker; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#676
  def ruby_2_0_or_later?; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#75
  def setup_mediator; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#111
  def started(result); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#486
  def suite_name(prefix, suite); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#620
  def summary_marker_color; end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#459
  def test_finished(test); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#436
  def test_started(test); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#515
  def test_suite_finished(suite); end

  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#495
  def test_suite_started(suite); end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/ui/console/testrunner.rb#672
  def windows?; end
end

# source://test-unit//lib/test/unit/ui/console/testrunner.rb#32
Test::Unit::UI::Console::TestRunner::N_REPORT_SLOW_TESTS = T.let(T.unsafe(nil), Integer)

# source://test-unit//lib/test/unit/ui/console/testrunner.rb#632
Test::Unit::UI::Console::TestRunner::TERM_COLOR_SUPPORT = T.let(T.unsafe(nil), Regexp)

# source://test-unit//lib/test/unit/ui/testrunner.rb#6
class Test::Unit::UI::TestRunner
  extend ::Test::Unit::UI::TestRunnerUtilities

  # @return [TestRunner] a new instance of TestRunner
  #
  # source://test-unit//lib/test/unit/ui/testrunner.rb#10
  def initialize(suite, options = T.unsafe(nil)); end

  # Returns the value of attribute listeners.
  #
  # source://test-unit//lib/test/unit/ui/testrunner.rb#9
  def listeners; end

  # Begins the test run.
  #
  # source://test-unit//lib/test/unit/ui/testrunner.rb#21
  def start; end

  private

  # source://test-unit//lib/test/unit/ui/testrunner.rb#33
  def attach_listeners; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/ui/testrunner.rb#43
  def diff_target_string?(string); end

  # source://test-unit//lib/test/unit/ui/testrunner.rb#47
  def prepare_for_diff(from, to); end

  # source://test-unit//lib/test/unit/ui/testrunner.rb#29
  def setup_mediator; end

  # source://test-unit//lib/test/unit/ui/testrunner.rb#39
  def start_mediator; end
end

# Provides an interface to write any given UI against,
# hopefully making it easy to write new UIs.
#
# source://test-unit//lib/test/unit/ui/testrunnermediator.rb#16
class Test::Unit::UI::TestRunnerMediator
  include ::Test::Unit::Util::Observable

  # Creates a new TestRunnerMediator initialized to run
  # the passed suite.
  #
  # @return [TestRunnerMediator] a new instance of TestRunnerMediator
  #
  # source://test-unit//lib/test/unit/ui/testrunnermediator.rb#25
  def initialize(suite, options = T.unsafe(nil)); end

  # Runs the suite the TestRunnerMediator was created
  # with.
  #
  # source://test-unit//lib/test/unit/ui/testrunnermediator.rb#34
  def run; end

  # Just for backward compatibility for NetBeans.
  # NetBeans should not use monkey patching. NetBeans
  # should use runner change public API.
  #
  # See GitHub#38
  #   https://github.com/test-unit/test-unit/issues/38
  #
  # source://test-unit//lib/test/unit/ui/testrunnermediator.rb#68
  def run_suite(result = T.unsafe(nil), run_context = T.unsafe(nil)); end

  private

  # A factory method to create the result the mediator
  # should run with. Can be overridden by subclasses if
  # one wants to use a different result.
  #
  # source://test-unit//lib/test/unit/ui/testrunnermediator.rb#82
  def create_result; end

  # source://test-unit//lib/test/unit/ui/testrunnermediator.rb#86
  def measure_time; end

  # source://test-unit//lib/test/unit/ui/testrunnermediator.rb#92
  def with_listener(result); end
end

# source://test-unit//lib/test/unit/ui/testrunnermediator.rb#19
Test::Unit::UI::TestRunnerMediator::FINISHED = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/ui/testrunnermediator.rb#17
Test::Unit::UI::TestRunnerMediator::RESET = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/ui/testrunnermediator.rb#18
Test::Unit::UI::TestRunnerMediator::STARTED = T.let(T.unsafe(nil), String)

# Provides some utilities common to most, if not all,
# TestRunners.
#
# --
#
# Perhaps there ought to be a TestRunner superclass? There
# seems to be a decent amount of shared code between test
# runners.
#
# source://test-unit//lib/test/unit/ui/testrunnerutilities.rb#20
module Test::Unit::UI::TestRunnerUtilities
  # Creates a new TestRunner and runs the suite.
  #
  # source://test-unit//lib/test/unit/ui/testrunnerutilities.rb#23
  def run(suite, options = T.unsafe(nil)); end

  # Takes care of the ARGV parsing and suite
  # determination necessary for running one of the
  # TestRunners from the command line.
  #
  # source://test-unit//lib/test/unit/ui/testrunnerutilities.rb#30
  def start_command_line_test; end
end

# source://test-unit//lib/test/unit/util/procwrapper.rb#9
module Test::Unit::Util; end

# source://test-unit//lib/test/unit/util/backtracefilter.rb#9
module Test::Unit::Util::BacktraceFilter
  private

  # source://test-unit//lib/test/unit/util/backtracefilter.rb#20
  def filter_backtrace(backtrace, prefix = T.unsafe(nil)); end

  class << self
    # source://test-unit//lib/test/unit/util/backtracefilter.rb#20
    def filter_backtrace(backtrace, prefix = T.unsafe(nil)); end
  end
end

# source://test-unit//lib/test/unit/util/backtracefilter.rb#14
Test::Unit::Util::BacktraceFilter::POWERASSERT_PREFIX = T.let(T.unsafe(nil), Array)

# source://test-unit//lib/test/unit/util/backtracefilter.rb#10
Test::Unit::Util::BacktraceFilter::TESTUNIT_FILE_SEPARATORS = T.let(T.unsafe(nil), Regexp)

# source://test-unit//lib/test/unit/util/backtracefilter.rb#11
Test::Unit::Util::BacktraceFilter::TESTUNIT_PREFIX = T.let(T.unsafe(nil), Array)

# source://test-unit//lib/test/unit/util/backtracefilter.rb#12
Test::Unit::Util::BacktraceFilter::TESTUNIT_RB_FILE = T.let(T.unsafe(nil), Regexp)

# source://test-unit//lib/test/unit/util/memory-usage.rb#4
class Test::Unit::Util::MemoryUsage
  # @return [MemoryUsage] a new instance of MemoryUsage
  #
  # source://test-unit//lib/test/unit/util/memory-usage.rb#7
  def initialize; end

  # @return [Boolean]
  #
  # source://test-unit//lib/test/unit/util/memory-usage.rb#13
  def collected?; end

  # Returns the value of attribute physical.
  #
  # source://test-unit//lib/test/unit/util/memory-usage.rb#6
  def physical; end

  # Returns the value of attribute virtual.
  #
  # source://test-unit//lib/test/unit/util/memory-usage.rb#5
  def virtual; end

  private

  # source://test-unit//lib/test/unit/util/memory-usage.rb#20
  def collect_data; end

  # source://test-unit//lib/test/unit/util/memory-usage.rb#24
  def collect_data_proc; end
end

# source://test-unit//lib/test/unit/util/method-owner-finder.rb#4
module Test::Unit::Util::MethodOwnerFinder
  private

  # source://test-unit//lib/test/unit/util/method-owner-finder.rb#6
  def find(object, method_name); end

  class << self
    # source://test-unit//lib/test/unit/util/method-owner-finder.rb#6
    def find(object, method_name); end
  end
end

# This is a utility class that allows anything mixing
# it in to notify a set of listeners about interesting
# events.
#
# source://test-unit//lib/test/unit/util/observable.rb#16
module Test::Unit::Util::Observable
  # Adds the passed proc as a listener on the
  # channel indicated by channel_name. listener_key
  # is used to remove the listener later; if none is
  # specified, the proc itself is used.
  #
  # Whatever is used as the listener_key is
  # returned, making it very easy to use the proc
  # itself as the listener_key:
  #
  #     listener = add_listener("Channel") { ... }
  #     remove_listener("Channel", listener)
  #
  # source://test-unit//lib/test/unit/util/observable.rb#31
  def add_listener(channel_name, listener_key = T.unsafe(nil), &listener); end

  # Calls all the procs registered on the channel
  # indicated by channel_name. If value is
  # specified, it is passed in to the procs,
  # otherwise they are called with no arguments.
  #
  # --
  #
  # Perhaps this should be private? Would it ever
  # make sense for an external class to call this
  # method directly?
  #
  # source://test-unit//lib/test/unit/util/observable.rb#71
  def notify_listeners(channel_name, *arguments); end

  # Removes the listener indicated by listener_key
  # from the channel indicated by
  # channel_name. Returns the registered proc, or
  # nil if none was found.
  #
  # source://test-unit//lib/test/unit/util/observable.rb#51
  def remove_listener(channel_name, listener_key); end

  private

  # source://test-unit//lib/test/unit/util/observable.rb#79
  def channels; end
end

# We use this for defaults since nil might mean something
#
# source://test-unit//lib/test/unit/util/observable.rb#18
Test::Unit::Util::Observable::NOTHING = T.let(T.unsafe(nil), String)

# source://test-unit//lib/test/unit/util/output.rb#4
module Test::Unit::Util::Output
  # Returns output for standard output and standard
  # error as string.
  #
  # Example:
  #
  #     capture_output do
  #       puts("stdout")
  #       warn("stderr")
  #     end # -> ["stdout\n", "stderr\n"]
  #
  # source://test-unit//lib/test/unit/util/output.rb#15
  def capture_output; end
end

# Allows the storage of a Proc passed through '&' in a
# hash.
#
# Note: this may be inefficient, since the hash being
# used is not necessarily very good. In Observable,
# efficiency is not too important, since the hash is
# only accessed when adding and removing listeners,
# not when notifying.
#
# source://test-unit//lib/test/unit/util/procwrapper.rb#20
class Test::Unit::Util::ProcWrapper
  # Creates a new wrapper for a_proc.
  #
  # @return [ProcWrapper] a new instance of ProcWrapper
  #
  # source://test-unit//lib/test/unit/util/procwrapper.rb#23
  def initialize(a_proc); end

  # source://test-unit//lib/test/unit/util/procwrapper.rb#32
  def ==(other); end

  # source://test-unit//lib/test/unit/util/procwrapper.rb#40
  def eql?(other); end

  # source://test-unit//lib/test/unit/util/procwrapper.rb#28
  def hash; end

  # source://test-unit//lib/test/unit/util/procwrapper.rb#42
  def to_proc; end
end

# source://test-unit//lib/test/unit/version.rb#3
Test::Unit::VERSION = T.let(T.unsafe(nil), String)
