
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <AppCont_ContMatrices.hxx>
#include <AppCont_Function.hxx>
#include <AppCont_LeastSquare.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_AppCont_enums(py::module &main_module) {


py::module m = main_module.def_submodule("AppCont", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes
    class Py_AppCont_Function : public AppCont_Function{
    public:
        using AppCont_Function::AppCont_Function;


        // public pure virtual
        Standard_Real FirstParameter() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,AppCont_Function,FirstParameter,) };
        Standard_Real LastParameter() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,AppCont_Function,LastParameter,) };
        Standard_Boolean Value( const Standard_Real theU,NCollection_Array1<gp_Pnt2d> & thePnt2d,NCollection_Array1<gp_Pnt> & thePnt) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,AppCont_Function,Value,theU,thePnt2d,thePnt) };
        Standard_Boolean D1( const Standard_Real theU,NCollection_Array1<gp_Vec2d> & theVec2d,NCollection_Array1<gp_Vec> & theVec) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,AppCont_Function,D1,theU,theVec2d,theVec) };


        // protected pure virtual


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    py::class_<AppCont_Function , shared_ptr<AppCont_Function> ,Py_AppCont_Function >(m,"AppCont_Function",R"#(Class describing a continuous 3d and/or function f(u). This class must be provided by the user to use the approximation algorithm FittingCurve.)#");
    py::class_<AppCont_LeastSquare , shared_ptr<AppCont_LeastSquare>  >(m,"AppCont_LeastSquare",R"#()#");
    py::class_<PeriodicityInfo , shared_ptr<PeriodicityInfo>  >(m,"PeriodicityInfo",R"#()#");

};

// user-defined post-inclusion per module

// user-defined post
