require 'spec_helper_acceptance'

describe 'basic cloudkitty' do

  context 'default parameters' do

    it 'should work with no errors' do
      pp= <<-EOS
      include openstack_integration
      include openstack_integration::repos
      include openstack_integration::apache
      include openstack_integration::rabbitmq
      include openstack_integration::mysql
      include openstack_integration::keystone

      rabbitmq_user { 'cloudkitty':
        admin    => true,
        password => 'an_even_bigger_secret',
        provider => 'rabbitmqctl',
        require  => Class['rabbitmq'],
      }

      rabbitmq_user_permissions { 'cloudkitty@/':
        configure_permission => '.*',
        write_permission     => '.*',
        read_permission      => '.*',
        provider             => 'rabbitmqctl',
        require              => Class['rabbitmq'],
      }

      # Cloudkitty resources
      class { 'cloudkitty::db':
        database_connection => 'mysql+pymysql://cloudkitty:a_big_secret@127.0.0.1/cloudkitty?charset=utf8',
      }
      class { 'cloudkitty::logging':
        debug => true,
      }
      class { 'cloudkitty':
        default_transport_url => 'rabbit://cloudkitty:an_even_bigger_secret@127.0.0.1:5672',
        # NOTE(tobias-urdin): Cloudkitty in Stein has moved to storage v2 by default and the
        # only driver available is InfluxDB which we do not deploy. This sets it back to the
        # old sqlalchemy storage driver in version 1.
        storage_backend       => 'sqlalchemy',
        storage_version       => '1',
      }
      class { 'cloudkitty::keystone::auth':
        password => 'a_big_secret',
      }
      class { 'cloudkitty::keystone::authtoken':
        password  => 'a_big_secret',
      }
      class { 'cloudkitty::db::mysql':
        charset  => $::openstack_integration::params::mysql_charset,
        collate  => $::openstack_integration::params::mysql_collate,
        password => 'a_big_secret',
      }
      class { 'cloudkitty::api':
        service_name => 'httpd',
      }
      include apache
      class { 'cloudkitty::wsgi::apache':
        ssl => false,
      }
      class { 'cloudkitty::processor': }
      class { 'cloudkitty::client': }
      EOS


      # Run it twice and test for idempotency
      apply_manifest(pp, :catch_failures => true)
      apply_manifest(pp, :catch_changes => true)
    end

    describe port(8889) do
      it { is_expected.to be_listening }
    end

  end

end
