
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileIsoPlotAttributes.h
    \brief Definition of IsoPlot Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef IsoPlotAttributes_H
#define IsoPlotAttributes_H

#include "magics.h"
#include "LevelSelection.h"
#include "IsoLabel.h"
#include "IsoHighlight.h"
#include "ColourTechnique.h"
#include "IsoShading.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class IsoPlotAttributes 
{
public:
//  --  constructor
    IsoPlotAttributes();
    
//  --  destructor
    virtual ~IsoPlotAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const IsoPlotAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string legend_special_;
	int user_thread_;
	double resolution_;
	string technique_;
	string legend_text_;
	int thickness_;
	bool rainbow_;
	string rainbowDirection_;
	stringarray rainbowColours_;
	intarray rainbowThicknessList_;
	stringarray rainbowStyleList_;
	bool legend_only_;
	LineStyle style_;
	unique_ptr<Colour> colour_;
	unique_ptr<ColourTechnique> rainbowMethod_;
	unique_ptr<Colour> rainbowMaxColour_;
	unique_ptr<Colour> rainbowMinColour_;
	ListPolicy rainbowColourPolicy_;
	ListPolicy rainbowThicknessListPolicy_;
	ListPolicy rainbowStyleListPolicy_;
	unique_ptr<NoIsoHighlight> highlight_;
	unique_ptr<LevelSelection> levelSelection_;
	unique_ptr<NoIsoLabel> label_;
	unique_ptr<NoIsoShading> shading_;
	 

private:
	friend ostream& operator<<(ostream& s,const IsoPlotAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

