import QtQuick 2.0
import UserMetrics 0.1

/**
  To run this example with the qtdeclarative5-usermetrics0.1 package already installed in the system:
  qmlscene examples/metrics_declarative.qml
  To run it after building te source but without the package installed:
  qmlscene -I src/modules examples/metrics_declarative.qml
  both from the root of the code repository.

  To see the changes generated by clicking on the various rectangles in this example
  you either have an libusermetricsoutput client alrady accessing the data somewhere,
  or you can use d-feet or a similar dbus inspector application to look at
  com.lomiri.UserMetrics /com/lomiri/UserMetrics/DataSet/{N} com.lomiri.UserMetrics.DataSet
  and watch how the value of the "data" property varies.
  The {N} placeholder is a number that represents the id of your data set. You can examine all the
  various data sources by looking at:
  com.lomiri.UserMetrics /com/lomiri/UserMetrics/DataSource/{N} com.lomiri.UserMetrics.DataSource
  and find the one that has the property "name" equal to "clicks-example", then use the same {N} to
  for the DataSet.
  **/
Item {
    width: 200
    height: 200

    Metric {
        /**
          Changing the "name" property will bind the Metric to the DataSource of that name,
          as well as set the rest of the properties to the specified values on that DataSource.
          If the DataSource doesn't already exist it will be created.
         **/
        id: clicksMetric
        name: "clicks-example"
        format: "%1 clicks on red rectangle today"
        emptyFormat: "No clicks on red rectangle today yet"
        domain: "metrics-declarative-example"
    }

    Rectangle {
        color: "red"
        anchors.left: parent.left
        anchors.top: parent.top
        height: 100
        width: 100

        Text {
            anchors.centerIn: parent
            text: "Increment"
        }

        MouseArea {
            anchors.fill: parent
            onClicked: clicksMetric.increment();
        }
    }

    Rectangle {
        color: "orange"
        anchors.right: parent.right
        anchors.top: parent.top
        height: 100
        width: 100

        Text {
            anchors.centerIn: parent
            text: "Add 10.5 :)"
        }

        MouseArea {
            anchors.fill: parent
            onClicked: clicksMetric.increment(10.5);
        }
    }

    Rectangle {
        color: "yellow"
        anchors.left: parent.left
        anchors.bottom: parent.bottom
        height: 100
        width: 200

        Text {
            anchors.centerIn: parent
            text: "Reset to zero"
        }

        MouseArea {
            anchors.fill: parent
            onClicked: clicksMetric.update(0);
        }
    }
}
