/*############################################################################*/
/*#                                                                          #*/
/*#  MIT HRTF C Library                                                      #*/
/*#  Filter table for normal set at 44100Hz                                  #*/
/*#  Copyright © 2007 Aristotel Digenis                                      #*/
/*#                                                                          #*/
/*#  Filename:  mit_hrtf_normal_44100.h                                      #*/
/*#  Version:   0.1                                                          #*/
/*#  Date:      04/05/2007                                                   #*/
/*#  Author(s): Aristotel Digenis                                            #*/
/*#  Credit:    Bill Gardner and Keith Martin                                #*/
/*#  Licence:   MIT                                                          #*/
/*#                                                                          #*/
/*############################################################################*/


#include "../mit_hrtf_filter.h"

const mit_hrtf_filter_set_44 normal_44 =
{
    {    // elev-10
        {    // H-10e000a.wav
            {6,-9,21,-31,35,-55,65,-84,81,-88,98,8,4587,6732,-8759,-4087,2448,-5277,6627,10260,2468,6955,16044,746,-11932,1720,-1530,-13711,-4322,1346,-7485,-5198,2168,1744,-413,1519,4593,2711,1892,3655,1260,-1483,96,-21,-2805,-3756,-2559,-3077,-3620,-1860,-1318,-1034,1002,1768,1524,1852,1949,1564,1019,500,267,-157,-917,-970,-1026,-1457,-1407,-1032,-966,-784,-287,38,85,445,771,710,590,489,371,24,-334,-387,-430,-694,-602,-412,-525,-505,-264,-80,-16,105,269,163,133,263,245,90,-27,-105,-317,-429,-441,-415,-370,-290,-144,-38,7,78,88,31,12,16,-13,-35,-69,-143,-174,-168,-146,-109,-62,-67,-41,5,8,59},
            {6,-9,21,-31,35,-55,65,-84,81,-88,98,8,4587,6732,-8759,-4087,2448,-5277,6627,10260,2468,6955,16044,746,-11932,1720,-1530,-13711,-4322,1346,-7485,-5198,2168,1744,-413,1519,4593,2711,1892,3655,1260,-1483,96,-21,-2805,-3756,-2559,-3077,-3620,-1860,-1318,-1034,1002,1768,1524,1852,1949,1564,1019,500,267,-157,-917,-970,-1026,-1457,-1407,-1032,-966,-784,-287,38,85,445,771,710,590,489,371,24,-334,-387,-430,-694,-602,-412,-525,-505,-264,-80,-16,105,269,163,133,263,245,90,-27,-105,-317,-429,-441,-415,-370,-290,-144,-38,7,78,88,31,12,16,-13,-35,-69,-143,-174,-168,-146,-109,-62,-67,-41,5,8,59}
        },
        {    // H-10e005a.wav
            {0,4,-6,15,-23,28,-46,59,-77,81,-91,108,75,4555,5317,-7917,-2566,1460,-4571,6395,8671,2499,6816,14047,556,-9551,1583,-1979,-11788,-3663,461,-6747,-4443,1409,1250,-367,1393,3982,2361,2074,3479,891,-1165,155,-335,-2555,-3054,-2055,-2819,-3092,-1353,-1050,-1178,442,1362,1228,1332,1466,1444,1051,559,325,-181,-780,-760,-956,-1411,-1284,-943,-887,-656,-206,59,68,378,652,573,438,417,340,13,-316,-336,-344,-606,-551,-401,-446,-418,-261,-145,-107,43,209,129,130,251,228,90,-4,-104,-284,-351,-339,-326,-307,-260,-169,-73,-28,25,22,-30,-56,-37,-23,-38,-45,-79,-99,-108,-99,-78,-69,-81,-63,-24,12},
            {-9,24,-33,35,-51,49,-54,30,-16,9,-9,3461,9006,-7315,-7900,3636,-5313,5083,12069,3094,5777,17403,4212,-14314,-183,820,-14437,-6659,2379,-6958,-7062,1975,2610,-394,843,4986,3246,1357,4036,2425,-1597,-223,490,-2517,-4230,-3148,-3404,-4386,-2448,-1192,-1158,785,2141,1887,2148,2375,1935,1177,491,191,-188,-995,-1055,-1007,-1481,-1484,-1046,-1018,-942,-431,12,84,394,810,755,632,575,462,104,-291,-396,-397,-717,-696,-475,-559,-522,-276,-70,-49,88,341,254,150,256,276,100,-45,-93,-313,-463,-514,-496,-440,-325,-149,-16,27,76,134,83,48,49,21,-6,-39,-133,-220,-235,-216,-164,-74,-53,-21,34,28,51,106}
        },
        {    // H-10e010a.wav
            {-5,2,0,-2,8,-15,20,-35,46,-68,74,-87,109,194,4625,3762,-7101,-1330,405,-3317,6121,7140,2690,6773,12266,-19,-7537,1405,-2524,-9971,-3023,-414,-6095,-3717,941,920,-305,1442,3485,2098,2108,3222,705,-1128,-9,-495,-2261,-2540,-1802,-2452,-2522,-1015,-813,-1079,88,901,951,1104,1281,1223,792,377,241,-226,-696,-683,-864,-1232,-1103,-790,-735,-523,-140,116,132,339,510,436,342,306,226,-29,-304,-330,-373,-559,-480,-391,-419,-351,-196,-126,-127,25,196,143,140,212,185,52,-36,-143,-271,-287,-282,-273,-275,-229,-157,-103,-66,-26,-29,-74,-71,-41,-31,-16,-9,-33,-80,-73,-67,-73,-75,-112,-76,-38},
            {19,-25,21,-27,12,6,-54,92,-116,106,2175,10414,-4118,-11903,3414,-4508,3336,13882,3642,4893,18138,7863,-15464,-2905,2558,-14387,-8631,2693,-6200,-8464,1328,3017,131,364,4634,3535,1446,4518,3167,-1347,-420,801,-2290,-4482,-3728,-4003,-5101,-2725,-891,-1397,426,2399,2368,2396,2472,2250,1536,681,152,-296,-1143,-1241,-1018,-1480,-1559,-1127,-1064,-982,-456,49,150,350,795,825,698,557,468,162,-278,-383,-372,-698,-806,-549,-543,-503,-264,-91,-27,59,320,337,210,314,303,123,-75,-136,-312,-486,-534,-564,-505,-377,-187,-22,47,107,179,133,80,75,39,9,-11,-103,-205,-237,-253,-222,-124,-77,-12,76,79,61,96,112}
        },
        {    // H-10e015a.wav
            {-1,-5,2,-2,0,4,-10,12,-24,31,-52,56,-67,79,303,4367,2751,-6083,-874,45,-2343,5272,6155,2764,6310,10838,65,-6062,1159,-2355,-8433,-2806,-954,-5446,-3373,466,747,-306,1258,3163,2058,1994,2639,653,-805,-110,-460,-1923,-2205,-1538,-2001,-2165,-1018,-790,-905,-42,508,789,1014,934,745,523,292,141,-219,-554,-528,-703,-1005,-905,-693,-600,-444,-127,122,156,303,382,339,243,166,93,-90,-300,-325,-362,-511,-432,-344,-377,-323,-170,-78,-57,28,129,111,138,188,118,-8,-73,-144,-247,-280,-269,-257,-243,-214,-160,-108,-85,-63,-61,-67,-71,-43,-29,-14,-3,-39,-62,-61,-51,-60,-86,-133,-125},
            {-1,-11,13,-43,74,-139,178,-222,238,932,10401,1039,-15103,949,-2481,412,15688,5359,3132,18307,12355,-15407,-6785,4388,-13692,-11183,2983,-4777,-10213,616,3579,55,302,3739,3619,2087,4660,3957,-854,-811,1111,-1712,-4700,-4664,-4567,-5214,-2881,-932,-1673,108,2762,2629,2393,2561,2435,1821,930,213,-276,-1119,-1468,-1142,-1530,-1698,-1243,-1072,-1035,-411,146,166,331,886,921,695,557,440,160,-287,-448,-404,-678,-835,-541,-538,-550,-277,-45,-3,40,298,375,225,340,352,147,-94,-183,-327,-504,-524,-577,-542,-423,-238,-79,-17,82,216,191,102,108,78,2,-11,-95,-192,-233,-244,-231,-168,-111,-63,81,140,128,117,73,67}
        },
        {    // H-10e020a.wav
            {-1,-2,-5,1,-2,1,2,-8,9,-18,21,-39,43,-47,50,375,3952,2145,-5151,-658,57,-1824,4379,5481,2647,5710,9726,427,-4914,1060,-1916,-7197,-2772,-1254,-4867,-3314,182,603,-427,1214,3012,1835,1589,2317,749,-496,-5,-316,-1665,-1915,-1233,-1816,-2085,-1081,-749,-713,54,402,447,555,593,542,312,190,162,-93,-379,-399,-564,-855,-761,-539,-505,-396,-86,115,103,246,315,235,134,70,-9,-196,-324,-264,-285,-442,-405,-308,-302,-259,-139,-48,-26,39,115,75,105,152,90,-46,-135,-175,-235,-268,-271,-246,-215,-162,-98,-86,-104,-76,-46,-50,-66,-50,-32,-19,-27,-54,-44,-22,-25,-58,-105,-155},
            {-32,44,-86,114,-170,188,-225,259,116,8638,6965,-15179,-4564,160,-2239,15071,8953,2018,16502,17108,-12393,-12020,4930,-10751,-14191,1326,-1983,-10906,-1799,4657,708,-1220,2925,4776,2175,4101,5015,148,-1550,1178,-691,-4968,-5792,-4667,-4672,-3288,-1575,-1636,126,2729,2686,2309,2629,2559,2039,1099,243,-192,-886,-1544,-1335,-1513,-1882,-1499,-1110,-943,-406,69,260,472,898,978,741,556,429,188,-319,-558,-424,-621,-887,-600,-469,-524,-353,-93,31,94,297,419,241,252,363,200,-83,-210,-338,-531,-540,-527,-525,-458,-294,-132,-51,13,158,197,112,119,126,54,-7,-91,-180,-210,-228,-259,-202,-137,-97,58,163,177,161,113,38,54}
        },
        {    // H-10e025a.wav
            {-3,0,-3,-5,1,-4,1,0,-5,8,-15,15,-29,32,-37,32,393,3474,1804,-4308,-513,159,-1606,3604,4926,2407,5073,8863,914,-3941,1061,-1402,-6253,-2803,-1333,-4536,-3269,40,446,-390,1107,2599,1573,1483,2133,770,-226,284,-129,-1475,-1723,-1253,-1792,-1985,-975,-619,-526,-28,58,134,290,411,378,260,160,215,59,-302,-398,-510,-639,-572,-443,-417,-352,-106,61,54,148,234,183,31,-49,-92,-203,-305,-242,-243,-383,-340,-248,-246,-192,-94,-47,-39,35,108,52,51,90,42,-101,-190,-207,-238,-240,-237,-209,-162,-109,-69,-77,-82,-69,-59,-58,-59,-54,-62,-60,-51,-24,-11,-10,-30,-75,-126},
            {40,-82,102,-123,111,-116,143,-128,5757,11400,-10839,-11359,803,-2705,12174,12087,2659,14350,19967,-6908,-15769,2627,-6968,-14955,-2154,-876,-9375,-3872,4088,1585,-1927,1777,5582,2573,3672,5152,1267,-1420,665,-70,-5015,-6499,-4281,-3930,-4008,-2251,-1435,237,2468,2459,2286,2610,2643,2204,1148,351,-79,-692,-1466,-1432,-1515,-1915,-1722,-1178,-988,-520,127,375,565,929,999,723,606,431,197,-287,-532,-442,-603,-898,-668,-445,-505,-354,-150,4,121,316,483,273,200,325,226,-34,-199,-295,-540,-577,-521,-494,-455,-324,-128,-36,-26,73,157,94,90,118,71,44,-4,-134,-171,-201,-263,-255,-175,-96,23,147,202,217,179,86,33,51}
        },
        {    // H-10e030a.wav
            {-1,-2,-1,-1,-4,1,-1,2,0,-1,7,-12,15,-22,26,-25,25,362,2974,1664,-3518,-429,245,-1525,2942,4400,2122,4480,8118,1523,-3046,1060,-916,-5519,-2741,-1430,-4307,-3041,-4,251,-555,922,2384,1466,1363,1968,897,175,523,-138,-1489,-1732,-1262,-1624,-1689,-827,-675,-778,-206,46,11,126,306,355,237,185,209,23,-248,-314,-381,-505,-426,-357,-405,-357,-144,9,11,93,139,80,-34,-78,-94,-188,-297,-254,-238,-297,-237,-180,-173,-152,-80,-63,-76,-1,70,36,8,26,-46,-148,-178,-196,-203,-192,-178,-173,-131,-70,-54,-67,-86,-73,-55,-56,-71,-83,-84,-55,-13,-4,-13,-18,-58,-105},
            {-38,31,-30,-16,36,-60,21,2703,12847,-2961,-16122,-2329,-1691,8668,13746,4138,12324,21815,-352,-17309,-1189,-4024,-13967,-5134,-1495,-8295,-4939,3584,825,-1528,2029,4688,2931,3914,4914,1852,-820,185,-281,-4905,-6146,-3652,-3865,-4582,-2328,-1269,-169,2192,2398,2063,2506,2666,2194,1177,578,29,-615,-1282,-1426,-1568,-1888,-1763,-1258,-1034,-714,86,484,647,909,951,726,583,426,252,-148,-492,-507,-571,-820,-690,-487,-522,-383,-179,-28,106,285,430,309,198,290,243,26,-151,-252,-491,-592,-584,-556,-470,-320,-123,-15,-2,32,97,38,17,53,41,55,58,-34,-117,-176,-245,-271,-208,-143,-25,105,165,231,241,153,49,30,38}
        },
        {    // H-10e035a.wav
            {-1,-1,-2,-2,-1,-6,0,-1,0,0,-2,4,-11,11,-18,18,-19,19,294,2477,1632,-2763,-413,264,-1455,2346,3832,1906,3915,7427,2215,-2241,1006,-563,-4763,-2686,-1645,-3792,-2703,-459,-67,-397,880,2053,1367,1336,1968,1235,327,230,-354,-1365,-1570,-1115,-1344,-1576,-1109,-895,-680,-234,-26,25,85,243,318,230,110,161,38,-181,-198,-296,-438,-414,-330,-397,-379,-146,-12,-31,9,44,-1,-57,-60,-93,-199,-286,-219,-184,-250,-175,-99,-144,-165,-122,-98,-97,-44,18,-26,-37,-26,-77,-146,-148,-133,-160,-152,-149,-147,-123,-87,-64,-77,-80,-71,-59,-76,-94,-73,-60,-33,-8,-8,-26,-64,-96},
            {-41,69,-135,173,-231,272,470,10877,5912,-15982,-8420,-1288,5705,13850,5896,10544,22255,6757,-15757,-5739,-2607,-11774,-6889,-3255,-7129,-6285,1506,928,-395,1927,3802,3486,3854,4614,2509,148,-945,-1093,-3947,-5344,-3437,-3734,-4825,-2541,-837,-555,1376,2436,2110,2256,2423,2155,1298,679,200,-481,-1112,-1406,-1577,-1886,-1708,-1185,-1089,-897,41,515,568,845,967,673,560,480,309,-24,-428,-520,-564,-710,-677,-459,-485,-444,-236,-79,72,233,347,302,177,262,267,119,-53,-192,-412,-590,-595,-613,-539,-355,-134,9,20,21,87,51,-26,-41,-29,30,117,45,-83,-138,-193,-240,-226,-158,-82,40,131,204,253,209,119,51,30,28}
        },
        {    // H-10e040a.wav
            {0,-1,-1,-2,-1,-3,-4,1,-1,2,1,-2,4,-7,10,-18,21,-15,15,222,1995,1656,-2019,-469,227,-1314,1765,3238,1827,3409,6712,2910,-1442,785,-235,-3910,-2721,-1647,-3327,-2827,-755,54,-233,636,1797,1509,1490,1937,1107,-16,-63,-236,-993,-1308,-1139,-1459,-1669,-1108,-777,-658,-278,-16,82,79,165,253,200,119,129,63,-109,-167,-266,-435,-440,-342,-347,-317,-159,-64,-92,-63,-7,-30,-77,-53,-49,-143,-232,-196,-181,-210,-154,-113,-145,-174,-137,-120,-119,-85,-53,-66,-60,-37,-62,-89,-87,-90,-119,-131,-151,-162,-130,-99,-87,-76,-78,-69,-57,-73,-72,-50,-32,-22,-17,-31,-75,-95},
            {78,-144,171,-201,250,-289,6393,12406,-9740,-14993,-2983,3341,12695,7516,8729,22031,13144,-11873,-9065,-2283,-10245,-6905,-4606,-7026,-7077,-1688,440,485,2566,3353,3344,3993,4923,2702,823,-1291,-2351,-3316,-4118,-3294,-3816,-4572,-2652,-836,-780,792,2158,2009,2239,2192,1959,1354,835,289,-318,-868,-1416,-1617,-1761,-1589,-1223,-1021,-939,-158,479,474,680,916,739,580,473,336,97,-319,-523,-540,-611,-626,-431,-419,-439,-303,-169,8,158,269,292,165,199,249,198,40,-98,-309,-548,-585,-638,-576,-414,-196,-26,11,3,58,106,7,-64,-84,-49,91,91,-27,-113,-178,-206,-200,-177,-113,-16,68,155,233,236,161,102,46,23,32}
        },
        {    // H-10e045a.wav
            {1,0,0,-1,-2,-1,-3,-3,0,-2,1,1,-3,1,-4,2,-11,19,-17,23,138,1545,1676,-1284,-579,145,-1077,1126,2695,1900,2900,5941,3563,-701,484,227,-2947,-2930,-1962,-2844,-2610,-858,125,-174,505,1857,1711,1179,1360,792,-19,90,-14,-841,-1471,-1338,-1351,-1456,-1061,-720,-582,-287,2,73,43,112,212,217,126,114,51,-117,-189,-281,-421,-455,-336,-272,-290,-217,-113,-120,-102,-38,1,-46,-42,-22,-107,-208,-221,-187,-220,-171,-120,-151,-151,-149,-143,-153,-123,-79,-84,-61,-28,-4,-28,-59,-87,-111,-129,-172,-177,-155,-114,-98,-80,-65,-47,-31,-45,-54,-44,-22,-23,-54,-86,-102},
            {-10,-30,63,-103,80,1735,13250,1632,-18241,-8091,1588,10220,9177,6479,20370,19515,-5719,-12211,-2012,-8323,-7450,-4437,-7112,-8009,-5082,82,-215,1961,4257,3850,3205,5318,4195,520,-1501,-2644,-2743,-3988,-3287,-3048,-4435,-3011,-836,-890,52,1921,1914,2046,2060,1872,1457,858,489,-257,-808,-1172,-1538,-1742,-1554,-1200,-927,-907,-403,318,389,558,868,790,544,492,373,185,-226,-487,-468,-573,-547,-404,-354,-431,-334,-187,-102,67,186,281,194,136,218,186,87,-29,-175,-424,-567,-607,-595,-447,-264,-124,-37,-28,37,111,42,-11,-60,-72,18,69,-1,-79,-146,-215,-187,-153,-125,-59,4,92,192,244,205,148,88,26,22,31}
        },
        {    // H-10e050a.wav
            {1,1,0,-1,-1,-2,-2,-2,-4,-2,-1,2,0,-7,5,-6,-3,0,10,-8,20,75,1133,1664,-574,-716,50,-829,536,2249,2008,2422,5126,4095,47,446,654,-2611,-3291,-1762,-2132,-2395,-971,159,123,648,1572,1134,619,1124,973,229,-5,-262,-974,-1414,-1199,-1180,-1301,-933,-602,-569,-274,-25,-10,43,139,190,182,117,65,-5,-127,-225,-314,-400,-417,-330,-282,-285,-214,-112,-111,-88,-13,0,-48,-58,-53,-98,-213,-233,-200,-204,-177,-150,-137,-161,-149,-144,-161,-138,-81,-61,-58,-3,17,-15,-54,-81,-117,-168,-191,-186,-158,-128,-85,-53,-28,-19,-37,-51,-62,-36,-31,-55,-82,-102},
            {-126,179,-247,301,-308,7913,12370,-12596,-16577,-911,7317,10295,4968,15943,24542,3540,-13381,-4431,-4859,-8014,-3982,-6740,-8637,-7732,-1488,-658,207,3927,4281,3680,5242,5368,1314,-1329,-3093,-2342,-3225,-4027,-2945,-3408,-3212,-1642,-846,-404,1377,1878,1789,1941,1772,1619,981,631,-64,-853,-1053,-1277,-1617,-1637,-1265,-916,-804,-656,103,381,432,765,797,554,458,419,226,-91,-394,-419,-527,-561,-394,-312,-384,-377,-233,-147,-22,138,231,227,112,157,182,81,-23,-122,-278,-486,-550,-566,-497,-343,-201,-109,-90,-26,86,93,16,-37,-53,-17,70,0,-103,-144,-210,-209,-162,-111,-78,-41,13,124,228,232,175,117,59,23,22,15}
        },
        {    // H-10e055a.wav
            {1,1,1,1,0,-1,-2,-2,-2,-1,-1,0,3,-3,-2,4,-7,3,4,8,-2,24,22,773,1604,72,-803,-106,-535,53,1846,2076,2016,4361,4573,1040,33,370,-1948,-2959,-1521,-1612,-2099,-866,412,219,73,732,856,776,1140,903,23,-393,-415,-730,-1190,-1147,-948,-1028,-880,-550,-474,-342,-104,26,65,99,157,134,46,20,-27,-171,-294,-309,-358,-401,-323,-241,-217,-175,-79,-80,-108,-54,-34,-71,-83,-85,-117,-180,-203,-203,-216,-202,-143,-120,-146,-136,-133,-143,-118,-71,-60,-58,1,20,-24,-75,-109,-130,-174,-187,-168,-128,-84,-58,-32,-41,-58,-57,-47,-39,-35,-31,-57,-83},
            {-52,88,-134,107,1518,13925,2782,-21381,-8749,5498,9663,5896,9066,25307,14947,-9731,-9060,-2282,-6830,-4088,-5652,-9130,-8617,-4736,-642,-1304,1825,4386,3611,4780,6775,2848,-612,-2553,-2820,-2280,-3987,-3404,-2913,-3079,-2177,-1247,-931,672,1865,1610,1731,1703,1727,1201,707,394,-504,-1172,-1264,-1344,-1522,-1384,-1102,-846,-779,-135,466,322,532,798,663,410,370,352,87,-296,-389,-401,-576,-487,-314,-317,-357,-265,-179,-119,98,248,252,120,69,146,107,12,-96,-219,-400,-489,-489,-480,-389,-267,-187,-141,-86,14,103,61,10,-22,-40,43,64,-55,-165,-226,-241,-195,-125,-65,-38,-17,48,160,234,214,149,77,32,35,32,10}
        },
        {    // H-10e060a.wav
            {1,1,2,2,1,0,1,-1,0,1,1,0,2,4,-2,0,3,-1,6,5,8,12,7,-5,504,1478,600,-830,-267,-265,-259,1433,2063,1953,3939,4514,1213,-167,642,-1114,-2620,-1429,-902,-1402,-924,-107,-317,-316,640,1001,680,646,469,-165,-393,-291,-571,-1005,-940,-757,-850,-739,-545,-456,-304,-98,-1,11,57,51,56,19,-42,-103,-231,-286,-282,-292,-312,-257,-180,-176,-141,-100,-117,-147,-106,-65,-82,-100,-103,-101,-163,-216,-211,-203,-175,-121,-101,-126,-123,-101,-113,-129,-86,-47,-56,-32,-24,-62,-109,-109,-109,-138,-141,-121,-86,-73,-81,-98,-82,-51,-31,-25,-29,-15,-21,-51},
            {84,-126,178,-301,5898,15363,-10272,-21918,771,8923,7678,4419,18602,25054,477,-12488,-3823,-3211,-4467,-3975,-9402,-8690,-7298,-2534,-833,-1340,3382,3898,3333,6304,5489,722,-1151,-2756,-2237,-2827,-3949,-2780,-2931,-2594,-1704,-1427,-416,1416,1670,1554,1600,1610,1472,915,717,132,-902,-1241,-1332,-1472,-1333,-1229,-1030,-866,-505,350,459,296,661,734,491,320,387,303,-65,-378,-367,-489,-575,-396,-309,-313,-300,-190,-124,-16,202,303,228,73,39,90,20,-27,-125,-314,-489,-499,-424,-392,-281,-210,-204,-171,-70,94,97,18,-3,-12,33,61,2,-117,-197,-271,-255,-174,-85,-24,-22,25,105,183,204,164,113,64,38,44,29,21}
        },
        {    // H-10e065a.wav
            {1,2,2,2,1,2,0,1,1,1,1,0,1,3,1,-1,1,2,4,-1,11,13,2,-3,-4,317,1290,950,-728,-428,-64,-386,1073,2352,2083,2635,3842,2173,274,583,-534,-1935,-874,-304,-1481,-1716,-686,-76,-35,287,506,206,156,306,38,-304,-310,-358,-728,-784,-580,-664,-720,-473,-307,-320,-194,-87,-67,-60,-57,-15,-55,-121,-152,-200,-209,-191,-179,-239,-237,-167,-158,-174,-166,-140,-158,-134,-91,-103,-116,-110,-129,-175,-198,-170,-146,-143,-110,-88,-87,-106,-116,-120,-129,-92,-88,-91,-92,-68,-58,-94,-76,-62,-78,-113,-118,-113,-132,-121,-94,-49,-36,-19,-2,0,11,-14},
            {158,-249,333,-67,11205,11204,-21505,-15708,8279,8751,4593,8375,26058,15955,-9524,-9064,-1277,-2432,-2623,-7805,-10219,-7537,-6069,-725,-2000,-295,4177,3066,3796,6341,3260,-133,-1262,-2271,-1503,-3533,-3332,-2482,-2911,-2106,-1796,-1556,241,1573,1432,1411,1323,1682,1365,766,671,-173,-981,-1169,-1485,-1472,-1247,-1125,-910,-778,-285,495,388,375,661,630,416,319,430,227,-234,-371,-387,-620,-512,-324,-290,-320,-232,-125,-92,85,297,318,176,45,41,2,-43,-52,-169,-388,-530,-483,-407,-302,-205,-198,-223,-142,-13,116,76,-19,-23,11,88,59,-71,-185,-240,-245,-221,-157,-38,-12,-22,43,147,187,159,111,80,68,70,65,26,20}
        },
        {    // H-10e070a.wav
            {1,1,1,1,1,1,1,0,1,-1,1,1,-1,0,3,-1,-1,3,0,1,5,13,-1,3,8,-6,187,1110,1098,-567,-510,80,-83,1079,1790,1450,2168,3833,2880,527,564,437,-857,-1004,-900,-1816,-1681,-300,9,-606,-514,23,23,63,322,109,-196,-163,-177,-465,-607,-521,-504,-515,-407,-347,-381,-309,-216,-186,-196,-155,-88,-91,-142,-113,-78,-92,-114,-161,-217,-222,-191,-194,-199,-164,-148,-186,-175,-136,-118,-134,-143,-136,-138,-130,-110,-107,-121,-100,-66,-90,-127,-139,-147,-158,-152,-119,-112,-101,-56,-41,-57,-52,-46,-86,-129,-147,-147,-119,-83,-60,-57,-30,15,32,31,5},
            {142,-230,253,1107,15436,3491,-27671,-6977,12117,6601,3135,15218,27473,4427,-12929,-4678,385,-734,-4012,-10541,-9360,-7282,-3866,-637,-2933,1415,3979,2328,4380,5484,1282,-470,-1190,-1133,-1472,-3391,-2521,-2787,-2612,-1788,-2119,-1470,653,1368,1130,1009,1350,1868,1135,755,625,-388,-919,-1084,-1561,-1452,-1071,-986,-905,-803,-34,469,232,439,656,580,359,407,449,77,-345,-348,-450,-627,-448,-315,-281,-282,-168,-111,-70,189,371,308,124,-6,12,-24,-46,-83,-243,-458,-529,-450,-382,-268,-180,-217,-197,-69,53,104,26,-41,-37,29,72,18,-112,-203,-248,-227,-175,-102,-6,-30,-56,19,137,189,147,79,60,69,106,97,47,11}
        },
        {    // H-10e075a.wav
            {0,0,0,0,0,1,1,1,1,0,0,0,-1,0,1,1,-1,1,0,1,5,2,3,3,17,-6,-2,147,914,1032,-327,-247,589,-177,-12,1528,1967,2047,3318,3195,1385,1144,802,-1063,-1684,-978,-1009,-1218,-910,-861,-1121,-791,-137,-21,6,312,312,22,-53,-33,-280,-470,-359,-317,-465,-483,-400,-466,-450,-370,-303,-269,-209,-108,-81,-69,-14,21,-48,-108,-148,-220,-230,-192,-167,-192,-203,-200,-217,-196,-171,-148,-132,-115,-97,-70,-77,-89,-76,-89,-106,-96,-111,-175,-197,-186,-175,-159,-114,-84,-83,-50,-42,-68,-63,-56,-91,-138,-134,-99,-67,-59,-65,-50,11,61,44,2},
            {69,-112,42,2808,17715,-4538,-29207,632,13210,4266,3602,21509,24146,-4862,-12286,-871,2087,-360,-5973,-11579,-9045,-6119,-2471,-1925,-2459,2585,3041,1944,4845,4350,-13,-755,-875,-273,-1530,-2756,-1879,-2769,-2508,-1833,-2097,-1267,546,968,730,753,1485,1805,960,879,576,-489,-845,-1008,-1455,-1296,-954,-913,-981,-809,81,331,110,461,659,493,339,493,428,-83,-374,-316,-503,-595,-385,-305,-309,-253,-119,-111,-27,263,373,262,60,-52,-26,-2,-10,-126,-333,-519,-523,-426,-357,-258,-199,-234,-165,-22,100,109,-21,-83,-68,-7,32,-8,-115,-198,-232,-205,-145,-56,-6,-96,-122,-20,113,175,130,73,45,86,136,107,59,8}
        },
        {    // H-10e080a.wav
            {-1,-1,-1,0,0,0,1,1,1,1,-1,0,-1,1,0,0,0,-2,2,3,1,-1,1,13,4,10,7,-2,129,736,962,482,63,-452,-452,493,1674,1985,1881,3103,3993,2255,409,-187,-877,-886,-436,-1030,-1931,-1819,-1189,-1081,-887,-364,-15,196,433,446,186,39,22,-54,-269,-329,-333,-468,-535,-499,-566,-584,-459,-347,-289,-225,-95,-19,16,42,23,-28,-116,-151,-175,-194,-185,-201,-222,-258,-243,-234,-214,-160,-130,-94,-74,-48,-47,-61,-55,-70,-101,-143,-149,-165,-211,-202,-180,-162,-143,-94,-77,-100,-78,-64,-56,-51,-63,-80,-82,-63,-58,-57,-58,-47,-17,31,33,-22},
            {-13,16,-159,4343,18471,-10638,-28397,5712,13079,2640,4887,25689,19219,-10944,-10104,2584,3144,-1034,-6796,-12540,-8642,-4399,-2561,-3039,-1717,3430,1966,1434,5297,3499,-921,-774,-473,-257,-1276,-1908,-1611,-2377,-2123,-2174,-2170,-821,337,248,393,732,1378,1594,987,935,509,-431,-718,-904,-1226,-1061,-905,-902,-999,-757,20,138,62,490,607,392,322,545,401,-132,-327,-299,-513,-550,-315,-294,-335,-233,-86,-91,44,305,323,185,21,-51,-24,17,21,-128,-375,-550,-527,-413,-317,-220,-219,-256,-137,27,144,124,-56,-138,-94,-21,25,-23,-101,-161,-175,-151,-137,-62,-49,-136,-137,-25,103,145,128,83,70,117,168,135,82,22}
        },
        {    // H-10e085a.wav
            {0,0,0,0,0,0,1,1,1,1,1,0,1,0,0,2,1,-2,4,4,0,-4,9,9,4,6,25,-22,10,228,982,1286,-98,-675,20,342,625,1367,2173,2687,3390,3306,1242,-392,219,530,-490,-1320,-1864,-2193,-1880,-1264,-1121,-957,-272,213,337,469,505,272,149,162,25,-266,-375,-347,-474,-608,-627,-612,-581,-481,-364,-299,-201,-58,45,35,18,63,-3,-78,-125,-150,-190,-222,-221,-282,-291,-235,-188,-173,-147,-89,-56,-41,-47,-41,-48,-84,-91,-125,-172,-185,-181,-187,-184,-170,-167,-152,-105,-79,-96,-84,-48,-33,-23,-14,-15,-19,-35,-46,-51,-51,-43,-35,-20,-44},
            {-56,85,-260,5073,18616,-13708,-27474,8241,12790,1928,5831,27507,15297,-14455,-7850,5652,3541,-1793,-6866,-13360,-8161,-3073,-3057,-3919,-1301,3945,1174,1005,5159,3139,-1202,-823,-118,-392,-1220,-1254,-1062,-2192,-1738,-1966,-2407,-855,422,-182,-260,655,1337,1295,925,1008,502,-419,-478,-673,-1065,-876,-796,-867,-1034,-696,-53,-66,-50,491,551,271,286,553,410,-103,-275,-256,-493,-511,-261,-286,-327,-218,-58,-91,63,320,272,124,-9,-48,-27,22,54,-115,-365,-557,-532,-393,-311,-199,-229,-258,-123,49,151,69,-84,-139,-87,-10,16,-24,-89,-107,-130,-145,-158,-106,-77,-163,-123,-11,83,127,114,93,78,142,202,163,112,29}
        },
        {    // H-10e090a.wav
            {0,0,0,0,1,1,1,1,1,1,1,0,1,2,0,2,0,-3,5,6,-5,2,9,15,-8,19,-2,-5,16,377,986,324,-148,243,368,395,330,779,2008,3207,2736,1665,1451,941,722,1139,396,-1361,-2093,-1901,-1906,-1834,-1430,-1006,-604,-120,243,389,455,493,379,248,102,-70,-263,-367,-396,-547,-661,-608,-563,-557,-494,-393,-272,-176,-58,9,70,93,64,10,-85,-111,-160,-222,-263,-268,-239,-246,-202,-175,-153,-106,-79,-54,-70,-71,-77,-70,-91,-119,-125,-181,-184,-169,-188,-211,-212,-163,-130,-92,-79,-92,-46,-6,23,33,32,13,-16,-40,-67,-82,-87,-87,-85,-76},
            {-35,43,-210,4646,18785,-13363,-27809,8584,12850,1880,5902,27387,13814,-16257,-6565,8329,3927,-2412,-6603,-13714,-8075,-2299,-3347,-4575,-1509,4180,829,536,4865,2840,-1233,-507,-21,-496,-999,-1173,-612,-1737,-1591,-1710,-2130,-1071,115,-224,-559,159,1101,1252,746,909,580,-337,-327,-394,-839,-765,-693,-773,-1008,-714,-87,-195,-274,387,524,200,206,536,422,-70,-208,-184,-454,-496,-215,-261,-313,-214,-47,-115,32,302,247,88,-47,-75,-48,28,74,-91,-335,-518,-521,-392,-314,-218,-220,-245,-143,-7,102,45,-104,-120,-63,13,34,-10,-79,-126,-143,-169,-167,-123,-112,-173,-119,21,77,98,102,83,79,143,227,183,134,46}
        },
        {    // H-10e095a.wav
            {1,0,2,1,1,1,1,1,2,2,2,1,2,2,2,2,1,0,4,4,-3,-1,18,8,7,-1,-12,1,214,864,440,-566,-184,819,960,450,438,1051,2185,2524,2076,1257,111,801,1889,1487,582,-528,-1631,-1960,-1635,-1672,-1730,-1248,-663,-390,-140,190,358,453,457,348,213,-12,-149,-248,-377,-459,-524,-569,-565,-519,-521,-501,-416,-300,-162,-33,82,90,58,51,3,-54,-162,-199,-203,-207,-206,-224,-213,-188,-149,-124,-115,-117,-115,-104,-89,-64,-76,-106,-105,-126,-170,-208,-222,-224,-208,-159,-130,-121,-89,-47,-17,15,52,69,57,25,-19,-61,-91,-107,-122,-127,-114,-101},
            {54,-109,26,3115,18684,-9263,-29417,6494,13599,2222,5112,25517,15035,-16349,-7060,10460,5102,-2790,-6319,-13507,-8419,-2106,-3383,-4740,-2533,4017,1195,-169,4385,2973,-1293,-407,456,-522,-848,-1104,-478,-1519,-1226,-1396,-2118,-904,11,-596,-684,14,577,1012,738,801,541,-255,-178,-195,-600,-561,-597,-731,-895,-695,-167,-251,-462,206,463,173,133,479,460,-57,-148,-91,-374,-478,-170,-203,-298,-214,-80,-115,6,253,211,64,-53,-101,-77,20,97,-27,-288,-481,-475,-366,-310,-232,-250,-292,-191,-36,68,31,-109,-111,-10,61,80,4,-104,-180,-189,-165,-167,-123,-101,-170,-128,27,103,81,84,79,78,139,226,206,134,54}
        },
        {    // H-10e100a.wav
            {1,0,0,0,1,1,1,1,0,1,0,0,2,0,2,2,0,2,0,2,-1,-1,14,4,23,-24,-21,97,803,799,-645,-618,425,683,905,924,958,1936,2198,1483,1055,1054,184,-592,1075,2034,1044,40,-732,-1377,-1529,-1350,-1419,-1339,-985,-559,-412,-236,186,291,298,335,280,103,-117,-213,-218,-305,-415,-468,-500,-463,-499,-568,-543,-412,-224,-106,-36,25,65,51,26,-33,-104,-100,-114,-151,-198,-207,-179,-197,-195,-170,-171,-177,-160,-122,-106,-83,-64,-71,-106,-145,-163,-222,-234,-204,-193,-170,-137,-88,-83,-48,16,36,62,69,47,-12,-49,-81,-122,-137,-141,-143,-145,-112},
            {190,-330,387,1066,17124,-1610,-30496,1111,14949,2911,3645,22073,18033,-13997,-9490,11448,7466,-2562,-6258,-12777,-9059,-2420,-3280,-4476,-3916,2903,2305,-741,3341,3290,-819,-625,661,28,-635,-1298,-238,-1312,-1405,-856,-1949,-1141,217,-519,-1158,-189,499,661,452,794,636,-317,-191,57,-420,-418,-401,-637,-843,-699,-176,-233,-575,-6,383,128,68,379,477,-8,-152,-21,-256,-436,-134,-118,-265,-222,-96,-124,-56,196,185,22,-77,-104,-89,15,112,43,-224,-431,-418,-304,-277,-298,-337,-359,-216,-31,38,15,-84,-76,26,86,88,-6,-108,-196,-220,-186,-150,-109,-77,-144,-145,6,115,115,75,67,78,134,220,204,126,43}
        },
        {    // H-10e105a.wav
            {1,1,0,2,1,1,1,0,-1,1,0,0,2,0,2,0,0,4,-2,4,-7,11,-1,20,-1,-6,-7,620,1179,-358,-1065,93,730,696,598,1253,2320,2442,1498,685,553,599,11,-833,-429,893,1479,946,115,-518,-960,-1030,-998,-1061,-1081,-967,-705,-415,-189,-22,86,166,211,123,-7,-131,-126,-108,-259,-338,-355,-430,-522,-544,-515,-455,-351,-257,-167,-60,26,25,-13,15,41,1,-66,-105,-138,-174,-179,-190,-238,-270,-225,-178,-179,-158,-121,-93,-66,-70,-131,-195,-179,-155,-177,-199,-196,-154,-98,-55,-41,-45,-8,50,66,37,-15,-53,-81,-91,-128,-158,-156,-147,-123,-99},
            {281,-459,621,-440,13194,7833,-28249,-8304,15887,4874,1588,17542,21463,-8728,-13228,10255,11041,-1097,-6337,-12077,-9797,-3079,-3224,-4065,-4842,747,3532,-435,1738,3384,-68,-612,571,266,-85,-1228,-392,-797,-1656,-905,-1430,-1182,44,-181,-1117,-695,179,748,244,312,749,-103,-396,95,-134,-282,-224,-459,-743,-763,-253,-93,-561,-305,270,119,12,237,475,112,-174,1,-105,-361,-155,-35,-203,-244,-142,-119,-137,113,184,15,-106,-110,-56,19,106,92,-123,-353,-385,-286,-302,-358,-373,-379,-272,-72,59,61,-30,-82,9,52,66,19,-87,-189,-231,-171,-147,-113,-52,-93,-147,-36,114,140,96,59,67,121,196,209,113,32}
        },
        {    // H-10e110a.wav
            {1,2,1,1,3,1,2,0,1,1,0,3,0,1,4,-2,7,0,4,0,2,2,12,12,0,-12,406,1371,158,-1355,-276,651,678,659,998,2131,3026,2045,535,344,499,5,-619,-885,-939,-422,694,1395,1178,451,-161,-462,-556,-725,-975,-1160,-1026,-612,-503,-439,-180,-52,-29,42,91,60,-13,-27,-38,-133,-272,-379,-442,-457,-450,-481,-480,-417,-276,-155,-82,-6,53,69,75,67,29,-28,-96,-132,-166,-236,-273,-278,-270,-214,-167,-156,-151,-103,-93,-136,-159,-165,-147,-129,-126,-152,-158,-106,-55,-27,-23,-18,-13,8,9,-19,-58,-93,-93,-99,-126,-155,-148,-110,-81,-66},
            {194,-286,375,-584,7074,14972,-18950,-19453,12868,8987,-183,11462,23342,-258,-15717,5780,14408,2035,-5731,-11529,-10733,-3706,-3264,-4056,-4918,-1772,3455,1026,337,2771,730,-387,671,316,104,-781,-422,-428,-1657,-1191,-1247,-1090,-59,-106,-888,-724,-302,500,486,-6,432,154,-373,-96,-39,-178,-77,-289,-585,-749,-382,3,-345,-511,34,131,-25,89,373,231,-168,-52,30,-249,-192,30,-125,-251,-206,-115,-188,-41,148,59,-81,-133,-65,16,120,150,-27,-261,-415,-376,-300,-331,-362,-425,-345,-112,101,131,-6,-138,-79,43,51,19,-58,-139,-204,-184,-145,-130,-46,-43,-133,-75,83,155,118,57,32,86,177,206,116,21}
        },
        {    // H-10e115a.wav
            {0,1,1,2,1,1,1,0,1,1,1,2,-1,3,1,1,3,2,3,2,3,0,17,3,3,188,1437,831,-1552,-789,699,669,522,951,2293,3307,2239,668,351,276,35,-613,-1114,-1073,-1064,-802,-130,877,1579,1419,854,327,-144,-460,-818,-1094,-1040,-1019,-861,-699,-557,-363,-247,-121,85,206,148,98,50,10,-105,-244,-321,-396,-444,-508,-561,-510,-416,-257,-90,-25,15,70,94,115,90,12,-42,-103,-187,-256,-275,-288,-289,-249,-187,-161,-173,-179,-167,-154,-137,-141,-131,-111,-93,-81,-85,-57,-46,-32,-16,-23,-37,-68,-87,-102,-97,-106,-118,-119,-127,-111,-94,-74,-62,-54},
            {-50,127,-218,213,1506,15382,-3487,-25966,2666,13659,859,4084,21521,10238,-14264,-1586,15630,6762,-3966,-10225,-12275,-4714,-2777,-4678,-4672,-3519,1693,2511,199,1586,1206,-135,846,608,85,-502,-435,124,-1402,-1592,-1123,-1221,-284,127,-741,-756,-361,93,480,51,195,156,-321,-195,-14,-280,-72,-76,-388,-634,-481,-12,-141,-497,-202,72,-52,-25,212,268,-103,-116,94,-92,-217,7,-65,-223,-241,-175,-211,-169,66,102,-14,-134,-114,10,146,189,29,-265,-453,-411,-282,-307,-383,-428,-358,-127,64,89,-27,-140,-120,-4,20,-3,-16,-71,-178,-222,-164,-115,-63,-14,-100,-116,27,136,124,42,6,38,145,206,134,6}
        },
        {    // H-10e120a.wav
            {1,1,1,1,1,0,1,0,-1,1,0,0,1,2,2,2,0,6,-2,11,-10,23,-11,32,51,1262,1584,-1376,-1565,610,863,462,740,2304,3889,2850,631,12,188,153,-807,-1425,-1132,-1204,-1072,-729,-250,414,1094,1752,1801,1177,378,-295,-680,-713,-1012,-1322,-1194,-953,-847,-697,-465,-227,38,240,251,163,217,155,30,-105,-209,-308,-467,-553,-596,-558,-419,-255,-167,-131,-25,88,124,114,89,53,-28,-84,-132,-228,-293,-297,-281,-253,-238,-220,-234,-220,-166,-128,-127,-134,-94,-62,-38,-24,-22,-30,-28,-22,-39,-69,-102,-127,-148,-161,-141,-131,-134,-102,-62,-54,-55,-39,-26,-30},
            {-168,284,-391,472,-570,8858,10429,-20329,-12537,13200,6353,-1462,13920,19259,-6376,-9191,12291,12437,-1127,-7822,-12522,-7787,-1801,-4737,-5213,-4141,-707,2653,1051,907,1284,-49,648,1339,217,-438,-563,321,-446,-1834,-1301,-1179,-759,128,-322,-854,-415,-60,361,126,61,240,-230,-425,-1,-213,-343,-27,-134,-398,-514,-110,26,-375,-359,22,-47,-133,26,249,45,-153,71,81,-190,-113,-13,-164,-250,-250,-213,-209,-25,104,48,-56,-90,-14,117,147,11,-199,-374,-413,-324,-302,-353,-340,-312,-218,-73,16,6,-69,-131,-64,9,22,5,-48,-136,-207,-173,-97,-55,-10,-40,-126,-43,93,119,57,14,26,103,187,169,42}
        },
        {    // H-10e125a.wav
            {3,2,2,2,1,0,1,-1,1,1,1,1,3,1,4,-2,11,-5,13,-7,19,-6,33,0,962,2206,-796,-2405,273,1129,481,574,2259,4349,3518,914,-78,-49,-82,-800,-1637,-1667,-1366,-1025,-888,-535,80,320,667,1534,2035,1645,898,55,-341,-574,-968,-1320,-1424,-1222,-1050,-950,-692,-203,-16,57,288,395,331,186,113,41,-138,-257,-456,-574,-516,-449,-418,-399,-272,-118,-9,23,89,125,70,25,-7,-21,-77,-192,-271,-310,-292,-278,-304,-298,-239,-182,-167,-137,-97,-63,-46,-28,0,20,21,2,-24,-50,-92,-129,-168,-188,-177,-185,-181,-142,-92,-48,-20,-12,-10,-3,-3,-15},
            {-4,-17,70,-136,115,1681,13438,-3467,-21894,2475,12451,-460,2878,20298,7372,-11513,3495,16142,4239,-6136,-9741,-10809,-3662,-2879,-5956,-4801,-2604,1387,1755,807,1514,383,-221,1543,1242,-409,-748,-18,424,-1192,-1641,-1230,-1060,-287,-68,-681,-531,-130,190,328,1,201,71,-521,-316,-3,-367,-290,-72,-151,-374,-267,84,-110,-439,-124,48,-154,-163,133,227,-79,-33,170,-64,-263,-58,-84,-235,-266,-202,-205,-118,91,129,39,-32,-51,-38,51,88,-40,-282,-440,-382,-248,-239,-296,-341,-336,-182,10,43,-36,-121,-73,35,37,-5,-51,-89,-142,-136,-90,-66,-13,6,-101,-116,38,123,89,51,52,70,145,193,113}
        },
        {    // H-10e130a.wav
            {1,2,1,0,0,-1,-1,1,-1,0,-2,3,0,3,-2,7,-5,7,-5,7,8,12,9,619,2582,152,-3126,-455,1437,627,410,2160,4862,4232,1101,-63,-127,-202,-834,-2086,-2105,-1533,-1379,-1065,-491,49,248,417,885,1248,1424,1586,1099,580,134,-638,-997,-1150,-1371,-1453,-1318,-1022,-667,-414,-97,107,334,414,278,239,200,73,-137,-261,-327,-364,-445,-493,-493,-442,-256,-133,-89,-5,45,43,17,57,67,8,-81,-168,-263,-323,-325,-348,-331,-290,-236,-192,-162,-111,-58,-12,-7,-9,23,43,33,10,-43,-122,-179,-213,-220,-215,-216,-196,-154,-97,-55,-35,-19,13,30,11,-12,-12},
            {91,-154,218,-266,323,-430,6315,10555,-14378,-13484,10349,6753,-3305,10451,18477,-2969,-6328,12926,11988,-3468,-7729,-9405,-7819,-2610,-4740,-5799,-3985,-831,1873,940,1275,1559,-258,233,1953,688,-812,-635,423,-104,-1450,-1325,-1255,-908,-166,-417,-703,-145,88,332,248,70,214,-217,-601,-176,-117,-395,-240,-128,-240,-333,-62,125,-244,-368,-26,-28,-170,-46,226,100,-80,83,46,-298,-241,-45,-191,-269,-209,-158,-144,41,170,73,-45,-142,-125,38,137,17,-222,-370,-368,-248,-222,-350,-403,-342,-217,-81,1,-13,-55,-66,-5,30,-9,-37,-63,-98,-112,-81,-83,-76,-23,-76,-148,-40,109,115,71,65,63,103,153,130}
        },
        {    // H-10e135a.wav
            {3,2,1,0,-1,1,0,0,-1,-1,3,1,3,-2,6,4,-4,9,-11,27,-10,45,325,2665,1318,-3496,-1539,1614,907,303,2068,5334,5000,1374,-63,-234,-372,-732,-2252,-2677,-1990,-1552,-1176,-898,-7,557,352,850,1277,881,834,1001,1054,881,221,-391,-920,-1091,-1200,-1470,-1477,-1014,-608,-429,-114,167,262,250,304,299,114,7,-9,-125,-220,-313,-404,-460,-476,-393,-258,-198,-137,-62,-48,-25,63,132,90,-11,-87,-193,-303,-319,-327,-340,-323,-267,-228,-176,-121,-81,-49,10,46,31,40,48,30,-33,-112,-195,-254,-273,-246,-207,-182,-150,-109,-65,-31,-19,-13,6,30,27,7,-16},
            {-45,64,-108,155,-235,274,281,9775,3338,-17783,-3605,11409,481,-1305,15870,12077,-6755,2201,15888,4080,-7412,-6853,-8355,-5796,-3278,-5680,-5298,-2843,436,1520,667,1804,1275,-426,943,1666,110,-834,-269,334,-676,-1313,-1141,-1365,-846,-221,-662,-508,113,312,427,184,182,99,-404,-464,-123,-276,-379,-184,-187,-372,-331,59,73,-323,-281,9,-36,-69,122,212,-54,-119,58,-127,-390,-208,-132,-247,-200,-85,-83,-74,88,47,-95,-111,-76,-14,46,33,-95,-241,-335,-356,-303,-336,-374,-347,-300,-185,-47,21,-16,-58,-44,19,23,-21,-46,-75,-100,-99,-97,-123,-113,-83,-114,-94,52,131,109,77,61,69,95,106}
        },
        {    // H-10e140a.wav
            {4,1,0,0,-1,-1,2,0,-2,3,2,0,3,-4,14,-12,17,-22,36,-29,75,130,2494,2493,-3405,-2842,1539,1279,235,1995,5843,5791,1610,12,-187,-719,-800,-2247,-3088,-2340,-1859,-1507,-1067,-110,491,368,969,1464,1041,722,492,414,763,554,141,-167,-597,-988,-1292,-1389,-1123,-882,-611,-346,-145,116,171,192,211,195,167,107,-81,-146,-150,-221,-323,-441,-373,-292,-323,-283,-191,-118,-75,-5,100,120,48,-42,-134,-255,-283,-296,-320,-312,-270,-212,-199,-166,-110,-61,-9,17,53,72,62,32,-46,-133,-216,-261,-274,-245,-207,-176,-148,-115,-65,-29,-23,-32,-22,7,27,18,-8,-21},
            {-38,29,-37,24,-15,-14,-45,2086,10411,-3556,-15598,3449,8155,-3319,3265,17233,6000,-5190,9265,13028,-3008,-7372,-5593,-7707,-4760,-4077,-6129,-4619,-1602,1146,926,762,2207,807,69,1424,993,-306,-551,58,-45,-1088,-1144,-1109,-1474,-721,-401,-785,-164,324,389,495,316,240,-5,-372,-288,-198,-439,-319,-160,-245,-446,-320,22,-97,-299,-67,102,3,50,184,84,-179,-102,6,-291,-409,-157,-137,-187,-86,-30,-128,-109,59,34,-48,-91,-93,-15,76,22,-178,-326,-363,-313,-283,-374,-399,-335,-224,-98,1,26,-19,-29,8,66,19,-37,-53,-82,-116,-126,-115,-146,-124,-78,-97,-17,134,167,98,56,61,70,92}
        },
        {    // H-10e145a.wav
            {1,0,-2,-2,-2,0,-1,-4,-3,4,-4,2,-10,13,-17,18,-27,35,-38,78,33,2180,3509,-2889,-4190,1181,1705,185,1914,6437,6607,1775,85,5,-1010,-1029,-2344,-3515,-2586,-1994,-1786,-1371,-401,660,416,686,1676,1378,758,599,296,208,41,28,26,-176,-442,-905,-1189,-929,-693,-770,-602,-294,-37,-20,-7,195,263,125,51,-35,-95,-82,-143,-231,-267,-269,-287,-356,-358,-225,-165,-151,-88,26,68,-18,-53,-67,-191,-257,-261,-275,-280,-231,-213,-225,-186,-109,-59,-51,-2,34,61,56,6,-71,-170,-246,-272,-257,-216,-172,-151,-153,-133,-85,-37,-32,-45,-44,-34,5,10,-23,-41,-38},
            {36,-66,69,-86,97,-124,142,-204,3980,8937,-7992,-11002,6526,3484,-3769,7468,15812,2429,-1026,12592,7168,-6756,-5383,-5075,-7455,-4176,-4823,-6198,-3625,-677,1379,358,1069,2317,641,746,1513,348,-486,-138,103,-491,-1401,-1033,-1186,-1531,-673,-582,-661,79,423,496,533,465,427,-13,-352,-232,-348,-470,-273,-242,-368,-442,-278,-141,-235,-154,143,119,-3,84,153,10,-203,-140,-133,-332,-268,-105,-161,-188,-113,-79,-120,2,90,-30,-107,-82,-34,-10,-8,-100,-210,-282,-338,-335,-350,-399,-363,-266,-154,-65,21,42,11,4,42,53,-21,-54,-78,-122,-139,-124,-131,-162,-122,-76,-50,70,161,119,61,66,69,60}
        },
        {    // H-10e150a.wav
            {0,-3,-2,-3,-1,-2,-3,-4,4,-4,5,-12,13,-17,15,-26,31,-31,56,10,1807,4281,-1986,-5434,482,2179,204,1731,7077,7556,1845,106,371,-1233,-1335,-2400,-4023,-3006,-2007,-1951,-1605,-612,646,414,617,1764,1466,849,739,405,230,-128,-426,-382,-466,-386,-400,-712,-650,-506,-529,-491,-443,-189,-111,-58,169,141,-45,10,9,-109,-140,-140,-112,-214,-264,-192,-250,-290,-204,-156,-163,-147,-46,-35,-94,-104,-110,-201,-218,-184,-217,-219,-209,-208,-238,-177,-72,-51,-26,6,9,8,-2,-34,-129,-203,-238,-266,-252,-194,-133,-111,-110,-116,-102,-56,-33,-62,-70,-56,-29,-3,-22,-64,-77,-55},
            {-17,34,-64,69,-96,113,-160,189,-111,5350,6606,-9795,-6390,6174,-152,-1964,9852,13446,1610,3324,11978,1324,-7095,-3368,-5355,-7109,-4245,-5199,-5656,-2773,49,974,1,1647,2323,604,1198,1487,23,-452,70,-87,-957,-1447,-1017,-1425,-1537,-653,-670,-493,307,545,571,622,684,532,-3,-305,-239,-427,-477,-289,-366,-495,-479,-182,-85,-275,-201,97,129,99,93,57,-66,-158,-86,-198,-331,-196,-115,-204,-152,-55,-73,-108,-14,14,-54,-52,-73,-94,-39,-43,-134,-222,-277,-348,-364,-340,-351,-295,-219,-120,-23,48,65,28,17,35,14,-49,-66,-88,-122,-138,-143,-143,-152,-98,-50,-5,100,133,101,73,67,48}
        },
        {    // H-10e155a.wav
            {-1,-1,-2,1,1,-2,-3,5,-3,8,-11,13,-14,13,-19,19,-7,27,23,1483,4759,-882,-6370,-537,2592,368,1505,7658,8665,1910,-72,883,-1295,-1742,-2450,-4442,-3573,-2096,-2054,-1845,-769,753,560,376,1742,1758,865,667,510,274,-46,-376,-707,-862,-632,-627,-792,-369,50,-198,-344,-263,-95,37,24,-42,-48,-98,-59,-60,-229,-192,-131,-163,-263,-259,-120,-118,-185,-89,-24,-129,-189,-107,-49,-136,-217,-181,-222,-242,-162,-157,-187,-182,-178,-212,-169,-30,36,34,19,0,-30,-85,-129,-158,-186,-246,-269,-229,-180,-125,-90,-70,-66,-53,-43,-51,-64,-70,-75,-65,-25,-23,-66,-96,-92,-60},
            {4,-9,20,-45,55,-86,107,-153,182,128,6069,4387,-9565,-3309,3969,-1621,320,10301,11621,2938,5971,8620,-2293,-5378,-2484,-5912,-6615,-4738,-5294,-4317,-2312,70,615,25,2219,2138,746,1351,1401,227,-422,-214,-248,-1195,-1486,-1116,-1726,-1427,-721,-707,-177,507,651,683,747,832,491,-60,-140,-182,-515,-525,-386,-437,-492,-424,-166,-160,-292,-192,-34,31,156,151,25,-122,-100,-25,-227,-325,-126,-56,-136,-142,-120,-152,-142,-16,-23,-68,-50,-51,-107,-105,-94,-154,-215,-277,-301,-314,-326,-320,-264,-172,-80,6,45,41,38,20,25,-20,-58,-75,-104,-121,-146,-136,-154,-142,-73,-22,26,89,113,86,71,52}
        },
        {    // H-10e160a.wav
            {-4,-3,-1,-1,-2,-5,4,-4,6,-10,8,-11,5,-12,3,6,9,28,1252,4988,196,-6869,-1768,2784,687,1292,8151,9793,2124,-410,1290,-1116,-2162,-2557,-4799,-4180,-2253,-2138,-2139,-977,838,799,408,1670,1808,933,737,515,193,-195,-446,-404,-799,-1004,-997,-1155,-650,52,159,22,0,396,444,-26,-125,-7,-125,-259,-267,-307,-289,-279,-284,-324,-286,-91,-81,-92,71,90,-49,-149,-72,-65,-209,-256,-229,-271,-283,-193,-210,-229,-163,-161,-192,-127,32,87,59,71,3,-102,-168,-170,-171,-222,-249,-267,-243,-178,-120,-102,-97,-57,-24,0,-12,-61,-89,-92,-77,-57,-49,-85,-126,-129,-103,-56},
            {5,-4,2,5,-27,34,-64,84,-123,145,404,6247,2782,-8297,-2147,1652,-1276,1792,9623,11136,5019,6037,4717,-3130,-3514,-2659,-6125,-6367,-5070,-4979,-3176,-1888,-486,479,550,2235,1971,1082,1337,1228,626,-264,-782,-538,-1025,-1572,-1477,-1853,-1408,-738,-508,124,551,703,865,868,800,469,-16,-159,-154,-457,-542,-498,-384,-376,-449,-345,-361,-341,-127,-7,-25,31,100,98,-68,-101,-22,-74,-130,-93,-162,-221,-165,-140,-185,-187,-82,-43,-42,-49,-118,-158,-121,-83,-115,-198,-243,-270,-283,-331,-306,-212,-135,-65,-27,17,51,50,19,-8,-49,-77,-88,-110,-126,-143,-143,-152,-124,-49,-18,19,66,80,84,67}
        },
        {    // H-10e165a.wav
            {-4,0,0,-3,-6,3,-5,5,-8,6,-9,0,-8,-7,11,1,27,1106,5072,1093,-6940,-2942,2602,1098,1189,8503,10903,2469,-689,1495,-873,-2439,-2717,-5045,-4828,-2516,-2144,-2392,-1304,828,1049,499,1726,1956,984,692,599,-32,-406,-210,-425,-920,-1029,-991,-1319,-1036,-294,-182,110,675,829,571,342,254,108,-216,-391,-389,-517,-511,-435,-399,-392,-354,-173,-43,-1,126,169,42,-43,-13,-13,-158,-268,-258,-298,-324,-260,-276,-320,-240,-131,-93,-68,14,82,97,78,-20,-124,-154,-153,-190,-249,-267,-269,-237,-192,-141,-111,-106,-83,-42,2,14,-19,-56,-66,-81,-87,-89,-99,-126,-159,-161,-112,-13},
            {-4,9,-11,11,-7,-9,11,-34,50,-80,94,660,6077,1945,-6942,-2443,295,-166,2095,8957,11845,6316,4222,2112,-2350,-2549,-3106,-6085,-6301,-5099,-4159,-2786,-1842,-319,172,957,2286,1766,1307,1451,1211,512,-166,-738,-946,-1237,-1370,-1749,-2013,-1320,-616,-211,229,562,709,944,1046,782,321,28,-68,-259,-424,-349,-337,-414,-543,-590,-510,-440,-381,-189,-10,70,59,-7,42,84,134,84,-76,-160,-159,-191,-222,-210,-196,-211,-200,-123,-64,-62,-94,-139,-113,-68,-65,-91,-164,-214,-273,-293,-290,-253,-179,-135,-82,-29,39,66,32,7,-32,-69,-90,-89,-91,-132,-139,-135,-129,-104,-57,-20,4,65,94,86}
        },
        {    // H-10e170a.wav
            {-3,1,-2,-6,2,-4,5,-9,7,-9,-1,-8,-5,5,1,23,1028,5094,1706,-6723,-3809,2115,1373,1281,8748,11882,2976,-892,1628,-704,-2652,-2864,-5226,-5389,-2898,-2178,-2585,-1589,733,1157,556,1845,2171,1221,709,209,50,-206,-414,-535,-1043,-1192,-1006,-1204,-1173,-682,-231,218,388,736,1079,862,556,320,29,-305,-570,-709,-705,-622,-554,-539,-477,-211,-22,-17,117,234,141,-8,23,131,-18,-203,-242,-322,-380,-327,-313,-379,-291,-140,-101,-53,52,111,42,-8,-36,-82,-94,-132,-180,-231,-261,-268,-258,-204,-166,-133,-117,-92,-48,-18,2,-19,-26,-25,-51,-87,-106,-114,-140,-163,-178,-154,-58,42},
            {4,-5,12,-13,16,-14,5,-9,-7,16,-32,42,864,5760,1729,-6081,-3335,72,703,1785,8909,12763,6330,2009,1107,-1309,-2355,-3437,-5910,-6259,-4880,-3334,-2553,-2212,-159,809,822,1951,2004,1436,1478,1123,380,-365,-615,-802,-1603,-1647,-1503,-1836,-1395,-506,-17,271,458,841,1079,905,674,368,67,-15,-103,-291,-333,-400,-497,-700,-755,-593,-511,-426,-182,31,129,120,122,174,158,125,64,-98,-255,-225,-155,-193,-288,-286,-234,-186,-120,-87,-93,-74,-64,-68,-61,-58,-86,-149,-201,-250,-289,-284,-226,-159,-119,-88,-33,29,57,27,-19,-64,-80,-73,-81,-91,-119,-136,-141,-126,-94,-61,-35,17,91,104}
        },
        {    // H-10e175a.wav
            {0,-1,-6,2,-4,5,-9,7,-12,1,-13,-1,0,4,13,1006,5124,2026,-6381,-4299,1515,1385,1449,8983,12643,3718,-931,1580,-481,-2826,-3111,-5302,-5832,-3381,-2242,-2685,-1921,608,1303,546,1784,2558,1335,523,598,160,-551,-531,-538,-1135,-1384,-1169,-1417,-1257,-347,-42,-86,251,749,1029,955,830,677,242,-155,-418,-680,-808,-774,-749,-726,-588,-338,-130,-57,120,237,166,94,116,177,88,-68,-183,-326,-408,-356,-301,-340,-311,-214,-163,-79,20,61,33,6,-26,-95,-105,-90,-130,-192,-233,-259,-272,-227,-177,-147,-131,-100,-57,-20,13,-10,-35,-33,-38,-56,-94,-119,-132,-157,-173,-165,-96,0,54},
            {-6,5,-6,10,-14,16,-16,8,-18,5,-6,1,4,991,5443,1848,-5859,-4059,483,1061,1561,9141,13177,5527,347,1081,-645,-2520,-3511,-5695,-6197,-4394,-2765,-2599,-2258,-92,1204,1120,1485,1957,1801,1341,885,285,-502,-735,-660,-1335,-1842,-1659,-1432,-1171,-616,-93,310,573,773,933,857,608,459,313,163,-34,-354,-538,-592,-635,-770,-804,-653,-490,-339,-102,124,195,184,237,266,184,26,-75,-203,-261,-203,-229,-295,-291,-216,-250,-244,-114,-42,-28,-38,-38,-57,-82,-55,-91,-135,-192,-257,-279,-272,-202,-148,-111,-91,-48,9,24,19,-29,-60,-74,-71,-63,-94,-113,-147,-142,-132,-113,-48,-8,46,88}
        },
        {    // H-10e180a.wav
            {0,-6,3,-4,7,-10,12,-15,6,-16,4,-6,7,0,1026,5227,2017,-6056,-4351,1001,1213,1538,9182,13071,4540,-573,1368,-416,-2712,-3401,-5462,-6033,-3890,-2437,-2688,-2142,252,1291,845,1763,2115,1480,1252,691,78,-527,-636,-683,-1182,-1452,-1612,-1621,-988,-329,-195,87,452,749,864,824,781,676,435,123,-229,-555,-688,-736,-758,-827,-778,-521,-297,-179,-1,190,227,187,209,234,127,-16,-113,-276,-370,-295,-249,-293,-314,-243,-206,-189,-74,11,22,-3,-36,-70,-91,-75,-108,-152,-206,-260,-273,-245,-183,-148,-124,-104,-64,-8,18,3,-34,-48,-57,-59,-70,-105,-130,-143,-153,-159,-112,-28,25,55},
            {0,-6,3,-4,7,-10,12,-15,6,-16,4,-6,7,0,1026,5227,2017,-6056,-4351,1001,1213,1538,9182,13071,4540,-573,1368,-416,-2712,-3401,-5462,-6033,-3890,-2437,-2688,-2142,252,1291,845,1763,2115,1480,1252,691,78,-527,-636,-683,-1182,-1452,-1612,-1621,-988,-329,-195,87,452,749,864,824,781,676,435,123,-229,-555,-688,-736,-758,-827,-778,-521,-297,-179,-1,190,227,187,209,234,127,-16,-113,-276,-370,-295,-249,-293,-314,-243,-206,-189,-74,11,22,-3,-36,-70,-91,-75,-108,-152,-206,-260,-273,-245,-183,-148,-124,-104,-64,-8,18,3,-34,-48,-57,-59,-70,-105,-130,-143,-153,-159,-112,-28,25,55}
        }
    },
    {    // elev-20
        {    // H-20e000a.wav
            {5,-8,19,-22,27,-46,46,-51,36,-44,45,13,3688,7158,-7481,-7205,1978,-4401,4622,10998,4979,3542,13675,9486,-8974,-3592,147,-10860,-6417,2107,-5741,-7291,89,1780,-60,738,4375,3486,1545,2411,769,-2287,-1589,-1469,-3444,-3779,-2357,-1131,-1542,-770,1178,931,937,1781,1529,1019,902,745,241,-551,-733,-634,-1193,-1165,-731,-970,-899,-304,-106,-35,185,519,471,361,398,240,3,-181,-301,-416,-537,-486,-295,-376,-379,-170,-148,-190,-28,98,126,120,142,68,-51,-133,-139,-97,-133,-98,-26,-57,-124,-55,-40,-132,-67,9,-147,-226,-221,-219,-139,-21,-13,-100,-74,-10,2,-58,-183,-257,-250,-279,-303,-256,-314,-427},
            {5,-8,19,-22,27,-46,46,-51,36,-44,45,13,3688,7158,-7481,-7205,1978,-4401,4622,10998,4979,3542,13675,9486,-8974,-3592,147,-10860,-6417,2107,-5741,-7291,89,1780,-60,738,4375,3486,1545,2411,769,-2287,-1589,-1469,-3444,-3779,-2357,-1131,-1542,-770,1178,931,937,1781,1529,1019,902,745,241,-551,-733,-634,-1193,-1165,-731,-970,-899,-304,-106,-35,185,519,471,361,398,240,3,-181,-301,-416,-537,-486,-295,-376,-379,-170,-148,-190,-28,98,126,120,142,68,-51,-133,-139,-97,-133,-98,-26,-57,-124,-55,-40,-132,-67,9,-147,-226,-221,-219,-139,-21,-13,-100,-74,-10,2,-58,-183,-257,-250,-279,-303,-256,-314,-427}
        },
        {    // H-20e005a.wav
            {-6,7,-8,15,-12,14,-23,12,-6,-16,18,-25,33,1957,6824,-3053,-8513,390,-3989,843,9884,6717,3680,9991,11650,-3375,-4689,284,-8049,-7879,902,-2931,-6847,-1907,845,301,5,2811,3359,1297,1925,1679,-996,-1386,-863,-2203,-3079,-2443,-1928,-1729,-828,420,505,618,1278,1421,1210,835,546,440,-96,-587,-446,-745,-1061,-831,-733,-821,-467,-189,-191,24,335,284,221,343,259,101,-19,-184,-309,-407,-447,-319,-347,-372,-278,-197,-167,-58,49,97,139,148,62,-51,-113,-125,-66,-74,-91,-38,-22,-109,-88,-30,-83,-133,-142,-253,-276,-164,-85,-26,-7,-38,-63,11,35,-50,-192,-315,-325,-280,-341,-338,-353,-436},
            {-9,20,-19,17,-27,14,-1,-34,43,-62,51,2304,8818,-4245,-11301,1862,-3773,2095,12687,6534,2505,12758,14088,-8171,-7263,1549,-9965,-9124,2386,-4133,-9093,-1038,1854,257,646,4235,4301,1989,2787,1585,-2511,-2431,-1405,-3590,-4529,-2791,-1097,-1498,-1100,1181,1356,1084,1975,1772,1080,922,807,414,-385,-844,-766,-1338,-1410,-805,-886,-1062,-467,-68,27,244,551,612,494,515,337,-42,-261,-345,-447,-608,-623,-339,-365,-367,-155,-97,-162,-44,124,143,117,87,43,-24,-100,-153,-142,-177,-152,-29,-14,-113,-62,-29,-105,-71,67,-31,-174,-184,-253,-240,-111,-31,-73,-77,-54,-39,-23,-100,-218,-235,-229,-246,-232,-244,-434,-464}
        },
        {    // H-20e010a.wav
            {-4,-3,5,-5,13,-15,16,-29,25,-28,12,-17,26,18,2576,5678,-4408,-6242,295,-3878,2155,8655,5693,3832,9913,9298,-3209,-3015,-893,-7657,-5834,411,-3546,-5597,-1398,498,90,380,2557,2407,962,1567,1257,-684,-956,-712,-1707,-2226,-1924,-1836,-1680,-750,196,77,286,957,1144,901,621,523,494,35,-333,-282,-633,-838,-650,-685,-750,-425,-313,-291,-34,200,131,149,304,237,122,31,-124,-259,-336,-365,-345,-375,-371,-302,-237,-164,-9,74,112,131,157,64,-56,-117,-142,-90,-111,-108,-49,-29,-74,-60,-40,-124,-191,-220,-285,-214,-84,-30,-31,-42,-39,-9,55,-3,-150,-267,-342,-352,-350,-348,-311,-330},
            {10,-3,-1,5,-32,57,-95,114,-143,142,1070,8992,641,-14210,-724,-1915,-790,13520,8936,1965,10778,17994,-5022,-11259,1634,-8268,-11261,1802,-2204,-10307,-3017,1744,1090,688,3594,4925,2339,3107,2668,-2248,-3648,-1980,-3034,-4373,-3464,-1702,-1309,-1128,1129,1609,902,2086,2214,1254,800,737,484,-263,-846,-739,-1234,-1681,-1022,-886,-1082,-487,-67,4,259,642,688,515,569,382,25,-199,-319,-480,-682,-738,-428,-339,-447,-201,-31,-121,-36,147,200,153,91,29,-51,-91,-153,-141,-185,-188,-87,-37,-118,-101,-1,-81,-83,94,102,-32,-92,-204,-296,-219,-106,-85,-59,-63,-92,-56,-28,-137,-219,-220,-196,-180,-188,-313,-539,-465}
        },
        {    // H-20e015a.wav
            {-3,-4,-1,2,-4,9,-12,12,-28,26,-38,26,-31,43,61,2928,4436,-4819,-4480,-42,-3382,2808,7477,4831,3947,9476,7679,-2626,-2418,-1476,-6601,-4574,-59,-3667,-4653,-1230,152,-66,526,2377,1608,357,1434,1253,-482,-602,-358,-1208,-1618,-1414,-1557,-1725,-998,-93,-220,-130,490,805,759,675,678,551,67,-109,-109,-549,-715,-521,-587,-698,-513,-394,-319,-107,93,47,81,233,252,134,7,-112,-189,-277,-329,-325,-429,-395,-256,-184,-124,-20,94,122,130,102,-8,-77,-159,-153,-120,-95,-69,-9,24,-72,-78,-94,-189,-266,-270,-245,-145,-19,-12,-58,-52,-3,55,39,-91,-246,-326,-367,-373,-345,-297,-259},
            {17,-24,33,-67,87,-119,123,-154,172,233,7530,6098,-14062,-5929,40,-3099,12491,12173,2497,7941,20320,629,-14665,-12,-5820,-12887,421,53,-11033,-5960,2017,2214,417,2921,5249,2504,3092,3906,-1475,-5069,-2781,-1957,-3661,-4193,-2648,-1194,-749,890,1608,785,1882,2537,1568,736,538,492,-151,-875,-673,-978,-1771,-1326,-838,-1031,-648,-84,42,325,651,729,502,513,426,124,-144,-316,-448,-644,-782,-536,-388,-513,-280,-31,-99,-53,165,211,204,169,71,-98,-152,-147,-111,-150,-231,-150,-75,-159,-163,-38,-64,-77,106,171,57,46,-77,-263,-270,-170,-166,-109,-35,-103,-118,-53,-70,-157,-213,-197,-147,-158,-194,-429,-601,-454}
        },
        {    // H-20e020a.wav
            {-1,-1,-5,0,1,-3,6,-9,9,-23,24,-36,32,-32,40,142,3040,3328,-4674,-3174,-375,-2810,3057,6332,4167,4060,8963,6559,-2365,-1990,-1405,-5700,-3643,-428,-3639,-3966,-1219,-57,-121,570,1774,857,314,1583,1150,-365,-109,117,-759,-1302,-1211,-1338,-1631,-1233,-655,-663,-326,310,664,814,767,686,540,155,31,-90,-459,-542,-406,-556,-686,-526,-430,-335,-182,-21,-4,110,217,169,98,-4,-83,-144,-266,-328,-326,-340,-310,-200,-133,-109,-9,49,83,64,3,-62,-111,-134,-111,-54,-47,-13,41,-14,-94,-107,-151,-278,-310,-249,-184,-49,6,-37,-59,-1,55,54,-22,-184,-300,-348,-357,-347,-300,-232},
            {-28,37,-69,69,-83,57,-74,78,-54,4945,10186,-9786,-12099,150,-3877,9438,15062,4624,5388,20160,7922,-15796,-3816,-3228,-13298,-1837,1845,-10943,-8690,1768,2902,998,1894,4983,3024,2786,4523,-549,-5794,-3581,-655,-2920,-4929,-3319,-1162,-489,627,1469,694,1663,2618,1773,700,356,486,-14,-809,-758,-805,-1691,-1457,-721,-960,-865,-174,70,315,665,684,465,555,528,133,-145,-302,-411,-577,-794,-634,-387,-508,-421,-127,-72,-48,146,181,195,233,151,-74,-195,-187,-120,-106,-219,-195,-136,-191,-260,-139,-67,-75,102,215,127,124,44,-168,-259,-215,-223,-178,-53,-88,-162,-134,-75,-93,-168,-241,-169,-130,-122,-236,-605,-637,-351}
        },
        {    // H-20e025a.wav
            {-1,2,-1,-4,1,-1,1,3,-4,5,-14,20,-30,33,-28,27,225,2952,2459,-4199,-2266,-668,-2248,2986,5273,3743,4170,8385,5478,-2097,-1331,-1255,-4861,-2933,-818,-3502,-3483,-1175,-115,-290,106,1090,747,708,1575,968,13,477,369,-706,-1152,-1072,-1221,-1660,-1605,-1114,-764,-200,356,629,668,687,666,521,202,70,-39,-352,-378,-348,-587,-674,-502,-413,-390,-228,-50,-19,80,165,109,19,-14,-72,-150,-244,-269,-244,-253,-215,-181,-158,-107,-39,-9,-14,-25,-33,-72,-88,-81,-25,10,-2,2,10,-44,-130,-158,-227,-317,-308,-207,-98,-11,-12,-51,-16,55,78,18,-113,-257,-321,-305,-328,-346,-264},
            {16,-31,18,-2,-42,53,-77,52,2304,11405,-2411,-16183,-2891,-3201,5382,16273,7765,4262,18044,14756,-13370,-8814,-1914,-12195,-4047,1912,-9773,-10059,425,2627,2061,1678,3897,3496,2783,4114,-11,-5094,-3797,-459,-2134,-4835,-3764,-1378,-469,228,1445,795,1242,2522,1870,837,183,345,172,-611,-899,-759,-1458,-1475,-675,-819,-933,-249,82,171,522,695,538,542,609,231,-75,-293,-441,-529,-709,-675,-414,-482,-476,-212,-80,-39,137,172,169,265,183,-42,-179,-155,-128,-92,-183,-203,-133,-187,-306,-252,-134,-83,80,271,193,149,178,-27,-214,-233,-227,-230,-80,-40,-155,-177,-119,-70,-87,-225,-240,-132,-87,-56,-392,-729,-557,-166}
        },
        {    // H-20e030a.wav
            {-1,-1,0,-2,-4,1,-2,1,0,-2,3,-11,13,-22,28,-26,17,277,2738,1860,-3569,-1722,-885,-1734,2658,4419,3558,4207,7542,4503,-1485,-732,-1121,-4026,-2543,-1157,-3219,-2969,-1206,-536,-643,-184,887,949,981,1491,1055,497,609,196,-677,-992,-1077,-1405,-1749,-1603,-1076,-562,-54,238,397,509,555,603,554,216,54,3,-214,-330,-372,-548,-606,-475,-409,-375,-257,-112,-53,15,63,71,10,-57,-77,-97,-171,-224,-232,-236,-204,-148,-133,-151,-112,-60,-59,-64,-56,-67,-64,-23,47,51,-3,-48,-38,-63,-139,-223,-306,-340,-267,-122,-51,-44,-48,-6,57,76,28,-74,-205,-283,-267,-280,-362,-372},
            {13,-51,77,-127,141,-193,215,439,9467,5816,-15614,-8762,-2582,1565,15209,10933,4777,14961,19963,-7157,-13434,-2523,-10446,-5985,823,-7390,-10774,-2077,2350,2439,1786,3308,3921,2354,3262,372,-3566,-3247,-1386,-1799,-3816,-3622,-1942,-806,-125,1164,1072,970,2140,1822,1074,288,127,168,-456,-947,-729,-1121,-1491,-805,-642,-806,-330,42,29,377,642,504,486,626,373,40,-175,-444,-570,-649,-678,-403,-453,-550,-318,-99,-23,81,188,157,240,202,-1,-180,-191,-154,-77,-75,-173,-175,-188,-282,-302,-227,-141,11,234,277,206,233,84,-144,-205,-213,-267,-162,-43,-91,-158,-158,-106,-64,-148,-262,-193,-119,-2,-92,-611,-734,-418,32}
        },
        {    // H-20e035a.wav
            {-1,-2,-2,-1,-3,-5,0,-4,-1,0,-3,-1,-8,8,-18,20,-22,3,302,2454,1524,-2934,-1485,-941,-1367,2214,3859,3474,4041,6497,3934,-703,-370,-874,-3325,-2394,-1204,-2792,-2972,-1591,-613,-692,-341,890,1196,1173,1563,1128,457,478,128,-630,-1057,-1260,-1365,-1509,-1275,-737,-509,-296,17,261,384,475,534,486,202,75,35,-160,-249,-342,-474,-494,-458,-433,-402,-278,-154,-108,-49,25,68,11,-26,-67,-98,-165,-236,-238,-202,-135,-113,-139,-159,-142,-102,-75,-70,-78,-61,-7,38,74,31,-30,-48,-27,-60,-194,-297,-331,-299,-184,-80,-64,-50,0,46,74,41,-64,-166,-218,-229,-242,-315,-406},
            {-60,82,-116,99,-124,142,-156,5415,11483,-9106,-15083,-3796,-1109,12056,13266,5934,12399,22485,1775,-15531,-4688,-8894,-8390,66,-4734,-10795,-5073,1408,2648,1969,2548,4624,2101,1983,953,-2129,-2441,-2082,-1912,-2939,-3103,-2136,-1264,-564,570,1166,872,1795,1678,1278,578,-42,169,-287,-966,-959,-764,-1273,-1055,-613,-612,-351,-6,-23,228,573,461,333,573,474,175,-83,-340,-481,-633,-710,-495,-363,-525,-393,-194,-64,52,183,168,188,201,59,-153,-235,-213,-122,-35,-79,-121,-189,-289,-321,-245,-204,-101,139,294,251,258,187,-18,-168,-224,-271,-231,-115,-97,-97,-127,-130,-84,-99,-216,-232,-173,-82,77,-263,-775,-657,-284,250}
        },
        {    // H-20e040a.wav
            {1,0,0,-1,0,-1,-4,1,-1,1,1,-1,0,-3,7,-11,20,-19,2,294,2175,1402,-2434,-1389,-879,-1156,1858,3507,3367,3630,5507,3752,-35,-70,-562,-2784,-2166,-1380,-2891,-2843,-1393,-632,-846,-300,1162,1477,1156,1261,933,486,409,-49,-766,-1121,-1032,-975,-1141,-994,-726,-704,-494,-51,155,225,364,461,406,165,135,76,-88,-153,-262,-429,-488,-455,-464,-402,-280,-197,-152,-67,19,33,19,-28,-103,-158,-197,-193,-161,-131,-126,-120,-150,-168,-154,-135,-97,-72,-53,-43,7,46,43,14,-9,-14,-32,-110,-252,-331,-315,-240,-118,-73,-77,-36,28,57,20,-48,-134,-178,-190,-212,-280,-364},
            {-3,9,-57,75,-117,95,1552,11895,1526,-17682,-8372,-2301,7286,14435,7308,9994,22684,11713,-13887,-7989,-7058,-11202,-913,-2167,-9984,-7651,-378,1979,2121,2446,4373,2130,1299,1962,-1260,-2146,-1856,-1968,-2525,-2809,-2034,-1660,-910,151,820,547,1572,1740,1131,961,230,18,-200,-662,-1111,-928,-1089,-990,-662,-596,-369,36,6,17,468,477,262,465,507,217,18,-192,-401,-534,-664,-630,-403,-433,-359,-244,-153,-7,175,165,103,187,132,-95,-239,-237,-175,-91,-59,-46,-113,-210,-324,-294,-239,-154,28,220,263,249,248,106,-35,-170,-300,-295,-191,-158,-124,-60,-85,-110,-71,-134,-217,-207,-155,22,46,-497,-814,-533,-138,454}
        },
        {    // H-20e045a.wav
            {1,0,-1,-1,-2,-1,-3,-4,1,-2,1,0,-2,1,-5,7,-10,16,-21,-2,261,1929,1379,-2091,-1360,-753,-1026,1627,3257,3116,3089,4729,3732,532,284,-206,-2569,-2478,-1477,-2417,-2475,-1361,-767,-781,128,1385,1174,755,1027,913,462,147,-318,-631,-625,-629,-791,-1044,-1016,-803,-761,-586,-203,22,143,247,376,364,180,174,151,9,-133,-240,-410,-501,-437,-421,-412,-340,-217,-164,-116,3,23,-50,-90,-110,-127,-156,-121,-99,-127,-136,-153,-180,-188,-145,-117,-108,-78,-47,-23,-13,15,41,38,29,-4,-61,-190,-303,-305,-240,-169,-130,-103,-80,-9,28,-5,-37,-90,-135,-173,-201,-239,-305},
            {70,-135,156,-197,240,-185,7300,10999,-12233,-15699,-3706,2742,13153,9373,7599,20208,20540,-6617,-12113,-5940,-12134,-3099,-608,-8050,-9213,-3127,973,1845,2336,3313,2670,945,2732,284,-2108,-1754,-1768,-1857,-2748,-2288,-1885,-1248,-272,593,264,800,1866,1167,1065,573,285,-25,-583,-928,-1013,-1108,-1184,-647,-468,-466,-107,106,-35,222,468,274,376,579,279,22,-94,-271,-455,-641,-637,-465,-432,-360,-194,-146,-101,80,155,79,127,124,-23,-190,-211,-215,-139,-84,-69,-49,-108,-203,-321,-308,-197,-37,130,190,230,286,189,48,-49,-198,-324,-272,-230,-222,-97,-30,-65,-69,-73,-140,-194,-188,-96,98,-99,-691,-746,-414,29,561}
        },
        {    // H-20e050a.wav
            {1,0,0,0,-1,-1,-1,-1,-2,1,-1,1,0,-1,4,-6,6,-7,17,-26,7,218,1731,1395,-1887,-1314,-603,-897,1528,2972,2725,2589,4205,3785,1170,598,-550,-2678,-2154,-1112,-1992,-2234,-1413,-675,-355,282,935,738,566,918,796,236,73,-27,-133,-267,-614,-954,-1058,-938,-854,-830,-635,-318,-69,95,204,290,330,242,243,223,22,-145,-224,-357,-459,-460,-459,-429,-358,-244,-176,-111,-54,-44,-56,-66,-46,-67,-101,-98,-91,-131,-191,-184,-171,-163,-146,-119,-94,-79,-40,-23,-12,23,72,81,30,-41,-137,-237,-262,-228,-196,-185,-157,-97,-39,-10,-19,-29,-50,-99,-157,-195,-211,-252},
            {3,-51,72,-116,89,1536,12668,1889,-19692,-9832,-111,8797,11917,6188,15067,25394,6573,-13481,-7713,-10531,-6588,222,-5439,-9438,-6560,-479,1241,2057,1963,2479,1130,2914,2399,-1590,-1513,-1538,-1359,-2407,-2597,-2169,-1948,-739,220,376,87,1403,1420,1080,905,425,364,-216,-705,-1094,-966,-1242,-1038,-549,-412,-243,-12,-26,47,438,276,245,578,517,156,-85,-230,-373,-555,-667,-564,-392,-381,-262,-127,-68,0,86,51,88,140,14,-150,-216,-206,-184,-102,-79,-47,-76,-131,-224,-289,-270,-142,39,151,177,232,251,132,38,-95,-253,-292,-259,-290,-222,-77,-39,-59,-57,-70,-124,-178,-164,-9,103,-328,-799,-645,-265,228,559}
        },
        {    // H-20e055a.wav
            {1,1,0,2,0,0,0,-1,0,-2,2,1,2,2,1,4,-6,9,-2,9,-20,16,175,1583,1361,-1749,-1248,-415,-722,1433,2599,2288,2295,3918,3946,1332,221,-581,-2171,-1717,-767,-1679,-2042,-1160,-503,-437,-49,574,556,321,664,750,466,431,299,-12,-429,-773,-942,-988,-968,-848,-838,-707,-332,-102,7,131,293,380,300,289,213,10,-125,-203,-350,-506,-514,-476,-423,-342,-247,-199,-163,-69,0,-22,-36,-24,-15,-59,-117,-142,-160,-161,-175,-205,-207,-148,-85,-69,-68,-45,-8,35,64,75,33,-30,-80,-158,-219,-232,-204,-182,-185,-131,-65,-47,-41,-27,-22,-84,-154,-187,-190,-215},
            {-102,121,-164,199,-283,6008,13317,-10623,-19659,-3327,4112,11704,7647,8758,23836,19617,-6816,-12349,-7915,-8609,-950,-2652,-8576,-8919,-3314,608,1556,1135,1276,1391,1783,4193,647,-1644,-1072,-688,-1602,-3103,-2287,-2208,-1709,-528,349,-62,467,1480,1123,1048,596,570,261,-207,-721,-959,-1046,-1232,-851,-606,-459,-152,35,-134,204,398,182,396,637,447,96,-176,-323,-464,-622,-632,-468,-347,-311,-206,-85,-11,80,67,-14,94,116,-59,-243,-248,-198,-124,-70,-29,-17,-99,-188,-242,-239,-209,-87,68,154,182,236,176,97,48,-121,-281,-278,-273,-308,-187,-62,-55,-72,-75,-57,-82,-135,-122,41,22,-500,-788,-547,-105,336,471}
        },
        {    // H-20e060a.wav
            {3,0,1,1,1,0,1,0,-1,1,-1,2,1,3,2,2,4,-4,10,-6,12,-14,17,165,1441,1250,-1622,-1133,-222,-521,1309,2181,2004,2352,3539,3239,1400,563,-386,-1700,-1315,-435,-1209,-1747,-1378,-878,-478,-106,213,107,158,910,1183,763,440,78,-186,-405,-787,-964,-962,-965,-859,-803,-664,-417,-187,23,211,335,367,315,277,206,-15,-177,-243,-411,-527,-526,-458,-389,-349,-259,-191,-124,-41,1,-20,0,12,-22,-79,-114,-130,-171,-211,-241,-230,-193,-118,-54,-46,-48,-12,31,42,35,16,-21,-44,-102,-184,-213,-186,-158,-161,-149,-111,-82,-64,-39,-39,-91,-148,-176,-187,-200},
            {-114,166,-239,277,250,11266,7896,-20562,-14065,1944,7274,10806,5307,16037,26852,7610,-13505,-9663,-7175,-3831,-127,-6455,-10026,-6801,-796,607,892,643,846,749,3078,3621,-202,-922,-455,-249,-2299,-3110,-2445,-2115,-1511,-510,60,-160,958,1193,1013,816,603,632,279,-107,-696,-791,-1051,-1115,-871,-742,-490,-162,-83,-69,322,206,190,584,643,337,17,-174,-358,-515,-644,-571,-401,-342,-307,-177,-44,33,92,8,10,115,54,-156,-282,-228,-177,-100,-41,19,-1,-123,-225,-274,-229,-163,-35,105,133,158,202,135,93,30,-145,-270,-277,-305,-293,-148,-66,-75,-110,-97,-42,-51,-91,-82,45,-138,-638,-717,-405,58,353,386}
        },
        {    // H-20e065a.wav
            {1,2,1,1,1,1,0,1,1,2,0,0,3,3,2,1,5,2,-3,7,3,8,-12,25,186,1298,1055,-1453,-1002,-29,-256,1120,2014,1966,1650,2662,3315,1933,805,-265,-1260,-574,75,-1314,-2231,-1621,-723,-472,-594,-278,198,735,1315,1185,514,125,24,-112,-445,-835,-969,-971,-928,-786,-778,-691,-412,-100,125,225,301,346,307,253,121,-105,-246,-285,-429,-526,-479,-416,-355,-320,-231,-162,-98,-31,-2,5,10,18,-9,-60,-132,-191,-234,-256,-220,-197,-152,-80,-37,-25,-15,10,6,5,2,-9,-26,-72,-140,-180,-144,-118,-135,-141,-137,-123,-92,-67,-78,-108,-133,-164,-190,-211},
            {-48,68,-104,50,2199,14890,-1381,-25126,-6222,5186,8528,8366,6983,23443,22584,-4213,-14160,-6902,-4838,-43,-2544,-9215,-9677,-4542,245,-1,291,644,442,452,3859,2766,-331,-443,494,-105,-2915,-2919,-2546,-2108,-1460,-592,-429,74,1062,884,851,661,792,718,392,-55,-581,-666,-933,-1018,-959,-811,-563,-306,-249,67,305,21,279,664,628,239,-12,-115,-328,-551,-611,-483,-405,-388,-307,-143,-23,55,39,-36,51,135,-49,-241,-260,-176,-140,-95,2,40,-4,-124,-278,-314,-235,-107,10,98,108,131,164,99,96,-3,-155,-218,-267,-347,-296,-124,-65,-99,-126,-107,-43,-36,-70,-53,-7,-293,-709,-629,-247,178,332,313}
        },
        {    // H-20e070a.wav
            {0,1,1,1,1,1,0,1,0,0,2,0,1,2,3,1,2,4,0,0,7,5,-4,4,28,250,1123,771,-1212,-861,209,123,1197,1418,912,1507,2855,3446,2158,898,171,-354,-218,-537,-1795,-2207,-1471,-912,-946,-754,123,785,936,1114,828,270,103,36,-159,-541,-906,-985,-899,-827,-772,-730,-598,-281,-13,107,201,273,318,234,138,8,-193,-289,-345,-405,-430,-411,-372,-347,-292,-203,-125,-82,-29,16,11,18,-1,-41,-105,-193,-250,-253,-196,-168,-173,-151,-84,-26,-14,-19,-19,-13,-6,-7,-11,-45,-105,-144,-124,-80,-99,-154,-166,-141,-112,-119,-124,-120,-137,-164,-201,-221},
            {52,-86,117,-241,5031,15774,-10896,-24690,725,6499,8246,6590,11563,27311,14053,-11399,-11770,-4864,-1305,1175,-5934,-10218,-8594,-2893,-80,-532,542,382,-406,1186,4143,1722,-245,63,1306,-184,-2908,-2892,-2563,-2024,-1539,-936,-707,293,804,704,697,727,959,763,551,20,-360,-621,-862,-874,-887,-849,-742,-518,-373,158,169,-86,363,693,574,201,66,-41,-283,-502,-525,-446,-423,-428,-306,-109,-37,23,-11,-50,93,98,-116,-247,-186,-108,-111,-50,47,50,-34,-150,-319,-326,-181,-73,5,69,106,162,128,44,61,19,-88,-163,-282,-379,-265,-102,-63,-109,-128,-96,-40,-26,-65,-63,-61,-404,-714,-539,-115,282,320,286}
        },
        {    // H-20e075a.wav
            {0,1,1,2,1,1,1,1,2,2,2,2,1,1,2,3,0,3,5,4,-2,5,5,0,12,52,346,855,478,-870,-578,795,286,-52,793,1283,1853,2897,3336,2372,1492,719,-480,-807,-882,-1804,-2263,-1741,-1131,-702,-133,536,779,716,796,628,208,55,-4,-311,-701,-876,-857,-806,-780,-691,-606,-441,-193,-25,96,177,232,232,122,-3,-116,-248,-298,-277,-324,-378,-367,-344,-299,-253,-165,-83,-36,-14,-31,-14,1,-36,-108,-165,-190,-209,-195,-172,-169,-177,-154,-82,-20,0,-13,-17,-4,10,5,-22,-74,-109,-102,-71,-89,-168,-186,-148,-116,-135,-154,-144,-149,-160,-189,-203},
            {137,-210,307,-418,7784,14629,-18249,-21705,5484,6740,7175,6230,16784,26928,5690,-14060,-9356,-2647,1990,369,-8645,-10197,-7268,-2342,-788,-492,554,-224,-839,2180,4157,774,-353,790,1922,-537,-2608,-2502,-2604,-2037,-1546,-1419,-962,345,535,466,718,887,899,803,790,201,-276,-502,-763,-775,-719,-869,-907,-769,-440,113,-28,-123,396,722,499,209,177,64,-210,-428,-443,-451,-396,-409,-316,-143,-60,-11,-82,-50,106,42,-154,-201,-99,-51,-68,27,97,28,-84,-219,-321,-272,-145,-77,-5,79,102,148,71,7,52,69,4,-132,-299,-370,-203,-82,-92,-124,-113,-76,-40,-30,-86,-76,-106,-461,-680,-464,-5,335,302,296}
        },
        {    // H-20e080a.wav
            {0,0,1,1,0,2,0,2,0,2,0,1,1,-1,1,0,0,-2,6,5,-3,-2,3,10,1,14,109,378,554,310,-68,-5,-121,-541,159,1261,1626,1938,2870,3674,2884,1284,106,-690,-1010,-1258,-2116,-2490,-1541,-479,-100,156,454,479,518,688,487,75,-69,-167,-442,-681,-753,-799,-745,-664,-554,-464,-346,-152,-32,77,147,148,70,-30,-103,-172,-219,-244,-263,-281,-313,-306,-287,-244,-183,-126,-69,-60,-64,-55,-48,-43,-88,-123,-141,-174,-188,-198,-197,-192,-165,-122,-58,0,15,12,12,17,7,-19,-49,-77,-83,-91,-134,-197,-194,-132,-109,-133,-165,-170,-158,-149,-156,-175},
            {190,-309,437,-481,9752,12984,-22831,-18584,8233,6672,5852,6854,20888,24175,-225,-14525,-7226,-338,4082,-859,-10667,-9522,-6128,-2644,-1436,-168,276,-1215,-566,2992,3804,352,-355,1185,2235,-605,-2479,-2145,-2154,-2060,-1875,-1686,-1113,13,323,392,675,945,848,828,913,386,-96,-391,-659,-686,-631,-840,-1007,-932,-566,-39,-243,-143,427,654,454,241,295,147,-148,-361,-385,-377,-382,-424,-350,-199,-108,-74,-158,-76,109,7,-165,-173,-36,-10,-6,89,95,-23,-136,-234,-340,-257,-143,-74,16,63,49,49,19,25,78,77,18,-95,-265,-313,-202,-118,-131,-141,-106,-93,-52,-50,-90,-100,-173,-512,-646,-373,54,325,277,294}
        },
        {    // H-20e085a.wav
            {0,0,0,1,1,1,1,1,3,1,0,1,1,1,2,0,-1,1,4,7,-2,3,-2,11,3,12,11,179,387,504,947,-155,-1405,-270,449,629,1442,1832,2312,3490,3603,1832,478,114,-770,-1683,-1966,-2171,-1743,-615,72,58,13,142,406,582,450,210,-116,-188,-206,-464,-684,-741,-685,-603,-513,-439,-377,-268,-134,-13,41,27,-8,-41,-91,-183,-191,-198,-235,-212,-215,-225,-223,-214,-212,-191,-121,-97,-92,-92,-71,-57,-93,-105,-130,-154,-193,-233,-216,-185,-139,-106,-71,-27,13,57,46,8,-30,-32,-34,-60,-80,-136,-194,-232,-192,-113,-95,-124,-169,-180,-148,-122,-128,-155},
            {228,-361,510,-543,10534,12176,-24800,-16877,9508,6625,4764,7506,23216,21347,-3635,-14076,-5314,1493,5121,-1635,-11872,-8897,-5279,-3222,-2125,144,-160,-2065,-348,3534,3692,1,-52,1533,2173,-641,-2190,-1903,-1811,-1710,-2126,-2067,-1221,-238,-63,302,752,880,808,854,974,493,142,-145,-603,-632,-588,-760,-1029,-1021,-673,-248,-409,-200,432,576,433,314,368,214,-103,-261,-302,-295,-336,-467,-389,-220,-129,-155,-223,-103,99,6,-164,-147,-13,46,54,117,99,-35,-137,-252,-348,-256,-120,-33,4,-5,-30,8,-5,30,107,115,66,-62,-220,-269,-192,-149,-168,-159,-116,-109,-63,-38,-75,-101,-206,-539,-618,-312,97,304,240,288}
        },
        {    // H-20e090a.wav
            {0,0,1,2,1,0,2,1,1,2,2,2,-1,3,0,1,-1,-1,8,-1,3,2,9,-1,2,12,-10,53,395,1003,466,-589,-762,-539,439,1040,930,1717,2807,2852,2489,2163,1213,342,-204,-1425,-2582,-1969,-924,-598,-165,82,-100,-171,213,481,316,99,-20,-150,-256,-321,-551,-692,-615,-513,-424,-419,-348,-267,-216,-98,-32,-55,-90,-95,-119,-184,-221,-207,-173,-151,-124,-119,-178,-195,-192,-200,-187,-148,-86,-77,-90,-104,-127,-113,-137,-182,-208,-216,-188,-151,-103,-65,-36,-15,10,50,46,9,-41,-63,-55,-57,-91,-160,-226,-251,-194,-108,-73,-96,-146,-164,-128,-82,-86,-139},
            {237,-370,521,-626,9986,12887,-24514,-17357,9898,6679,4111,7412,23927,19946,-5241,-13510,-3732,2889,5454,-1676,-12438,-8658,-4719,-3667,-2800,-63,-342,-2726,-410,3751,3792,-86,190,1937,2227,-800,-2107,-1475,-1599,-1609,-1963,-2163,-1615,-497,-252,36,680,924,752,803,1001,601,277,94,-428,-610,-573,-706,-990,-1057,-763,-411,-573,-271,377,542,401,314,429,261,-26,-189,-219,-247,-295,-461,-427,-245,-156,-200,-281,-135,60,-15,-149,-115,-11,30,72,164,140,-40,-156,-248,-312,-224,-137,-82,-62,-35,-52,-31,-57,9,152,193,136,-52,-208,-246,-173,-187,-239,-182,-123,-121,-78,-15,-38,-88,-227,-566,-614,-288,115,280,201,262}
        },
        {    // H-20e095a.wav
            {0,0,0,1,1,0,2,1,1,1,1,0,1,1,1,2,-2,2,3,-2,5,-1,18,-5,4,-12,8,56,721,1131,-485,-1138,4,289,123,785,1560,1926,2735,2438,1258,1368,1670,752,-290,-957,-2179,-2283,-660,248,-127,-255,-33,-84,-40,175,228,23,-105,-131,-321,-444,-432,-537,-604,-452,-319,-309,-328,-246,-194,-143,-76,-113,-160,-188,-182,-228,-249,-225,-150,-72,-97,-109,-120,-137,-166,-197,-186,-139,-85,-101,-129,-141,-169,-192,-196,-191,-195,-183,-145,-106,-57,-16,5,18,14,3,-3,-20,-50,-77,-97,-106,-107,-154,-233,-260,-201,-111,-58,-71,-113,-128,-99,-69,-68,-118},
            {197,-308,427,-608,8045,14797,-21563,-20120,9346,6918,3806,6599,22940,20530,-5264,-13288,-2658,3957,5507,-1062,-12292,-8996,-4394,-3870,-3444,-878,-329,-3017,-942,3687,4070,-4,430,2316,2446,-645,-2216,-1305,-1314,-1513,-1988,-2020,-1668,-934,-537,-78,458,813,828,775,931,676,400,255,-250,-480,-556,-694,-929,-1036,-850,-530,-644,-352,316,457,368,299,455,316,35,-124,-167,-210,-271,-421,-405,-263,-186,-211,-309,-187,15,-41,-156,-103,-11,14,67,192,169,-22,-137,-180,-274,-235,-179,-162,-110,-51,-51,-64,-86,8,184,252,194,5,-190,-256,-200,-228,-279,-209,-119,-121,-71,19,11,-69,-236,-567,-617,-281,84,247,180,236}
        },
        {    // H-20e100a.wav
            {0,0,0,1,1,1,0,0,2,1,0,-1,1,-1,-1,2,-4,3,-2,3,-5,5,8,7,-4,-19,-1,429,1147,90,-1185,-606,214,652,688,715,1713,3022,2298,1048,969,790,839,773,13,-999,-1638,-1594,-908,289,673,-27,-283,79,20,-170,-31,20,-138,-376,-468,-497,-477,-458,-513,-427,-248,-186,-230,-180,-108,-125,-142,-149,-167,-255,-307,-301,-258,-194,-176,-147,-108,-81,-75,-95,-131,-128,-95,-113,-141,-142,-144,-195,-256,-274,-239,-185,-159,-139,-105,-55,-6,24,26,18,17,-22,-63,-79,-90,-104,-116,-130,-150,-175,-221,-229,-189,-135,-71,-48,-65,-83,-81,-77,-88,-117},
            {100,-124,161,-319,4961,16606,-15073,-24503,7037,7797,3401,5549,20103,22634,-3127,-13786,-2317,4884,5595,-31,-11401,-9821,-4402,-3719,-3873,-2327,-386,-2799,-1745,3042,4442,560,311,2551,2939,-159,-2260,-1251,-1259,-1390,-1866,-2142,-1625,-963,-918,-415,344,688,746,792,929,684,426,427,-79,-385,-446,-633,-893,-1048,-882,-607,-637,-456,223,399,316,278,416,371,84,-86,-123,-207,-235,-361,-365,-233,-198,-214,-322,-248,-47,-60,-207,-142,14,36,37,175,207,44,-85,-145,-270,-270,-187,-180,-170,-108,-64,-41,-48,-3,153,264,268,95,-168,-312,-262,-250,-282,-226,-121,-102,-52,50,27,-46,-207,-541,-624,-314,33,188,153,230}
        },
        {    // H-20e105a.wav
            {3,3,3,5,3,4,4,3,4,4,5,5,6,3,6,4,5,4,4,9,0,9,12,15,1,-10,193,1186,619,-1376,-949,252,501,597,940,1628,2552,2729,1573,378,272,641,142,-135,-24,-540,-1283,-1131,-367,28,684,862,191,-133,27,-136,-316,-125,-230,-547,-742,-584,-470,-529,-466,-341,-198,-85,-3,-41,-77,-87,-89,-128,-212,-282,-365,-337,-269,-262,-262,-217,-126,-75,-60,-46,1,-3,-58,-95,-130,-152,-206,-266,-303,-291,-241,-179,-110,-69,-34,-8,15,39,38,36,19,-35,-97,-132,-120,-106,-125,-139,-161,-185,-187,-174,-162,-139,-71,-16,-13,-34,-63,-88,-111,-127},
            {-66,142,-216,217,1668,16151,-4891,-27887,1335,9584,2777,4516,15881,24391,2086,-14540,-3295,5847,5806,1226,-9752,-10775,-4893,-3455,-3830,-4051,-1121,-1969,-2541,1802,4553,1593,288,2278,3413,948,-2161,-1331,-1079,-1521,-1737,-2079,-1871,-1045,-882,-766,-98,613,754,648,928,821,399,429,169,-265,-362,-535,-804,-1052,-946,-621,-615,-574,120,398,263,193,337,404,145,-64,-102,-182,-208,-259,-320,-218,-193,-206,-320,-321,-137,-85,-216,-188,-40,38,53,158,237,100,-57,-141,-254,-282,-200,-191,-214,-148,-74,-16,-9,-14,116,232,291,169,-105,-338,-349,-281,-279,-219,-127,-77,-48,47,53,-28,-162,-493,-634,-369,-48,120,131,206}
        },
        {    // H-20e110a.wav
            {-1,-1,-1,-1,0,0,0,-2,-3,-1,-2,-2,-2,-2,0,-4,0,-7,2,-2,-3,-4,9,-11,14,44,982,1256,-1104,-1764,-81,802,728,703,1293,2722,3410,1719,200,172,207,-181,-376,-605,-764,-417,-470,-771,-317,383,622,1039,1085,239,-255,-219,-244,-400,-558,-743,-819,-780,-651,-540,-538,-348,-69,98,102,22,3,17,-10,-129,-260,-299,-325,-395,-435,-396,-331,-262,-223,-145,-19,41,57,44,-5,-81,-148,-203,-268,-305,-326,-306,-233,-168,-92,-35,-1,-16,-22,16,22,30,-11,-96,-148,-154,-133,-135,-162,-172,-156,-165,-190,-178,-169,-134,-67,-24,-13,-27,-68,-135,-169,-154},
            {-189,315,-443,555,-374,12033,6546,-25989,-8679,10938,3118,2982,11489,23696,9986,-13383,-6574,6580,6457,2539,-7384,-11438,-5885,-3451,-3315,-5128,-3095,-1135,-2577,-6,4176,2749,496,1962,3436,2229,-1436,-1602,-796,-1436,-1858,-2015,-1981,-1371,-958,-799,-450,142,781,691,769,886,542,376,310,-79,-280,-433,-689,-954,-1028,-709,-535,-649,-82,382,261,93,205,416,210,-36,-109,-117,-151,-195,-280,-212,-168,-221,-338,-377,-238,-116,-222,-258,-96,25,91,142,215,122,-25,-87,-237,-324,-238,-168,-191,-187,-98,-41,3,-4,77,193,231,198,-11,-294,-426,-341,-248,-201,-130,-87,-76,21,77,-12,-120,-412,-653,-455,-141,64,88,146}
        },
        {    // H-20e115a.wav
            {3,2,2,4,2,3,3,2,1,3,2,3,3,5,4,5,1,4,3,9,-4,18,-7,16,-2,680,1769,-419,-2345,-748,706,1027,888,1150,2471,3722,2596,521,-303,-192,-67,-625,-1086,-1024,-896,-703,-101,23,-253,325,1058,1299,1218,832,64,-363,-314,-558,-885,-965,-854,-843,-894,-716,-447,-237,-20,176,188,153,189,153,29,-103,-139,-274,-422,-479,-482,-442,-437,-363,-247,-108,-9,65,119,106,59,-74,-174,-202,-238,-280,-296,-250,-192,-126,-76,-40,-10,-6,-7,8,30,6,-65,-124,-131,-129,-139,-134,-110,-112,-146,-169,-176,-153,-137,-122,-64,-19,9,-10,-81,-155,-181,-140},
            {-140,189,-228,264,-439,5534,13933,-15514,-19786,7962,5918,919,7454,20079,17398,-7181,-11334,5227,8119,3648,-4349,-11369,-7176,-3863,-2958,-4757,-5510,-1773,-1649,-1417,2753,3809,959,1602,3367,3210,-233,-1702,-546,-1084,-1891,-2114,-2056,-1657,-1133,-1027,-575,-183,447,775,730,828,655,484,424,61,-182,-282,-549,-849,-986,-829,-521,-604,-366,272,306,110,72,330,279,29,-48,-36,-97,-143,-208,-228,-174,-224,-315,-391,-329,-179,-209,-272,-124,27,85,95,189,192,28,-67,-166,-322,-280,-132,-128,-175,-143,-73,2,26,58,147,193,195,63,-193,-395,-380,-242,-152,-125,-113,-88,-1,88,33,-78,-315,-628,-514,-207,-28,49,133}
        },
        {    // H-20e120a.wav
            {0,1,1,1,1,0,0,0,-1,1,0,-1,2,1,5,-1,1,-2,4,1,0,12,-6,6,320,1938,658,-2654,-1670,523,1141,1014,1167,2371,4086,3373,632,-411,-252,-272,-835,-1236,-1371,-1433,-947,-458,-140,230,337,387,1155,1602,1228,864,567,40,-610,-898,-1026,-1037,-1031,-1061,-959,-740,-416,-212,-51,159,323,354,278,199,140,33,-186,-385,-455,-458,-527,-578,-518,-391,-263,-151,-37,83,159,84,-11,-50,-114,-207,-245,-213,-199,-190,-185,-169,-130,-68,-27,-20,-3,-7,-22,-68,-125,-150,-153,-134,-108,-69,-47,-76,-157,-223,-199,-142,-123,-130,-114,-41,6,-32,-116,-174,-171,-130},
            {49,-125,202,-288,350,570,12895,446,-23982,-2493,9506,621,3085,14973,20618,3351,-12602,-513,9992,5172,-1311,-9839,-8850,-4288,-3487,-3472,-6454,-4252,-1301,-1463,786,3925,1951,1120,3108,3841,1479,-1675,-590,-341,-1676,-2227,-2162,-1979,-1352,-1168,-957,-377,114,639,715,799,733,535,572,297,-132,-206,-346,-688,-916,-860,-619,-563,-600,-4,330,161,11,181,351,147,0,9,-12,-94,-174,-254,-215,-215,-297,-419,-441,-282,-144,-210,-171,-36,33,65,156,224,70,-62,-78,-208,-302,-195,-121,-140,-142,-120,-64,14,52,119,178,170,78,-111,-323,-373,-247,-133,-112,-142,-129,-61,55,58,-46,-217,-574,-585,-293,-116,-11,91}
        },
        {    // H-20e125a.wav
            {1,1,2,1,1,1,1,0,2,0,1,2,3,4,5,1,4,-2,13,-14,28,-22,43,79,1716,1821,-2389,-2778,70,1274,1283,1084,2174,4387,4415,1232,-718,-740,-306,-558,-1457,-1831,-1804,-1317,-842,-217,76,133,656,1104,1206,1227,1238,948,769,320,-568,-1118,-1151,-1138,-1206,-1112,-920,-698,-501,-213,32,201,380,428,414,335,168,-62,-241,-306,-417,-535,-603,-582,-513,-415,-298,-178,3,70,52,45,14,-38,-101,-137,-147,-128,-136,-180,-202,-197,-152,-97,-38,-4,-10,-42,-95,-127,-158,-181,-152,-84,-13,22,12,-62,-178,-252,-224,-150,-118,-133,-135,-71,-35,-63,-103,-130,-125,-116},
            {89,-163,206,-233,287,-423,5698,11708,-14577,-16170,7573,4250,-755,8791,19362,12770,-6433,-7110,7814,8117,1098,-6537,-10251,-5100,-3899,-3454,-5021,-6475,-2999,-1121,-246,2673,3068,973,2515,3932,3131,-403,-1345,125,-780,-2164,-2354,-2152,-1798,-1259,-1160,-698,-240,358,689,755,841,620,539,591,132,-235,-253,-438,-734,-855,-745,-606,-680,-364,193,241,57,84,329,288,102,45,44,-71,-141,-242,-256,-240,-339,-433,-455,-326,-156,-143,-194,-99,5,49,72,181,164,14,-28,-107,-250,-257,-153,-126,-140,-130,-109,-12,48,95,171,173,98,-66,-249,-343,-227,-94,-101,-164,-176,-115,-13,69,-14,-145,-471,-620,-361,-198,-90,44}
        },
        {    // H-20e130a.wav
            {1,1,0,2,0,0,-1,1,0,0,-1,3,0,5,-3,10,-11,19,-19,26,-20,38,-11,1240,2783,-1495,-3926,-683,1275,1573,1270,1969,4367,5342,2152,-684,-1033,-691,-712,-1409,-1781,-2201,-1987,-1232,-406,9,134,456,902,1568,1282,816,872,1069,772,142,-373,-1005,-1232,-1247,-1198,-1123,-926,-667,-431,-126,95,226,369,547,489,220,53,-36,-170,-338,-466,-538,-607,-567,-477,-407,-285,-168,-77,-14,21,28,-16,-37,-31,-29,-80,-127,-153,-175,-192,-199,-153,-103,-44,-26,-62,-105,-157,-192,-183,-139,-89,-26,51,86,52,-72,-230,-290,-238,-166,-130,-145,-155,-119,-87,-65,-70,-76,-86,-109},
            {-49,67,-132,187,-265,320,262,10510,2722,-20048,-4257,8286,-647,2043,14325,17657,3667,-7881,1605,9453,3825,-2771,-9224,-7579,-3425,-4190,-4161,-6057,-5361,-2251,-694,1349,3217,1642,1592,3673,3928,1679,-1179,-439,52,-1418,-2440,-2358,-2107,-1642,-1309,-884,-471,-103,453,682,919,867,481,506,525,12,-253,-341,-527,-733,-807,-716,-693,-656,-127,246,157,62,248,419,250,51,28,-39,-143,-194,-317,-334,-370,-398,-410,-372,-254,-145,-150,-125,-47,-11,16,108,222,127,-28,-91,-177,-241,-194,-160,-173,-150,-94,-34,15,33,131,196,127,-29,-203,-313,-244,-80,-65,-180,-239,-176,-89,23,-5,-111,-349,-612,-438,-277,-199,-21}
        },
        {    // H-20e135a.wav
            {1,1,0,0,-1,-2,0,0,0,-2,3,-1,6,-6,11,-7,6,-3,1,13,2,10,689,3279,21,-4807,-1862,1158,1776,1593,1932,4368,6015,3071,-533,-1202,-881,-751,-1625,-2117,-2203,-2233,-1749,-977,-141,226,377,867,1559,1372,1080,751,573,794,444,-118,-427,-567,-1035,-1372,-1299,-972,-743,-570,-256,-93,123,384,431,342,285,259,80,-163,-252,-323,-457,-544,-549,-497,-384,-363,-335,-205,-79,-47,-58,-23,36,43,-11,-73,-110,-111,-136,-162,-185,-174,-129,-96,-77,-93,-147,-188,-180,-161,-149,-100,-35,40,97,107,34,-126,-275,-318,-247,-182,-163,-158,-169,-161,-96,-37,-37,-51,-58,-85},
            {-50,52,-78,61,-55,44,-129,2914,11175,-6994,-16763,3678,4137,-2005,6742,16479,12712,-1967,-3446,7421,6434,-371,-5283,-9007,-5113,-3254,-4731,-5095,-5968,-3945,-1809,-87,2580,2773,1121,2668,4218,3228,352,-969,167,-453,-2069,-2527,-2341,-1953,-1497,-1242,-623,-251,151,529,770,970,753,430,522,354,-86,-240,-430,-626,-765,-748,-679,-752,-512,65,228,177,254,434,341,103,-6,-27,-121,-222,-332,-380,-306,-330,-409,-423,-324,-171,-109,-142,-72,-27,15,74,172,178,-1,-78,-104,-177,-203,-173,-163,-163,-91,-46,-17,19,81,200,168,40,-145,-289,-260,-115,-50,-144,-239,-214,-141,-53,-24,-91,-214,-524,-519,-330,-272,-87}
        },
        {    // H-20e140a.wav
            {1,1,0,0,-1,-1,2,1,-3,3,2,3,-1,2,5,-6,16,-25,40,-33,73,244,3224,1834,-5048,-3444,877,1843,1926,2089,4413,6633,4009,-288,-1431,-1147,-729,-1616,-2381,-2431,-2618,-2028,-1292,-417,44,277,838,1642,1714,1121,729,664,662,-7,-199,-187,-353,-592,-941,-1099,-1062,-796,-550,-345,-83,147,186,228,326,308,200,53,-85,-179,-291,-385,-442,-450,-400,-394,-429,-336,-215,-159,-168,-109,0,46,28,-60,-83,-68,-79,-124,-143,-135,-129,-119,-131,-144,-149,-155,-154,-161,-156,-130,-87,-24,23,69,97,84,-11,-178,-308,-322,-254,-204,-180,-158,-165,-127,-55,-17,-6,-25,-35,-70},
            {41,-79,94,-130,156,-197,247,-245,5947,8020,-12895,-9887,5797,-167,12,10171,15726,7760,-3007,2397,8630,1713,-3062,-6066,-7732,-3549,-4019,-5355,-5466,-5092,-2781,-1503,634,3017,2322,1474,3515,3963,2210,-214,-454,175,-1233,-2438,-2542,-2214,-1713,-1452,-1034,-370,6,462,766,791,742,613,540,522,44,-233,-275,-481,-687,-767,-703,-705,-701,-248,247,306,288,334,369,172,-30,-100,-113,-198,-280,-338,-322,-303,-380,-429,-388,-251,-100,-97,-94,-11,33,42,50,124,69,-44,-65,-101,-174,-174,-132,-150,-128,-66,-39,14,83,159,186,81,-81,-245,-283,-183,-91,-89,-190,-240,-173,-111,-70,-121,-135,-352,-565,-398,-312,-160}
        },
        {    // H-20e145a.wav
            {1,1,-2,-1,-2,-1,0,-3,0,4,0,4,-9,17,-21,30,-38,48,-51,103,14,2710,3541,-4451,-5260,341,1858,2116,2335,4607,7240,4902,68,-1556,-1465,-918,-1548,-2674,-2469,-2768,-2582,-1744,-614,97,179,552,1554,2084,1329,940,625,496,212,-360,-695,-658,-542,-655,-733,-643,-588,-696,-254,186,100,47,189,304,219,60,-24,-143,-227,-239,-311,-399,-366,-373,-387,-371,-287,-192,-202,-167,-97,-16,-8,-69,-136,-109,-56,-71,-123,-127,-103,-95,-125,-168,-181,-178,-138,-130,-132,-121,-97,-75,-49,2,54,80,62,-1,-93,-212,-315,-325,-277,-237,-185,-140,-112,-57,-22,-2,8,-10,-47,-117},
            {-9,20,-51,60,-104,137,-193,223,270,7945,3308,-14274,-3828,3904,-1907,2934,11457,13814,4576,-784,6434,6056,-2203,-3670,-6241,-6341,-3032,-5091,-5492,-5346,-4042,-2013,-1048,1219,3017,2109,2199,3896,3187,1356,-291,-17,-424,-1993,-2435,-2370,-2118,-1648,-1259,-724,-58,316,714,872,785,692,462,453,355,-159,-384,-416,-474,-677,-824,-735,-586,-379,84,338,290,266,253,182,16,-103,-156,-153,-195,-268,-368,-360,-364,-389,-358,-312,-187,-69,-39,-20,-18,-19,-7,42,89,17,-55,-53,-88,-172,-151,-123,-137,-99,-36,4,60,116,165,111,-57,-224,-291,-214,-129,-101,-153,-225,-195,-139,-119,-167,-169,-182,-476,-487,-334,-254}
        },
        {    // H-20e150a.wav
            {0,-1,-1,-4,0,-2,-2,-5,5,-3,8,-15,17,-22,26,-34,36,-41,76,-24,1976,4779,-2987,-7025,-645,1915,2153,2567,4851,7965,5793,474,-1583,-1719,-1182,-1547,-3044,-2675,-2672,-2873,-2212,-1115,56,293,450,1393,2105,1572,1155,622,731,368,-580,-817,-1030,-959,-866,-665,-494,-321,-102,17,50,168,298,285,236,88,-56,-101,-253,-360,-310,-263,-312,-401,-431,-358,-277,-246,-175,-104,-55,-58,-36,-85,-157,-185,-148,-114,-117,-107,-107,-102,-120,-146,-203,-221,-141,-89,-102,-118,-82,-38,-55,-55,-23,21,43,41,-9,-89,-161,-251,-324,-335,-283,-212,-162,-116,-35,17,18,-4,-13,-35,-102,-197},
            {-13,17,-18,-3,6,-37,60,-102,93,1208,8566,-973,-12624,-666,1055,-1237,4828,11497,12047,3553,2507,7239,1939,-3713,-3436,-6314,-5290,-3420,-5650,-5270,-4929,-3200,-1494,-362,1731,2783,2117,2909,3728,2375,818,-289,-107,-1064,-2289,-2419,-2267,-1901,-1495,-1048,-296,268,522,875,940,805,678,385,244,-7,-329,-401,-511,-633,-749,-660,-500,-379,-137,252,250,155,208,192,67,-76,-92,-110,-191,-289,-356,-385,-339,-355,-364,-315,-207,-78,-30,-63,-54,-41,-26,-7,38,70,3,-34,-35,-109,-174,-122,-87,-99,-64,-15,34,101,115,86,-34,-188,-261,-214,-141,-141,-153,-176,-190,-166,-166,-185,-220,-133,-265,-520,-375,-291}
        },
        {    // H-20e155a.wav
            {0,-1,-2,-1,0,-2,-5,4,-3,10,-13,12,-14,12,-14,8,-1,11,35,1318,5332,-980,-8277,-2148,1992,2120,2729,5065,8787,6767,876,-1562,-1898,-1455,-1530,-3380,-3198,-2608,-2961,-2488,-1546,-205,297,454,1312,2260,1660,972,1044,1021,318,-645,-984,-1104,-1074,-1150,-1206,-814,13,252,233,386,446,426,389,283,71,-60,-170,-358,-461,-384,-360,-425,-434,-399,-363,-302,-232,-72,41,62,-14,-52,-66,-149,-232,-221,-169,-138,-149,-159,-141,-162,-188,-227,-186,-97,-48,-64,-77,-45,-3,-13,-44,-33,-9,6,2,-38,-83,-129,-210,-301,-338,-315,-246,-168,-115,-38,31,46,19,-19,-57,-111,-184,-242},
            {19,-28,38,-45,35,-46,33,-30,20,-45,2264,8049,-3764,-9953,-224,-683,246,5419,11308,10939,4139,4786,5548,-1500,-3327,-3229,-6477,-4563,-4213,-5569,-5015,-4411,-2342,-1106,295,2072,2648,2336,3232,3027,1853,518,-327,-516,-1674,-2199,-2330,-2217,-1734,-1140,-671,0,422,722,1016,966,816,566,313,120,-269,-510,-514,-559,-670,-703,-480,-267,-239,-136,153,206,236,197,127,46,-45,-128,-209,-286,-317,-356,-403,-353,-339,-279,-234,-149,-49,-24,-50,-74,-74,-27,8,52,67,10,-22,-30,-108,-146,-91,-84,-83,-51,1,55,81,64,-12,-146,-231,-213,-131,-128,-181,-187,-163,-158,-192,-210,-244,-192,-104,-370,-460,-294}
        },
        {    // H-20e160a.wav
            {-3,-3,-2,0,-1,-7,3,-2,6,-9,4,-3,-2,0,-17,29,-31,71,878,5307,1058,-8638,-4098,1921,2129,2809,5222,9492,7929,1360,-1472,-2094,-1741,-1490,-3557,-3823,-2842,-3064,-2646,-1779,-438,238,324,1328,2253,1769,1396,1103,780,484,-502,-1033,-1225,-1262,-1369,-1326,-921,-328,37,357,761,910,761,411,256,230,21,-186,-333,-511,-535,-511,-507,-536,-528,-378,-246,-218,-45,141,144,48,9,-23,-106,-200,-227,-210,-220,-225,-252,-244,-235,-219,-205,-165,-64,5,-14,-28,-7,16,14,-6,-33,-40,-27,-51,-97,-107,-87,-144,-261,-341,-339,-258,-165,-128,-68,21,67,47,-6,-66,-144,-206,-231,-258},
            {-8,21,-31,40,-57,57,-81,85,-108,122,-129,3183,6953,-4975,-7877,-1097,-946,1228,5515,11376,10418,5277,5278,2930,-3190,-2598,-3027,-6631,-4532,-4407,-5443,-4847,-3638,-1561,-731,745,2376,2649,2433,3096,2375,1420,319,-446,-1003,-1998,-2143,-2168,-2033,-1500,-842,-332,262,518,852,1102,906,698,469,244,76,-291,-581,-697,-639,-606,-608,-463,-321,-263,-74,167,238,312,235,106,-12,-75,-150,-249,-368,-382,-397,-395,-346,-305,-229,-188,-99,-33,-37,-65,-82,-66,-20,29,78,59,25,19,-24,-139,-153,-98,-102,-101,-61,11,70,59,-19,-125,-207,-187,-134,-129,-178,-200,-158,-139,-194,-244,-247,-256,-130,-161,-419,-359}
        },
        {    // H-20e165a.wav
            {-3,-2,0,-1,-7,3,-1,4,-3,-1,3,-8,10,-30,40,-39,70,632,4982,2665,-8037,-6066,1364,2294,2798,5395,9944,9092,2076,-1250,-2208,-2138,-1500,-3585,-4361,-3200,-3273,-2962,-1917,-583,267,298,960,2356,2325,1434,1034,857,514,-496,-969,-1288,-1611,-1428,-1169,-1021,-614,-174,260,774,1008,985,772,507,281,108,-57,-306,-577,-624,-550,-624,-707,-637,-442,-226,-139,-20,70,187,193,94,32,-44,-114,-196,-225,-287,-347,-378,-339,-275,-244,-205,-142,-39,50,39,22,37,50,37,19,7,-40,-81,-102,-127,-145,-109,-93,-174,-275,-312,-274,-192,-132,-76,-23,37,71,36,-48,-149,-220,-249,-261,-265},
            {4,-5,14,-20,31,-50,57,-84,100,-136,170,-117,3803,5840,-5107,-6962,-1973,-505,1560,5939,11313,10343,6178,4348,607,-3454,-1951,-3436,-6212,-4800,-4611,-4947,-4652,-2850,-992,-231,978,2636,2718,2166,2702,2115,1087,-55,-632,-1363,-1983,-2072,-2046,-1811,-1204,-529,-133,365,680,927,899,841,685,463,298,57,-371,-641,-648,-639,-679,-671,-577,-418,-294,17,300,310,279,213,180,51,-95,-237,-364,-416,-395,-418,-396,-330,-251,-212,-168,-104,-64,-31,-44,-32,-27,4,62,99,71,17,-1,-59,-149,-171,-158,-133,-97,-19,40,35,-23,-96,-171,-195,-141,-132,-162,-169,-143,-143,-182,-243,-249,-265,-249,-107,-247,-387}
        },
        {    // H-20e170a.wav
            {-4,0,0,-6,0,-1,3,-2,-4,2,-14,11,-30,32,-37,66,473,4654,3623,-6910,-7397,170,2454,2826,5554,10264,9992,2984,-851,-2140,-2544,-1675,-3599,-4761,-3586,-3513,-3349,-2257,-613,314,48,1036,2629,2344,1506,1137,926,571,-399,-1206,-1540,-1448,-1358,-1422,-1234,-526,-21,174,407,771,1083,949,768,600,265,-25,-234,-524,-708,-707,-707,-751,-711,-532,-303,-193,-1,179,227,184,154,152,60,-84,-210,-268,-353,-424,-455,-414,-340,-272,-205,-139,-40,71,85,47,49,75,64,38,21,-36,-93,-134,-167,-198,-159,-90,-113,-195,-256,-246,-211,-168,-107,-69,-17,44,48,-32,-140,-213,-261,-282,-302,-231},
            {-3,2,-1,6,-12,17,-35,39,-67,81,-120,158,-12,4115,5051,-4935,-6905,-2343,-108,2013,6423,10911,10716,6309,2776,-813,-3103,-1617,-4000,-5993,-4421,-4801,-4820,-3846,-2298,-639,249,1234,2532,2656,2281,2100,1582,1129,-246,-1122,-1485,-1804,-1924,-1896,-1631,-956,-279,93,336,576,945,985,790,683,539,212,-99,-352,-484,-553,-618,-833,-915,-696,-408,-223,11,261,405,400,281,172,36,-135,-312,-393,-396,-386,-424,-408,-343,-251,-224,-204,-127,-18,39,22,14,21,56,75,75,47,-1,-35,-96,-175,-198,-175,-124,-63,0,13,-26,-86,-149,-186,-166,-132,-142,-120,-93,-122,-179,-217,-238,-258,-318,-223,-112,-295}
        },
        {    // H-20e175a.wav
            {-1,2,-5,0,-1,4,0,-3,2,-14,13,-32,33,-46,76,350,4420,4117,-5843,-7790,-1250,2168,3027,5678,10510,10642,3892,-287,-1879,-2738,-1961,-3747,-5027,-3937,-3775,-3717,-2609,-977,147,532,1046,2357,2534,1804,1262,971,635,-582,-1263,-1345,-1497,-1735,-1525,-1096,-495,-91,65,446,705,868,891,829,723,532,244,-149,-534,-742,-761,-764,-800,-737,-625,-443,-222,29,208,281,307,264,190,77,-80,-230,-346,-392,-427,-483,-463,-393,-277,-204,-136,-47,62,127,83,42,59,90,61,32,-6,-87,-135,-170,-209,-206,-127,-62,-109,-175,-203,-194,-194,-157,-88,-49,2,22,-20,-117,-196,-228,-285,-329,-304,-134},
            {-3,0,0,3,1,-4,10,-23,24,-47,55,-82,118,136,4246,4602,-4962,-7150,-2381,429,2757,6341,10622,11080,5653,1354,-1445,-2662,-1823,-4201,-5704,-4322,-4286,-4650,-3550,-1600,-199,462,1263,2408,2484,2357,1941,1019,659,-152,-1093,-1670,-1738,-1755,-1723,-1426,-715,-185,21,361,697,929,986,817,567,388,270,98,-297,-486,-609,-810,-925,-867,-684,-489,-284,31,310,422,413,316,177,17,-134,-278,-361,-399,-407,-458,-442,-360,-295,-248,-182,-80,31,86,94,52,30,63,64,46,31,4,-83,-152,-192,-195,-164,-105,-40,-31,-53,-85,-140,-192,-181,-137,-122,-81,-29,-59,-164,-214,-213,-257,-320,-334,-139,-145}
        },
        {    // H-20e180a.wav
            {0,-3,0,0,3,0,-3,4,-17,17,-39,42,-61,93,237,4261,4430,-5157,-7573,-2220,1292,3143,5924,10597,11099,4845,384,-1628,-2651,-2090,-4013,-5327,-4189,-4085,-3939,-3268,-1493,411,599,1010,2294,2609,2116,1593,1031,397,-556,-907,-1361,-1906,-1836,-1509,-1127,-589,-179,40,389,800,1014,793,618,692,575,362,61,-380,-724,-804,-741,-831,-862,-694,-418,-279,-25,282,415,388,272,224,94,-104,-293,-375,-395,-432,-481,-469,-395,-297,-215,-153,-50,80,128,97,51,52,68,61,55,21,-51,-122,-172,-208,-197,-152,-80,-50,-78,-131,-155,-182,-189,-145,-94,-40,-5,-16,-101,-186,-207,-246,-315,-356,-233,-77},
            {0,-3,0,0,3,0,-3,4,-17,17,-39,42,-61,93,237,4261,4430,-5157,-7573,-2220,1292,3143,5924,10597,11099,4845,384,-1628,-2651,-2090,-4013,-5327,-4189,-4085,-3939,-3268,-1493,411,599,1010,2294,2609,2116,1593,1031,397,-556,-907,-1361,-1906,-1836,-1509,-1127,-589,-179,40,389,800,1014,793,618,692,575,362,61,-380,-724,-804,-741,-831,-862,-694,-418,-279,-25,282,415,388,272,224,94,-104,-293,-375,-395,-432,-481,-469,-395,-297,-215,-153,-50,80,128,97,51,52,68,61,55,21,-51,-122,-172,-208,-197,-152,-80,-50,-78,-131,-155,-182,-189,-145,-94,-40,-5,-16,-101,-186,-207,-246,-315,-356,-233,-77}
        }
    },
    {    // elev-30
        {    // H-30e000a.wav
            {-8,6,-4,5,0,-4,3,-28,34,-59,59,-83,82,655,6313,2093,-10148,-2457,-1373,-2539,8574,9341,4579,5326,13776,5453,-7484,-2713,-5026,-10468,-1681,1057,-5970,-3755,857,989,-400,341,1379,-235,133,1819,-377,-1766,-95,163,-1102,-1370,-685,-649,-652,160,251,-271,204,736,699,362,124,60,-45,-475,-476,-492,-691,-476,-197,-266,-274,11,31,-13,120,129,-7,-47,-109,-157,-178,-130,-86,-52,-161,-152,-75,-63,-41,-18,-58,-155,-118,-142,-177,-25,-70,-507,-621,-520,-273,267,500,372,269,-7,-326,-474,-651,-848,-677,-37,296,257,256,170,64,9,-38,6,118,142,32,-83,-208,-255,-276,-329,-383,-472},
            {-8,6,-4,5,0,-4,3,-28,34,-59,59,-83,82,655,6313,2093,-10148,-2457,-1373,-2539,8574,9341,4579,5326,13776,5453,-7484,-2713,-5026,-10468,-1681,1057,-5970,-3755,857,989,-400,341,1379,-235,133,1819,-377,-1766,-95,163,-1102,-1370,-685,-649,-652,160,251,-271,204,736,699,362,124,60,-45,-475,-476,-492,-691,-476,-197,-266,-274,11,31,-13,120,129,-7,-47,-109,-157,-178,-130,-86,-52,-161,-152,-75,-63,-41,-18,-58,-155,-118,-142,-177,-25,-70,-507,-621,-520,-273,267,500,372,269,-7,-326,-474,-651,-848,-677,-37,296,257,256,170,64,9,-38,6,118,142,32,-83,-208,-255,-276,-329,-383,-472}
        },
        {    // H-30e006a.wav
            {0,-6,1,2,-3,9,-11,15,-33,31,-47,38,-54,58,159,3965,4477,-6545,-5128,-1416,-4895,3901,9291,6265,5357,10957,8410,-3241,-3008,-2692,-8650,-4493,1613,-2767,-3974,-946,-475,-572,-753,229,549,-458,1132,1365,-322,-127,191,-393,-1254,-1039,-703,-1405,-796,281,-297,105,876,518,346,271,-37,62,-95,-151,-236,-504,-408,-293,-318,-361,-249,-177,-127,-32,83,-62,-70,91,-18,-97,51,30,-4,-40,-62,-23,-96,-185,-239,-304,-395,-307,-36,-6,-470,-641,-507,-299,293,680,549,370,154,-127,-409,-663,-954,-1012,-451,8,56,68,135,225,287,283,216,201,209,52,-105,-201,-328,-386,-390,-413,-511,-535},
            {3,0,3,7,-12,16,-43,51,-76,76,-104,109,390,6358,4016,-11083,-4316,-845,-3584,9049,10850,5079,4984,14694,7744,-8579,-3805,-5046,-11724,-2301,1405,-6009,-3936,882,1425,-159,197,1676,-480,-692,1750,-239,-1751,246,217,-1334,-1405,-406,-699,-1004,161,467,-246,248,660,526,443,330,161,-64,-462,-432,-527,-850,-633,-337,-355,-258,118,140,29,175,221,3,27,-94,-281,-283,-212,-167,-111,-173,-159,-78,-79,-6,43,20,-33,-9,-101,-206,-84,25,-394,-676,-620,-487,52,488,404,311,146,-178,-370,-586,-860,-848,-231,312,318,252,172,55,43,48,54,111,163,86,-64,-217,-301,-332,-351,-325,-382,-460}
        },
        {    // H-30e012a.wav
            {0,0,-5,2,0,-1,7,-6,10,-25,25,-40,35,-45,51,224,3744,3531,-5818,-4055,-1660,-4130,3741,7843,5834,5524,9531,6942,-2263,-2248,-2422,-7193,-3684,780,-2706,-3250,-1285,-871,-852,-1097,154,578,-221,1213,1434,259,350,280,-397,-1116,-899,-871,-1619,-1065,-154,-404,93,646,334,309,336,177,348,215,61,-100,-389,-423,-378,-409,-426,-353,-290,-266,-198,-14,-19,54,135,38,23,89,56,41,47,2,-47,-121,-227,-319,-416,-489,-332,-45,-157,-577,-556,-390,-53,505,683,520,267,19,-232,-469,-689,-954,-841,-313,1,100,119,132,154,167,206,212,220,166,22,-81,-173,-277,-370,-454,-507,-560},
            {6,-3,16,-21,26,-54,59,-79,75,-101,113,118,5726,6522,-10650,-7467,-271,-4426,8311,12760,5940,4553,15011,10703,-8723,-5530,-4800,-12937,-3714,2691,-5575,-4905,856,1641,4,24,1955,-745,-2167,1581,1035,-1374,-87,381,-1010,-1434,-319,-608,-1392,-128,538,-299,102,582,408,356,314,349,194,-367,-382,-337,-726,-727,-482,-493,-499,-16,214,91,211,312,28,27,2,-264,-366,-311,-269,-223,-193,-125,-50,-90,30,144,73,-18,28,-42,-206,-154,56,-280,-712,-654,-537,-196,341,444,347,273,-14,-229,-457,-811,-991,-523,199,364,285,177,24,37,82,116,172,236,167,-18,-174,-297,-399,-446,-364,-317,-426,-383}
        },
        {    // H-30e018a.wav
            {-3,0,-1,-5,1,-1,-1,4,-5,6,-19,18,-33,29,-36,38,261,3390,2834,-4897,-3367,-1818,-3313,3251,6620,5630,5185,8044,6005,-1295,-1540,-2034,-5742,-3208,28,-2434,-2950,-1411,-947,-1347,-1588,-64,562,168,1494,1583,741,868,645,-412,-1284,-1032,-1115,-1775,-1319,-495,-452,-11,363,250,381,557,539,576,348,200,-21,-347,-368,-382,-520,-563,-505,-536,-482,-246,12,83,150,189,113,100,148,90,47,13,-13,-58,-181,-300,-362,-426,-467,-281,-110,-345,-603,-467,-257,167,576,602,420,152,-86,-294,-496,-739,-902,-614,-154,64,130,83,73,80,79,129,209,222,115,12,-69,-181,-280,-394,-508,-550},
            {-4,21,-28,30,-57,52,-65,49,-71,78,-38,4478,8847,-8253,-11214,-728,-4445,6555,14123,7522,4461,14485,14062,-7487,-7699,-5383,-14023,-4471,4072,-4880,-6058,101,1711,461,-48,1804,-1267,-3686,1793,2961,-1111,-899,560,-1,-1192,-748,-842,-1485,-311,516,-570,-290,559,358,273,264,429,386,-226,-246,-22,-577,-730,-485,-494,-639,-244,7,-12,263,401,2,-55,94,-177,-385,-336,-292,-234,-210,-177,-27,-67,25,136,112,7,83,26,-222,-259,-3,-94,-651,-746,-589,-370,181,459,396,370,144,-90,-313,-659,-1034,-871,-37,375,263,173,28,26,66,121,243,308,290,117,-89,-245,-408,-520,-457,-358,-377,-433,-220}
        },
        {    // H-30e024a.wav
            {-1,-1,0,0,-3,1,-1,1,3,-3,6,-15,14,-23,24,-24,29,247,2931,2513,-3935,-3086,-1743,-2702,2536,5868,5321,4458,6839,5512,-393,-951,-1426,-4631,-3124,-280,-2146,-2771,-1446,-1303,-1942,-1770,4,679,593,1724,1805,1152,1064,664,-423,-1292,-1311,-1371,-1777,-1374,-635,-629,-239,304,438,584,689,692,701,445,242,-5,-278,-331,-431,-627,-752,-720,-609,-480,-261,27,139,202,260,222,150,143,91,23,-48,-95,-104,-168,-269,-341,-410,-412,-238,-201,-483,-592,-387,-83,330,512,455,296,64,-157,-356,-521,-704,-701,-344,-22,89,89,2,10,5,13,130,219,165,37,-34,-98,-185,-270,-403,-507},
            {23,-25,26,-42,27,-26,-1,-5,-4,-26,2859,10181,-3917,-14275,-2720,-4154,4328,14770,9042,5093,13797,16908,-4603,-9476,-7752,-14526,-3825,4367,-3948,-6457,-1409,980,1407,119,653,-1547,-4162,1819,4265,-703,-1312,802,822,-789,-1151,-1234,-1555,-405,315,-752,-567,315,218,326,311,342,448,7,-47,178,-418,-679,-358,-380,-646,-441,-176,-150,95,317,21,-46,93,-144,-336,-297,-220,-169,-159,-184,-54,-57,-4,98,85,-5,43,80,-100,-269,-136,9,-462,-821,-656,-464,0,445,428,452,361,65,-209,-548,-953,-1102,-407,345,291,121,-7,16,111,92,273,417,397,260,30,-134,-323,-540,-554,-465,-373,-403,-308,-115}
        },
        {    // H-30e030a.wav
            {0,-1,0,0,0,-3,1,0,1,3,-1,4,-10,12,-18,22,-17,20,208,2459,2348,-3097,-2893,-1547,-2304,2014,5256,4643,3834,5894,5050,421,-300,-888,-3875,-2951,-448,-1847,-2650,-1933,-1820,-1904,-1400,67,805,942,1910,1888,1125,946,513,-370,-1114,-1346,-1557,-1818,-1375,-770,-663,-213,374,577,704,717,638,669,482,245,-12,-251,-399,-549,-700,-775,-717,-621,-461,-249,25,130,178,279,252,198,129,31,-21,-79,-66,-78,-178,-277,-327,-370,-376,-239,-317,-538,-488,-268,44,329,389,322,172,-22,-224,-366,-480,-577,-432,-140,4,39,2,-76,-74,-29,22,94,138,56,-11,-30,-101,-180,-262,-376},
            {-5,3,-14,-18,27,-68,74,-114,94,1215,9831,2035,-15366,-6429,-3526,1358,14426,10760,5617,12964,19870,-419,-11477,-9313,-14731,-4432,4881,-2675,-6988,-2810,-180,1880,300,-963,-1141,-3109,995,4183,409,-1033,715,1180,-338,-1082,-1597,-1993,-553,274,-980,-830,225,63,193,276,302,527,341,-40,191,-71,-470,-403,-334,-570,-582,-266,-281,-114,171,-40,-86,119,-67,-277,-293,-183,-78,-81,-218,-69,-1,-32,27,31,-14,-4,49,-67,-232,-225,22,-164,-746,-801,-548,-187,364,452,393,466,291,-33,-398,-826,-1201,-853,141,383,101,-73,-92,94,108,260,486,506,400,157,-44,-186,-474,-604,-563,-484,-417,-350,-156,-80}
        },
        {    // H-30e036a.wav
            {-1,-2,-2,-2,-1,-2,-4,-2,-2,-3,1,-4,1,-12,7,-16,19,-18,12,152,2054,2293,-2454,-2782,-1380,-1974,1690,4544,3970,3406,5018,4699,1170,265,-533,-3330,-2714,-556,-1758,-2701,-2336,-1959,-1512,-984,210,1051,1172,1591,1530,1093,907,420,-351,-1007,-1275,-1560,-1854,-1373,-662,-424,-41,330,476,616,604,508,582,458,159,-82,-304,-407,-520,-640,-708,-688,-564,-483,-285,-33,53,141,232,250,155,104,55,-8,-23,-66,-114,-213,-293,-345,-384,-347,-302,-396,-463,-367,-190,85,283,271,189,48,-120,-262,-332,-386,-412,-254,-98,-49,-33,-87,-148,-128,-76,-36,51,76,9,-8,-44,-117,-171,-258},
            {-17,21,-61,70,-107,107,-153,168,120,7476,7987,-12699,-11638,-3227,-1309,12135,12461,6397,11659,22277,5166,-12807,-9259,-14848,-6859,5182,-1150,-7245,-4146,-1001,1043,536,-1888,-979,-1379,392,3303,1203,-244,677,1284,-190,-1013,-1366,-2349,-1290,264,-729,-1241,79,78,128,154,159,591,617,119,109,153,-251,-329,-322,-564,-703,-428,-369,-243,146,-52,-225,98,60,-126,-228,-246,-99,-14,-201,-152,7,-12,12,7,-13,7,16,-100,-188,-239,-103,28,-436,-823,-622,-367,142,477,378,423,409,138,-214,-602,-1053,-1167,-330,416,191,-100,-198,-54,82,232,557,615,503,316,54,-52,-323,-612,-593,-593,-496,-365,-195,-98,-55}
        },
        {    // H-30e042a.wav
            {1,0,-1,-1,-2,-1,-1,-4,0,-1,-1,3,-5,4,-10,10,-9,16,-12,14,97,1718,2216,-1940,-2620,-1201,-1575,1384,3750,3452,3032,4232,4446,1820,633,-261,-2756,-2673,-732,-1543,-2668,-2469,-1697,-1046,-624,481,1033,774,1164,1476,1111,790,373,-302,-939,-1208,-1456,-1601,-1080,-431,-313,-124,191,310,409,484,465,451,281,79,-55,-219,-347,-458,-554,-630,-618,-574,-478,-268,-56,30,104,175,181,167,122,61,56,18,-89,-166,-238,-290,-324,-364,-332,-320,-386,-337,-242,-88,118,199,157,77,-31,-182,-256,-240,-265,-271,-184,-124,-78,-63,-129,-198,-178,-100,-21,61,67,25,5,-44,-88,-155},
            {23,-61,59,-73,50,-68,73,-134,3994,11387,-5701,-16336,-5001,-2375,8134,13398,7308,10292,22767,11820,-11376,-9885,-13795,-9574,4243,202,-7152,-4957,-1634,-760,101,-1251,-889,-942,395,3115,1549,214,790,1422,-121,-1354,-1057,-2180,-1940,-312,-411,-1279,-135,50,61,280,116,399,646,482,163,134,-190,-242,-205,-528,-893,-587,-411,-411,45,72,-198,62,103,-78,-99,-175,-202,-106,-144,-176,-117,-106,20,74,25,-23,38,-82,-173,-196,-186,20,-126,-693,-730,-483,-137,409,423,341,421,240,-65,-403,-838,-1159,-764,180,311,-78,-261,-219,-22,121,503,746,620,452,196,9,-147,-512,-644,-629,-594,-419,-234,-120,-82,-16}
        },
        {    // H-30e048a.wav
            {3,0,1,0,0,-1,1,1,-1,1,0,1,6,-3,8,-7,12,-6,14,-7,11,65,1446,2080,-1513,-2436,-1028,-1172,1033,3020,3086,2701,3567,4159,2343,1068,-291,-2636,-2505,-612,-1194,-2541,-2389,-1266,-475,-384,182,688,622,979,1371,1113,672,221,-406,-882,-896,-1039,-1182,-865,-457,-403,-256,-4,154,313,328,279,298,186,68,-1,-162,-287,-387,-487,-555,-557,-529,-421,-230,-65,-10,20,78,133,156,137,57,20,-2,-66,-141,-234,-269,-318,-353,-335,-331,-304,-218,-125,14,96,66,41,8,-111,-229,-217,-161,-191,-227,-202,-131,-62,-98,-194,-236,-159,-70,-5,69,65,29,-2,-41,-89},
            {-6,-24,37,-83,95,-141,133,803,10293,4574,-16785,-10503,-2381,3577,12615,8696,8526,20147,19659,-5358,-11979,-11695,-11914,1655,1954,-6417,-6261,-2796,-2077,-409,-506,-980,-723,-84,2857,2735,843,453,1101,637,-1401,-1416,-2087,-2161,-846,-552,-1252,-286,245,-67,324,264,410,563,627,268,157,-38,-367,-356,-331,-752,-843,-576,-509,-63,169,-132,18,205,29,-55,-117,-214,-160,-136,-266,-179,-133,-83,-32,63,75,85,9,-148,-131,-130,-57,57,-418,-832,-600,-361,199,493,306,343,338,95,-233,-653,-1035,-963,-171,363,-11,-329,-312,-112,44,282,734,783,596,388,88,-74,-325,-583,-637,-647,-509,-279,-121,-101,-39,-1}
        },
        {    // H-30e054a.wav
            {1,1,0,0,0,0,0,0,0,-1,-1,2,3,3,1,4,-6,9,-10,15,-8,9,64,1234,1818,-1169,-2151,-881,-813,691,2414,2780,2363,3099,4114,2588,735,-540,-2127,-1891,-356,-1008,-2335,-1890,-750,-509,-587,-30,520,597,893,1197,923,382,-136,-285,-261,-430,-831,-1025,-835,-572,-484,-377,-157,55,156,139,105,156,135,93,38,-115,-231,-306,-382,-471,-482,-449,-358,-230,-139,-104,-47,31,70,102,82,19,37,34,-25,-104,-207,-288,-362,-352,-316,-264,-190,-125,-47,8,3,-29,-42,-93,-187,-204,-142,-131,-207,-240,-190,-117,-96,-162,-198,-176,-130,-67,18,61,34,14,-15,-61},
            {-53,69,-98,78,-103,114,-187,4840,12132,-8101,-17910,-4399,430,9455,10297,7196,15002,24266,6202,-12694,-10787,-12587,-2423,3595,-4199,-7922,-4891,-2851,-1322,469,-1085,-1154,-571,2193,3866,1710,469,908,1259,-941,-1830,-2091,-2637,-1528,-497,-1169,-902,488,97,203,491,593,533,574,505,192,11,-353,-535,-506,-570,-852,-681,-588,-312,184,14,-49,219,151,3,-26,-155,-211,-142,-283,-301,-213,-121,-102,-91,38,140,190,14,-113,-98,-63,87,-64,-744,-793,-522,-165,424,387,245,299,225,10,-405,-883,-1019,-537,223,183,-368,-469,-254,5,129,533,848,725,550,270,16,-212,-494,-610,-624,-568,-384,-152,-92,-69,4,8}
        },
        {    // H-30e060a.wav
            {0,1,1,1,1,0,2,0,-1,1,0,2,3,4,4,1,2,-2,7,-3,9,-2,6,99,1082,1433,-883,-1747,-763,-577,432,1894,2529,2496,2799,3252,2264,657,-366,-1251,-1241,-299,-659,-1798,-1696,-814,-554,-637,-119,464,477,686,868,439,175,256,278,45,-359,-788,-960,-833,-625,-521,-469,-273,-87,-74,-46,8,108,131,131,89,-57,-125,-228,-312,-386,-395,-369,-369,-292,-226,-161,-83,-37,28,37,61,85,90,60,-23,-99,-225,-317,-355,-314,-224,-165,-105,-102,-77,-47,-63,-73,-113,-152,-192,-148,-95,-153,-247,-280,-177,-83,-100,-143,-163,-145,-101,-39,17,19,10,-4,-36},
            {-44,73,-125,147,-206,229,341,10268,6792,-18415,-12407,-505,4337,11109,7264,9534,22679,19134,-7375,-12546,-11160,-6701,3719,-866,-8041,-7880,-3614,-2591,137,29,-1662,-965,926,3651,3020,1375,374,1610,575,-1980,-2491,-2865,-2252,-977,-674,-1348,-139,434,288,582,683,760,601,586,239,195,-194,-663,-665,-580,-797,-888,-563,-455,9,127,-115,104,266,148,19,-10,-131,-125,-216,-400,-327,-248,-166,-170,-70,82,211,213,51,-22,-40,11,174,-280,-872,-706,-498,66,448,245,236,215,157,-73,-594,-950,-762,-128,313,-128,-629,-519,-132,68,288,757,830,681,477,204,-75,-402,-578,-592,-571,-438,-249,-97,-80,-13,44,36}
        },
        {    // H-30e066a.wav
            {0,0,1,1,1,1,1,0,1,2,1,2,2,2,2,3,0,0,4,4,-5,6,7,-3,186,935,953,-625,-1245,-720,-513,342,1816,2524,2015,1886,2565,2328,977,-89,-524,-425,25,-702,-1750,-1501,-836,-643,-613,-182,181,200,273,503,683,640,502,345,87,-380,-821,-901,-762,-615,-602,-593,-444,-289,-201,-122,-2,137,174,173,131,6,-101,-167,-230,-314,-355,-410,-414,-341,-257,-185,-142,-49,22,63,97,93,102,61,-42,-173,-255,-281,-285,-214,-149,-129,-132,-132,-98,-79,-90,-118,-151,-181,-172,-116,-140,-238,-283,-237,-120,-48,-77,-124,-144,-129,-95,-35,6,-8,-19,-37},
            {8,-8,-32,48,-88,31,2377,13633,-2602,-22111,-5477,1694,7155,9866,5725,15481,25980,7391,-13415,-11193,-8670,484,2989,-5177,-10035,-6609,-2590,-2034,312,-791,-1218,-335,2312,3513,2374,959,1006,2041,-764,-2415,-2993,-3133,-1866,-574,-1214,-1192,339,443,431,708,1072,910,744,400,24,120,-347,-807,-816,-801,-994,-767,-529,-270,179,-21,-103,193,305,144,59,24,-34,-120,-385,-466,-376,-282,-250,-190,-24,163,281,199,72,38,4,97,189,-486,-875,-655,-436,198,293,159,214,154,161,-207,-771,-846,-402,157,188,-488,-770,-431,-64,68,471,834,783,653,393,163,-186,-536,-592,-558,-487,-315,-149,-86,-60,38,58,45}
        },
        {    // H-30e072a.wav
            {1,2,2,2,2,3,3,3,4,3,5,5,4,5,3,5,3,8,1,10,2,0,12,12,10,278,784,491,-379,-783,-781,-204,773,1312,1544,1639,1780,2350,2462,1240,243,510,364,-547,-1189,-1374,-1272,-974,-724,-644,-471,-294,-19,486,907,946,695,456,286,9,-497,-790,-725,-685,-758,-794,-684,-522,-366,-239,-89,102,165,184,194,138,40,-51,-124,-234,-308,-391,-454,-408,-321,-248,-196,-114,-33,27,82,109,123,88,6,-111,-201,-221,-219,-183,-160,-169,-144,-123,-111,-113,-125,-122,-134,-178,-223,-206,-153,-166,-219,-235,-169,-58,-22,-68,-137,-154,-117,-63,-15,-28,-52,-54},
            {60,-99,90,-102,108,-204,5148,13996,-11411,-20953,-116,2879,8162,7693,7360,21341,22758,-2335,-14838,-9374,-3626,3697,127,-7938,-10454,-4859,-2620,-2116,548,-1031,-1070,812,2854,2888,2166,475,1621,1893,-1412,-2768,-3112,-2762,-1797,-853,-1359,-768,382,409,390,975,1390,1027,846,233,-76,59,-486,-905,-882,-1001,-1140,-710,-447,-115,125,-119,-10,317,354,141,134,69,-8,-170,-470,-530,-394,-304,-321,-184,35,230,315,198,101,98,37,183,152,-603,-824,-639,-361,199,129,135,176,159,181,-356,-840,-662,-112,342,24,-766,-826,-349,-55,105,597,821,746,605,361,148,-281,-581,-547,-523,-396,-195,-90,-88,-16,33,26,54}
        },
        {    // H-30e078a.wav
            {0,0,0,0,1,1,2,2,2,3,1,2,1,0,0,0,3,2,1,2,8,-2,6,4,8,33,377,566,90,-133,-338,-277,-112,-92,658,1437,1917,2002,2166,2505,1910,919,479,-54,-948,-1249,-1094,-1147,-1211,-969,-857,-812,-224,582,971,949,838,618,322,101,-175,-496,-674,-733,-833,-923,-842,-679,-498,-336,-173,-2,129,166,170,187,143,70,-56,-201,-317,-377,-387,-383,-360,-313,-232,-156,-110,-43,21,96,153,114,15,-76,-126,-186,-211,-180,-151,-153,-166,-132,-114,-136,-157,-171,-171,-207,-262,-277,-199,-106,-131,-179,-158,-83,-44,-75,-126,-142,-111,-86,-67,-68,-84,-70},
            {91,-162,178,-222,261,-327,7336,12836,-17025,-18452,3113,3403,7344,6677,10571,23734,18066,-7869,-14817,-6580,645,4073,-2406,-9340,-9744,-3868,-3344,-2108,571,-1016,-843,1472,3092,2585,1674,211,2099,1433,-1676,-2671,-2950,-2520,-1707,-1279,-1451,-437,327,239,423,1216,1443,1098,966,272,-121,-61,-596,-957,-904,-1138,-1251,-759,-383,-28,26,-144,71,453,418,194,174,53,-62,-240,-449,-551,-420,-339,-359,-171,88,251,267,205,194,152,67,246,83,-687,-778,-650,-298,142,-7,152,161,217,142,-524,-832,-454,102,374,-164,-898,-773,-323,-109,179,671,799,688,533,362,130,-334,-572,-521,-479,-307,-97,-74,-109,8,14,0,36}
        },
        {    // H-30e084a.wav
            {0,0,0,0,0,1,1,2,2,2,3,1,1,0,-1,-1,3,0,-2,6,2,10,4,-6,4,13,91,381,313,35,522,9,-1049,-748,-68,995,1857,2125,2220,2602,2883,1672,214,-67,-165,-885,-1287,-1115,-1180,-1406,-1339,-879,-264,444,1009,1026,827,643,403,131,-76,-283,-556,-766,-890,-888,-874,-794,-598,-389,-207,-78,34,93,148,218,215,119,-34,-177,-294,-358,-354,-329,-311,-317,-294,-226,-141,-61,-9,50,119,155,92,-30,-116,-162,-184,-183,-171,-153,-136,-118,-133,-160,-186,-214,-239,-253,-281,-291,-208,-95,-51,-64,-91,-101,-100,-110,-132,-123,-99,-98,-109,-111,-97,-73},
            {110,-198,237,-297,363,-403,8492,11887,-19821,-16698,5070,3616,5905,6685,13157,23778,14435,-10960,-14084,-3476,3411,3734,-4415,-10033,-8759,-3623,-3951,-1905,340,-1333,-568,1968,3072,2579,1374,-21,2349,1292,-1978,-2740,-2343,-2135,-1762,-1445,-1575,-509,269,158,362,1237,1418,1112,1037,389,11,-143,-683,-931,-914,-1217,-1321,-799,-379,6,-12,-194,102,525,475,256,175,-3,-132,-255,-422,-516,-417,-340,-342,-178,69,232,273,216,214,178,102,293,60,-739,-800,-677,-275,74,-92,123,156,283,138,-570,-767,-305,192,333,-307,-957,-711,-339,-169,170,642,775,644,511,367,122,-292,-513,-522,-426,-230,-77,-102,-150,-28,-40,-29,26}
        },
        {    // H-30e090a.wav
            {0,0,0,0,1,1,2,3,3,2,3,2,0,1,-1,1,3,-1,2,5,3,7,9,2,-10,15,3,132,407,678,452,-427,-976,-946,-145,725,1438,2194,2671,3085,2483,1373,636,-43,-314,-333,-808,-1341,-1285,-1296,-1537,-1158,-111,593,806,1056,998,579,290,144,-42,-298,-559,-734,-843,-896,-835,-727,-621,-400,-227,-135,-32,59,143,161,181,122,-6,-152,-299,-343,-331,-286,-285,-308,-304,-246,-134,-73,-15,52,101,128,113,41,-61,-128,-186,-234,-216,-138,-102,-127,-155,-198,-233,-256,-263,-287,-308,-265,-180,-76,15,41,-14,-97,-152,-174,-146,-123,-121,-114,-126,-118,-86,-67},
            {119,-214,253,-313,385,-478,8163,12298,-19794,-16991,5944,3694,4462,6799,14322,23017,12645,-11947,-13088,-1200,4795,3726,-5659,-10317,-8040,-3847,-4295,-1889,103,-1713,-766,2192,3373,2424,1433,110,2211,1369,-2066,-2880,-2133,-1649,-1449,-1618,-1721,-549,-10,-52,434,1164,1284,1057,1054,513,135,-31,-662,-958,-879,-1179,-1396,-854,-357,-5,-54,-263,99,548,505,308,169,-33,-162,-274,-403,-461,-361,-322,-354,-183,77,228,244,206,205,189,129,280,52,-730,-768,-676,-307,-1,-167,109,183,354,141,-565,-674,-212,207,248,-393,-958,-654,-343,-192,125,566,753,635,542,377,112,-196,-439,-523,-396,-181,-68,-128,-194,-99,-100,-44,44}
        },
        {    // H-30e096a.wav
            {0,1,1,1,1,2,2,4,4,4,3,2,3,0,0,3,2,1,6,1,6,6,11,8,6,-16,7,38,691,1106,-286,-1112,-755,-296,250,817,1303,1991,3232,2905,1719,1060,345,58,-152,-517,-646,-773,-1282,-1425,-1262,-1032,-246,677,1035,960,883,622,243,19,-168,-379,-565,-766,-831,-798,-788,-648,-488,-397,-260,-107,-26,35,89,92,136,115,-46,-200,-267,-291,-342,-344,-306,-265,-218,-186,-137,-44,45,73,78,78,85,86,3,-109,-208,-274,-261,-166,-87,-124,-189,-237,-259,-266,-280,-280,-278,-233,-160,-50,72,98,23,-97,-180,-197,-169,-148,-150,-130,-107,-74,-57,-79},
            {105,-184,200,-229,271,-423,6167,13975,-16417,-19660,5484,4005,3257,6360,13852,22270,12926,-10932,-12670,92,5317,4132,-5639,-10555,-8062,-4158,-4355,-2416,46,-1991,-1303,2015,3616,2614,1710,238,2104,1742,-2034,-3006,-2065,-1583,-1219,-1278,-1823,-886,-191,-250,252,1132,1241,875,972,673,243,85,-496,-884,-840,-1085,-1373,-929,-449,-75,-64,-314,44,522,509,298,190,-24,-170,-274,-375,-401,-351,-300,-310,-146,100,200,179,134,177,168,73,245,127,-623,-729,-657,-392,-86,-205,96,217,387,166,-544,-617,-188,162,185,-400,-939,-648,-348,-195,89,481,698,628,591,411,104,-109,-366,-518,-386,-186,-83,-159,-244,-165,-139,-73,50}
        },
        {    // H-30e102a.wav
            {0,0,0,1,1,1,1,2,2,2,1,1,0,0,0,0,-1,2,0,4,0,8,1,13,5,-4,-21,396,1158,164,-1084,-962,-502,322,946,1084,1519,2647,2674,1826,1163,630,339,-221,-362,-478,-773,-768,-609,-801,-1311,-886,-19,596,1107,1129,693,442,347,-94,-453,-528,-632,-776,-850,-746,-660,-613,-443,-241,-125,-90,-54,12,83,97,33,-53,-94,-174,-301,-393,-396,-352,-311,-238,-164,-74,-12,22,64,73,61,46,53,55,8,-104,-253,-314,-279,-213,-158,-143,-209,-298,-303,-258,-226,-229,-237,-196,-107,-10,55,63,-9,-130,-197,-202,-200,-201,-165,-123,-79,-38,-47,-89},
            {49,-76,41,-20,-11,-66,3135,14950,-9112,-23272,2719,5066,2020,5578,11876,21385,14899,-8296,-12777,484,5608,4549,-4383,-10594,-8740,-4617,-4101,-3562,-157,-1596,-2091,1283,3871,2899,2056,640,1805,2350,-1513,-3101,-2230,-1595,-1304,-1140,-1590,-1080,-527,-410,94,869,1220,858,815,740,333,225,-248,-743,-711,-927,-1322,-1045,-578,-219,-74,-302,-33,461,486,266,178,30,-113,-249,-371,-382,-282,-210,-263,-143,96,190,111,38,43,98,61,247,266,-494,-714,-625,-422,-115,-259,49,260,409,179,-543,-608,-192,119,143,-345,-895,-659,-319,-189,45,418,649,606,616,458,115,-56,-288,-487,-386,-232,-136,-194,-260,-205,-150,-97,35}
        },
        {    // H-30e108a.wav
            {-1,0,1,2,1,3,1,1,3,4,2,2,1,0,3,-1,2,-1,1,1,6,0,5,10,5,5,230,1279,474,-1426,-1124,-451,274,967,1191,1583,2632,2991,1573,348,369,423,6,-143,-742,-1005,-677,-590,-296,-147,-467,-777,-101,849,1123,951,695,443,121,-207,-614,-777,-723,-757,-802,-806,-602,-404,-317,-177,-28,40,36,60,8,-31,-32,-90,-187,-325,-391,-414,-421,-383,-302,-147,-44,28,101,117,107,63,24,-13,28,59,-21,-137,-286,-349,-326,-246,-179,-215,-286,-317,-247,-179,-155,-157,-164,-112,-59,-21,-19,-31,-70,-162,-191,-210,-213,-182,-142,-91,-60,-13,-25,-78},
            {-50,82,-172,226,-327,392,347,12728,1903,-24343,-4395,6941,863,4537,9115,18920,18291,-3342,-13089,-610,6068,4908,-2322,-9818,-9687,-5840,-3699,-4538,-1372,-705,-2439,1,3700,3430,2331,1278,1509,2958,-508,-2944,-2334,-1839,-1577,-1242,-1576,-1213,-570,-661,-229,657,1158,846,745,835,380,298,142,-549,-670,-724,-1179,-1206,-759,-391,-136,-248,-124,343,442,245,176,65,-94,-190,-267,-310,-280,-130,-189,-180,9,130,43,-63,-58,23,62,201,373,-264,-671,-601,-470,-128,-236,-29,256,375,177,-527,-614,-224,32,101,-240,-774,-671,-306,-175,-15,355,609,556,603,503,138,-23,-202,-452,-407,-300,-201,-215,-271,-222,-160,-108,9}
        },
        {    // H-30e114a.wav
            {-1,0,0,1,1,1,1,0,2,1,1,0,-1,1,0,0,2,-4,-2,-1,5,-11,17,-9,27,108,1310,1099,-1591,-1777,-642,326,1223,1377,1534,2598,3681,2065,128,-176,-433,-421,-81,-546,-1029,-1104,-995,-185,192,90,225,118,87,598,1008,875,610,429,-21,-543,-724,-809,-916,-877,-752,-626,-502,-364,-164,-37,55,195,139,-23,-28,-33,-169,-293,-320,-355,-451,-503,-453,-330,-187,-70,31,136,188,157,99,24,3,4,-11,-3,-52,-182,-333,-393,-373,-312,-241,-263,-312,-282,-166,-69,-58,-76,-89,-60,-62,-122,-142,-132,-146,-198,-231,-201,-154,-122,-108,-71,-27,-6,-21,-52},
            {-92,130,-203,212,-267,325,-468,6733,11391,-16986,-15190,6702,1471,2275,7361,14054,20408,4658,-11996,-3482,6344,5551,-278,-7863,-10037,-7715,-4180,-4410,-3391,-535,-1930,-1326,2807,3951,2591,2037,1381,3212,1257,-2652,-2431,-1753,-1963,-1711,-1644,-1553,-778,-632,-516,167,1097,1043,625,868,691,324,363,-184,-608,-631,-1007,-1241,-958,-610,-267,-210,-228,187,418,264,107,93,-14,-85,-133,-188,-266,-167,-127,-231,-160,5,30,-82,-123,-56,38,143,423,-17,-587,-564,-488,-167,-190,-104,201,334,183,-483,-663,-270,-55,20,-125,-614,-656,-294,-156,-74,262,555,496,542,533,196,-3,-133,-416,-440,-362,-269,-226,-305,-248,-155,-84,-17}
        },
        {    // H-30e120a.wav
            {0,1,1,1,3,1,0,2,1,2,2,1,3,3,1,4,-2,4,-9,14,-16,18,-19,36,29,1191,1835,-1438,-2548,-919,140,1343,1707,1736,2715,4180,2677,132,-383,-590,-837,-947,-1036,-1057,-1122,-1128,-591,-69,307,679,701,819,814,474,354,728,798,127,-329,-514,-875,-1086,-970,-773,-630,-488,-398,-235,24,171,121,56,168,171,-74,-310,-341,-304,-397,-492,-487,-428,-348,-260,-140,6,156,199,128,100,115,83,21,-10,-25,-70,-143,-234,-350,-442,-404,-313,-308,-315,-260,-147,-46,7,14,12,19,-43,-160,-251,-257,-223,-208,-229,-242,-164,-67,-23,-24,-26,1,20,10,-18},
            {-10,-12,22,-86,125,-195,203,1076,12285,-1482,-21537,-908,5040,-972,5940,10074,17361,13458,-6604,-7203,5179,6871,1479,-5530,-9083,-8894,-6243,-4193,-4490,-1806,-1031,-2232,1046,4304,3098,2471,1848,2637,3185,-1022,-2875,-1851,-1814,-2144,-2020,-2008,-1257,-776,-602,-189,633,1287,876,761,954,615,441,170,-454,-599,-820,-1209,-1097,-791,-519,-274,-285,20,346,303,131,142,145,21,-46,-105,-167,-229,-214,-297,-251,-61,3,-92,-138,-101,23,92,381,217,-485,-527,-446,-209,-145,-179,116,338,260,-416,-743,-339,-80,-68,-80,-426,-608,-294,-113,-97,141,474,452,465,539,280,58,-74,-361,-479,-397,-324,-225,-307,-302,-154,-45,-2}
        },
        {    // H-30e126a.wav
            {0,0,1,1,2,-1,2,0,0,2,0,1,5,1,7,-4,9,-11,13,-10,12,-13,17,-2,922,2510,-855,-3450,-1339,93,1322,1862,1932,2890,4811,3668,97,-909,-696,-844,-1168,-1400,-1844,-1778,-1207,-705,-105,121,380,893,1368,1431,1029,475,239,388,412,59,-556,-865,-870,-937,-942,-809,-546,-300,-67,72,-14,26,233,274,77,-109,-197,-280,-401,-508,-534,-483,-378,-300,-248,-165,-43,48,74,95,133,131,101,81,49,-9,-96,-180,-256,-325,-367,-374,-332,-354,-404,-332,-159,5,57,37,39,84,63,-96,-284,-378,-366,-299,-255,-273,-229,-92,7,61,66,53,51,26,12,-25},
            {53,-93,109,-146,154,-190,231,-347,5245,10729,-12981,-14470,5437,48,861,9125,12012,16286,4178,-8442,1260,8180,3811,-3284,-7847,-8276,-7869,-5862,-4740,-3593,-898,-1624,-1361,3014,4213,2843,2650,2116,3491,1771,-1988,-2253,-1848,-2372,-2290,-2296,-2044,-1223,-945,-338,275,1052,1217,908,1053,991,595,416,-139,-589,-651,-1049,-1230,-953,-763,-525,-350,-230,231,448,296,137,211,197,53,-97,-203,-278,-243,-248,-327,-210,-40,-59,-110,-106,-41,40,240,389,-278,-583,-424,-256,-62,-140,-15,239,376,-207,-792,-466,-88,-166,-135,-246,-542,-371,-115,-65,57,370,393,336,535,390,136,-8,-282,-518,-447,-344,-267,-285,-367,-205,-27,21}
        },
        {    // H-30e132a.wav
            {1,2,2,2,1,2,0,1,2,1,-1,6,0,7,-2,8,-5,6,-1,-2,14,-8,12,597,2982,154,-4370,-2125,149,1382,2106,2012,2928,5414,4920,406,-1426,-1094,-1057,-1253,-1508,-2130,-2264,-1831,-1294,-102,223,294,778,1163,1612,1640,990,501,589,189,-516,-620,-485,-640,-879,-929,-860,-559,-210,-71,-8,50,176,270,152,-13,-31,-146,-317,-403,-515,-587,-540,-398,-277,-149,-59,-73,-73,-8,37,61,119,129,95,54,-8,-77,-193,-302,-328,-313,-298,-259,-273,-401,-446,-293,-64,99,114,58,87,117,5,-226,-393,-429,-405,-355,-337,-273,-132,-22,53,115,172,183,116,23,-36,-85},
            {-13,31,-64,85,-139,182,-250,307,20,8754,4579,-17197,-5784,4749,-2700,4427,10700,12653,12122,-1523,-3951,6881,6841,-293,-6288,-7968,-7267,-7368,-6006,-4960,-2581,-580,-1577,169,3764,3602,3122,2909,2776,3369,233,-2086,-1560,-2061,-3012,-2652,-2405,-1780,-1340,-975,17,813,1251,1135,1152,1264,918,556,297,-359,-623,-796,-1178,-1161,-957,-850,-510,-272,10,398,458,337,294,245,53,-88,-157,-199,-271,-263,-308,-284,-122,-23,-86,-105,-72,6,94,342,43,-564,-453,-271,-48,-3,-39,85,382,144,-653,-635,-118,-145,-291,-218,-435,-431,-174,-57,45,289,410,246,439,540,273,49,-188,-439,-477,-359,-324,-288,-381,-290,-45,51}
        },
        {    // H-30e138a.wav
            {1,1,1,0,2,0,-1,1,1,-3,3,2,5,1,3,4,-4,16,-23,35,-32,55,306,3192,1448,-5043,-3328,169,1490,2426,2247,3003,5793,6067,999,-1824,-1529,-1245,-1423,-1798,-2294,-2602,-2221,-1617,-447,-13,332,842,1140,1622,1510,1164,997,959,287,-592,-899,-880,-699,-622,-687,-625,-303,-253,-293,20,241,288,208,126,72,-61,-222,-377,-447,-493,-539,-575,-487,-276,-113,-72,-71,5,50,-2,15,69,73,69,2,-83,-123,-168,-239,-305,-302,-254,-183,-149,-286,-452,-422,-208,20,124,103,95,145,74,-143,-362,-451,-449,-394,-357,-358,-209,-39,11,87,206,289,238,105,20,-55,-138},
            {-12,21,-20,1,4,-42,70,-115,97,1280,9929,-1585,-15927,-452,1374,-2195,7218,10651,12295,7772,-2534,1761,8453,3131,-3297,-7127,-7514,-6654,-7135,-6215,-4788,-1605,-632,-1234,1633,3973,3146,3221,3133,3344,2678,-854,-1862,-1296,-2336,-3137,-3059,-2628,-1509,-1163,-803,208,1132,1399,1209,1204,1249,844,555,159,-506,-697,-996,-1288,-1120,-901,-762,-477,-254,204,558,451,257,232,178,45,-116,-208,-259,-276,-249,-304,-252,-85,-29,-115,-136,-75,-9,159,248,-331,-537,-301,-129,31,31,31,241,409,-291,-751,-297,-60,-384,-414,-417,-478,-230,-136,-12,189,399,326,319,539,382,135,-87,-319,-479,-437,-388,-358,-374,-409,-187,21}
        },
        {    // H-30e144a.wav
            {3,0,1,0,0,-1,1,0,-3,2,2,2,4,-7,12,-18,29,-36,48,-53,96,94,3129,2879,-5279,-4897,11,1641,2756,2538,3176,6243,7141,1594,-2202,-1997,-1483,-1454,-1980,-2601,-3089,-2531,-1858,-642,29,24,625,1312,1769,1757,1307,651,831,694,-312,-1003,-1147,-1062,-943,-498,-162,-161,-139,-5,163,203,207,285,275,94,-88,-293,-521,-519,-501,-565,-545,-434,-351,-283,-141,-17,82,142,109,51,51,47,-19,-129,-213,-192,-148,-203,-270,-261,-211,-150,-68,-156,-409,-464,-304,-92,53,82,80,149,164,-38,-345,-483,-474,-397,-332,-373,-302,-98,24,68,152,270,285,180,86,21,-78,-193},
            {22,-29,41,-51,45,-54,40,-38,30,-81,2624,9307,-5468,-12607,1009,-1363,-30,8185,9921,11334,5576,-838,5610,7003,-536,-4549,-7232,-6792,-6379,-7067,-6169,-4310,-983,-576,-628,2226,3989,3390,3338,2815,3162,2017,-1015,-1459,-1685,-2781,-2886,-2813,-2594,-1665,-1121,-339,626,1192,1284,1193,1276,1242,797,461,-99,-612,-711,-1017,-1220,-1066,-922,-677,-363,-170,251,471,366,286,280,154,-9,-144,-208,-258,-274,-256,-284,-220,-79,-67,-146,-169,-98,19,254,52,-502,-422,-210,-24,108,69,100,427,194,-585,-571,-122,-277,-581,-484,-529,-352,-176,-129,130,373,431,304,441,482,276,21,-218,-391,-483,-440,-435,-399,-451,-368,-84}
        },
        {    // H-30e150a.wav
            {3,2,0,1,-1,1,0,-2,0,5,-1,8,-11,18,-25,35,-45,59,-64,112,-5,2888,4217,-5055,-6597,-414,1795,3165,2914,3389,6698,8096,2348,-2421,-2573,-1939,-1554,-2058,-2736,-3485,-3021,-2170,-784,135,-22,419,1204,2010,2057,1432,586,802,647,-472,-965,-1201,-1205,-939,-754,-644,-106,434,414,357,464,385,241,290,210,-111,-387,-604,-629,-556,-550,-589,-562,-407,-238,-164,-107,81,244,233,146,100,3,-103,-166,-225,-245,-207,-213,-246,-239,-195,-123,-16,-34,-315,-489,-398,-155,41,51,7,93,220,95,-258,-497,-498,-427,-317,-319,-338,-173,-10,93,172,238,262,170,114,97,-2,-128,-246},
            {-10,25,-34,44,-63,64,-87,88,-107,119,-154,3540,8083,-6944,-9805,198,-2318,1828,7918,9254,10515,5342,1671,6819,3855,-2550,-4640,-7324,-6368,-6082,-6803,-5841,-3697,-911,-383,251,2566,3626,3294,3543,2795,2546,1159,-896,-1129,-1945,-2943,-2782,-2624,-2224,-1393,-1051,-181,828,1237,1227,1165,1215,1063,669,402,-182,-649,-728,-993,-1111,-1001,-930,-656,-307,-55,281,358,303,333,287,103,-30,-146,-223,-276,-272,-246,-261,-191,-115,-116,-147,-128,-101,75,288,-173,-549,-327,-135,75,160,54,195,428,-88,-598,-364,-197,-539,-620,-535,-540,-256,-163,0,338,455,376,343,467,411,166,-120,-294,-428,-478,-469,-487,-487,-449,-218}
        },
        {    // H-30e156a.wav
            {3,-1,2,-3,1,0,-3,-3,5,-3,11,-16,18,-27,33,-45,49,-54,91,-15,2617,5241,-4448,-8187,-1107,1828,3558,3545,3701,7154,8766,3052,-2360,-2980,-2489,-1963,-2200,-2751,-3780,-3484,-2488,-1025,247,-83,413,1368,2030,2078,1562,807,772,604,-497,-1215,-1291,-1120,-1149,-1088,-724,-226,146,499,918,972,686,503,380,110,-159,-344,-603,-664,-648,-753,-781,-618,-409,-281,-128,-24,87,215,264,175,77,-3,-64,-118,-215,-260,-218,-207,-252,-265,-215,-134,-27,38,-213,-474,-441,-246,-12,69,6,9,148,173,-119,-425,-478,-473,-382,-290,-308,-226,-78,69,186,236,269,189,98,105,52,-64,-193,-335},
            {5,-8,20,-27,41,-58,66,-93,108,-137,164,-151,4028,6816,-6868,-8084,-1231,-2121,2733,7252,8936,10046,5967,3886,6091,687,-3288,-4442,-7246,-5893,-5763,-6489,-5307,-3120,-791,-257,684,2838,3416,2939,3258,2661,2395,778,-1081,-1266,-1998,-2637,-2610,-2631,-1913,-910,-632,37,683,996,1182,1162,1138,937,512,268,-222,-601,-725,-1006,-1090,-925,-754,-502,-305,-89,255,327,303,302,211,51,-53,-180,-253,-269,-225,-183,-207,-182,-150,-124,-116,-103,-60,184,168,-376,-519,-285,-96,154,148,8,281,330,-221,-476,-277,-384,-696,-582,-580,-490,-162,-75,212,457,402,289,356,453,312,30,-169,-272,-427,-498,-548,-561,-493,-336}
        },
        {    // H-30e162a.wav
            {-1,-1,-2,-2,-2,-5,-6,3,-6,9,-19,16,-29,28,-42,34,-39,60,5,2428,5878,-3628,-9415,-2045,1773,3690,4337,4367,7627,9118,3565,-2059,-3215,-2892,-2513,-2702,-2797,-3799,-3955,-2862,-1392,301,250,254,1324,2170,2268,1808,724,708,731,-483,-1178,-1431,-1609,-1423,-972,-672,-452,-43,440,782,1145,1198,842,527,282,-35,-275,-596,-788,-787,-850,-874,-801,-590,-286,-42,47,129,208,190,93,77,61,-14,-93,-162,-227,-240,-214,-239,-251,-226,-170,-98,39,-84,-457,-530,-335,-40,116,-1,-59,75,186,-7,-344,-449,-471,-444,-303,-316,-297,-128,37,177,213,246,217,121,128,102,-11,-140,-324,-482},
            {-5,6,-6,16,-20,30,-50,58,-86,101,-136,164,-117,4019,6156,-5974,-7728,-2356,-1648,2949,6852,8701,9987,6920,5063,4363,-1413,-3335,-4731,-6980,-5016,-5261,-6179,-4968,-2729,-515,11,766,2594,3206,2987,3027,2175,1995,778,-781,-1473,-2373,-2554,-2297,-2216,-1522,-797,-459,381,853,927,984,951,993,817,406,132,-346,-606,-669,-864,-898,-784,-723,-529,-271,-43,209,242,263,239,115,-5,-97,-203,-223,-201,-145,-135,-183,-170,-111,-76,-79,-99,-49,184,-26,-523,-537,-315,-9,245,90,39,350,221,-267,-393,-312,-566,-690,-573,-637,-326,-24,67,352,408,272,220,350,386,207,0,-134,-285,-433,-542,-654,-607,-425}
        },
        {    // H-30e168a.wav
            {0,-3,0,0,-3,-4,4,-4,12,-16,16,-27,25,-34,25,-33,52,12,2448,6100,-2975,-9908,-3119,1558,3733,4911,5336,8330,9215,3848,-1621,-3340,-3152,-2980,-3286,-3077,-3855,-4250,-3340,-1519,351,272,229,1342,2402,2397,1934,897,772,847,-393,-1395,-1790,-1752,-1516,-1211,-771,-250,40,355,729,980,997,941,904,642,191,-173,-616,-826,-733,-863,-1013,-897,-624,-357,-130,11,113,193,223,160,87,48,23,-40,-109,-169,-201,-217,-230,-221,-224,-203,-158,20,48,-373,-622,-432,-100,157,75,-75,29,195,79,-273,-436,-452,-472,-345,-322,-334,-155,17,162,192,194,226,198,187,158,66,-73,-283,-468,-531},
            {-3,-3,3,-3,12,-16,23,-40,44,-71,81,-115,141,-62,3804,5792,-4989,-7835,-3179,-1224,3240,6627,8214,9945,7947,5242,2510,-2500,-3639,-4769,-6192,-4401,-4754,-5586,-4638,-2633,-323,246,756,2319,2879,2816,2993,2089,1580,477,-801,-1458,-2178,-2397,-2344,-2061,-1164,-405,-117,446,803,987,1021,794,680,492,245,99,-302,-498,-487,-641,-825,-861,-740,-492,-273,-85,132,196,220,162,46,-27,-72,-174,-204,-167,-76,-60,-121,-112,-46,-30,-110,-206,-95,109,-263,-636,-499,-234,106,263,65,140,351,90,-288,-369,-422,-683,-634,-547,-518,-143,45,175,361,285,173,201,315,305,173,29,-108,-311,-509,-645,-681,-540}
        },
        {    // H-30e174a.wav
            {-3,0,-1,-3,-6,4,-4,10,-13,14,-27,24,-38,32,-48,68,-5,2649,6076,-2796,-9688,-3982,993,3812,5338,6216,9122,9322,4104,-1121,-3440,-3372,-3386,-3899,-3383,-4141,-4425,-3399,-2024,35,415,510,1524,2335,2439,2134,1311,1126,673,-715,-1480,-1804,-1900,-1835,-1433,-708,-170,78,431,702,898,951,789,753,705,416,33,-457,-742,-766,-843,-911,-822,-676,-471,-274,-143,39,187,253,180,137,90,4,-62,-98,-103,-119,-166,-200,-196,-211,-260,-243,-69,108,-213,-630,-538,-223,146,200,-16,19,197,110,-209,-415,-468,-540,-427,-324,-360,-184,22,136,171,160,188,214,254,243,134,-9,-200,-412,-530,-581},
            {-1,-3,-4,2,-3,9,-14,18,-36,36,-58,60,-90,115,-35,3409,5829,-4028,-8355,-3855,-634,3644,6257,7582,9836,8774,5058,801,-3187,-3650,-4599,-5263,-3749,-4594,-5257,-4131,-2274,-279,189,632,1985,2768,2925,2721,1657,1425,577,-886,-1691,-2094,-2085,-2030,-1833,-1105,-322,123,606,756,873,960,811,605,319,85,35,-141,-265,-417,-723,-880,-852,-755,-552,-309,-109,95,170,178,95,33,22,-48,-138,-137,-107,-27,-29,-91,-73,-52,-125,-249,-282,-80,19,-424,-656,-441,-112,233,221,37,204,278,-19,-329,-415,-554,-694,-497,-457,-372,-47,99,202,260,190,136,196,294,261,157,36,-157,-423,-606,-672,-619}
        },
        {    // H-30e180a.wav
            {0,0,-3,-3,3,-2,12,-13,17,-29,31,-47,47,-65,93,-17,3020,5957,-3258,-9053,-4186,259,3912,5779,6878,9599,9235,4533,-429,-3516,-3588,-3814,-4529,-3766,-4184,-4784,-3869,-2036,-90,223,520,1809,2513,2732,2647,1445,936,543,-561,-1483,-2047,-2156,-1918,-1464,-774,-232,-57,400,865,1047,911,667,557,444,315,205,-193,-543,-638,-732,-845,-848,-739,-530,-310,-128,44,101,161,157,133,75,-11,-93,-104,-59,-29,-72,-136,-129,-133,-215,-295,-236,16,-55,-523,-606,-356,-3,261,140,31,202,184,-111,-369,-451,-592,-579,-362,-376,-258,-3,123,183,166,143,160,238,293,231,109,-62,-293,-498,-594,-638},
            {0,0,-3,-3,3,-2,12,-13,17,-29,31,-47,47,-65,93,-17,3020,5957,-3258,-9053,-4186,259,3912,5779,6878,9599,9235,4533,-429,-3516,-3588,-3814,-4529,-3766,-4184,-4784,-3869,-2036,-90,223,520,1809,2513,2732,2647,1445,936,543,-561,-1483,-2047,-2156,-1918,-1464,-774,-232,-57,400,865,1047,911,667,557,444,315,205,-193,-543,-638,-732,-845,-848,-739,-530,-310,-128,44,101,161,157,133,75,-11,-93,-104,-59,-29,-72,-136,-129,-133,-215,-295,-236,16,-55,-523,-606,-356,-3,261,140,31,202,184,-111,-369,-451,-592,-579,-362,-376,-258,-3,123,183,166,143,160,238,293,231,109,-62,-293,-498,-594,-638}
        }
    },
    {    // elev-40
        {    // H-40e000a.wav
            {-8,8,-6,14,-12,18,-27,20,-20,10,-17,20,-39,2138,6623,-2555,-8071,181,-1297,1448,8830,7885,3327,4823,10354,2975,-4886,-3540,-6390,-7410,-431,-2190,-6705,-3865,-1268,-716,-437,1002,1574,883,1711,3056,942,46,535,301,-300,-1129,-1019,-1168,-1324,-677,-708,-996,-198,229,88,292,510,662,449,-66,-51,-456,-517,136,238,177,280,180,-10,-369,-563,-780,-1233,-1004,-476,-175,175,349,472,513,292,268,32,-320,-548,-635,-472,-203,-30,75,49,31,52,-76,-118,-90,-59,-145,-252,-208,-118,-103,-96,-191,-281,-246,-184,-178,-119,2,45,58,94,103,57,-30,-82,-109,-152,-187,-226,-214,-266,-249,-149,-44},
            {-8,8,-6,14,-12,18,-27,20,-20,10,-17,20,-39,2138,6623,-2555,-8071,181,-1297,1448,8830,7885,3327,4823,10354,2975,-4886,-3540,-6390,-7410,-431,-2190,-6705,-3865,-1268,-716,-437,1002,1574,883,1711,3056,942,46,535,301,-300,-1129,-1019,-1168,-1324,-677,-708,-996,-198,229,88,292,510,662,449,-66,-51,-456,-517,136,238,177,280,180,-10,-369,-563,-780,-1233,-1004,-476,-175,175,349,472,513,292,268,32,-320,-548,-635,-472,-203,-30,75,49,31,52,-76,-118,-90,-59,-145,-252,-208,-118,-103,-96,-191,-281,-246,-184,-178,-119,2,45,58,94,103,57,-30,-82,-109,-152,-187,-226,-214,-266,-249,-149,-44}
        },
        {    // H-40e006a.wav
            {0,-5,6,-2,9,0,4,-2,-7,11,-22,27,-33,27,773,5186,1511,-7266,-3093,-1911,-1127,6838,8155,5111,4292,8061,6269,-1041,-2356,-4349,-7785,-3072,-363,-4268,-4977,-3159,-1305,-516,308,1126,759,986,2655,2071,599,667,596,-123,-772,-998,-1304,-1462,-1016,-735,-871,-564,-161,159,436,460,293,260,-85,185,673,409,376,353,-4,-260,-329,-359,-759,-1120,-956,-804,-483,3,150,266,499,500,415,74,-204,-451,-676,-517,-250,-114,-42,39,144,115,-47,-67,-97,-66,-79,-248,-359,-287,-214,-205,-172,-135,-116,-51,-28,-52,-66,-72,-28,47,54,-24,-54,-88,-117,-92,-43,-86,-72,-83,-230,-251,-196,-146},
            {3,-3,12,-7,8,-10,-10,15,-34,34,-56,38,1078,6965,703,-9834,-1650,-665,-346,8622,9657,4712,3507,11023,6150,-5439,-4622,-5772,-8484,-1101,-573,-7161,-5119,-1559,-1085,-1240,485,1738,1296,1681,3420,1838,266,695,240,-220,-1200,-1494,-1421,-1476,-847,-571,-1011,-294,429,272,285,483,593,507,-136,-209,-367,-698,-32,305,162,227,134,13,-252,-573,-790,-1277,-1109,-424,-62,179,375,460,621,455,306,46,-385,-593,-717,-579,-307,-135,-17,24,17,101,18,-20,29,56,-23,-172,-209,-146,-147,-154,-245,-366,-342,-253,-194,-153,-42,8,31,94,124,99,58,2,-32,-128,-188,-275,-332,-323,-303,-189,-94,56}
        },
        {    // H-40e013a.wav
            {-1,-2,-5,4,-3,9,-4,9,-13,4,-4,-4,6,-3,-7,1234,4979,-188,-6510,-2072,-2010,294,6581,6614,4600,4571,7669,4762,-1084,-1914,-4448,-6839,-2684,-964,-4253,-4738,-2447,-600,-392,232,1103,1045,1459,2273,1266,589,900,388,-513,-946,-1097,-1277,-1296,-959,-742,-682,-394,-31,302,422,299,309,324,73,504,667,392,382,113,-243,-413,-440,-494,-879,-1042,-820,-645,-253,84,174,303,342,317,230,-43,-234,-481,-591,-373,-156,-64,4,88,145,11,-90,-116,-184,-132,-188,-329,-346,-233,-187,-171,-132,-140,-96,3,-7,-51,-44,-17,17,48,1,-76,-119,-174,-175,-97,-54,-71,-44,-101,-185,-160,-142},
            {1,5,5,-8,14,-37,46,-66,74,-109,114,316,6214,4417,-10039,-4795,301,-1812,7497,11056,6616,2863,10367,9593,-5041,-5920,-5091,-9296,-2217,916,-7110,-6565,-1852,-1500,-2522,-73,2718,1897,1177,3415,2967,753,1036,181,-575,-1134,-1536,-1849,-1976,-1096,-495,-938,-351,627,476,344,493,635,662,-3,-385,-331,-765,-326,308,101,92,56,-20,-109,-483,-715,-1244,-1264,-489,47,289,454,492,581,524,410,170,-354,-647,-817,-743,-366,-143,-114,-24,23,162,142,32,80,145,122,-39,-173,-152,-129,-157,-274,-441,-432,-351,-230,-153,-51,17,22,73,135,142,104,48,36,-51,-162,-244,-372,-401,-352,-229,-100,6,154}
        },
        {    // H-40e019a.wav
            {-1,0,-2,-4,4,-2,10,-5,9,-10,3,-3,-1,8,1,-3,1146,4361,-152,-5565,-1943,-1518,556,5161,5653,4534,4314,6781,4367,-394,-1565,-3963,-6075,-2691,-1092,-4080,-4393,-2012,-344,-398,122,1123,1367,1655,1897,1061,667,710,18,-807,-1125,-1043,-1079,-1270,-964,-534,-447,-260,68,373,455,374,453,372,188,513,435,285,266,-23,-350,-537,-502,-661,-1041,-1016,-664,-394,4,235,283,325,241,189,69,-147,-335,-580,-548,-268,-71,-20,2,80,85,-33,-91,-148,-205,-166,-217,-316,-290,-190,-184,-173,-135,-128,-50,15,-19,-50,-14,25,40,10,-60,-102,-162,-220,-191,-104,-79,-37,16,-37,-92,-123},
            {1,14,-19,29,-52,57,-72,77,-110,122,31,5387,6874,-9243,-7892,473,-2125,6565,11845,8198,3471,9515,11245,-3526,-6667,-6127,-9312,-2233,1026,-7119,-7280,-2614,-2542,-3415,-136,3980,2667,850,3213,3863,1429,1017,227,-769,-1554,-1665,-1905,-2403,-1527,-580,-945,-376,823,653,383,628,833,832,227,-361,-406,-893,-714,92,89,-5,36,-75,-138,-397,-618,-1186,-1324,-581,120,474,595,517,476,472,435,270,-292,-653,-842,-836,-505,-220,-173,-60,68,249,288,120,98,162,182,88,-71,-144,-151,-150,-261,-498,-500,-447,-328,-167,8,85,29,55,108,132,126,84,56,-3,-126,-205,-365,-468,-391,-250,-109,1,124,208}
        },
        {    // H-40e026a.wav
            {-3,0,0,-3,-2,4,-1,9,-4,9,-12,12,-12,15,-8,19,-2,1462,3902,-1131,-4775,-1378,-1085,992,4361,5145,4195,4263,6127,3479,-205,-1507,-4122,-5419,-1890,-1362,-4252,-3778,-1310,-198,-371,295,1174,1490,1708,1700,866,471,367,-287,-983,-1072,-893,-1110,-1252,-703,-321,-325,-138,210,491,574,569,461,145,147,393,226,165,90,-136,-416,-574,-636,-896,-1086,-818,-418,-99,254,376,384,328,183,30,-167,-324,-478,-626,-487,-172,24,8,-28,42,55,-35,-112,-171,-177,-150,-214,-267,-217,-186,-230,-184,-129,-93,-28,-11,-22,-12,8,23,13,-42,-99,-149,-194,-228,-165,-79,-21,61,49,-38,-111},
            {21,-22,29,-39,33,-31,20,-31,23,-71,2929,9258,-4107,-12310,-867,-1651,3581,11833,10015,4992,6548,13718,1525,-7692,-6548,-9955,-3719,1911,-6044,-8742,-3878,-3094,-3832,-761,3897,3525,1409,2898,4130,2055,1172,280,-578,-1438,-2133,-2084,-2355,-1795,-841,-1067,-695,693,764,521,794,977,938,589,-156,-467,-847,-1132,-389,32,-30,109,2,-107,-343,-484,-967,-1373,-806,-70,442,658,590,449,386,350,356,-56,-517,-805,-903,-637,-270,-183,-160,-2,201,369,259,140,138,168,164,70,-62,-129,-155,-237,-488,-563,-494,-414,-232,-23,133,107,63,59,58,110,103,38,27,-74,-147,-272,-445,-468,-327,-161,-25,104,186,159}
        },
        {    // H-40e032a.wav
            {0,-1,0,0,-1,-1,3,0,8,-4,9,-8,11,-9,15,-6,20,-6,1287,3393,-893,-4102,-1069,-741,431,3542,4758,3882,3883,5344,3326,258,-1321,-3854,-4657,-1544,-1517,-3938,-3168,-893,-105,-396,310,1217,1459,1363,1346,886,419,89,-464,-833,-817,-854,-1139,-1063,-463,-240,-341,-136,402,738,631,502,293,33,53,107,41,19,-113,-267,-473,-543,-633,-850,-882,-597,-216,102,361,440,399,215,27,-121,-309,-488,-606,-590,-348,-52,43,-67,-67,37,37,-42,-109,-155,-172,-149,-174,-201,-183,-213,-255,-173,-100,-73,-54,-27,3,-24,-36,-9,-19,-86,-133,-181,-232,-194,-57,13,44,80,16,-74},
            {-9,9,-17,-6,16,-42,42,-80,34,1411,9356,875,-14134,-4053,-518,1880,11433,10948,5370,5553,15640,5275,-7722,-7392,-10962,-4459,2308,-4959,-9899,-5844,-3402,-2974,-961,2861,3749,2334,3449,4307,2162,1093,201,-468,-1183,-2494,-2683,-2359,-1719,-1006,-1056,-931,534,811,726,862,970,1065,827,60,-507,-849,-1390,-874,-53,-16,78,141,6,-267,-452,-797,-1301,-903,-233,300,517,549,471,354,313,383,152,-323,-746,-979,-754,-363,-163,-140,-21,122,316,302,155,138,179,169,174,80,-50,-115,-218,-484,-630,-582,-484,-237,-44,136,157,86,51,14,45,45,-6,20,-13,-95,-205,-370,-471,-406,-208,-71,53,143,154,144}
        },
        {    // H-40e039a.wav
            {0,1,0,0,0,-1,1,2,2,6,1,9,-8,14,-9,17,-15,29,24,1543,2820,-1589,-3226,-529,-851,557,3488,4310,3450,3800,4656,2614,257,-1433,-3774,-3711,-1249,-2000,-3364,-2098,-521,-266,-290,562,1202,1148,925,1088,875,448,-47,-550,-645,-630,-875,-1090,-887,-463,-269,-206,110,584,737,527,275,39,-89,-63,-62,-81,-138,-219,-303,-422,-430,-557,-703,-656,-397,-78,191,339,355,247,35,-101,-215,-380,-529,-560,-425,-160,-9,-62,-123,-52,2,-16,-45,-115,-190,-167,-138,-147,-156,-166,-209,-200,-108,-82,-71,-73,-67,-53,-67,-43,-15,-62,-126,-162,-198,-189,-87,17,32,70,71,-12},
            {-16,28,-56,69,-92,95,-141,149,13,6465,8013,-11069,-10779,-74,-26,8977,12125,6268,4232,15382,12111,-5484,-8000,-11556,-7434,2429,-2197,-10248,-8310,-4186,-2098,-1143,828,3276,2911,3767,4988,2673,1035,475,-305,-944,-2269,-3043,-2925,-1847,-1037,-969,-1063,269,800,769,905,859,967,1001,499,-337,-813,-1359,-1308,-395,1,-29,242,212,-106,-412,-622,-1075,-1028,-521,49,357,413,447,393,283,420,399,-46,-464,-933,-936,-581,-229,-139,-62,45,185,327,214,114,195,200,213,196,51,-43,-112,-352,-632,-647,-572,-344,-105,87,203,138,53,-7,-20,27,5,-18,24,-35,-136,-274,-399,-466,-323,-106,9,120,152,115,162}
        },
        {    // H-40e045a.wav
            {1,1,0,0,1,0,-1,2,2,4,7,4,7,-4,12,-10,18,-10,22,103,1743,2038,-1957,-2180,-431,-972,930,3368,3803,3106,3564,3890,2212,367,-1737,-3658,-2840,-1132,-1959,-2488,-1425,-418,-208,-7,546,846,708,761,1153,865,365,-136,-494,-519,-557,-880,-1164,-849,-236,-32,-19,224,475,423,306,127,-146,-211,-150,-78,-108,-172,-199,-290,-320,-321,-477,-586,-502,-260,-16,154,223,194,34,-100,-109,-197,-355,-434,-387,-252,-103,-87,-176,-167,-67,-31,-31,-101,-185,-174,-128,-111,-120,-123,-128,-129,-98,-86,-103,-116,-135,-122,-92,-73,-47,-35,-83,-123,-151,-164,-130,-41,33,61,102,53},
            {25,-44,44,-41,23,-40,29,-107,3088,10755,-3796,-15679,-2837,395,6440,11676,6781,4439,13725,17554,-1548,-8941,-11801,-9340,2190,-868,-9949,-9980,-4754,-1880,-693,-381,1753,3184,3722,5180,3632,1511,460,-207,-595,-2127,-3130,-3491,-2333,-1033,-697,-1188,-8,1048,752,826,753,941,938,746,-27,-723,-1216,-1505,-942,-105,5,111,288,152,-169,-545,-912,-976,-694,-230,147,255,313,386,379,387,488,223,-177,-713,-931,-687,-379,-244,-177,-26,78,197,218,143,206,310,263,249,169,43,-56,-243,-522,-665,-622,-435,-197,-4,171,183,94,19,-67,-53,15,-6,20,45,-77,-255,-337,-427,-412,-195,-27,105,185,144,98,98}
        },
        {    // H-40e051a.wav
            {0,-1,-1,-1,-1,-1,0,-2,0,1,3,2,1,0,-2,9,-9,10,-9,1,152,1558,1434,-1522,-1488,-671,-820,1006,2810,3217,2802,3200,3361,2122,287,-1874,-3061,-2013,-926,-1578,-1729,-943,-226,-136,-130,197,531,612,755,1001,658,182,-125,-292,-427,-690,-965,-872,-406,-35,-70,-129,4,196,206,89,-64,-178,-203,-200,-74,-25,-102,-161,-201,-246,-346,-466,-489,-403,-228,-65,31,42,2,-75,-87,-54,-130,-223,-259,-233,-212,-212,-231,-241,-172,-116,-117,-140,-175,-158,-121,-98,-100,-76,-56,-65,-73,-97,-117,-149,-172,-187,-169,-127,-87,-31,-45,-85,-101,-123,-147,-139,-46,27,76,88},
            {17,-48,67,-99,103,-156,159,162,7894,7456,-13794,-11149,369,3108,10187,8292,5159,8680,20276,8501,-8288,-10895,-12370,-583,1932,-7569,-11471,-6562,-2702,-1103,-203,466,2117,2898,4999,4520,2342,1399,-64,-402,-1355,-2722,-3746,-3099,-1642,-801,-964,-650,915,898,891,747,828,924,902,380,-476,-1064,-1411,-1316,-672,-51,-67,182,341,153,-239,-738,-961,-834,-445,-60,58,132,268,501,463,428,357,131,-383,-861,-771,-459,-304,-354,-181,-11,75,154,142,127,286,354,345,297,172,32,-185,-395,-579,-670,-549,-304,-132,57,187,148,52,-27,-97,-37,9,8,46,20,-177,-333,-361,-427,-310,-135,-1,165,216,134,64,0}
        },
        {    // H-40e058a.wav
            {3,2,1,2,1,1,4,3,1,4,3,6,3,7,2,7,3,0,1,-1,-6,373,1498,596,-1245,-946,-840,-341,1209,2427,2797,2755,3011,2575,1555,-73,-1887,-2283,-1205,-780,-1145,-923,-441,-250,-318,-92,153,309,427,632,675,402,157,-85,-282,-477,-633,-659,-435,-167,-154,-242,-221,-82,10,19,-2,-121,-209,-237,-119,55,52,-33,-113,-192,-303,-411,-447,-392,-319,-228,-112,-35,5,-38,-80,-38,-21,-67,-134,-167,-210,-242,-249,-253,-228,-199,-184,-178,-165,-152,-118,-68,-53,-53,-50,-45,-45,-55,-82,-130,-170,-192,-179,-139,-105,-62,-22,-30,-52,-85,-129,-153,-115,-31,20,70},
            {-28,24,-20,-18,11,-46,-27,2142,11392,-1218,-17870,-4760,2085,6596,9561,6401,5545,15567,19308,-2183,-10746,-12947,-5689,3606,-3629,-11047,-9536,-4027,-1968,-188,89,1185,1696,3304,5429,3296,1822,661,260,-480,-2202,-3291,-3657,-2302,-1472,-1016,-1104,380,1059,860,995,842,899,861,792,-50,-838,-1391,-1379,-1076,-455,-192,-169,331,451,119,-416,-831,-824,-691,-249,-37,-15,66,360,599,456,396,272,-24,-619,-807,-550,-333,-363,-342,-142,-34,40,114,116,166,305,370,426,353,215,-40,-334,-490,-607,-641,-437,-232,-84,88,185,121,34,-53,-79,-3,-33,28,51,-50,-251,-334,-349,-379,-229,-113,27,189,210,133,29,-45}
        },
        {    // H-40e064a.wav
            {4,1,1,2,3,2,3,3,3,2,3,1,6,3,4,2,8,-6,1,-1,11,1,487,1141,173,-746,-715,-801,-50,1088,2043,2580,2478,2183,1901,1427,36,-1508,-1448,-527,-264,-270,-446,-551,-411,-305,-278,-234,-10,147,334,506,402,51,-208,-207,-157,-267,-338,-268,-236,-288,-342,-355,-281,-128,-61,-117,-246,-258,-159,5,150,118,4,-127,-246,-340,-406,-403,-370,-319,-239,-92,7,-17,-68,-102,-62,-39,-60,-89,-140,-190,-224,-238,-253,-249,-230,-227,-204,-176,-144,-86,-46,-70,-100,-57,-16,-9,-31,-81,-140,-179,-157,-135,-135,-113,-50,-13,-26,-61,-128,-170,-170,-116,-60,-22},
            {-56,77,-109,95,-140,149,-184,5902,10954,-11571,-15684,805,3349,8646,7876,5018,9107,21664,10635,-9623,-12568,-9683,2344,1085,-8686,-11994,-6477,-2334,-1317,156,56,1319,1768,4212,4144,2341,1426,427,836,-803,-2716,-3920,-2790,-1745,-1606,-1622,-677,1060,919,1051,1021,1045,859,853,446,-431,-1168,-1532,-1293,-931,-298,-377,-204,449,511,95,-607,-757,-662,-521,-153,-106,-85,126,542,599,391,262,135,-291,-716,-612,-334,-266,-393,-329,-157,-62,-7,64,103,249,349,404,424,344,210,-145,-417,-535,-623,-587,-355,-169,-58,89,159,127,41,-70,-38,-33,-53,41,-21,-141,-234,-269,-347,-329,-209,-94,90,183,151,87,-15,-48}
        },
        {    // H-40e071a.wav
            {3,2,1,2,3,2,3,3,3,2,1,0,2,4,3,1,2,3,-2,7,-2,1,67,652,738,-163,-472,-628,-545,320,1331,1842,1871,1919,1765,1728,1318,-42,-979,-389,250,88,-221,-584,-627,-545,-506,-551,-434,-220,-5,332,407,155,-115,-9,228,176,-110,-272,-308,-365,-416,-452,-430,-339,-231,-190,-229,-260,-209,-91,95,229,160,-28,-190,-286,-340,-381,-384,-351,-282,-145,-30,-35,-88,-135,-143,-107,-93,-70,-42,-79,-160,-205,-217,-236,-257,-264,-248,-217,-186,-150,-105,-93,-108,-81,-13,24,13,-27,-86,-126,-141,-149,-146,-126,-87,-38,-35,-65,-121,-176,-194,-183,-126,-85},
            {-58,88,-136,143,-205,223,37,8756,8073,-17443,-11495,3085,4004,9158,6217,5279,13484,22297,3077,-13045,-12050,-4045,4690,-2370,-10772,-11424,-4251,-1935,-1068,-172,0,1447,2068,4185,3216,1991,810,1047,1003,-1120,-2886,-3839,-2305,-1604,-1673,-1951,-268,1117,899,1055,1121,1192,786,751,202,-601,-1338,-1502,-1257,-822,-285,-492,-90,463,501,45,-663,-652,-586,-374,-139,-172,-61,287,676,548,270,122,-73,-483,-661,-387,-187,-249,-403,-343,-206,-77,3,38,139,330,433,413,344,294,128,-192,-413,-538,-603,-553,-320,-145,-18,111,160,127,29,-66,-1,-55,-54,37,-91,-174,-192,-231,-329,-292,-210,-70,132,184,120,20,-82,-34}
        },
        {    // H-40e077a.wav
            {0,0,1,1,1,3,2,1,2,-1,-1,-1,0,1,-1,1,0,1,3,2,-2,-3,-1,132,570,414,-200,-311,-363,-12,599,817,866,1238,1815,1909,1870,1490,555,120,378,155,-324,-449,-605,-791,-833,-740,-744,-597,-326,-5,231,130,109,343,570,547,214,-182,-370,-434,-549,-566,-482,-492,-474,-358,-245,-239,-235,-148,-1,188,229,117,-33,-169,-283,-325,-318,-335,-300,-240,-160,-89,-111,-177,-222,-226,-188,-82,32,65,-17,-120,-183,-232,-263,-286,-291,-276,-252,-209,-168,-144,-116,-77,-10,29,34,20,-14,-55,-125,-163,-150,-126,-112,-97,-83,-92,-114,-160,-199,-213,-197,-152},
            {-40,76,-138,166,-235,254,582,11286,3329,-20977,-6135,4221,4644,8287,4969,7020,17601,19654,-4367,-14925,-8813,1991,3980,-5656,-12010,-9702,-2366,-2375,-975,-607,-202,1366,2759,3933,2440,1445,378,1714,956,-1156,-3181,-3250,-1618,-1662,-1935,-1879,26,795,775,966,1182,1154,786,600,-28,-551,-1313,-1422,-1193,-784,-458,-588,74,514,448,-94,-548,-424,-465,-349,-240,-230,-33,420,677,369,117,66,-168,-519,-527,-193,-103,-268,-392,-394,-288,-67,18,19,151,376,484,400,320,282,34,-243,-427,-483,-527,-557,-327,-132,28,140,149,109,21,-41,-10,-56,-44,-16,-133,-170,-118,-227,-338,-270,-181,-5,156,167,57,-67,-114,-23}
        },
        {    // H-40e084a.wav
            {1,1,0,3,2,4,2,1,1,0,-2,0,1,1,1,3,3,-1,6,5,3,-5,0,2,208,493,174,-195,50,222,-99,-169,351,887,1528,2159,2180,2086,1950,1031,94,-121,-344,-618,-587,-671,-1048,-1060,-759,-644,-499,-230,-5,83,276,665,824,650,390,-11,-397,-504,-577,-702,-642,-514,-512,-477,-338,-227,-184,-138,-38,78,161,162,110,7,-166,-280,-296,-283,-285,-272,-256,-225,-168,-180,-265,-314,-239,-75,74,152,91,-55,-168,-224,-261,-298,-307,-290,-259,-240,-209,-163,-121,-68,-13,40,44,41,23,-43,-111,-146,-142,-129,-118,-125,-121,-101,-109,-140,-189,-208,-198,-174},
            {-32,68,-133,172,-248,274,789,12157,1166,-21917,-3768,4802,4396,7246,4907,8330,19237,17371,-8146,-15354,-5483,5002,2774,-7245,-12192,-8192,-1931,-2892,-1103,-1257,-259,1513,2894,3664,2223,1038,401,2007,782,-1143,-2953,-2659,-1431,-1563,-2091,-1879,115,576,460,736,1181,1070,837,556,-82,-467,-1148,-1270,-1194,-836,-622,-608,168,537,457,-181,-521,-280,-319,-332,-322,-307,-38,481,603,227,48,62,-153,-441,-404,-154,-154,-297,-338,-395,-370,-84,40,22,115,355,510,405,356,259,-24,-268,-455,-436,-474,-543,-356,-147,33,163,171,85,3,-24,3,-45,-78,-77,-146,-146,-65,-230,-392,-262,-111,54,157,115,-3,-102,-114,-60}
        },
        {    // H-40e090a.wav
            {1,1,1,3,3,3,2,2,1,0,-1,-2,1,2,2,4,3,2,3,6,3,-2,-11,-4,29,249,373,309,408,-47,-690,-597,66,974,1489,1783,2402,2868,2592,1499,74,-550,-434,-537,-868,-907,-866,-1084,-907,-456,-379,-365,-189,23,408,819,899,718,448,98,-322,-631,-679,-679,-744,-671,-502,-406,-379,-267,-138,-117,-86,-13,97,188,196,70,-88,-170,-228,-236,-287,-327,-311,-304,-273,-255,-269,-304,-231,-70,76,157,100,-37,-153,-193,-243,-286,-282,-272,-248,-257,-233,-168,-119,-75,-18,36,52,52,16,-61,-120,-132,-136,-141,-128,-124,-114,-101,-111,-135,-159,-174,-189,-190},
            {-39,80,-144,192,-277,325,599,12149,1122,-22138,-3023,5547,3381,6099,5190,9240,19623,15691,-10252,-14975,-2057,6663,1517,-8328,-11607,-6939,-2055,-3318,-1541,-1873,-530,1685,2880,3216,2254,1042,518,2030,765,-1237,-2659,-1777,-1241,-1738,-2072,-1741,-143,294,147,423,1012,1017,898,553,44,-290,-968,-1090,-1110,-943,-794,-619,202,544,444,-143,-477,-232,-181,-317,-396,-433,-80,522,526,110,24,111,-96,-321,-288,-151,-230,-326,-310,-377,-375,-114,-22,-24,131,385,515,409,403,274,-32,-282,-468,-426,-436,-480,-366,-179,26,160,175,75,24,-1,28,-19,-125,-107,-157,-158,-44,-191,-398,-237,-49,72,165,102,-51,-141,-127,-53}
        },
        {    // H-40e096a.wav
            {0,0,0,1,2,2,2,0,-1,0,-2,-3,-2,1,1,-1,3,4,3,-3,1,-5,-4,-11,6,31,490,1040,186,-897,-880,-310,445,956,1349,1833,2578,3145,2477,1069,217,-304,-700,-774,-991,-1254,-1044,-585,-588,-573,-123,38,-179,-165,313,786,882,728,450,9,-347,-559,-762,-783,-701,-658,-579,-402,-265,-240,-195,-142,-101,-26,110,165,116,56,-24,-66,-111,-195,-308,-403,-399,-342,-321,-316,-276,-233,-166,-78,-3,15,-30,-55,-68,-120,-208,-238,-215,-216,-246,-273,-250,-191,-116,-69,-41,11,42,31,-31,-100,-144,-163,-152,-141,-126,-105,-90,-89,-97,-103,-122,-153,-200,-223},
            {-62,118,-191,242,-327,411,-14,10815,4367,-21657,-5322,6372,2275,5383,5247,9135,18836,16276,-9343,-15067,-902,7034,1663,-8378,-11005,-6726,-2337,-3520,-1977,-2168,-1041,1519,2590,3200,2342,1225,715,2038,882,-1207,-2453,-1562,-908,-1651,-2233,-1753,-279,3,-147,292,800,905,932,676,192,-140,-743,-1034,-1063,-929,-902,-762,180,627,473,-109,-451,-235,-197,-363,-439,-439,-81,495,516,119,-1,88,-60,-230,-209,-159,-305,-356,-292,-378,-408,-159,-52,-60,158,435,502,391,406,305,19,-274,-489,-476,-438,-414,-328,-200,-20,111,160,97,73,23,11,-38,-137,-110,-179,-193,-52,-133,-347,-232,-63,49,161,92,-59,-131,-111,-37}
        },
        {    // H-40e103a.wav
            {3,2,2,2,4,3,3,3,2,2,1,0,1,2,1,3,3,7,4,2,-2,0,-3,3,2,239,928,548,-656,-940,-459,322,833,1033,1303,2267,3097,2306,1172,773,358,-100,-548,-1165,-1300,-1066,-940,-658,-216,-79,-49,291,267,-146,-28,522,862,686,270,-121,-420,-537,-631,-729,-736,-613,-495,-397,-254,-184,-200,-159,-8,77,63,29,37,64,51,-14,-136,-231,-325,-370,-392,-375,-307,-264,-229,-190,-127,-120,-146,-143,-90,-26,-24,-75,-129,-131,-130,-171,-241,-279,-240,-168,-120,-84,-44,10,42,7,-68,-139,-173,-172,-158,-137,-102,-61,-46,-49,-60,-67,-92,-141,-193,-235},
            {-88,145,-208,236,-304,381,-415,8013,8955,-18916,-10142,7021,1629,4313,5099,8447,17263,17713,-5939,-15626,-1154,7024,2592,-7769,-10691,-6897,-2599,-3606,-2535,-2052,-1884,1101,2244,3136,2649,1452,799,2181,1327,-1186,-2344,-1546,-803,-1483,-2133,-1958,-595,-25,-381,10,643,826,890,818,436,-23,-550,-933,-1018,-934,-897,-894,7,702,594,-39,-506,-292,-223,-400,-509,-438,-48,463,518,155,4,78,-37,-140,-151,-167,-369,-409,-280,-383,-455,-216,-29,-57,136,450,492,381,380,345,111,-231,-490,-544,-430,-363,-296,-225,-69,69,121,110,89,71,8,-59,-150,-139,-190,-203,-51,-83,-265,-249,-111,21,123,95,-12,-62,-85,-51}
        },
        {    // H-40e109a.wav
            {3,2,2,2,4,3,3,3,2,3,2,1,4,0,1,0,3,2,6,3,0,3,-2,8,225,1129,613,-1182,-1186,-233,607,1067,1120,1197,2105,3131,2253,648,-38,20,229,-8,-692,-1144,-1246,-974,-530,-405,-204,333,600,516,453,117,-164,79,482,461,18,-296,-402,-488,-586,-626,-603,-557,-450,-307,-267,-192,-55,-35,14,75,17,-79,-54,42,23,-101,-224,-278,-309,-312,-333,-321,-261,-238,-193,-174,-175,-209,-235,-201,-131,-67,-32,-29,-30,-26,-68,-141,-212,-263,-252,-176,-105,-92,-70,-11,16,-20,-99,-175,-215,-203,-179,-121,-49,-13,-10,-27,-28,-38,-77,-134,-199,-237},
            {-63,79,-97,62,-58,43,-142,3498,12638,-10492,-17476,5571,2569,2100,5154,7036,14789,18811,889,-15481,-3587,6804,3856,-6273,-10512,-7450,-3183,-3227,-3527,-1633,-2255,14,1822,3069,2999,1857,944,1925,2118,-675,-2399,-1944,-862,-1368,-2064,-1924,-1005,-208,-378,-185,395,757,916,872,674,200,-367,-858,-968,-918,-940,-969,-219,564,623,177,-423,-332,-232,-437,-584,-515,-62,445,508,185,28,137,22,-127,-177,-213,-383,-463,-327,-358,-438,-282,-25,-24,65,376,492,399,352,353,185,-154,-442,-577,-459,-373,-300,-246,-131,34,63,111,86,116,42,-77,-176,-213,-202,-196,-57,-39,-173,-268,-211,-44,88,118,39,-19,-51,-73}
        },
        {    // H-40e116a.wav
            {4,3,2,4,2,3,3,3,4,3,3,3,3,1,-1,1,2,0,8,-8,10,-6,16,103,1128,1219,-1143,-1818,-684,530,1424,1505,1378,1952,3362,2800,470,-649,-480,-412,-462,-494,-821,-986,-791,-499,-359,-105,217,461,830,945,573,109,-136,-141,-81,-15,-29,-215,-459,-573,-542,-529,-477,-442,-386,-228,-127,-113,-64,57,106,9,-99,-124,-88,-61,-117,-229,-276,-259,-225,-262,-334,-271,-214,-239,-227,-166,-134,-198,-260,-245,-170,-95,-52,-24,16,17,-38,-100,-186,-245,-242,-190,-117,-67,-49,-56,-55,-56,-106,-179,-228,-218,-172,-104,-36,8,11,-3,-7,-35,-74,-118,-190,-231},
            {18,-50,84,-155,206,-281,338,373,11069,1153,-20589,-1053,5520,-366,4689,6186,11917,18281,8059,-12376,-7420,5978,5074,-4250,-10266,-7991,-4117,-2819,-4292,-1949,-1653,-841,1246,2536,3423,2387,1257,1478,2521,276,-2153,-2388,-1354,-1223,-2032,-1992,-1238,-318,-348,-319,342,695,884,881,795,408,-160,-663,-1013,-892,-859,-1047,-510,380,623,333,-260,-340,-215,-438,-607,-591,-153,432,548,293,70,143,93,-133,-204,-291,-403,-438,-359,-341,-379,-288,-54,16,27,272,478,441,365,328,222,-50,-347,-551,-514,-402,-340,-240,-147,23,29,86,125,139,104,-84,-200,-243,-208,-169,-75,-11,-83,-238,-275,-110,60,110,65,24,14,-56}
        },
        {    // H-40e122a.wav
            {3,3,3,3,2,2,3,3,3,4,3,6,4,0,-5,5,-6,10,-14,9,-16,24,51,1171,1774,-1147,-2418,-972,409,1554,1798,1738,2211,3961,3530,367,-1209,-1037,-976,-1046,-1219,-1526,-1132,-557,-197,59,135,401,739,882,1000,898,606,207,-228,-419,-535,-441,-215,-228,-475,-591,-535,-465,-382,-187,-32,-99,-119,-46,55,137,35,-162,-230,-168,-104,-167,-317,-339,-264,-200,-218,-340,-356,-272,-194,-148,-124,-80,-79,-171,-274,-322,-250,-122,-55,-19,13,3,-19,-67,-165,-220,-226,-181,-97,-21,-32,-124,-154,-121,-117,-154,-202,-206,-152,-93,-48,-9,14,18,9,-38,-75,-116,-179,-220},
            {53,-84,99,-122,107,-118,145,-244,4373,10995,-11841,-13939,6146,551,1066,6112,8826,15293,14354,-3440,-11195,2255,6971,-1170,-9618,-9122,-5162,-2925,-4203,-3593,-989,-1052,745,1981,3109,3031,2051,1386,2137,1481,-1426,-2518,-2055,-1428,-1938,-2236,-1620,-545,-58,-347,103,742,873,833,850,686,28,-356,-797,-1036,-876,-1065,-797,54,570,490,-85,-387,-200,-344,-572,-651,-311,380,574,418,199,86,107,-124,-270,-320,-449,-462,-386,-317,-273,-262,-129,24,28,191,438,453,353,297,222,53,-235,-523,-592,-456,-370,-259,-157,-13,66,52,136,146,134,-15,-215,-276,-235,-158,-102,-34,-23,-164,-273,-190,-38,70,74,43,76,15}
        },
        {    // H-40e129a.wav
            {3,2,2,2,2,3,3,3,3,2,7,4,6,-4,7,-7,11,-8,2,-11,13,-1,839,2412,-413,-3108,-1475,157,1555,2000,1945,2209,4124,4752,1081,-1598,-1433,-1181,-1407,-1658,-2073,-1868,-1219,-390,198,302,747,1097,1168,1269,1164,564,274,347,-2,-691,-962,-701,-490,-364,-372,-570,-577,-258,3,52,18,-19,-8,48,138,33,-268,-310,-157,-105,-171,-272,-364,-345,-262,-276,-453,-500,-292,-136,-61,-6,25,29,-54,-204,-332,-396,-317,-170,-44,25,-3,-37,-26,-43,-129,-213,-222,-129,-10,9,-86,-179,-190,-159,-133,-129,-178,-186,-130,-68,-45,-40,-9,25,26,-19,-79,-144,-174,-204},
            {-8,27,-57,80,-142,181,-246,298,189,9366,2975,-17827,-2880,5077,-1672,3989,7422,11641,15860,6062,-9033,-3553,6562,2719,-7032,-10831,-6799,-3391,-3404,-4730,-1932,-507,70,1822,2930,3319,2336,1774,1837,2089,-340,-2461,-2374,-1784,-1822,-2405,-2095,-1033,-14,-33,-115,577,926,899,851,876,344,-280,-547,-1028,-905,-988,-1007,-263,368,527,119,-372,-329,-302,-454,-518,-404,207,545,474,334,111,61,-90,-328,-387,-485,-485,-359,-331,-249,-198,-164,7,78,163,353,451,356,218,160,88,-126,-465,-624,-514,-383,-289,-160,-61,77,82,102,175,128,39,-170,-305,-278,-167,-112,-105,-43,-94,-215,-214,-134,-11,69,46,67,62}
        },
        {    // H-40e135a.wav
            {3,2,1,0,2,1,1,3,1,6,4,8,-1,4,-1,1,8,-9,6,-18,23,427,2728,801,-3695,-2279,-50,1511,2265,2124,2251,4011,5865,2264,-1816,-1889,-1350,-1711,-1885,-2358,-2481,-1759,-1040,-238,201,735,1338,1560,1653,1471,813,471,432,290,-199,-879,-1117,-972,-787,-645,-460,-261,-88,-17,142,218,126,62,18,39,-16,-247,-365,-287,-114,-33,-169,-357,-398,-373,-428,-582,-640,-419,-153,37,151,171,138,41,-105,-259,-424,-486,-363,-182,-33,6,-33,-19,1,-40,-132,-207,-163,-50,12,-33,-139,-190,-181,-185,-179,-160,-148,-139,-132,-94,-46,-24,10,38,4,-46,-109,-159,-172,-205},
            {-19,34,-38,25,-24,-11,28,-57,15,1860,10264,-3826,-15380,1508,1997,-626,5646,8148,12542,13571,915,-6990,1747,5202,-2002,-9412,-9457,-5646,-3660,-3930,-3610,-977,-122,1125,2490,3598,3334,2053,1500,1910,1511,-1388,-2733,-2228,-1838,-2179,-2509,-1859,-665,104,3,274,869,1030,1026,913,728,-40,-373,-713,-967,-811,-1095,-705,-22,391,290,-184,-378,-296,-344,-399,-397,-62,485,472,401,286,64,-34,-343,-490,-508,-538,-352,-270,-261,-155,-139,-54,113,208,285,345,351,207,35,-7,-20,-249,-547,-582,-447,-329,-174,-70,11,125,118,184,178,59,-93,-284,-315,-198,-108,-146,-131,-91,-138,-166,-187,-122,37,68,41,90}
        },
        {    // H-40e141a.wav
            {3,0,0,0,-1,2,1,0,5,4,10,2,2,6,-7,19,-22,36,-45,62,251,3062,1696,-4551,-3043,-8,1596,2756,2461,2478,4128,6832,3080,-2238,-2400,-1518,-2037,-2276,-2645,-2964,-2256,-1402,-380,-13,400,1252,1781,1846,1814,1242,639,635,453,-141,-758,-842,-1016,-1360,-1168,-630,-212,131,307,387,397,261,124,-29,-78,-27,-305,-537,-324,-52,23,-99,-291,-446,-551,-584,-616,-711,-543,-166,110,278,297,230,128,-54,-228,-405,-523,-451,-322,-218,-108,-17,43,42,-3,-44,-95,-103,-71,-77,-98,-83,-82,-134,-221,-247,-199,-141,-134,-180,-185,-97,6,61,82,31,-40,-94,-151,-191,-217,-225},
            {22,-33,52,-72,82,-113,120,-147,183,-241,4507,8548,-9588,-10486,2741,-188,1784,6636,8939,12844,9972,-1986,-2887,3832,1560,-5599,-10052,-7785,-4716,-4144,-4330,-2105,34,360,1689,3090,3910,2921,2016,1552,1609,329,-1918,-2334,-2120,-2183,-2479,-2318,-1456,-417,8,103,708,1026,1110,1057,912,377,-247,-387,-870,-832,-949,-960,-367,93,272,46,-221,-337,-344,-394,-365,-243,275,525,384,412,190,-11,-252,-532,-551,-571,-411,-228,-247,-148,-84,-133,6,196,299,295,272,186,16,-54,-18,-116,-402,-570,-503,-354,-227,-106,-40,91,162,146,190,109,-32,-198,-320,-247,-134,-144,-186,-140,-143,-144,-159,-195,-53,82,77,77}
        },
        {    // H-40e148a.wav
            {3,0,1,0,0,2,0,3,8,6,13,-4,20,-19,35,-38,57,-55,91,15,2706,3455,-4508,-4673,-36,1345,3072,2845,2756,3952,7324,4663,-2104,-3075,-1644,-2139,-2656,-2763,-3419,-2686,-1802,-704,14,272,1000,1545,1970,2109,1570,841,738,510,4,-746,-1066,-881,-922,-1097,-1065,-616,14,465,649,638,387,105,29,-17,-25,-248,-582,-493,-170,53,-18,-304,-516,-550,-531,-587,-753,-621,-183,151,307,333,283,170,-18,-223,-371,-487,-497,-389,-296,-189,-85,8,80,60,25,-15,-23,0,-63,-172,-160,-76,-55,-136,-228,-227,-170,-142,-190,-240,-183,-58,64,160,140,25,-78,-141,-179,-207,-232,-247},
            {4,8,-14,29,-54,70,-113,142,-194,242,-9,6699,4935,-11800,-6075,1638,-432,3897,6952,9428,12428,6633,-2241,661,2984,-2049,-7671,-9355,-6422,-4357,-4177,-3933,-1315,437,1100,2093,3350,3810,2652,1898,1667,1378,-596,-2137,-2005,-2020,-2393,-2597,-2120,-1130,-258,-50,251,890,1144,1228,1032,682,23,-248,-504,-790,-768,-1010,-664,-132,184,112,-90,-252,-363,-394,-408,-366,-69,453,438,393,362,103,-87,-392,-542,-564,-500,-298,-246,-216,-80,-101,-113,40,208,327,264,146,64,-2,-37,-82,-250,-468,-524,-398,-256,-145,-85,-28,105,142,154,162,44,-95,-216,-259,-194,-164,-206,-191,-164,-161,-144,-192,-138,22,106,93}
        },
        {    // H-40e154a.wav
            {-1,0,-3,1,1,-3,1,8,0,14,-12,23,-25,42,-44,60,-53,96,-36,2666,4619,-4763,-6249,142,1483,3342,3324,3113,4356,7960,5586,-2263,-3865,-1967,-2173,-3137,-3112,-3687,-3180,-2066,-795,-9,74,939,1776,2120,2138,1786,952,786,647,-152,-1069,-1250,-888,-926,-942,-703,-472,-220,218,626,743,602,274,78,-2,89,-48,-606,-659,-295,-62,-154,-386,-512,-516,-523,-539,-614,-599,-209,180,402,468,317,116,-91,-259,-398,-542,-576,-474,-314,-188,-77,9,65,82,83,60,29,56,14,-118,-198,-184,-133,-127,-153,-181,-192,-177,-193,-248,-240,-119,22,147,201,116,-18,-120,-178,-210,-226,-232,-242},
            {0,9,1,-2,13,-32,48,-84,111,-157,193,235,6826,3637,-10928,-5335,627,-30,4484,7162,9024,11260,6138,-469,1294,938,-3632,-8179,-8647,-5223,-4140,-4445,-3397,-920,340,1204,2340,3447,3492,2611,2172,1632,1081,-572,-1913,-2078,-2169,-2309,-2433,-1998,-1092,-245,74,498,917,1030,1098,865,392,-122,-181,-400,-539,-725,-853,-394,-45,139,24,-146,-362,-464,-430,-416,-344,15,386,366,456,355,126,-62,-334,-467,-583,-544,-400,-329,-179,-71,-119,-80,43,233,297,172,130,112,24,-57,-164,-332,-459,-430,-281,-190,-151,-130,-64,75,133,127,128,45,-48,-151,-205,-193,-209,-216,-212,-185,-163,-158,-164,-99,57,123}
        },
        {    // H-40e161a.wav
            {-1,-2,1,1,-2,-2,10,-3,17,-15,25,-27,34,-30,29,-20,50,-26,1955,5824,-3222,-8350,-653,1728,3393,3802,3333,4458,8071,7040,-1345,-4491,-2561,-2248,-3425,-3372,-3978,-3601,-2364,-1282,-163,159,1024,1772,2293,2357,1916,979,728,612,-124,-875,-1397,-1207,-1076,-955,-685,-329,10,105,276,597,733,448,266,152,73,104,-410,-778,-566,-240,-127,-267,-474,-577,-542,-494,-529,-615,-318,135,410,552,426,149,-92,-249,-385,-574,-690,-621,-415,-194,-58,-31,36,109,144,133,62,62,70,-37,-175,-224,-219,-203,-165,-147,-168,-184,-207,-267,-261,-140,-17,98,179,147,40,-58,-149,-227,-239,-211,-203,-224},
            {4,-4,16,-10,13,-11,-1,8,-34,47,-82,85,854,7310,1243,-10677,-4153,217,866,5226,7299,8875,10070,5303,953,889,-1416,-4957,-8147,-7163,-4268,-4287,-4476,-2856,-460,582,1206,2246,3445,3364,2636,2147,1484,789,-787,-1679,-1954,-2382,-2493,-2276,-1537,-613,-97,34,551,914,874,747,559,201,-32,-104,-304,-452,-749,-610,-204,48,109,-75,-296,-494,-528,-491,-415,-299,77,304,394,524,347,142,-113,-312,-531,-700,-635,-514,-336,-143,-91,-127,-34,107,252,230,148,173,114,-14,-155,-300,-393,-411,-321,-222,-203,-186,-162,-95,28,69,89,123,57,-37,-121,-180,-209,-228,-259,-246,-217,-193,-161,-150,-79,40}
        },
        {    // H-40e167a.wav
            {-4,-1,-1,-3,-5,10,-5,17,-17,23,-26,28,-28,20,-14,37,-15,1969,6449,-2914,-9529,-1296,1881,3916,4450,3616,5014,8375,7353,-733,-4621,-3426,-2731,-3662,-3482,-4268,-4406,-2770,-1279,-6,206,1124,2083,2622,2578,2048,911,487,556,-181,-938,-1502,-1379,-1231,-1088,-714,-349,-17,229,462,547,605,385,198,300,275,191,-405,-921,-620,-143,-3,-166,-415,-539,-528,-564,-582,-621,-383,89,384,561,562,307,-53,-305,-422,-553,-698,-691,-503,-281,-100,-44,15,93,158,198,184,181,102,-52,-164,-221,-257,-264,-223,-138,-126,-190,-234,-263,-253,-152,-24,93,177,164,68,-44,-141,-210,-227,-216,-194,-199,-205},
            {-9,7,-4,13,-7,8,-8,-3,6,-32,40,-68,76,823,6826,1715,-10122,-4890,182,1541,5595,6687,7826,9248,6118,1882,-202,-2545,-5157,-7237,-6043,-4005,-4478,-4323,-2695,-489,633,1145,2188,3219,3158,2577,2117,1391,812,-544,-1546,-1956,-2222,-2164,-2008,-1408,-620,-76,195,505,679,704,736,531,103,-79,-148,-197,-409,-638,-381,-55,88,51,-99,-365,-571,-577,-484,-397,-302,-2,238,481,598,388,113,-144,-336,-597,-725,-697,-567,-334,-134,-107,-85,64,183,275,276,222,154,40,-96,-262,-363,-330,-263,-210,-187,-201,-205,-212,-152,-28,13,86,181,131,41,-56,-176,-205,-229,-272,-258,-231,-178,-128,-133,-79}
        },
        {    // H-40e174a.wav
            {-3,0,-1,-5,9,-4,16,-11,18,-16,14,-8,-7,13,-8,31,1431,6696,-873,-10284,-2897,1531,3712,5396,4165,5153,8023,7762,865,-3869,-4083,-3614,-3948,-3686,-4267,-4912,-3383,-1693,10,532,1099,2042,2765,2697,2180,1343,660,491,-331,-1008,-1510,-1552,-1388,-1259,-965,-578,-29,287,568,743,730,404,11,111,132,97,-219,-695,-603,-172,91,12,-173,-420,-534,-615,-649,-645,-551,-111,276,519,629,473,114,-225,-380,-569,-719,-706,-537,-333,-166,-93,-57,63,136,211,254,228,144,-2,-128,-209,-264,-285,-241,-151,-134,-197,-248,-251,-234,-176,-74,52,193,201,103,-15,-127,-192,-230,-230,-206,-189,-185,-190},
            {-3,-8,8,-5,16,-10,13,-15,8,-9,-12,13,-26,30,1253,6949,321,-10293,-4169,491,2576,6113,6119,6891,8523,6421,1743,-1368,-3476,-5186,-6250,-4896,-3983,-4918,-4034,-2190,-271,731,1380,2180,2976,2932,2433,1903,1152,630,-559,-1306,-1759,-2064,-1992,-1781,-1222,-598,-125,208,588,815,843,707,260,-42,-159,-254,-194,-414,-509,-227,39,92,12,-165,-405,-522,-573,-546,-536,-357,27,335,578,563,332,27,-194,-416,-706,-779,-696,-476,-260,-146,-129,-1,168,243,302,268,181,76,-68,-213,-315,-297,-212,-180,-173,-205,-243,-254,-232,-154,-58,7,126,213,149,75,-80,-210,-216,-255,-257,-236,-226,-173,-123,-107}
        },
        {    // H-40e180a.wav
            {-1,-1,-8,7,-2,14,-7,10,-7,1,7,-26,32,-42,65,991,6579,1021,-10230,-4486,952,2997,5918,5230,5641,7788,7514,2233,-2630,-4060,-4303,-4974,-4206,-3914,-5102,-4163,-2062,99,721,988,1971,2838,2822,2412,1693,817,591,-210,-1050,-1713,-1784,-1569,-1585,-1220,-627,-99,229,588,820,875,717,129,-196,-206,-63,-61,-518,-580,-180,145,112,-50,-263,-428,-542,-647,-657,-640,-341,113,463,667,564,235,-97,-265,-481,-737,-792,-631,-376,-208,-120,-84,28,144,234,271,243,168,36,-106,-220,-265,-242,-208,-174,-175,-228,-252,-234,-227,-178,-84,17,155,216,150,42,-105,-188,-213,-259,-245,-207,-183,-150,-150},
            {-1,-1,-8,7,-2,14,-7,10,-7,1,7,-26,32,-42,65,991,6579,1021,-10230,-4486,952,2997,5918,5230,5641,7788,7514,2233,-2630,-4060,-4303,-4974,-4206,-3914,-5102,-4163,-2062,99,721,988,1971,2838,2822,2412,1693,817,591,-210,-1050,-1713,-1784,-1569,-1585,-1220,-627,-99,229,588,820,875,717,129,-196,-206,-63,-61,-518,-580,-180,145,112,-50,-263,-428,-542,-647,-657,-640,-341,113,463,667,564,235,-97,-265,-481,-737,-792,-631,-376,-208,-120,-84,28,144,234,271,243,168,36,-106,-220,-265,-242,-208,-174,-175,-228,-252,-234,-227,-178,-84,17,155,216,150,42,-105,-188,-213,-259,-245,-207,-183,-150,-150}
        }
    },
    {    // elev0
        {    // H0e000a.wav
            {5,-6,19,-24,39,-56,74,-101,120,-137,161,30,5321,6066,-6762,-253,195,-5129,7285,5986,2332,11785,11069,-6536,-5109,4539,-8167,-13539,-2026,-1365,-7336,-1277,3012,80,1084,4212,3286,1359,2467,1543,-905,-191,1215,-587,-1697,-1097,-1235,-2135,-2711,-2422,-2046,-1331,-253,114,194,681,1310,1375,929,696,553,151,-244,-225,-474,-819,-699,-736,-921,-736,-542,-605,-447,-73,76,157,352,549,419,112,-34,-6,-104,-306,-273,-311,-395,-292,-165,-175,-147,-5,-60,-246,-136,59,57,16,36,-37,-145,-119,-153,-195,-179,-216,-240,-128,25,74,12,-44,-33,-95,-202,-185,-158,-192,-162,-83,-51,-27,-21,-53,-58,-38,-56,-58},
            {5,-6,19,-24,39,-56,74,-101,120,-137,161,30,5321,6066,-6762,-253,195,-5129,7285,5986,2332,11785,11069,-6536,-5109,4539,-8167,-13539,-2026,-1365,-7336,-1277,3012,80,1084,4212,3286,1359,2467,1543,-905,-191,1215,-587,-1697,-1097,-1235,-2135,-2711,-2422,-2046,-1331,-253,114,194,681,1310,1375,929,696,553,151,-244,-225,-474,-819,-699,-736,-921,-736,-542,-605,-447,-73,76,157,352,549,419,112,-34,-6,-104,-306,-273,-311,-395,-292,-165,-175,-147,-5,-60,-246,-136,59,57,16,36,-37,-145,-119,-153,-195,-179,-216,-240,-128,25,74,12,-44,-33,-95,-202,-185,-158,-192,-162,-83,-51,-27,-21,-53,-58,-38,-56,-58}
        },
        {    // H0e005a.wav
            {-1,4,0,9,-17,31,-48,59,-82,100,-120,144,124,5029,4987,-5784,203,-165,-4327,6301,5304,2584,10535,9884,-5043,-4165,3342,-7205,-11684,-2271,-1535,-6311,-1339,2340,228,891,3388,2860,1253,2102,1665,-451,-167,1228,-110,-1537,-1189,-1189,-2285,-2652,-1955,-1617,-1236,-238,345,377,410,786,1062,741,424,342,104,-203,-242,-469,-759,-662,-638,-838,-690,-432,-431,-324,-5,167,209,308,381,277,40,-124,-103,-183,-294,-200,-214,-305,-227,-113,-176,-159,-40,-96,-219,-115,42,5,-34,-14,-88,-152,-120,-120,-145,-152,-185,-186,-89,10,71,37,-20,-42,-113,-200,-190,-172,-205,-174,-107,-84,-75,-50,-51,-54,-43,-28},
            {-9,28,-33,50,-68,76,-95,97,-103,117,-77,4475,8319,-6512,-2471,1694,-6346,6855,7572,1717,11669,13632,-6063,-7855,5529,-6589,-15651,-3317,-262,-7887,-2624,3606,261,481,4499,4182,1486,2647,2101,-1007,-712,1128,-439,-1753,-1114,-1140,-2033,-2692,-2747,-2572,-1744,-611,-248,160,1123,1601,1606,1176,901,742,343,-144,-241,-429,-821,-735,-738,-992,-842,-634,-688,-586,-196,-12,69,324,552,531,254,70,54,-35,-278,-231,-246,-479,-430,-218,-218,-206,-34,-40,-244,-148,121,103,41,66,15,-109,-86,-144,-236,-210,-254,-291,-200,-32,58,17,-43,-49,-69,-175,-166,-132,-194,-160,-91,-46,-16,20,-13,-56,-35,-56,-79,-54}
        },
        {    // H0e010a.wav
            {-5,4,0,-1,10,-14,23,-33,45,-65,82,-100,125,241,4833,3891,-4977,550,-574,-3424,5604,4722,2826,9638,8663,-4177,-3422,2433,-6438,-10180,-2218,-1611,-5553,-1207,1918,217,617,2911,2499,1048,2059,1742,-261,-86,1061,-58,-1214,-1103,-1375,-2287,-2278,-1604,-1466,-1062,-162,408,517,387,406,559,471,301,182,-88,-225,-191,-488,-759,-604,-591,-726,-526,-253,-235,-159,77,172,196,198,229,136,-41,-158,-179,-237,-297,-145,-137,-245,-218,-120,-122,-147,-73,-114,-201,-101,28,7,-60,-50,-96,-156,-127,-130,-151,-139,-142,-157,-94,22,86,39,-37,-67,-115,-173,-166,-191,-228,-191,-132,-101,-82,-56,-68,-55,-25},
            {30,-35,47,-51,57,-64,42,-13,1,-19,3352,10248,-5107,-5417,2920,-7065,5977,9294,1284,11548,15887,-4951,-10580,5574,-4914,-16853,-4781,271,-7837,-3814,3714,529,50,4282,4959,1899,2762,2696,-790,-1627,784,416,-1762,-1378,-1042,-2020,-2777,-2909,-2987,-2390,-1198,-282,467,1281,1726,1921,1515,1067,798,407,-40,-143,-377,-880,-782,-706,-1032,-938,-658,-783,-744,-279,-42,44,273,534,609,381,134,49,-6,-216,-202,-226,-448,-450,-310,-310,-318,-104,-43,-201,-128,147,190,115,116,43,-108,-106,-120,-219,-237,-278,-351,-274,-100,18,4,-69,-57,-59,-133,-130,-103,-173,-172,-96,-60,-17,44,10,-46,-40,-64,-86,-55,-83}
        },
        {    // H0e015a.wav
            {0,-4,3,0,1,4,-6,15,-28,37,-53,61,-77,103,296,4436,3255,-4257,615,-606,-2884,4961,4285,2777,8719,7845,-3382,-2995,2063,-5557,-8960,-2127,-1590,-4954,-1251,1531,-23,386,2554,2111,1101,2129,1720,-153,0,886,-123,-907,-917,-1407,-2026,-1989,-1603,-1331,-843,-99,318,381,266,247,277,195,119,14,-127,-234,-226,-409,-686,-580,-490,-516,-303,-126,-135,-98,53,122,95,106,145,68,-110,-204,-178,-246,-269,-156,-139,-211,-162,-88,-142,-139,-91,-121,-193,-86,37,5,-30,-62,-126,-179,-154,-160,-158,-109,-121,-121,-68,14,49,-1,-54,-80,-94,-140,-165,-200,-240,-187,-133,-115,-93,-65,-60,-60},
            {-9,24,-28,9,15,-68,114,-159,157,1906,11331,-1596,-9067,3308,-6516,3499,11412,1368,10570,18210,-2316,-13403,4333,-2415,-17790,-6712,950,-7503,-5274,3878,868,-535,3844,5524,2372,2762,3568,-817,-2583,927,1213,-1738,-1318,-1049,-2274,-2834,-2872,-3655,-3383,-1395,134,668,1145,1743,2270,1893,1212,846,473,-19,-144,-288,-841,-836,-740,-1065,-970,-626,-834,-861,-363,-45,19,230,544,683,426,130,84,71,-183,-211,-179,-446,-482,-350,-393,-407,-130,-11,-177,-166,167,282,207,157,61,-84,-89,-103,-251,-259,-292,-391,-343,-150,9,8,-85,-99,-46,-109,-126,-52,-130,-163,-108,-63,-26,35,25,-44,-52,-58,-83,-58,-60,-56}
        },
        {    // H0e020a.wav
            {0,-3,-3,5,-2,0,4,-4,13,-22,33,-44,50,-59,85,296,3966,2877,-3622,604,-554,-2447,4344,3827,2660,7781,7257,-2615,-2613,1904,-4638,-7875,-2071,-1516,-4536,-1344,1056,-250,281,2156,1991,1253,2003,1656,-4,35,759,-62,-704,-718,-1233,-1858,-1890,-1506,-1126,-738,-244,-6,141,288,231,35,-69,-32,2,-90,-227,-236,-326,-478,-439,-421,-376,-205,-116,-130,-118,11,80,69,65,71,-12,-142,-206,-165,-199,-262,-180,-138,-181,-159,-101,-139,-147,-70,-74,-153,-83,37,9,-63,-69,-135,-195,-171,-155,-133,-104,-96,-104,-74,-25,-3,-23,-61,-50,-77,-135,-151,-170,-189,-184,-135,-120,-101,-74,-75},
            {-13,30,-53,84,-158,220,-277,310,642,10739,3684,-11622,1257,-4219,330,12241,2626,9368,19370,1873,-14620,1031,170,-17051,-9850,650,-5506,-7085,3039,2132,-954,2823,5676,3408,2479,3581,-427,-2623,625,1731,-1079,-1518,-1025,-2175,-3056,-3210,-4328,-4292,-1291,845,417,857,2001,2550,2081,1235,931,628,60,-205,-324,-825,-839,-739,-1122,-1056,-629,-749,-903,-422,-18,-40,188,561,704,453,168,40,68,-70,-174,-163,-472,-587,-459,-400,-383,-156,-3,-151,-189,125,335,279,199,98,-57,-87,-107,-244,-291,-317,-445,-433,-200,8,52,-65,-107,-82,-117,-125,-61,-102,-154,-86,-61,-44,15,7,-60,-91,-74,-64,-15,-12,-47,12}
        },
        {    // H0e025a.wav
            {-3,1,0,-3,2,0,2,5,-3,12,-19,30,-38,42,-41,75,249,3435,2693,-2995,444,-342,-2078,3599,3487,2443,6818,6852,-1797,-2263,1812,-3643,-6898,-2102,-1489,-4128,-1546,531,-285,194,1903,1904,1229,1914,1598,124,102,789,86,-641,-749,-1046,-1587,-1702,-1338,-1186,-949,-510,-179,44,147,110,-47,-128,-43,109,-17,-199,-124,-180,-355,-359,-405,-437,-246,-94,-141,-128,28,65,1,0,37,-25,-134,-167,-144,-197,-241,-175,-161,-205,-161,-115,-135,-111,-24,-30,-115,-79,-9,-40,-77,-69,-121,-173,-165,-148,-128,-105,-115,-136,-93,-31,-15,-47,-64,-42,-61,-109,-112,-116,-153,-165,-153,-146,-124,-81},
            {49,-90,126,-185,220,-250,300,-80,8246,9401,-10742,-3750,-1443,-2112,11413,4195,8007,20168,6210,-13329,-2849,1281,-14734,-12249,-1934,-3679,-6860,916,2799,-355,2145,4913,4205,2802,2451,7,-1226,-125,1588,89,-1474,-1337,-1770,-2870,-4332,-5136,-4118,-1217,620,417,888,2025,2678,2270,1305,910,733,254,-248,-366,-743,-934,-795,-1081,-1151,-720,-667,-805,-436,5,-39,104,519,759,549,141,-22,20,17,-130,-164,-450,-672,-526,-389,-349,-179,-13,-88,-190,48,330,342,252,112,-32,-93,-113,-231,-290,-336,-489,-495,-258,-24,83,2,-91,-95,-109,-134,-95,-99,-148,-98,-60,-40,-8,-8,-76,-137,-113,-51,23,62,25,9,-22}
        },
        {    // H0e030a.wav
            {-1,-2,1,-1,-2,0,1,0,3,-4,10,-16,25,-35,34,-26,59,174,2875,2628,-2396,212,-20,-1838,2842,3193,2169,5876,6521,-874,-1972,1757,-2635,-6051,-2259,-1399,-3721,-1934,203,-143,51,1544,1839,1285,1754,1560,354,307,745,-15,-687,-655,-756,-1267,-1622,-1571,-1376,-1067,-672,-381,-162,-10,67,96,50,81,186,88,-55,-53,-177,-401,-422,-423,-478,-324,-119,-93,-108,-41,-8,-30,8,70,9,-116,-183,-155,-182,-232,-184,-178,-222,-199,-129,-109,-76,-2,-15,-95,-89,-47,-68,-91,-77,-109,-147,-152,-160,-148,-127,-138,-149,-97,-49,-40,-54,-58,-38,-40,-63,-75,-97,-139,-168,-166,-155,-125},
            {-65,85,-117,100,-100,107,-157,4677,12934,-5141,-9586,-972,-2570,8977,6064,6250,19976,11079,-10305,-6181,1512,-11966,-13688,-4953,-3551,-6196,-818,3198,-66,1850,5051,4266,1809,2270,1211,-1101,-287,1686,563,-1166,-1149,-1491,-3100,-5226,-5550,-3397,-1384,-319,476,1295,1982,2404,2350,1609,1049,670,251,-214,-311,-611,-995,-932,-1025,-1243,-862,-599,-623,-443,-105,31,174,513,740,572,157,5,-44,-70,-161,-172,-390,-628,-521,-368,-347,-202,-21,-56,-183,-2,318,353,279,157,-30,-152,-121,-199,-292,-325,-481,-538,-326,-60,94,62,-45,-103,-119,-142,-86,-73,-163,-150,-90,-46,-18,-5,-72,-152,-159,-77,42,117,87,35,-6,-44}
        },
        {    // H0e035a.wav
            {-3,0,-1,0,0,-2,0,2,0,3,-5,12,-17,22,-28,28,-13,36,121,2283,2615,-1775,-73,332,-1610,2066,2898,1941,4912,6214,164,-1667,1611,-1674,-5234,-2466,-1244,-3387,-2203,39,-195,-124,1323,1811,1317,1635,1665,603,220,512,30,-480,-464,-717,-1348,-1716,-1646,-1440,-1277,-910,-511,-248,-13,231,383,284,222,269,190,-22,-143,-276,-488,-488,-471,-474,-345,-170,-103,-147,-65,24,36,30,71,43,-112,-185,-159,-168,-215,-200,-197,-244,-204,-117,-104,-74,10,14,-90,-104,-54,-78,-98,-90,-105,-139,-140,-133,-153,-158,-165,-145,-97,-78,-47,-41,-41,-17,-10,-44,-73,-82,-119,-148,-160,-159},
            {-6,13,-58,96,-144,148,1528,12621,3199,-12132,-4199,-1915,6430,6976,5100,18832,14721,-5820,-7357,343,-9073,-13237,-8202,-5108,-5012,-2836,2363,1290,1597,4907,4717,599,1874,2887,-834,-870,1474,1074,-709,-801,-1332,-3625,-5797,-5224,-2845,-1719,-1026,267,1511,2036,2060,2231,1905,1350,686,111,-244,-226,-523,-939,-982,-1111,-1263,-1004,-552,-488,-448,-236,90,347,567,712,544,204,37,-104,-233,-254,-147,-318,-578,-486,-339,-282,-196,-48,-64,-135,-28,239,364,310,182,-29,-192,-169,-214,-284,-298,-406,-530,-424,-121,112,142,-11,-108,-125,-141,-92,-68,-149,-179,-144,-87,-19,2,-68,-148,-165,-86,26,109,119,62,14,-28,16}
        },
        {    // H0e040a.wav
            {0,-1,0,0,0,1,-2,-1,3,-1,3,-3,9,-15,19,-23,23,-11,32,64,1704,2606,-1159,-368,674,-1357,1267,2618,1758,3952,5906,1266,-1385,1318,-719,-4408,-2659,-1035,-3008,-2534,-258,-108,-178,1085,1849,1423,1519,1554,662,200,475,252,-420,-770,-968,-1289,-1649,-1784,-1648,-1398,-937,-463,-147,159,461,579,495,322,264,163,-107,-294,-414,-526,-548,-508,-472,-379,-231,-130,-88,-6,73,56,35,68,40,-80,-176,-160,-169,-243,-237,-210,-227,-196,-123,-90,-74,-14,-8,-78,-99,-77,-75,-107,-87,-87,-117,-126,-151,-164,-171,-154,-156,-130,-81,-41,-20,-26,-6,-5,-37,-68,-82,-110,-142,-149},
            {75,-153,216,-272,345,-135,8950,10715,-9302,-9242,-2445,4537,7486,3612,17326,18210,-2091,-7364,186,-7004,-12302,-8904,-8213,-5348,-3181,492,1039,2289,5605,3804,258,2443,3347,-213,-632,577,961,-27,-291,-1474,-4251,-5740,-4601,-2843,-2035,-1026,146,1135,1918,1955,2034,1985,1633,843,28,-250,-213,-526,-889,-911,-1170,-1382,-1084,-501,-478,-458,-189,159,368,636,774,572,216,-26,-180,-325,-255,-177,-314,-522,-449,-288,-267,-185,0,-8,-83,-89,139,313,349,258,-24,-242,-251,-231,-298,-272,-317,-494,-468,-190,101,196,55,-75,-141,-141,-99,-75,-153,-211,-181,-130,-37,8,-34,-130,-173,-76,23,83,113,68,19,-29,4,77}
        },
        {    // H0e045a.wav
            {3,0,0,0,-1,1,1,-2,1,3,-3,7,-2,7,-8,16,-11,14,3,23,26,1190,2492,-524,-605,932,-1059,514,2319,1624,3100,5520,2294,-1072,997,163,-3476,-2673,-1059,-2833,-2648,-385,-54,-165,997,1838,1304,1268,1556,901,306,277,-20,-654,-961,-1016,-1282,-1729,-1872,-1616,-1257,-758,-276,21,345,622,696,540,329,206,4,-257,-417,-460,-565,-589,-533,-491,-364,-194,-64,-43,24,76,68,62,55,31,-55,-146,-192,-222,-256,-232,-188,-200,-186,-123,-102,-101,-55,-30,-70,-93,-49,-50,-82,-80,-70,-104,-148,-153,-159,-160,-176,-160,-123,-80,-26,-6,-1,-9,-11,-51,-82,-86,-109,-117},
            {-80,98,-104,109,-198,3827,14044,-1104,-13286,-4944,2536,7775,2651,13546,22171,2592,-7664,-94,-4166,-11388,-8443,-9890,-7349,-3719,-1140,553,1452,5620,3898,670,2462,3901,933,-410,61,579,408,-349,-1609,-4459,-5358,-4162,-3138,-2239,-1008,447,919,1299,1772,2000,1891,1684,1122,166,-220,-317,-465,-851,-956,-1093,-1502,-1270,-562,-355,-426,-171,230,406,620,771,657,233,-111,-221,-343,-262,-201,-289,-481,-457,-287,-280,-193,46,97,-11,-92,5,205,358,312,31,-249,-331,-296,-319,-262,-256,-429,-489,-284,47,224,131,-22,-133,-159,-108,-67,-138,-242,-253,-204,-77,10,-11,-90,-152,-95,18,87,98,58,0,-46,-30,53,92}
        },
        {    // H0e050a.wav
            {1,1,1,1,0,0,-1,-1,-1,-2,2,-2,3,-3,3,-6,7,-1,1,12,10,9,747,2260,103,-744,1051,-714,-144,1972,1545,2383,5004,3125,-616,738,1029,-2558,-2945,-1183,-2355,-2606,-596,104,-57,716,1561,1332,1353,1629,845,-215,-202,-104,-757,-1181,-1159,-1234,-1600,-1707,-1372,-959,-504,-116,175,448,627,662,471,215,32,-145,-367,-494,-488,-586,-618,-514,-412,-292,-131,-29,-53,0,100,95,34,35,29,-75,-183,-212,-214,-244,-230,-181,-193,-195,-148,-130,-130,-77,-25,-51,-74,-27,-27,-76,-69,-65,-126,-161,-153,-167,-183,-167,-148,-116,-73,-23,-5,-28,-38,-48,-67,-86,-73,-70},
            {-96,168,-246,290,244,10999,9628,-12128,-10351,547,6972,3446,7597,23880,10153,-7427,-1538,-865,-9970,-8329,-8904,-10121,-4762,-2397,-495,572,3954,3746,1495,2713,4449,2307,8,439,104,409,-230,-2171,-4597,-4793,-3754,-3650,-2555,-809,539,944,1060,1387,1743,1783,1674,1321,447,-118,-326,-434,-754,-995,-1134,-1529,-1487,-762,-235,-320,-156,239,496,582,709,701,285,-71,-179,-339,-392,-228,-163,-382,-526,-371,-266,-182,7,164,78,-28,-41,89,297,349,141,-221,-371,-348,-349,-291,-216,-326,-489,-384,-42,204,210,45,-105,-160,-115,-36,-90,-215,-296,-293,-185,-43,28,-22,-103,-124,-12,109,128,94,-7,-96,-95,35,110,57}
        },
        {    // H0e055a.wav
            {1,1,2,1,1,1,0,-1,0,0,0,1,-1,2,-2,2,-1,5,4,-5,21,-1,11,399,1909,685,-722,1001,-340,-640,1559,1503,1854,4345,3741,223,596,1292,-1735,-2800,-1278,-1916,-2420,-721,103,-165,562,1625,1563,1162,898,295,-403,-371,-385,-996,-1211,-1014,-982,-1280,-1353,-1047,-633,-284,-55,190,413,523,475,301,87,-138,-266,-398,-511,-523,-551,-517,-412,-303,-227,-125,-45,-47,13,67,68,25,-2,-19,-101,-161,-193,-202,-245,-249,-192,-195,-201,-165,-127,-112,-68,-35,-44,-45,-14,-19,-63,-66,-91,-125,-149,-165,-174,-172,-145,-135,-111,-87,-66,-51,-52,-46,-40,-46,-56,-54},
            {63,-70,90,-186,4017,15164,-1500,-16415,-3671,5699,5243,2443,19749,19864,-4110,-4649,1667,-6431,-9200,-7348,-10924,-6855,-3354,-1780,138,1055,3014,2356,2050,4273,4804,1149,292,689,558,-411,-2446,-4389,-4981,-3722,-3745,-3060,-940,567,1031,1071,1177,1420,1684,1536,1323,856,75,-276,-395,-624,-926,-1199,-1631,-1656,-966,-354,-227,-94,206,539,612,569,673,521,41,-210,-257,-461,-344,-133,-245,-502,-458,-275,-231,-55,187,181,25,-73,14,245,340,239,-102,-392,-421,-377,-311,-213,-245,-431,-462,-195,132,255,111,-55,-141,-140,-44,-27,-136,-271,-340,-314,-169,-16,24,-41,-120,-60,96,165,143,46,-98,-153,-83,74,114,37}
        },
        {    // H0e060a.wav
            {-1,0,0,1,1,1,0,-1,-2,-2,-1,-1,-1,-1,-1,-2,-3,5,1,2,-10,28,-5,5,173,1467,1149,-504,779,-1,-913,1112,1459,1525,3749,4211,901,289,1577,-695,-2590,-1450,-1407,-2205,-1031,74,213,695,1286,1002,365,372,99,-661,-748,-526,-835,-983,-675,-570,-863,-1007,-716,-418,-264,-109,92,251,305,269,114,-79,-225,-302,-419,-487,-428,-402,-398,-313,-232,-210,-140,-60,-37,-33,3,36,-12,-41,-46,-86,-136,-197,-219,-252,-255,-196,-181,-174,-139,-111,-104,-74,-32,-41,-40,-17,-26,-57,-76,-73,-109,-149,-161,-175,-157,-147,-153,-148,-130,-86,-53,-27,-20,-16,-33,-57},
            {153,-244,324,-131,9824,12990,-12926,-13589,3455,6825,1523,9742,25761,6266,-8315,1161,-941,-8698,-7135,-9485,-9865,-3944,-2898,-758,-669,850,2563,1673,3089,5304,3869,1065,1087,1004,172,-2393,-4211,-4831,-4396,-3896,-3667,-1570,497,1113,1027,1145,1253,1507,1485,1294,1094,428,-166,-266,-461,-930,-1131,-1509,-1826,-1398,-594,-162,-67,180,405,586,571,606,686,336,-104,-269,-373,-463,-236,-170,-398,-476,-345,-260,-173,122,256,115,-32,-60,123,341,344,73,-310,-491,-437,-327,-223,-180,-321,-483,-395,-36,241,200,23,-109,-157,-88,21,-34,-191,-318,-378,-290,-117,-8,-11,-85,-100,45,181,174,114,-17,-138,-141,-25,88,62,12}
        },
        {    // H0e065a.wav
            {3,3,3,5,4,5,5,4,4,3,5,6,6,5,8,3,9,4,15,7,6,13,33,-7,14,68,1006,1434,-91,448,262,-880,645,1492,1627,2900,3888,1910,610,1588,93,-2078,-1605,-1214,-1796,-813,330,169,-20,336,510,36,-234,-390,-689,-601,-423,-516,-448,-199,-203,-509,-704,-562,-368,-349,-282,-76,49,79,45,-23,-136,-263,-292,-290,-308,-294,-281,-275,-228,-183,-197,-158,-78,-68,-83,-42,-8,-18,-38,-53,-73,-127,-188,-220,-224,-202,-159,-127,-129,-119,-103,-81,-65,-48,-31,-36,-16,-11,-27,-42,-56,-88,-138,-158,-172,-180,-170,-161,-146,-112,-60,-22,0,3,-17,-37},
            {116,-197,199,1378,14950,5372,-19967,-6418,7991,4281,1581,19625,21034,-5281,-4670,3557,-4224,-8157,-7258,-10748,-7080,-2874,-1888,-1374,-1997,1924,1988,1334,4082,5609,2772,1277,2142,1182,-1426,-4062,-4262,-4627,-4506,-4236,-2753,-287,1134,1251,922,1093,1424,1531,1260,1237,870,60,-242,-186,-693,-1262,-1334,-1574,-1763,-1186,-339,-5,70,283,478,504,600,813,607,92,-159,-210,-486,-445,-152,-240,-487,-462,-268,-241,-58,230,232,35,-55,7,212,366,284,-92,-443,-483,-406,-268,-158,-179,-394,-516,-291,83,258,131,-44,-163,-139,5,41,-67,-256,-369,-352,-222,-70,-18,-55,-129,-41,141,186,146,87,-35,-149,-93,45,51,12,-17}
        },
        {    // H0e070a.wav
            {0,0,0,0,1,2,2,1,2,0,-1,1,0,-1,3,1,-1,6,-6,14,-1,5,13,13,-4,2,27,582,1472,412,136,368,-565,544,1366,1104,2198,3875,2902,1000,1347,693,-1521,-1674,-638,-901,-980,-566,-618,-597,-193,-81,-620,-730,-345,-285,-368,-153,33,76,143,7,-340,-562,-556,-506,-563,-480,-298,-218,-137,-105,-110,-176,-200,-141,-129,-188,-214,-180,-194,-207,-208,-223,-198,-173,-143,-133,-96,-43,-53,-67,-80,-82,-128,-193,-189,-169,-149,-135,-129,-125,-126,-101,-113,-106,-73,-43,-17,-22,-15,-31,-36,-65,-124,-163,-198,-198,-197,-179,-164,-132,-86,-69,-36,-15,-19,-43},
            {-21,20,-133,4195,17381,-4118,-21438,1073,9223,1060,6071,25499,10798,-10026,461,3363,-6039,-7571,-8292,-10271,-4770,-2198,-1740,-3303,-1736,2919,1340,1522,4909,4985,1921,2061,2341,610,-2608,-4305,-4037,-4558,-4691,-4142,-1769,392,1286,1097,801,1103,1553,1468,1219,1207,536,-103,-156,-300,-992,-1356,-1398,-1683,-1613,-886,-190,-60,67,355,514,466,682,921,486,-56,-119,-259,-545,-333,-116,-364,-573,-435,-276,-207,77,296,152,-17,-28,75,250,335,157,-248,-482,-438,-330,-213,-147,-246,-483,-518,-171,187,209,31,-113,-179,-103,41,27,-129,-303,-396,-326,-166,-32,-26,-107,-145,-10,156,158,135,54,-84,-129,-22,76,28,-43,-97}
        },
        {    // H0e075a.wav
            {0,0,-1,-1,0,0,1,1,2,1,0,0,0,0,0,0,-1,0,3,-6,15,3,-6,19,13,-5,-3,13,281,1330,919,-10,608,124,-172,806,1366,1921,3496,3618,1507,1019,1166,-322,-1081,-599,-1161,-1951,-1450,-952,-1068,-996,-737,-762,-571,-28,155,108,249,464,488,307,7,-309,-535,-692,-730,-753,-702,-536,-380,-253,-178,-102,-54,-24,-5,-21,-85,-132,-125,-160,-223,-249,-276,-279,-234,-180,-158,-137,-92,-71,-83,-87,-88,-91,-107,-128,-120,-130,-135,-121,-127,-139,-148,-136,-100,-55,-25,-24,-25,-27,-35,-72,-104,-134,-173,-194,-203,-183,-166,-134,-114,-114,-83,-53,-27,-40},
            {-176,270,-431,7424,17046,-12260,-19326,6706,8448,-860,12085,26119,906,-9926,4561,2537,-7126,-7332,-8828,-9327,-3011,-1682,-3033,-4861,-363,3199,664,2396,5348,3856,1557,2657,1952,-509,-2916,-3470,-3705,-4904,-4686,-3371,-1263,460,1243,830,603,1200,1647,1337,1257,1215,278,-239,-24,-350,-1199,-1358,-1420,-1720,-1466,-625,-136,-175,-44,435,542,463,775,920,411,-82,-85,-355,-518,-168,-125,-501,-628,-385,-280,-168,198,295,83,-48,13,114,272,320,29,-357,-479,-344,-221,-160,-170,-343,-546,-443,-43,232,124,-51,-161,-180,-53,54,9,-174,-338,-390,-273,-102,12,-9,-160,-183,26,178,155,103,17,-106,-84,69,88,-18,-94,-129}
        },
        {    // H0e080a.wav
            {0,-1,-1,-1,-1,-1,0,-1,1,0,0,-1,0,2,0,0,-1,-1,1,1,1,11,1,-2,30,9,-14,-11,-1,160,1113,1465,446,194,27,-13,824,1278,1675,3090,3838,2251,1515,1957,403,-1510,-1616,-1695,-2315,-2118,-1638,-1552,-1347,-850,-464,-165,368,668,559,572,732,644,261,-118,-385,-653,-874,-963,-944,-852,-653,-459,-288,-83,35,101,101,78,53,-29,-72,-121,-188,-296,-320,-295,-307,-264,-232,-196,-165,-115,-87,-93,-53,-14,-14,-68,-103,-105,-121,-137,-148,-158,-169,-150,-113,-91,-62,-38,-28,-49,-63,-69,-91,-110,-143,-172,-188,-174,-156,-161,-148,-131,-124,-107,-69,-33},
            {-280,436,-554,10004,15367,-17574,-16314,10087,7182,-1280,16883,23784,-6108,-7995,7633,1713,-8023,-6816,-8944,-8650,-1614,-1581,-5004,-5627,1340,2906,-126,3603,5662,2695,1429,2905,1021,-1463,-2472,-2527,-3575,-4844,-4278,-3046,-880,539,749,487,639,1193,1491,1301,1400,1071,64,-199,99,-414,-1178,-1325,-1501,-1686,-1315,-484,-174,-271,-105,406,519,489,841,915,316,-58,-80,-402,-447,-70,-153,-602,-636,-351,-258,-117,231,250,19,-60,23,122,300,283,-49,-426,-454,-270,-161,-106,-187,-414,-594,-378,53,222,54,-125,-220,-191,-18,70,-36,-215,-358,-354,-207,-57,23,-52,-197,-175,61,178,122,74,-21,-116,-59,93,75,-45,-109,-165}
        },
        {    // H0e085a.wav
            {1,0,-1,-1,-1,0,0,0,1,2,2,1,1,1,0,1,-2,-1,0,3,3,-4,14,8,7,23,2,-30,-9,54,293,1401,1473,-87,212,798,226,514,1106,1445,2691,4504,3838,1831,1138,-114,-2028,-2186,-2022,-2869,-2806,-1941,-1483,-1233,-654,-23,360,743,1022,905,727,744,554,114,-338,-596,-786,-1048,-1112,-1025,-908,-687,-390,-120,44,148,191,168,111,82,21,-110,-191,-249,-305,-325,-318,-320,-316,-267,-211,-173,-114,-43,-17,4,35,7,-49,-87,-116,-130,-149,-163,-170,-157,-130,-113,-104,-90,-51,-37,-62,-74,-88,-101,-113,-125,-152,-165,-145,-157,-167,-163,-154,-130,-78,-25},
            {-329,516,-589,11258,14119,-20135,-14312,11778,6384,-1031,19298,21206,-10200,-6273,10222,1278,-8867,-5915,-8809,-8480,-558,-1790,-7025,-5650,2667,2098,-277,4354,5522,2451,1296,2619,90,-1921,-1853,-1920,-3506,-4399,-3570,-2943,-842,600,487,-9,558,1256,1225,1215,1499,963,-88,-101,268,-424,-1121,-1201,-1503,-1740,-1185,-358,-256,-345,-125,336,464,514,865,889,281,-53,-84,-379,-393,-22,-170,-633,-599,-303,-232,-91,254,179,-56,-69,22,144,300,251,-91,-421,-420,-253,-110,-45,-167,-455,-614,-333,98,220,2,-179,-261,-198,-4,65,-51,-234,-337,-307,-184,-31,26,-72,-192,-142,66,173,135,56,-58,-150,-56,93,77,-38,-125,-183}
        },
        {    // H0e090a.wav
            {0,-1,-1,-1,-1,-1,-1,0,-1,1,0,-1,1,0,-1,0,-3,-2,-2,3,1,-3,5,17,8,1,14,-17,-17,142,652,557,356,1077,804,509,932,639,379,581,1414,3573,5326,3672,748,-99,-453,-1911,-2745,-2775,-3069,-2714,-1804,-1237,-863,-252,404,726,1007,1192,1025,678,534,361,-178,-598,-774,-892,-1080,-1175,-1030,-821,-496,-222,-30,127,197,220,167,118,30,-50,-129,-220,-251,-323,-346,-341,-344,-352,-298,-175,-99,-45,-14,15,41,37,-16,-73,-89,-103,-130,-168,-193,-164,-147,-163,-151,-116,-74,-54,-51,-73,-98,-93,-104,-114,-126,-133,-138,-155,-170,-195,-172,-112,-56,-26},
            {-335,531,-666,11016,14274,-20450,-14263,12368,6401,-801,19447,19852,-12004,-5756,12468,1733,-9639,-5131,-8237,-8810,85,-2066,-8668,-5494,3117,1712,-260,4570,5301,2338,1627,2189,-842,-1992,-1338,-1702,-3319,-3868,-3063,-2585,-812,342,377,-215,265,1103,1114,1065,1393,929,-46,-95,322,-262,-1020,-1130,-1409,-1717,-1222,-280,-226,-397,-211,273,410,477,842,837,272,-36,-70,-360,-378,3,-131,-616,-560,-251,-219,-103,254,128,-151,-100,40,131,284,246,-105,-429,-382,-195,-60,-30,-174,-450,-620,-324,100,208,-37,-213,-289,-228,-13,73,-31,-230,-347,-326,-174,2,46,-72,-203,-152,84,193,130,18,-104,-176,-72,82,65,-52,-127,-156}
        },
        {    // H0e095a.wav
            {-1,-1,-1,-1,-1,-1,-1,0,-1,-1,-1,1,0,0,1,-1,-3,-2,-2,2,-3,1,6,11,9,12,-10,-2,49,554,765,-72,-138,776,1294,1027,825,1467,1419,-467,26,2826,4048,3905,2227,55,-618,-625,-1994,-3244,-3004,-2552,-2270,-1626,-746,-351,-7,597,984,1137,1103,862,493,290,-9,-454,-774,-829,-853,-1084,-1087,-841,-556,-363,-162,37,146,197,150,86,47,19,-45,-155,-243,-300,-311,-351,-396,-373,-294,-183,-111,-58,-24,7,18,6,-21,-52,-38,-56,-128,-171,-187,-200,-199,-175,-154,-144,-109,-87,-76,-61,-71,-100,-124,-125,-108,-110,-132,-155,-164,-164,-151,-100,-46,-28},
            {-302,463,-692,9276,15697,-18346,-16300,11923,7260,-853,17710,19991,-11665,-6850,14080,3568,-10173,-4957,-7112,-9372,91,-2034,-9688,-5798,2744,2048,-209,4127,5276,2409,1691,2229,-1291,-2356,-868,-1539,-3133,-3529,-2644,-2285,-687,297,79,-390,276,862,797,991,1299,836,16,-51,310,-144,-877,-985,-1340,-1652,-1221,-308,-179,-379,-300,197,373,431,767,758,274,-18,-46,-329,-390,8,-54,-538,-531,-232,-174,-132,204,113,-172,-177,-1,117,257,252,-88,-394,-344,-157,-36,-8,-172,-446,-595,-321,67,182,-38,-240,-327,-231,-6,96,-31,-262,-368,-325,-158,27,68,-79,-203,-129,94,182,102,-7,-105,-187,-108,35,40,-37,-102,-136}
        },
        {    // H0e100a.wav
            {1,0,-1,-1,0,0,0,0,0,0,0,1,2,1,3,1,1,-1,1,1,-1,4,10,5,14,11,6,-2,443,965,148,-379,298,587,543,1101,1862,2206,1974,24,-1028,1320,2929,2420,2028,1455,-37,-819,-904,-2089,-2978,-2560,-2038,-1748,-1055,-440,-237,178,790,1023,923,828,643,267,-76,-342,-602,-694,-747,-827,-891,-803,-608,-452,-276,-106,33,66,48,81,95,74,-1,-110,-204,-240,-267,-354,-390,-310,-221,-199,-146,-69,-30,-35,-42,-25,-14,-21,-29,-46,-86,-153,-207,-215,-192,-161,-148,-162,-157,-109,-70,-65,-75,-88,-114,-123,-114,-118,-124,-110,-104,-111,-97,-81,-52,-30},
            {-180,258,-491,6236,17321,-13108,-19957,9776,9141,-1047,14315,21126,-8941,-9433,14288,7077,-9974,-5756,-5587,-9782,-719,-1488,-10054,-6717,1744,2686,44,3280,5205,2694,1794,2172,-1098,-2599,-885,-1305,-2716,-3507,-2489,-1874,-715,308,108,-540,38,840,683,705,1133,916,48,-141,294,-9,-777,-853,-1190,-1572,-1227,-300,-154,-365,-300,123,294,362,696,716,264,-41,-9,-247,-404,-33,47,-447,-503,-233,-145,-154,165,130,-173,-202,-66,63,218,284,-7,-338,-331,-149,-11,27,-148,-420,-596,-339,45,183,-40,-259,-307,-224,-2,89,-44,-271,-358,-290,-166,-6,78,-25,-146,-129,47,143,117,21,-110,-208,-147,25,51,-22,-83,-111}
        },
        {    // H0e105a.wav
            {1,0,2,1,0,2,0,0,1,0,0,0,0,2,1,1,1,1,0,1,-2,13,-1,9,14,13,1,296,1079,478,-494,97,562,321,323,1018,2638,3235,1501,194,-118,-60,773,1232,1123,1205,1073,92,-864,-1083,-1578,-2313,-2070,-1364,-1182,-932,-485,5,370,586,728,692,562,286,-46,-316,-420,-469,-568,-630,-632,-624,-610,-512,-344,-262,-206,-105,3,52,83,84,-8,-85,-133,-178,-259,-279,-251,-246,-219,-174,-128,-111,-106,-86,-79,-42,-10,-41,-67,-59,-76,-142,-174,-174,-165,-159,-175,-185,-166,-119,-83,-86,-93,-85,-91,-124,-140,-124,-90,-53,-46,-48,-61,-61,-57,-55},
            {32,-98,33,2623,17173,-4233,-23233,4501,11818,-564,9169,22076,-3299,-12545,11944,11845,-7956,-7704,-4056,-9512,-2548,-526,-9555,-8195,191,3086,575,2252,5006,3126,1858,2324,-581,-2892,-936,-1073,-2339,-3313,-2694,-1699,-709,264,138,-424,-173,598,742,684,827,863,256,-228,77,116,-647,-818,-1049,-1380,-1228,-397,-58,-312,-340,47,260,263,572,708,309,-98,-18,-144,-373,-126,120,-327,-517,-267,-133,-152,102,166,-154,-240,-100,1,157,304,82,-262,-343,-156,-13,45,-121,-381,-563,-413,-18,171,9,-240,-287,-227,-93,51,6,-192,-344,-346,-209,-41,109,37,-135,-178,-10,156,128,6,-127,-199,-146,7,59,-9,-75,-83}
        },
        {    // H0e110a.wav
            {0,0,1,1,1,1,0,0,0,0,-1,1,0,0,3,1,1,2,3,-4,4,11,-2,10,14,10,170,1106,889,-544,-176,636,335,79,727,2240,2955,2065,1332,715,114,-278,-904,-439,458,640,896,923,246,-565,-822,-1032,-1411,-1497,-1243,-1053,-812,-310,-30,125,333,479,372,127,14,-93,-251,-317,-317,-378,-475,-472,-460,-469,-505,-455,-319,-226,-85,-19,-5,3,-12,-55,-126,-121,-107,-146,-186,-190,-167,-152,-130,-165,-171,-130,-78,-60,-88,-79,-106,-120,-95,-82,-98,-121,-141,-187,-206,-180,-148,-135,-119,-100,-99,-98,-120,-132,-114,-82,-60,-34,-10,-4,-18,-48,-73,-97},
            {223,-394,520,-23,13468,6429,-22276,-4648,13466,2211,2993,20576,5183,-14015,6317,16063,-2923,-10018,-3656,-7877,-5137,-52,-7700,-9750,-2074,2987,1310,1264,4505,3730,1959,2359,551,-3014,-1640,-485,-1837,-3210,-2920,-1694,-873,163,204,-306,-256,454,682,696,801,764,333,-166,-132,63,-530,-810,-897,-1185,-1189,-537,-1,-167,-350,-120,258,227,417,663,432,-91,-100,-42,-292,-225,101,-177,-532,-348,-125,-129,23,182,-85,-259,-128,20,101,260,167,-152,-319,-190,-34,25,-80,-304,-511,-478,-130,153,92,-164,-299,-304,-144,70,98,-124,-352,-399,-238,-28,80,19,-127,-160,-27,127,95,-7,-76,-139,-150,-22,75,29,-46,-69}
        },
        {    // H0e115a.wav
            {1,1,1,3,1,2,2,0,1,0,1,2,-1,1,3,1,2,3,5,-4,9,2,11,5,27,72,1032,1344,-434,-554,636,448,-30,519,2287,3259,1959,887,939,874,118,-942,-1297,-1181,-674,194,581,827,1121,557,-247,-187,-357,-1170,-1492,-1103,-770,-780,-539,-215,-61,35,67,11,41,122,25,-118,-148,-160,-276,-353,-380,-465,-530,-510,-390,-283,-233,-161,-111,-87,-92,-68,-13,24,7,-70,-136,-116,-94,-139,-172,-172,-169,-158,-130,-118,-148,-175,-157,-111,-81,-62,-43,-74,-140,-196,-195,-165,-150,-130,-127,-125,-122,-132,-135,-109,-66,-42,-34,-25,5,23,-3,-49,-98,-124},
            {190,-300,390,-558,6871,13993,-13693,-14945,10424,7614,-1319,14160,14286,-10705,-1801,16939,4937,-10370,-5564,-5169,-7056,-1350,-4800,-10104,-5201,1957,2247,513,3459,4362,2352,2092,1744,-2038,-2832,-561,-864,-2810,-3358,-1833,-993,-211,183,-90,-315,268,767,672,705,874,496,-187,-268,-25,-457,-898,-792,-945,-1129,-734,-16,-20,-269,-248,153,256,278,574,543,25,-182,0,-178,-305,-17,-66,-505,-448,-160,-117,-75,155,33,-217,-155,29,95,177,208,-21,-267,-243,-92,-8,-59,-229,-430,-522,-246,96,140,-149,-310,-271,-138,56,89,-78,-297,-347,-268,-134,-18,10,-61,-133,-96,37,84,40,-17,-92,-143,-55,87,77,-13,-66}
        },
        {    // H0e120a.wav
            {1,1,1,3,2,1,0,-1,0,0,1,1,-1,2,1,2,1,8,-3,9,-5,16,-4,39,23,869,1751,-115,-974,491,641,-129,313,2483,3671,2096,886,829,354,33,-471,-1274,-1339,-1105,-1065,-584,303,927,1071,1131,1055,429,-153,-517,-1041,-1184,-982,-928,-914,-684,-477,-405,-328,-68,155,210,227,149,48,-26,-130,-311,-390,-395,-414,-451,-467,-402,-332,-280,-279,-246,-84,51,71,59,40,3,-44,-71,-74,-96,-143,-175,-183,-188,-188,-215,-243,-217,-151,-95,-84,-48,-39,-87,-134,-164,-162,-150,-137,-126,-126,-154,-167,-142,-108,-69,-47,-42,-20,7,10,-4,-30,-69,-110,-134},
            {-50,113,-206,216,1171,13676,555,-19514,563,12151,148,3983,18232,-526,-8836,12129,12970,-6087,-9157,-3437,-6534,-4268,-2879,-8152,-8001,-820,2973,593,1769,4478,3303,1818,2120,-29,-3106,-1674,-415,-1759,-3343,-2450,-1183,-511,-64,-45,-134,29,698,819,646,806,807,34,-443,-220,-262,-904,-921,-785,-954,-899,-238,102,-144,-241,7,265,176,409,613,257,-175,-42,-55,-327,-214,-46,-389,-555,-271,-123,-147,53,142,-91,-157,5,107,139,207,80,-178,-294,-167,-63,-53,-172,-345,-484,-367,-71,52,-55,-200,-195,-170,-57,54,20,-156,-329,-356,-242,-85,11,-49,-164,-170,-7,110,68,11,-47,-97,-69,70,104,12,-47}
        },
        {    // H0e125a.wav
            {1,1,2,1,1,0,-1,0,-1,-1,-2,-1,1,-2,1,-4,8,-6,6,-5,10,-3,26,16,674,2053,375,-1359,205,826,-130,79,2608,4260,2342,783,934,328,-298,-961,-1665,-1263,-954,-1099,-907,-600,95,721,984,1417,1577,957,120,-267,-376,-852,-1215,-1099,-1054,-1104,-1001,-818,-500,-100,145,253,329,379,254,4,-129,-197,-287,-328,-373,-426,-465,-459,-440,-468,-378,-158,-28,12,33,72,68,11,12,26,-20,-95,-124,-177,-198,-205,-268,-308,-281,-182,-149,-126,-71,-56,-84,-132,-131,-128,-112,-100,-119,-143,-164,-154,-157,-134,-85,-54,-45,-42,-6,0,-23,-46,-74,-97,-119,-129},
            {-133,219,-310,363,-484,6637,11530,-12096,-11947,9746,6944,-2743,11676,12332,-8032,1950,16447,3166,-10723,-5212,-3657,-6464,-3678,-5239,-8365,-4691,1952,1751,200,3497,4288,2294,1657,1541,-1550,-2673,-1016,-1004,-2505,-2864,-1675,-962,-297,-172,-75,0,465,892,744,703,914,460,-357,-456,-186,-611,-1060,-887,-829,-881,-569,5,12,-136,-72,229,193,154,499,547,42,-134,-7,-256,-402,-166,-224,-585,-477,-174,-144,-91,145,86,-79,-17,108,120,182,146,-75,-277,-267,-124,-62,-114,-275,-427,-505,-295,11,80,-89,-204,-206,-118,57,102,-94,-329,-372,-262,-158,-100,-92,-159,-167,-56,90,99,35,-7,-39,-51,21,100,55,-39}
        },
        {    // H0e130a.wav
            {1,2,2,1,0,-1,0,-1,1,-1,-2,1,-2,4,-3,4,1,2,0,6,6,13,25,491,2248,998,-1646,-247,980,-54,-140,2737,4890,2625,728,1083,310,-510,-1069,-2132,-1997,-1179,-946,-921,-564,130,197,283,1146,1550,1162,943,642,135,-223,-496,-869,-1276,-1327,-1332,-1395,-1040,-470,-172,5,284,473,342,234,171,13,-130,-215,-288,-400,-413,-411,-506,-558,-392,-207,-165,-139,-60,35,26,12,81,115,77,-18,-103,-144,-160,-166,-236,-310,-306,-255,-187,-150,-124,-95,-99,-129,-160,-126,-76,-52,-65,-119,-159,-166,-137,-111,-87,-73,-66,-42,-31,-30,-45,-72,-92,-109,-106,-104,-112},
            {41,-81,130,-211,249,578,10869,3222,-15834,-1745,11507,324,-319,15663,4010,-6362,10895,12916,-5579,-9573,-2103,-5075,-6442,-3962,-6442,-7069,-1401,2459,230,1220,4572,3461,1486,1665,646,-2148,-1921,-1013,-1697,-2638,-2082,-1339,-951,-314,-93,-36,217,793,912,702,813,803,55,-500,-284,-270,-892,-1019,-863,-849,-792,-290,75,-8,-69,122,300,115,222,543,408,-49,-55,-124,-443,-396,-178,-412,-628,-361,-144,-157,47,221,65,-22,93,156,141,169,41,-184,-308,-186,-62,-92,-261,-430,-470,-364,-95,49,-52,-172,-145,-54,6,34,-34,-199,-315,-329,-238,-190,-144,-103,-130,-110,27,135,81,31,27,-10,-18,72,87,-30}
        },
        {    // H0e135a.wav
            {3,0,0,-1,-1,-1,-1,-1,-1,-3,1,-1,0,-2,2,2,-3,2,-5,17,-7,44,337,2314,1682,-1770,-816,1054,49,-333,2888,5560,2932,611,1246,436,-771,-1212,-2378,-2558,-1502,-1221,-1253,-635,354,521,340,796,1073,911,796,724,682,481,5,-340,-625,-1128,-1554,-1588,-1318,-923,-611,-282,-3,157,309,357,325,248,66,-87,-189,-307,-390,-432,-425,-398,-364,-283,-219,-229,-178,-128,-95,-25,86,148,95,17,-47,-120,-148,-118,-160,-250,-288,-250,-202,-201,-176,-140,-150,-168,-171,-149,-98,-42,-39,-96,-147,-147,-119,-100,-65,-47,-68,-86,-73,-56,-81,-112,-129,-131,-116,-102,-93,-98},
            {53,-79,97,-111,113,-199,3242,11060,-4614,-12920,5621,8287,-4177,4946,15135,-1389,-652,14743,5605,-9948,-5477,-1440,-7134,-5995,-4086,-6973,-4891,757,1513,-237,2632,4731,2396,1121,1575,-215,-2089,-1375,-1318,-2096,-2299,-1618,-1313,-957,-284,-76,21,483,955,855,717,840,549,-154,-396,-191,-501,-988,-892,-836,-870,-642,-135,37,-7,28,256,288,153,331,463,160,-93,-21,-275,-541,-356,-268,-572,-569,-239,-134,-83,188,224,47,58,167,142,117,116,-59,-219,-218,-152,-187,-238,-289,-358,-404,-309,-121,-21,-50,-65,-53,-49,-6,1,-98,-267,-348,-313,-221,-155,-106,-106,-121,-32,98,125,72,52,37,-16,-11,48,20}
        },
        {    // H0e140a.wav
            {1,0,-1,-2,-1,-1,-1,0,-2,-1,0,0,0,-1,5,-5,8,-13,22,-17,58,225,2314,2352,-1737,-1447,1055,205,-546,3039,6299,3275,487,1381,554,-971,-1323,-2607,-3085,-1806,-1346,-1490,-1001,176,741,572,1081,1325,628,278,511,497,364,409,345,-199,-751,-1025,-1380,-1436,-1038,-779,-647,-487,-133,126,197,336,308,159,50,-41,-238,-363,-301,-240,-317,-336,-213,-191,-251,-265,-225,-180,-126,-12,90,85,30,-32,-116,-123,-76,-105,-199,-223,-168,-163,-187,-190,-174,-191,-210,-193,-169,-113,-53,-55,-119,-146,-126,-93,-39,-6,-24,-76,-102,-90,-84,-110,-142,-142,-144,-138,-106,-86,-85,-99},
            {-53,80,-115,141,-196,239,-232,5809,8409,-9083,-7461,8812,2867,-4882,9929,12148,-3026,5152,13618,-1474,-9506,-1812,-3273,-8477,-4734,-4574,-6767,-2597,1477,434,261,3838,3984,1568,1185,1198,-806,-1769,-1142,-1529,-2025,-2033,-1514,-1325,-830,-350,-180,166,726,949,739,785,834,375,-198,-285,-248,-688,-957,-754,-734,-800,-576,-106,-23,-16,138,347,267,197,373,282,-87,-130,-34,-363,-558,-352,-377,-604,-417,-124,-120,-40,234,203,83,120,135,66,102,105,-92,-262,-251,-161,-164,-229,-337,-430,-442,-266,-47,6,-59,-48,-14,-25,-53,-97,-198,-295,-303,-238,-172,-154,-112,-93,-60,23,107,107,64,43,-8,-50,-9,29}
        },
        {    // H0e145a.wav
            {0,-3,-3,-2,-3,-1,-2,-2,-3,0,-1,0,-3,6,-11,14,-21,27,-30,63,148,2273,2986,-1603,-2110,969,404,-747,3204,7097,3560,353,1607,644,-1294,-1416,-2702,-3620,-2176,-1401,-1714,-1267,126,706,476,1263,1651,883,361,253,91,66,133,216,165,-215,-753,-1057,-935,-752,-783,-842,-662,-375,-175,-20,97,155,113,41,-52,-185,-155,-78,-165,-272,-238,-138,-134,-218,-261,-238,-212,-194,-132,-39,-2,-23,-61,-102,-117,-79,-91,-153,-164,-114,-105,-147,-155,-143,-181,-228,-214,-192,-146,-105,-116,-154,-171,-147,-75,13,42,-1,-83,-129,-120,-102,-116,-145,-157,-164,-159,-122,-90,-86,-103,-116},
            {9,-34,48,-76,101,-152,179,257,7360,4906,-10277,-2066,8086,-1866,-2476,12847,8769,-1897,8775,9430,-5509,-6458,-596,-6036,-8041,-3689,-5399,-5574,-1078,1226,-25,1254,4379,2897,1093,1282,869,-1211,-1481,-986,-1441,-1846,-1874,-1503,-1417,-729,-453,-264,270,837,904,695,841,863,325,-211,-237,-343,-796,-800,-612,-675,-718,-459,-164,-95,57,223,323,168,187,331,167,-216,-210,-147,-400,-447,-300,-422,-535,-264,-76,-123,7,232,168,102,128,91,20,61,12,-109,-146,-126,-174,-273,-342,-390,-410,-360,-191,-39,-3,-31,-28,-53,-90,-118,-143,-194,-227,-228,-206,-181,-136,-68,-46,-25,44,94,64,28,4,-26,-44,-12}
        },
        {    // H0e150a.wav
            {-1,-3,-1,-2,-3,-1,-3,-3,0,-2,4,-6,9,-15,15,-24,33,-35,62,91,2210,3574,-1358,-2763,770,650,-923,3330,7987,3846,133,1870,869,-1697,-1634,-2693,-4095,-2571,-1447,-1896,-1506,42,780,486,1227,1797,1047,406,463,212,-273,-257,-45,-114,-362,-435,-638,-703,-429,-401,-514,-560,-423,-293,-275,-155,-67,-118,-246,-188,-50,10,-14,-58,-141,-190,-84,-62,-131,-182,-173,-209,-259,-167,-68,-116,-165,-117,-135,-163,-94,-65,-121,-138,-87,-90,-122,-78,-71,-130,-161,-183,-196,-176,-153,-170,-217,-212,-149,-66,13,54,5,-94,-150,-133,-93,-90,-123,-159,-169,-157,-124,-97,-101,-111,-114,-97},
            {12,-10,-4,13,-37,50,-85,74,950,7867,1849,-9158,1426,5057,-4049,887,13529,6462,370,9442,4968,-6182,-3565,-1722,-7774,-6503,-3670,-5692,-4085,-498,733,169,2294,4138,1968,914,1340,438,-1328,-1182,-998,-1139,-1581,-1764,-1641,-1508,-711,-549,-325,300,858,879,729,872,880,320,-209,-228,-373,-755,-689,-575,-609,-621,-334,-132,-101,49,140,157,63,160,218,24,-210,-162,-219,-450,-352,-200,-380,-412,-176,-96,-148,30,191,119,110,87,-36,-37,120,106,-32,-147,-195,-257,-305,-344,-392,-385,-286,-128,-57,-60,-58,-55,-97,-129,-113,-106,-149,-190,-211,-187,-151,-86,-32,-24,-16,23,46,16,8,-8,-56,-60}
        },
        {    // H0e155a.wav
            {-3,-2,-2,-1,0,-3,-2,3,-1,4,-6,11,-17,18,-25,32,-30,59,53,2133,4095,-1033,-3363,486,882,-1043,3412,8902,4175,-138,2127,1154,-2057,-1998,-2646,-4467,-3080,-1446,-2013,-1779,11,867,431,1269,2000,1120,360,460,325,-162,-293,-333,-458,-599,-678,-722,-585,-208,11,-82,-164,-155,-211,-299,-244,-260,-477,-531,-264,-119,-152,-24,37,-66,-131,-29,57,-38,-118,-116,-153,-200,-149,-99,-147,-186,-216,-288,-283,-106,-15,-121,-157,-107,-75,-75,-46,-10,-41,-84,-125,-181,-194,-162,-172,-226,-240,-190,-100,-10,23,-46,-151,-175,-119,-58,-55,-93,-140,-164,-144,-116,-101,-106,-130,-133,-101,-48},
            {-12,25,-27,18,-17,3,3,-20,-1,1592,7638,-111,-7013,2433,1929,-3859,3438,12907,5687,2213,8024,2063,-4940,-2265,-3677,-7768,-5243,-4241,-5200,-2976,-453,442,708,2916,3463,1454,1060,1126,-52,-1064,-952,-1025,-905,-1249,-1584,-1892,-1574,-779,-671,-289,362,793,791,824,983,826,245,-86,-112,-444,-713,-569,-529,-535,-489,-241,-103,-79,-78,-52,-23,-66,50,138,31,-108,-36,-217,-469,-327,-140,-237,-258,-174,-172,-154,43,118,5,17,69,72,84,108,30,-75,-138,-195,-265,-309,-321,-298,-312,-289,-210,-123,-74,-59,-50,-99,-115,-96,-87,-121,-154,-169,-150,-103,-54,-23,-18,-12,7,-4,-18,-19,-18,-39}
        },
        {    // H0e160a.wav
            {-3,-2,-1,-2,-3,-4,2,0,6,-7,13,-18,18,-26,33,-31,62,31,2076,4538,-694,-3863,125,1086,-1108,3465,9851,4533,-442,2386,1455,-2365,-2425,-2708,-4694,-3586,-1558,-2067,-2044,21,992,405,1256,2133,1326,389,372,312,-253,-298,-203,-589,-884,-853,-1098,-948,-139,313,225,93,222,196,-71,-218,-356,-491,-517,-526,-473,-285,-83,-68,-214,-161,103,155,21,-38,-29,-83,-150,-119,-21,-71,-207,-280,-369,-370,-210,-90,-143,-189,-108,-63,-80,-11,54,37,-44,-119,-170,-146,-97,-120,-190,-252,-222,-142,-65,-53,-128,-222,-232,-131,-31,-10,-46,-108,-143,-127,-92,-87,-119,-148,-154,-121,-54,13},
            {14,-19,30,-36,32,-41,34,-40,39,-56,2069,7034,-871,-5114,1662,78,-2586,4577,12065,6021,2867,5913,1004,-3390,-2567,-4944,-6779,-4927,-4609,-4278,-2404,-700,670,1176,2735,2954,1495,1042,713,-136,-892,-843,-839,-829,-1109,-1354,-1942,-1762,-965,-612,-154,318,602,746,917,1035,808,239,-21,-101,-406,-607,-461,-417,-463,-431,-271,-196,-155,-173,-227,-215,-158,-20,147,110,2,8,-164,-361,-292,-159,-193,-153,-145,-239,-276,-83,69,66,90,68,36,52,56,0,-72,-127,-174,-225,-238,-256,-288,-361,-360,-273,-160,-66,-21,-41,-108,-118,-91,-70,-66,-100,-145,-138,-94,-34,-1,-5,-44,-51,-45,-45,-19,-23}
        },
        {    // H0e165a.wav
            {-3,1,-2,-2,-3,2,-3,6,-8,13,-21,16,-26,29,-31,59,20,2032,4908,-346,-4252,-263,1214,-1103,3449,10731,5022,-762,2602,1787,-2635,-2836,-2829,-4931,-4038,-1695,-2086,-2344,-54,1240,408,1222,2282,1424,470,408,271,-359,-410,-247,-529,-936,-1204,-1254,-930,-420,6,275,407,474,410,215,74,28,-218,-637,-714,-554,-427,-335,-329,-333,-242,-26,95,96,49,77,38,-92,-21,78,-26,-204,-258,-349,-421,-286,-178,-260,-266,-127,-70,-51,42,84,27,-46,-103,-129,-96,-23,-19,-127,-221,-240,-202,-152,-134,-165,-270,-303,-196,-47,13,-13,-59,-104,-93,-68,-73,-108,-144,-164,-145,-78,-3,21},
            {-4,13,-19,29,-38,35,-52,54,-65,74,-81,2340,6389,-772,-4101,326,-368,-1382,4633,11636,6713,2408,4127,1228,-2521,-3486,-5084,-5900,-5111,-4471,-3390,-2254,-882,1068,1431,2227,2514,1790,1059,339,-86,-756,-847,-603,-666,-1186,-1434,-1700,-1669,-1231,-605,52,214,383,750,977,1027,723,297,56,-114,-322,-415,-333,-317,-461,-587,-409,-289,-278,-329,-258,-211,-214,-33,208,206,86,34,-175,-282,-156,-109,-239,-292,-235,-228,-244,-85,55,94,65,-16,-61,-18,69,75,-3,-93,-150,-196,-229,-267,-316,-389,-395,-309,-159,-62,-32,-50,-99,-103,-64,-21,-36,-96,-134,-127,-75,-11,4,-33,-88,-93,-77,-53,-32}
        },
        {    // H0e170a.wav
            {0,0,-3,-4,3,-4,6,-7,15,-22,17,-27,29,-34,55,16,2040,5198,-74,-4511,-618,1244,-1042,3455,11471,5594,-986,2739,2102,-2853,-3279,-2952,-5120,-4545,-1892,-2034,-2546,-207,1406,519,1203,2421,1590,452,376,311,-359,-510,-271,-726,-1295,-1055,-1107,-1130,-624,-136,145,256,490,494,415,613,535,-51,-485,-523,-554,-639,-569,-453,-523,-517,-194,30,48,39,56,73,72,129,179,58,-121,-240,-370,-442,-306,-176,-285,-363,-232,-103,-62,46,90,-6,-69,-68,-49,-26,23,32,-46,-143,-226,-267,-242,-192,-214,-318,-348,-229,-68,-7,-18,-42,-64,-58,-30,-35,-92,-137,-146,-139,-105,-36,-3,-39},
            {3,-5,11,-12,25,-34,33,-47,53,-67,82,-70,2399,5921,-320,-3942,-720,9,-754,4209,11699,7209,1325,3101,1895,-2433,-4150,-4608,-5429,-5330,-4030,-2675,-2383,-853,1413,1386,1795,2264,1839,1128,446,-293,-660,-684,-591,-560,-1227,-1541,-1602,-1376,-1105,-719,-68,269,405,672,849,870,752,404,145,-16,-225,-317,-297,-356,-567,-741,-574,-369,-360,-401,-274,-127,-63,77,242,229,117,42,-135,-303,-219,-116,-173,-300,-316,-257,-210,-50,37,14,-73,-77,-21,34,107,121,68,-59,-162,-229,-266,-268,-303,-384,-431,-337,-159,-46,-30,-67,-82,-64,-24,-2,-31,-83,-112,-103,-73,-26,-11,-59,-120,-117,-88,-61}
        },
        {    // H0e175a.wav
            {0,-3,-4,4,-3,5,-7,16,-23,19,-26,29,-37,54,10,2094,5398,131,-4603,-926,1186,-947,3482,11948,6225,-962,2781,2348,-2957,-3704,-3188,-5175,-4991,-2281,-2001,-2617,-343,1502,664,1162,2480,1847,499,262,319,-309,-526,-559,-857,-1127,-1226,-1316,-1106,-597,-247,24,100,186,430,796,927,590,250,-36,-242,-505,-662,-558,-596,-772,-749,-391,-102,-25,-42,8,75,89,190,305,190,-35,-175,-350,-430,-290,-162,-280,-361,-261,-188,-159,-32,64,-6,-64,-36,-4,32,85,96,6,-128,-217,-265,-263,-241,-276,-364,-385,-256,-91,-15,-23,-50,-55,-43,-4,2,-46,-109,-152,-138,-102,-52,-27,-60,-101},
            {-5,2,-2,9,-10,19,-28,25,-40,44,-57,73,-38,2329,5661,40,-4201,-1159,574,-643,3807,11970,7200,191,2772,2360,-2718,-4296,-4006,-5257,-5407,-3396,-2263,-2564,-638,1577,1100,1504,2279,1820,965,495,41,-753,-784,-388,-636,-1254,-1471,-1557,-1319,-799,-491,-247,91,525,622,559,800,846,553,193,27,-182,-422,-384,-435,-704,-861,-651,-440,-353,-277,-167,-72,35,256,364,201,25,-56,-207,-329,-217,-88,-153,-278,-316,-318,-280,-97,22,6,-59,-59,-17,48,140,162,78,-71,-195,-264,-265,-258,-318,-411,-426,-312,-144,-49,-31,-61,-77,-52,-9,22,-6,-70,-121,-126,-89,-46,-31,-76,-127,-117,-88}
        },
        {    // H0e180a.wav
            {-3,-4,3,-4,6,-9,16,-25,19,-31,34,-46,60,-8,2200,5530,192,-4501,-1159,994,-791,3572,12125,6811,-604,2758,2477,-2946,-4064,-3530,-5220,-5273,-2800,-2070,-2631,-454,1570,847,1284,2371,1898,744,291,266,-401,-869,-519,-607,-1259,-1358,-1433,-1302,-662,-168,-84,-173,223,718,668,709,834,593,149,-154,-298,-432,-521,-623,-815,-876,-560,-307,-258,-149,9,40,62,235,376,223,-47,-141,-249,-333,-247,-136,-208,-341,-301,-266,-265,-124,53,48,-53,-68,-32,61,155,167,37,-124,-209,-254,-266,-276,-308,-389,-407,-289,-120,-33,-35,-51,-66,-41,3,26,-14,-87,-134,-143,-108,-50,-25,-76,-124,-110},
            {-3,-4,3,-4,6,-9,16,-25,19,-31,34,-46,60,-8,2200,5530,192,-4501,-1159,994,-791,3572,12125,6811,-604,2758,2477,-2946,-4064,-3530,-5220,-5273,-2800,-2070,-2631,-454,1570,847,1284,2371,1898,744,291,266,-401,-869,-519,-607,-1259,-1358,-1433,-1302,-662,-168,-84,-173,223,718,668,709,834,593,149,-154,-298,-432,-521,-623,-815,-876,-560,-307,-258,-149,9,40,62,235,376,223,-47,-141,-249,-333,-247,-136,-208,-341,-301,-266,-265,-124,53,48,-53,-68,-32,61,155,167,37,-124,-209,-254,-266,-276,-308,-389,-407,-289,-120,-33,-35,-51,-66,-41,3,26,-14,-87,-134,-143,-108,-50,-25,-76,-124,-110}
        }
    },
    {    // elev10
        {    // H10e000a.wav
            {8,-10,21,-18,26,-27,18,-9,-10,27,-41,38,1898,8088,-528,-4303,777,-5855,2708,7238,3222,11158,10655,-3431,-4559,3601,-4772,-13166,-5593,-950,-5732,-3428,2126,267,870,3637,2542,1094,2453,2423,426,-147,659,-20,-1273,-694,-572,-1972,-2857,-1624,-424,-257,-301,-390,-502,-85,304,161,-128,17,259,131,-198,-166,-69,-454,-598,-581,-651,-369,25,-105,-224,-20,6,-116,36,146,-74,-267,-267,-209,-169,-183,-149,-147,-225,-187,-61,-1,-15,4,-49,-135,-101,30,-14,-86,-86,-196,-297,-260,-228,-192,-118,-138,-152,-18,126,177,136,-9,-107,-123,-139,-142,-115,-186,-242,-151,-80,-40,-18,-93,-160,-113,-67,-53},
            {8,-10,21,-18,26,-27,18,-9,-10,27,-41,38,1898,8088,-528,-4303,777,-5855,2708,7238,3222,11158,10655,-3431,-4559,3601,-4772,-13166,-5593,-950,-5732,-3428,2126,267,870,3637,2542,1094,2453,2423,426,-147,659,-20,-1273,-694,-572,-1972,-2857,-1624,-424,-257,-301,-390,-502,-85,304,161,-128,17,259,131,-198,-166,-69,-454,-598,-581,-651,-369,25,-105,-224,-20,6,-116,36,146,-74,-267,-267,-209,-169,-183,-149,-147,-225,-187,-61,-1,-15,4,-49,-135,-101,30,-14,-86,-86,-196,-297,-260,-228,-192,-118,-138,-152,-18,126,177,136,-9,-107,-123,-139,-142,-115,-186,-242,-151,-80,-40,-18,-93,-160,-113,-67,-53}
        },
        {    // H10e005a.wav
            {-5,7,-10,17,-14,22,-25,19,-16,-5,15,-22,23,1889,7149,-518,-3414,595,-5275,2423,6185,3200,10325,9507,-2416,-3417,2856,-4646,-11380,-5062,-1570,-5185,-2855,1569,36,908,3053,2060,1304,2377,1943,287,67,774,122,-891,-619,-637,-1599,-2412,-1597,-647,-692,-462,-49,-200,-42,280,337,72,-149,-257,-227,-254,-286,-269,-510,-484,-443,-519,-264,22,-90,-200,-16,48,-62,-6,74,-20,-192,-231,-263,-243,-194,-171,-159,-211,-151,-36,10,8,32,-36,-167,-115,14,-43,-113,-117,-187,-263,-210,-206,-240,-186,-155,-130,-32,99,182,158,24,-82,-104,-121,-135,-124,-185,-214,-144,-101,-66,-27,-89,-163,-124,-76},
            {-5,13,-7,6,5,-27,42,-81,121,-163,178,894,8461,2319,-6244,874,-5714,638,8686,3189,10649,13056,-1958,-6854,3247,-2534,-13773,-8040,-898,-4842,-4904,1647,832,518,3589,3251,1252,2034,2899,1129,-8,462,216,-1324,-1043,-793,-2131,-2876,-1976,-683,57,95,-417,-959,-409,164,-107,-365,308,748,380,64,28,123,-282,-591,-644,-771,-557,-77,-103,-245,-96,-95,-194,-10,153,-4,-250,-257,-187,-123,-98,-105,-113,-237,-259,-130,-40,-46,-1,-32,-178,-173,35,49,-31,-69,-205,-323,-240,-161,-172,-109,-114,-145,-43,107,180,132,-17,-138,-150,-149,-157,-122,-194,-265,-187,-98,-35,42,-29,-166,-136,-71,-47,10}
        },
        {    // H10e010a.wav
            {-3,-2,6,-9,17,-14,22,-26,29,-31,18,-11,20,-2,2132,6296,-935,-2468,34,-4445,2571,5023,3836,9627,7874,-1766,-2306,1752,-4668,-9528,-4723,-1983,-4399,-2249,973,92,1067,2371,1792,1589,2008,1344,421,339,786,170,-696,-585,-746,-1488,-1899,-1384,-924,-771,-275,128,-97,-103,141,269,110,-257,-536,-440,-359,-344,-378,-513,-366,-301,-425,-268,7,-59,-133,-19,12,-36,24,90,1,-141,-237,-301,-264,-231,-178,-159,-200,-139,-17,19,5,18,-31,-148,-147,-38,-58,-93,-117,-204,-247,-182,-194,-248,-202,-163,-116,-5,101,155,132,32,-56,-106,-145,-140,-107,-162,-194,-142,-100,-63,-33,-104,-169,-123},
            {6,11,-16,36,-62,85,-131,181,-225,265,280,8085,5263,-7290,-10,-5096,-1352,9817,3335,10348,15232,-848,-8412,2576,-1268,-13965,-9234,-1449,-4556,-5322,1216,730,243,3765,3452,1560,1925,2881,1580,511,588,291,-1127,-1391,-1410,-2074,-2764,-2338,-896,80,275,-120,-1013,-943,-400,-272,-118,463,799,605,399,242,334,-115,-539,-598,-792,-684,-192,-128,-316,-176,-138,-280,-164,107,64,-172,-194,-158,-90,11,4,-66,-259,-323,-242,-112,-32,16,-45,-221,-220,5,94,-16,-95,-190,-279,-190,-95,-120,-75,-85,-155,-67,90,151,134,-7,-155,-178,-167,-170,-125,-186,-299,-235,-131,-44,77,47,-103,-122,-78,-67,-4,37}
        },
        {    // H10e015a.wav
            {0,-3,-2,4,-7,15,-13,20,-23,26,-34,28,-22,39,-11,2146,5540,-908,-2048,-175,-3642,2120,4530,4139,8496,6942,-929,-1973,1001,-3845,-8267,-4706,-1837,-3658,-2243,599,295,788,1754,1895,1560,1392,1313,779,368,713,301,-539,-578,-835,-1474,-1429,-1036,-1101,-722,16,-4,-381,-232,25,82,-29,-246,-477,-475,-428,-381,-384,-428,-305,-299,-399,-233,8,-61,-101,12,-16,-47,57,93,-12,-140,-229,-282,-239,-206,-169,-163,-194,-140,-46,-6,-19,-1,-45,-148,-138,-57,-48,-74,-118,-203,-243,-196,-189,-181,-150,-151,-117,-13,87,119,90,8,-60,-91,-135,-122,-98,-154,-177,-127,-96,-86,-56,-95,-138},
            {27,-39,62,-90,111,-154,190,-220,263,-126,6619,8832,-6916,-2422,-3615,-3802,9859,4672,9060,17341,2052,-10203,813,697,-13707,-11326,-1752,-3688,-6398,702,1419,-702,3592,4026,1621,1859,2996,1707,878,1001,698,-1009,-2111,-1580,-1637,-2923,-2757,-1172,-113,230,243,-813,-1656,-1080,-81,436,439,628,661,686,440,414,69,-408,-492,-778,-772,-249,-149,-426,-292,-166,-376,-313,40,100,-91,-174,-121,-56,93,103,20,-232,-426,-341,-141,-43,-11,-74,-245,-292,-71,66,-36,-59,-132,-242,-159,-29,-60,-60,-64,-145,-110,47,138,135,-16,-186,-218,-183,-175,-138,-174,-314,-288,-168,-65,68,89,-56,-110,-70,-61,-23,22,-36}
        },
        {    // H10e020a.wav
            {-1,0,-2,-1,3,-4,13,-11,18,-20,22,-27,25,-20,39,-6,1985,4943,-719,-1856,-85,-3158,1634,4338,3974,7423,6509,-301,-1951,831,-2918,-7491,-4497,-1447,-3324,-2346,523,257,274,1560,1961,1138,1246,1547,784,342,870,397,-571,-608,-813,-1125,-1027,-994,-1045,-585,-126,-362,-670,-422,-111,-50,-126,-110,-196,-389,-497,-364,-302,-423,-367,-331,-314,-144,-32,-84,-66,2,-52,-93,6,82,11,-101,-175,-208,-183,-193,-178,-167,-198,-186,-109,-47,-29,-16,-51,-134,-141,-50,-45,-83,-106,-171,-229,-194,-151,-125,-109,-133,-133,-53,53,94,52,-25,-68,-76,-109,-120,-98,-134,-158,-121,-108,-94,-53,-78},
            {-32,60,-82,85,-107,104,-94,95,-116,4248,11487,-3827,-5758,-2465,-5191,8182,5850,8244,18249,5790,-9550,-2282,1561,-11584,-13350,-4051,-2090,-6053,-1397,2181,-538,2551,4186,2131,1602,2974,2103,955,1390,1247,-999,-2547,-1312,-1284,-2872,-3081,-1914,-423,246,232,-735,-2118,-1491,410,963,254,518,794,795,467,282,241,-185,-400,-643,-810,-356,-22,-445,-477,-255,-391,-412,-82,173,-1,-203,-133,-9,136,180,83,-209,-397,-312,-174,-108,-55,-47,-268,-411,-224,-10,14,4,-57,-178,-135,28,-5,-52,-47,-113,-147,-11,125,143,0,-196,-233,-218,-204,-155,-137,-273,-322,-211,-92,72,127,-24,-136,-93,-40,-5,22,-31,-80}
        },
        {    // H10e025a.wav
            {-4,-1,0,-2,-1,4,-3,11,-9,14,-17,19,-22,21,-12,35,2,1708,4477,-471,-1714,108,-2887,1269,4123,3553,6587,6240,118,-1863,972,-2210,-6778,-4075,-1280,-3131,-2303,406,-56,-11,1592,1704,924,1265,1510,891,542,834,208,-456,-390,-585,-751,-881,-1202,-1080,-521,-470,-804,-938,-534,-152,-84,-30,64,12,-219,-460,-424,-292,-386,-415,-305,-237,-131,-71,-132,-123,-96,-115,-127,-16,118,96,-36,-115,-152,-171,-170,-165,-201,-258,-241,-144,-74,-47,-19,-64,-139,-133,-56,-42,-73,-84,-140,-182,-153,-142,-125,-107,-114,-134,-64,22,43,17,-61,-85,-91,-92,-92,-90,-109,-143,-119,-118,-95,-57},
            {22,-28,10,-2,-46,97,-147,152,1824,12027,1896,-8654,-3213,-5421,5792,6846,6987,19051,9771,-7728,-4312,890,-9469,-13535,-7281,-2765,-4253,-2619,1461,-103,2251,4204,2194,1738,2767,2316,1203,1493,1288,-1238,-2067,-801,-1369,-2317,-3099,-2855,-996,431,-63,-1415,-2191,-1057,616,888,472,607,860,778,412,191,245,-1,-264,-620,-772,-392,-67,-400,-529,-435,-461,-413,-86,250,93,-174,-158,11,113,121,16,-147,-277,-280,-248,-136,-20,-40,-276,-489,-391,-85,57,44,-23,-114,-96,11,6,-3,-7,-129,-174,-50,108,119,20,-157,-255,-255,-237,-176,-139,-240,-324,-246,-107,66,145,5,-128,-125,-84,-30,24,-11,-100,-120}
        },
        {    // H10e030a.wav
            {-5,-2,-1,-1,-2,-1,3,-4,9,-9,12,-13,11,-12,10,-6,29,-12,1390,4041,-155,-1559,229,-2632,921,3786,3141,5873,5966,497,-1620,1085,-1589,-5912,-3771,-1240,-2869,-2262,131,-306,54,1440,1292,876,1281,1621,1015,436,681,417,-85,-258,-311,-592,-1276,-1470,-946,-699,-970,-1089,-955,-504,-118,24,94,193,168,-90,-407,-406,-268,-340,-363,-300,-260,-203,-160,-203,-261,-186,-122,-78,50,154,125,9,-47,-108,-144,-186,-201,-236,-293,-255,-190,-107,-60,-40,-57,-138,-141,-53,-30,-47,-66,-112,-137,-121,-138,-137,-98,-113,-125,-87,-46,-28,-26,-62,-110,-95,-71,-54,-54,-107,-144,-137,-124,-104},
            {30,-66,92,-150,211,-271,331,229,9771,8316,-8075,-6152,-5122,3290,7184,5696,18391,13574,-4504,-5090,210,-7892,-13010,-9482,-4940,-3426,-3156,1015,295,1263,4547,2849,1406,2554,2648,1484,1398,457,-741,-1124,-805,-961,-1782,-3052,-3358,-1605,69,-597,-2204,-1943,-129,534,513,830,1113,904,504,374,211,188,0,-195,-597,-727,-374,-128,-224,-491,-538,-594,-426,17,273,165,-97,-69,-10,-6,19,26,-49,-236,-247,-202,-136,-49,-59,-249,-473,-442,-147,35,86,53,-71,-118,-27,65,59,20,-106,-182,-87,53,132,63,-102,-250,-286,-234,-162,-111,-201,-307,-276,-131,53,168,82,-89,-143,-115,-47,17,-7,-95,-122,-76}
        },
        {    // H10e035a.wav
            {-4,-1,-2,-1,0,-2,-1,2,-4,6,-8,9,-11,10,-6,-3,9,11,-5,1055,3598,255,-1435,304,-2312,532,3401,2793,5176,5654,942,-1317,1128,-949,-5042,-3578,-1240,-2582,-2239,-113,-277,-21,930,1178,1042,1208,1512,1023,589,856,733,95,-293,-403,-840,-1540,-1574,-1098,-997,-1139,-1131,-854,-368,-46,120,202,277,254,53,-292,-345,-221,-297,-389,-393,-360,-318,-262,-290,-318,-200,-66,-13,81,187,153,56,-16,-74,-143,-242,-247,-231,-286,-292,-207,-129,-79,-43,-68,-139,-130,-42,-36,-47,-35,-57,-99,-101,-102,-124,-133,-146,-154,-122,-96,-59,-40,-64,-94,-83,-39,-39,-54,-112,-149,-129,-116},
            {-75,103,-156,171,-206,245,-269,5825,12518,-3085,-9444,-6178,1340,7067,4304,16772,17047,-1392,-4588,354,-6744,-11889,-10450,-8201,-3567,-3065,-804,859,1316,3884,3373,2139,2298,2710,1899,928,-896,-32,225,-1169,-598,-1163,-2781,-3525,-2048,-669,-1648,-2589,-1368,274,312,432,1031,1504,1158,282,160,275,222,-105,-347,-521,-714,-550,-178,-62,-400,-587,-655,-417,10,219,251,105,-9,-97,-126,-73,6,-21,-224,-290,-231,-150,-105,-109,-176,-363,-442,-266,19,141,77,-88,-178,-90,28,92,42,-103,-204,-161,-30,116,122,-63,-258,-323,-258,-159,-119,-175,-268,-302,-226,-31,161,128,-40,-153,-169,-95,-8,-28,-120,-159,-108,-1}
        },
        {    // H10e040a.wav
            {-1,-2,-2,-2,-1,0,-2,0,2,-3,5,-7,6,-6,7,-1,-9,15,4,-1,737,3141,701,-1310,320,-1913,78,3010,2500,4483,5349,1426,-944,1096,-344,-4192,-3437,-1277,-2176,-2092,-405,-393,-217,755,1211,816,1038,1735,1358,835,996,694,-216,-494,-510,-1149,-1783,-1642,-1221,-1056,-1086,-1055,-710,-233,52,198,266,387,368,114,-170,-243,-256,-395,-473,-461,-479,-442,-317,-301,-306,-178,-23,62,116,197,182,61,-27,-91,-170,-260,-244,-228,-278,-278,-218,-150,-104,-72,-86,-127,-107,-49,-33,-21,9,-7,-67,-92,-117,-155,-172,-176,-172,-154,-109,-65,-40,-55,-72,-55,-56,-63,-56,-90,-131,-118},
            {14,-32,10,20,-55,35,1973,12631,4692,-9939,-9006,-1143,7188,3239,13407,20448,2423,-4589,1087,-4462,-11189,-9999,-10414,-6079,-2653,-2048,-87,735,4225,3986,2253,2633,3667,2120,-490,-1262,185,797,-738,-301,-953,-2438,-2962,-2466,-1810,-2605,-2484,-840,76,158,619,1211,1625,1409,382,64,205,170,-53,-487,-562,-745,-703,-224,-98,-334,-464,-541,-413,-64,211,360,274,68,-56,-183,-183,-29,7,-177,-359,-311,-270,-186,-29,-34,-255,-393,-271,-34,163,169,-36,-224,-175,-27,53,61,-42,-206,-235,-111,97,192,22,-209,-319,-289,-166,-88,-123,-227,-297,-278,-115,124,170,26,-136,-175,-118,-35,-24,-93,-153,-163,-57,73}
        },
        {    // H10e045a.wav
            {0,0,-3,0,0,0,1,1,0,1,-1,4,-4,4,2,3,3,-11,23,-7,11,469,2628,1143,-1130,288,-1473,-357,2581,2233,3810,5023,1959,-543,1000,191,-3338,-3238,-1183,-1755,-2196,-696,-306,-336,401,940,946,1399,2040,1612,722,562,380,-400,-717,-806,-1386,-1779,-1536,-1169,-982,-1009,-936,-523,-74,128,250,371,473,398,152,-120,-291,-335,-453,-570,-562,-541,-448,-321,-298,-252,-109,47,110,122,162,142,36,-56,-96,-161,-229,-235,-219,-237,-276,-238,-182,-138,-94,-87,-95,-80,-14,5,5,29,0,-62,-115,-138,-160,-167,-170,-187,-168,-116,-49,-22,-37,-59,-72,-71,-57,-37,-67,-105},
            {63,-130,191,-251,315,-107,8490,11889,-5576,-11994,-4999,6174,4242,7964,22255,8174,-4816,1334,-1569,-9934,-9172,-10588,-9433,-3099,-2952,-1375,-216,2870,4781,3297,2913,4079,3397,-1430,-1647,162,617,-33,-124,-631,-2150,-2495,-2678,-2799,-3451,-2325,-330,-235,-258,810,1630,1582,1372,735,185,123,63,-168,-425,-559,-874,-894,-347,-116,-328,-468,-364,-286,-113,123,441,430,188,32,-180,-259,-81,27,-170,-394,-438,-403,-264,-20,71,-83,-287,-273,-97,139,239,107,-180,-271,-137,-7,50,-33,-185,-286,-193,35,223,132,-134,-285,-297,-194,-65,-83,-178,-276,-312,-206,51,185,75,-72,-177,-153,-50,-17,-61,-118,-173,-138,5,91}
        },
        {    // H10e050a.wav
            {0,0,0,-1,-1,-1,-1,0,1,-2,-1,0,-1,-2,1,8,-7,9,-14,17,-6,23,255,2073,1528,-867,167,-990,-713,2072,1988,3227,4657,2423,-63,869,637,-2319,-2921,-1378,-1498,-1982,-857,-604,-693,418,1256,1319,1692,1868,1089,380,310,-27,-752,-883,-945,-1369,-1508,-1331,-1108,-895,-862,-736,-362,22,220,280,402,482,319,60,-138,-314,-459,-561,-596,-558,-521,-442,-317,-247,-138,-32,33,76,66,84,81,30,-42,-102,-141,-196,-213,-231,-260,-271,-253,-205,-163,-108,-63,-47,-40,-10,-2,-3,9,-20,-87,-115,-122,-151,-164,-189,-208,-175,-99,-44,-29,-41,-73,-70,-61,-52,-38,-59},
            {-47,49,-43,27,-89,2809,13753,3976,-12683,-9679,2569,6518,3523,19246,16327,-3702,-321,2054,-7525,-9358,-8826,-11542,-5588,-2744,-2900,-1512,681,4697,3693,3417,5255,4248,-1473,-1397,428,-321,325,211,-224,-2024,-2097,-2721,-4003,-3923,-2065,-309,-450,-270,613,1749,1840,1425,910,264,181,155,-321,-557,-472,-834,-1149,-595,-241,-297,-467,-334,-207,-93,137,400,576,395,115,-153,-285,-129,19,-193,-452,-510,-469,-403,-69,106,25,-139,-222,-173,33,306,252,-91,-280,-222,-121,-17,-22,-181,-339,-272,-55,194,209,-10,-220,-303,-246,-77,-27,-137,-250,-326,-294,-67,154,115,-22,-145,-172,-91,-19,-33,-85,-165,-189,-79,35,45}
        },
        {    // H10e055a.wav
            {1,1,2,1,0,1,0,0,2,1,-1,1,2,-1,1,2,10,-6,15,-16,14,7,31,102,1536,1772,-496,29,-538,-931,1476,1794,2708,4223,2841,488,913,1091,-1564,-2702,-1317,-1112,-2041,-1442,-645,-187,833,1435,1209,1103,1272,850,97,-260,-439,-769,-826,-868,-1106,-1236,-1188,-893,-695,-771,-590,-169,89,180,292,321,299,243,33,-237,-432,-489,-523,-533,-513,-482,-390,-239,-139,-102,-79,-24,14,1,28,72,30,-30,-75,-134,-191,-225,-226,-259,-262,-238,-208,-161,-96,-24,-28,-46,-20,-2,-24,-28,-16,-59,-94,-120,-163,-186,-179,-179,-168,-104,-53,-30,-43,-62,-52,-49,-59,-60},
            {-102,166,-232,274,-122,8367,13477,-6383,-14608,-3073,7044,3149,11284,22683,2514,-4025,4093,-2870,-9177,-7729,-10955,-9286,-2856,-3600,-2570,-1489,2296,4478,3359,5199,5324,549,-1447,383,-78,507,-74,-62,-1037,-2304,-2746,-4748,-4765,-2062,-210,-722,-283,661,1560,1969,1668,1222,385,37,207,-120,-559,-634,-808,-1163,-901,-487,-386,-481,-285,-170,-205,103,478,748,570,209,-58,-210,-242,-70,-129,-430,-563,-542,-482,-199,106,123,-67,-202,-167,-14,247,343,87,-229,-275,-198,-84,-32,-158,-352,-363,-179,104,253,126,-112,-259,-290,-156,3,-51,-181,-318,-367,-209,73,163,33,-111,-190,-130,-9,1,-55,-135,-211,-166,-20,40,8}
        },
        {    // H10e060a.wav
            {0,0,0,1,0,0,0,-1,-1,0,0,-1,0,0,-2,2,2,9,-8,15,-19,13,19,17,26,1037,1826,-11,-127,-188,-952,846,1552,2285,3812,3258,1271,835,1048,-640,-2035,-1617,-1381,-1819,-1089,-101,328,587,538,661,821,743,296,-267,-508,-518,-532,-565,-762,-922,-874,-805,-737,-665,-621,-423,-138,52,87,76,180,230,103,-107,-281,-408,-431,-413,-451,-459,-390,-281,-203,-164,-148,-145,-69,-39,-42,7,44,29,-20,-86,-157,-181,-201,-220,-239,-241,-220,-196,-151,-88,-46,-29,-34,-38,-35,-28,3,-12,-65,-110,-140,-162,-157,-158,-184,-163,-102,-54,-40,-38,-38,-56,-74,-93},
            {-41,88,-141,124,1521,13666,7502,-14636,-11126,3847,6234,3788,20363,14667,-5617,1570,2943,-6783,-8010,-8193,-11561,-5895,-2874,-3671,-2426,-810,3519,3406,4635,5526,1885,124,934,-89,458,1038,-478,-577,-1669,-2823,-5210,-5894,-2646,-355,-726,-511,686,1474,1960,1878,1627,817,-27,25,-34,-309,-508,-871,-1182,-1149,-772,-544,-550,-363,-168,-229,-39,465,832,839,456,50,-145,-288,-210,-112,-275,-509,-636,-561,-336,29,210,22,-202,-207,-47,180,366,249,-93,-266,-267,-164,-30,-74,-307,-441,-315,-57,210,256,42,-175,-296,-241,-25,27,-102,-257,-376,-319,-70,143,102,-41,-171,-192,-52,43,16,-77,-192,-241,-110,33,37,18}
        },
        {    // H10e065a.wav
            {0,0,0,0,0,1,0,-1,-2,-1,0,-2,-1,0,-2,0,0,4,4,-3,10,-17,20,19,1,-7,652,1700,476,-192,43,-805,204,1261,2080,3712,3477,1527,992,1371,-121,-1985,-1751,-682,-708,-639,-357,-451,-212,104,189,142,183,42,-281,-444,-290,-226,-504,-542,-430,-520,-645,-624,-564,-580,-390,-199,-179,-132,-36,57,53,14,-104,-230,-291,-312,-314,-371,-357,-288,-276,-246,-229,-200,-167,-113,-78,-74,-23,12,26,-29,-97,-132,-158,-178,-214,-218,-210,-199,-177,-159,-106,-51,-29,-45,-39,-22,-17,-20,-40,-70,-108,-122,-144,-153,-156,-164,-141,-102,-68,-44,-37,-69,-98,-106},
            {72,-97,112,-180,4883,16174,-1473,-18220,-4663,7733,3592,9532,22847,3176,-5198,5408,-364,-8154,-7191,-9178,-10007,-3953,-3731,-3488,-2459,797,3580,3582,4856,2729,1406,1297,868,886,1491,160,-328,-525,-2854,-5032,-6753,-4269,-1042,-672,-719,287,1480,1988,1963,1808,1601,450,-309,-157,-111,-275,-712,-1040,-1282,-1253,-773,-611,-516,-333,-210,-129,281,788,994,784,295,25,-279,-392,-168,-85,-365,-651,-634,-461,-149,187,174,-116,-264,-141,51,295,379,133,-205,-307,-227,-106,0,-161,-402,-446,-259,55,287,208,-49,-240,-300,-134,59,-1,-187,-335,-370,-210,44,125,25,-107,-208,-157,12,68,9,-95,-243,-226,-40,66,37,6}
        },
        {    // H10e070a.wav
            {0,-1,0,0,0,0,0,0,-1,-1,-1,0,-2,0,-2,-1,0,-1,5,-2,5,2,-6,18,6,-7,1,374,1425,912,-139,146,-557,-305,1190,2060,3181,3467,2279,1087,768,226,-743,-528,111,-701,-1686,-1268,-688,-855,-811,-382,-96,11,51,25,-193,-172,-64,-100,-115,-223,-349,-438,-545,-637,-630,-528,-429,-365,-302,-191,-50,34,50,-26,-100,-158,-223,-242,-264,-281,-298,-324,-322,-277,-212,-198,-159,-117,-98,-45,4,23,-23,-84,-120,-145,-174,-192,-179,-175,-187,-181,-161,-113,-66,-29,-19,-39,-46,-46,-32,-35,-60,-92,-124,-140,-138,-143,-144,-129,-107,-94,-90,-86,-96,-98},
            {158,-253,331,-237,8927,15236,-9941,-17619,1840,8323,2488,16314,18436,-4607,-1061,6358,-2943,-8651,-6933,-9394,-7979,-3451,-4147,-3788,-2308,2393,3901,3732,2594,1527,2469,1142,1208,1941,1682,125,8,-1177,-4483,-7123,-6201,-2266,-1176,-1166,-144,1139,1866,2101,1970,1882,1416,214,-470,-282,-44,-402,-847,-1096,-1432,-1321,-833,-612,-478,-414,-195,131,533,950,1095,640,149,-33,-330,-403,-89,-92,-494,-725,-558,-325,-11,260,83,-211,-265,-79,107,331,333,27,-254,-314,-188,-31,-7,-261,-453,-396,-180,160,307,118,-136,-274,-246,-51,72,-60,-231,-357,-345,-121,103,87,-45,-170,-230,-104,56,78,-7,-130,-252,-166,25,69,32,-29}
        },
        {    // H10e075a.wav
            {1,0,0,0,0,0,1,1,1,0,0,0,0,2,1,-2,2,1,1,4,-2,13,3,0,11,4,-2,18,212,1095,1148,96,258,-67,-419,575,1734,3308,3530,1853,921,1588,1991,1002,-446,-1257,-1572,-1884,-1864,-1701,-1588,-1111,-498,-80,189,314,224,-6,101,392,243,-41,-96,-142,-351,-672,-846,-787,-685,-643,-575,-404,-182,18,104,123,91,29,-68,-153,-160,-210,-309,-371,-378,-339,-282,-264,-243,-173,-121,-86,-43,9,22,-26,-84,-120,-129,-129,-137,-158,-165,-165,-168,-160,-124,-58,-24,-26,-51,-49,-29,-31,-26,-47,-84,-111,-129,-128,-128,-125,-141,-156,-141,-109,-83,-84},
            {173,-296,388,130,12338,12211,-15903,-14931,6814,7130,3426,20738,11393,-7703,2982,6285,-4684,-8985,-6544,-9195,-6524,-3326,-4369,-4406,-1738,3422,4311,2791,445,2402,2475,781,2271,2108,1454,857,555,-2735,-6410,-7252,-4503,-1999,-1798,-923,229,1606,1997,2052,2085,1914,1253,44,-461,-128,-153,-627,-789,-1180,-1655,-1315,-850,-587,-525,-485,-104,316,736,1044,1033,492,92,-84,-325,-286,-27,-176,-629,-681,-463,-247,89,267,22,-289,-256,-39,143,321,268,-54,-295,-271,-133,33,-57,-337,-453,-352,-67,226,280,27,-193,-283,-217,13,74,-89,-272,-356,-314,-66,124,46,-98,-232,-221,-50,87,70,-12,-144,-242,-97,71,75,7,-62}
        },
        {    // H10e080a.wav
            {1,1,1,-1,-1,0,0,0,2,1,0,0,0,-1,1,0,-4,3,0,1,4,-3,20,-2,1,3,-6,31,37,82,731,1283,715,796,-23,-1137,391,1803,2519,2884,2670,2949,3277,2228,111,-1411,-1758,-2059,-2868,-2742,-2033,-1708,-1100,-303,191,409,475,453,401,515,556,229,36,49,-143,-538,-893,-1021,-985,-909,-802,-572,-294,-61,94,169,220,197,106,-6,-109,-180,-287,-387,-396,-367,-374,-364,-292,-214,-150,-111,-80,-43,-18,-9,-60,-89,-67,-73,-105,-147,-150,-134,-151,-176,-179,-126,-72,-39,-21,-35,-38,-44,-40,-23,-41,-81,-123,-132,-137,-142,-158,-178,-170,-148,-122,-94},
            {142,-262,330,677,14471,9048,-19303,-12047,9959,5713,5110,22362,5232,-8215,6035,6294,-6054,-9013,-5893,-9139,-5732,-3058,-4762,-4956,-934,4131,3852,1095,454,3290,1571,1191,2790,1931,1416,1440,760,-4184,-7697,-6204,-3035,-2581,-2191,-599,486,1547,1885,2156,2136,1903,1157,-14,-335,109,-296,-805,-780,-1306,-1760,-1347,-773,-581,-635,-511,-48,416,865,1076,869,396,118,-78,-308,-179,38,-284,-718,-631,-378,-192,137,245,-57,-336,-255,-24,146,331,203,-154,-323,-224,-51,49,-111,-380,-436,-314,-5,279,239,-49,-256,-303,-180,72,81,-148,-307,-362,-272,-34,99,-5,-151,-264,-219,-9,109,71,-40,-177,-218,-38,94,54,-21,-112}
        },
        {    // H10e085a.wav
            {1,0,0,-1,-1,-1,-1,0,1,1,1,-1,0,-2,-1,-1,-2,-3,2,1,-1,3,-1,27,-5,-19,8,30,43,-20,3,647,1851,1307,489,-45,-1186,-682,750,3219,5152,4671,3151,1970,1165,-22,-1743,-3147,-3204,-2931,-2718,-2171,-1503,-687,-55,393,666,757,774,703,603,476,255,37,-57,-300,-741,-1159,-1274,-1127,-903,-696,-416,-141,25,176,251,299,256,138,-28,-197,-280,-346,-378,-398,-428,-420,-340,-228,-177,-136,-106,-87,-79,-73,-43,-25,-4,-31,-88,-123,-132,-122,-130,-158,-188,-183,-130,-69,-20,-6,-31,-57,-58,-39,-23,-57,-109,-133,-152,-166,-168,-162,-174,-182,-161,-130},
            {124,-237,289,958,15344,7269,-20867,-10226,11635,5012,6134,22314,1405,-8199,8271,6804,-7061,-8869,-5032,-9257,-5512,-2691,-5142,-5421,-202,4703,2534,-366,1546,3735,800,1766,2932,1538,1552,1922,356,-5391,-7541,-4786,-2746,-2977,-1910,-688,275,1499,1672,2108,2188,2013,1087,-92,-14,308,-417,-843,-798,-1462,-1821,-1274,-695,-617,-728,-495,-48,417,946,1031,758,353,191,-32,-272,-89,73,-338,-743,-570,-333,-136,170,197,-142,-359,-217,-23,136,354,167,-232,-331,-176,3,78,-116,-387,-439,-272,52,304,206,-113,-270,-284,-118,101,62,-180,-317,-350,-252,-1,88,-41,-191,-275,-191,36,145,68,-63,-188,-179,8,103,38,-44,-120}
        },
        {    // H10e090a.wav
            {1,2,1,0,2,0,-1,1,2,1,4,2,2,1,-1,1,1,0,2,4,1,3,4,15,23,-24,1,52,15,-8,60,525,952,1400,1549,1197,-1030,-3249,-711,3912,6434,5057,2565,1943,1915,803,-1339,-3091,-3630,-3007,-2677,-2616,-1839,-1008,-365,180,770,986,867,872,764,610,324,53,-55,-133,-576,-1164,-1339,-1203,-978,-747,-516,-234,-17,128,241,312,334,215,38,-152,-266,-311,-362,-400,-423,-409,-339,-257,-195,-157,-123,-132,-147,-97,-40,16,34,6,-56,-108,-111,-121,-113,-116,-152,-181,-170,-92,-33,-8,-13,-41,-57,-58,-54,-64,-77,-108,-147,-178,-176,-155,-154,-171,-185,-154},
            {137,-263,329,763,15144,7386,-21123,-9929,12166,5181,6019,21556,50,-8577,9726,7947,-7465,-8894,-4091,-9212,-5906,-2422,-5333,-5849,138,5129,1165,-1332,2624,3548,765,2349,2634,1285,1657,2114,-144,-6210,-6853,-3433,-2864,-3133,-1536,-800,-135,1175,1580,1923,2114,2206,1049,-131,287,462,-469,-746,-855,-1561,-1889,-1221,-587,-699,-800,-495,-64,339,932,982,687,346,262,19,-241,-11,77,-388,-698,-518,-318,-133,160,149,-221,-388,-190,-10,109,346,147,-247,-349,-162,23,90,-87,-388,-454,-264,77,284,167,-124,-256,-249,-109,92,37,-200,-323,-361,-235,2,81,-73,-235,-277,-165,55,126,67,-56,-195,-189,0,100,23,-52,-129}
        },
        {    // H10e095a.wav
            {1,1,0,0,0,0,-1,-1,1,0,1,1,0,2,-2,-1,-1,-1,2,-3,4,-1,6,7,4,14,-3,20,15,34,445,779,130,484,2019,1902,-605,-3392,-599,4569,5197,3698,2791,2258,1706,887,-1003,-2376,-2838,-3141,-2830,-2411,-1929,-1392,-727,48,656,880,872,922,879,664,343,70,-68,-166,-506,-1017,-1198,-1102,-989,-809,-543,-312,-98,68,171,268,287,202,48,-81,-207,-319,-351,-376,-386,-350,-309,-286,-225,-173,-182,-193,-149,-82,-46,-21,19,21,-37,-91,-122,-119,-97,-80,-115,-159,-150,-118,-75,-51,-34,-21,-65,-95,-94,-78,-65,-99,-147,-190,-181,-154,-160,-169,-166,-132},
            {180,-327,432,188,13797,9388,-20041,-11338,11739,6189,4876,20284,1089,-9532,10042,9931,-6922,-9379,-3252,-8658,-6763,-2412,-5268,-6234,-84,5264,469,-1857,2992,3282,1038,2696,2605,1001,1646,2172,-531,-6329,-6345,-2714,-2685,-2893,-1540,-930,-285,743,1279,1783,2025,2235,1128,-55,431,567,-337,-621,-885,-1567,-1908,-1233,-558,-719,-826,-536,-96,262,837,935,688,338,312,97,-190,15,100,-365,-656,-475,-313,-150,101,129,-248,-415,-199,-3,112,321,157,-214,-332,-156,23,90,-59,-352,-461,-287,46,272,192,-100,-231,-235,-107,77,33,-205,-334,-349,-224,5,71,-71,-226,-279,-176,45,146,84,-54,-198,-217,-24,113,38,-61,-129}
        },
        {    // H10e100a.wav
            {1,1,0,0,0,0,0,-1,1,0,0,0,1,1,0,0,-2,1,4,-3,0,3,8,8,-8,24,26,-5,9,406,909,353,-143,615,1153,1031,-12,-766,1426,3276,2869,2524,2574,2246,1184,215,-532,-1383,-1984,-2407,-2690,-2295,-1696,-1497,-944,-176,331,594,755,918,800,573,401,149,-173,-301,-496,-756,-898,-947,-866,-759,-550,-344,-182,-15,94,155,158,126,44,-66,-174,-250,-308,-351,-312,-287,-270,-252,-242,-233,-237,-175,-95,-69,-72,-64,-30,-7,-32,-87,-116,-99,-67,-54,-83,-104,-102,-111,-113,-100,-64,-58,-79,-92,-90,-77,-87,-116,-162,-174,-163,-171,-160,-143,-109,-95},
            {208,-365,494,-386,11117,12529,-17015,-14320,10166,7926,3283,18148,4222,-10473,8597,12564,-4960,-10364,-2937,-7400,-7861,-2787,-4984,-6515,-907,4991,687,-2090,2676,3156,1381,2623,2741,1087,1343,2075,-478,-5988,-6234,-2574,-2354,-2523,-1583,-1039,-419,461,1006,1496,1903,2179,1232,70,423,662,-135,-527,-867,-1489,-1873,-1323,-608,-739,-800,-581,-143,181,718,888,701,335,296,199,-131,-12,116,-263,-634,-504,-326,-194,26,110,-227,-442,-241,-24,101,310,197,-160,-312,-152,6,69,-48,-332,-475,-332,12,253,220,-68,-217,-230,-118,61,27,-191,-334,-350,-242,-13,87,-56,-233,-318,-199,42,160,81,-96,-219,-222,-29,94,25,-69,-114}
        },
        {    // H10e105a.wav
            {1,0,2,0,0,0,0,0,-1,-1,-1,-1,0,0,-2,3,-1,-1,2,-1,1,-2,11,0,0,12,30,5,280,1045,631,-262,246,727,240,-141,1001,2721,2490,1511,1517,1678,1581,1172,544,-27,-429,-594,-1061,-1659,-1746,-1821,-1749,-1223,-832,-544,-138,259,584,665,589,440,341,127,-220,-428,-463,-486,-621,-688,-689,-594,-468,-390,-237,-117,-43,-9,6,29,-47,-104,-124,-171,-236,-278,-267,-255,-210,-217,-277,-271,-190,-105,-95,-90,-100,-111,-84,-87,-75,-96,-84,-52,-59,-42,-44,-51,-77,-100,-120,-154,-142,-107,-72,-70,-80,-88,-131,-157,-172,-175,-169,-161,-125,-104,-89,-78},
            {170,-278,369,-524,7036,15354,-10690,-18099,6450,10207,2023,14362,8958,-9984,4783,14917,-873,-11183,-3846,-5212,-8754,-3849,-4379,-6613,-2298,4040,1643,-1940,1760,3165,1766,2253,2847,1441,1072,1854,-33,-5014,-6423,-2941,-2000,-2300,-1618,-1014,-553,159,854,1266,1636,2045,1408,250,336,735,139,-475,-756,-1333,-1764,-1456,-725,-726,-797,-612,-204,129,556,855,717,355,255,287,-6,-43,127,-124,-568,-576,-378,-239,-66,98,-165,-440,-314,-55,77,289,288,-70,-282,-165,18,49,-53,-321,-481,-345,-17,217,206,-18,-187,-218,-129,34,50,-145,-316,-355,-260,-19,101,-55,-255,-291,-187,7,130,54,-112,-198,-204,-64,62,34,-50,-100}
        },
        {    // H10e110a.wav
            {0,0,0,0,1,1,1,0,-1,-1,-1,-1,0,0,0,1,-1,1,-2,3,2,-1,6,5,4,12,15,206,1106,948,-290,-20,578,128,-335,852,2902,2959,1929,1573,1105,570,280,-174,-328,-67,-88,-411,-519,-484,-826,-1191,-1170,-956,-864,-719,-426,-114,183,317,340,224,99,-16,-246,-364,-353,-321,-375,-417,-412,-404,-350,-334,-287,-264,-216,-156,-141,-153,-138,-85,-116,-116,-148,-211,-211,-199,-211,-250,-217,-149,-117,-97,-106,-122,-133,-147,-144,-157,-136,-86,-46,-27,-36,-14,-8,-18,-56,-109,-146,-184,-162,-119,-78,-62,-79,-116,-164,-178,-191,-187,-152,-113,-89,-86,-63,-57},
            {31,-31,0,-76,2703,15303,-1185,-19960,-220,11944,2548,8652,13200,-6272,-729,15125,5115,-10214,-6441,-2918,-8358,-5863,-3814,-6152,-3954,2221,2619,-1021,544,2885,2355,1845,2632,2014,884,1510,583,-3521,-6321,-3868,-1853,-2095,-1809,-997,-600,-100,695,1105,1405,1783,1557,529,244,676,442,-394,-686,-1070,-1618,-1556,-910,-695,-807,-668,-290,94,414,742,744,407,212,318,157,-17,78,1,-465,-637,-462,-311,-174,39,-76,-395,-384,-114,69,237,340,66,-218,-191,1,35,-62,-292,-450,-360,-92,147,178,19,-155,-193,-135,7,66,-90,-277,-327,-262,-87,33,-30,-179,-251,-216,-77,52,35,-63,-161,-226,-132,56,70,-48,-113}
        },
        {    // H10e115a.wav
            {1,1,2,2,2,3,1,2,1,1,1,1,1,1,4,3,3,3,3,6,0,7,3,16,0,25,126,1092,1345,-235,-336,502,112,-452,936,3293,2861,1409,1665,1619,735,-107,-1047,-1254,-683,-386,-166,-101,17,228,-50,-289,-349,-636,-868,-774,-554,-429,-310,-81,12,-121,-198,-251,-243,-172,-207,-200,-155,-138,-157,-202,-215,-248,-323,-404,-373,-346,-331,-219,-165,-135,-113,-97,-102,-132,-157,-218,-231,-155,-69,-51,-72,-110,-134,-152,-186,-193,-197,-184,-135,-87,-53,-26,-1,26,11,-25,-76,-149,-158,-131,-126,-136,-112,-78,-97,-146,-189,-194,-190,-157,-119,-100,-73,-57,-37,-43},
            {-113,199,-315,386,-35,11008,8649,-16309,-9089,10734,5907,2572,13629,1385,-5348,11535,11175,-5800,-9698,-2383,-5961,-7956,-4321,-4961,-5161,-367,2735,511,-129,1939,2878,1919,2014,2470,1066,990,907,-1733,-5376,-4889,-2341,-1853,-1961,-1250,-578,-296,528,985,1226,1532,1590,896,257,463,616,-122,-700,-861,-1342,-1600,-1108,-699,-790,-730,-407,25,297,595,708,514,234,303,291,70,18,29,-311,-664,-560,-392,-278,-87,-29,-293,-403,-173,50,177,312,199,-86,-203,-72,7,-39,-213,-395,-384,-210,33,134,59,-116,-164,-123,-31,62,-15,-195,-299,-303,-199,-9,41,-113,-254,-275,-169,-4,42,-44,-150,-207,-164,1,64,-40,-121}
        },
        {    // H10e120a.wav
            {0,0,1,1,1,1,0,-1,-1,-1,-1,1,-1,-1,2,0,1,0,6,-4,1,-1,21,-6,21,77,1038,1669,-54,-639,365,122,-533,1036,3664,3102,1298,1455,1255,435,191,-720,-1659,-1453,-971,-737,-490,186,645,429,544,687,200,-301,-525,-681,-770,-707,-575,-522,-506,-481,-502,-425,-204,-70,-69,-31,59,94,33,-33,-87,-220,-349,-480,-599,-508,-334,-251,-239,-213,-148,-82,-66,-139,-196,-169,-88,-41,0,-3,-63,-120,-176,-208,-227,-225,-210,-173,-121,-104,-82,-35,31,46,-22,-97,-132,-119,-102,-102,-120,-151,-134,-121,-156,-184,-185,-177,-159,-129,-118,-96,-56,-44,-47,-32},
            {-88,134,-181,195,-324,4465,13429,-5729,-15826,4108,10264,192,7913,10012,-4806,4286,14193,1923,-10516,-5054,-2649,-8288,-6302,-3973,-5107,-3165,1492,1866,78,1014,2638,2565,1494,2390,1711,572,760,-416,-3466,-5135,-3345,-2047,-1912,-1606,-743,-406,207,959,1108,1331,1517,1247,488,251,556,212,-565,-830,-1071,-1442,-1273,-772,-752,-741,-534,-100,173,405,651,608,376,276,382,184,-10,-8,-185,-588,-670,-466,-356,-244,-73,-170,-332,-220,28,138,232,268,61,-144,-137,-29,-9,-102,-311,-414,-321,-105,67,87,-43,-135,-108,-46,54,53,-117,-304,-311,-186,-48,12,-97,-254,-294,-198,-54,1,-30,-95,-149,-184,-102,14,-15,-92}
        },
        {    // H10e125a.wav
            {0,3,2,2,2,1,-1,1,0,1,1,0,1,1,0,3,1,6,-1,6,-9,21,0,28,39,966,1986,191,-950,191,193,-641,1118,4129,3334,1226,1538,1338,-10,-434,-925,-1539,-1261,-1031,-1280,-1052,-203,321,480,936,1184,876,541,258,-142,-557,-809,-864,-861,-915,-929,-870,-732,-435,-203,-88,61,212,243,211,220,118,-51,-228,-456,-582,-555,-466,-368,-335,-330,-246,-135,-115,-164,-134,-42,-39,-20,39,48,1,-84,-154,-212,-230,-210,-206,-200,-158,-114,-111,-66,6,22,-38,-105,-126,-94,-53,-56,-105,-133,-131,-143,-181,-198,-162,-142,-142,-129,-108,-92,-72,-46,-45,-31,13},
            {54,-104,158,-239,292,209,10043,6725,-14031,-6466,10361,4014,-190,12128,3339,-2522,11365,9775,-6019,-9193,-1642,-5555,-8562,-4466,-4000,-4924,-1164,2415,703,503,2157,2736,1834,1688,2368,739,302,86,-1592,-4008,-4076,-2707,-2132,-1713,-1139,-528,-193,722,1158,1175,1389,1415,861,285,364,403,-299,-794,-935,-1169,-1304,-934,-692,-724,-589,-291,58,183,479,682,561,320,368,331,23,-97,-120,-438,-714,-587,-388,-366,-196,-77,-226,-250,-35,149,156,233,155,-46,-127,-53,6,-43,-205,-398,-395,-221,-34,55,15,-73,-67,-33,5,6,-69,-172,-220,-203,-155,-97,-105,-201,-254,-233,-132,-13,17,-53,-147,-197,-173,-52,-7,-50}
        },
        {    // H10e130a.wav
            {0,0,1,0,-1,-1,-2,-1,-1,-1,-2,-2,0,-3,1,-4,5,-7,5,-10,13,-1,22,31,880,2254,506,-1235,-68,253,-688,1153,4612,3615,1148,1649,1527,-235,-839,-1199,-2104,-1693,-773,-968,-1185,-521,73,88,501,1262,1311,873,759,616,98,-373,-630,-936,-1214,-1248,-1198,-1097,-810,-476,-282,-59,199,321,319,328,342,176,-183,-395,-439,-467,-399,-414,-508,-463,-296,-240,-276,-220,-63,-3,-16,23,48,68,15,-61,-129,-205,-200,-177,-188,-201,-188,-169,-129,-48,-13,-29,-85,-142,-138,-100,-50,-38,-71,-119,-151,-145,-170,-190,-172,-140,-133,-136,-100,-82,-75,-59,-54,-34,3,38},
            {47,-70,82,-92,88,-167,3062,11559,-2488,-13469,2785,9270,-2066,4317,12347,-1066,3159,13106,2666,-9656,-5006,-1764,-8291,-6918,-3145,-4804,-4175,1199,1841,-116,1808,2683,2204,1495,2181,1549,24,68,-620,-2269,-3717,-3246,-2683,-1976,-1379,-873,-487,202,1119,1144,1201,1442,1178,536,311,426,-21,-678,-839,-949,-1151,-1121,-713,-640,-611,-420,-104,79,225,560,679,467,339,375,154,-131,-155,-271,-633,-696,-486,-367,-334,-110,-98,-236,-131,104,162,155,171,36,-73,-38,8,-44,-140,-294,-381,-315,-156,-21,52,15,-37,-56,-74,-21,34,-36,-168,-250,-261,-202,-128,-147,-220,-218,-142,-28,3,-57,-145,-195,-186,-103,-8,-15}
        },
        {    // H10e135a.wav
            {1,2,1,0,-1,-1,-1,0,0,-1,-2,1,-2,3,-3,4,-5,5,-11,12,1,24,17,808,2502,860,-1466,-380,312,-722,1187,5129,3897,1032,1787,1837,-355,-1249,-1465,-2369,-2085,-1147,-1156,-1135,-240,326,-51,173,901,998,891,1050,922,473,220,-49,-498,-1012,-1351,-1467,-1349,-1023,-793,-591,-271,41,227,273,376,445,229,-78,-216,-320,-329,-278,-363,-503,-534,-418,-363,-345,-213,-83,-42,-18,15,79,49,-8,-39,-134,-195,-180,-123,-148,-189,-190,-188,-152,-73,5,-48,-136,-158,-144,-121,-99,-56,-69,-123,-150,-159,-151,-154,-137,-140,-158,-146,-108,-71,-71,-59,-44,-36,-21,-1,0},
            {-50,75,-113,140,-200,242,-171,6392,8742,-8587,-7989,7714,3716,-3734,10028,9293,-1880,8215,10439,-3619,-8736,-1866,-4297,-9030,-4490,-3313,-5701,-1943,2351,278,451,2824,2522,1724,1665,2163,462,-301,-149,-1065,-2577,-3213,-2899,-2543,-1703,-1180,-783,-356,703,1211,976,1231,1431,896,401,405,223,-433,-772,-783,-951,-1114,-897,-626,-583,-440,-251,9,108,277,541,580,381,322,257,-37,-217,-203,-419,-675,-615,-429,-369,-253,-53,-132,-183,-26,134,120,123,103,-22,-44,12,-24,-115,-208,-302,-332,-241,-100,3,18,-49,-52,-20,14,28,-27,-159,-268,-301,-274,-210,-150,-131,-143,-138,-106,-70,-82,-127,-163,-164,-124,-40,1}
        },
        {    // H10e140a.wav
            {1,1,0,-1,-1,-1,0,0,-1,-2,1,-2,1,-2,5,-7,6,-9,3,3,21,20,721,2733,1252,-1687,-721,346,-710,1177,5674,4278,837,1860,2188,-337,-1594,-1759,-2696,-2455,-1250,-1261,-1562,-535,647,444,331,765,773,563,705,900,671,405,263,24,-513,-996,-1313,-1434,-1236,-926,-710,-529,-217,48,181,293,261,154,51,-114,-183,-169,-176,-277,-417,-501,-498,-429,-287,-179,-134,-80,-65,-11,35,15,-13,-70,-131,-190,-164,-100,-107,-170,-182,-154,-147,-76,-23,-60,-137,-159,-143,-137,-107,-96,-116,-142,-169,-168,-138,-109,-101,-119,-160,-167,-105,-53,-53,-62,-52,-32,-12,-23,-62,-105},
            {-3,-16,26,-55,76,-126,132,651,8414,4204,-10272,-1852,7484,-1792,-822,13451,5401,54,10549,5566,-6627,-5812,-1367,-6884,-7705,-2931,-4753,-5028,440,1594,-480,1626,3086,2229,1541,1810,1589,-229,-429,-273,-1314,-2711,-2830,-2589,-2269,-1622,-1005,-588,-129,932,1082,864,1257,1285,743,417,303,-52,-593,-719,-699,-941,-1063,-740,-532,-479,-269,-48,59,74,292,493,409,262,258,100,-152,-220,-223,-464,-623,-513,-423,-375,-151,-14,-135,-103,48,65,37,106,86,-20,-12,1,-90,-154,-194,-241,-249,-192,-128,-48,29,48,46,11,-31,-78,-172,-265,-300,-289,-232,-145,-80,-97,-131,-142,-135,-115,-110,-96,-92,-95,-83,-39}
        },
        {    // H10e145a.wav
            {1,0,-1,-2,-2,0,1,-1,-2,1,-2,2,-6,5,-6,1,-4,0,2,13,30,653,2944,1661,-1891,-1102,372,-663,1213,6199,4667,666,1889,2492,-315,-1833,-1993,-3031,-2876,-1400,-1280,-1731,-757,455,480,642,1139,914,454,500,597,297,256,423,204,-275,-595,-886,-1127,-1102,-915,-762,-610,-356,-128,23,54,79,71,-95,-124,-66,-88,-117,-167,-328,-499,-433,-253,-203,-219,-129,-76,-77,-74,-45,-19,-59,-87,-154,-219,-174,-73,-84,-149,-154,-148,-116,-38,1,-84,-145,-134,-135,-141,-122,-107,-126,-176,-203,-186,-140,-76,-53,-112,-176,-147,-67,-20,-26,-56,-60,-41,-26,-40,-90,-140,-177},
            {19,-31,24,-24,10,-8,-10,-23,1870,8799,185,-8733,1993,4157,-4217,3733,13863,2742,2776,9825,1321,-6593,-3503,-2658,-8020,-5592,-3139,-5684,-2982,1225,389,-109,2466,2927,1947,1535,1693,869,-468,-302,-503,-1596,-2558,-2517,-2401,-2070,-1452,-754,-407,52,858,917,877,1154,1113,711,394,121,-250,-570,-566,-671,-964,-948,-569,-446,-324,-117,20,21,25,278,387,227,117,150,17,-168,-204,-240,-443,-504,-426,-423,-375,-108,9,-83,-55,2,-33,-12,114,102,-7,-35,-59,-107,-107,-158,-237,-259,-173,-53,45,100,84,21,-92,-190,-221,-239,-238,-232,-226,-191,-121,-86,-114,-137,-163,-141,-92,-48,-30,-58,-93,-86}
        },
        {    // H10e150a.wav
            {0,-1,-1,-1,0,1,-1,-3,1,-2,4,-3,4,-4,1,-3,0,5,2,36,595,3156,2075,-2074,-1500,370,-606,1275,6779,5056,437,1943,2820,-343,-2084,-2161,-3309,-3318,-1598,-1261,-1904,-925,439,504,640,1162,1135,733,607,549,70,-144,65,78,-202,-497,-707,-780,-713,-564,-523,-582,-400,-119,-204,-194,12,-63,-236,-279,-184,-117,-80,-144,-367,-429,-199,-88,-146,-128,-62,-68,-151,-118,-31,-62,-129,-129,-187,-258,-199,-111,-99,-128,-129,-122,-105,-17,17,-59,-120,-121,-132,-157,-133,-100,-125,-187,-236,-235,-143,-40,-55,-149,-177,-100,-14,2,-19,-45,-59,-51,-61,-91,-113,-146,-195,-216},
            {-14,31,-48,49,-63,64,-81,86,-108,3046,8045,-2243,-6035,2796,737,-3715,7390,12625,1815,4469,7506,-830,-5357,-2643,-4287,-7556,-4245,-4262,-5039,-1355,764,-87,633,2766,2611,1778,1498,1426,206,-251,-81,-982,-1734,-2250,-2308,-2338,-1881,-1129,-568,-301,260,661,668,879,1097,987,610,288,41,-310,-494,-452,-656,-883,-764,-451,-335,-221,-107,-14,-52,-5,184,258,139,47,81,-55,-207,-172,-182,-374,-417,-357,-393,-339,-124,-25,-42,-44,-54,-93,0,114,81,10,-41,-106,-133,-103,-132,-190,-178,-84,28,104,90,-1,-132,-245,-263,-203,-156,-170,-221,-239,-196,-127,-103,-122,-137,-119,-75,-45,-29,-27,-41,-64}
        },
        {    // H10e155a.wav
            {-1,-1,-1,0,0,1,-3,1,-1,3,-3,6,-6,-1,2,-5,13,-8,41,538,3365,2507,-2254,-1911,350,-550,1333,7399,5503,194,1950,3139,-340,-2349,-2341,-3564,-3732,-1866,-1205,-1991,-1103,432,467,787,1337,1051,634,802,855,130,-321,-161,-233,-658,-654,-668,-744,-480,-150,-82,-242,-169,-217,-268,-83,-83,-277,-406,-353,-314,-300,-248,-274,-316,-257,-112,-39,-2,30,17,-49,-119,-95,-64,-98,-139,-168,-217,-288,-263,-140,-126,-157,-138,-97,-66,-13,25,-23,-83,-99,-118,-149,-119,-84,-117,-188,-252,-248,-162,-78,-64,-134,-155,-51,46,34,-20,-47,-73,-84,-92,-111,-128,-153,-201,-228,-188},
            {12,-14,29,-47,54,-76,90,-120,145,-93,3900,6837,-2980,-3982,1682,-1080,-1995,9362,11217,1871,4575,5358,-1227,-4274,-2890,-5181,-6396,-4206,-4788,-3680,-845,217,29,1212,2614,2356,1798,1258,965,100,91,-212,-1183,-1758,-2084,-2121,-2256,-1718,-920,-347,-96,326,426,401,843,1106,885,389,164,65,-283,-392,-354,-581,-758,-592,-397,-313,-208,-179,-114,-135,-41,102,171,131,54,11,-137,-207,-128,-152,-303,-342,-335,-367,-288,-126,-70,-64,-71,-101,-91,36,100,26,-37,-75,-118,-107,-72,-80,-101,-103,-56,12,58,-1,-115,-208,-249,-213,-164,-156,-187,-230,-264,-233,-142,-96,-84,-83,-84,-70,-41,-2,7,-15}
        },
        {    // H10e160a.wav
            {-3,-2,-1,0,0,-4,0,-2,3,-4,3,-5,-6,2,-12,18,-18,50,479,3576,2938,-2432,-2324,306,-503,1387,8033,5988,-49,1962,3427,-396,-2593,-2458,-3838,-4171,-2152,-1244,-2012,-1213,485,406,759,1582,1193,587,644,848,330,-162,-185,-372,-960,-1123,-1027,-867,-439,-47,246,205,5,47,71,-41,-94,-292,-568,-573,-414,-444,-518,-389,-261,-299,-159,55,108,81,37,30,-30,-49,-27,-72,-177,-203,-241,-343,-296,-181,-174,-209,-167,-97,-81,-26,28,-10,-67,-93,-106,-117,-76,-58,-121,-209,-263,-244,-190,-143,-131,-140,-100,-6,71,79,17,-69,-139,-165,-142,-122,-144,-179,-208,-220,-184,-128},
            {1,7,-6,18,-35,43,-66,87,-120,151,11,4355,5781,-2753,-3231,317,-1405,-435,10157,10294,1922,3716,4227,-859,-3857,-3448,-5105,-5639,-4725,-4350,-2609,-960,-32,379,1420,2354,2287,1740,878,639,460,93,-479,-1023,-1672,-2010,-2149,-2105,-1469,-778,-201,152,313,186,307,787,1044,710,263,60,40,-89,-239,-287,-478,-650,-579,-386,-326,-298,-247,-187,-172,-87,83,196,104,70,33,-142,-230,-131,-127,-278,-309,-317,-323,-231,-76,-66,-152,-145,-84,-43,9,57,36,-49,-94,-92,-56,-22,-29,-64,-112,-97,-37,23,-10,-108,-202,-235,-184,-160,-181,-214,-261,-276,-216,-119,-63,-42,-47,-68,-48,-3,40,39}
        },
        {    // H10e165a.wav
            {-3,0,-1,-1,-4,-1,-2,3,-2,2,-3,-8,6,-16,23,-31,63,423,3756,3411,-2587,-2748,266,-473,1417,8647,6553,-272,1943,3727,-454,-2862,-2559,-3989,-4623,-2492,-1299,-2075,-1337,603,519,639,1694,1401,586,651,866,208,-195,-25,-249,-1084,-1422,-1340,-1191,-652,-68,225,207,418,513,307,248,143,-252,-620,-618,-628,-721,-491,-297,-461,-523,-182,108,109,48,75,96,17,23,74,-13,-135,-181,-259,-361,-337,-224,-220,-230,-177,-136,-117,-55,30,-11,-71,-71,-68,-70,-46,-23,-88,-181,-260,-288,-201,-128,-135,-165,-132,-11,130,171,63,-78,-181,-214,-194,-164,-165,-196,-215,-205,-157,-101,-81},
            {-1,3,3,-1,6,-23,25,-47,63,-93,115,157,4458,5155,-2357,-3415,-418,-1060,518,10409,9764,1548,2744,3987,-487,-3955,-3673,-4614,-5587,-4912,-3475,-2127,-1223,-28,686,1346,2202,2231,1467,660,681,544,-53,-565,-806,-1420,-2116,-2229,-1875,-1240,-684,-124,239,275,196,289,641,865,556,200,80,61,-18,-75,-203,-475,-705,-640,-423,-358,-344,-315,-219,-162,-71,111,205,109,71,32,-131,-225,-168,-172,-265,-296,-289,-297,-206,-52,-69,-177,-204,-139,-36,64,80,0,-83,-102,-84,-27,-2,-46,-107,-139,-117,-46,17,-8,-85,-164,-215,-220,-213,-209,-240,-284,-276,-202,-93,-24,-13,-51,-73,-31,26,67}
        },
        {    // H10e170a.wav
            {-3,0,-1,-5,-1,-2,3,-2,2,-3,-12,9,-22,28,-42,70,391,3921,3860,-2702,-3179,232,-467,1446,9252,7128,-413,1915,3998,-570,-3134,-2651,-4125,-5002,-2882,-1370,-2095,-1527,618,738,705,1723,1546,626,592,939,279,-312,-189,-216,-989,-1518,-1570,-1360,-769,-417,-106,324,559,635,632,593,398,-48,-488,-667,-668,-652,-530,-497,-536,-527,-319,-86,3,86,79,34,46,114,156,72,-84,-132,-202,-349,-378,-254,-204,-252,-235,-183,-157,-107,-18,-8,-49,-47,-46,-49,-25,-5,-61,-177,-245,-242,-175,-125,-153,-191,-153,-21,121,179,101,-46,-170,-245,-255,-214,-187,-204,-236,-220,-161,-82,-38,-59},
            {-1,0,5,1,4,1,-15,15,-31,44,-65,81,281,4375,4904,-2220,-3827,-500,-697,994,10463,9346,925,2103,4161,-382,-4144,-3446,-4317,-5741,-4604,-2761,-1973,-1433,132,846,1142,2159,2169,1118,613,891,350,-176,-459,-668,-1217,-2071,-2176,-1795,-1138,-510,-62,169,247,313,396,498,583,578,248,29,104,6,-100,-259,-501,-762,-727,-469,-361,-360,-269,-129,-146,-47,179,235,99,57,1,-157,-211,-132,-180,-309,-303,-286,-290,-202,-73,-62,-129,-146,-109,-66,29,77,9,-93,-124,-87,-30,-11,-56,-138,-176,-129,-18,55,41,-45,-165,-238,-244,-223,-235,-265,-280,-257,-171,-60,5,-16,-62,-53,-4,48}
        },
        {    // H10e175a.wav
            {0,0,-5,-1,-1,3,0,2,-1,-13,13,-24,33,-45,70,372,4041,4265,-2688,-3585,148,-447,1406,9753,7739,-401,1861,4244,-661,-3451,-2721,-4209,-5309,-3336,-1537,-2001,-1641,462,844,906,1817,1654,740,489,948,396,-356,-296,-293,-1039,-1618,-1639,-1426,-945,-575,-172,153,430,674,726,744,645,185,-305,-487,-423,-501,-600,-551,-599,-648,-473,-210,-76,-41,-11,24,33,109,227,165,-21,-55,-128,-319,-379,-245,-207,-269,-242,-228,-248,-159,-19,-16,-65,-38,-20,-38,-6,18,-73,-192,-198,-158,-128,-111,-135,-195,-188,-45,103,148,92,-16,-151,-252,-269,-244,-219,-224,-243,-225,-154,-67,-29,-34,-56},
            {-4,-1,-1,5,0,3,-1,-14,11,-24,34,-51,66,347,4253,4769,-2351,-4013,-276,-507,1235,10355,8880,308,1827,4363,-506,-4103,-3105,-4262,-5714,-4171,-2258,-1942,-1527,301,792,1025,2181,1972,879,649,901,342,-298,-450,-421,-1183,-1850,-2022,-1857,-1051,-340,-40,-10,243,443,498,564,581,438,198,80,-24,-167,-242,-330,-614,-819,-670,-486,-363,-238,-123,-86,-120,15,226,229,72,24,-20,-177,-241,-144,-171,-322,-354,-319,-301,-166,-24,-37,-105,-92,-62,-76,-31,29,10,-73,-125,-126,-76,-42,-78,-159,-195,-118,31,117,62,-58,-176,-240,-247,-235,-238,-268,-286,-246,-141,-38,-9,-25,-46,-38,-8}
        },
        {    // H10e180a.wav
            {-1,-5,-1,-1,3,-1,1,0,-15,10,-25,31,-48,64,363,4139,4582,-2556,-3911,-30,-446,1339,10119,8357,-162,1780,4402,-639,-3829,-2848,-4265,-5544,-3769,-1871,-1930,-1585,348,782,1033,2041,1745,826,572,858,418,-348,-417,-305,-1097,-1780,-1769,-1669,-1063,-363,-111,-23,232,582,692,685,658,336,-70,-106,-142,-421,-470,-453,-607,-812,-639,-302,-239,-175,-39,-2,-71,58,234,209,69,-4,-74,-256,-298,-197,-230,-306,-306,-288,-270,-163,-27,-24,-80,-80,-50,-43,4,15,-56,-128,-158,-150,-101,-76,-123,-180,-180,-77,54,113,73,-30,-159,-247,-263,-247,-239,-257,-273,-237,-144,-43,-11,-40,-59,-43},
            {-1,-5,-1,-1,3,-1,1,0,-15,10,-25,31,-48,64,363,4139,4582,-2556,-3911,-30,-446,1339,10119,8357,-162,1780,4402,-639,-3829,-2848,-4265,-5544,-3769,-1871,-1930,-1585,348,782,1033,2041,1745,826,572,858,418,-348,-417,-305,-1097,-1780,-1769,-1669,-1063,-363,-111,-23,232,582,692,685,658,336,-70,-106,-142,-421,-470,-453,-607,-812,-639,-302,-239,-175,-39,-2,-71,58,234,209,69,-4,-74,-256,-298,-197,-230,-306,-306,-288,-270,-163,-27,-24,-80,-80,-50,-43,4,15,-56,-128,-158,-150,-101,-76,-123,-180,-180,-77,54,113,73,-30,-159,-247,-263,-247,-239,-257,-273,-237,-144,-43,-11,-40,-59,-43}
        }
    },
    {    // elev20
        {    // H20e000a.wav
            {-5,2,-6,10,1,3,11,-26,42,-72,106,-139,167,543,6671,4276,-2692,-1647,-5872,792,4988,5035,11773,7686,-2234,-1219,1989,-5035,-9992,-7086,-2924,-3516,-3122,223,17,1363,2937,2064,2242,2440,1079,37,54,202,613,189,65,-589,-1895,-2557,-1977,-997,-967,-509,800,978,808,1009,556,-210,-530,-710,-1033,-1193,-999,-460,-425,-575,-591,-454,-87,168,88,-33,75,112,84,133,239,119,-164,-303,-356,-426,-398,-315,-236,-276,-260,-160,-8,153,185,34,-144,-144,-66,-16,-7,-64,-203,-270,-194,-137,-117,-102,-172,-211,-120,20,87,29,-116,-191,-156,-108,-45,-45,-126,-138,-96,-9,109,102,-40,-126,-136,-183},
            {-5,2,-6,10,1,3,11,-26,42,-72,106,-139,167,543,6671,4276,-2692,-1647,-5872,792,4988,5035,11773,7686,-2234,-1219,1989,-5035,-9992,-7086,-2924,-3516,-3122,223,17,1363,2937,2064,2242,2440,1079,37,54,202,613,189,65,-589,-1895,-2557,-1977,-997,-967,-509,800,978,808,1009,556,-210,-530,-710,-1033,-1193,-999,-460,-425,-575,-591,-454,-87,168,88,-33,75,112,84,133,239,119,-164,-303,-356,-426,-398,-315,-236,-276,-260,-160,-8,153,185,34,-144,-144,-66,-16,-7,-64,-203,-270,-194,-137,-117,-102,-172,-211,-120,20,87,29,-116,-191,-156,-108,-45,-45,-126,-138,-96,-9,109,102,-40,-126,-136,-183}
        },
        {    // H20e005a.wav
            {-3,-4,3,-7,13,-5,10,-3,-7,17,-41,67,-82,98,814,6267,3193,-2167,-1443,-5137,725,4586,5166,10333,6873,-1691,-642,1877,-4806,-9423,-6222,-2412,-3837,-2982,477,-85,1104,2759,1993,1993,2014,857,302,174,268,632,114,83,-523,-1742,-2316,-1838,-1096,-716,-7,726,725,632,722,371,-218,-569,-755,-809,-921,-975,-676,-515,-554,-619,-485,-103,188,69,-24,110,107,50,105,204,55,-199,-311,-335,-344,-320,-248,-205,-250,-218,-128,-23,99,154,24,-148,-175,-90,15,25,-51,-200,-284,-204,-129,-118,-126,-166,-170,-79,43,78,-9,-135,-186,-155,-130,-84,-63,-113,-97,-49,19,107,96,-22,-127,-155},
            {-4,1,-1,15,-19,38,-60,78,-111,147,-178,214,28,5754,6932,-2635,-1901,-6200,-1357,6378,4000,11873,10857,-2036,-2861,2676,-4069,-10601,-7903,-3794,-3588,-3311,23,-295,892,3442,2068,2120,2914,1723,115,-209,66,738,310,148,-288,-1933,-2816,-2205,-1288,-1269,-654,647,978,1015,1099,631,42,-429,-792,-1254,-1334,-870,-210,-321,-564,-506,-472,-98,196,47,-129,-8,51,94,168,251,141,-73,-229,-375,-466,-424,-313,-216,-280,-298,-168,-33,103,157,41,-129,-150,-77,-31,-36,-54,-154,-253,-217,-127,-91,-96,-164,-232,-170,0,127,84,-90,-197,-174,-134,-65,-6,-89,-168,-127,-49,77,104,-31,-133,-145,-163,-142}
        },
        {    // H20e010a.wav
            {0,-3,-4,3,-7,14,-8,16,-14,12,-9,-3,24,-25,28,1255,5872,2023,-1597,-1606,-4674,1428,4205,5132,9695,5485,-1552,413,1272,-5337,-8447,-4925,-2557,-4036,-2085,410,-351,1362,2530,1734,1785,1609,773,452,228,449,473,14,183,-619,-1727,-2054,-1626,-1098,-361,621,620,206,437,473,133,-325,-662,-717,-711,-741,-766,-716,-641,-495,-594,-497,-81,151,30,-40,91,62,0,101,134,-35,-206,-288,-298,-266,-200,-142,-176,-241,-183,-107,-49,42,68,-43,-141,-156,-69,-3,3,-56,-199,-260,-210,-129,-105,-117,-147,-140,-52,51,70,-35,-163,-204,-187,-151,-84,-52,-86,-83,-26,39,108,81,-41,-127},
            {4,-9,30,-32,52,-68,79,-99,115,-118,140,-116,4095,9257,-1070,-2941,-5718,-4275,6762,4619,10542,13885,205,-5288,2436,-2108,-11300,-9326,-4041,-3529,-4186,43,178,-292,3498,2724,1673,3029,2500,470,-244,-286,712,657,150,93,-1613,-3095,-2686,-1841,-1548,-531,470,991,1153,1102,747,209,-367,-1020,-1539,-1298,-554,-112,-192,-456,-431,-396,-154,207,166,-224,-166,-17,24,136,271,218,-34,-235,-384,-454,-409,-269,-190,-252,-262,-119,-43,38,102,32,-143,-194,-156,-71,-18,-26,-117,-231,-204,-103,-65,-103,-172,-249,-171,16,155,146,-18,-198,-222,-159,-81,-15,-69,-155,-155,-69,69,122,-10,-149,-180,-180,-137,-29}
        },
        {    // H20e015a.wav
            {-3,0,-3,-4,2,-5,12,-9,16,-19,18,-22,16,-3,7,1,1514,5288,1427,-1130,-1991,-3961,1932,3522,5294,8935,4201,-889,1058,424,-5322,-7060,-4272,-2954,-3552,-1518,-29,-293,1496,2104,1524,1594,1303,833,637,375,365,251,215,131,-774,-1524,-1692,-1420,-953,7,667,254,-128,196,277,-57,-497,-642,-608,-625,-575,-573,-594,-599,-549,-553,-442,-158,31,-28,-22,-13,-69,-13,90,89,-45,-187,-225,-202,-164,-115,-94,-140,-212,-192,-133,-69,-36,-36,-88,-132,-121,-83,-44,-27,-64,-172,-230,-172,-121,-86,-85,-128,-127,-62,30,38,-39,-173,-228,-186,-157,-86,-59,-87,-67,-13,58,101,71,-44},
            {-10,29,-26,39,-41,33,-33,16,14,-33,34,2211,10261,2207,-4135,-5291,-6477,5437,5493,9699,15696,3401,-6018,420,-291,-10448,-11256,-5559,-2528,-4254,-1562,1171,-423,2447,3192,1826,2686,2976,1143,-154,-437,393,990,216,427,-1070,-3026,-3415,-2787,-1442,-443,143,1031,1254,984,889,553,-437,-1546,-1765,-889,-265,-245,-94,-270,-291,-341,-220,164,277,-105,-267,-190,-111,71,228,288,27,-313,-406,-403,-353,-239,-189,-173,-195,-85,-54,17,90,29,-180,-314,-252,-129,-36,-23,-74,-187,-198,-112,-62,-92,-167,-243,-186,3,196,230,44,-205,-273,-197,-97,-22,-83,-174,-168,-105,38,140,32,-139,-204,-215,-166,-29,6}
        },
        {    // H20e020a.wav
            {-4,0,-1,-1,-2,2,-4,12,-8,14,-16,19,-23,26,-17,28,-5,1603,4712,1228,-971,-2258,-3029,1886,3035,5487,7861,3466,-102,1179,-265,-4667,-5874,-4202,-2943,-2905,-1437,-352,-101,1338,1705,1457,1320,1208,1084,735,231,223,350,237,55,-647,-1160,-1315,-1325,-875,37,372,-106,-346,-7,232,-250,-698,-488,-442,-509,-472,-332,-387,-566,-566,-544,-451,-265,-102,-123,-84,-93,-166,-41,115,135,-12,-148,-136,-114,-89,-58,-75,-135,-185,-190,-174,-137,-103,-82,-106,-161,-148,-88,-40,-27,-83,-151,-161,-113,-98,-84,-73,-114,-131,-78,2,18,-58,-165,-213,-207,-168,-94,-63,-79,-40,15,50,94,59},
            {14,-3,7,7,-31,48,-88,143,-197,244,657,9342,6568,-4008,-5683,-7756,3023,5954,8423,17176,7263,-5607,-1210,108,-8909,-11749,-8185,-3294,-2710,-2418,336,139,2167,2993,1676,2676,3107,1694,207,-403,-27,1152,419,574,-197,-2861,-4286,-3393,-1379,-549,-45,813,1157,1019,1021,750,-483,-1922,-1760,-460,-185,-446,-62,16,-131,-420,-336,192,392,72,-234,-321,-247,-5,78,272,79,-311,-448,-380,-284,-189,-141,-123,-139,-72,-19,-5,91,61,-191,-383,-360,-227,-76,-47,-48,-133,-196,-164,-86,-60,-114,-181,-183,-32,196,308,118,-196,-306,-223,-136,-45,-63,-163,-208,-155,2,146,81,-110,-218,-234,-177,-36,29,-46}
        },
        {    // H20e025a.wav
            {-4,-3,-2,-1,-2,-3,1,-3,10,-9,13,-16,16,-20,23,-19,34,-8,1550,4225,1188,-1022,-2167,-2303,1527,2858,5360,6823,3216,485,989,-474,-3781,-5199,-4144,-2615,-2474,-1564,-462,-48,1049,1545,1312,1182,1315,1136,621,61,230,469,327,199,-326,-813,-1340,-1508,-765,-36,-209,-484,-271,36,9,-473,-624,-306,-260,-386,-350,-183,-191,-465,-667,-618,-472,-332,-275,-238,-150,-162,-167,-18,154,154,28,-55,-63,-52,-50,-54,-70,-131,-188,-222,-222,-177,-132,-126,-166,-190,-151,-75,-27,-38,-67,-111,-107,-83,-83,-70,-79,-113,-126,-85,-37,-26,-86,-163,-192,-210,-181,-88,-34,-45,-40,-7,34,69},
            {22,-27,50,-77,98,-144,194,-243,309,-156,6699,10364,-1365,-6447,-8827,317,5664,7000,17119,11536,-3072,-2926,351,-7511,-11522,-9970,-5633,-2341,-2217,161,-118,1430,3760,1681,1865,3229,2460,411,-262,-186,1023,667,683,692,-2693,-5005,-3496,-1491,-867,-43,410,850,1064,1087,703,-666,-1716,-1243,-407,-306,-499,-112,249,-44,-526,-509,151,540,288,-197,-289,-284,-152,-29,126,58,-218,-471,-387,-250,-138,-67,-56,-74,-89,-39,-39,95,102,-127,-400,-424,-334,-165,-32,-34,-166,-246,-185,-104,-40,-47,-125,-157,-36,181,310,173,-125,-311,-280,-201,-56,-27,-144,-229,-211,-61,131,133,-68,-223,-260,-195,-49,47,-3,-67}
        },
        {    // H20e030a.wav
            {-3,-2,-2,-1,0,-1,-2,2,-1,8,-7,14,-13,18,-17,20,-9,23,1,1405,3831,1173,-1055,-1866,-1921,1196,2773,4966,6061,3171,764,871,-328,-3072,-4720,-3908,-2260,-2266,-1666,-537,-115,911,1497,1158,1058,1363,1059,354,59,494,650,635,453,-320,-953,-1498,-1472,-805,-435,-649,-536,-104,24,-259,-544,-348,-72,-164,-327,-205,-6,-128,-493,-710,-667,-498,-420,-396,-330,-207,-158,-107,21,144,182,94,39,20,-21,-80,-89,-65,-122,-207,-243,-241,-209,-173,-165,-188,-175,-127,-70,-31,-8,-16,-76,-94,-65,-42,-44,-74,-125,-151,-116,-56,-43,-96,-156,-180,-170,-128,-58,-36,-64,-47,-13,11},
            {-26,51,-75,75,-102,106,-110,117,-155,3334,11760,3613,-6135,-10128,-2710,5266,4931,16138,15142,45,-2554,197,-6582,-10384,-10751,-8762,-2917,-2161,-845,914,866,2979,2643,2026,2305,2707,1423,-254,-564,981,1058,524,1294,-2417,-5032,-3511,-1888,-912,-227,30,558,1030,864,249,-843,-957,-349,-649,-635,-209,16,113,-154,-497,-631,-56,527,478,-27,-147,-295,-292,-72,20,2,-252,-420,-330,-264,-203,25,89,-12,-118,-127,-83,61,125,-24,-341,-467,-391,-228,-46,-34,-195,-334,-259,-99,-3,-2,-64,-129,-52,136,295,229,-46,-295,-334,-260,-109,5,-97,-234,-255,-128,90,166,4,-196,-292,-237,-85,53,43,-40,-89}
        },
        {    // H20e035a.wav
            {-3,-3,-3,-3,-2,-2,-2,-3,1,-3,3,-9,10,-11,12,-17,17,-12,13,10,1197,3479,1176,-992,-1564,-1754,960,2610,4508,5519,3106,949,867,-103,-2506,-4258,-3609,-2020,-2143,-1749,-588,-65,933,1256,883,1045,1246,834,378,380,835,1015,649,90,-445,-1007,-1708,-1609,-860,-733,-859,-412,-7,-82,-404,-348,-56,5,-153,-220,-97,-42,-158,-491,-706,-678,-566,-515,-468,-359,-247,-147,-42,45,137,202,173,101,17,-82,-133,-98,-69,-121,-233,-290,-278,-246,-194,-171,-182,-172,-124,-66,-23,6,-9,-47,-69,-53,-48,-65,-100,-174,-180,-130,-73,-61,-98,-138,-155,-135,-119,-86,-63,-71,-59,-54},
            {14,-13,-8,14,-50,97,-152,187,721,9884,9110,-3281,-10980,-6557,4713,3459,12705,18596,3942,-2641,1540,-4731,-10801,-9480,-10800,-6087,-1622,-1790,83,1271,3271,2377,2020,2903,2431,1552,443,-443,99,1562,816,935,-2112,-4154,-3279,-2742,-925,-220,-312,200,1044,498,-616,-958,-48,505,-625,-898,-132,379,160,-459,-638,-640,-280,288,505,238,69,-250,-385,-56,-16,-52,-258,-344,-320,-306,-239,68,237,72,-141,-243,-139,50,138,-2,-260,-411,-401,-261,-76,-43,-182,-360,-348,-186,22,97,19,-130,-98,93,260,289,46,-264,-393,-292,-137,6,-47,-208,-276,-181,37,167,79,-125,-278,-288,-150,31,90,18,-81,-122}
        },
        {    // H20e040a.wav
            {1,0,-2,0,-3,-1,1,-1,-1,4,-1,5,-3,11,-4,10,-9,14,-6,19,7,985,3156,1206,-842,-1308,-1660,765,2394,4079,5075,3089,1095,915,169,-2022,-3804,-3308,-1839,-2044,-1694,-456,-28,728,896,666,1048,1171,865,786,889,923,707,333,-19,-589,-1366,-1856,-1430,-904,-955,-803,-256,11,-113,-313,-163,92,34,-156,-185,-94,-35,-170,-487,-664,-686,-640,-571,-453,-351,-235,-98,8,92,158,224,190,72,-31,-100,-117,-103,-86,-134,-261,-327,-285,-215,-192,-159,-144,-143,-112,-53,-4,16,29,-15,-63,-77,-73,-78,-128,-168,-176,-139,-67,-30,-58,-120,-148,-131,-107,-75,-63,-75,-72},
            {35,-72,89,-131,171,-217,278,-277,5688,12348,2422,-9963,-10891,2471,3995,7709,19468,9406,-1885,1465,-1440,-9817,-9694,-10611,-8901,-3203,-2397,-654,491,2580,3893,2143,2265,2863,2641,319,-395,89,1280,1016,300,-1599,-3352,-2874,-2958,-1452,-397,-276,78,690,31,-1310,-1015,475,1000,-189,-805,-178,473,326,-393,-720,-869,-656,27,376,397,180,-110,-300,-91,-19,-32,-170,-269,-311,-396,-288,105,345,129,-190,-296,-187,-13,123,21,-182,-358,-388,-304,-105,-17,-106,-337,-429,-273,-32,144,87,-87,-138,19,206,308,147,-205,-418,-363,-188,3,24,-141,-286,-241,-38,148,137,-35,-225,-329,-216,-12,99,71,-37,-147,-105}
        },
        {    // H20e045a.wav
            {1,0,-1,-2,-2,-2,-1,0,-2,-1,2,-3,2,-3,11,-6,5,-7,7,1,11,-2,786,2820,1249,-634,-1114,-1618,593,2143,3653,4753,3074,1157,1027,434,-1661,-3345,-2975,-1676,-1802,-1550,-498,-168,335,584,797,1116,1267,1377,1014,529,589,598,53,-378,-855,-1523,-1638,-1214,-1047,-996,-588,-99,-10,-122,-202,-42,65,-60,-126,-139,-78,-48,-216,-496,-637,-708,-701,-532,-389,-327,-192,-45,29,88,149,186,132,32,-43,-97,-127,-134,-122,-183,-286,-299,-265,-217,-163,-112,-113,-128,-94,-45,-4,25,21,-31,-82,-86,-99,-111,-130,-162,-165,-128,-49,-19,-47,-109,-152,-127,-96,-60,-64,-91},
            {-34,29,-44,29,-14,-12,-14,1559,11178,9197,-5560,-13895,-2848,5594,3864,16488,14894,541,834,1583,-7327,-9892,-9519,-11121,-5170,-2776,-2725,9,1483,3516,3028,3202,2383,2650,2153,-177,-520,1100,1426,-942,-1229,-2052,-2960,-2847,-1738,-730,-427,151,480,-536,-1997,-954,865,1029,216,-381,-56,410,336,-119,-594,-900,-1059,-531,143,438,190,-49,-110,-81,-44,13,67,-153,-371,-376,-287,-10,348,244,-170,-368,-239,-81,39,44,-67,-312,-438,-335,-125,11,-15,-231,-443,-350,-100,129,97,-56,-133,-52,121,274,235,-105,-414,-420,-250,-59,46,-36,-214,-287,-140,89,162,47,-147,-318,-274,-71,70,85,24,-111,-185,-61}
        },
        {    // H20e050a.wav
            {1,2,1,0,-1,-2,-3,1,1,0,1,1,-3,3,-2,11,-5,3,-3,6,5,1,3,610,2475,1320,-400,-976,-1579,427,1859,3306,4521,3036,1209,1156,634,-1337,-2793,-2504,-1493,-1699,-1573,-732,-331,203,634,1107,1438,1442,1048,560,379,396,182,-329,-508,-931,-1375,-1305,-1157,-1070,-763,-358,-108,-34,-96,-205,-120,3,-15,-74,-105,-81,-133,-263,-482,-658,-683,-597,-450,-349,-268,-137,-58,5,74,102,119,109,14,-76,-112,-160,-164,-166,-202,-248,-274,-237,-178,-115,-84,-91,-92,-99,-66,-18,12,6,-47,-87,-110,-124,-122,-127,-144,-152,-111,-41,-10,-42,-103,-129,-113,-88,-74,-78},
            {-50,67,-110,142,-197,247,-234,6086,13286,2406,-12961,-10324,4752,3796,10223,18572,4940,-93,3418,-2984,-9411,-8973,-11142,-8256,-3115,-3776,-1658,-80,2659,3422,2902,3501,2918,2725,795,296,714,886,-1319,-1364,-1101,-2906,-2615,-2084,-1153,-419,141,278,-949,-2402,-1185,1010,1124,522,-47,87,523,335,72,-343,-801,-1163,-1044,-349,217,142,-37,-33,-60,10,28,222,148,-269,-429,-267,-60,212,260,-47,-327,-353,-225,-49,82,10,-262,-479,-376,-164,24,47,-110,-335,-382,-183,32,115,-12,-147,-140,-5,214,286,30,-348,-470,-331,-144,45,32,-139,-272,-222,6,149,94,-79,-264,-293,-134,24,70,44,-65,-198,-144,10}
        },
        {    // H20e055a.wav
            {0,0,1,0,0,-1,-2,-2,0,-1,0,-1,0,-3,1,1,9,-6,1,1,3,3,-6,10,447,2130,1399,-153,-844,-1551,214,1588,3021,4346,2987,1211,1286,864,-834,-2100,-2212,-1634,-1841,-1574,-615,-298,317,1202,1255,903,986,777,246,9,67,-72,-370,-451,-871,-1111,-1002,-1019,-937,-588,-290,-132,-115,-241,-276,-124,25,53,-58,-161,-135,-184,-329,-465,-523,-576,-524,-373,-296,-253,-150,-74,-43,25,66,84,51,-30,-105,-160,-178,-173,-174,-198,-209,-213,-197,-148,-89,-55,-77,-103,-124,-86,-24,-1,-16,-77,-104,-119,-135,-135,-121,-121,-128,-97,-45,-14,-26,-74,-112,-117,-113,-94},
            {-1,-5,-10,34,-75,68,1029,10914,11328,-6021,-15764,-2160,6600,4430,17024,12253,-436,3083,1729,-6636,-8793,-9552,-11267,-4950,-3268,-3721,-1092,375,2868,3086,3561,2898,3716,2647,283,1342,1280,-1842,-2254,-76,-2456,-3016,-2102,-1704,-661,113,404,-1275,-2845,-1398,974,1080,785,481,162,453,501,341,-159,-655,-978,-1327,-917,-130,-4,-155,-73,-104,21,84,276,447,36,-315,-290,-133,107,253,28,-245,-395,-344,-185,37,90,-178,-475,-443,-209,-18,85,23,-159,-337,-267,-62,82,82,-102,-232,-149,66,270,194,-176,-452,-411,-245,-34,104,-19,-238,-288,-101,115,151,13,-198,-310,-188,-15,68,59,-25,-167,-210,-48,74}
        },
        {    // H20e060a.wav
            {0,0,0,1,1,0,-1,-1,-1,0,1,1,-1,1,-2,3,4,4,0,0,5,3,1,-4,23,316,1798,1461,91,-699,-1559,-6,1367,2817,4208,2875,1261,1563,1321,-384,-1870,-2345,-1770,-1496,-1261,-370,238,581,662,544,660,583,195,-129,-167,45,6,-281,-448,-638,-653,-763,-972,-807,-505,-345,-258,-268,-343,-283,-47,79,-25,-141,-144,-198,-240,-214,-338,-449,-480,-412,-346,-309,-238,-187,-115,-58,-5,11,13,10,-82,-141,-151,-164,-176,-176,-135,-155,-178,-161,-119,-66,-67,-78,-116,-121,-82,-47,-20,-46,-82,-121,-137,-132,-113,-91,-105,-109,-96,-38,9,-5,-56,-108,-133,-134},
            {41,-76,102,-117,133,-203,3841,14156,5958,-13365,-12782,4920,5162,8812,18380,4189,103,4445,-1406,-7970,-8225,-10280,-9397,-3720,-4011,-2522,-1307,1080,2684,2892,3653,2983,3928,2133,1832,1634,-1373,-2298,-464,-1559,-3040,-2344,-2485,-1188,87,396,-1167,-3118,-1903,585,1233,904,879,610,385,424,560,253,-453,-812,-1271,-1328,-618,-228,-220,-210,-281,-169,76,335,617,402,-49,-174,-131,-14,186,134,-157,-389,-444,-306,-63,78,-78,-365,-465,-326,-102,73,139,24,-212,-297,-163,19,134,26,-230,-301,-123,136,260,58,-297,-444,-346,-141,69,100,-123,-300,-230,8,159,122,-53,-268,-296,-106,61,96,44,-95,-231,-159,36,112}
        },
        {    // H20e065a.wav
            {-1,-1,-1,0,0,0,0,-2,-1,-2,-2,0,-1,-2,-1,-2,2,2,2,2,-7,14,-9,-2,3,29,203,1502,1493,328,-538,-1614,-241,1198,2703,4061,2881,1633,1877,1350,-585,-1770,-1876,-1460,-1069,-388,49,-407,-131,264,54,48,36,-150,-212,138,224,-32,-147,-144,-281,-430,-664,-925,-826,-576,-418,-392,-404,-332,-199,-77,-56,-89,-124,-168,-144,-109,-157,-266,-339,-391,-404,-357,-316,-289,-202,-118,-102,-77,-52,-42,-57,-87,-120,-147,-169,-158,-121,-105,-123,-144,-139,-111,-78,-72,-87,-114,-118,-95,-73,-55,-66,-105,-128,-116,-107,-97,-91,-96,-103,-73,-8,14,-8,-68,-118,-146},
            {52,-96,147,-193,240,-121,7443,14900,-1129,-17424,-6411,8380,4104,13781,14466,-464,2646,3580,-3730,-8390,-8009,-10054,-7294,-4025,-4166,-1911,-1071,1496,2352,3140,2953,3660,3684,2193,3225,-196,-2715,-593,-227,-2647,-3069,-2575,-2327,-603,505,-718,-3287,-2614,87,990,1069,1113,1191,779,240,432,636,19,-604,-1100,-1498,-1069,-506,-387,-280,-400,-491,-242,238,691,701,311,22,-2,17,83,119,-14,-295,-484,-475,-231,16,6,-230,-413,-428,-249,-8,155,189,-20,-256,-232,-62,89,139,-99,-347,-326,-69,174,202,-67,-364,-403,-255,-35,122,31,-231,-316,-141,82,167,83,-131,-312,-259,-39,93,117,22,-165,-241,-90,80,99}
        },
        {    // H20e070a.wav
            {0,0,0,0,1,1,2,2,0,1,0,0,2,3,-1,2,2,2,4,6,2,-2,23,-20,6,12,35,133,1260,1485,564,-381,-1738,-491,1172,2799,4223,3111,1565,1333,1151,-37,-1141,-1378,-513,-306,-859,-818,-744,-645,-601,-462,-328,-266,-7,214,315,264,304,117,-15,-41,-286,-770,-1041,-831,-610,-519,-480,-380,-351,-312,-149,-83,-84,-55,-28,-53,-64,-58,-182,-306,-383,-405,-391,-362,-267,-204,-165,-151,-133,-108,-62,-39,-82,-115,-131,-131,-123,-94,-68,-95,-129,-136,-104,-86,-79,-76,-99,-118,-126,-104,-78,-62,-81,-104,-103,-100,-92,-81,-66,-62,-38,-13,-5,-23,-67,-113},
            {30,-63,108,-163,189,494,10858,13337,-7965,-17943,400,8749,4726,16594,8744,-1373,4510,2259,-5336,-8619,-7572,-9212,-6059,-4523,-3869,-2197,-581,1852,2139,3145,2675,3951,3429,3242,1966,-1876,-952,64,-829,-2698,-3238,-3015,-1859,2,-375,-2691,-3541,-805,617,916,1266,1452,1563,678,137,489,599,-120,-833,-1418,-1414,-850,-561,-382,-440,-689,-636,-187,487,812,681,336,188,153,145,78,34,-112,-393,-552,-484,-159,32,-86,-282,-427,-426,-164,106,236,167,-78,-243,-148,15,161,60,-253,-410,-275,-3,168,141,-166,-389,-339,-143,49,119,-47,-298,-294,-50,157,168,15,-212,-325,-182,27,106,113,-1,-185,-203,-31,80,77}
        },
        {    // H20e075a.wav
            {0,0,0,-1,-1,2,1,1,0,-1,-1,0,0,4,0,-2,3,-2,2,5,4,1,5,15,-31,19,21,38,73,1077,1485,781,-327,-1949,-604,1625,3430,3952,2156,1147,1715,1733,472,-21,-383,-1005,-1072,-1145,-1418,-1564,-1314,-1062,-739,-276,29,210,462,722,564,348,230,158,-35,-454,-944,-1055,-838,-631,-550,-550,-509,-471,-290,-130,-52,32,74,43,15,31,-39,-195,-328,-421,-444,-426,-343,-268,-241,-213,-210,-156,-98,-54,-59,-79,-85,-107,-106,-97,-74,-69,-96,-116,-143,-114,-77,-67,-79,-124,-151,-151,-102,-55,-46,-85,-110,-104,-95,-65,-45,-40,-58,-55,-32,-17,-35,-78},
            {-8,-3,24,-65,40,1475,13306,10595,-13167,-16057,5727,7643,6310,16803,4008,-432,5532,1366,-6683,-8576,-6896,-8376,-5608,-4634,-3725,-2645,-203,1786,2430,2894,2690,4098,3495,3337,-178,-1597,549,375,-947,-3160,-3126,-2878,-1522,-337,-1925,-3900,-2320,216,300,1062,1622,1927,1528,557,270,530,455,-271,-1090,-1516,-1232,-807,-549,-454,-697,-910,-740,-18,605,773,662,437,352,266,171,58,0,-195,-476,-628,-472,-109,-11,-159,-313,-469,-398,-109,169,273,114,-125,-215,-74,65,150,-50,-387,-429,-215,29,135,65,-245,-415,-280,-70,86,81,-132,-345,-259,34,178,115,-74,-279,-319,-126,56,96,76,-55,-198,-172,-24,57,39}
        },
        {    // H20e080a.wav
            {0,1,0,0,0,-1,1,1,1,0,0,0,0,0,1,-1,-2,1,-3,3,3,4,6,3,-1,-25,47,15,11,52,998,1503,967,-443,-1949,29,2091,2719,2835,2329,1959,2128,2657,1644,-414,-1406,-1121,-1524,-2256,-2040,-1853,-1764,-1090,-292,-80,125,730,1028,802,561,472,188,63,-163,-678,-1046,-995,-779,-706,-708,-678,-555,-376,-197,-59,59,137,154,121,89,13,-95,-273,-396,-451,-465,-405,-331,-292,-287,-255,-195,-127,-91,-63,-54,-58,-62,-62,-92,-124,-98,-56,-79,-137,-133,-89,-85,-98,-110,-142,-153,-109,-78,-71,-70,-87,-98,-84,-50,-47,-52,-55,-61,-60,-47,-42,-57},
            {-39,53,-53,34,-101,2414,14691,7923,-16470,-13410,9112,6437,7722,15552,1065,803,6269,909,-7775,-8194,-6257,-7854,-5488,-4454,-3843,-2931,46,1441,2597,2978,2760,4173,3847,1956,-1306,-235,822,668,-666,-3348,-3219,-2346,-1141,-1625,-3447,-3704,-1130,75,205,1374,1950,2191,1358,588,481,621,328,-508,-1184,-1379,-1190,-804,-468,-615,-943,-1034,-707,64,594,764,672,545,486,346,189,98,15,-246,-540,-649,-410,-101,-71,-177,-343,-483,-340,-44,194,276,114,-133,-182,-15,115,122,-129,-428,-414,-174,43,160,18,-313,-408,-221,1,105,66,-182,-342,-177,92,165,72,-95,-306,-293,-71,83,110,49,-98,-205,-123,22,58,15}
        },
        {    // H20e085a.wav
            {0,0,1,0,0,-1,-1,0,1,1,1,1,0,-1,-1,2,-2,0,2,-2,3,3,13,0,-9,4,12,35,-4,-5,112,1020,1608,1277,-266,-1847,-647,1605,3241,3194,2695,3095,3270,2072,479,-660,-1928,-2182,-2247,-2613,-2266,-1875,-1451,-719,-110,304,721,1054,1117,835,460,291,126,-64,-452,-790,-973,-1021,-911,-807,-767,-610,-374,-252,-106,64,167,199,225,174,24,-101,-199,-334,-439,-458,-415,-397,-357,-314,-284,-221,-142,-103,-96,-61,-29,-6,-23,-103,-166,-118,-44,-48,-84,-113,-122,-116,-114,-109,-106,-108,-110,-111,-111,-75,-43,-49,-58,-64,-66,-63,-44,-50,-69,-71,-66,-59},
            {-48,70,-85,79,-172,2850,15190,6321,-17988,-11411,10804,5743,8180,14096,-344,1685,6988,916,-8434,-7694,-5703,-7707,-5522,-4220,-4028,-3201,152,1165,2428,3055,2972,4364,3708,564,-1340,669,749,860,-469,-3063,-3086,-2013,-1118,-2786,-4380,-3144,-658,-303,272,1621,2164,2209,1225,695,700,728,249,-649,-1161,-1254,-1237,-781,-437,-795,-1125,-1112,-642,35,507,747,702,594,566,396,222,166,42,-276,-571,-630,-373,-148,-139,-203,-383,-492,-304,2,196,256,109,-126,-169,12,146,109,-174,-447,-410,-169,44,165,-15,-372,-406,-183,32,108,47,-201,-332,-138,114,155,59,-117,-326,-285,-40,98,85,8,-136,-211,-96,60,56,-21}
        },
        {    // H20e090a.wav
            {0,0,0,0,0,0,-1,-1,0,2,2,1,1,-1,-2,1,2,-2,2,-1,1,5,7,12,-18,7,27,14,-6,4,-17,323,1337,2587,1517,-2583,-3105,733,3503,3675,3578,3937,2767,1947,1514,-204,-2186,-2744,-2313,-2579,-2538,-1806,-1518,-1189,-206,478,618,929,1219,986,539,326,184,-60,-269,-553,-929,-1156,-1086,-889,-756,-575,-384,-291,-143,63,148,198,259,209,22,-122,-174,-275,-394,-419,-425,-442,-411,-340,-273,-232,-165,-111,-118,-93,-3,23,-50,-134,-152,-116,-65,-35,-46,-91,-140,-153,-129,-102,-76,-81,-128,-137,-121,-81,-25,2,-44,-96,-89,-68,-46,-55,-68,-85,-103,-87},
            {-41,62,-69,56,-140,2583,14997,6313,-18048,-10886,11271,5833,7494,13088,-651,2014,7696,1478,-8537,-7418,-5056,-7780,-5805,-4052,-4075,-3542,67,1086,2161,2965,3025,4651,3262,-228,-744,825,559,1150,-334,-2840,-2595,-1708,-1579,-3498,-4454,-2805,-921,-453,406,1609,2278,2154,1091,801,929,889,254,-643,-1065,-1217,-1273,-745,-501,-916,-1213,-1161,-604,-35,391,698,724,610,606,440,274,245,106,-256,-575,-600,-351,-201,-185,-244,-423,-482,-286,11,188,261,96,-126,-149,31,162,118,-176,-460,-406,-154,38,137,-44,-375,-399,-168,44,101,45,-206,-327,-118,141,164,58,-131,-332,-266,-26,80,50,-19,-147,-206,-81,68,51,-41}
        },
        {    // H20e095a.wav
            {0,0,0,0,0,-1,0,-1,2,2,0,1,-1,-1,-2,-1,2,0,-2,-1,-1,7,0,10,-5,-7,30,26,-24,-8,-7,244,1579,2617,1400,-2603,-3422,650,3267,4361,4191,2888,2501,2710,1262,-908,-1704,-2319,-2747,-2423,-2007,-1910,-1591,-952,-368,224,591,868,952,906,719,394,106,1,-112,-523,-973,-1150,-1088,-918,-684,-485,-366,-301,-135,37,133,176,197,133,0,-104,-176,-247,-331,-383,-427,-465,-416,-328,-257,-208,-179,-131,-124,-78,-10,-22,-104,-138,-105,-100,-71,-36,-42,-90,-143,-151,-125,-74,-63,-100,-142,-136,-89,-62,-11,0,-45,-97,-102,-74,-54,-54,-85,-112,-111,-87},
            {-16,14,-3,-35,-13,1711,14030,7876,-16766,-11818,10596,6689,5885,12484,22,1653,8328,2656,-8007,-7585,-4286,-7741,-6410,-4097,-3964,-3892,-298,1140,1946,2792,2831,4628,3004,-293,-205,659,396,1277,-53,-2625,-2291,-1448,-1882,-3802,-4267,-2653,-1360,-611,424,1516,2186,2077,1063,791,1064,1165,363,-595,-896,-1179,-1295,-775,-575,-967,-1239,-1185,-633,-135,264,606,700,610,617,481,339,299,203,-177,-557,-571,-370,-240,-226,-290,-465,-504,-286,5,170,247,102,-123,-153,58,179,120,-161,-435,-398,-181,21,100,-64,-357,-385,-174,37,90,31,-209,-317,-104,158,176,52,-118,-310,-268,-51,47,9,-33,-132,-208,-99,53,42,-27}
        },
        {    // H20e100a.wav
            {1,0,0,0,-1,-1,0,0,0,1,1,0,-1,-2,1,0,1,1,-1,-2,0,6,1,4,0,10,4,40,-16,-12,49,907,2103,1438,-105,-2130,-2187,1234,4129,4244,2855,2393,2773,2339,484,-1280,-1769,-1821,-2105,-2292,-1832,-1444,-1267,-868,-283,57,315,638,721,735,630,442,191,28,-175,-583,-980,-1124,-974,-769,-595,-429,-287,-208,-139,9,144,120,50,-1,-50,-102,-164,-221,-303,-371,-412,-435,-374,-288,-226,-196,-170,-144,-106,-72,-77,-92,-119,-115,-89,-75,-63,-50,-61,-115,-144,-118,-79,-63,-88,-125,-142,-108,-49,-21,-18,-37,-57,-83,-100,-80,-61,-80,-126,-125,-82,-59},
            {26,-54,93,-153,172,619,11979,10566,-13869,-13816,8551,8224,3918,11652,1909,646,8520,4513,-6659,-8240,-3609,-7199,-7273,-4464,-3782,-4118,-973,1208,1852,2607,2528,4244,2957,155,135,445,348,1191,269,-2221,-2231,-1483,-1924,-3529,-4077,-2785,-1642,-690,238,1320,1994,1963,1129,725,1096,1413,610,-474,-744,-1037,-1273,-888,-645,-966,-1209,-1182,-697,-249,148,499,632,602,615,519,400,368,299,-66,-489,-553,-397,-261,-245,-318,-486,-521,-319,-15,141,225,137,-82,-146,56,194,134,-116,-381,-385,-220,-13,73,-48,-320,-371,-171,18,72,15,-175,-287,-102,158,178,78,-63,-262,-286,-106,30,1,-36,-124,-203,-121,39,71,7}
        },
        {    // H20e105a.wav
            {1,1,0,0,0,0,1,2,2,1,0,-1,0,0,1,2,3,1,0,1,4,3,6,2,1,14,17,2,28,29,679,1813,1250,67,-861,-1943,-352,3222,4479,2767,1705,2644,2463,849,-335,-1197,-1808,-1690,-1396,-1574,-1641,-1024,-561,-621,-331,79,74,162,499,550,392,353,315,24,-426,-708,-875,-989,-845,-588,-449,-354,-184,-79,-83,2,101,26,-106,-128,-141,-151,-149,-214,-307,-380,-374,-322,-294,-240,-190,-185,-155,-105,-99,-141,-145,-99,-103,-114,-86,-61,-58,-71,-95,-133,-113,-69,-50,-74,-112,-121,-114,-72,-26,-3,-22,-63,-76,-78,-79,-84,-100,-125,-132,-99,-57,-38},
            {60,-105,157,-223,281,-172,8655,13247,-8807,-15957,4776,9954,2440,9696,5005,-308,7594,6789,-4138,-9103,-3544,-5828,-8188,-5227,-3618,-4220,-1916,1114,1873,2413,2172,3696,3018,721,452,283,319,1026,616,-1691,-2298,-1671,-2003,-2961,-3651,-3070,-2012,-671,99,931,1679,1824,1246,701,1016,1467,926,-215,-609,-863,-1173,-1027,-739,-914,-1157,-1172,-787,-366,18,374,544,543,583,568,442,409,379,58,-388,-524,-440,-304,-268,-317,-484,-541,-381,-83,89,183,164,-21,-117,16,175,145,-47,-320,-394,-264,-68,45,-20,-256,-365,-211,-15,39,14,-132,-262,-137,114,188,107,-1,-219,-298,-162,-6,-11,-56,-134,-212,-129,34,93,19}
        },
        {    // H20e110a.wav
            {0,0,0,0,0,1,1,1,1,0,-1,-1,-2,0,0,0,0,0,-2,4,1,3,-2,9,-2,12,12,6,35,639,1751,1147,-139,-458,-1199,-975,2168,4576,2974,1526,2380,2057,764,-25,-1030,-1615,-1287,-1246,-1447,-1020,-552,-559,-409,43,-91,-275,-21,20,18,181,289,246,90,-143,-537,-831,-794,-695,-664,-523,-313,-184,-55,10,25,25,-41,-111,-202,-254,-261,-232,-196,-269,-362,-327,-263,-238,-191,-188,-191,-159,-112,-108,-168,-174,-140,-122,-113,-111,-100,-85,-82,-111,-131,-108,-65,-50,-77,-93,-101,-108,-75,-48,-36,-26,-32,-65,-101,-83,-77,-119,-143,-138,-108,-73,-59,-55},
            {54,-88,119,-148,177,-290,4609,14137,-1530,-16640,-865,10882,2520,6178,8335,141,5226,8619,-262,-9249,-4764,-3801,-8490,-6569,-3537,-4081,-3073,675,2012,2239,1827,3084,3170,1185,798,327,159,849,936,-978,-2385,-1945,-2045,-2554,-3051,-3095,-2467,-863,127,598,1231,1569,1401,799,865,1333,1168,181,-421,-689,-1027,-1101,-836,-858,-1077,-1153,-868,-467,-110,244,455,475,507,617,501,411,410,203,-243,-474,-465,-364,-301,-293,-423,-546,-450,-175,21,124,181,59,-71,-14,141,152,27,-242,-401,-306,-106,15,9,-168,-326,-271,-72,29,13,-69,-226,-186,42,206,148,32,-146,-272,-188,-58,-47,-93,-123,-170,-122,27,86,20}
        },
        {    // H20e115a.wav
            {0,0,0,0,1,2,2,0,1,0,-1,0,-2,0,1,-1,0,0,2,0,5,-4,8,-1,11,-1,15,25,569,1831,1241,-342,-505,-789,-886,1740,4218,2908,1593,2319,2064,624,-344,-1006,-1622,-1524,-1004,-1052,-1124,-508,88,150,104,198,140,-182,-200,-97,-291,-208,118,25,-307,-461,-605,-745,-665,-476,-438,-431,-232,-4,103,134,103,-11,-145,-230,-293,-342,-360,-319,-357,-402,-295,-209,-154,-150,-135,-135,-148,-114,-123,-161,-163,-125,-145,-159,-120,-98,-120,-146,-131,-134,-112,-53,-41,-58,-88,-97,-81,-65,-46,-42,-54,-51,-51,-69,-90,-108,-118,-133,-141,-116,-79,-66,-75,-88},
            {1,5,-24,45,-89,73,1179,11669,6568,-13604,-7636,9349,4715,1815,9811,3247,2152,8678,4420,-7235,-7199,-2299,-7224,-8337,-4061,-3503,-4147,-505,2151,2173,1482,2408,3351,1576,1021,731,-3,514,1126,-116,-2182,-2347,-2070,-2323,-2651,-2781,-2662,-1402,28,469,825,1195,1418,996,743,1075,1250,574,-143,-513,-850,-1090,-919,-829,-1018,-1096,-938,-558,-260,102,350,424,429,562,563,395,377,310,-53,-398,-482,-401,-351,-298,-346,-496,-510,-307,-58,38,147,122,-16,-36,95,148,60,-163,-373,-350,-151,-19,8,-87,-273,-301,-153,0,6,-29,-166,-237,-47,167,173,55,-67,-208,-225,-133,-109,-120,-93,-108,-126,-35,53,-3}
        },
        {    // H20e120a.wav
            {-1,0,0,1,2,2,1,0,-1,-1,-2,-1,-2,0,-2,0,-2,2,-2,4,-5,2,6,9,-5,14,12,523,1918,1387,-456,-637,-616,-801,1587,4242,2984,1340,2104,2171,548,-379,-970,-2010,-1810,-953,-1145,-1161,-249,144,134,659,836,270,37,225,-88,-484,-384,-277,-354,-487,-622,-739,-703,-553,-431,-348,-301,-229,-108,81,266,251,77,-81,-181,-298,-395,-401,-427,-550,-518,-353,-226,-100,-88,-101,-83,-77,-95,-145,-137,-99,-111,-148,-179,-157,-110,-130,-188,-203,-166,-117,-62,-37,-49,-64,-81,-70,-63,-44,-36,-53,-62,-75,-79,-89,-108,-130,-141,-128,-108,-86,-77,-79,-102,-149},
            {-48,76,-109,138,-191,237,-230,6407,11724,-5728,-12602,4012,7820,-802,7195,8312,812,6131,8106,-2421,-8990,-3035,-4428,-9274,-5743,-2859,-4404,-2377,1785,2387,1216,1673,3355,2134,930,1304,276,-3,1002,689,-1523,-2592,-2194,-2192,-2513,-2450,-2374,-1940,-429,393,601,885,1249,1138,734,833,1183,870,129,-274,-633,-961,-968,-835,-942,-1025,-939,-637,-388,-80,265,402,389,463,546,408,316,347,133,-275,-453,-402,-365,-331,-290,-401,-497,-408,-156,-36,63,149,51,-35,53,138,66,-86,-281,-345,-220,-54,4,-26,-182,-289,-193,-39,13,-26,-106,-211,-132,96,157,88,15,-120,-242,-213,-111,-105,-71,-67,-128,-99,-10,-11}
        },
        {    // H20e125a.wav
            {-1,-1,2,1,2,1,0,-1,-1,-2,0,-1,-1,-2,-1,0,2,0,3,-2,1,-2,14,4,2,13,475,2002,1611,-543,-835,-524,-687,1542,4324,3088,1293,2081,2092,271,-518,-851,-2029,-2125,-1219,-1104,-1250,-543,235,404,610,886,796,501,379,274,-66,-392,-395,-478,-863,-1009,-941,-869,-672,-411,-283,-236,-141,-37,48,213,326,215,10,-94,-188,-346,-400,-528,-666,-605,-475,-284,-170,-104,-59,-42,-37,-79,-87,-79,-48,-66,-124,-191,-180,-124,-153,-201,-238,-214,-146,-82,-45,-48,-58,-54,-54,-48,-34,-35,-45,-64,-78,-94,-111,-130,-132,-131,-129,-98,-74,-69,-85,-112,-155,-174},
            {-22,16,-19,5,4,-36,-2,1569,10764,4293,-11783,-3940,8364,722,1257,11325,3835,2196,8719,3651,-7452,-5960,-2160,-7876,-8083,-3222,-3617,-4066,326,2621,1186,998,2901,2841,949,1318,1163,-202,400,1101,-517,-2400,-2378,-2117,-2501,-2428,-1921,-1967,-1165,104,474,684,1035,1134,758,665,1008,1023,361,-94,-348,-736,-944,-888,-863,-941,-918,-699,-479,-258,108,376,380,367,467,376,253,290,246,-122,-379,-376,-349,-344,-297,-324,-434,-427,-264,-136,-50,104,98,-19,-3,97,63,-42,-177,-287,-266,-136,-32,-14,-93,-216,-201,-74,-19,-47,-85,-152,-162,-25,100,85,42,-56,-193,-231,-137,-80,-92,-82,-123,-160,-105,-28}
        },
        {    // H20e130a.wav
            {0,1,1,1,1,1,-1,0,-1,-1,-1,-1,-2,0,-1,4,-1,3,-3,0,0,6,11,4,10,431,2082,1853,-581,-1036,-542,-636,1587,4531,3231,1224,2084,2161,203,-829,-1082,-2061,-2312,-1394,-1088,-1319,-701,164,284,608,1102,834,461,687,776,241,-100,-51,-361,-960,-1258,-1313,-1182,-883,-555,-372,-262,-108,41,163,254,310,206,54,-4,-86,-205,-351,-575,-673,-656,-531,-348,-275,-210,-105,-40,-67,-73,2,53,6,-34,-99,-182,-161,-146,-194,-239,-238,-223,-188,-114,-51,-57,-80,-53,-40,-44,-27,-5,-24,-61,-89,-112,-132,-133,-143,-159,-132,-89,-58,-49,-73,-124,-169,-169,-115},
            {25,-52,65,-90,111,-152,188,-182,5180,10311,-3817,-9821,3575,4764,-2856,7847,10133,815,5517,8008,-1943,-7995,-2930,-4520,-9116,-5279,-2700,-4468,-2027,2201,1502,485,2157,3113,1656,862,1682,572,-204,763,462,-1593,-2475,-2113,-2361,-2623,-1935,-1487,-1523,-554,295,543,852,1073,831,548,771,1001,596,64,-131,-444,-808,-894,-799,-847,-875,-734,-509,-374,-101,257,402,330,372,357,173,174,258,44,-272,-312,-304,-337,-296,-256,-353,-405,-315,-207,-163,-19,101,30,-41,29,57,-23,-90,-183,-247,-204,-109,-46,-15,-71,-147,-117,-60,-71,-73,-89,-150,-133,4,63,20,3,-80,-179,-165,-108,-123,-120,-120,-174,-159,-36}
        },
        {    // H20e135a.wav
            {0,1,2,1,0,-1,-1,-1,0,0,0,-2,0,0,2,0,4,-2,0,-1,4,10,6,14,383,2171,2110,-585,-1247,-571,-608,1567,4781,3484,1215,2084,2241,111,-1043,-1104,-2212,-2774,-1659,-1034,-1287,-729,156,268,485,960,956,560,535,747,607,364,213,-27,-603,-1188,-1488,-1450,-1154,-801,-572,-417,-194,-7,201,410,433,205,-4,-26,-16,-97,-355,-512,-577,-622,-501,-412,-345,-271,-191,-172,-175,-59,102,125,75,50,-71,-164,-176,-149,-183,-272,-266,-225,-201,-134,-56,-58,-83,-79,-78,-55,-3,19,-12,-46,-77,-122,-147,-143,-152,-168,-159,-109,-53,-27,-50,-116,-167,-166,-113,-55},
            {5,-3,-13,22,-43,65,-106,113,616,8125,6206,-7861,-4350,5430,-850,-54,12401,5904,1100,7826,4660,-5431,-6025,-2496,-7090,-7850,-3335,-3472,-3945,389,1987,232,1358,2815,2460,1060,1233,1479,132,17,673,-367,-2152,-2178,-2147,-2643,-2361,-1396,-1224,-1052,-139,371,671,999,957,527,527,792,680,268,33,-207,-590,-823,-744,-748,-819,-720,-522,-393,-281,32,337,377,293,311,172,57,133,132,-118,-279,-251,-293,-307,-220,-239,-352,-339,-232,-215,-165,-4,69,-15,-53,7,-16,-46,-92,-183,-229,-185,-95,0,44,-38,-118,-96,-83,-96,-71,-103,-178,-123,14,27,14,11,-90,-184,-175,-160,-177,-142,-112,-121,-59}
        },
        {    // H20e140a.wav
            {0,1,0,-1,-2,-2,-3,-2,-1,-2,-4,-2,-4,0,-2,1,-4,-5,-2,-6,12,-1,21,336,2240,2418,-585,-1490,-624,-578,1584,5014,3732,1212,2178,2374,16,-1322,-1247,-2159,-2982,-2111,-1366,-1279,-665,176,455,501,808,928,541,422,669,550,398,507,361,-284,-905,-1250,-1414,-1308,-983,-783,-684,-417,-102,151,370,498,373,60,-88,-56,-189,-350,-409,-524,-502,-420,-410,-356,-280,-264,-334,-298,-57,123,142,117,67,7,-118,-192,-167,-209,-258,-266,-261,-224,-135,-66,-59,-70,-102,-116,-97,-29,34,10,-53,-97,-118,-132,-139,-163,-188,-177,-133,-66,-30,-52,-108,-149,-145,-119,-75,-57},
            {-13,26,-38,32,-40,39,-48,42,-84,2289,9045,1454,-7650,1,2861,-3341,5607,12520,2291,3251,7772,1003,-6308,-4180,-3798,-7967,-5733,-2890,-4028,-2247,1449,563,378,2270,2631,1863,958,1441,1037,7,144,423,-1139,-2129,-1866,-2439,-2694,-1908,-1028,-1060,-637,106,444,792,1062,706,329,525,606,379,152,24,-278,-684,-754,-601,-682,-719,-542,-382,-354,-228,109,344,286,223,197,40,14,88,-11,-181,-218,-210,-278,-263,-173,-218,-303,-282,-243,-234,-137,-4,-2,-71,-62,-40,-55,-42,-83,-185,-215,-137,-29,70,62,-42,-101,-102,-116,-114,-75,-138,-182,-89,16,27,21,-30,-167,-226,-216,-198,-136,-59,-48,-65}
        },
        {    // H20e145a.wav
            {3,0,0,-1,-2,0,0,0,0,-2,-2,-1,2,0,2,-1,-3,2,-7,13,-1,30,302,2339,2724,-581,-1729,-686,-565,1637,5333,3986,1154,2256,2596,-46,-1595,-1432,-2212,-3086,-2363,-1590,-1491,-843,241,653,674,879,895,556,345,463,420,357,479,416,-39,-560,-967,-1184,-1080,-897,-852,-869,-681,-280,60,307,430,350,169,66,-128,-347,-340,-380,-433,-439,-393,-307,-264,-256,-347,-375,-244,-87,35,132,126,76,7,-94,-129,-146,-198,-247,-275,-272,-224,-134,-46,-31,-84,-111,-115,-93,-39,11,2,-54,-100,-127,-117,-111,-139,-173,-174,-129,-68,-27,-63,-110,-121,-121,-111,-74,-34,-61},
            {10,-14,27,-43,50,-67,86,-115,142,-97,4090,8108,-1691,-5477,1212,-397,-1949,10010,9917,951,5032,6187,-1392,-5892,-3516,-5164,-7309,-4278,-3183,-3596,-707,893,-117,1274,2439,2322,1497,1041,1357,688,-41,214,1,-1524,-1770,-1937,-2610,-2508,-1529,-807,-875,-333,322,601,815,957,584,231,310,378,255,96,14,-355,-699,-609,-486,-607,-565,-389,-345,-353,-179,152,272,200,174,109,-21,-13,18,-81,-166,-173,-226,-277,-195,-125,-182,-240,-260,-263,-227,-112,-26,-69,-110,-93,-83,-43,2,-73,-200,-191,-60,62,110,30,-72,-97,-97,-130,-117,-78,-140,-150,-64,8,-7,-34,-103,-221,-239,-184,-124,-59,-14,-33}
        },
        {    // H20e150a.wav
            {1,0,-2,-2,-1,-1,0,1,-2,-2,0,1,1,2,-1,-4,5,-11,16,-9,39,260,2436,3083,-603,-2019,-722,-561,1675,5689,4287,1070,2307,2840,-123,-1849,-1611,-2289,-3208,-2585,-1810,-1636,-915,96,635,896,1062,923,645,403,310,241,206,353,362,-84,-541,-760,-893,-829,-654,-608,-791,-809,-450,-83,180,338,302,132,-59,-161,-196,-363,-454,-396,-423,-408,-258,-169,-259,-343,-264,-179,-115,42,96,41,25,-28,-107,-138,-106,-136,-224,-280,-277,-238,-142,-23,-14,-76,-124,-123,-93,-25,18,-27,-97,-137,-139,-120,-100,-111,-157,-174,-122,-40,-17,-70,-122,-133,-119,-100,-69,-41,-37,-67},
            {3,4,-1,9,-24,35,-52,74,-108,133,183,5400,6399,-2910,-3763,399,-1978,1083,11855,7080,1087,5604,4498,-2628,-5349,-3592,-5754,-6210,-3686,-3280,-2646,-306,124,226,1749,2347,2105,1253,1102,1154,377,10,168,-447,-1353,-1657,-2176,-2518,-2220,-1299,-752,-591,-33,467,662,764,887,573,58,-55,239,276,77,-91,-403,-565,-483,-467,-508,-427,-346,-352,-378,-148,177,216,119,134,85,-55,-79,-32,-79,-167,-202,-246,-245,-140,-82,-143,-213,-267,-276,-219,-98,-42,-115,-166,-122,-63,-9,-5,-104,-176,-122,-7,80,88,5,-75,-92,-102,-139,-100,-66,-125,-144,-98,-69,-63,-54,-130,-209,-190,-139,-94,-34,-12}
        },
        {    // H20e155a.wav
            {0,-1,-2,-1,-1,0,1,-3,-1,0,1,2,0,2,-8,8,-12,17,-17,49,208,2517,3507,-587,-2392,-775,-522,1679,6077,4638,991,2327,3136,-162,-2209,-1782,-2373,-3313,-2733,-2043,-1840,-978,96,618,899,1199,1069,697,511,360,125,46,243,212,-259,-658,-787,-841,-673,-375,-347,-540,-570,-385,-193,37,262,267,-40,-256,-192,-240,-288,-313,-466,-554,-385,-203,-226,-273,-160,-108,-200,-93,103,122,2,-81,-101,-164,-174,-93,-114,-204,-234,-264,-246,-132,-18,-15,-79,-116,-121,-89,-25,16,-32,-110,-177,-197,-143,-85,-90,-147,-167,-108,-25,10,-40,-120,-150,-127,-91,-57,-44,-47,-57,-59},
            {-3,7,-5,9,-11,-1,4,-17,27,-53,53,661,6005,4924,-3103,-3276,-598,-1897,3770,11910,5105,1456,5418,3325,-3268,-4977,-3795,-5651,-5356,-3499,-2910,-2081,-574,2,617,1888,2303,1847,1126,1067,891,212,103,-62,-560,-1100,-1773,-2334,-2360,-1832,-1173,-753,-287,221,483,597,821,883,432,-159,-219,116,234,148,-173,-459,-463,-376,-457,-465,-366,-349,-386,-360,-79,163,172,97,132,55,-134,-132,-53,-87,-184,-237,-247,-199,-86,-68,-138,-230,-271,-258,-204,-85,-50,-113,-173,-157,-87,-7,-14,-112,-145,-86,-4,67,86,14,-75,-107,-127,-125,-45,-50,-160,-211,-155,-88,-54,-46,-115,-166,-165,-146,-104,-44}
        },
        {    // H20e160a.wav
            {-3,-2,-1,-2,-1,0,-3,-2,-2,0,2,-2,1,-11,10,-19,22,-30,57,158,2556,3979,-503,-2823,-870,-493,1660,6509,5049,897,2318,3441,-131,-2572,-2035,-2485,-3440,-2826,-2174,-2105,-1117,116,662,901,1290,1213,683,613,470,62,-12,211,90,-454,-875,-972,-890,-686,-366,-207,-209,-235,-185,-45,122,236,46,-235,-243,-261,-389,-338,-299,-442,-542,-467,-344,-244,-75,-36,-147,-143,8,133,102,2,-67,-162,-270,-209,-113,-159,-209,-215,-224,-214,-130,-24,-10,-66,-118,-138,-98,-12,16,-50,-128,-194,-235,-174,-83,-90,-167,-178,-92,2,40,-29,-123,-142,-104,-82,-73,-50,-56,-72,-60,-44},
            {0,-3,10,-7,15,-21,15,-17,14,-14,8,-19,1160,6154,3975,-3273,-3435,-927,-1165,5555,11298,3840,1574,5108,2576,-3683,-4733,-3782,-5266,-4907,-3223,-2447,-2087,-691,152,806,2037,2170,1645,998,932,750,203,-48,-113,-443,-1119,-1800,-2453,-2159,-1412,-1026,-761,-93,418,391,574,930,793,199,-184,-196,-23,185,151,-203,-491,-474,-380,-410,-436,-397,-333,-358,-286,-38,190,201,99,87,-38,-177,-156,-79,-94,-180,-235,-260,-178,-58,-60,-151,-257,-256,-209,-147,-65,-34,-89,-182,-185,-121,-41,-48,-101,-96,-53,-7,44,81,28,-65,-136,-146,-76,-11,-79,-215,-235,-146,-74,-27,-16,-83,-163,-187,-172,-129}
        },
        {    // H20e165a.wav
            {-3,0,-1,-1,0,-2,-4,1,0,4,-2,5,-15,15,-21,27,-35,62,107,2534,4491,-279,-3306,-1020,-447,1545,6942,5587,811,2258,3764,-21,-2917,-2309,-2616,-3618,-2938,-2219,-2298,-1325,69,758,963,1232,1420,830,544,579,99,-131,206,186,-590,-1143,-1142,-1060,-838,-420,-210,-146,35,130,172,383,329,-56,-237,-282,-352,-446,-424,-393,-506,-583,-546,-408,-137,44,-53,-118,-59,50,147,118,20,-68,-152,-246,-289,-197,-153,-225,-237,-228,-195,-91,17,17,-77,-131,-121,-91,-29,17,-49,-145,-206,-221,-175,-104,-93,-157,-191,-124,2,84,32,-95,-145,-104,-61,-42,-42,-78,-98,-64,-22,-50},
            {-8,3,-4,9,-7,15,-23,19,-27,25,-35,38,-50,1563,6134,3307,-3718,-3503,-733,-467,6655,10541,2850,1523,4955,1999,-4016,-4426,-3545,-4986,-4623,-2731,-2316,-2250,-531,211,1026,2095,1973,1487,791,849,796,76,-264,63,-380,-1245,-1897,-2300,-1894,-1289,-791,-563,-63,382,367,587,944,667,46,-104,-30,-61,-43,22,-175,-550,-622,-450,-389,-387,-341,-314,-299,-186,59,217,174,95,10,-140,-225,-138,-63,-121,-200,-260,-280,-197,-54,-46,-160,-222,-210,-186,-125,-23,-1,-106,-194,-212,-171,-99,-55,-60,-93,-74,-17,55,77,8,-81,-143,-137,-84,-24,-74,-206,-227,-144,-47,8,-7,-106,-212,-234,-207}
        },
        {    // H20e170a.wav
            {-1,-1,-1,0,-3,-3,1,0,5,-4,7,-18,14,-23,30,-40,61,66,2464,4996,82,-3815,-1267,-385,1360,7350,6257,760,2145,4079,117,-3227,-2618,-2776,-3795,-3102,-2259,-2433,-1524,-23,793,1156,1209,1368,1084,639,595,144,-265,141,275,-541,-1293,-1427,-1231,-968,-612,-278,-90,66,198,461,563,394,241,-50,-348,-404,-460,-532,-471,-577,-781,-699,-268,10,-46,-66,-34,-39,20,147,170,37,-61,-117,-248,-309,-210,-195,-266,-252,-244,-225,-98,58,59,-68,-131,-137,-112,-33,5,-52,-154,-213,-223,-168,-98,-101,-167,-205,-136,-20,60,53,-30,-104,-114,-77,-30,-15,-69,-137,-125,-50,-23,-68},
            {-1,-6,1,-2,7,-6,12,-20,15,-29,30,-40,47,-38,1848,6083,2665,-4235,-3210,-428,36,7359,9698,2007,1547,4898,1429,-4176,-3963,-3318,-4868,-4193,-2329,-2512,-2183,-382,269,1268,1992,1844,1259,602,969,791,-187,-266,153,-366,-1301,-1992,-1965,-1722,-1274,-507,-248,-118,174,406,634,839,597,143,-39,43,-1,-251,-254,-305,-611,-730,-565,-347,-248,-235,-214,-211,-121,119,251,126,27,-23,-184,-232,-118,-59,-163,-258,-298,-313,-193,-29,10,-93,-182,-206,-181,-82,21,3,-134,-213,-213,-178,-105,-76,-92,-107,-81,-11,81,93,-20,-133,-164,-117,-44,5,-69,-183,-191,-117,-33,3,-45,-168,-246,-237}
        },
        {    // H20e175a.wav
            {-3,0,-1,-3,-5,1,-1,6,-5,7,-18,14,-25,30,-42,60,32,2367,5428,570,-4246,-1603,-314,1118,7661,7003,799,1979,4384,292,-3547,-2870,-2974,-4014,-3221,-2301,-2535,-1698,-156,739,1340,1397,1234,1082,886,689,212,-313,-59,321,-394,-1382,-1623,-1458,-1158,-674,-359,-198,63,323,362,494,728,523,80,-153,-300,-515,-522,-502,-769,-956,-629,-205,-129,-53,17,-18,-90,-33,158,177,75,6,-97,-268,-306,-184,-171,-273,-320,-297,-227,-80,67,41,-71,-113,-119,-117,-72,-24,-51,-127,-204,-234,-185,-90,-74,-158,-211,-153,-24,73,56,-44,-116,-101,-40,1,-8,-74,-157,-164,-84,-35,-53,-122},
            {0,-1,-5,2,-1,7,-5,11,-20,15,-26,31,-39,52,-13,2066,5983,1934,-4545,-2655,-272,446,7756,8758,1393,1677,4771,919,-4080,-3498,-3244,-4647,-3692,-2262,-2638,-1980,-335,421,1393,1865,1673,952,665,1131,545,-326,-212,162,-309,-1330,-1939,-1795,-1542,-1069,-401,-115,-45,44,351,668,780,620,265,-26,-11,-31,-350,-541,-631,-724,-686,-505,-313,-169,-68,-63,-141,-116,106,244,117,10,-45,-189,-255,-139,-77,-213,-325,-337,-299,-139,36,33,-74,-150,-173,-157,-75,26,-12,-125,-215,-231,-175,-103,-71,-129,-148,-93,15,110,61,-69,-164,-140,-64,10,25,-76,-149,-159,-105,-65,-43,-71,-178,-236}
        },
        {    // H20e180a.wav
            {0,0,-4,-5,2,-3,6,-7,8,-20,15,-26,28,-42,54,9,2234,5765,1203,-4528,-2081,-258,809,7826,7842,1017,1810,4592,568,-3840,-3167,-3140,-4305,-3401,-2293,-2612,-1836,-271,597,1421,1687,1377,870,928,983,264,-300,-166,207,-294,-1348,-1819,-1662,-1335,-817,-394,-180,55,157,289,623,785,595,269,-23,-161,-279,-426,-624,-883,-822,-571,-402,-257,-81,54,1,-139,-97,116,217,129,23,-92,-223,-272,-184,-126,-244,-341,-345,-266,-80,53,49,-71,-142,-132,-125,-66,-15,-39,-127,-198,-235,-197,-88,-66,-135,-197,-133,10,90,41,-72,-135,-114,-45,24,32,-61,-165,-183,-110,-46,-44,-99,-187},
            {0,0,-4,-5,2,-3,6,-7,8,-20,15,-26,28,-42,54,9,2234,5765,1203,-4528,-2081,-258,809,7826,7842,1017,1810,4592,568,-3840,-3167,-3140,-4305,-3401,-2293,-2612,-1836,-271,597,1421,1687,1377,870,928,983,264,-300,-166,207,-294,-1348,-1819,-1662,-1335,-817,-394,-180,55,157,289,623,785,595,269,-23,-161,-279,-426,-624,-883,-822,-571,-402,-257,-81,54,1,-139,-97,116,217,129,23,-92,-223,-272,-184,-126,-244,-341,-345,-266,-80,53,49,-71,-142,-132,-125,-66,-15,-39,-127,-198,-235,-197,-88,-66,-135,-197,-133,10,90,41,-72,-135,-114,-45,24,32,-61,-165,-183,-110,-46,-44,-99,-187}
        }
    },
    {    // elev30
        {    // H30e000a.wav
            {5,6,-7,20,-39,55,-86,127,-163,207,93,5125,5683,-325,-3557,-7833,1643,5327,6140,12244,5368,-2342,1542,1864,-6291,-7851,-6563,-4757,-3265,-2425,-783,-732,1418,2826,1586,2088,2401,1556,1074,484,-603,-33,-310,-476,-275,-1016,-1580,-1681,-1244,-800,-212,-103,24,683,1268,1233,1059,907,37,-1098,-1612,-1562,-1192,-1252,-1445,-1205,-574,32,174,120,112,197,120,187,365,400,168,-141,-318,-402,-499,-483,-342,-299,-345,-312,-157,47,212,176,-2,-147,-140,-82,2,59,-23,-243,-341,-249,-151,-94,-139,-235,-257,-138,29,146,113,-44,-164,-173,-122,-66,-64,-138,-203,-180,-99,19,91,47,-49,-102,-62,3,33,-9},
            {5,6,-7,20,-39,55,-86,127,-163,207,93,5125,5683,-325,-3557,-7833,1643,5327,6140,12244,5368,-2342,1542,1864,-6291,-7851,-6563,-4757,-3265,-2425,-783,-732,1418,2826,1586,2088,2401,1556,1074,484,-603,-33,-310,-476,-275,-1016,-1580,-1681,-1244,-800,-212,-103,24,683,1268,1233,1059,907,37,-1098,-1612,-1562,-1192,-1252,-1445,-1205,-574,32,174,120,112,197,120,187,365,400,168,-141,-318,-402,-499,-483,-342,-299,-345,-312,-157,47,212,176,-2,-147,-140,-82,2,59,-23,-243,-341,-249,-151,-94,-139,-235,-257,-138,29,146,113,-44,-164,-173,-122,-66,-64,-138,-203,-180,-99,19,91,47,-49,-102,-62,3,33,-9}
        },
        {    // H30e006a.wav
            {-3,15,-5,16,-8,4,7,-15,51,-59,93,775,5641,3564,-726,-4460,-5478,3075,3840,7762,10372,2664,-1023,2484,31,-5909,-6852,-6342,-3684,-2836,-2404,-877,-191,1627,2070,1733,2116,1956,1461,986,-117,-328,325,-368,-204,-323,-1122,-1616,-1549,-1077,-514,-125,-85,528,1123,802,691,883,398,-449,-1155,-1373,-1177,-939,-1066,-1145,-1018,-471,2,-50,-50,95,154,45,135,318,343,120,-147,-343,-438,-436,-369,-279,-239,-244,-166,-60,70,154,76,-69,-148,-103,-61,-10,32,-40,-204,-266,-229,-135,-77,-125,-218,-210,-100,30,126,74,-43,-133,-143,-93,-48,-73,-160,-211,-178,-65,63,89,19,-53,-70,-35,24,48},
            {17,-21,36,-63,80,-116,154,-194,241,-90,4963,7197,-51,-3757,-9276,473,6608,6570,13171,6856,-2866,205,2695,-6366,-9256,-7055,-4541,-3532,-3039,-281,-577,760,3239,2051,1859,2439,1884,1064,729,-397,-297,-415,-522,-312,-1204,-1710,-1612,-1095,-874,-273,48,-519,-105,1480,1709,1244,1191,328,-864,-1534,-1800,-1611,-1549,-1383,-1023,-710,-115,376,328,116,221,132,188,375,473,238,-139,-312,-426,-503,-451,-327,-350,-436,-390,-205,22,227,277,105,-175,-200,-92,15,64,-19,-258,-396,-285,-170,-103,-122,-232,-277,-150,76,218,145,-45,-196,-207,-164,-56,-11,-109,-201,-206,-104,21,103,53,-48,-100,-81,4,42,-4,-71}
        },
        {    // H30e012a.wav
            {0,-4,13,-6,15,-12,6,-5,-3,21,-24,39,826,4904,3140,-521,-3879,-4487,2052,3647,7299,8871,2938,-261,2210,176,-4913,-6571,-5742,-3170,-2971,-2456,-754,-203,1178,1931,1668,1807,1833,1500,747,-200,105,402,-394,-213,-321,-1057,-1499,-1370,-879,-253,-160,-263,544,1111,521,179,532,308,-548,-1065,-1077,-981,-848,-796,-782,-910,-653,-197,-83,-154,-55,49,-39,49,208,246,64,-144,-307,-402,-395,-288,-179,-165,-168,-104,-56,14,89,27,-109,-169,-145,-102,-33,5,-47,-176,-240,-233,-166,-90,-102,-174,-196,-114,25,105,47,-63,-146,-165,-113,-54,-82,-164,-198,-155,-76,18,53,-5,-74,-85,-33,30},
            {-21,46,-76,85,-116,146,-174,204,-169,4244,8731,1050,-4022,-10399,-1260,7248,6787,14635,8373,-2969,-698,2577,-6047,-9911,-8281,-5141,-2526,-3474,-1015,189,708,2747,2245,2283,2254,1875,1312,966,-153,-326,-520,-645,-205,-1354,-1942,-1791,-1040,-617,-239,-248,-787,-249,1108,1815,1625,1157,539,-430,-1360,-2119,-2070,-1614,-1131,-920,-870,-126,420,499,206,191,157,153,285,459,394,-81,-412,-481,-471,-421,-329,-357,-466,-427,-229,-4,270,355,162,-161,-232,-130,-11,46,-19,-263,-447,-387,-238,-105,-103,-208,-275,-120,102,246,193,-18,-215,-284,-192,-29,40,-65,-210,-257,-166,27,133,58,-59,-115,-86,-7,52,15,-56,-142}
        },
        {    // H30e018a.wav
            {-3,0,-4,10,-4,10,-10,3,-4,-5,18,-15,16,741,4165,2945,-217,-3249,-4131,1447,3494,6363,7952,3177,175,2163,485,-4286,-5876,-4925,-3123,-3014,-2272,-795,-428,897,1702,1456,1630,1766,1482,655,25,299,211,-359,-52,-292,-934,-1140,-1052,-713,-382,-488,-327,514,677,150,119,361,217,-434,-928,-880,-732,-634,-666,-635,-748,-694,-399,-188,-159,-187,-164,-114,18,57,80,69,-68,-237,-285,-283,-209,-80,-59,-125,-130,-85,-14,27,-15,-112,-194,-204,-130,-28,-1,-78,-178,-223,-205,-132,-75,-92,-144,-139,-89,4,67,19,-98,-177,-161,-115,-72,-65,-107,-153,-155,-111,-36,5,-22,-67,-69,-21},
            {38,-66,72,-91,108,-104,115,-132,3004,9678,3452,-3922,-11353,-3740,7249,6868,14940,11458,-2129,-2214,2834,-5683,-10421,-8954,-6825,-2486,-2321,-1674,-319,1079,3048,1829,2082,2741,1838,1173,1307,236,-311,-495,-756,-77,-1315,-2205,-1937,-1086,-587,-334,-608,-584,-128,535,1827,1803,1035,561,-15,-1064,-2532,-2530,-1162,-654,-1088,-1082,-188,576,653,178,173,166,137,283,374,389,54,-417,-572,-460,-430,-339,-328,-392,-420,-292,-10,332,410,232,-115,-280,-187,-31,67,-27,-269,-489,-475,-327,-135,-90,-172,-228,-143,75,307,306,24,-254,-309,-182,1,82,-46,-225,-286,-206,-13,143,98,-46,-145,-117,-18,78,60,-20,-123,-203}
        },
        {    // H30e024a.wav
            {0,-3,-2,-2,8,-3,7,-6,0,2,-9,25,-23,20,573,3475,2860,182,-2818,-3913,1140,3028,5531,7314,3250,580,2222,659,-3642,-4864,-4370,-3230,-2822,-2093,-998,-633,669,1410,1306,1531,1765,1538,530,52,340,219,-174,31,-104,-548,-870,-1067,-875,-583,-701,-447,261,277,37,215,283,179,-235,-762,-722,-528,-527,-600,-588,-644,-637,-515,-325,-220,-269,-335,-251,-61,-21,32,79,9,-113,-157,-175,-126,-40,-48,-100,-147,-151,-67,0,-34,-133,-217,-220,-136,-60,-48,-84,-161,-195,-157,-80,-55,-82,-114,-123,-90,-29,7,-24,-97,-150,-157,-129,-71,-47,-89,-141,-156,-127,-66,-24,-25,-50,-63},
            {-39,34,-51,36,-10,-13,8,1572,9454,6533,-2451,-12225,-6635,6353,6701,14882,13451,692,-2577,1658,-4328,-10416,-9975,-8388,-3337,-2047,-1425,-59,275,2992,2756,1714,2101,2336,1418,975,717,-30,-445,-925,125,-1105,-2396,-2154,-1080,-548,-1231,-619,137,-301,212,1682,1744,1064,655,8,-1209,-2569,-2412,-834,-431,-1042,-1206,-303,535,681,278,126,165,173,254,312,391,99,-398,-626,-546,-446,-329,-288,-301,-384,-298,-54,318,462,334,-60,-332,-242,-67,58,-10,-247,-537,-566,-409,-177,-50,-133,-272,-223,32,330,389,114,-204,-289,-177,-7,81,-32,-229,-323,-254,-56,134,111,-23,-149,-164,-51,85,105,16,-101,-199,-167}
        },
        {    // H30e030a.wav
            {0,-1,-2,-2,-1,5,-2,4,-4,-2,4,-14,29,-31,26,379,2828,2826,554,-2441,-3660,756,2512,4849,6676,3335,980,2172,824,-2829,-3930,-4001,-3229,-2572,-2014,-1232,-752,409,1176,1284,1486,1713,1262,396,341,399,255,141,290,20,-512,-923,-1185,-976,-867,-998,-502,189,80,-53,265,399,255,-180,-606,-582,-433,-474,-592,-572,-553,-582,-574,-471,-360,-352,-392,-307,-137,-12,68,98,78,-14,-97,-107,-54,-39,-80,-121,-156,-180,-127,-54,-76,-126,-193,-221,-188,-109,-42,-57,-119,-158,-114,-62,-39,-68,-130,-152,-119,-44,-8,-33,-82,-131,-154,-142,-83,-56,-85,-121,-135,-116,-75,-38,-43,-61},
            {-19,22,-56,107,-167,227,321,7939,9301,723,-11888,-10517,5092,5777,13937,15930,2958,-1782,1982,-3871,-10191,-9437,-10804,-5157,-1488,-2152,-84,1027,2384,2482,2632,2249,1396,1716,1465,573,44,116,-1100,31,-538,-2390,-2302,-1302,-1010,-1720,-375,411,-194,33,1199,1770,1234,711,-217,-1674,-2348,-1521,-784,-795,-667,-937,-517,225,540,396,217,204,131,197,318,484,118,-365,-655,-682,-525,-318,-162,-211,-341,-293,-70,292,500,361,-12,-294,-280,-127,34,31,-189,-558,-650,-448,-169,-17,-116,-310,-309,-47,278,410,212,-53,-201,-189,-49,94,15,-218,-357,-310,-111,97,141,13,-135,-185,-80,71,129,60,-74,-184,-169,-93}
        },
        {    // H30e036a.wav
            {-3,0,0,-3,-1,-1,2,0,0,3,-4,6,-16,31,-34,30,220,2236,2744,890,-2009,-3435,336,2068,4190,6077,3475,1254,2042,1133,-2031,-3151,-3612,-3151,-2387,-1975,-1352,-867,273,1109,1053,1214,1599,1194,511,536,604,587,243,119,-69,-581,-1018,-1279,-1180,-1132,-1012,-335,105,-102,18,361,490,274,-197,-474,-480,-416,-471,-567,-527,-520,-628,-650,-556,-448,-355,-333,-272,-136,-29,105,120,60,46,-46,-96,-38,-19,-93,-181,-180,-182,-174,-121,-87,-103,-191,-223,-187,-98,-15,-14,-70,-140,-117,-66,-60,-84,-128,-151,-125,-68,-8,-28,-91,-130,-149,-135,-88,-53,-72,-105,-118,-104,-71,-62,-65},
            {57,-116,181,-236,309,-288,5323,10889,4702,-9252,-14561,2494,5774,10763,18074,6256,-1119,1936,-1357,-9952,-9763,-10619,-8291,-2532,-1947,-792,527,2784,3184,2104,2606,2051,1302,1004,1260,134,-53,-704,-107,-174,-2142,-2093,-1677,-2304,-1641,443,35,-151,231,592,1508,1587,833,-820,-2094,-1644,-697,-884,-1096,-515,-451,-572,-259,234,451,340,263,16,147,425,485,178,-247,-636,-793,-673,-351,-51,-142,-297,-249,-40,236,456,353,48,-242,-318,-216,5,90,-155,-541,-632,-455,-209,-48,-104,-284,-344,-162,123,375,331,94,-148,-224,-84,96,73,-159,-353,-377,-217,37,155,65,-112,-210,-106,59,132,72,-47,-167,-177,-105,-64}
        },
        {    // H30e042a.wav
            {-3,-2,0,-1,-3,-1,0,0,-1,2,6,-8,8,-18,32,-37,35,104,1679,2613,1182,-1509,-3193,-165,1668,3574,5564,3583,1435,1964,1445,-1289,-2482,-3204,-3057,-2240,-1837,-1355,-796,14,576,858,1361,1549,1049,843,990,610,340,105,-65,-267,-678,-1111,-1337,-1214,-1146,-849,-245,15,-63,77,345,483,249,-218,-432,-389,-412,-462,-544,-583,-594,-668,-634,-533,-374,-296,-278,-207,-116,-60,34,112,75,39,-31,-97,-62,-47,-98,-177,-228,-222,-190,-144,-106,-112,-153,-172,-136,-62,-11,-15,-81,-130,-124,-98,-75,-80,-110,-147,-143,-97,-34,-25,-78,-116,-137,-123,-79,-52,-67,-100,-109,-104,-84,-67},
            {-80,116,-138,152,-220,2361,10425,8837,-4462,-16885,-2722,6826,7265,17410,10597,442,1599,947,-8104,-9950,-10224,-10373,-4148,-2983,-1678,433,1712,3349,3321,2954,1524,2013,1501,658,178,399,-608,-608,484,-1706,-2107,-2138,-3238,-1751,821,326,-251,77,349,1281,1570,765,-1102,-2143,-1106,-330,-684,-983,-642,-278,-503,-496,-68,296,293,275,19,111,431,452,332,-71,-589,-797,-753,-422,-81,-103,-239,-186,-8,186,374,315,114,-219,-327,-272,-95,66,-78,-405,-586,-475,-270,-72,-80,-261,-369,-277,11,317,388,169,-104,-230,-158,61,122,-70,-304,-391,-313,-65,148,113,-60,-209,-163,14,131,98,-17,-152,-200,-116,-51,-52}
        },
        {    // H30e048a.wav
            {-1,-2,-1,0,0,-2,-1,0,-1,1,3,9,-8,11,-17,29,-32,37,28,1208,2399,1418,-944,-2972,-710,1340,3077,5075,3634,1617,1866,1730,-622,-1917,-2781,-2888,-1943,-1533,-1471,-1223,-294,590,940,1357,1550,1314,968,712,377,119,-162,-332,-394,-680,-1020,-1163,-1152,-1105,-605,-94,-74,-107,96,303,379,143,-225,-358,-354,-399,-528,-634,-611,-591,-588,-507,-393,-312,-261,-183,-179,-168,-125,4,91,64,-2,-85,-99,-84,-46,-96,-207,-260,-243,-184,-151,-106,-78,-83,-91,-110,-72,-41,-38,-74,-128,-133,-121,-87,-81,-119,-150,-146,-112,-44,-15,-55,-110,-128,-100,-69,-57,-83,-96,-105,-104,-71},
            {-31,72,-127,173,167,7472,11768,2425,-15580,-10531,6904,5703,13914,14083,3335,1592,2375,-4144,-10211,-9908,-10700,-6634,-3747,-3002,-805,869,3017,3061,3920,2687,1724,1750,1414,542,-404,-82,-524,234,-988,-1889,-2907,-3893,-1635,404,637,179,-105,7,1022,1507,504,-1132,-1769,-765,-378,-465,-504,-562,-407,-640,-546,-155,128,69,67,21,178,381,368,483,187,-436,-762,-685,-477,-239,-64,-103,-179,-67,133,327,316,154,-156,-360,-336,-183,4,-9,-210,-446,-503,-335,-91,-9,-203,-411,-368,-76,275,404,211,-70,-224,-197,-16,121,20,-217,-376,-356,-122,114,146,5,-161,-195,-60,92,117,40,-93,-198,-148,-45,-24,-71}
        },
        {    // H30e054a.wav
            {0,-1,-2,-2,0,-2,0,-2,-1,-3,1,3,8,-8,10,-13,18,-18,22,0,826,2106,1615,-414,-2722,-1237,1038,2686,4632,3630,1760,1817,1927,-42,-1407,-2207,-2437,-1890,-1848,-1615,-999,-279,497,1177,1571,1270,917,784,444,16,-183,-388,-418,-255,-500,-799,-1022,-1075,-834,-367,-172,-243,-127,74,193,215,49,-208,-324,-379,-502,-589,-619,-537,-432,-435,-384,-327,-255,-188,-184,-232,-217,-113,-41,0,0,-59,-89,-84,-83,-96,-139,-198,-247,-231,-186,-121,-64,-32,-31,-76,-113,-100,-64,-50,-82,-125,-156,-134,-97,-100,-120,-142,-122,-109,-67,-32,-47,-79,-106,-94,-81,-71,-80,-86,-88,-90},
            {105,-164,223,-318,3028,11447,9393,-8319,-18063,1934,7644,8549,15920,6653,2252,3089,-191,-7667,-9932,-10888,-8924,-4093,-4501,-2195,-389,1511,2949,3801,3653,2014,2816,1747,869,238,-77,-778,61,15,-2086,-3461,-4115,-2016,-299,679,780,-119,-143,709,1212,195,-904,-1166,-625,-473,-414,-76,-319,-318,-711,-868,-251,80,-20,-207,-191,33,319,422,535,372,-154,-578,-640,-486,-306,-130,3,-98,-152,-10,185,334,241,-38,-371,-469,-291,-76,61,-45,-325,-488,-364,-102,12,-117,-377,-425,-196,133,385,301,-10,-229,-266,-109,79,82,-140,-336,-355,-192,63,174,75,-104,-210,-133,36,113,63,-45,-159,-167,-70,-28,-44,-102}
        },
        {    // H30e060a.wav
            {3,-1,-1,-1,-1,0,0,1,-2,-1,-1,4,5,6,-5,10,-10,12,-7,9,3,549,1792,1732,57,-2464,-1702,759,2460,4269,3519,1879,1829,2071,573,-678,-1872,-2764,-1866,-1356,-1426,-935,-25,736,977,957,789,639,336,30,-149,-296,-324,-220,-41,-291,-602,-813,-896,-632,-343,-400,-352,-109,-14,46,67,-53,-232,-350,-461,-528,-506,-448,-346,-292,-345,-326,-246,-203,-224,-235,-247,-223,-165,-132,-75,-42,-65,-88,-93,-130,-134,-129,-163,-203,-208,-159,-72,-18,-16,-40,-82,-121,-118,-76,-71,-102,-127,-145,-140,-112,-89,-102,-123,-128,-120,-69,-27,-34,-67,-84,-93,-94,-70,-62,-63,-73},
            {82,-150,216,-68,6847,13114,3177,-17409,-10852,9387,6161,12664,12124,2806,3282,2620,-2925,-9207,-9658,-10557,-6821,-4409,-3566,-1749,-536,2277,2651,4239,2842,2366,3084,2039,790,-229,93,-161,56,-1366,-3689,-4596,-2742,-935,132,1000,250,-72,411,840,80,-927,-568,-208,-517,-521,43,79,-204,-477,-916,-710,-187,72,-178,-439,-316,-20,387,657,542,100,-341,-485,-440,-333,-164,26,8,-130,-139,-31,217,307,131,-277,-544,-448,-191,44,101,-149,-443,-393,-144,31,3,-256,-414,-325,-49,248,355,146,-170,-310,-253,-43,103,8,-258,-369,-253,-16,168,155,-17,-193,-195,-30,103,100,9,-125,-181,-114,-34,-30,-63,-106}
        },
        {    // H30e066a.wav
            {1,1,0,-1,-2,-2,-1,-1,0,-2,-3,-1,3,1,2,-4,6,-11,7,0,0,9,372,1491,1771,442,-2252,-2069,536,2365,3985,3347,1996,2084,2482,750,-988,-1570,-2034,-1530,-1163,-977,-578,-245,160,449,427,246,109,-61,78,79,-268,-184,129,182,-133,-380,-700,-830,-608,-504,-512,-363,-187,-170,-103,-71,-163,-294,-394,-389,-347,-341,-273,-206,-243,-303,-234,-234,-287,-250,-248,-295,-286,-206,-173,-134,-73,-74,-109,-133,-133,-116,-115,-124,-151,-155,-116,-56,-32,-48,-63,-94,-125,-135,-108,-94,-94,-118,-141,-124,-106,-99,-119,-132,-117,-102,-70,-43,-35,-47,-81,-101,-83,-55,-61,-65},
            {-28,29,-68,1193,10264,12284,-5173,-20350,-592,10709,6114,14208,7451,2408,3540,1677,-5136,-9758,-9079,-9160,-6084,-5058,-2534,-1719,-139,2110,3144,3747,2080,3303,2971,1945,893,196,94,415,-263,-3629,-4859,-3482,-2038,-736,707,580,-123,445,678,-139,-947,-314,325,-294,-563,-85,380,27,-337,-558,-917,-683,-142,-99,-379,-512,-440,-40,539,728,397,-116,-307,-289,-303,-186,9,117,-24,-198,-205,20,240,213,-108,-478,-573,-359,-78,125,48,-271,-418,-244,-3,73,-45,-295,-401,-244,60,283,256,-29,-268,-353,-227,9,98,-83,-309,-324,-151,101,194,93,-115,-234,-134,61,140,76,-58,-178,-190,-93,-30,-24,-62,-85}
        },
        {    // H30e072a.wav
            {1,2,1,1,0,-1,0,1,0,3,0,-1,0,4,1,5,1,6,-11,9,9,-3,16,301,1258,1764,732,-2207,-2355,471,2495,3872,3295,2434,2009,1690,868,-124,-981,-1633,-1005,-753,-1120,-1031,-682,-426,-153,-203,-331,27,282,322,98,-22,174,324,372,6,-442,-779,-800,-631,-573,-541,-461,-384,-289,-161,-223,-281,-255,-198,-189,-222,-180,-139,-172,-209,-243,-277,-300,-298,-280,-314,-329,-275,-244,-214,-138,-93,-109,-120,-106,-108,-91,-77,-66,-80,-115,-123,-92,-61,-66,-75,-100,-136,-138,-114,-90,-75,-84,-118,-137,-124,-112,-105,-103,-99,-97,-72,-38,-35,-39,-58,-74,-82,-70,-51},
            {-110,171,-301,2906,12630,9545,-12591,-17889,7294,9125,7089,13329,4692,2938,3376,824,-7080,-9479,-8093,-7979,-6264,-4868,-2229,-2117,586,1994,3313,3062,1991,3631,2969,1792,708,1026,736,215,-1685,-4492,-4497,-3193,-1649,-386,402,139,98,626,-48,-942,-552,639,379,-428,-378,430,572,-210,-448,-647,-873,-603,-259,-296,-488,-620,-455,63,521,589,256,-138,-166,-181,-154,-1,171,144,-131,-289,-192,75,194,30,-320,-575,-516,-280,-4,159,-26,-307,-372,-122,82,107,-81,-334,-364,-164,127,257,130,-184,-361,-353,-171,64,72,-160,-313,-261,-53,134,172,28,-179,-226,-64,120,145,50,-117,-227,-192,-77,-9,-23,-69,-75}
        },
        {    // H30e078a.wav
            {0,1,0,2,1,-2,0,0,0,2,1,-3,-1,-1,1,0,5,0,4,-15,18,3,6,0,311,1155,1770,808,-2496,-2464,823,3128,4162,2605,1472,2192,2470,1164,181,-282,-1152,-1262,-1186,-1427,-1598,-1223,-923,-919,-404,155,248,369,654,408,62,377,641,237,-275,-518,-798,-792,-596,-652,-726,-623,-437,-327,-285,-258,-160,-72,-46,-53,-99,-84,-106,-169,-248,-312,-297,-343,-348,-323,-324,-332,-312,-242,-195,-165,-149,-100,-75,-81,-69,-68,-29,-22,-79,-156,-164,-100,-81,-81,-101,-119,-129,-135,-101,-70,-63,-95,-137,-148,-132,-87,-82,-104,-105,-97,-69,-37,-18,-31,-60,-79,-85,-61},
            {-136,223,-366,4419,13835,6173,-17246,-13167,11523,7072,7787,11629,3714,3392,3507,27,-8552,-8660,-7017,-7478,-6520,-4317,-2510,-2387,752,2128,3414,2206,2425,3749,2689,1543,971,1531,1006,32,-2805,-4443,-3799,-2981,-1730,-496,178,-233,246,227,-918,-853,370,988,161,-346,42,858,477,-385,-526,-723,-819,-586,-395,-418,-579,-677,-420,86,411,402,145,-40,-59,-110,25,197,304,87,-254,-307,-139,71,74,-140,-438,-586,-483,-246,38,167,-53,-325,-314,-31,141,114,-121,-350,-309,-78,133,198,-3,-305,-427,-331,-81,94,38,-205,-306,-208,1,146,130,-24,-201,-191,-7,144,131,-1,-150,-235,-174,-53,-5,-41,-90,-64}
        },
        {    // H30e084a.wav
            {0,1,1,1,3,1,0,1,0,2,2,0,0,-3,2,4,0,7,4,0,-9,32,0,-6,-10,496,1196,1784,357,-3082,-1662,2242,3141,2518,2339,2585,2601,2626,1605,232,-748,-1308,-1614,-1958,-1828,-1863,-1941,-1242,-270,10,114,630,963,626,344,458,384,274,60,-324,-704,-782,-680,-754,-862,-772,-617,-495,-295,-175,-123,-45,59,107,28,-47,-79,-171,-256,-303,-321,-355,-376,-350,-332,-338,-322,-257,-242,-242,-182,-100,-47,-38,-44,-57,-30,-6,-70,-140,-153,-123,-118,-107,-97,-105,-107,-107,-101,-104,-78,-72,-100,-136,-129,-92,-79,-91,-102,-89,-75,-48,-25,-33,-37,-49,-73,-82},
            {-132,223,-346,5202,14226,3726,-19162,-9354,13143,5667,7646,10324,3675,3669,3929,-400,-9375,-7868,-6133,-7415,-6625,-3785,-2932,-2633,753,2015,3284,1924,2666,3885,2471,1096,1414,1832,641,-78,-2579,-4202,-3588,-2484,-1815,-1022,-122,-306,-58,-474,-1112,-393,802,1068,183,-162,477,1108,358,-473,-573,-752,-829,-581,-415,-503,-653,-685,-438,29,293,246,115,6,6,33,190,336,377,59,-299,-291,-119,24,-29,-235,-488,-590,-458,-224,60,159,-68,-297,-231,29,162,111,-142,-319,-251,-36,123,140,-101,-381,-442,-297,-19,120,20,-224,-294,-168,30,154,113,-52,-195,-143,31,129,106,-23,-153,-203,-138,-37,-26,-58,-89,-61}
        },
        {    // H30e090a.wav
            {-1,-1,0,1,2,2,1,0,-1,-1,0,0,1,-2,-3,4,1,3,3,2,-4,23,13,-18,-34,143,835,1424,1603,-859,-2770,-537,2057,3458,3026,2433,2967,3333,2326,560,-492,-1277,-1848,-2149,-2270,-2377,-2096,-1238,-539,-88,334,782,881,844,723,320,50,206,265,-145,-547,-774,-818,-820,-834,-856,-778,-536,-285,-142,-76,-9,90,181,145,-8,-134,-181,-245,-326,-345,-350,-388,-385,-333,-304,-293,-287,-299,-268,-192,-99,-37,-22,-42,-49,-44,-64,-78,-87,-105,-144,-147,-129,-106,-87,-95,-96,-106,-125,-104,-74,-72,-95,-119,-119,-91,-67,-76,-86,-75,-68,-47,-27,-29,-44,-64,-73},
            {-127,213,-352,4974,14122,3257,-19045,-8049,13396,5006,6623,9763,4056,3891,4373,-6,-9524,-7468,-5464,-7504,-6773,-3475,-3147,-3067,633,1906,2813,1781,2995,3943,2251,966,1631,1602,445,164,-2269,-3655,-3238,-2410,-1822,-1278,-609,-608,-429,-894,-1080,-158,941,1078,320,187,714,1152,402,-450,-620,-808,-838,-509,-391,-586,-708,-711,-477,-84,159,157,69,23,67,151,313,411,398,89,-250,-290,-154,-38,-74,-274,-538,-592,-445,-209,41,132,-76,-263,-158,64,155,93,-126,-289,-226,-23,103,89,-157,-410,-436,-265,-2,107,11,-221,-278,-147,41,142,104,-45,-179,-129,26,119,89,-23,-143,-181,-112,-35,-49,-85,-95,-57}
        },
        {    // H30e096a.wav
            {0,-1,0,2,2,2,1,0,-1,-1,1,2,0,0,-3,0,2,6,-1,1,10,15,15,-27,2,12,659,1411,2150,189,-3833,-1988,2713,3834,2871,2874,3111,2929,2524,946,-769,-1594,-1617,-2095,-2779,-2504,-1629,-1142,-797,79,623,673,818,1077,670,18,-50,139,230,-30,-423,-787,-937,-815,-776,-845,-758,-517,-290,-134,-15,51,121,189,129,-29,-163,-189,-260,-358,-358,-368,-385,-368,-297,-242,-299,-323,-294,-261,-186,-75,-29,-65,-59,-68,-105,-103,-39,-26,-112,-147,-131,-111,-104,-96,-89,-116,-123,-123,-106,-71,-60,-86,-119,-115,-73,-45,-63,-90,-84,-71,-50,-27,-34,-43,-58,-73},
            {-111,176,-332,3767,13515,4877,-17341,-9339,12717,5250,4794,9835,4606,4054,4729,1238,-8907,-7621,-4832,-7554,-7151,-3498,-2987,-3641,269,1801,2442,1518,2971,4236,2042,961,1780,1168,288,706,-1857,-3362,-2746,-2219,-1967,-1528,-868,-1006,-903,-958,-1033,-283,915,1132,457,456,853,1142,460,-319,-555,-866,-854,-408,-352,-627,-773,-762,-521,-245,50,94,3,4,136,223,332,450,419,134,-181,-257,-193,-105,-92,-280,-554,-595,-451,-221,-11,95,-67,-247,-144,80,156,83,-118,-268,-227,-47,76,58,-166,-405,-416,-258,-20,68,-13,-207,-259,-142,26,118,98,-32,-175,-142,11,116,81,-29,-137,-170,-105,-44,-70,-106,-105,-64}
        },
        {    // H30e102a.wav
            {-1,0,0,2,2,2,0,-1,-1,-1,1,2,0,0,-3,4,-2,4,-1,-1,10,16,8,-14,-8,58,773,2128,2399,-1886,-4623,119,3748,3288,2963,3061,2573,2560,2333,226,-1238,-1292,-1648,-2521,-2530,-1784,-1535,-1087,-239,395,440,672,1074,852,235,-105,-82,9,162,-82,-557,-769,-815,-835,-799,-674,-553,-477,-318,-100,67,137,166,123,-9,-105,-150,-219,-318,-373,-403,-402,-338,-288,-242,-252,-309,-284,-253,-228,-154,-55,-61,-114,-122,-159,-146,-37,18,-64,-134,-117,-95,-80,-82,-105,-130,-135,-127,-124,-82,-60,-84,-113,-114,-63,-37,-49,-79,-93,-77,-62,-43,-35,-28,-42,-86,-121},
            {-49,63,-158,1943,11893,8056,-13701,-12356,10354,6724,2347,10007,5663,3856,5048,3058,-7256,-8332,-4196,-7285,-7773,-4070,-2516,-4094,-507,1731,2136,1435,2554,4362,2119,963,1776,1020,170,999,-1112,-3031,-2637,-1961,-1811,-1879,-1205,-1121,-1192,-1065,-1018,-437,640,1151,680,554,850,1159,581,-205,-381,-769,-875,-395,-278,-581,-803,-841,-593,-354,-61,33,-24,-21,169,270,310,413,433,215,-123,-223,-190,-125,-117,-257,-488,-582,-478,-258,-75,50,-45,-205,-172,52,168,92,-93,-254,-226,-91,40,54,-117,-340,-386,-276,-68,36,-11,-188,-244,-141,0,111,98,-27,-166,-131,6,99,78,-22,-120,-147,-104,-61,-80,-100,-108,-88}
        },
        {    // H30e108a.wav
            {-1,0,2,2,1,1,0,-1,-1,0,2,2,-1,-1,0,5,0,-1,-2,8,6,11,2,2,-14,329,1860,2651,-320,-3911,-2014,2272,3690,3591,2852,2145,2529,2499,611,-916,-967,-1302,-2109,-2357,-1847,-1479,-1070,-429,152,512,607,796,910,467,-77,-220,-153,-3,-101,-415,-672,-707,-686,-770,-741,-494,-341,-365,-283,-74,161,252,133,-30,-131,-166,-187,-287,-390,-426,-437,-383,-255,-201,-248,-291,-235,-207,-206,-151,-113,-98,-115,-180,-261,-206,-57,13,-30,-107,-115,-78,-66,-58,-74,-111,-159,-161,-121,-96,-73,-80,-126,-126,-72,-28,-29,-65,-89,-90,-65,-47,-30,-23,-36,-88,-144,-137},
            {40,-87,105,345,8689,11259,-7604,-15038,5324,8937,272,8917,7900,3289,4992,5029,-4216,-9238,-3965,-6314,-8443,-5143,-2271,-4023,-1771,1581,1882,1473,2041,4218,2290,967,1757,1065,188,1016,-224,-2505,-2614,-1966,-1633,-1972,-1603,-1183,-1278,-1097,-1045,-577,271,979,924,620,727,1054,756,-17,-231,-550,-803,-475,-207,-463,-783,-889,-678,-451,-193,-18,-7,-29,157,292,265,331,394,298,-38,-193,-189,-109,-102,-206,-382,-528,-498,-305,-147,-26,-17,-133,-183,-21,142,102,-43,-211,-236,-146,-9,49,-20,-218,-338,-302,-138,9,12,-136,-244,-157,-15,94,92,-1,-118,-121,-9,74,59,1,-65,-116,-117,-71,-70,-99,-109,-92}
        },
        {    // H30e114a.wav
            {1,2,2,2,1,0,1,-1,1,2,3,-1,2,1,2,4,3,-1,0,9,8,10,-6,16,195,1704,2634,-3,-3043,-2226,1138,3277,3783,3017,2131,2477,2394,657,-871,-1062,-1359,-1808,-1937,-1800,-1507,-1077,-279,329,468,568,874,977,487,-23,-156,-185,-199,-242,-529,-786,-725,-632,-626,-625,-511,-340,-238,-194,-134,24,246,232,27,-117,-206,-230,-275,-376,-496,-497,-388,-283,-239,-214,-202,-219,-167,-119,-94,-87,-112,-160,-238,-299,-253,-109,-20,-41,-97,-100,-63,-53,-46,-60,-75,-107,-151,-153,-110,-63,-77,-124,-135,-96,-39,-27,-47,-70,-86,-72,-44,-13,-8,-44,-102,-138,-122,-87},
            {70,-123,170,-243,4364,12157,587,-14674,-2223,9859,357,5390,10830,3655,3854,6423,175,-9024,-5126,-4458,-8686,-6583,-2644,-3456,-3168,948,1796,1505,1632,3743,2656,844,1698,1272,297,760,659,-1640,-2616,-1997,-1646,-2058,-1852,-1171,-1340,-1198,-875,-644,-133,620,1028,726,599,813,829,221,-85,-297,-650,-542,-214,-328,-711,-853,-731,-569,-349,-65,26,-6,107,271,213,219,305,310,62,-162,-190,-120,-62,-114,-254,-438,-482,-370,-234,-123,-21,-67,-164,-89,52,62,-1,-149,-248,-205,-59,35,46,-74,-252,-301,-213,-49,8,-78,-207,-178,-61,31,73,54,-42,-120,-67,29,52,23,-17,-84,-119,-86,-66,-103,-108,-76}
        },
        {    // H30e120a.wav
            {3,2,2,1,0,1,0,1,2,2,1,0,1,4,2,2,0,1,7,0,12,-1,16,199,1742,2565,-91,-2641,-1964,658,3052,4000,2905,1815,2536,2636,602,-1048,-1184,-1486,-1984,-1935,-1626,-1421,-1046,-238,413,612,838,943,882,737,231,-245,-252,-55,-241,-777,-1011,-904,-800,-664,-540,-389,-276,-231,-136,-35,93,198,185,64,-40,-145,-272,-329,-395,-511,-576,-468,-318,-302,-250,-174,-126,-115,-96,-17,-11,-75,-181,-296,-344,-258,-131,-86,-96,-111,-112,-98,-45,-15,-52,-82,-83,-106,-128,-114,-90,-81,-105,-133,-122,-74,-45,-52,-76,-84,-70,-36,-3,-5,-54,-123,-140,-104,-66,-68},
            {-3,14,-37,20,857,9011,8190,-8914,-9511,6587,3190,622,11551,6847,2036,6085,4748,-5821,-7474,-3160,-7287,-8206,-3833,-2726,-4095,-568,1770,1458,1457,2937,3057,918,1454,1478,631,394,987,-273,-2268,-2162,-1658,-2162,-2225,-1178,-1162,-1414,-873,-451,-303,110,867,889,514,562,722,441,40,-104,-374,-523,-332,-231,-551,-761,-720,-637,-501,-189,55,49,43,196,195,88,163,260,152,-103,-176,-146,-77,-31,-86,-296,-446,-412,-312,-205,-76,-29,-127,-143,-47,-5,-25,-103,-225,-235,-118,9,65,26,-131,-231,-237,-145,-52,-35,-121,-176,-126,-54,37,82,38,-99,-124,-35,35,44,11,-48,-104,-97,-67,-89,-99,-68}
        },
        {    // H30e126a.wav
            {3,0,0,-1,-2,0,-1,1,0,-2,0,-2,2,1,0,-3,-4,7,0,8,-11,15,253,1897,2519,-343,-2526,-1698,610,3044,4140,2836,1717,2530,2452,414,-1002,-1147,-1749,-2204,-1818,-1814,-1747,-888,-52,406,684,990,1073,1016,874,373,-102,-131,-41,-226,-639,-1076,-1192,-1086,-859,-633,-464,-222,-81,-109,-37,189,305,216,50,-50,-109,-199,-326,-458,-562,-580,-510,-465,-375,-268,-192,-115,-96,-10,44,37,-39,-179,-278,-316,-272,-175,-127,-153,-143,-151,-140,-77,-28,-31,-65,-88,-100,-99,-90,-71,-90,-117,-132,-125,-92,-71,-72,-106,-110,-75,-22,7,-21,-87,-136,-125,-95,-70,-66,-98},
            {-43,70,-104,128,-189,3561,10449,1105,-11168,-1329,5558,-1392,7259,11616,2551,3429,7149,277,-7925,-4539,-4532,-8520,-6009,-2608,-3812,-2745,1145,1484,1388,2177,2976,1464,1090,1592,967,405,623,713,-1054,-2090,-1900,-2052,-2569,-1611,-883,-1358,-1131,-432,-154,-110,394,908,607,341,497,528,184,-43,-145,-331,-428,-291,-363,-635,-637,-577,-570,-402,-15,115,46,69,151,29,-18,143,193,-8,-147,-147,-126,-47,24,-90,-350,-418,-347,-267,-164,-34,-79,-174,-146,-93,-93,-101,-154,-235,-195,-47,55,70,-22,-129,-189,-203,-136,-54,-33,-136,-178,-132,-21,55,58,-33,-135,-90,-14,21,12,-9,-54,-93,-80,-71,-83,-74}
        },
        {    // H30e132a.wav
            {3,0,0,-1,1,0,1,1,-1,1,1,3,3,2,-1,-2,2,8,11,-6,13,332,2152,2484,-674,-2527,-1486,702,3294,4348,2686,1638,2647,2403,107,-1304,-1301,-1780,-2226,-1793,-1846,-1968,-1087,-157,562,835,979,1192,1098,932,544,92,-47,59,-61,-557,-1015,-1107,-1151,-1167,-897,-565,-348,-179,-13,101,203,330,330,165,-1,-135,-233,-255,-392,-621,-632,-557,-486,-407,-339,-191,-144,-110,4,104,93,-38,-138,-190,-230,-244,-196,-181,-175,-184,-213,-167,-91,-23,-35,-83,-86,-75,-80,-63,-42,-65,-107,-131,-119,-105,-72,-74,-120,-137,-84,-10,15,-28,-114,-143,-109,-65,-44,-70,-99,-112},
            {13,-30,51,-79,94,208,6170,8673,-4161,-8256,2444,855,725,12101,7741,1055,5536,5851,-3470,-7017,-3555,-6280,-7803,-4144,-2829,-3960,-922,1481,1251,1806,2327,2067,1101,1370,1324,707,308,722,194,-1137,-1941,-2192,-2466,-2243,-1056,-1034,-1306,-638,-125,-42,142,633,728,342,259,424,293,15,-47,-177,-336,-397,-307,-437,-527,-455,-473,-525,-261,88,130,34,10,12,-99,-31,136,97,-75,-121,-137,-126,-19,41,-123,-324,-347,-289,-240,-90,-22,-140,-229,-212,-140,-109,-103,-190,-230,-146,-3,90,68,-30,-111,-165,-157,-87,-29,-88,-168,-154,-88,-9,23,20,-61,-98,-67,-32,0,32,21,-55,-90,-68,-62,-82}
        },
        {    // H30e138a.wav
            {-1,-2,-2,-1,-2,0,-1,-3,-1,-2,3,-1,2,-5,-3,-2,2,8,0,6,453,2466,2409,-1086,-2575,-1287,866,3666,4602,2491,1610,2828,2257,-218,-1499,-1527,-2106,-2419,-1672,-1614,-2073,-1293,-186,468,801,1084,1286,1075,936,694,102,-40,256,57,-538,-880,-938,-1053,-1146,-983,-779,-581,-323,-146,34,306,437,325,200,120,-40,-249,-340,-388,-520,-721,-702,-431,-349,-324,-279,-201,-104,-7,68,17,-23,-23,-79,-180,-188,-190,-202,-219,-256,-254,-222,-106,-21,-33,-83,-112,-109,-79,-24,-23,-64,-104,-119,-120,-105,-85,-113,-139,-131,-89,-22,1,-68,-139,-135,-103,-70,-49,-55,-86,-112,-112},
            {1,-9,8,-7,-3,-26,1083,7567,5788,-6152,-4877,1657,-1322,5537,12617,4087,1624,6580,3625,-5212,-5742,-3927,-6884,-6480,-3277,-3271,-3219,209,1255,1472,1842,1900,1693,1082,1383,1217,445,240,641,34,-1132,-2159,-2550,-2396,-1607,-994,-1198,-900,-300,-59,136,422,624,521,283,204,226,84,-10,-76,-239,-428,-392,-246,-313,-388,-387,-413,-443,-154,129,119,-35,-70,-90,-144,-3,115,35,-72,-116,-173,-129,13,40,-124,-270,-283,-247,-182,-49,-57,-195,-283,-239,-155,-97,-105,-192,-212,-125,19,106,89,3,-80,-127,-105,-65,-64,-112,-135,-122,-88,-34,24,27,-44,-84,-67,-14,38,65,19,-56,-84,-80,-89}
        },
        {    // H30e144a.wav
            {-1,-1,-1,1,1,0,-2,-1,0,4,-1,4,-5,2,-4,5,5,9,9,610,2852,2308,-1581,-2634,-1064,1096,4118,4864,2302,1614,3066,2099,-622,-1682,-1752,-2399,-2594,-1791,-1545,-1966,-1247,-158,387,797,1084,1237,1119,941,666,190,-17,144,93,-403,-806,-874,-849,-930,-908,-701,-621,-540,-377,-100,223,432,424,261,119,1,-123,-272,-430,-684,-795,-547,-401,-336,-286,-273,-194,-142,-41,-19,-39,28,52,-23,-105,-136,-129,-186,-270,-299,-300,-236,-108,-30,-47,-65,-98,-107,-72,-34,-15,-57,-90,-107,-105,-82,-98,-124,-146,-143,-69,-2,-19,-99,-144,-129,-87,-47,-42,-55,-74,-88,-108,-111},
            {-19,18,-29,30,-42,47,-87,1985,7840,3463,-6157,-3423,-211,-325,9014,10817,2094,2584,6638,1763,-5725,-5034,-4368,-6594,-5478,-2994,-3373,-2323,589,1177,1563,1417,1799,1501,1033,1514,1049,105,183,803,-108,-1441,-2413,-2590,-1953,-1302,-1110,-1082,-560,-184,11,333,524,538,495,283,-11,11,21,-11,-192,-411,-424,-321,-177,-187,-315,-407,-421,-351,-73,132,59,-99,-110,-136,-153,-14,87,-19,-123,-156,-192,-123,7,14,-126,-237,-248,-228,-156,-44,-80,-222,-329,-286,-173,-82,-97,-207,-247,-141,26,122,121,30,-86,-144,-127,-83,-66,-100,-142,-158,-121,-45,31,31,-44,-95,-70,-11,51,60,-28,-127,-140,-102}
        },
        {    // H30e150a.wav
            {-3,-2,-1,0,-2,-4,-1,-1,4,-3,4,-7,3,-7,5,-1,14,8,806,3285,2172,-2158,-2714,-807,1388,4634,5097,2085,1682,3302,1876,-1071,-1852,-1941,-2776,-2764,-1858,-1556,-1866,-1316,-80,569,801,1057,1213,1128,831,619,251,-54,86,19,-502,-882,-752,-655,-809,-749,-497,-443,-511,-485,-303,64,366,326,213,150,63,-96,-211,-476,-817,-783,-565,-308,-229,-308,-264,-153,-130,-167,-103,33,45,26,-12,-105,-92,-82,-194,-290,-312,-310,-254,-134,-42,-49,-99,-104,-78,-50,-19,-30,-77,-124,-127,-102,-83,-101,-139,-163,-144,-64,-1,-45,-128,-142,-115,-90,-56,-27,-45,-76,-96,-125,-114,-62},
            {10,-23,21,-28,37,-50,62,-65,2615,7566,2173,-5835,-3481,-1022,1744,10330,8850,1302,3207,6318,511,-5780,-4687,-4364,-6111,-4867,-2804,-3226,-1689,689,1211,1188,1231,1908,1190,1200,1618,670,-202,525,899,-566,-1729,-2443,-2271,-1632,-1229,-1073,-894,-389,-69,126,334,614,644,425,114,-106,-59,-45,-31,-284,-509,-421,-223,-151,-172,-282,-431,-432,-266,54,155,-7,-94,-70,-148,-170,-34,22,-57,-137,-204,-209,-114,26,2,-146,-218,-215,-188,-108,-8,-82,-257,-343,-271,-156,-84,-112,-218,-229,-106,43,128,119,34,-84,-176,-159,-67,-10,-58,-159,-209,-134,10,95,39,-67,-100,-45,16,39,-1,-91,-143,-125}
        },
        {    // H30e156a.wav
            {-1,0,0,0,-4,1,-1,6,-2,4,-7,8,-9,9,-6,21,9,1045,3779,1985,-2809,-2793,-515,1756,5227,5279,1827,1833,3588,1569,-1620,-2027,-2077,-3124,-2972,-1933,-1623,-1686,-1231,-178,695,930,1137,1249,1078,828,552,164,-42,12,-119,-585,-980,-915,-662,-508,-538,-459,-271,-256,-390,-273,89,213,143,79,76,64,-36,-297,-603,-728,-702,-492,-348,-297,-180,-138,-184,-232,-124,40,30,-17,16,-36,-104,-112,-111,-178,-270,-306,-298,-225,-126,-58,-74,-96,-104,-91,-24,33,3,-82,-149,-156,-132,-111,-107,-142,-170,-142,-53,-1,-43,-111,-138,-120,-74,-36,-26,-42,-73,-105,-114,-77,-36,-31},
            {-1,8,-21,17,-27,34,-50,58,-12,2886,7206,1614,-5844,-3879,-757,3298,10300,7509,968,3471,5934,-205,-5641,-4380,-4104,-5724,-4388,-2675,-3021,-1336,755,969,737,1468,1735,1024,1536,1414,230,-47,868,552,-890,-1901,-2263,-1872,-1556,-1158,-970,-736,-287,27,190,283,715,748,245,-50,-69,-104,-42,-21,-357,-612,-501,-216,-164,-263,-356,-399,-333,-148,112,183,23,-70,-69,-164,-189,-86,-40,-91,-178,-257,-234,-115,10,-14,-135,-220,-215,-142,-40,6,-100,-263,-318,-252,-170,-100,-112,-191,-199,-103,12,94,96,2,-135,-201,-127,-7,21,-81,-192,-194,-83,55,97,15,-81,-91,-62,-35,-1,-23,-89,-133}
        },
        {    // H30e162a.wav
            {-1,0,-2,-5,0,-1,6,-4,5,-11,8,-11,11,-14,29,8,1314,4301,1770,-3511,-2871,-199,2142,5863,5428,1544,2048,3880,1223,-2219,-2243,-2229,-3437,-3145,-2024,-1736,-1561,-1024,-243,739,1075,1137,1304,1141,841,504,139,-35,-150,-326,-688,-1040,-1075,-814,-496,-349,-284,-197,-205,-236,45,277,207,26,-51,-27,-43,-241,-435,-584,-689,-568,-443,-395,-277,-150,-157,-240,-172,61,116,27,-19,-51,-94,-159,-150,-136,-213,-269,-295,-279,-198,-89,-60,-93,-111,-119,-92,-32,45,43,-59,-163,-194,-152,-124,-144,-192,-213,-149,-42,1,-45,-97,-115,-102,-63,-35,-27,-51,-89,-117,-110,-52,7,-5,-65},
            {9,-3,8,-18,17,-24,29,-42,50,34,2916,6902,1307,-6035,-3967,-124,4008,9807,6705,772,3518,5574,-515,-5386,-4022,-3791,-5345,-4017,-2607,-2815,-1103,708,472,696,1607,1386,1250,1637,990,176,319,734,246,-1004,-1968,-1970,-1614,-1475,-1135,-834,-535,-174,30,110,390,798,660,112,-105,22,-4,-38,-114,-414,-641,-667,-409,-220,-312,-380,-325,-184,25,165,155,75,20,-91,-232,-220,-98,-66,-154,-252,-293,-234,-117,-9,-15,-131,-210,-186,-112,1,30,-91,-233,-278,-241,-167,-79,-97,-186,-200,-119,-19,54,48,-63,-169,-156,-53,29,5,-91,-156,-130,-29,56,67,-11,-94,-115,-93,-37,8,-4,-71}
        },
        {    // H30e168a.wav
            {0,-3,-6,0,-1,6,-5,6,-14,10,-16,16,-22,33,11,1611,4840,1548,-4229,-2978,105,2575,6540,5547,1253,2313,4182,835,-2835,-2480,-2403,-3757,-3308,-2113,-1826,-1451,-803,-228,694,1272,1195,1245,1215,842,535,176,6,-213,-604,-957,-1118,-1091,-962,-584,-304,-211,-218,-169,-30,261,463,353,128,-10,-95,-304,-432,-494,-651,-693,-586,-419,-305,-225,-206,-252,-177,-4,136,136,87,19,-70,-191,-245,-182,-160,-219,-298,-330,-273,-157,-55,-29,-90,-139,-126,-82,-15,42,35,-52,-167,-189,-156,-121,-153,-250,-271,-175,-46,-2,-44,-92,-91,-63,-41,-24,-19,-44,-95,-148,-128,-42,30,18,-39,-79},
            {3,8,-4,6,-17,17,-22,27,-38,48,46,2777,6625,1132,-6108,-3789,364,4094,9220,6236,650,3416,5293,-540,-5049,-3647,-3457,-4978,-3802,-2549,-2599,-946,410,123,822,1436,1328,1489,1381,784,427,360,482,126,-1093,-1817,-1772,-1525,-1360,-1070,-656,-311,-145,-112,37,532,858,467,84,23,64,74,-86,-287,-500,-695,-805,-656,-363,-236,-285,-277,-68,131,243,197,72,2,-120,-236,-249,-141,-100,-221,-300,-295,-257,-155,-32,-20,-115,-179,-166,-102,-3,55,-38,-198,-266,-226,-138,-73,-110,-213,-237,-156,-46,21,-10,-115,-179,-125,-13,57,24,-80,-135,-88,-8,17,-6,-58,-100,-111,-87,-24,19,-1}
        },
        {    // H30e174a.wav
            {-1,-5,2,-1,7,-4,6,-14,12,-19,22,-28,41,16,1932,5374,1329,-4915,-3107,380,3025,7247,5647,982,2628,4465,416,-3432,-2745,-2608,-4046,-3453,-2226,-1956,-1273,-566,-148,642,1330,1413,1172,1226,927,443,239,175,-193,-821,-1259,-1315,-1157,-1025,-612,-289,-276,-299,-153,111,422,583,494,315,70,-179,-295,-394,-562,-769,-803,-636,-421,-295,-275,-243,-107,12,-7,113,229,139,0,-103,-212,-255,-198,-169,-252,-323,-326,-289,-164,-14,6,-78,-136,-129,-77,-1,76,41,-108,-197,-159,-105,-109,-191,-275,-272,-174,-59,-25,-66,-91,-62,-45,-24,12,32,-20,-99,-142,-138,-71,26,45,-18,-73,-74},
            {0,1,9,-4,8,-17,15,-21,28,-36,47,38,2542,6293,1083,-5935,-3524,579,3857,8609,5953,636,3222,5035,-370,-4575,-3283,-3155,-4656,-3664,-2464,-2355,-939,1,5,837,1261,1469,1467,1144,877,568,213,348,38,-1031,-1626,-1721,-1420,-1225,-888,-440,-247,-244,-157,45,502,845,544,137,46,88,17,-151,-435,-706,-814,-764,-637,-516,-289,-132,-105,-20,120,276,264,72,-72,-111,-228,-264,-167,-131,-229,-318,-334,-303,-160,-13,-7,-111,-143,-130,-95,12,76,-8,-169,-225,-184,-127,-86,-139,-238,-263,-179,-69,2,-25,-131,-177,-101,26,87,51,-52,-114,-88,-41,-32,-36,-50,-84,-83,-40,-7,5}
        },
        {    // H30e180a.wav
            {-5,2,0,7,-5,7,-16,13,-20,24,-33,45,25,2249,5869,1155,-5508,-3290,558,3468,7943,5772,756,2948,4745,-19,-4004,-3006,-2878,-4336,-3566,-2355,-2120,-1108,-318,-30,692,1250,1545,1280,1114,1005,480,140,335,-84,-947,-1477,-1587,-1270,-1101,-723,-310,-255,-351,-190,150,472,663,635,333,-31,-50,-62,-322,-569,-775,-862,-731,-511,-415,-370,-166,48,21,3,210,288,100,-80,-125,-203,-256,-181,-160,-270,-333,-345,-308,-166,-11,-2,-91,-126,-123,-86,-9,85,24,-136,-216,-177,-105,-94,-169,-284,-285,-174,-63,-24,-68,-115,-118,-67,9,64,53,-34,-100,-115,-112,-76,-11,-12,-51,-50,-42,-41},
            {-5,2,0,7,-5,7,-16,13,-20,24,-33,45,25,2249,5869,1155,-5508,-3290,558,3468,7943,5772,756,2948,4745,-19,-4004,-3006,-2878,-4336,-3566,-2355,-2120,-1108,-318,-30,692,1250,1545,1280,1114,1005,480,140,335,-84,-947,-1477,-1587,-1270,-1101,-723,-310,-255,-351,-190,150,472,663,635,333,-31,-50,-62,-322,-569,-775,-862,-731,-511,-415,-370,-166,48,21,3,210,288,100,-80,-125,-203,-256,-181,-160,-270,-333,-345,-308,-166,-11,-2,-91,-126,-123,-86,-9,85,24,-136,-216,-177,-105,-94,-169,-284,-285,-174,-63,-24,-68,-115,-118,-67,9,64,53,-34,-100,-115,-112,-76,-11,-12,-51,-50,-42,-41}
        }
    },
    {    // elev40
        {    // H40e000a.wav
            {3,-5,-3,4,8,-5,14,-40,45,-86,116,-157,213,-44,3991,5092,321,-8034,-13665,2199,10876,13927,13643,1537,-4033,847,2379,-3450,-5203,-6535,-4786,-3083,-3496,-1933,-1842,-358,1670,1892,2485,2446,2290,1971,951,406,127,-1598,-1089,-574,-2112,-1790,-948,-643,-355,64,390,451,305,413,837,1226,965,455,96,-366,-800,-1142,-1480,-1506,-1381,-1305,-1173,-788,-38,323,241,255,417,248,114,124,-8,-161,-217,-320,-428,-307,-213,-322,-413,-359,-310,-182,11,141,86,52,57,36,55,48,-48,-225,-275,-242,-203,-175,-173,-163,-164,-135,-56,-42,-62,-58,-73,-96,-69,-60,-72,-77,-70,-67,-101,-132,-124,-71,-44,-29},
            {3,-5,-3,4,8,-5,14,-40,45,-86,116,-157,213,-44,3991,5092,321,-8034,-13665,2199,10876,13927,13643,1537,-4033,847,2379,-3450,-5203,-6535,-4786,-3083,-3496,-1933,-1842,-358,1670,1892,2485,2446,2290,1971,951,406,127,-1598,-1089,-574,-2112,-1790,-948,-643,-355,64,390,451,305,413,837,1226,965,455,96,-366,-800,-1142,-1480,-1506,-1381,-1305,-1173,-788,-38,323,241,255,417,248,114,124,-8,-161,-217,-320,-428,-307,-213,-322,-413,-359,-310,-182,11,141,86,52,57,36,55,48,-48,-225,-275,-242,-203,-175,-173,-163,-164,-135,-56,-42,-62,-58,-73,-96,-69,-60,-72,-77,-70,-67,-101,-132,-124,-71,-44,-29}
        },
        {    // H40e006a.wav
            {1,2,-3,-2,1,10,-7,19,-37,37,-73,93,-114,156,-68,2940,4647,949,-5929,-12730,-1352,8447,12209,14284,4585,-2968,-38,1902,-2105,-3530,-5410,-5175,-3326,-3048,-2156,-2226,-852,1167,1283,1992,2422,2091,2060,1654,849,278,-1502,-1231,-595,-1922,-1644,-936,-607,-266,9,139,333,290,289,978,1407,715,62,115,-215,-823,-1106,-1333,-1307,-1085,-951,-918,-916,-408,209,240,93,197,166,-1,-2,21,-123,-202,-247,-382,-377,-260,-188,-297,-382,-314,-179,-62,60,126,98,43,29,46,19,-43,-149,-222,-235,-184,-177,-194,-169,-151,-134,-102,-83,-75,-52,-32,-31,-66,-100,-88,-67,-68,-43,-71,-131,-151,-121,-81},
            {-6,-3,-4,18,-20,35,-67,69,-106,124,-156,185,-173,2891,6499,1693,-6252,-16402,-2198,12140,14264,17038,4113,-5402,-1081,2977,-2478,-5484,-7013,-5999,-2622,-3631,-2805,-1636,-689,1368,2000,2791,2606,2339,2290,1274,225,181,-1104,-1657,-727,-1801,-2052,-1211,-672,-381,-86,326,587,274,404,620,836,1495,1074,51,-304,-536,-1016,-1522,-1730,-1705,-1724,-1305,-737,-247,203,525,474,460,386,260,203,36,-138,-275,-390,-431,-310,-296,-323,-401,-431,-361,-183,9,172,162,87,51,9,59,70,-24,-242,-349,-310,-235,-175,-180,-186,-156,-117,-54,-28,-36,-38,-64,-89,-80,-96,-105,-76,-84,-103,-124,-119,-94,-61,-37,-12,-6}
        },
        {    // H40e013a.wav
            {0,3,2,-3,-4,5,2,2,6,-20,18,-45,67,-83,111,99,3100,3800,510,-6400,-10674,150,7063,11501,12663,3371,-1790,896,1063,-1996,-3107,-5208,-4683,-2907,-2701,-2282,-2033,-453,840,1082,1929,2147,1972,1993,1593,966,-61,-1553,-797,-748,-1742,-1311,-776,-388,-219,-121,0,236,122,297,1056,1215,462,-116,-87,-185,-693,-1120,-1189,-1002,-916,-832,-747,-763,-431,22,198,48,-11,-24,-45,-38,-79,-111,-165,-271,-313,-263,-255,-234,-237,-320,-335,-178,-9,87,101,69,20,16,40,17,-62,-153,-196,-187,-173,-191,-201,-200,-166,-133,-94,-100,-66,-12,-2,-23,-80,-120,-100,-47,-47,-52,-72,-110,-134,-144},
            {-4,-9,25,-22,38,-57,42,-62,58,-48,32,-30,1567,7118,3706,-4169,-17428,-8252,12469,14881,18936,8672,-5633,-3854,3075,-1375,-5704,-6943,-7549,-2935,-2806,-3333,-2220,-929,1409,1807,2724,3087,2416,2347,1653,388,79,-758,-1707,-1050,-1764,-2115,-1432,-861,-398,23,223,643,454,189,240,476,1823,1561,207,-269,-441,-755,-1306,-1809,-2166,-2175,-1299,-607,-537,-40,698,777,620,461,257,271,148,-89,-311,-441,-472,-374,-298,-267,-396,-527,-440,-187,29,159,239,176,104,-5,16,86,22,-208,-418,-416,-306,-192,-180,-215,-155,-107,-67,-18,-3,2,-17,-57,-104,-121,-124,-95,-114,-136,-120,-91,-78,-71,-36,0,13,2}
        },
        {    // H40e019a.wav
            {-4,1,1,2,-2,-3,5,0,0,4,-18,13,-34,50,-64,82,89,2534,3355,839,-5144,-9157,-963,5151,10134,11508,3982,-451,823,925,-1317,-2585,-4662,-4202,-2581,-2667,-2300,-1799,-673,365,894,1652,1946,1931,1900,1587,921,-129,-1145,-518,-621,-1340,-1052,-695,-536,-432,-235,-189,0,16,280,959,959,323,-44,-79,-86,-554,-1031,-998,-823,-791,-773,-663,-623,-478,-212,48,50,-92,-218,-177,-26,-84,-197,-156,-201,-243,-191,-213,-256,-262,-246,-247,-155,-24,50,73,62,18,-12,-6,-3,-45,-111,-169,-184,-197,-220,-205,-195,-176,-139,-78,-70,-45,0,-9,-37,-82,-123,-117,-60,-23,-32,-79,-123,-136},
            {-12,23,-16,28,-39,14,-29,7,28,-64,86,855,7103,5578,-2632,-18278,-12815,12115,16651,20207,11254,-4372,-5427,1675,-321,-6190,-7342,-8420,-3835,-2263,-3017,-2261,-1690,1293,2360,2612,2935,2804,2565,1660,471,48,-465,-1679,-1291,-1919,-2167,-1547,-1052,-549,113,488,727,660,-61,-176,387,1731,1738,440,-349,-405,-506,-1060,-1898,-2579,-2311,-1132,-649,-768,-141,801,1046,771,485,277,303,185,-64,-326,-452,-533,-450,-266,-223,-403,-558,-491,-237,25,209,302,227,156,56,33,65,32,-190,-423,-479,-398,-274,-229,-216,-173,-144,-80,21,46,44,32,-31,-94,-114,-130,-151,-177,-130,-75,-66,-95,-85,-39,2,18,5,18}
        },
        {    // H40e026a.wav
            {-3,-3,0,1,2,-2,-2,6,-3,5,-3,-7,3,-16,31,-39,46,193,2399,2886,694,-4993,-7815,-911,4487,9658,10012,3713,202,936,802,-1081,-2417,-4209,-3514,-2416,-2623,-2118,-1624,-775,171,855,1572,1865,1689,1629,1558,962,-155,-760,-188,-541,-1135,-1021,-843,-702,-452,-423,-375,26,-44,267,960,751,161,133,137,-175,-614,-906,-885,-752,-730,-707,-682,-577,-378,-251,-88,-32,-115,-287,-231,-36,-108,-231,-158,-128,-205,-187,-192,-256,-245,-198,-140,-125,-78,50,81,49,-17,-48,-13,9,-32,-134,-186,-180,-195,-224,-212,-169,-150,-100,-51,-55,-34,-28,-19,-32,-78,-121,-110,-62,-39,-28,-85,-141},
            {8,5,0,6,-44,46,-94,148,-206,281,-103,5488,7683,1310,-15047,-20192,6637,17638,20793,16252,-1250,-6152,-119,593,-5349,-7369,-9579,-5677,-2039,-2957,-2057,-1758,142,2079,3133,3057,2398,2895,2191,700,-143,-189,-1215,-1414,-2069,-2276,-1586,-1398,-765,-35,491,930,1009,-348,-242,598,950,1653,966,-373,-594,-215,-718,-2012,-2617,-2137,-1135,-824,-998,-356,807,1199,768,492,357,356,289,-14,-354,-488,-524,-457,-307,-251,-345,-518,-512,-311,-57,156,331,296,196,82,33,111,67,-144,-398,-480,-450,-360,-277,-279,-254,-188,-100,9,75,80,54,-5,-69,-83,-131,-183,-186,-139,-67,-72,-101,-93,-58,-31,-2,7,7,29}
        },
        {    // H40e032a.wav
            {-1,-2,-3,-1,1,1,-1,-1,1,0,1,0,-5,5,-16,25,-36,39,115,1843,2628,1124,-3625,-7083,-2112,3269,8198,9234,4412,858,939,939,-655,-1863,-3451,-3131,-2302,-2531,-1991,-1579,-1057,-11,806,1224,1369,1502,1734,1770,1124,126,-306,-96,-576,-1148,-1115,-984,-918,-648,-485,-322,-93,-197,320,927,617,232,359,231,-253,-607,-797,-841,-760,-708,-732,-682,-460,-321,-314,-240,-110,-111,-241,-199,-142,-152,-173,-133,-145,-216,-229,-197,-162,-184,-197,-149,-65,-22,6,22,-3,-17,-31,-30,-25,-75,-139,-175,-167,-188,-217,-202,-148,-97,-70,-56,-69,-53,-35,-23,-31,-74,-114,-112,-89,-74,-57,-82},
            {22,-19,35,-74,80,-133,180,-231,303,-340,3806,8515,4430,-11157,-24456,439,17831,20970,19798,2017,-5969,-1456,1629,-4784,-7722,-9806,-8094,-2631,-2681,-2072,-1688,108,1777,2699,3692,2641,2559,2306,1308,-112,-379,-972,-1141,-2066,-2764,-1514,-1438,-1163,-119,598,965,1042,-263,-9,711,541,1389,1007,-372,-825,-233,-592,-2124,-2459,-1552,-1084,-1111,-843,-305,561,1073,862,529,273,361,427,57,-348,-484,-600,-519,-283,-219,-308,-513,-463,-297,-107,112,331,334,198,94,29,109,120,-49,-337,-487,-469,-371,-296,-332,-350,-255,-125,20,75,71,88,29,-54,-87,-128,-144,-114,-103,-109,-108,-91,-88,-72,-61,-28,2,15,39,50}
        },
        {    // H40e039a.wav
            {3,-1,-1,-2,1,2,2,0,0,2,1,2,2,-1,3,-8,13,-18,23,159,1695,2358,1064,-3390,-6419,-2080,3010,7632,8303,4150,1115,1064,876,-487,-1602,-2971,-2684,-2211,-2386,-1782,-1505,-995,-95,443,988,1437,1636,1850,1901,1109,83,-226,-259,-754,-1093,-1241,-1298,-855,-466,-516,-336,-133,-155,458,991,547,235,369,186,-318,-673,-781,-863,-787,-701,-646,-582,-418,-321,-339,-237,-113,-98,-193,-149,-149,-200,-152,-160,-233,-243,-212,-168,-146,-142,-143,-100,-21,-13,-33,-16,0,-15,-49,-70,-71,-81,-136,-154,-152,-183,-191,-176,-107,-65,-60,-62,-69,-54,-39,-31,-43,-75,-118,-116,-100,-93,-80},
            {-13,39,-68,49,-76,67,-54,37,-43,1143,7775,7586,-2978,-24237,-12509,15271,19490,22775,9315,-4368,-3298,1445,-1739,-7265,-9570,-10259,-4734,-3235,-2310,-1435,-941,1696,2716,3593,2836,2871,2590,1406,385,-148,-882,-1166,-1493,-2957,-2050,-1393,-1432,-527,464,1011,845,177,366,490,296,1184,1215,-183,-1026,-607,-618,-1807,-2177,-1259,-1116,-1320,-663,-57,236,573,779,757,377,215,354,179,-113,-315,-635,-710,-376,-162,-214,-425,-437,-343,-192,72,335,339,170,94,34,72,116,42,-197,-418,-455,-403,-306,-339,-386,-312,-184,-39,43,62,79,63,-43,-108,-121,-106,-52,-58,-107,-131,-104,-80,-99,-100,-56,-2,28,32,46,43}
        },
        {    // H40e045a.wav
            {1,0,0,-2,-2,-1,1,0,0,-2,1,-2,2,1,-1,-2,-8,9,-10,6,190,1552,2122,1053,-3161,-5948,-2049,2792,7129,7527,3893,1318,1141,834,-334,-1335,-2527,-2330,-2114,-2161,-1526,-1572,-1282,-236,588,1124,1511,1774,1960,1729,704,-41,-243,-372,-819,-1396,-1392,-1036,-688,-516,-460,-231,-251,-20,811,879,294,233,348,48,-406,-708,-883,-910,-693,-572,-615,-570,-396,-313,-265,-203,-121,-66,-124,-120,-171,-265,-233,-225,-273,-251,-209,-166,-130,-70,-60,-83,-61,-22,-19,-35,-27,-58,-92,-106,-86,-86,-128,-145,-155,-160,-162,-131,-90,-78,-60,-64,-65,-76,-68,-50,-56,-80,-119,-130,-134,-111},
            {10,-11,-28,26,-75,125,-190,264,-167,5522,9205,3118,-18823,-22426,9178,19347,21553,15348,-656,-3697,542,810,-6292,-9057,-10630,-7344,-4050,-3704,-1623,-1193,866,2612,4193,3425,2549,2949,2076,535,-274,-400,-1196,-1324,-2760,-2595,-1527,-1633,-845,312,814,539,736,931,210,166,1056,1164,85,-947,-1241,-1207,-1477,-1559,-1161,-1163,-1108,-617,104,407,267,287,619,618,244,88,126,95,-137,-481,-709,-577,-250,-146,-272,-368,-383,-224,36,296,358,177,14,-20,19,104,62,-122,-335,-404,-378,-310,-310,-377,-325,-227,-125,-6,53,53,27,-68,-127,-115,-64,-45,-57,-92,-102,-76,-88,-126,-137,-94,-26,36,46,31,37,19}
        },
        {    // H40e051a.wav
            {1,2,1,-1,0,-2,0,2,1,0,-3,0,-3,1,5,-4,-1,-9,11,-15,9,122,1207,1900,1378,-2223,-5600,-2711,1941,6198,7060,4104,1676,1167,917,-15,-839,-1943,-2013,-1826,-2093,-1874,-1623,-1030,-81,665,1184,1562,1584,1560,1310,457,27,-216,-724,-1019,-1083,-1205,-1027,-553,-336,-433,-355,-48,271,666,597,217,163,207,-48,-470,-794,-880,-755,-580,-556,-634,-509,-302,-246,-225,-160,-84,-33,-70,-159,-241,-337,-337,-269,-268,-267,-237,-135,-33,-14,-54,-87,-53,-13,-24,-64,-77,-102,-120,-111,-107,-106,-108,-112,-120,-127,-123,-119,-102,-73,-57,-66,-92,-99,-75,-61,-66,-92,-128,-153,-145},
            {34,-76,76,-116,134,-151,175,-247,1818,8483,8396,-6722,-27585,-6240,18716,19357,19568,6178,-2452,-1326,2474,-2023,-8979,-10535,-9021,-5135,-5192,-2889,-1876,-592,1969,3827,4454,2976,3328,2495,1279,169,-255,-1137,-1114,-2009,-3178,-2045,-1750,-1245,-168,500,335,968,1363,411,155,701,1100,487,-492,-1450,-1870,-1412,-1123,-1073,-1195,-955,-558,-82,407,431,148,216,507,368,85,53,116,-51,-259,-486,-606,-445,-171,-126,-315,-378,-239,-31,195,338,260,21,-68,-59,24,92,-6,-236,-398,-362,-283,-238,-299,-318,-264,-199,-71,51,37,-2,-76,-144,-115,-60,-38,-71,-93,-90,-54,-57,-100,-123,-120,-66,8,51,51,39,30,-16}
        },
        {    // H40e058a.wav
            {1,1,1,1,0,-2,0,0,1,0,-1,-3,1,-3,7,5,-3,-2,-5,7,-11,7,168,1154,1758,1317,-2359,-5339,-2409,2073,6057,6405,3679,1709,1197,888,131,-591,-1518,-1860,-2088,-2065,-1432,-1132,-730,90,765,1062,1170,1203,1220,893,364,-180,-606,-533,-680,-1104,-1163,-640,-357,-449,-342,-143,11,294,539,294,101,123,19,-274,-543,-683,-757,-671,-564,-549,-510,-361,-252,-214,-158,-107,-56,-55,-130,-227,-326,-381,-333,-287,-316,-272,-136,-48,-36,-36,-31,-32,-41,-39,-57,-98,-102,-129,-151,-142,-111,-73,-65,-82,-112,-110,-108,-105,-93,-85,-72,-69,-85,-106,-102,-86,-84,-100,-148,-160},
            {3,-40,39,-91,143,-210,291,-348,4719,9929,4823,-18954,-24087,9853,20064,18976,13743,1018,-1575,975,2767,-5383,-10533,-10725,-6904,-4959,-4900,-2683,-2298,247,2560,4987,3798,3282,3798,2153,591,54,-326,-1522,-1451,-2652,-2811,-2229,-1701,-580,-2,3,803,1760,665,299,754,762,659,53,-1043,-2252,-1844,-989,-899,-1063,-939,-562,-166,224,404,394,138,161,183,131,119,104,-73,-186,-256,-435,-499,-300,-62,-184,-372,-317,-95,113,291,314,72,-100,-113,-79,35,56,-96,-348,-398,-305,-176,-183,-262,-259,-241,-152,-2,61,-23,-85,-153,-152,-84,-44,-71,-109,-100,-72,-61,-71,-79,-80,-78,-38,19,45,51,38,-5,-55}
        },
        {    // H40e064a.wav
            {1,1,1,1,1,0,-1,-2,0,2,1,-1,-3,1,-2,9,2,-2,-2,-3,7,-9,15,146,1011,1605,1414,-2044,-5143,-2488,1855,5636,5903,3488,1860,1298,1028,434,-430,-1570,-1709,-1496,-1471,-1052,-842,-658,-206,381,644,756,875,888,505,-35,-5,-147,-387,-600,-905,-832,-561,-320,-282,-376,-231,76,267,184,81,70,-62,-228,-263,-334,-600,-722,-615,-459,-404,-396,-291,-226,-169,-83,-117,-139,-114,-185,-308,-335,-333,-386,-363,-264,-155,-108,-74,-20,8,12,-14,-51,-73,-96,-110,-136,-180,-169,-107,-59,-50,-51,-71,-89,-80,-93,-111,-104,-71,-46,-71,-110,-131,-116,-102,-97,-113,-139},
            {-50,48,-78,68,-62,37,-51,697,7555,10138,-3403,-27926,-10262,19676,18095,16861,7245,-486,-509,3663,1053,-8569,-10842,-9408,-5955,-5744,-3338,-3073,-2467,804,3510,4828,3213,4314,3619,1809,610,168,-1045,-1440,-1866,-3071,-2701,-2361,-1237,-506,-406,374,1587,1260,311,820,912,606,245,-520,-1858,-2296,-1317,-909,-766,-842,-607,-190,79,208,423,362,59,-30,-140,35,204,29,-257,-208,-219,-374,-361,-99,-33,-250,-354,-246,-20,239,331,177,-99,-205,-191,-67,69,-19,-253,-411,-329,-198,-90,-163,-222,-215,-187,-86,21,-9,-87,-147,-183,-142,-103,-82,-102,-126,-126,-96,-77,-64,-44,-21,-31,-17,12,30,25,-1,-56,-75}
        },
        {    // H40e071a.wav
            {0,0,1,1,1,0,0,-1,-1,-1,2,0,-1,-2,1,-2,12,-4,3,-6,4,-3,9,-1,257,1092,1610,1077,-2900,-4908,-1512,2673,5695,5104,2941,1799,1425,875,43,-462,-961,-1085,-1143,-1145,-947,-1005,-944,-419,204,379,539,576,317,341,488,150,-187,-144,-436,-929,-674,-267,-432,-503,-336,-144,79,128,-60,-50,-52,-170,-199,-194,-338,-608,-608,-445,-363,-359,-314,-252,-191,-112,-147,-196,-178,-178,-241,-312,-325,-388,-382,-280,-212,-156,-98,-18,12,18,5,-35,-76,-119,-130,-151,-165,-163,-130,-74,-61,-45,-49,-65,-67,-89,-108,-98,-74,-68,-74,-95,-135,-148,-139,-118,-96,-94},
            {-61,73,-123,151,-192,230,-352,2108,9242,8878,-11720,-28530,2102,21375,16086,14203,4141,-512,411,5310,-1479,-10007,-9974,-8077,-6381,-5815,-2594,-3472,-1949,926,4137,3963,3069,4969,3368,1592,976,404,-1546,-1537,-1906,-3094,-3136,-2082,-932,-994,-366,978,1497,738,503,1124,825,421,-24,-1063,-2122,-1830,-1062,-933,-679,-563,-326,-73,144,258,368,196,33,-203,-299,26,221,-41,-282,-182,-226,-316,-200,32,-61,-255,-297,-182,30,253,298,78,-206,-259,-209,-37,48,-80,-347,-407,-216,-95,-81,-164,-153,-173,-144,-37,14,-74,-124,-144,-167,-159,-138,-107,-110,-144,-141,-106,-77,-39,3,16,-5,13,24,15,-6,-35,-67,-61}
        },
        {    // H40e077a.wav
            {1,1,1,1,2,1,2,0,-1,0,1,2,0,1,-3,3,3,9,-5,7,-9,14,0,18,-25,378,1172,1643,548,-3654,-4390,-408,3323,5308,4375,2582,1574,1229,974,618,73,-445,-791,-1147,-1241,-1374,-1380,-1125,-563,-57,98,88,216,785,797,438,254,280,-93,-630,-575,-580,-697,-600,-379,-341,-177,74,-99,-281,-69,11,-193,-218,-167,-276,-443,-466,-396,-320,-283,-259,-226,-201,-177,-227,-240,-210,-202,-252,-332,-339,-311,-312,-295,-207,-106,-28,13,16,-6,-33,-60,-114,-158,-155,-131,-132,-137,-109,-72,-51,-46,-38,-50,-70,-79,-89,-86,-83,-77,-87,-127,-157,-156,-125,-93,-57},
            {-45,54,-103,148,-210,282,-439,3392,10351,6478,-18606,-24451,11017,19796,14070,11854,3061,-384,1677,5820,-4030,-10225,-8506,-7117,-7193,-5437,-2574,-3967,-1387,1474,4091,2852,3386,4949,3037,1785,1476,347,-1523,-1252,-2156,-3171,-3151,-1957,-1144,-1196,-134,1041,1140,452,722,1273,632,286,-297,-1362,-1947,-1331,-941,-951,-553,-320,-159,-49,218,290,207,21,-25,-328,-408,20,240,-95,-274,-150,-193,-236,-54,95,-90,-233,-208,-135,37,246,206,-57,-259,-258,-217,-31,19,-171,-393,-318,-138,-45,-70,-141,-115,-125,-94,-21,-22,-117,-127,-142,-157,-181,-158,-143,-152,-153,-141,-105,-67,-17,32,28,11,37,48,5,-37,-56,-64,-46}
        },
        {    // H40e084a.wav
            {0,0,0,0,0,1,1,-2,-1,-2,-1,0,0,-1,-3,-2,0,4,3,-3,-2,-1,21,0,-16,43,760,1424,1539,-1350,-4779,-2461,1729,4203,4580,3211,1844,1687,1938,1260,518,-29,-485,-1165,-1518,-1469,-1655,-1499,-1114,-455,-251,-315,450,996,814,681,685,393,63,-103,-579,-988,-899,-600,-501,-441,-278,-127,-86,-211,-102,-6,-156,-242,-128,-88,-249,-431,-462,-334,-251,-260,-275,-239,-235,-265,-268,-221,-205,-253,-300,-300,-275,-307,-316,-257,-148,-43,-2,-11,-40,-49,-77,-111,-132,-145,-137,-129,-121,-116,-104,-75,-52,-47,-48,-54,-70,-98,-100,-88,-92,-106,-124,-144,-156,-132,-95,-59},
            {-32,34,-75,118,-183,257,-400,3958,10784,4619,-21524,-20513,14445,17759,12638,10867,3107,-205,2711,5548,-5508,-9737,-7328,-6705,-7493,-5170,-2936,-4253,-1315,1846,4057,2062,3538,4814,2615,1936,1943,209,-1377,-630,-2148,-3478,-2950,-1697,-1631,-1319,84,792,685,340,929,1122,494,299,-415,-1419,-1642,-953,-959,-922,-418,-210,-174,-30,260,245,110,-92,-116,-416,-419,6,226,-115,-281,-105,-143,-167,21,99,-107,-198,-162,-128,44,227,114,-170,-272,-236,-216,-24,-14,-232,-395,-248,-111,-47,-45,-113,-114,-106,-55,-26,-65,-123,-111,-155,-175,-175,-165,-182,-192,-168,-139,-96,-56,-19,19,21,22,42,48,15,-39,-71,-65,-37}
        },
        {    // H40e090a.wav
            {1,1,1,0,2,1,1,0,1,1,1,1,2,0,0,0,1,1,8,-2,3,-3,34,-5,0,-48,459,1239,1718,62,-4154,-3682,670,3391,4133,3404,2558,2262,2341,1750,766,-12,-439,-980,-1722,-1656,-1618,-1830,-1513,-637,-562,-379,701,1030,900,959,897,338,328,225,-752,-1288,-954,-598,-635,-511,-363,-258,-92,31,-10,-117,-170,-188,-81,-39,-133,-367,-466,-352,-251,-262,-285,-235,-284,-312,-267,-209,-187,-245,-274,-263,-260,-264,-274,-263,-188,-78,-31,-46,-56,-74,-98,-91,-70,-109,-149,-127,-90,-90,-106,-89,-55,-55,-52,-48,-62,-87,-103,-92,-92,-104,-105,-119,-131,-114,-77,-54},
            {-26,29,-63,102,-161,231,-372,3809,10795,4048,-21674,-18317,14726,15869,11338,10813,3694,166,3416,5386,-6135,-9255,-6247,-6406,-7439,-4986,-3397,-4632,-1434,1734,3815,1835,3437,4582,2416,1930,2039,261,-996,-77,-1857,-3324,-2849,-1621,-1829,-1532,-10,429,198,242,973,892,397,379,-334,-1266,-1341,-681,-878,-874,-311,-141,-215,-92,272,209,36,-149,-217,-467,-401,-20,151,-101,-215,-83,-102,-86,69,99,-90,-182,-160,-102,45,176,56,-209,-306,-221,-172,-33,-37,-232,-368,-244,-100,-32,-35,-83,-100,-99,-39,-18,-72,-126,-97,-155,-185,-164,-157,-195,-211,-187,-138,-77,-44,-29,1,8,23,61,60,32,-12,-48,-60,-41}
        },
        {    // H40e096a.wav
            {0,-1,0,0,0,0,1,-1,-1,-1,-3,-2,0,-1,-3,-2,1,-3,3,-6,5,-6,30,-4,-8,-47,329,1169,1786,609,-3752,-4428,-2,3245,4183,3761,3021,2461,2409,1775,649,-10,-623,-1123,-1653,-1784,-1778,-1897,-1473,-1054,-606,266,636,838,1299,1242,658,470,553,-76,-1012,-1285,-905,-733,-694,-605,-515,-282,44,219,70,-116,-144,-123,-120,-69,-114,-339,-464,-377,-288,-270,-261,-264,-322,-341,-260,-198,-181,-198,-265,-305,-227,-188,-232,-250,-208,-150,-120,-88,-105,-132,-86,-39,-56,-110,-133,-108,-82,-80,-82,-81,-85,-81,-74,-71,-73,-92,-111,-110,-93,-88,-99,-101,-96,-79,-72,-78},
            {-34,36,-72,106,-156,211,-360,2992,10320,5261,-19411,-19019,12464,14963,10485,11482,4492,538,3429,5760,-5510,-9213,-5716,-6083,-7264,-5014,-3459,-5056,-1843,1413,3408,1738,3312,4545,2344,1994,1859,226,-644,342,-1565,-2922,-2536,-1761,-1911,-1544,-289,-47,-120,203,847,664,376,451,-159,-986,-1167,-628,-743,-793,-289,-125,-241,-133,229,153,22,-156,-246,-468,-400,-85,72,-61,-168,-65,-89,-51,71,113,-61,-185,-178,-101,32,127,40,-186,-297,-233,-165,-36,-37,-199,-342,-267,-132,-31,-25,-91,-85,-93,-40,-11,-59,-122,-107,-141,-174,-168,-155,-185,-208,-189,-159,-95,-46,-31,-19,-8,15,67,81,42,-1,-31,-40,-34}
        },
        {    // H40e103a.wav
            {0,1,1,1,1,1,1,1,0,0,0,0,2,0,-1,-2,3,1,1,-9,7,4,26,-8,-3,-43,434,1316,1986,198,-4543,-4386,568,3791,4654,4193,2963,2083,2186,1465,295,-225,-736,-1381,-1799,-1678,-1851,-1739,-1404,-1161,-74,585,603,994,1442,1142,657,686,221,-633,-1080,-1035,-932,-836,-694,-720,-514,-160,149,243,135,17,-28,-81,-188,-182,-156,-288,-498,-457,-280,-231,-272,-301,-332,-307,-219,-183,-163,-185,-281,-270,-180,-152,-195,-234,-223,-199,-160,-167,-178,-108,-14,-31,-95,-105,-84,-67,-75,-71,-62,-61,-88,-105,-92,-92,-94,-107,-108,-98,-85,-75,-82,-75,-65,-59,-72,-76},
            {-36,38,-71,92,-123,151,-259,1734,9105,7500,-14809,-20993,7666,14450,9677,12563,5764,911,3015,6307,-3588,-9310,-5634,-5736,-7001,-5332,-3248,-5224,-2657,835,2988,1715,2730,4739,2564,1979,1751,238,-601,620,-1030,-2497,-2252,-1738,-1820,-1711,-526,-480,-518,115,715,467,280,547,82,-644,-1031,-662,-625,-725,-277,-164,-252,-164,185,83,-12,-130,-213,-415,-440,-144,3,-26,-147,-60,-65,-65,42,120,-29,-172,-189,-135,-21,100,46,-147,-247,-221,-197,-58,-12,-158,-315,-286,-163,-77,-29,-102,-96,-87,-38,-4,-55,-115,-111,-129,-164,-165,-154,-169,-189,-186,-179,-126,-64,-41,-39,-27,10,68,88,51,0,-19,-11,-13}
        },
        {    // H40e109a.wav
            {0,1,1,1,1,1,1,0,-1,0,1,0,1,1,-1,2,-1,5,-4,-5,-1,14,19,-10,-13,46,817,1941,1847,-2308,-5817,-2236,2679,4640,4947,3861,2381,2019,1692,517,-133,-622,-1242,-1667,-1785,-1757,-1603,-1386,-1559,-456,669,513,852,1464,1223,789,968,534,-566,-1105,-930,-853,-1006,-874,-803,-680,-328,13,118,174,287,226,76,-54,-192,-329,-291,-323,-503,-529,-325,-221,-304,-336,-306,-214,-161,-139,-186,-252,-206,-172,-145,-161,-199,-235,-253,-223,-245,-257,-157,-27,-32,-94,-101,-62,-38,-56,-61,-54,-47,-65,-85,-116,-119,-121,-128,-125,-114,-73,-67,-70,-59,-52,-57,-65,-50,-52},
            {-25,15,-36,30,-28,6,-16,357,6496,9782,-6839,-21911,-1105,13223,8814,13482,8473,1199,2282,6414,7,-8743,-6142,-5289,-6660,-5895,-3155,-4739,-3838,-137,2229,1984,1761,4448,3284,2086,1624,519,-622,418,-257,-1890,-2012,-1775,-1345,-1760,-1065,-739,-907,-209,502,376,131,535,440,-228,-845,-767,-482,-701,-355,-190,-261,-153,79,34,-61,-88,-153,-286,-445,-232,-34,-8,-138,-103,-70,-72,-41,94,27,-157,-185,-163,-97,28,76,-69,-194,-178,-190,-124,-17,-101,-252,-299,-204,-144,-80,-114,-116,-92,-55,0,-34,-101,-104,-124,-166,-152,-140,-144,-163,-175,-196,-160,-107,-73,-66,-41,2,61,87,46,-1,9,22,0}
        },
        {    // H40e116a.wav
            {0,0,1,1,1,3,1,0,-1,0,1,2,0,0,0,3,-1,3,-6,-3,-2,17,2,5,-30,377,1627,2436,-428,-5364,-4334,1174,4428,5237,4286,2639,2158,2136,972,-206,-672,-1211,-1730,-1942,-1658,-1591,-1385,-1353,-941,403,700,750,1356,1379,944,938,763,-153,-949,-1108,-889,-888,-950,-985,-835,-393,-132,-4,81,228,364,319,105,-9,-149,-395,-448,-442,-492,-500,-413,-330,-331,-301,-209,-144,-114,-161,-212,-179,-136,-129,-151,-167,-229,-262,-268,-307,-277,-169,-85,-92,-116,-97,-56,-27,-40,-59,-51,-27,-38,-81,-107,-113,-127,-132,-143,-145,-115,-64,-38,-52,-63,-68,-51,-40,-41,-53},
            {-1,-16,8,-28,47,-83,119,-190,3544,9850,1018,-18697,-10016,9625,8475,12883,12068,2128,1287,5738,3360,-6641,-7006,-4960,-6277,-6317,-3650,-3842,-4629,-1201,1307,2127,1282,3546,3825,2417,1667,765,-301,-80,227,-1283,-1796,-1819,-1122,-1389,-1486,-1019,-1058,-569,220,314,80,422,662,167,-593,-826,-456,-613,-535,-244,-236,-132,-24,-24,-85,-38,-110,-166,-367,-291,-59,16,-119,-162,-115,-103,-89,32,74,-132,-190,-154,-138,-60,68,7,-133,-146,-136,-166,-80,-48,-160,-275,-248,-198,-133,-122,-139,-117,-84,-9,1,-60,-109,-123,-166,-135,-113,-122,-135,-157,-189,-179,-139,-110,-87,-51,-5,50,76,35,21,36,38,7}
        },
        {    // H40e122a.wav
            {0,0,1,2,2,1,0,-1,0,1,2,0,0,0,3,2,2,-4,-2,-3,11,2,2,-11,236,1563,2646,-66,-5073,-4818,543,4483,5629,4457,2460,1959,2207,1313,48,-585,-1418,-2104,-2189,-1852,-1685,-1287,-1111,-1074,305,953,754,1295,1458,1079,983,830,6,-881,-1060,-862,-895,-981,-1019,-960,-518,-159,-80,-32,153,348,353,209,157,93,-156,-404,-570,-571,-488,-480,-530,-501,-351,-159,-79,-129,-170,-98,-66,-115,-133,-117,-167,-216,-233,-329,-358,-257,-143,-120,-145,-162,-125,-69,-26,-15,-57,-54,-26,-14,-48,-103,-127,-117,-100,-127,-160,-143,-84,-42,-36,-52,-83,-67,-26,-17,-50,-93},
            {10,-24,12,-28,30,-40,38,-79,744,6773,7871,-8978,-16905,454,7592,10333,15689,6143,-17,3819,5908,-1832,-7353,-5165,-5563,-6419,-4823,-3139,-4579,-2771,154,1685,1374,2092,3902,2911,1887,1089,348,-452,280,-411,-1568,-1755,-1196,-963,-1470,-1359,-1256,-873,-205,173,49,267,709,587,-124,-728,-565,-498,-670,-411,-272,-150,-87,-88,-157,-20,11,-78,-222,-297,-90,22,-62,-211,-203,-180,-124,-43,60,-71,-178,-147,-143,-133,-16,44,-34,-87,-114,-164,-129,-34,-63,-196,-274,-248,-187,-131,-187,-171,-112,-32,14,-21,-94,-125,-140,-127,-100,-93,-96,-134,-172,-183,-154,-149,-125,-76,-17,20,30,45,61,57,41,19}
        },
        {    // H40e129a.wav
            {-1,0,2,0,1,0,-1,-1,0,1,0,-1,-2,2,2,0,-1,-4,-3,3,9,-3,-5,119,1362,2811,527,-4637,-5339,-312,4280,5951,4848,2528,1824,2198,1425,99,-388,-1108,-2064,-2453,-2216,-1914,-1556,-1022,-961,-135,1037,1092,1260,1396,1095,1105,922,211,-659,-1083,-972,-756,-854,-1111,-1057,-593,-224,-200,-108,86,263,343,210,160,204,40,-152,-395,-608,-607,-532,-552,-627,-545,-286,-84,-117,-125,-37,-3,-34,-92,-109,-164,-204,-265,-340,-311,-239,-191,-179,-165,-152,-140,-121,-68,-26,-25,-46,-38,-23,-42,-75,-119,-120,-110,-109,-143,-142,-88,-56,-51,-80,-81,-61,-42,-27,-44,-79,-109},
            {3,-2,-15,3,-16,21,-46,63,-107,2882,8743,1429,-14924,-9437,3778,7590,15516,12068,984,1201,5776,2946,-5261,-6060,-4889,-6027,-5680,-3580,-3756,-3912,-1051,852,1542,1246,3067,3424,2095,1335,972,-236,-121,299,-1157,-1676,-1381,-876,-1225,-1381,-1483,-1143,-427,-89,-9,130,607,790,336,-390,-643,-512,-625,-558,-412,-262,-129,-120,-183,-113,72,9,-80,-239,-146,4,12,-196,-285,-229,-177,-102,-7,-28,-146,-143,-145,-172,-115,16,19,-33,-97,-144,-153,-59,-20,-112,-244,-265,-230,-180,-192,-218,-152,-78,-15,-27,-73,-107,-115,-120,-101,-82,-73,-114,-153,-171,-158,-158,-162,-113,-52,-18,-9,40,78,77,55,23}
        },
        {    // H40e135a.wav
            {1,1,1,1,-1,-2,-2,-1,2,0,-2,-2,0,3,-1,-2,-6,-3,-5,10,-5,3,64,1235,2959,880,-4464,-5676,-841,4223,6327,5194,2559,1735,2204,1542,19,-553,-1045,-1943,-2338,-2285,-2138,-1920,-1203,-841,-499,833,1451,1449,1470,1076,1072,905,358,-370,-1088,-1136,-735,-654,-1016,-1143,-675,-201,-223,-202,-23,188,295,182,139,191,117,-41,-207,-410,-546,-593,-632,-681,-643,-417,-268,-177,-47,4,32,5,-1,-49,-140,-226,-323,-323,-248,-194,-223,-244,-198,-164,-153,-134,-94,-61,-45,-32,-32,-26,-42,-85,-115,-110,-102,-132,-150,-126,-80,-36,-46,-98,-124,-81,-31,-22,-51,-98,-110,-93},
            {6,6,-7,-7,-8,3,-2,-4,-2,218,4493,8147,-3449,-14466,-5788,3295,11052,16798,7437,-462,2629,5812,492,-5785,-5176,-4956,-5832,-4844,-3288,-3973,-2779,-339,1027,1217,1548,3332,2649,1490,1445,659,-424,432,-201,-1409,-1480,-1160,-956,-1308,-1412,-1501,-767,-185,-221,-79,440,820,670,202,-352,-601,-598,-563,-509,-510,-266,-171,-145,-144,-67,31,67,-29,-189,-75,24,-46,-257,-279,-227,-159,-89,-31,-69,-120,-148,-179,-188,-88,21,16,-43,-103,-140,-110,-17,-18,-120,-242,-251,-209,-175,-212,-201,-149,-93,-44,-47,-78,-87,-67,-73,-82,-77,-70,-109,-141,-143,-146,-162,-141,-96,-70,-41,32,87,97,89,62}
        },
        {    // H40e141a.wav
            {1,1,1,-1,-2,-2,0,1,0,-1,-1,0,2,0,0,-7,-1,-7,11,-8,9,99,1532,3240,297,-5248,-5578,-195,5001,6939,5102,2163,1719,2312,1364,-271,-804,-1311,-2169,-2390,-2178,-2068,-1953,-1302,-763,-684,470,1608,1810,1671,1068,1053,841,263,-340,-1048,-1250,-873,-525,-802,-1067,-710,-132,-90,-196,-62,99,184,108,104,160,129,-12,-220,-356,-363,-434,-645,-755,-699,-542,-320,-172,-116,-41,27,91,71,-5,-97,-259,-315,-248,-194,-223,-253,-221,-188,-218,-216,-141,-84,-51,-43,-50,-41,-14,-21,-65,-119,-128,-122,-137,-148,-129,-73,-27,-25,-69,-107,-102,-61,-29,-46,-89,-113,-102,-105},
            {9,3,2,-10,-4,-3,3,-10,14,-49,939,6206,5942,-7885,-12811,-3578,5415,15058,14418,3192,-419,4071,4939,-1937,-5748,-4571,-4983,-5487,-4049,-3354,-3686,-1686,66,1078,994,2197,3078,1724,1559,1361,76,40,416,-736,-1357,-1437,-1017,-1155,-1439,-1411,-1159,-477,-181,-220,76,729,805,476,139,-316,-661,-668,-456,-510,-539,-290,-171,-136,-157,-83,-2,80,-48,-136,-53,4,-91,-236,-243,-209,-149,-87,-28,-80,-155,-202,-219,-184,-55,5,-30,-73,-92,-124,-79,-8,-34,-134,-223,-236,-199,-175,-202,-200,-181,-119,-64,-61,-73,-49,-52,-65,-71,-77,-90,-121,-135,-141,-145,-144,-132,-124,-75,4,76,97,90,80}
        },
        {    // H40e148a.wav
            {3,0,-1,-2,-2,1,1,-1,-2,-2,0,3,-1,0,-7,0,-11,9,-7,12,67,1504,3506,521,-5486,-5985,-390,5236,7518,5453,2032,1651,2474,1460,-420,-1040,-1460,-2298,-2518,-2271,-2095,-1905,-1321,-611,-593,-87,1258,1999,1907,1168,1075,867,247,-170,-950,-1494,-1114,-506,-670,-943,-665,-177,-36,-21,32,-1,71,83,44,101,118,-5,-227,-387,-338,-348,-544,-688,-787,-598,-258,-170,-195,-161,6,106,75,19,-99,-209,-192,-184,-244,-263,-234,-210,-223,-248,-234,-178,-109,-52,-39,-43,-35,-25,-20,-42,-89,-125,-157,-169,-170,-136,-81,-43,-48,-61,-65,-62,-56,-72,-83,-85,-82,-91,-135,-168},
            {0,10,0,-1,-12,-3,-4,1,-10,14,-28,1863,7099,3033,-10292,-11228,-1827,8858,16389,10779,916,268,4993,3480,-3492,-5219,-4116,-4940,-5057,-3516,-3419,-3037,-1076,242,927,1182,2598,2185,1495,1760,856,117,346,61,-880,-1416,-1319,-1059,-1401,-1470,-1200,-798,-421,-171,-81,330,752,669,421,154,-353,-737,-626,-399,-452,-497,-372,-229,-156,-180,-137,-61,21,-54,-55,-4,-19,-106,-160,-170,-192,-162,-67,-41,-137,-214,-237,-247,-187,-64,-42,-46,-50,-101,-131,-48,15,-30,-139,-217,-227,-171,-160,-207,-232,-204,-116,-68,-69,-66,-41,-39,-39,-61,-106,-133,-124,-122,-137,-130,-138,-152,-102,-28,42,80,78,77}
        },
        {    // H40e154a.wav
            {1,-2,-2,-2,2,2,-1,-2,0,2,2,-1,1,-7,3,-10,10,-9,19,121,1952,3861,-329,-6612,-5848,653,6346,8228,5214,1471,1717,2725,1231,-824,-1343,-1851,-2588,-2628,-2331,-2219,-1869,-1152,-380,-286,-110,1075,1913,1958,1255,995,781,263,-113,-915,-1578,-1411,-760,-636,-765,-558,-158,104,165,178,104,29,-11,60,138,29,-158,-313,-359,-331,-385,-613,-820,-685,-306,-148,-219,-256,-133,28,56,-3,-79,-68,-33,-99,-209,-249,-240,-227,-246,-269,-275,-235,-170,-119,-64,-31,-25,-26,2,7,-33,-92,-133,-139,-169,-201,-172,-103,-66,-70,-67,-61,-30,-9,-50,-92,-103,-95,-90,-115,-151,-136},
            {-3,2,10,-1,1,-13,1,-8,4,-9,9,8,2095,6953,2088,-10421,-10992,-1041,10393,15614,9105,404,467,5111,2759,-3612,-4608,-3691,-4738,-4699,-3249,-3253,-2665,-1022,110,845,1479,2159,1569,1738,1639,790,387,266,-5,-893,-1397,-1300,-1222,-1498,-1476,-927,-544,-444,-205,177,437,523,639,525,129,-374,-601,-521,-354,-345,-476,-540,-396,-250,-240,-222,-207,-63,28,52,46,-4,-70,-45,-51,-161,-200,-114,-74,-165,-244,-299,-350,-233,-59,-37,-68,-78,-93,-80,9,26,-57,-151,-175,-172,-162,-179,-210,-218,-187,-125,-112,-111,-57,-3,-11,-45,-86,-136,-161,-135,-109,-95,-110,-142,-123,-58,2,33,39,47}
        },
        {    // H40e161a.wav
            {-3,-2,-1,0,2,0,-3,0,1,4,-2,2,-10,4,-12,11,-13,25,92,1970,4252,-142,-7147,-6401,693,6834,8915,5605,1252,1581,2953,1341,-1043,-1565,-2066,-2842,-2748,-2434,-2332,-1946,-1152,-269,-19,-81,860,1861,2049,1304,888,740,217,-22,-618,-1549,-1639,-1013,-799,-798,-502,-135,74,271,406,208,39,65,162,102,-47,-176,-377,-408,-352,-412,-779,-931,-587,-201,-92,-191,-152,-45,13,-19,-98,-87,33,17,-141,-195,-166,-205,-292,-311,-276,-269,-251,-178,-114,-78,-37,-7,-1,10,28,-10,-87,-118,-139,-167,-182,-175,-157,-128,-82,-65,-70,-49,-8,-1,-42,-87,-110,-105,-112,-120,-105,-117},
            {-5,0,2,7,-1,1,-16,4,-13,9,-18,17,80,2757,6878,70,-11304,-9765,1242,11834,14307,7082,-300,1244,5157,1485,-3801,-3921,-3475,-4663,-4205,-2994,-3122,-2328,-909,141,1014,1531,1542,1480,1913,1436,861,385,253,-140,-1007,-1371,-1361,-1299,-1589,-1311,-668,-432,-393,-91,305,384,506,661,459,-41,-282,-307,-418,-368,-375,-490,-630,-584,-423,-297,-265,-244,-77,83,157,73,8,23,65,-27,-166,-192,-142,-131,-216,-313,-384,-365,-219,-87,-54,-51,-61,-69,-45,17,20,-63,-143,-158,-155,-156,-166,-178,-201,-184,-147,-136,-114,-48,6,-17,-69,-125,-154,-148,-121,-83,-68,-95,-110,-88,-39,1,13,16}
        },
        {    // H40e167a.wav
            {-4,-3,1,2,-3,-3,-2,1,3,-4,-2,-12,3,-15,11,-20,26,165,2558,4642,-1283,-8488,-6153,2069,8241,9580,5090,636,1847,3226,937,-1596,-1862,-2450,-3228,-2830,-2501,-2492,-1936,-978,-54,226,111,874,1854,2067,1414,813,418,123,-126,-625,-1364,-1641,-1272,-970,-834,-559,-164,120,324,434,365,154,230,321,79,-128,-249,-357,-402,-461,-724,-961,-795,-456,-289,-251,-72,97,109,11,-127,-110,52,79,-104,-207,-149,-120,-227,-336,-365,-338,-304,-227,-151,-99,-86,-68,-18,18,47,30,-27,-91,-121,-132,-157,-181,-183,-181,-174,-135,-103,-102,-68,-25,-14,-25,-59,-93,-103,-114,-130,-116,-109,-130},
            {1,-4,-1,2,8,-3,3,-17,4,-15,12,-19,19,70,2546,6497,190,-10773,-9477,1431,11142,13213,6879,-176,1234,4771,1425,-3218,-3412,-3138,-4345,-3924,-2873,-2951,-2269,-1023,55,1025,1160,1119,1566,1884,1499,969,463,253,-237,-927,-1379,-1360,-1387,-1547,-1112,-633,-422,-252,56,153,317,619,647,303,-12,4,-44,-338,-455,-437,-584,-746,-759,-632,-413,-234,-165,-119,83,239,115,26,132,181,-19,-193,-212,-151,-201,-302,-367,-405,-363,-261,-125,-31,-9,-55,-87,-38,45,31,-51,-128,-153,-142,-118,-129,-168,-199,-188,-151,-144,-126,-80,-40,-40,-67,-114,-152,-140,-74,-43,-72,-93,-86,-79,-51,-20,-6}
        },
        {    // H40e174a.wav
            {-3,2,3,-1,-3,0,1,6,-2,1,-13,5,-16,15,-22,30,121,2510,5156,-866,-9103,-6999,1997,8861,10380,5587,383,1690,3586,1064,-1907,-2143,-2593,-3555,-3030,-2524,-2633,-2074,-1030,48,470,262,810,1707,2088,1521,975,391,10,-208,-693,-1176,-1548,-1360,-1169,-940,-605,-240,35,247,403,352,394,452,344,69,-52,-129,-318,-425,-622,-874,-920,-699,-565,-442,-261,-49,158,160,30,-53,87,131,-20,-139,-160,-153,-175,-235,-307,-370,-390,-340,-239,-129,-73,-62,-62,-49,10,59,44,-18,-77,-112,-134,-131,-151,-171,-190,-180,-157,-156,-130,-69,-34,-32,-36,-46,-65,-69,-79,-120,-129,-110,-105,-101},
            {5,0,-3,1,5,8,-1,2,-14,9,-15,17,-23,28,129,2871,6101,-1002,-10756,-8144,2596,10899,12064,5858,-257,1730,4366,888,-2918,-2901,-2983,-4156,-3591,-2710,-2786,-2136,-999,136,975,809,997,1618,1893,1542,962,514,79,-315,-919,-1356,-1369,-1452,-1332,-1008,-646,-398,-52,168,79,283,699,671,222,28,82,51,-255,-524,-631,-698,-821,-810,-665,-460,-224,-76,-2,50,156,179,137,163,134,-37,-200,-245,-183,-232,-335,-396,-406,-354,-254,-114,-27,-27,-68,-69,-5,49,27,-53,-114,-129,-118,-113,-147,-164,-175,-176,-167,-168,-151,-94,-54,-50,-66,-97,-122,-101,-39,-57,-103,-96,-80,-82,-71,-41}
        },
        {    // H40e180a.wav
            {0,3,-1,-5,-1,1,7,-4,2,-16,5,-17,13,-22,26,78,2374,5631,-187,-9569,-8062,1632,9440,11266,6237,243,1428,3934,1297,-2229,-2499,-2674,-3848,-3366,-2563,-2706,-2214,-1122,31,735,475,820,1567,2017,1618,1021,509,-5,-219,-822,-1220,-1407,-1415,-1237,-1041,-695,-326,21,166,203,273,606,651,277,57,33,17,-213,-491,-736,-851,-849,-756,-653,-504,-276,-66,116,107,36,106,201,143,20,-73,-181,-243,-212,-199,-302,-420,-418,-347,-245,-142,-74,-48,-56,-52,-8,41,20,-23,-70,-114,-133,-137,-142,-156,-175,-185,-189,-185,-152,-88,-53,-60,-56,-57,-74,-77,-62,-92,-115,-102,-109,-104,-73},
            {0,3,-1,-5,-1,1,7,-4,2,-16,5,-17,13,-22,26,78,2374,5631,-187,-9569,-8062,1632,9440,11266,6237,243,1428,3934,1297,-2229,-2499,-2674,-3848,-3366,-2563,-2706,-2214,-1122,31,735,475,820,1567,2017,1618,1021,509,-5,-219,-822,-1220,-1407,-1415,-1237,-1041,-695,-326,21,166,203,273,606,651,277,57,33,17,-213,-491,-736,-851,-849,-756,-653,-504,-276,-66,116,107,36,106,201,143,20,-73,-181,-243,-212,-199,-302,-420,-418,-347,-245,-142,-74,-48,-56,-52,-8,41,20,-23,-70,-114,-133,-137,-142,-156,-175,-185,-189,-185,-152,-88,-53,-60,-56,-57,-74,-77,-62,-92,-115,-102,-109,-104,-73}
        }
    },
    {    // elev50
        {    // H50e000a.wav
            {6,3,-28,36,-72,106,-153,207,-55,3561,4741,2370,-8236,-16173,2342,12509,15337,11784,-651,-2615,1849,1809,-3284,-4373,-6525,-4665,-2274,-3453,-2739,-1821,-132,714,1933,2744,1924,2097,2159,1087,120,-81,-368,-231,-1666,-2489,-1566,-1430,-790,168,278,65,673,811,622,170,-179,379,627,158,-162,89,-134,-577,-690,-907,-1243,-1497,-1325,-860,-515,-319,-25,162,84,203,233,183,204,107,-184,-298,-209,-219,-281,-322,-357,-451,-374,-248,-178,-187,-158,-77,33,173,222,142,-13,-65,-90,-107,-141,-240,-280,-229,-171,-132,-133,-123,-110,-124,-99,-64,-85,-84,-63,-60,-25,-24,-57,-65,-73,-84,-103,-132,-110,-63,-31,-45},
            {6,3,-28,36,-72,106,-153,207,-55,3561,4741,2370,-8236,-16173,2342,12509,15337,11784,-651,-2615,1849,1809,-3284,-4373,-6525,-4665,-2274,-3453,-2739,-1821,-132,714,1933,2744,1924,2097,2159,1087,120,-81,-368,-231,-1666,-2489,-1566,-1430,-790,168,278,65,673,811,622,170,-179,379,627,158,-162,89,-134,-577,-690,-907,-1243,-1497,-1325,-860,-515,-319,-25,162,84,203,233,183,204,107,-184,-298,-209,-219,-281,-322,-357,-451,-374,-248,-178,-187,-158,-77,33,173,222,142,-13,-65,-90,-107,-141,-240,-280,-229,-171,-132,-133,-123,-110,-124,-99,-64,-85,-84,-63,-60,-25,-24,-57,-65,-73,-84,-103,-132,-110,-63,-31,-45}
        },
        {    // H50e008a.wav
            {16,-8,27,-39,41,-67,73,-88,115,-109,1575,4328,3099,-2292,-14387,-7618,6914,13230,16225,5951,-1932,-961,1456,-533,-2125,-4189,-5302,-3056,-3497,-2929,-2165,-1677,-51,1243,1942,1752,1894,1993,2301,1310,343,-216,-668,-1301,-2248,-1689,-1358,-793,-69,141,-61,255,615,499,369,-157,80,803,753,71,-177,-165,-586,-647,-664,-1091,-1381,-1247,-766,-513,-466,-179,224,99,-158,-82,73,124,151,16,-246,-243,-180,-260,-357,-341,-356,-394,-374,-259,-156,-113,-26,33,107,168,172,105,-23,-76,-122,-188,-224,-218,-195,-172,-127,-170,-207,-141,-65,-13,-15,-85,-154,-141,-66,35,46,-45,-121,-121,-74,-45,-67,-136,-152,-90},
            {21,-56,68,-108,145,-198,250,-212,3354,5668,3267,-7423,-19753,472,14968,16583,13880,-13,-3705,882,2445,-3656,-5156,-6820,-5699,-2082,-3140,-2901,-2190,-155,1026,1780,2956,2352,2156,2209,1288,-8,-303,-473,-75,-1382,-2848,-1973,-1508,-924,126,411,95,694,915,874,385,-340,178,503,271,103,1,-145,-361,-648,-973,-1294,-1594,-1732,-1212,-357,-147,-289,66,394,429,357,344,267,145,-101,-353,-392,-322,-208,-327,-453,-423,-303,-265,-197,-146,-116,-65,22,164,213,151,5,-106,-135,-125,-163,-263,-298,-225,-181,-133,-104,-108,-92,-111,-113,-103,-89,-40,-56,-86,-43,-20,-53,-84,-93,-111,-124,-100,-50,-34,-28,-30,-31}
        },
        {    // H50e016a.wav
            {-3,13,-7,21,-30,31,-56,59,-73,101,-94,1495,3678,2782,-2101,-12222,-6642,5240,11430,14010,5814,-670,-227,1548,-372,-1844,-3560,-4611,-3180,-3251,-2573,-2139,-1709,-105,1015,1469,1555,1723,1882,2239,1291,379,-16,-417,-1201,-1885,-1425,-1223,-783,-289,-105,-100,186,352,294,230,-57,236,831,740,126,-241,-344,-436,-592,-829,-1071,-1165,-1022,-644,-361,-385,-321,13,94,-94,-220,-131,55,92,-6,-164,-233,-248,-259,-314,-413,-408,-311,-281,-239,-157,-62,-3,36,100,121,130,86,9,-82,-121,-152,-227,-235,-216,-187,-153,-148,-163,-132,-67,-39,-29,-80,-122,-117,-75,15,13,-51,-96,-110,-103,-75,-62,-102,-142},
            {-62,76,-127,154,-190,220,-260,2631,6459,4459,-5161,-22651,-4107,17043,17980,16110,1251,-4081,-102,2541,-3139,-6219,-7353,-6659,-2301,-2919,-2638,-2275,-657,1128,2043,2956,2337,2529,2326,1346,100,-383,-646,-100,-1056,-2946,-2354,-1706,-1033,-37,434,226,706,933,1001,794,-266,-332,166,607,377,-141,-173,-295,-507,-850,-1260,-1778,-2220,-1446,-170,-56,-464,33,487,616,618,399,260,217,-12,-413,-481,-325,-272,-442,-433,-361,-344,-289,-182,-95,-72,-30,28,142,236,215,9,-152,-191,-181,-181,-273,-315,-274,-228,-125,-71,-93,-96,-101,-104,-102,-75,-42,-66,-93,-43,-13,-48,-114,-155,-147,-108,-56,-30,-42,-7,10,-18,-17}
        },
        {    // H50e024a.wav
            {-3,-2,8,-6,15,-25,21,-46,48,-58,77,-72,1301,3118,2569,-1605,-10303,-6235,3686,9580,12278,5975,367,380,1525,-245,-1451,-2935,-4105,-3073,-2907,-2377,-2126,-1660,-236,691,1148,1379,1588,1650,1994,1414,650,256,-203,-988,-1633,-1361,-1227,-923,-503,-206,-125,-108,92,352,254,33,364,818,667,183,-162,-438,-536,-631,-860,-995,-948,-841,-620,-371,-294,-293,-131,31,-49,-192,-217,-104,25,-49,-180,-246,-336,-335,-291,-333,-372,-292,-180,-127,-111,-59,-7,25,64,92,109,74,-13,-100,-125,-171,-232,-257,-223,-167,-129,-109,-130,-115,-80,-51,-35,-78,-123,-103,-55,-9,-12,-78,-114,-112,-108,-83,-67,-73},
            {44,-94,112,-104,102,-119,1519,6776,5784,-1654,-23329,-11609,17404,19728,18364,3843,-4540,-850,2763,-2161,-6971,-7905,-8205,-2824,-2689,-2731,-1805,-951,809,1988,3470,2359,2287,2689,1643,66,-362,-689,-216,-626,-2973,-2797,-1918,-1069,-150,272,218,878,1041,948,1212,-72,-943,34,926,235,-270,-58,-191,-469,-639,-1231,-1991,-2279,-1521,-318,-127,-399,18,592,748,630,453,367,293,10,-410,-511,-371,-290,-426,-465,-423,-353,-272,-148,-44,-66,-16,35,154,287,265,49,-152,-216,-235,-225,-251,-337,-329,-265,-143,-58,-80,-82,-117,-108,-51,-11,-48,-111,-91,-41,-1,-31,-142,-193,-135,-67,-54,-55,-40,29,38,-14,-24,-40}
        },
        {    // H50e032a.wav
            {-1,-2,1,6,-4,12,-20,17,-36,37,-43,54,-47,1101,2648,2409,-1074,-8730,-6003,2401,8019,10884,5996,1178,853,1426,-65,-1073,-2395,-3588,-2827,-2593,-2251,-2027,-1588,-400,445,889,1067,1322,1568,2005,1606,896,490,14,-957,-1669,-1352,-1262,-1011,-592,-402,-370,-157,194,336,334,184,330,793,724,112,-288,-432,-537,-731,-900,-819,-746,-817,-652,-337,-214,-242,-170,-18,-11,-122,-230,-279,-123,-82,-254,-330,-355,-329,-271,-259,-267,-213,-127,-72,-57,-66,-32,14,63,91,62,11,-69,-119,-138,-199,-239,-225,-173,-124,-88,-87,-110,-93,-90,-68,-45,-67,-107,-107,-60,-32,-37,-102,-141,-110,-91,-75,-55},
            {-17,-13,60,-117,174,305,6125,6991,2433,-19882,-20994,13611,21693,20205,8301,-3933,-2132,2298,280,-7114,-8489,-9427,-4708,-2659,-2860,-1689,-1013,849,1581,3569,2894,2267,2559,1929,482,-483,-673,-444,-213,-2553,-3298,-2429,-1201,-145,187,109,740,1336,1004,1402,198,-1244,-121,1026,234,-531,-281,-76,-222,-481,-1308,-2229,-2016,-1235,-624,-368,-362,67,670,759,561,475,423,331,130,-358,-607,-491,-247,-287,-496,-543,-412,-238,-93,-8,-56,-54,29,162,265,288,120,-106,-220,-277,-240,-254,-343,-371,-304,-178,-84,-81,-127,-109,-87,-43,-6,-41,-83,-89,-68,-48,-43,-142,-170,-94,-76,-70,-58,-28,9,7,-19,-13,-6,0}
        },
        {    // H50e040a.wav
            {1,-2,-2,0,4,-3,10,-17,15,-30,29,-38,43,-33,921,2267,2268,-612,-7511,-5818,1443,6794,9677,5857,1795,1164,1364,142,-767,-1950,-3073,-2510,-2372,-2088,-1858,-1497,-566,45,577,994,1345,1571,1996,1735,1025,513,-24,-1060,-1697,-1312,-1222,-1176,-861,-373,-291,-172,263,512,408,98,382,800,480,-81,-225,-366,-662,-804,-765,-705,-755,-759,-576,-340,-203,-161,-105,-9,-23,-162,-273,-312,-284,-266,-291,-306,-335,-345,-259,-160,-137,-138,-135,-82,-23,-21,-19,-3,31,40,-15,-76,-126,-159,-167,-168,-185,-190,-141,-78,-48,-81,-116,-107,-90,-56,-44,-86,-145,-136,-81,-49,-62,-114,-148,-128,-76,-40},
            {-106,187,-262,342,-363,4207,7840,5732,-12115,-28002,3817,23101,20770,13575,-1334,-2860,934,2390,-5237,-8929,-9930,-7016,-3430,-3733,-1569,-1333,582,1744,3405,3400,2282,2880,2049,717,-295,-599,-746,-3,-1804,-3498,-2940,-1725,-306,134,141,555,1360,1281,1392,318,-906,-130,537,459,-477,-786,-233,-34,-339,-1294,-2201,-1916,-851,-649,-682,-304,206,532,498,574,601,408,318,240,-261,-644,-504,-282,-265,-405,-536,-489,-278,-37,33,-65,-46,57,93,191,265,198,-44,-211,-261,-231,-223,-334,-376,-333,-215,-107,-108,-160,-99,-59,-75,-37,-40,-69,-48,-68,-98,-97,-119,-113,-76,-68,-73,-40,-12,-11,-39,-50,-9,10,17,-3}
        },
        {    // H50e048a.wav
            {-1,2,1,-2,1,4,-1,9,-11,15,-24,26,-34,42,-25,808,1985,2148,-346,-6678,-5559,913,5969,8630,5568,2176,1375,1330,294,-549,-1588,-2526,-2193,-2159,-1836,-1694,-1629,-839,17,654,1011,1321,1527,1882,1596,901,430,-97,-1140,-1614,-1307,-1425,-1171,-584,-368,-393,105,498,454,394,102,192,586,420,-136,-319,-342,-628,-777,-697,-683,-699,-673,-519,-322,-158,-47,-34,-51,-90,-185,-324,-380,-374,-336,-301,-322,-312,-262,-174,-117,-110,-89,-90,-58,0,26,1,-45,-41,-40,-87,-144,-163,-149,-119,-110,-148,-154,-87,-33,-29,-76,-114,-90,-66,-62,-78,-122,-162,-149,-98,-58,-60,-101,-119,-109,-71},
            {96,-124,152,-183,1534,7458,7893,-2340,-27641,-11846,21199,21569,17157,4125,-2565,-653,3286,-1408,-9218,-9755,-8608,-4706,-4849,-2788,-1499,-336,1571,3223,4329,2420,2986,2715,1125,-182,-463,-872,-272,-840,-3186,-3590,-2321,-612,-170,27,519,1248,1620,1407,351,-517,74,258,320,-128,-1012,-692,-131,-242,-1261,-2064,-1688,-720,-581,-668,-280,209,520,276,255,583,627,367,153,-162,-471,-549,-365,-223,-350,-476,-485,-319,-79,44,18,-45,35,62,120,211,197,11,-210,-243,-223,-165,-260,-352,-332,-258,-138,-112,-154,-103,-64,-89,-75,-72,-76,-54,-65,-120,-115,-92,-89,-78,-66,-50,-24,2,-1,-52,-68,-48,-7,9,18,-4}
        },
        {    // H50e056a.wav
            {-3,0,1,0,0,-1,3,-1,5,-8,13,-23,22,-30,39,-15,778,1796,2040,-408,-6273,-5108,896,5567,7693,5081,2329,1476,1273,426,-381,-1313,-2013,-1857,-2006,-1778,-1623,-1475,-707,138,685,895,1155,1284,1529,1374,804,317,-205,-1140,-1707,-1300,-1074,-945,-615,-424,-63,342,452,427,138,-146,182,554,205,-264,-252,-287,-627,-719,-623,-687,-677,-554,-415,-279,-119,-6,-21,-115,-159,-248,-391,-381,-365,-403,-376,-265,-191,-205,-175,-115,-78,-43,-24,-17,-8,5,-38,-95,-123,-131,-143,-156,-131,-99,-85,-97,-112,-109,-56,-6,-10,-70,-114,-96,-87,-94,-110,-144,-174,-161,-116,-65,-39,-60,-97,-117},
            {119,-209,314,-299,4808,8679,5613,-17050,-26753,9744,23821,18413,10404,1,-1284,1650,3457,-6412,-10775,-9526,-6009,-5058,-4740,-2266,-1866,727,2326,4744,3612,2781,3485,2091,251,-389,-674,-791,-373,-2214,-3705,-3332,-1282,-269,-322,215,1011,1774,1689,571,-238,57,292,340,29,-895,-992,-461,-399,-1097,-1860,-1651,-820,-444,-389,-244,36,504,358,15,206,638,535,168,-85,-325,-508,-465,-235,-257,-411,-467,-360,-149,31,93,5,-36,43,69,160,193,54,-207,-300,-242,-145,-143,-273,-312,-259,-185,-132,-106,-99,-70,-97,-96,-115,-110,-75,-105,-149,-122,-60,-62,-88,-71,-39,-25,-6,22,-7,-54,-75,-58,-10,14,2,-51}
        },
        {    // H50e064a.wav
            {-4,-1,0,-1,1,-2,-1,1,0,1,-4,9,-21,16,-23,39,6,858,1708,1945,-996,-6307,-4248,1493,5594,6820,4406,2210,1466,1256,533,-265,-1138,-1627,-1766,-1868,-1390,-1297,-1246,-646,188,548,548,823,1047,1299,1144,704,222,-545,-1132,-1178,-1044,-1045,-837,-488,-292,174,446,176,-8,35,0,107,312,69,-199,-184,-297,-583,-662,-646,-678,-558,-404,-341,-262,-107,-20,-71,-181,-243,-300,-374,-401,-399,-381,-315,-217,-171,-174,-156,-99,-35,11,10,-32,-59,-63,-98,-154,-188,-168,-129,-115,-93,-75,-72,-85,-90,-66,-20,11,-18,-86,-138,-130,-108,-106,-125,-171,-186,-160,-106,-51,-25,-50,-97},
            {-61,77,-109,930,7104,9085,-1268,-27410,-13329,21110,20756,14961,5243,-507,-391,4272,927,-9706,-10641,-8250,-5232,-5729,-3339,-2789,-1808,1112,3441,4796,3023,3865,3457,1404,26,-266,-1022,-526,-1134,-3200,-3888,-2501,-683,-662,-172,648,1372,1859,1175,147,2,251,466,255,-620,-1067,-672,-653,-1091,-1631,-1590,-1093,-561,-200,-37,32,248,448,126,-42,296,564,269,13,-201,-443,-496,-274,-163,-335,-463,-391,-229,-41,113,102,-35,-41,28,89,180,113,-131,-352,-343,-225,-98,-165,-243,-235,-208,-156,-80,-81,-76,-70,-117,-148,-158,-105,-144,-197,-166,-81,-50,-85,-78,-33,-31,-30,12,22,-18,-50,-70,-50,-20,-11,-54,-76}
        },
        {    // H50e072a.wav
            {-3,-2,-1,0,0,0,-3,2,-3,2,-3,4,-4,-12,6,0,12,97,1051,1749,1707,-2392,-6435,-2684,2731,5838,5809,3561,1898,1488,1279,546,-316,-1196,-1283,-1419,-1491,-1111,-1150,-1172,-725,88,247,223,656,961,1065,1054,439,-166,-190,-577,-1098,-1144,-826,-626,-471,-53,140,-48,-61,76,33,-17,60,123,24,-43,-102,-421,-637,-619,-599,-579,-429,-306,-313,-266,-150,-59,-137,-235,-283,-354,-404,-351,-284,-343,-328,-203,-137,-135,-110,-54,-14,7,-21,-89,-133,-143,-151,-170,-172,-144,-100,-80,-65,-63,-73,-77,-59,-27,-4,-10,-60,-123,-156,-136,-119,-126,-141,-168,-175,-148,-98,-39,-21,-44},
            {-163,267,-415,2423,8323,8440,-9457,-29069,-536,23266,18002,12323,3085,-771,635,5871,-2142,-10685,-9623,-7194,-5946,-5555,-2508,-3334,-1448,1139,4031,4038,3060,4530,3436,1125,168,-36,-1072,-747,-1916,-3621,-3868,-1715,-685,-999,96,994,1530,1487,795,202,137,535,547,-124,-962,-878,-580,-1199,-1548,-1560,-1256,-840,-313,1,120,208,389,339,-30,-51,333,437,93,-98,-322,-528,-368,-100,-172,-405,-452,-299,-153,37,143,97,-48,-36,8,115,170,-12,-273,-414,-339,-218,-128,-161,-169,-171,-171,-103,-45,-45,-40,-91,-142,-191,-158,-147,-224,-223,-141,-66,-87,-103,-49,-3,-27,-11,25,-3,-33,-32,-34,-32,-41,-48,-93,-67}
        },
        {    // H50e080a.wav
            {0,-1,-1,0,1,1,0,-1,4,-3,6,-5,12,-19,12,-1,29,-42,402,1350,1937,636,-4740,-5564,-18,4273,5765,4589,2689,1588,1607,1127,280,-338,-906,-1007,-1372,-1247,-1068,-1251,-1269,-757,32,46,107,631,1074,825,578,669,311,-199,-645,-1031,-1081,-699,-378,-498,-464,-124,71,-5,2,54,57,19,28,164,52,-320,-594,-580,-523,-516,-465,-328,-293,-329,-287,-180,-86,-172,-298,-385,-336,-257,-243,-302,-370,-277,-151,-86,-74,-68,-53,-47,-34,-99,-174,-187,-150,-128,-145,-127,-100,-63,-57,-59,-50,-57,-55,-40,-22,-22,-44,-87,-142,-160,-140,-116,-104,-131,-166,-158,-122,-70,-24,-10},
            {-159,276,-430,3339,8999,7071,-14975,-26203,6651,21868,16152,10936,2378,-1024,1822,6164,-4151,-10483,-8360,-6625,-6707,-5199,-2491,-3607,-1157,1392,3909,3091,3333,4653,3235,1336,630,32,-791,-867,-2567,-3757,-3430,-1430,-1151,-925,310,935,1409,1208,576,121,418,808,425,-367,-906,-661,-775,-1483,-1649,-1393,-1117,-654,-97,22,174,294,467,241,-86,-66,296,375,38,-194,-407,-480,-262,-20,-184,-408,-410,-274,-112,72,146,76,-47,-22,23,126,103,-93,-330,-424,-339,-213,-145,-152,-125,-134,-119,-65,-8,-10,-26,-106,-159,-191,-155,-193,-262,-216,-135,-91,-120,-99,-30,-3,-14,22,27,-23,-39,-20,-10,-13,-28,-62,-110,-60}
        },
        {    // H50e088a.wav
            {0,-1,-1,-1,0,1,-1,-3,3,-2,2,-5,3,-3,-3,14,10,-18,98,1021,1761,1621,-2665,-6266,-2080,3057,5224,4994,3357,1906,1494,1531,782,162,-373,-923,-1314,-1386,-1140,-1302,-1520,-1137,-346,-73,-87,440,788,543,1006,1237,558,13,-289,-807,-1160,-707,-533,-947,-862,-175,70,-23,37,56,91,164,115,32,33,-129,-471,-655,-515,-388,-431,-406,-307,-326,-381,-252,-141,-182,-283,-325,-281,-227,-203,-288,-352,-282,-156,-89,-70,-70,-96,-105,-106,-141,-191,-185,-136,-121,-125,-96,-65,-64,-76,-51,-30,-44,-63,-70,-41,-35,-49,-81,-137,-160,-147,-102,-88,-104,-130,-156,-139,-101,-34,-14},
            {-133,233,-372,3417,9176,6283,-16455,-23516,8096,19865,15280,10900,2382,-1027,2563,5816,-4644,-9816,-7347,-6290,-6951,-5194,-2885,-3774,-1218,1466,3735,2438,3165,4641,3008,1471,1240,351,-702,-808,-2508,-3866,-3109,-1340,-1601,-883,317,764,1113,964,431,71,615,910,363,-379,-686,-552,-910,-1526,-1611,-1321,-1069,-577,-26,-13,168,338,465,197,-97,-101,236,345,59,-244,-427,-412,-228,-40,-180,-350,-395,-280,-121,78,123,43,-26,-2,38,108,54,-133,-337,-416,-364,-222,-134,-156,-139,-120,-78,-41,10,10,-29,-100,-145,-186,-175,-221,-258,-216,-157,-131,-136,-101,-38,-9,-12,30,28,-26,-45,-23,4,8,-3,-57,-106,-51}
        },
        {    // H50e096a.wav
            {0,-1,-1,0,0,1,1,-2,3,0,3,-3,-1,0,0,22,-1,-2,26,889,1737,1815,-1976,-6213,-2813,2552,4892,5079,3783,2186,1614,1596,881,283,-266,-777,-1365,-1580,-1325,-1415,-1533,-1262,-372,-125,-115,344,338,814,1500,1176,670,325,-312,-852,-752,-769,-1105,-1175,-746,-288,-120,18,77,157,176,259,271,6,-180,-80,-292,-669,-562,-370,-339,-385,-375,-375,-363,-265,-218,-245,-256,-207,-218,-231,-227,-270,-278,-215,-119,-97,-122,-115,-123,-152,-176,-191,-170,-137,-128,-122,-98,-58,-42,-50,-70,-49,-25,-45,-68,-75,-56,-52,-62,-81,-126,-148,-127,-89,-67,-65,-96,-149,-151,-102,-44,-22},
            {-116,206,-345,2758,8790,6818,-14558,-22664,5370,18016,15239,11791,2947,-891,2739,5633,-3956,-9229,-6662,-5937,-6766,-5336,-3386,-4000,-1564,1111,3436,2363,2806,4329,2995,1565,1442,829,-457,-747,-2124,-3431,-3028,-1590,-1614,-979,-61,602,976,588,234,166,626,871,454,-181,-533,-444,-809,-1436,-1554,-1324,-1029,-660,-82,-16,148,304,462,253,-125,-145,177,351,124,-201,-433,-385,-199,-62,-183,-325,-362,-276,-161,39,111,40,-13,21,40,86,45,-108,-324,-409,-360,-244,-135,-148,-151,-138,-61,-20,11,15,-9,-71,-113,-163,-182,-224,-243,-222,-174,-145,-148,-104,-51,-22,-16,29,29,-20,-31,-13,15,30,17,-27,-71,-42}
        },
        {    // H50e104a.wav
            {0,-1,-1,-1,0,0,0,-1,3,-1,5,-6,-2,-8,7,19,0,-19,86,1021,1921,1670,-2859,-6368,-2023,3102,5022,4966,3765,2370,1812,1594,512,-146,-384,-920,-1490,-1628,-1567,-1650,-1493,-890,-251,-33,80,-124,527,1549,1359,939,781,240,-549,-593,-648,-1173,-1419,-992,-529,-458,-223,-60,152,343,303,224,228,111,-127,-234,-391,-537,-569,-422,-309,-356,-427,-415,-327,-286,-257,-239,-222,-201,-164,-225,-293,-222,-165,-126,-105,-132,-180,-200,-188,-216,-218,-165,-125,-142,-138,-108,-63,-38,-49,-51,-44,-41,-57,-59,-73,-86,-82,-70,-64,-87,-121,-144,-120,-68,-31,-43,-99,-149,-151,-94,-42,-40},
            {-91,152,-259,1508,7478,8442,-9298,-22743,-1194,15523,15680,13496,4418,-722,2263,5786,-1891,-8684,-6585,-5409,-6401,-5572,-3647,-4305,-2291,378,2852,2496,2413,4072,3013,1732,1513,1050,-256,-392,-1582,-2905,-2715,-1848,-1663,-1156,-465,236,845,356,-18,191,480,802,655,65,-386,-357,-506,-1237,-1465,-1347,-1106,-794,-238,-70,89,271,439,331,-88,-197,62,340,234,-91,-418,-406,-197,-58,-177,-336,-362,-264,-202,-35,75,60,-2,13,36,53,63,-54,-260,-389,-356,-267,-173,-151,-148,-159,-98,-37,2,6,10,-35,-85,-135,-162,-214,-250,-227,-190,-150,-155,-128,-72,-41,-38,2,17,-14,-23,4,24,33,27,3,-47,-49}
        },
        {    // H50e112a.wav
            {0,-3,-2,0,1,-1,0,0,4,-2,5,-7,4,-16,22,-1,21,-48,357,1473,2294,426,-5267,-5638,474,4478,5296,4615,3223,2122,2104,1309,-30,-541,-968,-1339,-1729,-1668,-1645,-1799,-1310,-356,154,146,-199,134,1404,1527,1109,880,434,-192,-369,-487,-1102,-1509,-1240,-577,-475,-484,-329,-36,374,428,268,158,172,184,-3,-337,-495,-553,-521,-364,-374,-440,-431,-371,-322,-282,-215,-173,-217,-223,-214,-217,-183,-145,-81,-91,-131,-177,-225,-270,-285,-240,-158,-105,-135,-151,-120,-60,-35,-45,-54,-50,-33,-38,-60,-74,-88,-112,-91,-57,-53,-77,-116,-123,-93,-33,-16,-56,-114,-144,-117,-58,-29,-81},
            {-27,32,-44,320,5059,9413,-1702,-20324,-10063,10390,15656,15625,7198,-274,1270,5624,1257,-7258,-7145,-5053,-5731,-5837,-3849,-4214,-3301,-655,1876,2660,1925,3645,3330,1911,1563,1269,-198,-285,-704,-2263,-2424,-1829,-1597,-1475,-878,-130,575,193,-201,134,253,613,887,370,-233,-278,-151,-873,-1355,-1322,-1178,-967,-482,-184,12,220,356,380,7,-184,-42,270,297,69,-307,-440,-234,-44,-152,-331,-355,-300,-242,-97,14,39,26,6,6,19,75,17,-159,-321,-340,-292,-209,-172,-156,-170,-131,-73,-35,-14,17,-4,-56,-79,-131,-182,-245,-243,-202,-147,-137,-147,-111,-62,-54,-27,2,-7,-20,12,39,36,39,20,-42,-37}
        },
        {    // H50e120a.wav
            {-3,0,-1,0,1,-1,-3,3,-1,3,-4,1,-8,0,11,3,-3,67,1044,2299,1822,-3385,-6970,-1982,3828,5573,5229,3720,2161,2113,1925,492,-354,-939,-1606,-2096,-1952,-1690,-1826,-1505,-667,97,435,117,-130,1234,1770,1103,962,508,-149,-241,-341,-995,-1490,-1372,-724,-428,-424,-455,-304,289,501,267,125,120,163,164,-72,-317,-508,-577,-425,-424,-497,-477,-444,-379,-265,-175,-168,-182,-231,-289,-218,-110,-57,-73,-111,-125,-180,-224,-310,-346,-246,-157,-148,-166,-143,-98,-62,-48,-44,-50,-58,-58,-56,-57,-58,-100,-131,-108,-73,-52,-58,-71,-93,-82,-47,-40,-58,-104,-139,-113,-58,-37,-71,-133},
            {30,-55,90,-155,2144,8004,5634,-12614,-17425,887,13440,17195,11604,1414,-2,4377,4344,-3792,-7644,-5348,-5001,-5759,-4426,-3751,-3967,-1934,461,2469,1830,2627,3562,2407,1735,1436,103,-537,-136,-1379,-1932,-1776,-1545,-1463,-1339,-603,252,108,-400,-48,205,338,821,723,64,-253,53,-316,-1180,-1315,-1118,-1029,-819,-436,-102,153,277,378,115,-155,-103,141,279,188,-108,-344,-293,-99,-103,-295,-344,-323,-285,-184,-55,-3,10,0,-5,-27,53,84,-36,-228,-300,-287,-242,-189,-194,-180,-145,-98,-80,-69,-10,13,-29,-37,-86,-151,-209,-237,-212,-150,-121,-151,-147,-89,-61,-54,-18,-7,-23,-3,42,54,40,7,-6,-7}
        },
        {    // H50e128a.wav
            {-3,-2,-1,0,-2,-2,0,2,1,-1,-4,-2,-11,12,-7,15,-10,765,2304,2412,-2364,-7309,-3506,3349,5972,5763,4053,2129,1964,2050,708,-223,-684,-1522,-2260,-2364,-2130,-2048,-1637,-758,86,481,386,-41,1148,2005,1182,978,515,-194,-246,-286,-924,-1516,-1453,-796,-335,-412,-447,-342,174,529,291,101,41,81,98,-39,-125,-308,-463,-386,-454,-613,-565,-483,-467,-358,-151,-45,-156,-334,-260,-152,-117,-31,-32,-100,-175,-172,-244,-363,-321,-200,-172,-210,-195,-173,-102,-47,-43,-43,-62,-48,-63,-94,-88,-83,-108,-135,-116,-76,-61,-66,-71,-65,-35,-19,-44,-82,-126,-155,-127,-65,-35,-60,-124,-158},
            {12,-16,16,-23,253,4262,8669,-1119,-16857,-11037,6190,16273,16262,5984,-515,2086,5301,1314,-6113,-6395,-4576,-5225,-5065,-3704,-3815,-3113,-1055,1328,2109,1672,2986,2899,2217,1736,555,-626,-141,-606,-1317,-1304,-1686,-1417,-1413,-1089,-224,-63,-477,-277,77,282,589,748,440,-39,70,64,-713,-1243,-1072,-931,-965,-772,-396,32,187,280,188,-108,-136,5,219,244,71,-176,-242,-163,-107,-220,-332,-310,-294,-266,-176,-87,-33,-24,-32,-32,0,90,62,-88,-233,-264,-252,-220,-211,-195,-153,-110,-110,-134,-89,-6,-1,-24,-46,-125,-163,-189,-205,-176,-133,-130,-147,-123,-91,-78,-42,-17,-25,-27,18,52,23,4,35,40}
        },
        {    // H50e136a.wav
            {-1,0,0,-1,-2,-1,2,1,2,-4,-1,-11,9,-8,19,-20,660,2416,2746,-2162,-7650,-4150,3331,6497,6292,4213,1988,1888,2101,664,-367,-702,-1515,-2238,-2381,-2292,-2362,-2049,-965,139,480,658,232,893,2216,1570,927,444,-173,-296,-477,-879,-1391,-1588,-1039,-251,-171,-422,-393,193,594,311,121,47,-20,-23,-74,-202,-263,-250,-264,-412,-585,-594,-612,-564,-389,-178,-64,-146,-239,-209,-153,-62,9,-53,-137,-156,-212,-315,-325,-235,-198,-229,-211,-181,-166,-139,-87,-48,-27,-9,-47,-87,-92,-90,-109,-152,-159,-125,-76,-51,-57,-78,-70,-13,15,-5,-61,-135,-167,-143,-97,-68,-60,-85,-135,-161},
            {-10,13,-18,23,-60,893,5925,7170,-6409,-16842,-6490,9974,17888,12898,2386,-147,3448,4792,-1105,-6534,-5153,-4408,-5118,-4387,-3405,-3542,-2445,-355,1617,1584,1786,2785,2624,2354,1175,-299,-455,-200,-733,-649,-1398,-1701,-1292,-1281,-681,-405,-695,-403,18,95,496,676,496,235,212,203,-338,-862,-905,-869,-901,-883,-714,-381,35,160,137,-37,-154,-107,76,295,212,-8,-137,-105,-122,-175,-263,-295,-295,-302,-288,-231,-141,-55,-41,-47,-38,30,98,42,-91,-217,-270,-235,-180,-191,-184,-151,-120,-142,-146,-90,-21,-13,-36,-79,-129,-139,-176,-185,-141,-105,-121,-146,-136,-111,-77,-27,-27,-34,-11,18,7,15,63,63}
        },
        {    // H50e144a.wav
            {0,3,-2,-2,1,3,3,2,-5,1,-12,8,-7,18,-15,722,2764,2897,-2813,-8282,-3910,4186,7283,6609,3972,1713,1958,2117,433,-695,-934,-1691,-2432,-2379,-2229,-2443,-2111,-1086,-31,365,831,594,811,2230,1840,932,478,-129,-387,-643,-967,-1374,-1559,-1189,-393,-46,-267,-299,187,631,413,179,38,-77,-73,-94,-273,-343,-249,-239,-337,-510,-526,-594,-660,-470,-169,-100,-207,-176,-103,-55,-17,-7,-65,-145,-187,-281,-310,-231,-192,-239,-271,-206,-139,-149,-147,-106,-86,-39,6,-18,-76,-93,-91,-106,-143,-179,-168,-107,-43,-49,-79,-49,1,14,6,-33,-99,-146,-145,-122,-91,-79,-99,-119,-124,-102},
            {-8,-6,10,-14,19,-43,1529,6746,5084,-9288,-15826,-3226,12754,17385,9633,1026,497,3995,4015,-2577,-6050,-4282,-4327,-4850,-3891,-3124,-3270,-1966,98,1455,1226,1779,2568,2745,2118,394,-406,-331,-287,-88,-630,-1785,-1454,-1196,-1003,-700,-964,-780,-85,157,310,552,525,334,295,345,-19,-576,-625,-514,-723,-926,-870,-634,-412,-133,7,-22,-142,-133,-61,164,301,204,37,-42,-57,-119,-163,-240,-299,-343,-353,-332,-257,-159,-93,-64,-28,-24,43,100,51,-92,-216,-232,-182,-156,-190,-191,-159,-122,-132,-142,-101,-38,-32,-43,-82,-129,-149,-145,-112,-91,-105,-134,-158,-152,-102,-51,-27,-24,-10,-12,-16,21,61,60}
        },
        {    // H50e152a.wav
            {1,-3,-3,0,2,1,1,-5,-1,-11,5,-12,18,-13,817,3168,3008,-3635,-9013,-3613,5145,8182,6926,3676,1469,2126,2176,109,-1074,-1233,-1936,-2615,-2443,-2252,-2501,-2053,-1001,27,252,684,924,789,1829,2115,1196,407,-71,-295,-853,-1183,-1269,-1584,-1433,-537,52,-187,-223,238,646,542,340,80,-206,-119,-36,-236,-386,-360,-393,-457,-445,-444,-611,-671,-441,-219,-126,-98,-167,-144,23,121,25,-137,-211,-252,-272,-230,-236,-288,-284,-228,-177,-187,-170,-120,-94,-83,-39,-25,-65,-72,-58,-70,-120,-165,-187,-185,-136,-95,-87,-76,-53,-18,14,12,-39,-97,-125,-126,-118,-101,-105,-129,-143,-126,-77,-42},
            {-16,3,-12,13,-20,24,-16,1968,6871,3516,-10555,-14795,-871,13980,15869,7698,749,776,4198,3313,-3219,-5260,-3706,-4202,-4567,-3463,-2916,-3098,-1602,227,1145,1005,1703,2562,2741,1527,110,-293,-390,266,252,-1177,-1759,-1220,-1099,-927,-1089,-1162,-538,32,421,551,316,302,417,416,163,-234,-428,-293,-239,-599,-1009,-934,-592,-491,-400,-226,-124,-94,-73,13,168,246,274,167,26,-71,-85,-129,-262,-366,-401,-386,-360,-278,-197,-119,-61,-26,-16,44,113,69,-85,-188,-195,-161,-170,-194,-187,-156,-111,-116,-137,-110,-46,-45,-69,-93,-131,-137,-87,-63,-90,-126,-145,-160,-139,-85,-46,-23,4,-5,-41,-17,31,52}
        },
        {    // H50e160a.wav
            {-1,-3,1,4,2,1,-7,0,-9,6,-12,18,-4,1007,3705,2970,-4863,-9804,-2884,6474,9155,7102,3202,1213,2390,2246,-312,-1505,-1586,-2300,-2843,-2503,-2255,-2546,-2045,-858,223,397,723,1122,871,1315,1945,1416,536,79,-359,-979,-1242,-1264,-1570,-1540,-811,-44,18,-98,221,588,661,536,158,-184,-154,-17,-150,-339,-428,-549,-569,-513,-543,-689,-658,-429,-89,54,-144,-207,-16,150,129,12,-114,-247,-256,-189,-232,-332,-333,-277,-238,-197,-184,-152,-120,-78,-30,-14,-33,-72,-87,-62,-55,-89,-155,-203,-183,-132,-101,-104,-103,-86,-37,17,17,-36,-92,-119,-110,-80,-69,-98,-135,-143,-130,-85,-37,-64},
            {-1,-14,3,-12,13,-22,26,6,2158,6626,2574,-10861,-13721,516,13829,14287,6836,797,871,4201,2721,-3240,-4422,-3283,-4006,-4259,-3110,-2815,-2925,-1413,100,875,844,1664,2535,2410,1139,132,-361,27,859,-104,-1443,-1546,-1131,-1019,-1122,-1400,-1022,-357,158,642,549,115,154,531,457,-7,-248,-174,-62,-144,-516,-1011,-1055,-760,-568,-526,-459,-197,-9,29,69,143,183,320,316,95,-107,-144,-156,-268,-383,-452,-470,-390,-252,-202,-167,-111,-31,38,86,89,27,-74,-145,-170,-183,-200,-198,-162,-131,-126,-122,-119,-99,-63,-85,-98,-84,-113,-133,-96,-75,-85,-109,-139,-151,-131,-82,-40,-3,-5,-63,-54,1,20}
        },
        {    // H50e168a.wav
            {-4,1,5,0,0,-8,-1,-9,7,-14,19,4,1260,4319,2798,-6314,-10576,-1887,8030,10133,7105,2593,1026,2750,2272,-846,-1976,-1926,-2692,-3106,-2591,-2327,-2552,-1921,-758,305,616,932,1378,1193,840,1326,1527,636,153,-225,-1099,-1373,-1176,-1498,-1646,-977,-226,6,46,290,513,651,622,191,-97,27,98,-193,-388,-430,-519,-617,-695,-751,-848,-738,-324,74,37,-124,-58,113,181,145,36,-147,-200,-131,-212,-366,-356,-309,-335,-305,-221,-179,-167,-86,-17,-43,-14,8,-39,-93,-91,-74,-107,-155,-182,-175,-139,-93,-92,-128,-125,-66,-5,-15,-62,-87,-114,-102,-63,-47,-74,-106,-134,-152,-101,-50,-74,-99},
            {3,-2,-12,2,-10,12,-22,25,19,2108,6177,2195,-10382,-12748,841,12813,12992,6620,1030,902,3988,2367,-2811,-3670,-2929,-3769,-3944,-2856,-2745,-2766,-1418,-108,648,750,1637,2320,2034,1021,74,-121,760,779,-485,-1317,-1427,-1071,-1064,-1408,-1480,-787,-185,287,585,419,151,223,493,407,11,-116,-41,-3,-173,-539,-876,-1118,-1031,-670,-490,-509,-300,-14,162,163,124,157,299,354,135,-145,-191,-183,-297,-411,-454,-451,-400,-298,-223,-161,-87,-4,32,69,79,22,-77,-134,-161,-173,-188,-183,-167,-146,-116,-88,-91,-119,-99,-90,-83,-77,-116,-154,-127,-76,-44,-68,-121,-150,-119,-65,-39,-29,-67,-86,-34,6}
        },
        {    // H50e176a.wav
            {1,7,1,0,-8,0,-9,9,-15,22,13,1563,4976,2549,-7845,-11309,-784,9711,11098,6974,1961,896,3180,2286,-1470,-2515,-2275,-3062,-3355,-2689,-2465,-2565,-1760,-559,368,705,1242,1629,1547,792,569,1232,899,166,-277,-1091,-1385,-1119,-1409,-1693,-1142,-352,0,97,282,470,606,620,169,-46,244,248,-161,-398,-461,-439,-605,-877,-993,-1009,-652,-186,-77,-92,22,152,209,184,146,45,-17,-41,-161,-329,-359,-335,-362,-384,-359,-272,-209,-136,-42,-23,-25,15,29,-3,-71,-113,-106,-116,-173,-195,-167,-109,-75,-92,-130,-140,-72,-36,-62,-80,-101,-130,-101,-50,-35,-44,-72,-129,-154,-99,-43,-78,-115,-64},
            {8,-1,0,-10,0,-10,10,-20,22,20,1872,5606,2271,-9279,-11978,248,11338,11998,6762,1430,881,3603,2264,-2142,-3038,-2625,-3453,-3608,-2750,-2642,-2628,-1562,-350,478,736,1496,1961,1772,925,136,570,1054,363,-442,-1155,-1402,-1052,-1213,-1651,-1364,-529,-37,251,366,361,383,519,300,124,195,133,-43,-196,-340,-514,-711,-988,-1167,-902,-466,-357,-296,-58,178,209,164,168,225,214,104,-87,-219,-259,-320,-389,-421,-424,-391,-315,-215,-122,-62,-22,6,61,60,-5,-85,-113,-126,-144,-182,-205,-179,-115,-75,-84,-110,-131,-100,-74,-69,-79,-123,-160,-121,-52,-25,-44,-89,-136,-134,-75,-37,-74,-111,-71,-19}
        }
    },
    {    // elev60
        {    // H60e000a.wav
            {16,-28,24,-11,-17,31,549,3878,4380,3365,-10240,-11245,7885,11168,8701,3347,1360,2913,2769,-1090,-5608,-5508,-5370,-2927,-2680,-2736,-1296,-656,378,1081,2018,1686,1672,1403,1229,573,-184,210,148,13,-1031,-1847,-2064,-1499,-978,-426,221,579,548,262,530,725,549,266,-196,-528,-380,-199,-209,-157,-203,-411,-550,-658,-544,-684,-1159,-1319,-739,-20,194,213,109,-45,-79,-31,25,52,80,-28,-259,-429,-408,-185,-83,-139,-281,-423,-403,-311,-138,81,88,-34,-135,-114,33,126,11,-114,-135,-116,-55,-33,-68,-147,-235,-261,-209,-100,-52,-120,-155,-146,-98,-34,-1,-6,-40,-91,-64,12,26,-14,-86,-177,-191,-84},
            {16,-28,24,-11,-17,31,549,3878,4380,3365,-10240,-11245,7885,11168,8701,3347,1360,2913,2769,-1090,-5608,-5508,-5370,-2927,-2680,-2736,-1296,-656,378,1081,2018,1686,1672,1403,1229,573,-184,210,148,13,-1031,-1847,-2064,-1499,-978,-426,221,579,548,262,530,725,549,266,-196,-528,-380,-199,-209,-157,-203,-411,-550,-658,-544,-684,-1159,-1319,-739,-20,194,213,109,-45,-79,-31,25,52,80,-28,-259,-429,-408,-185,-83,-139,-281,-423,-403,-311,-138,81,88,-34,-135,-114,33,126,11,-114,-135,-116,-55,-33,-68,-147,-235,-261,-209,-100,-52,-120,-155,-146,-98,-34,-1,-6,-40,-91,-64,12,26,-14,-86,-177,-191,-84}
        },
        {    // H60e010a.wav
            {-31,35,-52,52,-59,53,-57,919,3622,3985,1891,-10713,-8089,7796,10129,8094,2747,1332,2651,2631,-1331,-4630,-4781,-4695,-2545,-2691,-2604,-1516,-679,161,928,1887,1639,1681,1367,1215,471,-133,183,239,-24,-1032,-1659,-1834,-1330,-853,-436,39,478,413,144,383,620,574,247,-180,-421,-286,-112,-213,-142,-187,-618,-647,-467,-503,-817,-1065,-954,-560,-131,143,231,15,-229,-195,-59,-20,-8,21,-52,-223,-356,-364,-245,-115,-115,-268,-376,-360,-266,-126,65,90,-36,-104,-104,-14,62,-12,-111,-108,-89,-47,-8,-61,-141,-213,-243,-190,-111,-80,-126,-174,-160,-74,-9,-20,-37,-38,-52,-41,-5,2,-34,-74,-130,-165},
            {9,-34,74,-123,166,100,3892,4889,4915,-8419,-15512,6608,12987,9311,4343,1190,3131,3053,-423,-6229,-6457,-6095,-3540,-2661,-2971,-1117,-544,476,1201,2278,1799,1475,1450,1256,654,-345,326,235,69,-867,-1986,-2353,-1744,-1079,-546,292,724,614,348,603,840,678,385,-207,-693,-582,-305,-47,-108,-271,-363,-475,-564,-497,-706,-1346,-1595,-896,47,210,111,209,159,105,94,28,46,155,40,-336,-546,-424,-148,-73,-122,-249,-434,-441,-337,-106,91,92,-41,-207,-148,82,176,38,-120,-202,-145,-25,19,-40,-180,-279,-280,-220,-93,-34,-109,-132,-145,-130,-24,35,10,-39,-105,-85,5,50,5,-105,-186,-160,-69,-18}
        },
        {    // H60e020a.wav
            {14,-31,34,-49,58,-73,86,-83,1151,3250,3616,690,-10308,-5845,7242,9348,7368,2375,1377,2588,2396,-1234,-3775,-4323,-4055,-2306,-2671,-2536,-1572,-702,-24,886,1781,1566,1626,1340,1103,412,5,213,265,-93,-965,-1555,-1717,-1176,-826,-549,-42,423,201,15,561,737,458,154,-176,-337,-236,-48,-188,-374,-387,-509,-480,-444,-606,-796,-829,-668,-420,-240,-23,162,37,-226,-307,-202,-103,-45,-4,-96,-254,-325,-297,-221,-144,-124,-202,-281,-288,-221,-106,38,63,-55,-111,-90,-37,-9,-53,-105,-84,-40,-1,1,-78,-149,-192,-212,-186,-119,-93,-129,-170,-155,-65,-5,-18,-40,-38,-49,-41,-16,-21,-39,-66,-114},
            {-80,148,-216,272,-254,3354,5437,6051,-4664,-19135,2659,15051,9834,5572,1442,3130,3225,821,-6344,-7483,-6805,-4545,-2770,-3361,-1003,-399,661,1295,2360,2237,1317,1301,1257,879,-524,206,390,194,-641,-1895,-2613,-2154,-1254,-693,222,760,746,422,679,987,814,519,-47,-741,-932,-477,-29,-142,-215,-305,-480,-559,-404,-548,-1410,-1887,-1096,90,179,37,328,307,198,171,101,87,169,45,-363,-564,-463,-212,-102,-70,-190,-449,-508,-316,-29,75,74,-46,-232,-152,79,160,90,-122,-285,-192,-48,48,26,-163,-314,-350,-263,-88,3,-66,-154,-201,-137,17,65,27,-56,-126,-98,-17,39,-13,-121,-158,-122,-64,-31,-20}
        },
        {    // H60e030a.wav
            {0,9,-24,28,-42,52,-70,93,-69,1318,2918,3299,-437,-9820,-4041,6897,8743,6511,2037,1508,2533,2143,-1059,-3181,-3905,-3374,-2141,-2690,-2380,-1512,-732,-139,916,1647,1392,1519,1320,1039,408,132,228,241,-186,-995,-1500,-1529,-1094,-905,-538,-138,137,273,365,593,575,337,74,-115,-210,-252,-258,-342,-306,-295,-486,-488,-434,-569,-663,-627,-533,-459,-322,-47,131,12,-240,-380,-336,-161,-99,-90,-138,-237,-296,-254,-149,-131,-119,-128,-175,-223,-215,-107,-3,-2,-88,-132,-100,-61,-45,-74,-83,-47,0,13,-19,-80,-140,-183,-195,-171,-133,-114,-129,-157,-152,-65,-1,-10,-45,-66,-57,-38,-22,-35,-55,-76},
            {122,-179,229,-274,2050,5900,6550,804,-19915,-5447,16460,11038,6754,2210,3216,3099,2177,-4753,-8881,-7209,-5745,-3269,-3908,-1363,-242,558,1696,2239,2673,1484,1325,1041,1073,-393,-122,417,297,-175,-1681,-2664,-2546,-1583,-916,83,705,735,540,703,1101,988,692,191,-704,-1181,-600,-77,-368,-212,-152,-446,-508,-392,-507,-1252,-1829,-1373,-225,254,140,260,454,337,123,121,193,207,66,-317,-528,-514,-310,-119,-58,-156,-399,-526,-318,-15,94,116,-75,-238,-119,55,150,134,-135,-307,-225,-91,45,64,-122,-291,-362,-319,-138,44,10,-173,-255,-150,23,105,88,-42,-138,-126,-33,29,-24,-106,-113,-106,-77,-15,8,-20}
        },
        {    // H60e040a.wav
            {8,0,3,-14,18,-32,42,-55,83,-19,1454,2670,3006,-1590,-9335,-2456,6829,8214,5543,1809,1696,2455,1880,-945,-2767,-3467,-2775,-2091,-2623,-2136,-1427,-743,-164,923,1428,1240,1476,1326,939,403,229,164,115,-332,-966,-1380,-1428,-1065,-927,-767,-113,532,354,329,523,413,287,149,-80,-466,-531,-165,-68,-347,-468,-403,-337,-398,-532,-530,-572,-552,-407,-278,-91,53,-63,-260,-365,-417,-317,-165,-64,-130,-243,-250,-177,-85,-63,-78,-111,-129,-170,-207,-146,-53,-53,-122,-159,-129,-57,-22,-44,-57,-30,-1,13,-10,-65,-122,-174,-188,-167,-136,-127,-132,-139,-114,-51,-19,-24,-47,-62,-58,-42,-32,-39,-53},
            {35,-82,126,342,5406,6692,5864,-14223,-16737,13269,14309,7418,3866,3164,3416,2684,-1482,-9193,-8241,-6587,-4085,-4561,-2620,-85,-68,1902,2373,3025,1840,1507,1172,1055,-120,-489,380,177,186,-1045,-2466,-3004,-1966,-1176,-285,647,665,528,695,1139,1193,851,460,-497,-1252,-802,-202,-456,-427,-157,-302,-436,-441,-465,-1050,-1611,-1433,-650,55,259,348,456,331,156,152,186,163,175,-145,-519,-580,-403,-169,-67,-132,-349,-500,-320,-60,32,168,-20,-229,-154,1,143,145,-99,-301,-270,-148,17,68,-83,-259,-371,-347,-190,19,41,-172,-255,-186,-39,97,123,7,-107,-147,-104,-19,-13,-55,-82,-126,-119,-22,32,-3,-59}
        },
        {    // H60e050a.wav
            {4,3,6,-4,-2,4,-16,24,-28,53,103,1642,2527,2608,-3238,-8691,-387,7061,7517,4402,1712,1868,2365,1554,-994,-2515,-3064,-2242,-2079,-2456,-1861,-1301,-735,-126,998,1223,1115,1449,1284,758,346,170,29,10,-392,-951,-1299,-1281,-1330,-1003,-202,230,367,303,303,360,465,353,-137,-524,-491,-179,-16,-266,-489,-324,-182,-310,-473,-489,-469,-513,-496,-396,-280,-152,-38,-108,-287,-439,-492,-343,-139,-50,-129,-201,-179,-98,-28,-32,-71,-115,-135,-173,-213,-170,-99,-102,-164,-174,-118,-26,17,-22,-49,-30,-1,13,-12,-56,-114,-177,-191,-172,-139,-134,-125,-114,-94,-62,-46,-37,-44,-58,-70,-54,-37,-44},
            {-189,304,-403,3106,6861,7843,-3151,-22706,753,18338,8849,5273,3553,4043,2553,1934,-6755,-10095,-7018,-5205,-4557,-4605,-724,-458,1038,2517,3255,2697,1532,1615,1257,429,-888,89,173,182,-414,-1863,-3037,-2687,-1456,-657,365,654,480,599,993,1377,1090,683,-247,-1113,-784,-484,-523,-546,-331,-263,-378,-446,-478,-848,-1357,-1320,-822,-293,125,464,512,281,145,139,185,156,175,43,-369,-602,-536,-259,-88,-91,-257,-462,-371,-117,-1,129,44,-144,-184,-83,87,129,-17,-237,-310,-206,-36,34,-13,-200,-364,-372,-242,-37,35,-122,-243,-222,-113,56,127,47,-69,-143,-149,-82,-13,2,-49,-128,-159,-65,34,27,-50,-97}
        },
        {    // H60e060a.wav
            {-5,9,-2,8,-14,12,-15,13,-11,20,-9,388,1870,2533,1695,-5528,-7186,2291,7345,6467,3228,1763,1958,2317,1043,-1283,-2393,-2597,-1814,-2117,-2188,-1632,-1150,-636,51,1042,1006,1043,1411,1113,425,235,99,-3,-60,-457,-911,-1454,-1422,-904,-420,-95,159,266,236,288,436,308,-182,-349,-264,-249,-204,-196,-297,-312,-163,-201,-430,-460,-332,-396,-537,-501,-397,-315,-188,-91,-221,-393,-441,-417,-296,-96,-18,-102,-148,-108,-53,-22,-33,-93,-163,-170,-182,-224,-196,-133,-127,-169,-155,-84,1,27,-13,-29,-16,-4,-1,-31,-66,-116,-173,-191,-166,-137,-127,-119,-110,-82,-58,-48,-46,-55,-62,-66,-55,-50},
            {-71,121,273,5583,7766,6075,-15083,-16935,14168,14457,5920,4311,4471,3204,2833,-809,-10228,-8940,-5882,-4601,-5633,-2782,-591,-558,2082,2863,3530,2182,1902,1575,1298,-359,-712,162,23,30,-1188,-2533,-3240,-2105,-988,-109,602,420,534,813,1229,1364,956,156,-982,-754,-404,-682,-649,-451,-332,-426,-451,-475,-711,-1117,-1195,-845,-437,-44,303,509,388,137,96,120,174,175,150,-160,-511,-587,-432,-165,-48,-123,-373,-419,-194,-51,69,90,-47,-144,-170,-5,83,47,-119,-299,-262,-100,-18,13,-66,-291,-388,-296,-115,-6,-47,-181,-249,-200,-22,118,91,-19,-128,-188,-129,-6,48,-19,-111,-159,-110,8,38,-14,-81,-94}
        },
        {    // H60e070a.wav
            {-3,0,8,0,5,-12,15,-22,31,-34,61,-33,960,2098,2597,-733,-7768,-3609,5251,7137,4820,2326,1919,2090,2174,98,-1689,-2228,-2034,-1703,-2130,-1852,-1409,-899,-509,335,995,849,1011,1258,764,170,206,82,28,-112,-751,-1296,-1084,-802,-656,-343,-112,125,247,283,178,11,-17,-37,-113,-242,-355,-245,-92,-209,-305,-218,-277,-349,-274,-293,-488,-563,-467,-434,-370,-214,-204,-327,-351,-357,-344,-188,-4,8,-82,-110,-67,-41,-51,-93,-163,-194,-188,-221,-243,-172,-100,-121,-163,-123,-36,29,20,-13,-10,0,-10,-36,-52,-72,-122,-172,-172,-145,-136,-134,-112,-85,-60,-47,-65,-75,-56,-52,-58,-62},
            {132,-234,1702,6855,8532,844,-21047,-6405,18153,10333,4967,4302,4486,2695,3150,-4136,-11038,-7517,-5253,-5105,-5411,-1497,-1162,-144,2367,3276,3085,2107,2356,1703,963,-579,-250,-121,18,-315,-1854,-3090,-3053,-1580,-600,189,484,392,634,969,1409,1208,639,-443,-931,-387,-503,-694,-599,-379,-474,-569,-493,-586,-958,-1074,-875,-608,-82,239,269,372,334,110,9,108,203,165,33,-305,-554,-564,-302,-96,-38,-194,-400,-305,-126,13,71,15,-23,-159,-164,-6,68,13,-212,-301,-194,-67,-19,25,-142,-322,-327,-225,-77,-7,-78,-223,-260,-150,38,114,58,-72,-197,-207,-62,72,42,-78,-139,-124,-42,24,14,-44,-83,-89}
        },
        {    // H60e080a.wav
            {-1,-3,8,0,9,-14,12,-16,17,-11,28,-19,350,1699,2438,1462,-5418,-6764,2262,6953,5650,2981,2130,2080,2333,1275,-1152,-1964,-1851,-1680,-1993,-1804,-1572,-1211,-667,-143,589,800,833,961,1019,429,109,178,203,-196,-674,-771,-880,-707,-623,-613,-377,30,211,112,-117,-127,168,157,-20,-172,-287,-276,-145,-140,-365,-331,-140,-164,-247,-276,-402,-526,-515,-538,-549,-411,-223,-206,-289,-325,-314,-185,0,47,-28,-78,-69,-67,-99,-137,-179,-210,-214,-231,-248,-175,-89,-90,-139,-141,-65,11,14,-13,-9,-2,-10,-21,-46,-79,-109,-133,-143,-146,-150,-138,-113,-86,-63,-57,-75,-90,-70,-47,-49,-77},
            {192,-328,2693,7486,8500,-3863,-21321,402,17665,8406,4805,4287,4008,2936,2889,-6134,-10548,-6469,-5089,-5771,-4703,-1134,-1610,252,2223,3299,2742,2124,2579,1997,761,-551,106,-118,-84,-704,-2256,-3453,-2819,-1124,-416,121,416,518,592,1015,1481,1056,233,-605,-560,-458,-580,-493,-499,-466,-589,-626,-574,-682,-1058,-947,-725,-368,216,299,171,298,347,98,-86,85,223,144,-61,-393,-576,-487,-207,-54,-68,-253,-345,-249,-114,39,51,9,-15,-174,-164,-39,64,-11,-254,-294,-176,-70,19,19,-188,-299,-277,-183,-75,2,-93,-252,-260,-119,43,89,38,-116,-229,-187,-25,82,17,-96,-119,-78,-12,17,-10,-62,-84,-88}
        },
        {    // H60e090a.wav
            {-1,-5,5,0,8,-9,2,-6,2,9,3,13,131,1426,2331,2039,-3910,-7497,462,6555,5837,3268,2303,2274,2431,1732,-679,-1925,-1858,-1496,-2020,-1916,-1427,-1427,-900,-217,404,474,748,1037,952,551,293,258,-58,-236,-286,-643,-804,-524,-602,-707,-441,-105,-34,-164,-190,-11,181,182,48,-37,-96,-233,-300,-309,-379,-293,-72,-76,-232,-275,-301,-435,-544,-628,-716,-588,-224,-85,-248,-364,-268,-85,33,41,2,-43,-77,-100,-152,-201,-230,-232,-232,-238,-226,-162,-83,-67,-113,-132,-83,-19,-7,-22,-30,-20,-3,-4,-42,-99,-104,-100,-114,-142,-154,-136,-110,-87,-78,-71,-81,-98,-85,-59,-63,-96},
            {173,-297,2823,7678,8186,-5431,-20040,1902,16653,8147,4882,4041,3754,3311,2625,-6387,-9970,-5879,-5009,-6093,-4549,-1199,-1722,88,2096,3056,2437,2225,2589,2126,968,-304,131,100,75,-1063,-2560,-3488,-2676,-947,-430,-54,384,556,552,926,1368,965,103,-466,-343,-602,-623,-242,-394,-594,-641,-642,-614,-756,-1041,-932,-685,-168,334,277,136,296,344,107,-122,23,187,151,-72,-436,-571,-418,-169,-62,-73,-255,-323,-242,-114,26,43,46,-20,-186,-165,-59,43,-30,-243,-304,-200,-74,41,16,-180,-263,-262,-158,-63,-3,-93,-248,-263,-134,25,74,17,-135,-229,-175,-27,56,0,-69,-80,-57,3,17,-26,-83,-97,-73}
        },
        {    // H60e100a.wav
            {-3,-4,6,-2,8,-7,2,-10,1,8,7,8,129,1432,2407,1982,-4120,-7395,746,6593,5579,3118,2422,2435,2588,1820,-729,-1927,-1919,-1672,-2022,-1998,-1512,-1314,-977,-282,482,407,570,1161,1157,448,407,236,-366,-33,-127,-740,-732,-507,-567,-593,-390,-261,-391,-355,15,129,83,127,147,137,-19,-187,-384,-530,-429,-178,-31,-98,-229,-245,-204,-357,-560,-735,-838,-616,-188,-62,-271,-363,-192,9,63,63,29,-45,-99,-136,-203,-273,-274,-250,-235,-231,-201,-134,-67,-54,-100,-113,-92,-40,-20,-43,-59,-39,-1,-15,-58,-79,-69,-77,-112,-136,-140,-123,-103,-92,-89,-83,-86,-99,-90,-84,-96,-101},
            {136,-246,2157,7311,8239,-3847,-18872,-876,15869,9027,5001,3795,3722,3615,2786,-5273,-9563,-5724,-4740,-6037,-4951,-1592,-1674,-378,1652,2933,2287,1976,2691,2141,1158,133,267,147,332,-871,-2758,-3534,-2465,-976,-730,-166,374,406,480,824,1107,864,274,-171,-235,-695,-642,-97,-253,-636,-685,-607,-606,-750,-1030,-962,-729,-153,323,294,187,263,318,156,-92,-67,127,167,-23,-385,-542,-415,-197,-66,-65,-234,-325,-265,-134,-5,38,63,19,-169,-176,-69,18,-31,-223,-308,-229,-85,31,31,-136,-229,-252,-159,-46,2,-78,-236,-267,-155,-2,66,12,-133,-223,-172,-45,33,8,-33,-48,-43,9,17,-37,-93,-104,-63}
        },
        {    // H60e110a.wav
            {-4,-4,8,-3,8,-12,10,-21,16,-11,33,-34,347,1766,2672,1073,-6003,-6211,3133,6912,4776,2651,2506,2579,2702,1386,-1184,-2072,-1896,-1938,-2424,-1912,-1504,-1375,-713,-21,444,481,795,1225,1088,644,280,-252,25,110,-564,-712,-710,-628,-476,-421,-419,-440,-494,-255,111,161,55,116,295,146,-72,-168,-465,-627,-359,-138,-161,-132,-128,-195,-216,-313,-591,-871,-785,-452,-196,-188,-294,-279,-89,61,96,97,24,-65,-133,-190,-268,-306,-268,-246,-240,-227,-172,-83,-40,-64,-106,-101,-70,-31,-38,-79,-77,-52,-37,-38,-34,-20,-36,-81,-114,-120,-103,-97,-99,-105,-98,-86,-85,-90,-113,-112,-100,-95},
            {52,-108,1009,6106,8481,-70,-16614,-6826,13858,11086,5309,3618,3661,3948,3299,-3050,-9055,-6050,-4317,-5644,-5497,-2374,-1648,-1008,1005,2515,2491,1679,2422,2318,1360,366,490,401,375,-468,-2351,-3532,-2534,-1004,-1010,-506,311,328,277,621,843,744,500,187,-45,-698,-749,-27,-70,-595,-736,-556,-535,-685,-988,-1023,-821,-326,193,302,255,233,269,213,-18,-126,51,165,63,-260,-493,-439,-272,-103,-54,-216,-329,-299,-189,-52,36,56,56,-107,-192,-84,-7,-16,-199,-323,-266,-114,11,36,-84,-197,-236,-178,-52,9,-61,-217,-276,-183,-37,38,10,-107,-208,-198,-90,12,19,-10,-26,-38,-8,4,-33,-94,-107,-68}
        },
        {    // H60e120a.wav
            {-4,3,5,2,4,-8,10,-21,26,-22,54,-39,973,2408,2750,-1950,-8112,-2128,6406,6413,3448,2347,2589,2747,2556,88,-1891,-1999,-1954,-2440,-2603,-1870,-1550,-1147,-382,485,542,574,1215,1316,928,534,-69,-114,290,-254,-733,-907,-761,-512,-490,-430,-455,-446,-278,0,82,76,135,317,269,-55,-129,-233,-527,-522,-248,-224,-308,-151,-24,-112,-273,-422,-701,-783,-530,-297,-288,-340,-251,-129,-16,90,145,80,-26,-101,-180,-275,-295,-243,-235,-262,-251,-189,-109,-50,-43,-93,-113,-73,-22,-28,-79,-98,-90,-85,-68,-20,10,4,-42,-88,-90,-68,-70,-95,-108,-105,-99,-84,-90,-114,-114,-106,-99,-86},
            {-53,81,38,3892,8100,4399,-11252,-13529,7876,13835,6618,3567,3306,4237,3870,-92,-7488,-7083,-3947,-4907,-5765,-3549,-1708,-1641,57,1853,2579,1707,1976,2292,1675,674,452,664,607,-111,-1741,-3042,-2688,-1296,-1114,-864,-44,286,191,287,485,610,688,534,193,-486,-843,-163,141,-417,-790,-577,-400,-555,-871,-1063,-933,-593,-77,204,270,239,231,240,90,-102,-48,129,166,-89,-411,-465,-339,-183,-93,-181,-323,-334,-264,-139,21,81,50,-44,-178,-111,-14,-16,-151,-323,-315,-165,-16,33,-40,-160,-212,-197,-87,-6,-50,-167,-259,-222,-96,-2,6,-64,-166,-220,-149,-22,25,2,-16,-34,-36,-16,-27,-74,-107,-85}
        },
        {    // H60e130a.wav
            {-5,9,-2,8,-13,13,-19,18,-21,37,-35,397,2046,3153,675,-7059,-5947,4454,7580,4519,2433,2480,2668,2934,1207,-1661,-2181,-1899,-2338,-2965,-2302,-1828,-1616,-686,302,730,705,1136,1359,1190,781,12,-174,447,-18,-739,-925,-969,-701,-568,-556,-514,-412,-241,91,135,28,97,366,360,-29,-185,-239,-414,-415,-329,-384,-328,-236,-193,-60,-91,-375,-678,-674,-427,-282,-340,-417,-304,-158,-55,27,118,121,9,-118,-215,-269,-254,-208,-231,-275,-262,-202,-145,-78,-55,-98,-119,-83,-45,-29,-61,-109,-119,-113,-94,-54,-17,-5,-29,-68,-65,-24,-34,-95,-123,-113,-96,-91,-113,-139,-126,-96,-94,-100,-78},
            {-49,73,-125,1259,6112,7401,-2566,-15473,-3674,13607,10245,4184,2796,3982,4416,2615,-3781,-7921,-4653,-3796,-5387,-4856,-2279,-1821,-1189,795,2308,2019,1535,2195,1823,1132,551,611,770,438,-999,-2444,-2502,-1609,-1303,-1153,-499,82,195,78,59,341,692,828,576,-205,-728,-383,181,-141,-687,-664,-358,-381,-638,-953,-1052,-824,-435,-72,162,245,230,236,195,45,-96,28,219,130,-253,-453,-397,-276,-182,-160,-268,-366,-335,-227,-61,107,88,-21,-127,-150,-25,-10,-98,-248,-331,-240,-78,15,4,-95,-176,-197,-146,-49,-28,-104,-203,-243,-172,-46,-3,-41,-110,-184,-181,-84,4,16,-8,-28,-51,-37,-19,-46,-85,-84}
        },
        {    // H60e140a.wav
            {5,0,7,-8,3,-8,1,4,-4,15,122,1713,3338,2059,-5687,-8006,2487,8305,5442,2660,2425,2634,3030,1813,-1420,-2415,-2009,-2304,-3063,-2641,-1942,-1873,-1136,26,820,795,1187,1598,1297,867,268,-270,336,311,-576,-1030,-1126,-749,-740,-744,-600,-457,-279,106,327,149,124,376,450,26,-259,-272,-418,-386,-274,-413,-449,-304,-202,-162,-165,-333,-603,-613,-319,-170,-286,-396,-320,-188,-93,-39,70,111,11,-126,-280,-294,-190,-140,-218,-287,-251,-198,-170,-114,-72,-88,-127,-103,-61,-55,-68,-94,-113,-122,-100,-73,-59,-46,-50,-73,-50,0,-5,-66,-115,-132,-105,-77,-114,-162,-150,-114,-90,-73,-70,-65},
            {40,-74,102,-77,2799,7067,4730,-8627,-13565,4780,13913,7043,2766,3004,4422,4091,745,-5942,-6467,-3398,-4124,-5306,-3730,-1786,-1946,-672,1315,2282,1461,1726,2043,1357,920,590,709,684,-66,-1688,-2190,-1625,-1448,-1375,-979,-258,154,-8,-210,-53,471,766,1008,331,-579,-489,108,53,-489,-621,-439,-315,-439,-625,-967,-1035,-756,-426,-124,122,222,255,231,201,33,-51,135,264,6,-339,-439,-383,-265,-204,-208,-318,-369,-302,-176,10,157,54,-92,-158,-110,-5,-22,-147,-272,-297,-170,-34,10,-18,-115,-178,-181,-105,-31,-46,-136,-210,-209,-117,-36,-42,-71,-109,-157,-126,-43,5,1,-21,-47,-63,-28,-17,-49,-62}
        },
        {    // H60e150a.wav
            {4,3,-5,-4,1,-11,16,-27,44,6,1489,3524,2878,-4788,-9139,1119,8821,6177,2838,2442,2714,3116,2123,-1460,-2754,-2115,-2344,-3247,-2920,-1923,-1968,-1352,-127,739,781,1216,1711,1485,1087,450,-365,124,573,-467,-1113,-1107,-843,-884,-840,-663,-614,-383,54,394,331,277,464,523,160,-272,-430,-426,-294,-323,-461,-438,-374,-297,-191,-189,-472,-699,-512,-145,-90,-202,-263,-239,-168,-125,-69,19,66,-28,-215,-326,-247,-162,-164,-194,-206,-227,-234,-188,-114,-64,-83,-116,-111,-101,-74,-66,-92,-119,-98,-82,-92,-78,-61,-76,-96,-53,-3,-3,-45,-91,-121,-102,-77,-112,-137,-135,-136,-107,-60,-27,-36,-63},
            {3,3,-16,16,270,3928,6932,1571,-11942,-9253,9444,12200,4892,2262,3458,4374,3624,-941,-6447,-4917,-3006,-4293,-4921,-2856,-1774,-1912,-290,1606,1964,1197,1888,1663,1193,850,657,672,407,-595,-1681,-1504,-1506,-1458,-1247,-823,-59,14,-278,-388,57,516,949,981,-5,-543,-119,238,-250,-562,-463,-331,-395,-445,-584,-920,-1041,-810,-432,-161,63,218,283,240,198,75,34,166,201,-77,-380,-476,-395,-277,-206,-218,-310,-364,-275,-124,36,150,24,-147,-179,-91,2,-19,-163,-272,-259,-126,-30,-8,-43,-117,-168,-155,-84,-34,-51,-149,-209,-178,-104,-61,-51,-68,-110,-125,-78,-25,-3,-13,-38,-71,-61,-21,-16,-27}
        },
        {    // H60e160a.wav
            {0,-4,-10,7,-22,24,-44,55,-46,1357,3770,3504,-4338,-10009,313,9402,6736,2935,2464,2837,3253,2298,-1656,-3227,-2268,-2449,-3434,-3159,-2011,-1991,-1406,-144,804,748,1088,1740,1563,1161,789,-141,-299,559,-155,-1258,-1246,-808,-907,-981,-671,-619,-606,-185,399,488,375,554,628,321,-186,-510,-494,-271,-316,-477,-511,-457,-299,-243,-334,-631,-763,-495,-130,6,-40,-137,-138,-73,-80,-118,-37,42,-116,-340,-354,-230,-184,-184,-175,-193,-229,-231,-217,-125,-40,-63,-133,-145,-126,-99,-70,-104,-132,-120,-99,-87,-80,-83,-98,-106,-87,-55,-31,-51,-104,-134,-104,-88,-117,-128,-131,-135,-119,-75,-31,-33,-57,-95},
            {-26,33,-40,37,-63,684,4433,6267,-995,-12866,-5328,11122,10354,3712,2279,3618,4149,3185,-1970,-5995,-3852,-2867,-4258,-4461,-2371,-1898,-1808,-59,1673,1556,1157,1798,1440,1222,799,716,491,61,-743,-1143,-1381,-1618,-1185,-1195,-661,-44,-180,-497,-431,163,670,1012,703,18,-276,11,68,-371,-466,-390,-378,-466,-430,-516,-818,-1088,-873,-422,-175,21,190,301,268,204,105,96,135,93,-153,-413,-490,-415,-257,-182,-201,-270,-345,-268,-126,15,122,32,-168,-207,-88,4,-16,-162,-255,-223,-112,-41,-33,-54,-95,-147,-139,-77,-33,-60,-152,-206,-161,-96,-71,-58,-81,-107,-91,-47,-12,-10,-29,-61,-89,-62,-22,-11}
        },
        {    // H60e170a.wav
            {3,-15,13,-25,34,-49,65,-74,1276,4063,4112,-4026,-10893,-326,10133,7301,2960,2505,3054,3447,2405,-1961,-3793,-2464,-2561,-3699,-3399,-1993,-2057,-1492,28,981,841,1043,1653,1601,1157,914,273,-376,245,21,-1223,-1455,-859,-935,-981,-595,-532,-692,-437,174,601,588,581,628,456,-34,-471,-423,-295,-370,-444,-499,-526,-345,-244,-456,-827,-828,-457,-112,19,78,62,30,38,-16,-71,-4,-10,-238,-375,-327,-258,-238,-163,-125,-191,-252,-246,-199,-66,16,-36,-127,-166,-139,-67,-50,-102,-132,-138,-117,-73,-45,-58,-85,-105,-85,-63,-48,-64,-101,-124,-111,-86,-85,-96,-104,-101,-89,-50,-14,-17,-49,-84,-105},
            {13,-33,43,-54,63,-94,974,4483,5522,-2563,-12556,-2844,11268,9016,3191,2406,3511,3920,2841,-2320,-5264,-3198,-2744,-4115,-4075,-2159,-1968,-1716,62,1548,1206,1133,1659,1447,1211,807,714,187,-159,-437,-852,-1639,-1389,-1004,-1155,-535,-152,-395,-659,-334,333,802,817,608,256,-96,-119,-133,-295,-419,-448,-457,-490,-394,-426,-737,-1059,-881,-453,-158,-7,170,288,242,200,122,72,45,5,-203,-418,-478,-392,-254,-132,-141,-257,-348,-285,-127,3,84,20,-156,-218,-91,-3,-55,-149,-202,-182,-119,-72,-41,-58,-70,-115,-133,-82,-43,-60,-144,-193,-153,-86,-74,-80,-87,-92,-75,-36,-5,-8,-48,-85,-97,-64,-35}
        },
        {    // H60e180a.wav
            {-18,18,-33,37,-55,67,-94,1160,4313,4776,-3505,-11756,-1275,10777,8013,3012,2490,3289,3685,2565,-2246,-4480,-2756,-2647,-3938,-3728,-2034,-2022,-1624,101,1263,973,1095,1584,1530,1186,868,580,-162,-88,-40,-1017,-1695,-1035,-963,-1057,-525,-332,-611,-649,-105,527,731,684,623,378,7,-298,-292,-279,-415,-483,-477,-507,-380,-336,-623,-936,-868,-506,-119,36,126,157,208,177,18,-28,40,-6,-279,-422,-407,-313,-232,-127,-148,-253,-279,-255,-176,-35,48,3,-128,-203,-128,-45,-64,-113,-144,-168,-142,-77,-35,-48,-74,-112,-117,-72,-41,-75,-136,-159,-125,-84,-86,-92,-88,-90,-76,-35,-9,-17,-52,-85,-104,-83},
            {-18,18,-33,37,-55,67,-94,1160,4313,4776,-3505,-11756,-1275,10777,8013,3012,2490,3289,3685,2565,-2246,-4480,-2756,-2647,-3938,-3728,-2034,-2022,-1624,101,1263,973,1095,1584,1530,1186,868,580,-162,-88,-40,-1017,-1695,-1035,-963,-1057,-525,-332,-611,-649,-105,527,731,684,623,378,7,-298,-292,-279,-415,-483,-477,-507,-380,-336,-623,-936,-868,-506,-119,36,126,157,208,177,18,-28,40,-6,-279,-422,-407,-313,-232,-127,-148,-253,-279,-255,-176,-35,48,3,-128,-203,-128,-45,-64,-113,-144,-168,-142,-77,-35,-48,-74,-112,-117,-72,-41,-75,-136,-159,-125,-84,-86,-92,-88,-90,-76,-35,-9,-17,-52,-85,-104,-83}
        }
    },
    {    // elev70
        {    // H70e000a.wav
            {-4,-5,-6,18,-6,15,-19,11,-7,-7,26,-59,81,255,3267,4223,4430,-7297,-12655,5572,11429,7082,3472,3241,3322,2148,-766,-5816,-6343,-5330,-3183,-3044,-2544,-536,56,845,1520,2423,1683,1231,1250,1128,225,-708,-233,-102,-221,-887,-1542,-2059,-1668,-989,-366,292,793,923,664,706,874,529,27,-353,-597,-641,-532,-582,-694,-409,-213,-23,-42,-212,-291,-461,-824,-1080,-816,-231,126,44,-108,-40,111,53,-98,-103,-74,-219,-356,-344,-204,-66,3,-103,-274,-332,-273,-180,-69,-24,-148,-250,-176,5,92,30,-106,-134,-84,-1,82,52,-71,-182,-231,-194,-105,-75,-154,-222,-227,-134,3,36,-17,-40,-31,-48},
            {-4,-5,-6,18,-6,15,-19,11,-7,-7,26,-59,81,255,3267,4223,4430,-7297,-12655,5572,11429,7082,3472,3241,3322,2148,-766,-5816,-6343,-5330,-3183,-3044,-2544,-536,56,845,1520,2423,1683,1231,1250,1128,225,-708,-233,-102,-221,-887,-1542,-2059,-1668,-989,-366,292,793,923,664,706,874,529,27,-353,-597,-641,-532,-582,-694,-409,-213,-23,-42,-212,-291,-461,-824,-1080,-816,-231,126,44,-108,-40,111,53,-98,-103,-74,-219,-356,-344,-204,-66,3,-103,-274,-332,-273,-180,-69,-24,-148,-250,-176,5,92,30,-106,-134,-84,-1,82,52,-71,-182,-231,-194,-105,-75,-154,-222,-227,-134,3,36,-17,-40,-31,-48}
        },
        {    // H70e015a.wav
            {0,-4,-3,-6,13,-4,16,-20,13,-14,2,10,-33,45,322,2876,3709,3586,-6857,-10993,4660,10473,7133,3308,2806,3078,2183,-337,-4685,-5487,-4687,-2906,-2751,-2462,-961,-354,387,1206,2079,1596,1410,1378,1170,392,-533,-272,-105,-208,-846,-1425,-1814,-1526,-977,-395,158,539,737,584,619,805,551,135,-265,-565,-668,-511,-386,-667,-540,-208,-104,-133,-175,-212,-384,-673,-844,-679,-270,37,-20,-210,-224,-122,-59,-101,-97,-97,-196,-285,-272,-150,-120,-78,-85,-192,-265,-280,-198,-72,-28,-128,-242,-195,-43,65,21,-101,-113,-55,26,88,80,-30,-156,-209,-196,-131,-123,-175,-214,-218,-140,-20,46,17,-46,-55},
            {-3,-8,18,-3,17,-11,-4,11,-33,70,-107,148,74,3524,4808,5538,-6794,-15165,5483,12737,7070,3771,3858,3582,1958,-590,-6806,-7273,-5834,-3725,-3419,-2792,-159,372,1370,1911,2692,1940,1097,1033,1081,64,-963,-198,-40,-104,-879,-1660,-2303,-1894,-1086,-334,451,843,1115,806,749,1083,626,-95,-475,-562,-649,-719,-696,-648,-463,-192,105,-34,-166,-236,-503,-1033,-1328,-870,-121,102,-72,85,282,293,108,-85,-73,-54,-259,-474,-451,-199,17,21,-101,-255,-341,-299,-170,3,8,-185,-280,-169,16,114,39,-138,-173,-102,13,111,63,-98,-232,-268,-197,-76,-29,-124,-223,-227,-134,1,36,32,-1,-53,-74,-46}
        },
        {    // H70e030a.wav
            {0,1,-2,-3,-5,13,-1,13,-16,12,-12,5,6,-23,36,304,2458,3255,3041,-6010,-9966,3467,9673,7055,3267,2578,2812,2212,249,-3666,-4706,-4132,-2690,-2526,-2391,-1285,-624,134,864,1795,1541,1420,1429,1201,505,-349,-250,-147,-234,-831,-1288,-1606,-1432,-962,-447,6,236,671,755,555,640,598,240,-298,-585,-602,-513,-461,-627,-484,-220,-203,-208,-32,-67,-350,-570,-572,-503,-400,-198,-101,-194,-284,-288,-263,-163,-49,-79,-216,-256,-222,-134,-81,-56,-85,-148,-184,-211,-192,-119,-76,-137,-225,-217,-101,2,-6,-67,-67,-6,55,94,69,-14,-114,-205,-208,-153,-140,-186,-203,-193,-142,-36,36,35,-12},
            {-8,14,8,2,7,-27,43,-78,125,-171,236,-180,3350,5370,6604,-4544,-17788,3313,14234,7078,4099,4547,4101,1645,13,-6939,-8444,-6175,-4150,-4107,-3290,-31,439,1786,2343,2970,2203,1208,1010,881,33,-1214,-309,-57,-3,-639,-1631,-2556,-2167,-1228,-461,534,914,1102,883,863,1243,756,-6,-481,-593,-626,-957,-802,-698,-628,-95,176,-91,-161,-82,-460,-1140,-1446,-936,-189,32,87,245,352,372,177,-10,-40,-42,-327,-582,-480,-179,0,4,-72,-241,-348,-302,-119,53,25,-186,-287,-164,1,97,33,-152,-228,-149,-6,108,101,-80,-261,-323,-238,-55,18,-91,-218,-242,-174,-24,114,88,-23,-100,-123,-59,14}
        },
        {    // H70e045a.wav
            {-3,0,0,-3,-2,-6,9,-3,12,-17,12,-19,13,-11,0,9,372,2234,2969,2412,-6155,-8761,3475,9017,6541,3038,2534,2589,2199,450,-3033,-4057,-3534,-2424,-2444,-2199,-1365,-737,-27,678,1554,1371,1371,1418,1198,508,-200,-298,-250,-299,-818,-1194,-1484,-1286,-909,-614,-94,521,706,520,499,605,515,124,-322,-570,-658,-552,-392,-504,-511,-289,-131,-123,-43,-3,-212,-465,-479,-472,-511,-357,-169,-224,-366,-360,-315,-243,-83,-40,-188,-245,-172,-91,-44,-9,-63,-139,-152,-160,-214,-199,-126,-151,-227,-235,-142,-35,1,-14,-13,14,58,83,46,-29,-104,-188,-209,-170,-154,-187,-198,-166,-106,-28,8,-4},
            {-1,26,-19,37,-63,81,-114,148,-177,224,-276,2127,5707,7141,913,-18479,-4336,15449,8498,4186,4965,5148,1631,1099,-5409,-9681,-6765,-4757,-4312,-4511,-632,394,1422,2751,3236,2843,1348,1323,1036,168,-1461,-661,-136,-106,-360,-1334,-2465,-2610,-1520,-620,375,931,1110,873,856,1321,1032,186,-390,-539,-670,-1031,-842,-854,-882,-219,198,9,-168,-57,-346,-1029,-1346,-954,-503,-120,354,443,296,276,207,79,8,-22,-328,-608,-502,-220,-62,-13,-25,-230,-348,-271,-83,49,55,-111,-275,-218,-43,73,48,-140,-271,-206,-58,84,131,-39,-269,-343,-256,-89,30,-30,-184,-273,-243,-22,144,114,-26,-150,-158,-64,42,11}
        },
        {    // H70e060a.wav
            {-6,0,-1,1,-3,-3,-3,9,-4,11,-19,18,-28,32,-39,44,-39,653,2237,2901,1138,-7586,-6568,5102,8423,5426,2648,2618,2405,2150,112,-2905,-3595,-2900,-2165,-2443,-1862,-1237,-731,-66,755,1359,1104,1335,1419,1082,322,-238,-404,-231,-313,-898,-1175,-1307,-1371,-882,46,164,221,600,499,371,520,349,-161,-494,-504,-372,-415,-596,-569,-293,-138,-203,-135,88,55,-213,-389,-444,-561,-622,-425,-240,-329,-390,-339,-324,-242,-36,-17,-165,-186,-106,-37,-17,0,-84,-181,-173,-171,-245,-237,-156,-155,-230,-225,-112,-16,16,10,9,22,54,55,10,-40,-107,-179,-200,-173,-168,-175,-150,-127,-88,-37,-5},
            {23,-10,27,-31,19,-15,-5,41,-77,124,221,4775,6900,6650,-11219,-16257,10543,13153,4578,4514,6136,3024,1312,-1258,-9516,-8644,-5235,-4397,-5419,-2451,152,353,2501,3064,3642,2113,1515,1423,956,-936,-1537,-341,-275,-214,-935,-2108,-2869,-2022,-985,32,866,1056,901,847,1174,1261,592,-170,-469,-715,-894,-755,-984,-1161,-455,6,-40,-55,6,-233,-802,-1171,-942,-609,-319,207,626,431,122,123,143,63,-30,-187,-517,-559,-343,-129,-16,-16,-155,-314,-296,-97,58,86,-31,-198,-263,-147,21,64,-80,-270,-258,-131,28,131,44,-208,-350,-282,-129,18,32,-143,-293,-259,-56,108,122,-3,-148,-179,-100,32,30,-105}
        },
        {    // H70e075a.wav
            {-4,-4,0,0,-1,-4,-4,3,2,3,-1,-9,7,-19,31,-41,63,12,1343,2443,2763,-2410,-9044,-1352,7578,7028,3665,2516,2632,2341,1835,-1102,-3143,-3137,-2234,-2188,-2349,-1408,-984,-565,102,1089,1068,888,1441,1351,582,-32,-191,-336,-270,-426,-960,-1614,-1303,-442,-224,-121,113,339,405,329,381,250,-209,-326,-126,-187,-477,-585,-462,-396,-328,-161,-93,-9,108,20,-227,-350,-505,-721,-716,-434,-286,-402,-375,-278,-231,-107,45,-26,-140,-101,-25,-22,-47,-88,-180,-217,-181,-223,-285,-200,-114,-154,-216,-163,-50,8,7,11,18,25,33,21,-15,-62,-129,-179,-175,-147,-137,-139,-131,-111,-56,-14},
            {30,-22,37,-59,72,-92,110,-123,143,-179,1413,5988,7884,2628,-17445,-7979,15185,9472,3796,5286,5592,1878,1609,-4058,-10367,-7130,-4685,-4955,-5157,-1178,-91,666,2587,3437,3266,1837,2025,1591,544,-1282,-1028,-524,-400,-342,-1530,-2781,-2760,-1580,-517,463,1013,921,799,1013,1257,1056,201,-262,-560,-873,-693,-659,-1263,-1034,-159,-106,-258,-13,26,-485,-955,-983,-705,-363,32,390,522,284,73,42,92,10,-66,-315,-555,-477,-272,-78,-1,-34,-225,-336,-206,-5,108,91,-82,-252,-248,-78,27,2,-186,-309,-222,-65,72,99,-54,-270,-335,-213,-31,80,-38,-266,-305,-157,41,121,51,-98,-177,-164,-48,35,-50,-144}
        },
        {    // H70e090a.wav
            {-1,-2,-1,0,1,-3,-3,1,8,-1,9,-13,16,-28,38,-37,66,-57,848,2226,2847,-383,-8272,-4251,6178,7484,4117,2562,2849,2409,2367,-11,-2767,-3044,-2383,-2186,-2457,-1684,-1066,-606,-197,712,1208,824,1037,1363,922,17,-96,-182,-240,-387,-1201,-1425,-819,-499,-341,-159,63,293,200,167,186,85,-86,-92,-39,-188,-347,-291,-402,-668,-531,-124,0,-26,67,75,-82,-216,-376,-724,-921,-663,-342,-326,-371,-311,-198,-14,129,25,-88,-56,-13,-39,-111,-157,-210,-223,-216,-247,-257,-177,-100,-116,-164,-145,-73,-5,-7,-13,5,13,16,11,-12,-59,-95,-132,-140,-117,-101,-121,-131,-94,-51,-38},
            {27,-18,33,-54,66,-93,119,-138,171,-228,1774,6280,8024,394,-17802,-4764,15115,8460,3850,5257,5054,1956,1643,-4798,-9984,-6331,-4525,-5421,-4857,-948,-464,633,2349,3313,3056,1767,2239,1913,561,-1219,-733,-416,-468,-561,-1853,-3087,-2748,-1342,-299,563,952,801,833,988,1212,924,23,-268,-521,-771,-611,-708,-1195,-864,-195,-237,-334,-14,-45,-591,-908,-861,-603,-138,248,360,351,236,122,9,-2,0,-58,-355,-554,-477,-241,-34,15,-54,-235,-322,-193,9,125,99,-81,-256,-238,-60,19,-43,-226,-315,-219,-42,77,70,-76,-263,-294,-170,8,94,-77,-291,-279,-132,46,113,15,-121,-178,-147,-50,-10,-70,-138}
        },
        {    // H70e105a.wav
            {-1,-2,1,1,1,-2,-3,1,7,-1,7,-12,16,-28,37,-37,71,-59,951,2358,2886,-1121,-8643,-3169,6913,7112,3574,2533,3003,2583,2342,-174,-2788,-2987,-2321,-2454,-2705,-1655,-1106,-676,14,892,1088,864,1145,1166,768,266,-84,-224,-133,-872,-1286,-893,-771,-639,-399,-48,195,214,120,-37,-88,116,246,-6,-281,-245,-25,-118,-594,-780,-524,-206,-44,34,53,61,-7,-149,-350,-711,-957,-768,-386,-309,-400,-360,-103,134,133,42,-14,-20,-49,-97,-178,-239,-233,-240,-286,-285,-175,-101,-106,-135,-144,-107,-63,-20,-40,-49,-29,-7,-7,-24,-43,-70,-85,-95,-103,-99,-86,-95,-104,-96,-69,-74},
            {26,-15,30,-45,49,-64,74,-75,85,-112,1025,5611,7801,2131,-15361,-8113,13321,9909,3961,4684,5078,2614,1852,-3245,-9301,-6488,-4238,-5272,-5337,-1595,-474,-95,1842,3072,2921,1768,2246,2057,1051,-700,-747,-329,-178,-491,-2031,-3064,-2815,-1460,-411,416,810,711,835,865,1040,832,108,-153,-335,-576,-664,-660,-971,-849,-364,-285,-352,-104,-37,-523,-890,-854,-565,-129,238,338,279,211,201,37,-62,-27,-16,-279,-541,-524,-298,-32,37,-67,-217,-286,-232,-62,106,126,-38,-211,-238,-97,1,-41,-208,-322,-251,-81,58,78,-44,-223,-278,-166,-6,79,-35,-249,-287,-162,7,90,27,-105,-169,-154,-85,-40,-64,-116}
        },
        {    // H70e120a.wav
            {-4,-3,1,0,-1,-3,-6,6,-1,5,-10,3,-7,-5,7,-7,26,124,1681,2889,2250,-5009,-8425,2152,8445,5417,2529,2851,2983,2725,1655,-1708,-3132,-2646,-2417,-2974,-2616,-1562,-1090,-491,498,1458,1059,888,1359,1194,398,1,125,-197,-823,-928,-862,-1110,-824,-559,-352,43,306,219,-76,-95,145,284,152,-81,-281,-174,-37,-335,-722,-660,-378,-275,-160,29,114,92,-13,-199,-511,-749,-752,-543,-441,-483,-434,-175,63,89,130,90,4,-54,-106,-199,-249,-214,-244,-313,-308,-213,-104,-68,-106,-164,-153,-87,-23,-24,-84,-81,-39,-33,-42,-52,-65,-74,-90,-85,-66,-59,-61,-61,-80,-106,-94,-90},
            {17,2,9,-10,-1,9,-26,53,-80,122,-1,3642,7056,5482,-8888,-14127,6929,12952,5073,3745,4998,3799,2274,-410,-7366,-7433,-4167,-4473,-5687,-3268,-636,-697,741,2383,3126,1806,1893,2281,1489,62,-578,-248,-153,-28,-1515,-2969,-2978,-1656,-758,-88,664,615,705,755,791,734,274,42,-38,-285,-646,-598,-676,-832,-637,-354,-297,-221,-20,-320,-757,-920,-682,-279,53,261,282,215,220,155,12,-46,-12,-139,-422,-542,-424,-153,3,-33,-171,-254,-252,-148,25,123,48,-123,-233,-159,-39,-26,-143,-282,-278,-150,1,69,15,-138,-244,-202,-73,37,39,-128,-267,-235,-63,51,52,-48,-162,-168,-121,-43,-42,-94}
        },
        {    // H70e135a.wav
            {-5,0,0,-1,-5,-4,0,5,-2,1,-12,11,-29,32,-47,69,-56,1155,2864,3201,-2376,-9470,-1455,8469,6818,2882,2596,3211,2807,2335,-871,-3377,-2935,-2405,-3024,-3203,-1902,-1402,-999,172,1503,1454,1106,1458,1289,721,131,1,-217,-633,-808,-905,-1151,-1002,-807,-507,-100,159,228,48,-34,220,548,286,-147,-217,-51,-147,-469,-694,-628,-376,-331,-335,-142,100,111,-34,-130,-383,-672,-597,-335,-402,-594,-477,-209,-48,57,151,76,-7,-46,-121,-228,-229,-171,-229,-311,-298,-199,-112,-80,-88,-146,-179,-137,-50,-14,-73,-81,-68,-70,-64,-48,-55,-84,-102,-103,-65,-22,-12,-41,-82,-92,-87,-93,-106},
            {-4,23,-11,21,-33,38,-50,56,-59,70,-95,886,4950,6871,803,-13623,-6417,12090,9552,3427,3842,4842,3192,1944,-2899,-7753,-5279,-3569,-4860,-5083,-1959,-830,-594,1122,2621,2531,1466,2042,1949,959,-194,-197,-62,99,-590,-2198,-3007,-2162,-1005,-691,149,526,558,621,539,540,414,224,135,145,-333,-653,-411,-548,-865,-692,-272,-215,-152,-123,-432,-817,-872,-551,-207,23,161,232,215,231,176,49,-28,-51,-216,-465,-515,-354,-161,-58,-91,-189,-235,-198,-100,27,96,-5,-172,-233,-134,-43,-60,-171,-263,-224,-97,14,37,-44,-160,-226,-166,-31,41,-9,-149,-240,-187,-36,28,-8,-93,-171,-152,-76,-26,-51}
        },
        {    // H70e150a.wav
            {-1,0,0,-4,-5,0,8,-4,6,-18,17,-34,36,-53,71,-82,993,3061,3716,-1627,-9947,-2614,8864,7447,2954,2638,3376,2898,2433,-852,-3785,-3212,-2504,-3251,-3493,-1994,-1458,-1204,0,1497,1585,1264,1700,1562,844,65,57,-157,-726,-942,-828,-1133,-1234,-866,-533,-263,15,249,11,-82,380,745,492,31,-178,-140,-141,-439,-859,-731,-395,-351,-295,-151,-28,12,-56,-254,-498,-521,-336,-219,-362,-441,-292,-194,-121,-29,82,44,-66,-141,-209,-209,-147,-142,-233,-294,-252,-160,-106,-72,-90,-165,-206,-142,-54,-54,-90,-83,-60,-76,-85,-56,-52,-81,-122,-122,-70,-11,3,-43,-91,-106,-74,-67,-99,-111},
            {-5,4,16,-7,15,-30,36,-53,69,-88,117,-157,1462,5120,5985,-2309,-13705,-1699,12601,7664,2785,3839,4579,3026,1581,-3775,-6891,-4170,-3377,-4825,-4455,-1555,-1091,-600,1171,2541,2066,1400,1991,1657,760,-46,-50,87,19,-1094,-2361,-2472,-1458,-1037,-575,179,368,512,403,255,302,419,315,294,139,-285,-442,-293,-580,-976,-680,-230,-166,-182,-157,-408,-786,-785,-506,-267,-88,64,148,238,310,158,33,47,-18,-318,-498,-459,-358,-229,-104,-65,-142,-206,-185,-102,22,71,-56,-224,-244,-107,-32,-53,-155,-225,-196,-87,14,4,-76,-167,-192,-114,-9,25,-44,-126,-166,-152,-82,-53,-52,-75,-114,-130,-70,-10}
        },
        {    // H70e165a.wav
            {1,0,-5,-3,1,9,-5,8,-19,20,-37,44,-61,79,-99,1094,3505,4182,-2014,-10771,-2075,9873,7445,2750,2898,3648,2931,2275,-1529,-4424,-3369,-2673,-3610,-3780,-1882,-1355,-1208,192,1721,1549,1268,1824,1621,1023,152,-50,-160,-539,-1134,-1252,-1141,-1226,-928,-486,-282,4,206,-26,-99,344,780,678,204,-96,-35,-135,-599,-868,-677,-569,-471,-216,-78,-74,-81,-229,-463,-574,-436,-189,-154,-223,-207,-111,-28,-45,-70,-26,-75,-217,-300,-253,-158,-112,-133,-199,-244,-206,-155,-108,-45,-65,-183,-240,-146,-52,-51,-100,-113,-102,-85,-50,-35,-67,-107,-128,-111,-46,5,-17,-83,-119,-107,-67,-71,-90,-97,-106},
            {-8,-4,4,10,-7,8,-24,26,-49,59,-84,109,-143,1532,4723,5187,-3242,-12714,-334,11972,7030,2526,3635,4291,2991,1607,-3449,-5998,-3672,-3148,-4527,-4114,-1573,-1256,-750,953,2297,1786,1338,1911,1516,833,120,8,79,-228,-1316,-2143,-1774,-1260,-1151,-402,73,232,339,163,35,249,509,499,351,51,-56,-260,-421,-676,-907,-710,-308,-152,-170,-179,-297,-608,-764,-537,-309,-201,-30,64,194,259,124,42,70,-6,-342,-522,-468,-322,-221,-125,-65,-101,-184,-213,-131,-16,10,-92,-237,-239,-100,-30,-51,-141,-194,-183,-87,-18,-29,-82,-148,-162,-100,-15,4,-46,-107,-149,-143,-121,-105,-77,-71,-94,-96,-61}
        },
        {    // H70e180a.wav
            {0,-5,-3,2,10,-4,8,-20,23,-40,51,-70,94,-118,1336,4118,4637,-2844,-11735,-882,11041,7131,2534,3276,3978,2972,1925,-2543,-5188,-3456,-2894,-4082,-3945,-1731,-1292,-983,540,2034,1640,1257,1875,1541,975,221,4,-86,-432,-1260,-1687,-1338,-1303,-1032,-301,-158,39,262,27,-90,282,662,669,318,3,8,-132,-554,-829,-771,-656,-404,-207,-114,-121,-146,-405,-693,-586,-326,-189,-123,-57,22,131,86,1,16,-19,-243,-426,-421,-275,-159,-107,-90,-142,-188,-204,-165,-58,-19,-83,-205,-228,-121,-45,-42,-116,-155,-142,-83,-42,-33,-58,-113,-149,-110,-14,21,-30,-104,-150,-131,-76,-76,-98,-97,-83,-78},
            {0,-5,-3,2,10,-4,8,-20,23,-40,51,-70,94,-118,1336,4118,4637,-2844,-11735,-882,11041,7131,2534,3276,3978,2972,1925,-2543,-5188,-3456,-2894,-4082,-3945,-1731,-1292,-983,540,2034,1640,1257,1875,1541,975,221,4,-86,-432,-1260,-1687,-1338,-1303,-1032,-301,-158,39,262,27,-90,282,662,669,318,3,8,-132,-554,-829,-771,-656,-404,-207,-114,-121,-146,-405,-693,-586,-326,-189,-123,-57,22,131,86,1,16,-19,-243,-426,-421,-275,-159,-107,-90,-142,-188,-204,-165,-58,-19,-83,-205,-228,-121,-45,-42,-116,-155,-142,-83,-42,-33,-58,-113,-149,-110,-14,21,-30,-104,-150,-131,-76,-76,-98,-97,-83,-78}
        }
    },
    {    // elev80
        {    // H80e000a.wav
            {16,-6,17,-23,19,-17,10,13,-24,46,313,3188,4578,4872,-6962,-11476,5790,10102,4320,3018,4901,3465,1859,-471,-5646,-6097,-4304,-3345,-4194,-2512,-329,51,1258,1929,2321,1451,1180,1065,875,-148,-652,-82,1,-161,-849,-1465,-2030,-1645,-1025,-552,-37,466,948,915,953,1080,560,-195,-704,-688,-349,-137,-513,-979,-725,-297,-239,-194,28,73,16,-128,-445,-789,-801,-398,-132,-398,-584,-276,85,117,68,44,-82,-130,-80,-85,-144,-80,-97,-224,-365,-374,-239,-103,-114,-275,-372,-239,-1,92,19,-98,-115,-39,68,146,101,-79,-195,-200,-150,-71,-71,-177,-254,-246,-145,-3,40,-12,-139,-229,-164,16,145,119},
            {16,-6,17,-23,19,-17,10,13,-24,46,313,3188,4578,4872,-6962,-11476,5790,10102,4320,3018,4901,3465,1859,-471,-5646,-6097,-4304,-3345,-4194,-2512,-329,51,1258,1929,2321,1451,1180,1065,875,-148,-652,-82,1,-161,-849,-1465,-2030,-1645,-1025,-552,-37,466,948,915,953,1080,560,-195,-704,-688,-349,-137,-513,-979,-725,-297,-239,-194,28,73,16,-128,-445,-789,-801,-398,-132,-398,-584,-276,85,117,68,44,-82,-130,-80,-85,-144,-80,-97,-224,-365,-374,-239,-103,-114,-275,-372,-239,-1,92,19,-98,-115,-39,68,146,101,-79,-195,-200,-150,-71,-71,-177,-254,-246,-145,-3,40,-12,-139,-229,-164,16,145,119}
        },
        {    // H80e030a.wav
            {-6,18,-6,17,-20,23,-23,24,-5,4,12,422,2930,3995,3506,-7893,-10255,6376,10371,4730,2535,4131,3280,2214,-10,-4854,-5480,-3917,-3007,-3802,-2512,-594,-176,674,1622,2170,1359,1286,1153,950,87,-509,-152,-15,-207,-907,-1528,-1900,-1488,-928,-356,93,453,725,714,831,1037,554,-169,-602,-698,-466,-336,-543,-789,-622,-220,-147,-125,103,116,-18,-98,-238,-613,-862,-619,-219,-351,-643,-521,-132,149,159,19,-121,-100,2,39,-64,-134,-167,-237,-285,-335,-295,-136,-99,-208,-326,-259,-72,54,24,-81,-83,7,96,136,106,-25,-140,-192,-173,-115,-121,-185,-215,-192,-106,-7,16,-5,-22,-55,-77,-27,18},
            {8,5,-5,-6,19,-41,75,-102,150,-24,3017,5167,6682,-3595,-14263,2225,10804,4771,3382,5458,3967,1516,-35,-5799,-6829,-4688,-3828,-4350,-2999,-377,181,1486,2012,2582,1829,988,1202,1018,-317,-927,-91,-87,-106,-475,-1365,-2149,-1880,-1349,-747,2,657,1099,912,807,1034,634,-155,-520,-539,-239,30,-540,-1167,-778,-471,-467,-153,42,-15,9,-124,-479,-808,-772,-334,-60,-339,-518,-130,164,172,146,68,-156,-235,-108,-71,-44,-59,-236,-354,-353,-261,-116,-79,-100,-217,-361,-246,-48,32,-17,-107,-118,-43,70,174,124,-68,-199,-208,-147,-68,-86,-194,-261,-245,-192,-155,-72,-31,14,79,127,73,-46,-70,-63}
        },
        {    // H80e060a.wav
            {-8,-3,13,-10,16,-27,32,-46,56,-63,78,-85,947,3007,3844,925,-10654,-6352,8933,9323,3915,2527,3828,2738,2330,-660,-4680,-4639,-3234,-2890,-3587,-2007,-744,-251,491,1615,1900,1153,1413,1239,803,-43,-328,-230,-71,-370,-1109,-1594,-1791,-1343,-746,-9,324,527,657,499,673,799,331,-286,-630,-560,-341,-390,-759,-807,-475,-128,-57,-15,167,104,17,-6,-196,-643,-933,-656,-315,-483,-725,-591,-193,154,226,12,-112,-29,66,45,-77,-159,-225,-242,-260,-352,-347,-179,-85,-185,-279,-215,-85,12,-11,-60,-46,14,72,95,60,-43,-131,-193,-171,-119,-128,-173,-181,-162,-97,-27,-21,-32,-23,-25,-67,-60},
            {-9,24,-48,57,-80,97,-110,137,-170,1490,5015,7251,3579,-13367,-7436,10180,7248,3405,5098,5239,1850,929,-3603,-7660,-5531,-4112,-4414,-3998,-1105,-38,1040,1755,2365,2677,1230,1201,1404,377,-1136,-561,-145,-208,-63,-949,-2185,-2294,-1682,-1010,-31,657,1027,844,611,891,858,202,-322,-500,-214,94,-292,-1135,-1104,-647,-607,-377,-2,81,15,-52,-385,-726,-696,-387,-228,-287,-299,-118,51,178,139,40,-6,-125,-206,-196,-129,-50,-170,-382,-389,-246,-25,24,-62,-245,-414,-328,-93,64,36,-133,-226,-100,92,176,143,-12,-218,-304,-237,-94,-1,-86,-343,-487,-373,-34,318,330,20,-259,-218,-12,153,121,-124,-335}
        },
        {    // H80e090a.wav
            {-5,-7,11,-4,10,-14,12,-15,4,6,-13,29,257,2398,3466,2761,-7130,-10356,4793,10633,5487,2358,3459,3213,2524,1075,-3327,-4558,-3460,-2659,-3488,-2822,-1131,-671,15,1137,2025,1217,1276,1580,976,119,-258,-209,-235,-192,-828,-1532,-1858,-1408,-603,-173,66,533,633,411,550,639,261,-151,-386,-388,-357,-440,-595,-773,-660,-293,-47,-4,153,191,106,14,-83,-381,-832,-895,-529,-418,-667,-725,-394,53,241,121,-19,22,95,88,-51,-194,-254,-265,-285,-344,-338,-181,-93,-162,-258,-227,-110,-21,-18,-55,-23,2,22,52,52,-28,-122,-176,-177,-136,-101,-105,-116,-125,-97,-36,-38,-61,-54,-46,-78,-98},
            {-5,15,-40,51,-79,104,-138,177,-208,2144,5580,7779,838,-14895,-3692,10887,6070,3534,5401,4589,1582,589,-4676,-7400,-4980,-4066,-4543,-3725,-772,13,840,1634,2577,2381,1271,1585,1469,108,-1002,-417,-426,-160,-88,-1410,-2510,-2251,-1508,-674,220,882,907,523,634,902,657,43,-336,-377,-26,137,-435,-1169,-1036,-722,-693,-379,34,118,63,-115,-489,-698,-491,-267,-368,-350,-97,8,-37,62,153,196,-36,-254,-311,-202,36,-60,-359,-429,-261,-88,-29,-36,-120,-289,-361,-237,-41,25,-36,-189,-208,-53,106,174,95,-104,-276,-326,-183,17,14,-262,-478,-390,-96,264,314,-12,-299,-229,2,164,84,-129,-291,-325}
        },
        {    // H80e120a.wav
            {-5,-3,15,-7,15,-21,25,-32,32,-32,38,-35,538,2749,3762,1673,-9279,-8160,7513,9938,4128,2289,3820,3180,2577,252,-3981,-4345,-3026,-2899,-3758,-2512,-1173,-791,84,1501,2151,1245,1387,1553,938,-118,-343,-224,-217,-222,-1059,-1845,-1765,-897,-467,-375,231,622,373,363,652,564,44,-151,-128,-338,-520,-372,-478,-865,-719,-232,-70,7,114,127,157,83,-131,-527,-816,-732,-474,-513,-720,-644,-202,133,110,68,102,92,79,36,-107,-220,-243,-280,-389,-390,-235,-106,-112,-191,-222,-161,-79,-29,-60,-71,-33,-5,14,30,3,-81,-134,-159,-141,-98,-75,-85,-100,-93,-58,-38,-48,-57,-70,-98,-106,-70},
            {-6,22,-41,46,-62,70,-77,87,-112,1003,4598,6853,3737,-11721,-8300,9298,7975,3239,4502,5224,2451,1236,-2692,-7003,-5296,-3775,-4393,-4349,-1550,-382,128,1185,2290,2555,1403,1673,1751,710,-755,-509,-287,-390,-117,-1118,-2399,-2294,-1460,-818,-144,721,897,523,658,791,572,44,-238,-298,-41,184,-190,-888,-1005,-781,-800,-519,-61,139,84,-58,-343,-607,-528,-269,-312,-434,-230,-1,-29,31,144,165,21,-200,-293,-189,-28,-49,-265,-391,-308,-174,-26,-15,-75,-207,-337,-291,-107,10,-16,-132,-214,-117,39,129,121,-8,-188,-283,-212,-61,25,-50,-260,-376,-271,-49,136,154,-43,-205,-159,13,132,92,-97,-235}
        },
        {    // H80e150a.wav
            {-9,12,1,5,-5,-3,11,-21,39,-58,92,13,2173,3848,3740,-5254,-11419,3118,11043,5361,2110,3728,3925,2651,1294,-3282,-4983,-3457,-2817,-3957,-3333,-1242,-1135,-448,1201,2360,1696,1502,1707,1119,225,-319,-368,-341,-59,-815,-1817,-1909,-1072,-604,-569,86,513,267,339,679,673,316,28,-139,-311,-434,-273,-299,-832,-899,-430,-203,-168,25,173,100,11,-19,-372,-789,-644,-326,-498,-724,-514,-112,14,41,129,51,12,34,-20,-129,-112,-115,-301,-439,-361,-192,-106,-103,-168,-249,-214,-110,-20,-23,-80,-87,-65,13,61,13,-78,-137,-160,-147,-93,-56,-77,-98,-104,-66,-19,-15,-31,-65,-122,-143,-77,-7},
            {13,-6,12,-25,35,-57,81,-108,147,-158,1975,4781,6035,-1576,-13034,-799,10924,5710,2661,4627,4589,2274,882,-3951,-6330,-4177,-3392,-4595,-3703,-1020,-788,-14,1333,2507,2001,1449,1884,1543,320,-706,-306,-283,-213,-595,-1717,-2316,-1695,-873,-677,-119,661,603,575,772,677,288,-100,-208,-176,-49,60,-242,-912,-872,-707,-712,-401,-1,180,57,-116,-323,-570,-553,-276,-271,-512,-337,-34,-30,-8,185,215,-99,-272,-240,-137,-7,-43,-272,-383,-258,-126,-131,-130,-101,-184,-314,-251,-80,-17,-35,-118,-173,-104,39,100,33,-70,-169,-225,-149,-24,4,-105,-208,-187,-93,-31,-44,-122,-231,-170,-6,71,57,8,-43}
        },
        {    // H80e180a.wav
            {8,5,3,2,-13,23,-39,62,-85,124,-87,2087,4289,4777,-3686,-12164,1617,11097,5365,2254,4159,4313,2517,1093,-3618,-5633,-3730,-3082,-4320,-3531,-1141,-1009,-395,1241,2486,1816,1571,1875,1324,220,-473,-308,-352,-109,-788,-1870,-2071,-1247,-655,-641,-56,467,354,492,767,666,295,33,-126,-280,-332,-52,-175,-903,-888,-561,-497,-312,12,182,88,-64,-210,-482,-613,-405,-319,-558,-520,-189,-46,-45,82,158,-8,-117,-107,-141,-138,-84,-140,-272,-300,-220,-203,-162,-136,-175,-274,-264,-91,-5,-7,-75,-123,-97,-12,69,24,-74,-157,-206,-152,-54,-10,-75,-139,-141,-72,-5,-16,-41,-100,-163,-172,-128,-76,-38},
            {8,5,3,2,-13,23,-39,62,-85,124,-87,2087,4289,4777,-3686,-12164,1617,11097,5365,2254,4159,4313,2517,1093,-3618,-5633,-3730,-3082,-4320,-3531,-1141,-1009,-395,1241,2486,1816,1571,1875,1324,220,-473,-308,-352,-109,-788,-1870,-2071,-1247,-655,-641,-56,467,354,492,767,666,295,33,-126,-280,-332,-52,-175,-903,-888,-561,-497,-312,12,182,88,-64,-210,-482,-613,-405,-319,-558,-520,-189,-46,-45,82,158,-8,-117,-107,-141,-138,-84,-140,-272,-300,-220,-203,-162,-136,-175,-274,-264,-91,-5,-7,-75,-123,-97,-12,69,24,-74,-157,-206,-152,-54,-10,-75,-139,-141,-72,-5,-16,-41,-100,-163,-172,-128,-76,-38}
        }
    },
    {    // elev90
        {    // H90e000a.wav
            {5,-16,26,-41,63,-81,119,-73,2020,4378,5862,-903,-11453,-1186,9080,4800,2577,4817,4371,2144,575,-3634,-5593,-3944,-3191,-4101,-3272,-1131,-482,514,1269,2172,1956,1147,1256,990,-222,-780,134,460,257,-481,-1587,-2274,-1906,-1100,-432,-2,355,547,419,651,931,678,145,-284,-374,-347,-98,-141,-816,-1128,-690,-358,-272,105,75,-125,-120,-96,-275,-592,-607,-361,-364,-647,-563,-77,190,92,42,0,-123,-222,-170,-55,59,53,-195,-453,-387,-120,23,-107,-440,-607,-424,-74,136,51,-75,-11,93,170,173,79,-115,-263,-269,-222,-146,-100,-138,-198,-199,-118,6,70,29,-59,-127,-124,-20,69,38,-69,-132,-141},
            {5,-16,26,-41,63,-81,119,-73,2020,4378,5862,-903,-11453,-1186,9080,4800,2577,4817,4371,2144,575,-3634,-5593,-3944,-3191,-4101,-3272,-1131,-482,514,1269,2172,1956,1147,1256,990,-222,-780,134,460,257,-481,-1587,-2274,-1906,-1100,-432,-2,355,547,419,651,931,678,145,-284,-374,-347,-98,-141,-816,-1128,-690,-358,-272,105,75,-125,-120,-96,-275,-592,-607,-361,-364,-647,-563,-77,190,92,42,0,-123,-222,-170,-55,59,53,-195,-453,-387,-120,23,-107,-440,-607,-424,-74,136,51,-75,-11,93,170,173,79,-115,-263,-269,-222,-146,-100,-138,-198,-199,-118,6,70,29,-59,-127,-124,-20,69,38,-69,-132,-141}
        }
    }
};
