/**
 * \file pappsomspp/processing/cbor/psm/psmfilescanprocess.h
 * \date 12/07/2025
 * \author Olivier Langella
 * \brief PSM file reader designed to parallelize scan process
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#include "psmfilescanprocess.h"
#include "pappsomspp/core/pappsoexception.h"
#include <QtConcurrent>


namespace pappso
{
namespace cbor
{
namespace psm
{

PsmFileScanProcess::PsmFileScanProcess(std::size_t buffer_scan_size)
{
  m_bufferScanSize = buffer_scan_size;
}

PsmFileScanProcess::~PsmFileScanProcess()
{
}

void
PsmFileScanProcess::clearScanBuffer()
{
  for(CborScanMapBase *cbor_scan_p : m_cborScanList)
    {
      delete cbor_scan_p;
    }
  m_cborScanList.clear();
}


void
PsmFileScanProcess::readScan(pappso::UiMonitorInterface &monitor)
{
  qDebug();
  //  auto& ref = elections.emplace_back("Nelson Mandela", "South Africa", 1994);
  CborScanMapBase *scan_map_p = newCborScanMap();
  m_cborScanList.push_back(scan_map_p);

  if(!mpa_cborReader->readCborMap(*scan_map_p))
    {
      throw pappso::PappsoException(QObject::tr("readCborMap scan failed"));
    }
  // m_cborScanList.push_back(scan_map);
  qDebug() << "scan end";
  scanFinished(monitor);
  qDebug();
}

void
PsmFileScanProcess::scanFinished(pappso::UiMonitorInterface &monitor)
{

  // monitor.setStatus(QObject::tr("PsmFileScanProcess::scanFinished
  // %1").arg(m_cborScanList.size()));
  if(m_cborScanList.size() > m_bufferScanSize)
    {
      processBufferScan(monitor);
      clearScanBuffer();
    }
}

void
PsmFileScanProcess::sampleFinished(pappso::UiMonitorInterface &monitor)
{
  // qWarning() << "sampleFinished";
  processBufferScan(monitor);
  clearScanBuffer();
}


void
PsmFileScanProcess::processBufferScan(pappso::UiMonitorInterface &monitor)
{
  // you decide how to process the list of scans
  // monitor.setStatus(
  //  QObject::tr("PsmFileScanProcess::processBufferScan %1").arg(m_cborScanList.size()));
  std::function<void(CborScanMapBase *)> mapProcessCborScan = [](CborScanMapBase *cbor_scan_p) {
    cbor_scan_p->process();
  };


  QFuture<void> res = QtConcurrent::map<std::vector<CborScanMapBase *>::iterator>(
    m_cborScanList.begin(), m_cborScanList.end(), mapProcessCborScan);
  res.waitForFinished();
  processBufferScanDone(monitor);

  // monitor.setStatus(
  //  QObject::tr("PsmFileScanProcess::processBufferScan %1 done").arg(m_cborScanList.size()));
}

void
PsmFileScanProcess::processBufferScanDone(pappso::UiMonitorInterface &monitor)
{
  // you decide what to do with processed scans
}

} // namespace psm
} // namespace cbor
} // namespace pappso
