# frozen_string_literal: true

class PrepareIndexForInitialAndLatestPipelineIdToVulnerabilityOccurrences < Gitlab::Database::Migration[2.2]
  milestone '16.10'

  TABLE_NAME = :vulnerability_occurrences
  INITIAL_PIPELINE_INDEX = 'index_vulnerability_occurrences_on_initial_pipeline_id'
  LATEST_PIPELINE_INDEX = 'index_vulnerability_occurrences_on_latest_pipeline_id'

  # Index created synchronously in https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145782
  def up
    prepare_async_index TABLE_NAME, :initial_pipeline_id, name: INITIAL_PIPELINE_INDEX
    prepare_async_index TABLE_NAME, :latest_pipeline_id, name: LATEST_PIPELINE_INDEX
  end

  def down
    unprepare_async_index TABLE_NAME, :initial_pipeline_id, name: INITIAL_PIPELINE_INDEX
    unprepare_async_index TABLE_NAME, :latest_pipeline_id, name: LATEST_PIPELINE_INDEX
  end
end
