Language scripts
================

> Originally "Teeworlds language scripts" by timakro

These scripts can help you to improve the language files. This is a short tutorial
about how to use the scripts.


You can start by analyzing the current languages using `analyze.py`:

```shell
$ ./analyze.py
```

`analyze.py` outputs several columns. The column 'total' is the number of
translations in the file. 'empty' is the number of untranslated phrases in the
file. The 2nd and 3rd columns are calculated by looking into the source. The script
searches through the source for all phrases. 'missing' is the number of phrases in
the source but not in the file. 'unused' is the number of phrases in the file but
not in the source.


To update a language you should first copy it using the `copy_fix.py` script.

```shell
$ ./copy_fix.py ../spanish.txt newspanish.txt --delete-unused --append-missing
```

Then you can start to modify newspanish.txt. Search in the file for the following
line and remove it:

```
##### generated by copy_fix.py, please translate this #####
```

Every phrase below this line should be empty. Now you can fill in the translations
you know. It's also okay to write just the same phrase as in English for words like
'Hookcollision' or 'Screenshot'. If you don't know how to translate something just
remove it.

That's all, you improved the translation. If you want you can add your name at the
start of the file. Now you can move the file back to its original location.

```shell
$ mv newspanish.txt ../spanish.txt
```

Often people know better phrases for translations where the English phrase was just
copied. To find these you can use `find_unchanged.py`

```shell
$ ./find_unchanged.py ../spanish.txt
```

To update all languages:

```shell
$ ./update_all.py
```

To get a statistic of how complete the translation is:

```shell
for i in data/languages/*.txt; do
  COVERED=$(grep "^== " "$i" | grep -v "^== $" | wc -l)
  TOTAL=$(grep "^== " "$i" | wc -l)
  BASENAME=$(basename "$i")
  BASENAME_NO_EXT="${BASENAME%.txt}"
  if [ "$BASENAME" != "license.txt" ] && [ "$BASENAME" != "index.txt" ]; then
    [ "$TOTAL" -ne 0 ] && echo "$((COVERED * 100 / TOTAL))% $BASENAME_NO_EXT"
  fi
done | sort -n -r
```
