<a name="#run_binary"></a>
## run_binary

<pre>
run_binary(<a href="#run_binary-name">name</a>, <a href="#run_binary-args">args</a>, <a href="#run_binary-env">env</a>, <a href="#run_binary-outs">outs</a>, <a href="#run_binary-srcs">srcs</a>, <a href="#run_binary-tool">tool</a>)
</pre>

Runs a binary as a build action.<br/><br/>This rule does not require Bash (unlike <code>native.genrule</code>).

### Attributes

<table class="params-table">
  <colgroup>
    <col class="col-param" />
    <col class="col-description" />
  </colgroup>
  <tbody>
    <tr id="run_binary-name">
      <td><code>name</code></td>
      <td>
        <a href="https://bazel.build/docs/build-ref.html#name">Name</a>; required
        <p>
          A unique name for this target.
        </p>
      </td>
    </tr>
    <tr id="run_binary-args">
      <td><code>args</code></td>
      <td>
        List of strings; optional
        <p>
          Command line arguments of the binary.<br/><br/>Subject to<code><a href="https://docs.bazel.build/versions/master/be/make-variables.html#location">$(location)</a></code> expansion.
        </p>
      </td>
    </tr>
    <tr id="run_binary-env">
      <td><code>env</code></td>
      <td>
        <a href="https://bazel.build/docs/skylark/lib/dict.html">Dictionary: String -> String</a>; optional
        <p>
          Environment variables of the action.<br/><br/>Subject to  <code><a href="https://docs.bazel.build/versions/master/be/make-variables.html#location">$(location)</a></code> expansion.
        </p>
      </td>
    </tr>
    <tr id="run_binary-outs">
      <td><code>outs</code></td>
      <td>
        List of labels; required
        <p>
          Output files generated by the action.<br/><br/>These labels are available for <code>$(location)</code> expansion in <code>args</code> and <code>env</code>.
        </p>
      </td>
    </tr>
    <tr id="run_binary-srcs">
      <td><code>srcs</code></td>
      <td>
        <a href="https://bazel.build/docs/build-ref.html#labels">List of labels</a>; optional
        <p>
          Additional inputs of the action.<br/><br/>These labels are available for <code>$(location)</code> expansion in <code>args</code> and <code>env</code>.
        </p>
      </td>
    </tr>
    <tr id="run_binary-tool">
      <td><code>tool</code></td>
      <td>
        <a href="https://bazel.build/docs/build-ref.html#labels">Label</a>; required
        <p>
          The tool to run in the action.<br/><br/>Must be the label of a *_binary rule, of a rule that generates an executable file, or of a file that can be executed as a subprocess (e.g. an .exe or .bat file on Windows or a binary with executable permission on Linux). This label is available for <code>$(location)</code> expansion in <code>args</code> and <code>env</code>.
        </p>
      </td>
    </tr>
  </tbody>
</table>


