package Lido::XML::LIDO_1_0::datums;

use Moo;

our $VERSION = '0.03';

sub content {
	my @lines = <DATA>;
	join '' , @lines;
}

1;
__DATA__
<?xml version="1.0" encoding="UTF-8"?>
<schema targetNamespace="http://www.opengis.net/gml" xmlns:gml="http://www.opengis.net/gml" xmlns="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified" version="3.1.1.2" xml:lang="en">
	<annotation>
		<appinfo source="urn:opengis:specification:gml:schema-xsd:datums:3.1.1"/>
		<documentation>How to encode datum definitions. Builds on referenceSystems.xsd to encode the data needed to define datums, including the specific subtypes of datums. 
		This schema encodes the Datum (CD_) package of the extended UML Model for OGC Abstract Specification Topic 2: Spatial Referencing by Coordinates. That UML model is adapted from ISO 19111 - Spatial referencing by coordinates, as described in Annex C of Topic 2. 
		Caution: The CRS package in GML 3.1 and GML 3.1.1 is preliminary, and is expected to undergo some modifications that are not backward compatible during the development of GML 3.2 (ISO 19136). The GML 3.2 package will implement the model described in the revised version of ISO 19111.
		
		GML is an OGC Standard.
		Copyright (c) 2001,2005,2010 Open Geospatial Consortium.
		To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
		</documentation>
	</annotation>
	<!-- ======================================================
       includes and imports
	====================================================== -->
	<include schemaLocation="gml.xsd"/>
	<include schemaLocation="referenceSystems.xsd"/>
	<!-- ======================================================
       elements and types
	====================================================== -->
	<element name="_Datum" type="gml:AbstractDatumType" abstract="true" substitutionGroup="gml:Definition"/>
	<!-- =================================================== -->
	<complexType name="AbstractDatumBaseType" abstract="true">
		<annotation>
			<documentation>Basic encoding for datum objects, simplifying and restricting the DefinitionType as needed. </documentation>
		</annotation>
		<complexContent>
			<restriction base="gml:DefinitionType">
				<sequence>
					<element ref="gml:metaDataProperty" minOccurs="0" maxOccurs="unbounded"/>
					<element ref="gml:datumName"/>
				</sequence>
				<attribute ref="gml:id" use="required"/>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =================================================== -->
	<element name="datumName" type="gml:CodeType" substitutionGroup="gml:name">
		<annotation>
			<documentation>The name by which this datum is identified. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<complexType name="AbstractDatumType" abstract="true">
		<annotation>
			<documentation>A datum specifies the relationship of a coordinate system to the earth, thus creating a coordinate reference system. A datum uses a parameter or set of parameters that determine the location of the origin of the coordinate reference system. Each datum subtype can be associated with only specific types of coordinate systems. This abstract complexType shall not be used, extended, or restricted, in an Application Schema, to define a concrete subtype with a meaning equivalent to a concrete subtype specified in this document. </documentation>
		</annotation>
		<complexContent>
			<extension base="gml:AbstractDatumBaseType">
				<sequence>
					<element ref="gml:datumID" minOccurs="0" maxOccurs="unbounded">
						<annotation>
							<documentation>Set of alternative identifications of this datum. The first datumID, if any, is normally the primary identification code, and any others are aliases. </documentation>
						</annotation>
					</element>
					<element ref="gml:remarks" minOccurs="0">
						<annotation>
							<documentation>Comments on this reference system, including source information. </documentation>
						</annotation>
					</element>
					<element ref="gml:anchorPoint" minOccurs="0"/>
					<element ref="gml:realizationEpoch" minOccurs="0"/>
					<element ref="gml:validArea" minOccurs="0"/>
					<element ref="gml:scope" minOccurs="0"/>
				</sequence>
			</extension>
		</complexContent>
	</complexType>
	<!-- =================================================== -->
	<element name="datumID" type="gml:IdentifierType">
		<annotation>
			<documentation>An identification of a datum. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<element name="anchorPoint" type="gml:CodeType">
		<annotation>
			<documentation>Description, possibly including coordinates, of the point or points used to anchor the datum to the Earth. Also known as the "origin", especially for engineering and image datums. The codeSpace attribute can be used to reference a source of more detailed on this point or surface, or on a set of such descriptions. 
- For a geodetic datum, this point is also known as the fundamental point, which is traditionally the point where the relationship between geoid and ellipsoid is defined. In some cases, the "fundamental point" may consist of a number of points. In those cases, the parameters defining the geoid/ellipsoid relationship have been averaged for these points, and the averages adopted as the datum definition.
- For an engineering datum, the anchor point may be a physical point, or it may be a point with defined coordinates in another CRS. When appropriate, the coordinates of this anchor point can be referenced in another document, such as referencing a GML feature that references or includes a point position.
- For an image datum, the anchor point is usually either the centre of the image or the corner of the image.
- For a temporal datum, this attribute is not defined. Instead of the anchor point, a temporal datum carries a separate time origin of type DateTime. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<element name="realizationEpoch" type="date">
		<annotation>
			<documentation>The time after which this datum definition is valid. This time may be precise (e.g. 1997.0 for IRTF97) or merely a year (e.g. 1983 for NAD83). In the latter case, the epoch usually refers to the year in which a major recalculation of the geodetic control network, underlying the datum, was executed or initiated. An old datum can remain valid after a new datum is defined. Alternatively, a datum may be superseded by a later datum, in which case the realization epoch for the new datum defines the upper limit for the validity of the superseded datum. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<element name="datumRef" type="gml:DatumRefType"/>
	<!-- =================================================== -->
	<complexType name="DatumRefType">
		<annotation>
			<documentation>Association to a datum, either referencing or containing the definition of that datum. </documentation>
		</annotation>
		<sequence minOccurs="0">
			<element ref="gml:_Datum"/>
		</sequence>
		<attributeGroup ref="gml:AssociationAttributeGroup"/>
	</complexType>
	<!-- =================================================== -->
	<element name="EngineeringDatum" type="gml:EngineeringDatumType" substitutionGroup="gml:_Datum"/>
	<!-- =================================================== -->
	<complexType name="EngineeringDatumType">
		<annotation>
			<documentation>An engineering datum defines the origin of an engineering coordinate reference system, and is used in a region around that origin. This origin can be fixed with respect to the earth (such as a defined point at a construction site), or be a defined point on a moving vehicle (such as on a ship or satellite). </documentation>
		</annotation>
		<complexContent>
			<extension base="gml:AbstractDatumType"/>
		</complexContent>
	</complexType>
	<!-- =================================================== -->
	<element name="engineeringDatumRef" type="gml:EngineeringDatumRefType"/>
	<!-- =================================================== -->
	<complexType name="EngineeringDatumRefType">
		<annotation>
			<documentation>Association to an engineering datum, either referencing or containing the definition of that datum. </documentation>
		</annotation>
		<sequence minOccurs="0">
			<element ref="gml:EngineeringDatum"/>
		</sequence>
		<attributeGroup ref="gml:AssociationAttributeGroup"/>
	</complexType>
	<!-- =================================================== -->
	<element name="ImageDatum" type="gml:ImageDatumType" substitutionGroup="gml:_Datum"/>
	<!-- =================================================== -->
	<complexType name="ImageDatumType">
		<annotation>
			<documentation>An image datum defines the origin of an image coordinate reference system, and is used in a local context only. For more information, see OGC Abstract Specification Topic 2. </documentation>
		</annotation>
		<complexContent>
			<extension base="gml:AbstractDatumType">
				<sequence>
					<element ref="gml:pixelInCell"/>
				</sequence>
			</extension>
		</complexContent>
	</complexType>
	<!-- =================================================== -->
	<element name="pixelInCell" type="gml:PixelInCellType"/>
	<!-- =================================================== -->
	<complexType name="PixelInCellType">
		<annotation>
			<documentation>Specification of the way an image grid is associated with the image data attributes. </documentation>
		</annotation>
		<simpleContent>
			<restriction base="gml:CodeType">
				<attribute name="codeSpace" type="anyURI" use="required">
					<annotation>
						<documentation>Reference to a source of information specifying the values and meanings of all the allowed string values for this PixelInCellType. </documentation>
					</annotation>
				</attribute>
			</restriction>
		</simpleContent>
	</complexType>
	<!-- =================================================== -->
	<element name="imageDatumRef" type="gml:ImageDatumRefType"/>
	<!-- =================================================== -->
	<complexType name="ImageDatumRefType">
		<annotation>
			<documentation>Association to an image datum, either referencing or containing the definition of that datum. </documentation>
		</annotation>
		<sequence minOccurs="0">
			<element ref="gml:ImageDatum"/>
		</sequence>
		<attributeGroup ref="gml:AssociationAttributeGroup"/>
	</complexType>
	<!-- =================================================== -->
	<element name="VerticalDatum" type="gml:VerticalDatumType" substitutionGroup="gml:_Datum"/>
	<!-- =================================================== -->
	<complexType name="VerticalDatumType">
		<annotation>
			<documentation>A textual description and/or a set of parameters identifying a particular reference level surface used as a zero-height surface, including its position with respect to the Earth for any of the height types recognized by this standard. There are several types of Vertical Datums, and each may place constraints on the Coordinate Axis with which it is combined to create a Vertical CRS. </documentation>
		</annotation>
		<complexContent>
			<extension base="gml:AbstractDatumType">
				<sequence>
					<element ref="gml:verticalDatumType" minOccurs="0"/>
				</sequence>
			</extension>
		</complexContent>
	</complexType>
	<!-- =================================================== -->
	<element name="verticalDatumType" type="gml:VerticalDatumTypeType"/>
	<!-- =================================================== -->
	<complexType name="VerticalDatumTypeType">
		<annotation>
			<documentation>Type of a vertical datum. </documentation>
		</annotation>
		<simpleContent>
			<restriction base="gml:CodeType">
				<attribute name="codeSpace" type="anyURI" use="required">
					<annotation>
						<documentation>Reference to a source of information specifying the values and meanings of all the allowed string values for this VerticalDatumTypeType. </documentation>
					</annotation>
				</attribute>
			</restriction>
		</simpleContent>
	</complexType>
	<!-- =================================================== -->
	<element name="verticalDatumRef" type="gml:VerticalDatumRefType"/>
	<!-- =================================================== -->
	<complexType name="VerticalDatumRefType">
		<annotation>
			<documentation>Association to a vertical datum, either referencing or containing the definition of that datum. </documentation>
		</annotation>
		<sequence minOccurs="0">
			<element ref="gml:VerticalDatum"/>
		</sequence>
		<attributeGroup ref="gml:AssociationAttributeGroup"/>
	</complexType>
	<!-- =================================================== -->
	<element name="TemporalDatum" type="gml:TemporalDatumType" substitutionGroup="gml:_Datum"/>
	<!-- =================================================== -->
	<complexType name="TemporalDatumBaseType" abstract="true">
		<annotation>
			<documentation>Partially defines the origin of a temporal coordinate reference system. This type restricts the AbstractDatumType to remove the "anchorPoint" and "realizationEpoch" elements. </documentation>
		</annotation>
		<complexContent>
			<restriction base="gml:AbstractDatumType">
				<sequence>
					<element ref="gml:metaDataProperty" minOccurs="0" maxOccurs="unbounded"/>
					<element ref="gml:datumName"/>
					<element ref="gml:datumID" minOccurs="0" maxOccurs="unbounded"/>
					<element ref="gml:validArea" minOccurs="0"/>
					<element ref="gml:scope" minOccurs="0"/>
				</sequence>
				<attribute ref="gml:id" use="required"/>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =================================================== -->
	<complexType name="TemporalDatumType">
		<annotation>
			<documentation>Defines the origin of a temporal coordinate reference system. This type extends the TemporalDatumRestrictionType to add the "origin" element with the dateTime type. </documentation>
		</annotation>
		<complexContent>
			<extension base="gml:TemporalDatumBaseType">
				<sequence>
					<element ref="gml:origin"/>
				</sequence>
			</extension>
		</complexContent>
	</complexType>
	<!-- =================================================== -->
	<element name="origin" type="dateTime">
		<annotation>
			<documentation>The date and time origin of this temporal datum. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<element name="temporalDatumRef" type="gml:TemporalDatumRefType"/>
	<!-- =================================================== -->
	<complexType name="TemporalDatumRefType">
		<annotation>
			<documentation>Association to a temporal datum, either referencing or containing the definition of that datum. </documentation>
		</annotation>
		<sequence minOccurs="0">
			<element ref="gml:TemporalDatum"/>
		</sequence>
		<attributeGroup ref="gml:AssociationAttributeGroup"/>
	</complexType>
	<!-- =================================================== -->
	<element name="GeodeticDatum" type="gml:GeodeticDatumType" substitutionGroup="gml:_Datum"/>
	<!-- =================================================== -->
	<complexType name="GeodeticDatumType">
		<annotation>
			<documentation>A geodetic datum defines the precise location and orientation in 3-dimensional space of a defined ellipsoid (or sphere) that approximates the shape of the earth, or of a Cartesian coordinate system centered in this ellipsoid (or sphere). </documentation>
		</annotation>
		<complexContent>
			<extension base="gml:AbstractDatumType">
				<sequence>
					<element ref="gml:usesPrimeMeridian"/>
					<element ref="gml:usesEllipsoid"/>
				</sequence>
			</extension>
		</complexContent>
	</complexType>
	<!-- =================================================== -->
	<element name="usesPrimeMeridian" type="gml:PrimeMeridianRefType">
		<annotation>
			<documentation>Association to the prime meridian used by this geodetic datum. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<element name="usesEllipsoid" type="gml:EllipsoidRefType">
		<annotation>
			<documentation>Association to the ellipsoid used by this geodetic datum. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<element name="geodeticDatumRef" type="gml:GeodeticDatumRefType"/>
	<!-- =================================================== -->
	<complexType name="GeodeticDatumRefType">
		<annotation>
			<documentation>Association to a geodetic datum, either referencing or containing the definition of that datum. </documentation>
		</annotation>
		<sequence minOccurs="0">
			<element ref="gml:GeodeticDatum"/>
		</sequence>
		<attributeGroup ref="gml:AssociationAttributeGroup"/>
	</complexType>
	<!-- =================================================== -->
	<!-- =================================================== -->
	<element name="PrimeMeridian" type="gml:PrimeMeridianType" substitutionGroup="gml:Definition"/>
	<!-- =================================================== -->
	<complexType name="PrimeMeridianBaseType" abstract="true">
		<annotation>
			<documentation>Basic encoding for prime meridian objects, simplifying and restricting the DefinitionType as needed. </documentation>
		</annotation>
		<complexContent>
			<restriction base="gml:DefinitionType">
				<sequence>
					<element ref="gml:metaDataProperty" minOccurs="0" maxOccurs="unbounded"/>
					<element ref="gml:meridianName"/>
				</sequence>
				<attribute ref="gml:id" use="required"/>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =================================================== -->
	<element name="meridianName" type="gml:CodeType" substitutionGroup="gml:name">
		<annotation>
			<documentation>The name by which this prime meridian is identified. The meridianName most common value is Greenwich, and that value shall be used when the greenwichLongitude value is zero. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<complexType name="PrimeMeridianType">
		<annotation>
			<documentation>A prime meridian defines the origin from which longitude values are determined.</documentation>
		</annotation>
		<complexContent>
			<extension base="gml:PrimeMeridianBaseType">
				<sequence>
					<element ref="gml:meridianID" minOccurs="0" maxOccurs="unbounded">
						<annotation>
							<documentation>Set of alternative identifications of this prime meridian. The first meridianID, if any, is normally the primary identification code, and any others are aliases. </documentation>
						</annotation>
					</element>
					<element ref="gml:remarks" minOccurs="0">
						<annotation>
							<documentation>Comments on or information about this prime meridian, including source information. </documentation>
						</annotation>
					</element>
					<element ref="gml:greenwichLongitude"/>
				</sequence>
			</extension>
		</complexContent>
	</complexType>
	<!-- =================================================== -->
	<element name="meridianID" type="gml:IdentifierType">
		<annotation>
			<documentation>An identification of a prime meridian. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<element name="greenwichLongitude" type="gml:AngleChoiceType">
		<annotation>
			<documentation>Longitude of the prime meridian measured from the Greenwich meridian, positive eastward. The greenwichLongitude most common value is zero, and that value shall be used when the meridianName value is Greenwich. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<element name="primeMeridianRef" type="gml:PrimeMeridianRefType"/>
	<!-- =================================================== -->
	<complexType name="PrimeMeridianRefType">
		<annotation>
			<documentation>Association to a prime meridian, either referencing or containing the definition of that meridian. </documentation>
		</annotation>
		<sequence minOccurs="0">
			<element ref="gml:PrimeMeridian"/>
		</sequence>
		<attributeGroup ref="gml:AssociationAttributeGroup"/>
	</complexType>
	<!-- =================================================== -->
	<element name="Ellipsoid" type="gml:EllipsoidType" substitutionGroup="gml:Definition"/>
	<!-- =================================================== -->
	<complexType name="EllipsoidBaseType" abstract="true">
		<annotation>
			<documentation>Basic encoding for ellipsoid objects, simplifying and restricting the DefinitionType as needed. </documentation>
		</annotation>
		<complexContent>
			<restriction base="gml:DefinitionType">
				<sequence>
					<element ref="gml:metaDataProperty" minOccurs="0" maxOccurs="unbounded"/>
					<element ref="gml:ellipsoidName"/>
				</sequence>
				<attribute ref="gml:id" use="required"/>
			</restriction>
		</complexContent>
	</complexType>
	<!-- =================================================== -->
	<element name="ellipsoidName" type="gml:CodeType" substitutionGroup="gml:name">
		<annotation>
			<documentation>The name by which this ellipsoid is identified. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<complexType name="EllipsoidType">
		<annotation>
			<documentation>An ellipsoid is a geometric figure that can be used to describe the approximate shape of the earth. In mathematical terms, it is a surface formed by the rotation of an ellipse about its minor axis.</documentation>
		</annotation>
		<complexContent>
			<extension base="gml:EllipsoidBaseType">
				<sequence>
					<element ref="gml:ellipsoidID" minOccurs="0" maxOccurs="unbounded">
						<annotation>
							<documentation>Set of alternative identifications of this ellipsoid. The first ellipsoidID, if any, is normally the primary identification code, and any others are aliases. </documentation>
						</annotation>
					</element>
					<element ref="gml:remarks" minOccurs="0">
						<annotation>
							<documentation>Comments on or information about this ellipsoid, including source information. </documentation>
						</annotation>
					</element>
					<element ref="gml:semiMajorAxis"/>
					<element ref="gml:secondDefiningParameter"/>
				</sequence>
			</extension>
		</complexContent>
	</complexType>
	<!-- =================================================== -->
	<element name="ellipsoidID" type="gml:IdentifierType">
		<annotation>
			<documentation>An identification of an ellipsoid. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<element name="semiMajorAxis" type="gml:MeasureType">
		<annotation>
			<documentation>Length of the semi-major axis of the ellipsoid, with its units. Uses the MeasureType with the restriction that the unit of measure referenced by uom must be suitable for a length, such as metres or feet. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<element name="ellipsoidRef" type="gml:EllipsoidRefType"/>
	<!-- =================================================== -->
	<complexType name="EllipsoidRefType">
		<annotation>
			<documentation>Association to an ellipsoid, either referencing or containing the definition of that ellipsoid. </documentation>
		</annotation>
		<sequence minOccurs="0">
			<element ref="gml:Ellipsoid"/>
		</sequence>
		<attributeGroup ref="gml:AssociationAttributeGroup"/>
	</complexType>
	<!-- =================================================== -->
	<element name="secondDefiningParameter" type="gml:SecondDefiningParameterType"/>
	<!-- =================================================== -->
	<complexType name="SecondDefiningParameterType">
		<annotation>
			<documentation>Definition of the second parameter that defines the shape of an ellipsoid. An ellipsoid requires two defining parameters: semi-major axis and inverse flattening or semi-major axis and semi-minor axis. When the reference body is a sphere rather than an ellipsoid, only a single defining parameter is required, namely the radius of the sphere; in that case, the semi-major axis "degenerates" into the radius of the sphere.</documentation>
		</annotation>
		<choice>
			<element ref="gml:inverseFlattening"/>
			<element ref="gml:semiMinorAxis"/>
			<element ref="gml:isSphere"/>
		</choice>
	</complexType>
	<!-- =================================================== -->
	<element name="inverseFlattening" type="gml:MeasureType">
		<annotation>
			<documentation>Inverse flattening value of the ellipsoid. Value is a scale factor (or ratio) that has no physical unit. Uses the MeasureType with the restriction that the unit of measure referenced by uom must be suitable for a scale factor, such as percent, permil, or parts-per-million. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<element name="semiMinorAxis" type="gml:MeasureType">
		<annotation>
			<documentation>Length of the semi-minor axis of the ellipsoid. Uses the MeasureType with the restriction that the unit of measure referenced by uom must be suitable for a length, such as metres or feet. </documentation>
		</annotation>
	</element>
	<!-- =================================================== -->
	<element name="isSphere">
		<annotation>
			<documentation>The ellipsoid is degenerate and is actually a sphere. The sphere is completely defined by the semi-major axis, which is the radius of the sphere. </documentation>
		</annotation>
		<simpleType>
			<restriction base="string">
				<enumeration value="sphere"/>
			</restriction>
		</simpleType>
	</element>
	<!-- =================================================== -->
</schema>

