######################################################################
#
# 1275_cp932ibm_by_jef9p.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x00"],
        ["\x01",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x01"],
        ["\x02",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x02"],
        ["\x03",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x03"],
        ["\x37",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x04"],
        ["\x2D",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x05"],
        ["\x2E",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x06"],
        ["\x2F",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x07"],
        ["\x16",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x08"],
        ["\x05",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x09"],
        ["\x15",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x0A"],
        ["\x0B",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x0B"],
        ["\x0C",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x0C"],
        ["\x0D",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x0D"],
        ["\x0E",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x0E"],
        ["\x0F",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x0F"],
        ["\x10",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x10"],
        ["\x11",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x11"],
        ["\x12",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x12"],
        ["\x13",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x13"],
        ["\x3C",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x14"],
        ["\x3D",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x15"],
        ["\x32",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x16"],
        ["\x26",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x17"],
        ["\x18",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x18"],
        ["\x19",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x19"],
        ["\x3F",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x1A"],
        ["\x27",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x1B"],
        ["\x1C",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x1C"],
        ["\x1D",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x1D"],
        ["\x1E",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x1E"],
        ["\x1F",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x1F"],
        ["\x40",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x20"],
        ["\x4F",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x21"],
        ["\x7F",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x22"],
        ["\x7B",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x23"],
        ["\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x24"],
        ["\x6C",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x25"],
        ["\x50",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x26"],
        ["\x7D",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x27"],
        ["\x4D",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x28"],
        ["\x5D",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x29"],
        ["\x5C",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x2A"],
        ["\x4E",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x2B"],
        ["\x6B",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x2C"],
        ["\x60",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x2D"],
        ["\x4B",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x2E"],
        ["\x61",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x2F"],
        ["\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x30"],
        ["\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x31"],
        ["\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x32"],
        ["\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x33"],
        ["\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x34"],
        ["\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x35"],
        ["\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x36"],
        ["\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x37"],
        ["\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x38"],
        ["\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x39"],
        ["\x7A",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x3A"],
        ["\x5E",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x3B"],
        ["\x4C",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x3C"],
        ["\x7E",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x3D"],
        ["\x6E",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x3E"],
        ["\x6F",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x3F"],
        ["\x7C",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x40"],
        ["\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x41"],
        ["\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x42"],
        ["\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x43"],
        ["\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x44"],
        ["\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x45"],
        ["\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x46"],
        ["\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x47"],
        ["\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x48"],
        ["\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x49"],
        ["\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x4A"],
        ["\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x4B"],
        ["\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x4C"],
        ["\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x4D"],
        ["\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x4E"],
        ["\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x4F"],
        ["\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x50"],
        ["\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x51"],
        ["\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x52"],
        ["\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x53"],
        ["\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x54"],
        ["\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x55"],
        ["\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x56"],
        ["\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x57"],
        ["\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x58"],
        ["\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x59"],
        ["\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x5A"],
        ["\x4A",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x5B"],
        ["\x5B",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x5C"],
        ["\x5A",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x5D"],
        ["\x5F",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x5E"],
        ["\x6D",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x5F"],
        ["\x79",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x60"],
        ["\x59",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x61"],
        ["\x62",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x62"],
        ["\x63",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x63"],
        ["\x64",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x64"],
        ["\x65",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x65"],
        ["\x66",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x66"],
        ["\x67",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x67"],
        ["\x68",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x68"],
        ["\x69",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x69"],
        ["\x70",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x6A"],
        ["\x71",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x6B"],
        ["\x72",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x6C"],
        ["\x73",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x6D"],
        ["\x74",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x6E"],
        ["\x75",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x6F"],
        ["\x76",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x70"],
        ["\x77",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x71"],
        ["\x78",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x72"],
        ["\x80",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x73"],
        ["\x8B",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x74"],
        ["\x9B",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x75"],
        ["\x9C",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x76"],
        ["\xA0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x77"],
        ["\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x78"],
        ["\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x79"],
        ["\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x7A"],
        ["\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x7B"],
        ["\x6A",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x7C"],
        ["\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x7D"],
        ["\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x7E"],
        ["\x07",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x7F"],
        ["\x20",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x80"],
        ["\x21",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x81"],
        ["\x22",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x82"],
        ["\x23",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x83"],
        ["\x24",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x84"],
        ["\x25",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x85"],
        ["\x06",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x86"],
        ["\x17",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x87"],
        ["\x28",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x88"],
        ["\x29",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x89"],
        ["\x2A",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x8A"],
        ["\x2B",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x8B"],
        ["\x2C",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x8C"],
        ["\x09",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x8D"],
        ["\x0A",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x8E"],
        ["\x1B",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x8F"],
        ["\x30",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x90"],
        ["\x31",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x91"],
        ["\x1A",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x92"],
        ["\x33",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x93"],
        ["\x34",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x94"],
        ["\x35",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x95"],
        ["\x36",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x96"],
        ["\x08",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x97"],
        ["\x38",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x98"],
        ["\x39",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x99"],
        ["\x3A",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x9A"],
        ["\x3B",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x9B"],
        ["\x04",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x9C"],
        ["\x14",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x9D"],
        ["\x3E",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x9E"],
        ["\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\x9F"],
        ["\x57",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xA0"],
        ["\x41",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xA1"],
        ["\x42",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xA2"],
        ["\x43",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xA3"],
        ["\x44",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xA4"],
        ["\x45",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xA5"],
        ["\x46",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xA6"],
        ["\x47",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xA7"],
        ["\x48",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xA8"],
        ["\x49",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xA9"],
        ["\x51",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xAA"],
        ["\x52",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xAB"],
        ["\x53",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xAC"],
        ["\x54",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xAD"],
        ["\x55",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xAE"],
        ["\x56",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xAF"],
        ["\x58",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xB0"],
        ["\x81",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xB1"],
        ["\x82",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xB2"],
        ["\x83",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xB3"],
        ["\x84",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xB4"],
        ["\x85",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xB5"],
        ["\x86",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xB6"],
        ["\x87",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xB7"],
        ["\x88",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xB8"],
        ["\x89",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xB9"],
        ["\x8A",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xBA"],
        ["\x8C",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xBB"],
        ["\x8D",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xBC"],
        ["\x8E",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xBD"],
        ["\x8F",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xBE"],
        ["\x90",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xBF"],
        ["\x91",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xC0"],
        ["\x92",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xC1"],
        ["\x93",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xC2"],
        ["\x94",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xC3"],
        ["\x95",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xC4"],
        ["\x96",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xC5"],
        ["\x97",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xC6"],
        ["\x98",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xC7"],
        ["\x99",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xC8"],
        ["\x9A",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xC9"],
        ["\x9D",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xCA"],
        ["\x9E",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xCB"],
        ["\x9F",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xCC"],
        ["\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xCD"],
        ["\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xCE"],
        ["\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xCF"],
        ["\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xD0"],
        ["\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xD1"],
        ["\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xD2"],
        ["\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xD3"],
        ["\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xD4"],
        ["\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xD5"],
        ["\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xD6"],
        ["\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xD7"],
        ["\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xD8"],
        ["\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xD9"],
        ["\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xDA"],
        ["\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xDB"],
        ["\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xDC"],
        ["\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xDD"],
        ["\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xDE"],
        ["\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xDF"],
        ["\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xE0"],
        ["\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xE1"],
        ["\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xE2"],
        ["\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xE3"],
        ["\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xE4"],
        ["\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xE5"],
        ["\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xE6"],
        ["\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xE7"],
        ["\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xE8"],
        ["\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xE9"],
        ["\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xEA"],
        ["\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xEB"],
        ["\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xEC"],
        ["\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xED"],
        ["\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xEE"],
        ["\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xEF"],
        ["\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xF0"],
        ["\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xF1"],
        ["\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xF2"],
        ["\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xF3"],
        ["\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xF4"],
        ["\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xF5"],
        ["\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xF6"],
        ["\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xF7"],
        ["\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xF8"],
        ["\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xF9"],
        ["\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xFA"],
        ["\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xFB"],
        ["\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xFC"],
        ["\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xFD"],
        ["\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xFE"],
        ["\xFF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'S'},"\xFF"],
        ["\xA1\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x40"],
        ["\xA1\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x41"],
        ["\xA1\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x42"],
        ["\xA1\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x43"],
        ["\xA1\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x44"],
        ["\xA1\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x45"],
        ["\xA1\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x46"],
        ["\xA1\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x47"],
        ["\xA1\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x48"],
        ["\xA1\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x49"],
        ["\xA1\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x4A"],
        ["\xA1\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x4B"],
        ["\xA1\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x4C"],
        ["\xA1\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x4D"],
        ["\xA1\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x4E"],
        ["\xA1\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x4F"],
        ["\xA1\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x50"],
        ["\xA1\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x51"],
        ["\xA1\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x52"],
        ["\xA1\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x53"],
        ["\xA1\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x54"],
        ["\xA1\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x55"],
        ["\xA1\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x56"],
        ["\xA1\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x57"],
        ["\xA1\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x58"],
        ["\xA1\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x59"],
        ["\xA1\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x5A"],
        ["\xA1\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x5B"],
        ["\xA1\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x5C"],
        ["\xA1\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x5D"],
        ["\xA1\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x5E"],
        ["\xA1\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x5F"],
        ["\xA1\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x60"],
        ["\xA1\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x61"],
        ["\xA1\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x62"],
        ["\xA1\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x63"],
        ["\xA1\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x64"],
        ["\xA1\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x65"],
        ["\xA1\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x66"],
        ["\xA1\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x67"],
        ["\xA1\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x68"],
        ["\xA1\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x69"],
        ["\xA1\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x6A"],
        ["\xA1\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x6B"],
        ["\xA1\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x6C"],
        ["\xA1\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x6D"],
        ["\xA1\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x6E"],
        ["\xA1\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x6F"],
        ["\xA1\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x70"],
        ["\xA1\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x71"],
        ["\xA1\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x72"],
        ["\xA1\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x73"],
        ["\xA1\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x74"],
        ["\xA1\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x75"],
        ["\xA1\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x76"],
        ["\xA1\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x77"],
        ["\xA1\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x78"],
        ["\xA1\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x79"],
        ["\xA1\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x7A"],
        ["\xA1\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x7B"],
        ["\xA1\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x7C"],
        ["\xA1\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x7D"],
        ["\xA1\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x7E"],
        ["\xA1\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x80"],
        ["\xA1\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x81"],
        ["\xA1\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x82"],
        ["\xA1\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x83"],
        ["\xA1\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x84"],
        ["\xA1\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x85"],
        ["\xA1\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x86"],
        ["\xA1\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x87"],
        ["\xA1\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x88"],
        ["\xA1\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x89"],
        ["\xA1\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x8A"],
        ["\xA1\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x8B"],
        ["\xA1\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x8C"],
        ["\xA1\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x8D"],
        ["\xA1\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x8E"],
        ["\xA1\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x8F"],
        ["\xA1\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x90"],
        ["\xA1\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x91"],
        ["\xA1\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x92"],
        ["\xA1\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x93"],
        ["\xA1\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x94"],
        ["\xA1\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x95"],
        ["\xA1\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x96"],
        ["\xA1\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x97"],
        ["\xA1\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x98"],
        ["\xA1\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x99"],
        ["\xA1\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x9A"],
        ["\xA1\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x9B"],
        ["\xA1\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x9C"],
        ["\xA1\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x9D"],
        ["\xA1\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x9E"],
        ["\xA2\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\x9F"],
        ["\xA2\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xA0"],
        ["\xA2\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xA1"],
        ["\xA2\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xA2"],
        ["\xA2\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xA3"],
        ["\xA2\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xA4"],
        ["\xA2\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xA5"],
        ["\xA2\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xA6"],
        ["\xA2\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xA7"],
        ["\xA2\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xA8"],
        ["\xA2\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xA9"],
        ["\xA2\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAA"],
        ["\xA2\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAB"],
        ["\xA2\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x7F\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xB8"],
        ["\x7F\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xB9"],
        ["\x7F\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xBA"],
        ["\x7F\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xBB"],
        ["\x7F\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xBC"],
        ["\x7F\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xBD"],
        ["\x7F\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xBE"],
        ["\x7F\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xBF"],
        ["\x7F\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xC8"],
        ["\x7F\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xC9"],
        ["\x76\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xCA"],
        ["\x7F\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xCB"],
        ["\x7F\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xCC"],
        ["\x7F\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xCD"],
        ["\x7F\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xCE"],
        ["\x7F\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xDA"],
        ["\x7F\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xDB"],
        ["\x7F\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xDC"],
        ["\x7F\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xDD"],
        ["\x7F\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xDE"],
        ["\x76\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xDF"],
        ["\x76\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xE0"],
        ["\x7F\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xE1"],
        ["\x7F\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xE2"],
        ["\x7F\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xE3"],
        ["\x7F\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xE4"],
        ["\x7F\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xE5"],
        ["\x76\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xE6"],
        ["\x7F\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xE7"],
        ["\x7F\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xE8"],
        ["\x76\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xF0"],
        ["\x76\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xF1"],
        ["\x7F\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xF2"],
        ["\x7F\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xF3"],
        ["\x7F\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xF4"],
        ["\x7F\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xF5"],
        ["\x7F\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xF6"],
        ["\x7F\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xF7"],
        ["\x7F\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xFC"],
        ["\xA3\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x4F"],
        ["\xA3\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x50"],
        ["\xA3\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x51"],
        ["\xA3\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x52"],
        ["\xA3\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x53"],
        ["\xA3\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x54"],
        ["\xA3\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x55"],
        ["\xA3\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x56"],
        ["\xA3\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x57"],
        ["\xA3\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x58"],
        ["\xA3\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x60"],
        ["\xA3\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x61"],
        ["\xA3\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x62"],
        ["\xA3\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x63"],
        ["\xA3\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x64"],
        ["\xA3\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x65"],
        ["\xA3\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x66"],
        ["\xA3\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x67"],
        ["\xA3\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x68"],
        ["\xA3\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x69"],
        ["\xA3\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x6A"],
        ["\xA3\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x6B"],
        ["\xA3\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x6C"],
        ["\xA3\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x6D"],
        ["\xA3\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x6E"],
        ["\xA3\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x6F"],
        ["\xA3\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x70"],
        ["\xA3\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x71"],
        ["\xA3\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x72"],
        ["\xA3\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x73"],
        ["\xA3\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x74"],
        ["\xA3\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x75"],
        ["\xA3\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x76"],
        ["\xA3\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x77"],
        ["\xA3\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x78"],
        ["\xA3\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x79"],
        ["\xA3\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x81"],
        ["\xA3\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x82"],
        ["\xA3\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x83"],
        ["\xA3\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x84"],
        ["\xA3\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x85"],
        ["\xA3\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x86"],
        ["\xA3\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x87"],
        ["\xA3\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x88"],
        ["\xA3\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x89"],
        ["\xA3\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x8A"],
        ["\xA3\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x8B"],
        ["\xA3\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x8C"],
        ["\xA3\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x8D"],
        ["\xA3\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x8E"],
        ["\xA3\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x8F"],
        ["\xA3\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x90"],
        ["\xA3\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x91"],
        ["\xA3\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x92"],
        ["\xA3\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x93"],
        ["\xA3\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x94"],
        ["\xA3\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x95"],
        ["\xA3\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x96"],
        ["\xA3\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x97"],
        ["\xA3\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x98"],
        ["\xA3\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x99"],
        ["\xA3\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x9A"],
        ["\xA4\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\x9F"],
        ["\xA4\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xA0"],
        ["\xA4\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xA1"],
        ["\xA4\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xA2"],
        ["\xA4\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xA3"],
        ["\xA4\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xA4"],
        ["\xA4\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xA5"],
        ["\xA4\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xA6"],
        ["\xA4\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xA7"],
        ["\xA4\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xA8"],
        ["\xA4\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xA9"],
        ["\xA4\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xAA"],
        ["\xA4\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xAB"],
        ["\xA4\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xAC"],
        ["\xA4\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xAD"],
        ["\xA4\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xAE"],
        ["\xA4\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xAF"],
        ["\xA4\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xB0"],
        ["\xA4\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xB1"],
        ["\xA4\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xB2"],
        ["\xA4\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xB3"],
        ["\xA4\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xB4"],
        ["\xA4\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xB5"],
        ["\xA4\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xB6"],
        ["\xA4\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xB7"],
        ["\xA4\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xB8"],
        ["\xA4\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xB9"],
        ["\xA4\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xBA"],
        ["\xA4\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xBB"],
        ["\xA4\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xBC"],
        ["\xA4\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xBD"],
        ["\xA4\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xBE"],
        ["\xA4\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xBF"],
        ["\xA4\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xC0"],
        ["\xA4\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xC1"],
        ["\xA4\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xC2"],
        ["\xA4\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xC3"],
        ["\xA4\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xC4"],
        ["\xA4\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xC5"],
        ["\xA4\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xC6"],
        ["\xA4\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xC7"],
        ["\xA4\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xC8"],
        ["\xA4\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xC9"],
        ["\xA4\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xCA"],
        ["\xA4\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xCB"],
        ["\xA4\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xCC"],
        ["\xA4\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xCD"],
        ["\xA4\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xCE"],
        ["\xA4\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xCF"],
        ["\xA4\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xD0"],
        ["\xA4\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xD1"],
        ["\xA4\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xD2"],
        ["\xA4\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xD3"],
        ["\xA4\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xD4"],
        ["\xA4\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xD5"],
        ["\xA4\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xD6"],
        ["\xA4\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xD7"],
        ["\xA4\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xD8"],
        ["\xA4\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xD9"],
        ["\xA4\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xDA"],
        ["\xA4\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xDB"],
        ["\xA4\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xDC"],
        ["\xA4\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xDD"],
        ["\xA4\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xDE"],
        ["\xA4\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xDF"],
        ["\xA4\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xE0"],
        ["\xA4\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xE1"],
        ["\xA4\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xE2"],
        ["\xA4\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xE3"],
        ["\xA4\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xE4"],
        ["\xA4\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xE5"],
        ["\xA4\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xE6"],
        ["\xA4\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xE7"],
        ["\xA4\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xE8"],
        ["\xA4\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xE9"],
        ["\xA4\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xEA"],
        ["\xA4\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xEB"],
        ["\xA4\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xEC"],
        ["\xA4\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xED"],
        ["\xA4\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xEE"],
        ["\xA4\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xEF"],
        ["\xA4\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xF0"],
        ["\xA4\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x82\xF1"],
        ["\xA5\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x40"],
        ["\xA5\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x41"],
        ["\xA5\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x42"],
        ["\xA5\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x43"],
        ["\xA5\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x44"],
        ["\xA5\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x45"],
        ["\xA5\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x46"],
        ["\xA5\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x47"],
        ["\xA5\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x48"],
        ["\xA5\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x49"],
        ["\xA5\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x4A"],
        ["\xA5\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x4B"],
        ["\xA5\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x4C"],
        ["\xA5\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x4D"],
        ["\xA5\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x4E"],
        ["\xA5\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x4F"],
        ["\xA5\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x50"],
        ["\xA5\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x51"],
        ["\xA5\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x52"],
        ["\xA5\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x53"],
        ["\xA5\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x54"],
        ["\xA5\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x55"],
        ["\xA5\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x56"],
        ["\xA5\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x57"],
        ["\xA5\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x58"],
        ["\xA5\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x59"],
        ["\xA5\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x5A"],
        ["\xA5\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x5B"],
        ["\xA5\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x5C"],
        ["\xA5\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x5D"],
        ["\xA5\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x5E"],
        ["\xA5\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x5F"],
        ["\xA5\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x60"],
        ["\xA5\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x61"],
        ["\xA5\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x62"],
        ["\xA5\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x63"],
        ["\xA5\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x64"],
        ["\xA5\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x65"],
        ["\xA5\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x66"],
        ["\xA5\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x67"],
        ["\xA5\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x68"],
        ["\xA5\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x69"],
        ["\xA5\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x6A"],
        ["\xA5\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x6B"],
        ["\xA5\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x6C"],
        ["\xA5\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x6D"],
        ["\xA5\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x6E"],
        ["\xA5\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x6F"],
        ["\xA5\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x70"],
        ["\xA5\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x71"],
        ["\xA5\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x72"],
        ["\xA5\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x73"],
        ["\xA5\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x74"],
        ["\xA5\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x75"],
        ["\xA5\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x76"],
        ["\xA5\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x77"],
        ["\xA5\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x78"],
        ["\xA5\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x79"],
        ["\xA5\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x7A"],
        ["\xA5\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x7B"],
        ["\xA5\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x7C"],
        ["\xA5\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x7D"],
        ["\xA5\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x7E"],
        ["\xA5\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x80"],
        ["\xA5\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x81"],
        ["\xA5\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x82"],
        ["\xA5\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x83"],
        ["\xA5\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x84"],
        ["\xA5\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x85"],
        ["\xA5\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x86"],
        ["\xA5\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x87"],
        ["\xA5\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x88"],
        ["\xA5\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x89"],
        ["\xA5\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x8A"],
        ["\xA5\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x8B"],
        ["\xA5\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x8C"],
        ["\xA5\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x8D"],
        ["\xA5\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x8E"],
        ["\xA5\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x8F"],
        ["\xA5\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x90"],
        ["\xA5\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x91"],
        ["\xA5\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x92"],
        ["\xA5\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x93"],
        ["\xA5\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x94"],
        ["\xA5\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x95"],
        ["\xA5\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x96"],
        ["\xA6\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\x9F"],
        ["\xA6\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xA0"],
        ["\xA6\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xA1"],
        ["\xA6\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xA2"],
        ["\xA6\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xA3"],
        ["\xA6\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xA4"],
        ["\xA6\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xA5"],
        ["\xA6\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xA6"],
        ["\xA6\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xA7"],
        ["\xA6\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xA8"],
        ["\xA6\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xA9"],
        ["\xA6\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xAA"],
        ["\xA6\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xAB"],
        ["\xA6\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xAC"],
        ["\xA6\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xAD"],
        ["\xA6\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xAE"],
        ["\xA6\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xAF"],
        ["\xA6\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xB0"],
        ["\xA6\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xB1"],
        ["\xA6\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xB2"],
        ["\xA6\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xB3"],
        ["\xA6\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xB4"],
        ["\xA6\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xB5"],
        ["\xA6\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xB6"],
        ["\xA6\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xBF"],
        ["\xA6\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xC0"],
        ["\xA6\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xC1"],
        ["\xA6\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xC2"],
        ["\xA6\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xC3"],
        ["\xA6\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xC4"],
        ["\xA6\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xC5"],
        ["\xA6\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xC6"],
        ["\xA6\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xC7"],
        ["\xA6\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xC8"],
        ["\xA6\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xC9"],
        ["\xA6\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xCA"],
        ["\xA6\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xCB"],
        ["\xA6\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xCC"],
        ["\xA6\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xCD"],
        ["\xA6\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xCE"],
        ["\xA6\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xCF"],
        ["\xA6\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xD0"],
        ["\xA6\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xD1"],
        ["\xA6\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xD2"],
        ["\xA6\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xD3"],
        ["\xA6\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xD4"],
        ["\xA6\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xD5"],
        ["\xA6\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x83\xD6"],
        ["\xA7\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x40"],
        ["\xA7\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x41"],
        ["\xA7\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x42"],
        ["\xA7\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x43"],
        ["\xA7\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x44"],
        ["\xA7\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x45"],
        ["\xA7\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x46"],
        ["\xA7\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x47"],
        ["\xA7\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x48"],
        ["\xA7\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x49"],
        ["\xA7\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x4A"],
        ["\xA7\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x4B"],
        ["\xA7\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x4C"],
        ["\xA7\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x4D"],
        ["\xA7\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x4E"],
        ["\xA7\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x4F"],
        ["\xA7\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x50"],
        ["\xA7\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x51"],
        ["\xA7\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x52"],
        ["\xA7\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x53"],
        ["\xA7\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x54"],
        ["\xA7\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x55"],
        ["\xA7\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x56"],
        ["\xA7\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x57"],
        ["\xA7\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x58"],
        ["\xA7\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x59"],
        ["\xA7\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x5A"],
        ["\xA7\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x5B"],
        ["\xA7\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x5C"],
        ["\xA7\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x5D"],
        ["\xA7\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x5E"],
        ["\xA7\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x5F"],
        ["\xA7\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x60"],
        ["\xA7\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x70"],
        ["\xA7\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x71"],
        ["\xA7\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x72"],
        ["\xA7\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x73"],
        ["\xA7\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x74"],
        ["\xA7\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x75"],
        ["\xA7\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x76"],
        ["\xA7\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x77"],
        ["\xA7\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x78"],
        ["\xA7\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x79"],
        ["\xA7\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x7A"],
        ["\xA7\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x7B"],
        ["\xA7\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x7C"],
        ["\xA7\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x7D"],
        ["\xA7\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x7E"],
        ["\xA7\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x80"],
        ["\xA7\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x81"],
        ["\xA7\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x82"],
        ["\xA7\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x83"],
        ["\xA7\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x84"],
        ["\xA7\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x85"],
        ["\xA7\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x86"],
        ["\xA7\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x87"],
        ["\xA7\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x88"],
        ["\xA7\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x89"],
        ["\xA7\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x8A"],
        ["\xA7\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x8B"],
        ["\xA7\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x8C"],
        ["\xA7\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x8D"],
        ["\xA7\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x8E"],
        ["\xA7\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x8F"],
        ["\xA7\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x90"],
        ["\xA7\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x91"],
        ["\x7C\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\x9F"],
        ["\x7C\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xA0"],
        ["\x7C\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xA1"],
        ["\x7C\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xA2"],
        ["\x7C\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xA3"],
        ["\x7C\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xA4"],
        ["\x7C\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xA5"],
        ["\x7C\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xA6"],
        ["\x7C\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xA7"],
        ["\x7C\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xA8"],
        ["\x7C\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xA9"],
        ["\x7C\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xAA"],
        ["\x7C\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xAB"],
        ["\x7C\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xAC"],
        ["\x7C\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xAD"],
        ["\x7C\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xAE"],
        ["\x7C\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xAF"],
        ["\x7C\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xB0"],
        ["\x7C\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xB1"],
        ["\x7C\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xB2"],
        ["\x7C\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xB3"],
        ["\x7C\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xB4"],
        ["\x7C\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xB5"],
        ["\x7C\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xB6"],
        ["\x7C\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xB7"],
        ["\x7C\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xB8"],
        ["\x7C\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xB9"],
        ["\x7F\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xBA"],
        ["\x7F\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xBB"],
        ["\x7F\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xBC"],
        ["\x7F\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xBD"],
        ["\x7C\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x84\xBE"],
        ["\x77\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x40"],
        ["\x77\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x41"],
        ["\x77\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x42"],
        ["\x77\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x43"],
        ["\x77\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x44"],
        ["\x77\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x45"],
        ["\x77\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x46"],
        ["\x77\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x47"],
        ["\x77\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x48"],
        ["\x77\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x49"],
        ["\x77\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x4A"],
        ["\x77\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x4B"],
        ["\x77\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x4C"],
        ["\x77\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x4D"],
        ["\x77\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x4E"],
        ["\x77\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x4F"],
        ["\x77\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x50"],
        ["\x77\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x51"],
        ["\x77\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x52"],
        ["\x77\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x53"],
        ["\x77\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x4A"],
        ["\x77\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x4B"],
        ["\x77\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x4C"],
        ["\x77\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x4D"],
        ["\x77\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x4E"],
        ["\x77\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x4F"],
        ["\x77\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x50"],
        ["\x77\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x51"],
        ["\x77\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x52"],
        ["\x77\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x53"],
        ["\x76\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x5F"],
        ["\x76\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x60"],
        ["\x76\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x61"],
        ["\x76\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x62"],
        ["\x76\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x63"],
        ["\x76\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x64"],
        ["\x76\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x65"],
        ["\x76\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x66"],
        ["\x76\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x68"],
        ["\x76\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x69"],
        ["\x76\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x6A"],
        ["\x76\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x6B"],
        ["\x76\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x6C"],
        ["\x76\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x6D"],
        ["\x76\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x6E"],
        ["\x76\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x6F"],
        ["\x76\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x70"],
        ["\x76\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x71"],
        ["\x76\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x72"],
        ["\x76\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x73"],
        ["\x76\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x74"],
        ["\x76\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x75"],
        ["\x76\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x59"],
        ["\x76\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x83"],
        ["\x76\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x5A"],
        ["\x78\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x58"],
        ["\x78\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x8B"],
        ["\x78\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x87\x8C"],
        ["\xB0\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\x9F"],
        ["\xB0\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xA0"],
        ["\xB0\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xA1"],
        ["\xB0\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xA2"],
        ["\xB0\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xA3"],
        ["\xB0\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xA4"],
        ["\xB0\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xA5"],
        ["\xB0\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xA6"],
        ["\xB0\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xA7"],
        ["\xB0\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xA8"],
        ["\xB0\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xA9"],
        ["\xB0\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xAA"],
        ["\xB0\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xAB"],
        ["\xB0\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xAC"],
        ["\xB0\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xAD"],
        ["\xB0\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xAE"],
        ["\xB0\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xAF"],
        ["\xB0\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xB0"],
        ["\xF2\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xB1"],
        ["\xB0\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xB2"],
        ["\xB0\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xB3"],
        ["\xB0\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xB4"],
        ["\xB0\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xB5"],
        ["\xB0\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xB6"],
        ["\xB0\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xB7"],
        ["\xB0\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xB8"],
        ["\xB0\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xB9"],
        ["\xB0\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xBA"],
        ["\xB0\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xBB"],
        ["\xB0\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xBC"],
        ["\xB0\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xBD"],
        ["\xB0\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xBE"],
        ["\xB0\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xBF"],
        ["\xB0\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xC0"],
        ["\xB0\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xC1"],
        ["\xB0\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xC2"],
        ["\xB0\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xC3"],
        ["\xB0\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xC4"],
        ["\xB0\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xC5"],
        ["\xB0\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xC6"],
        ["\xB0\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xC7"],
        ["\xB0\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xC8"],
        ["\xB0\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xC9"],
        ["\xB0\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xCA"],
        ["\xB0\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xCB"],
        ["\xB0\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xCC"],
        ["\xB0\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xCD"],
        ["\xB0\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xCE"],
        ["\xB0\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xCF"],
        ["\xB0\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xD0"],
        ["\xB0\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xD1"],
        ["\xB0\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xD2"],
        ["\xB0\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xD3"],
        ["\xB0\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xD4"],
        ["\xB0\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xD5"],
        ["\xB0\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xD6"],
        ["\xB0\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xD7"],
        ["\xB0\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xD8"],
        ["\xB0\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xD9"],
        ["\xB0\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xDA"],
        ["\xB0\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xDB"],
        ["\xB0\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xDC"],
        ["\xB0\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xDD"],
        ["\xB0\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xDE"],
        ["\xB0\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xDF"],
        ["\xB0\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xE0"],
        ["\xB0\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xE1"],
        ["\xB0\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xE2"],
        ["\xB0\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xE3"],
        ["\xB0\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xE4"],
        ["\xB0\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xE5"],
        ["\xB0\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xE6"],
        ["\xB0\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xE7"],
        ["\xB0\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xE8"],
        ["\xB0\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xE9"],
        ["\xB0\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xEA"],
        ["\xB0\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xEB"],
        ["\xB0\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xEC"],
        ["\xB0\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xED"],
        ["\xB0\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xEE"],
        ["\xB0\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xEF"],
        ["\xB0\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xF0"],
        ["\xB0\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xF1"],
        ["\xB0\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xF2"],
        ["\xB0\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xF3"],
        ["\xB0\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xF4"],
        ["\xB0\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xF5"],
        ["\xB0\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xF6"],
        ["\xB0\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xF7"],
        ["\xB0\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xF8"],
        ["\xB0\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xF9"],
        ["\xB0\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xFA"],
        ["\xB0\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xFB"],
        ["\xB0\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x88\xFC"],
        ["\xB1\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x40"],
        ["\xB1\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x41"],
        ["\xB1\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x42"],
        ["\xB1\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x43"],
        ["\xB1\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x44"],
        ["\xB1\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x45"],
        ["\xB1\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x46"],
        ["\xB1\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x47"],
        ["\xB1\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x48"],
        ["\xB1\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x49"],
        ["\xB1\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x4A"],
        ["\xB1\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x4B"],
        ["\xB1\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x4C"],
        ["\xB1\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x4D"],
        ["\xB1\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x4E"],
        ["\xB1\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x4F"],
        ["\xB1\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x50"],
        ["\xB1\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x51"],
        ["\xB1\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x52"],
        ["\xB1\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x53"],
        ["\xB1\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x54"],
        ["\xB1\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x55"],
        ["\xB1\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x56"],
        ["\xB1\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x57"],
        ["\xB1\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x58"],
        ["\xB1\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x59"],
        ["\xB1\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x5A"],
        ["\xB1\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x5B"],
        ["\xB1\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x5C"],
        ["\xB1\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x5D"],
        ["\xB1\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x5E"],
        ["\xB1\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x5F"],
        ["\xB1\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x60"],
        ["\xB1\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x61"],
        ["\xB1\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x62"],
        ["\xB1\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x63"],
        ["\xB1\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x64"],
        ["\xB1\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x65"],
        ["\xB1\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x66"],
        ["\xB1\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x67"],
        ["\xB1\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x68"],
        ["\xB1\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x69"],
        ["\xB1\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x6A"],
        ["\xB1\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x6B"],
        ["\xB1\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x6C"],
        ["\xB1\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x6D"],
        ["\xB1\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x6E"],
        ["\xB1\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x6F"],
        ["\xB1\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x70"],
        ["\xB1\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x71"],
        ["\xB1\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x72"],
        ["\xB1\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x73"],
        ["\xB1\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x74"],
        ["\xB1\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x75"],
        ["\xB1\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x76"],
        ["\xB1\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x77"],
        ["\xB1\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x78"],
        ["\xB1\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x79"],
        ["\xB1\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x7A"],
        ["\xB1\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x7B"],
        ["\xB1\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x7C"],
        ["\xB1\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x7D"],
        ["\xB1\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x7E"],
        ["\xB1\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x80"],
        ["\xB1\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x81"],
        ["\xB1\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x82"],
        ["\xB1\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x83"],
        ["\xB1\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x84"],
        ["\xB1\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x85"],
        ["\xB1\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x86"],
        ["\xB1\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x87"],
        ["\xB1\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x88"],
        ["\xB1\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x89"],
        ["\xB1\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x8A"],
        ["\xB1\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x8B"],
        ["\xB1\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x8C"],
        ["\xB1\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x8D"],
        ["\xB1\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x8E"],
        ["\xB1\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x8F"],
        ["\xB1\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x90"],
        ["\xB1\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x91"],
        ["\xB1\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x92"],
        ["\xB1\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x93"],
        ["\xB1\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x94"],
        ["\xB1\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x95"],
        ["\xB1\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x96"],
        ["\xB1\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x97"],
        ["\xB1\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x98"],
        ["\xB1\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x99"],
        ["\xB1\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x9A"],
        ["\xB1\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x9B"],
        ["\xB1\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x9C"],
        ["\xB1\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x9D"],
        ["\xB1\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x9E"],
        ["\xB2\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\x9F"],
        ["\xB2\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xA0"],
        ["\xB2\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xA1"],
        ["\xB2\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xA2"],
        ["\xB2\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xA3"],
        ["\xB2\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xA4"],
        ["\xB2\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xA5"],
        ["\xB2\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xA6"],
        ["\xF2\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xA7"],
        ["\xB2\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xA8"],
        ["\xB2\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xA9"],
        ["\xB2\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xAA"],
        ["\xB2\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xAB"],
        ["\xB2\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xAC"],
        ["\xB2\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xAD"],
        ["\xB2\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xAE"],
        ["\xB2\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xAF"],
        ["\xB2\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xB0"],
        ["\xB2\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xB1"],
        ["\xB2\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xB2"],
        ["\xB2\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xB3"],
        ["\xB2\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xB4"],
        ["\xB2\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xB5"],
        ["\xB2\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xB6"],
        ["\xB2\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xB7"],
        ["\xB2\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xB8"],
        ["\xB2\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xB9"],
        ["\xB2\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xBA"],
        ["\xB2\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xBB"],
        ["\xB2\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xBC"],
        ["\xB2\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xBD"],
        ["\xB2\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xBE"],
        ["\xB2\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xBF"],
        ["\xB2\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xC0"],
        ["\xB2\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xC1"],
        ["\xB2\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xC2"],
        ["\xB2\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xC3"],
        ["\xB2\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xC4"],
        ["\xB2\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xC5"],
        ["\xB2\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xC6"],
        ["\xB2\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xC7"],
        ["\xB2\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xC8"],
        ["\xB2\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xC9"],
        ["\xB2\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xCA"],
        ["\xB2\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xCB"],
        ["\xB2\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xCC"],
        ["\xB2\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xCD"],
        ["\xB2\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xCE"],
        ["\xB2\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xCF"],
        ["\xB2\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xD0"],
        ["\xB2\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xD1"],
        ["\xB2\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xD2"],
        ["\xB2\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xD3"],
        ["\xB2\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xD4"],
        ["\xB2\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xD5"],
        ["\xB2\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xD6"],
        ["\xB2\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xD7"],
        ["\xB2\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xD8"],
        ["\xB2\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xD9"],
        ["\xB2\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xDA"],
        ["\xB2\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xDB"],
        ["\xB2\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xDC"],
        ["\xB2\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xDD"],
        ["\xB2\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xDE"],
        ["\xB2\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xDF"],
        ["\xB2\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xE0"],
        ["\xB2\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xE1"],
        ["\xB2\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xE2"],
        ["\xB2\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xE3"],
        ["\xB2\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xE4"],
        ["\xB2\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xE5"],
        ["\xB2\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xE6"],
        ["\xB2\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xE7"],
        ["\xB2\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xE8"],
        ["\xB2\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xE9"],
        ["\xB2\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xEA"],
        ["\xB2\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xEB"],
        ["\xB2\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xEC"],
        ["\xB2\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xED"],
        ["\xB2\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xEE"],
        ["\xB2\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xEF"],
        ["\xB2\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xF0"],
        ["\xB2\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xF1"],
        ["\xB2\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xF2"],
        ["\xB2\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xF3"],
        ["\xB2\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xF4"],
        ["\xB2\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xF5"],
        ["\xB2\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xF6"],
        ["\xB2\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xF7"],
        ["\xB2\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xF8"],
        ["\xB2\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xF9"],
        ["\xB2\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xFA"],
        ["\xB2\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xFB"],
        ["\xB2\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x89\xFC"],
        ["\xB3\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x40"],
        ["\xB3\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x41"],
        ["\xB3\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x42"],
        ["\xB3\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x43"],
        ["\xB3\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x44"],
        ["\xB3\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x45"],
        ["\xB3\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x46"],
        ["\xB3\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x47"],
        ["\xB3\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x48"],
        ["\xB3\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x49"],
        ["\xB3\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x4A"],
        ["\xB3\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x4B"],
        ["\xB3\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x4C"],
        ["\xB3\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x4D"],
        ["\xB3\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x4E"],
        ["\xB3\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x4F"],
        ["\xB3\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x50"],
        ["\xB3\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x51"],
        ["\xB3\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x52"],
        ["\xB3\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x53"],
        ["\xB3\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x54"],
        ["\xB3\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x55"],
        ["\xB3\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x56"],
        ["\xB3\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x57"],
        ["\xB3\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x58"],
        ["\xB3\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x59"],
        ["\xB3\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x5A"],
        ["\xB3\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x5B"],
        ["\xB3\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x5C"],
        ["\xB3\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x5D"],
        ["\xB3\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x5E"],
        ["\xB3\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x5F"],
        ["\xB3\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x60"],
        ["\xE9\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x61"],
        ["\xB3\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x62"],
        ["\xB3\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x63"],
        ["\xB3\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x64"],
        ["\xB3\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x65"],
        ["\xB3\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x66"],
        ["\xB3\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x67"],
        ["\xD9\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x68"],
        ["\xB3\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x69"],
        ["\xB3\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x6A"],
        ["\xB3\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x6B"],
        ["\xB3\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x6C"],
        ["\xB3\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x6D"],
        ["\xB3\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x6E"],
        ["\xB3\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x6F"],
        ["\xB3\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x70"],
        ["\xB3\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x71"],
        ["\xB3\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x72"],
        ["\xB3\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x73"],
        ["\xB3\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x74"],
        ["\xB3\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x75"],
        ["\xB3\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x76"],
        ["\xB3\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x77"],
        ["\xB3\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x78"],
        ["\xB3\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x79"],
        ["\xB3\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x7A"],
        ["\xB3\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x7B"],
        ["\xB3\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x7C"],
        ["\xB3\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x7D"],
        ["\xB3\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x7E"],
        ["\xB3\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x80"],
        ["\xB3\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x81"],
        ["\xB3\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x82"],
        ["\xB3\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x83"],
        ["\xB3\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x84"],
        ["\xB3\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x85"],
        ["\xB3\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x86"],
        ["\xB3\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x87"],
        ["\xB3\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x88"],
        ["\xB3\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x89"],
        ["\xB3\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x8A"],
        ["\xB3\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x8B"],
        ["\xB3\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x8C"],
        ["\xB3\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x8D"],
        ["\xB3\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x8E"],
        ["\xB3\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x8F"],
        ["\xB3\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x90"],
        ["\xB3\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x91"],
        ["\xB3\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x92"],
        ["\xB3\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x93"],
        ["\xB3\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x94"],
        ["\xB3\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x95"],
        ["\xE3\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x96"],
        ["\xB3\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x97"],
        ["\xB3\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x98"],
        ["\xB3\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x99"],
        ["\xB3\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x9A"],
        ["\xB3\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x9B"],
        ["\xB3\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x9C"],
        ["\xB3\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x9D"],
        ["\xB3\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x9E"],
        ["\xB4\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\x9F"],
        ["\xB4\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xA0"],
        ["\xB4\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xA1"],
        ["\xB4\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xA2"],
        ["\xB4\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xA3"],
        ["\xB4\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xA4"],
        ["\xB4\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xA5"],
        ["\xB4\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xA6"],
        ["\xB4\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xA7"],
        ["\xB4\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xA8"],
        ["\xB4\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xA9"],
        ["\xB4\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xAA"],
        ["\xB4\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xAB"],
        ["\xB4\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xAC"],
        ["\xB4\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xAD"],
        ["\xB4\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xAE"],
        ["\xB4\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xAF"],
        ["\xB4\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xB0"],
        ["\xB4\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xB1"],
        ["\xB4\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xB2"],
        ["\xB4\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xB3"],
        ["\xB4\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xB4"],
        ["\xB4\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xB5"],
        ["\xB4\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xB6"],
        ["\xB4\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xB7"],
        ["\xB4\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xB8"],
        ["\xB4\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xB9"],
        ["\xB4\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xBA"],
        ["\xB4\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xBB"],
        ["\xB4\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xBC"],
        ["\xB4\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xBD"],
        ["\xB4\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xBE"],
        ["\xB4\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xBF"],
        ["\xB4\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xC0"],
        ["\xDE\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xC1"],
        ["\xB4\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xC2"],
        ["\xB4\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xC3"],
        ["\xB4\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xC4"],
        ["\xB4\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xC5"],
        ["\xB4\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xC6"],
        ["\xB4\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xC7"],
        ["\xB4\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xC8"],
        ["\xB4\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xC9"],
        ["\xB4\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xCA"],
        ["\xB4\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xCB"],
        ["\xB4\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xCC"],
        ["\xB4\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xCD"],
        ["\xB4\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xCE"],
        ["\xB4\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xCF"],
        ["\xEB\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xD0"],
        ["\xB4\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xD1"],
        ["\xB4\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xD2"],
        ["\xB4\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xD3"],
        ["\xB4\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xD4"],
        ["\xB4\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xD5"],
        ["\xB4\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xD6"],
        ["\xB4\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xD7"],
        ["\xB4\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xD8"],
        ["\xB4\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xD9"],
        ["\xB4\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xDA"],
        ["\xB4\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xDB"],
        ["\xB4\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xDC"],
        ["\xB4\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xDD"],
        ["\xB4\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xDE"],
        ["\xB4\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xDF"],
        ["\xB4\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xE0"],
        ["\xB4\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xE1"],
        ["\xB4\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xE2"],
        ["\xB4\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xE3"],
        ["\xB4\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xE4"],
        ["\xB4\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xE5"],
        ["\xB4\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xE6"],
        ["\xB4\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xE7"],
        ["\xB4\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xE8"],
        ["\xB4\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xE9"],
        ["\xB4\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xEA"],
        ["\xB4\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xEB"],
        ["\xB4\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xEC"],
        ["\xB4\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xED"],
        ["\xB4\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xEE"],
        ["\xB4\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xEF"],
        ["\xB4\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xF0"],
        ["\xB4\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xF1"],
        ["\xB4\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xF2"],
        ["\xB4\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xF3"],
        ["\xB4\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xF4"],
        ["\xB4\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xF5"],
        ["\xB4\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xF6"],
        ["\xB4\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xF7"],
        ["\xB4\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xF8"],
        ["\xB4\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xF9"],
        ["\xB4\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xFA"],
        ["\xB4\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xFB"],
        ["\xB4\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8A\xFC"],
        ["\xB5\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x40"],
        ["\xB5\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x41"],
        ["\xB5\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x42"],
        ["\xB5\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x43"],
        ["\xB5\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x44"],
        ["\xB5\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x45"],
        ["\xB5\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x46"],
        ["\xB5\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x47"],
        ["\xB5\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x48"],
        ["\xB5\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x49"],
        ["\xB5\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x4A"],
        ["\xB5\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x4B"],
        ["\xB5\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x4C"],
        ["\xB5\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x4D"],
        ["\xB5\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x4E"],
        ["\xB5\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x4F"],
        ["\xB5\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x50"],
        ["\xB5\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x51"],
        ["\xB5\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x52"],
        ["\xB5\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x53"],
        ["\xB5\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x54"],
        ["\xB5\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x55"],
        ["\xB5\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x56"],
        ["\xB5\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x57"],
        ["\xB5\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x58"],
        ["\xB5\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x59"],
        ["\xB5\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x5A"],
        ["\xB5\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x5B"],
        ["\xB5\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x5C"],
        ["\xB5\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x5D"],
        ["\xB5\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x5E"],
        ["\xB5\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x5F"],
        ["\xB5\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x60"],
        ["\xB5\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x61"],
        ["\xB5\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x62"],
        ["\xB5\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x63"],
        ["\xB5\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x64"],
        ["\xB5\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x65"],
        ["\xB5\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x66"],
        ["\xB5\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x67"],
        ["\xB5\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x68"],
        ["\xB5\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x69"],
        ["\xB5\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x6A"],
        ["\xB5\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x6B"],
        ["\xB5\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x6C"],
        ["\xB5\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x6D"],
        ["\xB5\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x6E"],
        ["\xB5\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x6F"],
        ["\xB5\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x70"],
        ["\xB5\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x71"],
        ["\xB5\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x72"],
        ["\xB5\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x73"],
        ["\xB5\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x74"],
        ["\xB5\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x75"],
        ["\xB5\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x76"],
        ["\xB5\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x77"],
        ["\xB5\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x78"],
        ["\xB5\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x79"],
        ["\xB5\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x7A"],
        ["\xB5\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x7B"],
        ["\xB5\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x7C"],
        ["\xB5\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x7D"],
        ["\xB5\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x7E"],
        ["\xB5\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x80"],
        ["\xB5\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x81"],
        ["\xB5\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x82"],
        ["\xB5\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x83"],
        ["\xB5\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x84"],
        ["\xB5\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x85"],
        ["\xB5\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x86"],
        ["\xB5\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x87"],
        ["\xB5\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x88"],
        ["\xB5\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x89"],
        ["\xB5\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x8A"],
        ["\xB5\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x8B"],
        ["\xB5\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x8C"],
        ["\xB5\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x8D"],
        ["\xB5\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x8E"],
        ["\xB5\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x8F"],
        ["\xB5\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x90"],
        ["\xB5\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x91"],
        ["\xB5\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x92"],
        ["\xB5\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x93"],
        ["\xB5\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x94"],
        ["\xB5\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x95"],
        ["\xB5\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x96"],
        ["\xB5\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x97"],
        ["\xB5\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x98"],
        ["\xB5\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x99"],
        ["\xB5\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x9A"],
        ["\xB5\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x9B"],
        ["\xB5\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x9C"],
        ["\xB5\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x9D"],
        ["\xB5\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x9E"],
        ["\xB6\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\x9F"],
        ["\xB6\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xA0"],
        ["\xB6\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xA1"],
        ["\xB6\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xA2"],
        ["\xB6\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xA3"],
        ["\xB6\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xA4"],
        ["\xB6\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xA5"],
        ["\xB6\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xA6"],
        ["\xB6\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xA7"],
        ["\xB6\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xA8"],
        ["\xB6\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xA9"],
        ["\xB6\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xAA"],
        ["\xB6\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xAB"],
        ["\xB6\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xAC"],
        ["\xB6\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xAD"],
        ["\xB6\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xAE"],
        ["\xB6\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xAF"],
        ["\xB6\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xB0"],
        ["\xB6\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xB1"],
        ["\xB6\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xB2"],
        ["\xB6\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xB3"],
        ["\xB6\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xB4"],
        ["\xB6\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xB5"],
        ["\xB6\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xB6"],
        ["\xB6\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xB7"],
        ["\xB6\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xB8"],
        ["\xB6\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xB9"],
        ["\xB6\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xBA"],
        ["\xB6\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xBB"],
        ["\xB6\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xBC"],
        ["\xB6\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xBD"],
        ["\xB6\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xBE"],
        ["\xB6\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xBF"],
        ["\xB6\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xC0"],
        ["\xB6\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xC1"],
        ["\xB6\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xC2"],
        ["\xB6\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xC3"],
        ["\x47\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xC4"],
        ["\xB6\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xC5"],
        ["\xB6\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xC6"],
        ["\xB6\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xC7"],
        ["\xB6\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xC8"],
        ["\xB6\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xC9"],
        ["\xB6\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xCA"],
        ["\xB6\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xCB"],
        ["\xB6\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xCC"],
        ["\xB6\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xCD"],
        ["\xB6\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xCE"],
        ["\xB6\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xCF"],
        ["\xB6\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xD0"],
        ["\xB6\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xD1"],
        ["\xB6\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xD2"],
        ["\xB6\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xD3"],
        ["\xB6\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xD4"],
        ["\xB6\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xD5"],
        ["\xB6\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xD6"],
        ["\xB6\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xD7"],
        ["\xB6\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xD8"],
        ["\xB6\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xD9"],
        ["\xB6\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xDA"],
        ["\xB6\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xDB"],
        ["\xB6\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xDC"],
        ["\xB6\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xDD"],
        ["\xB6\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xDE"],
        ["\xB6\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xDF"],
        ["\xB6\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xE0"],
        ["\xB6\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xE1"],
        ["\xB6\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xE2"],
        ["\xB6\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xE3"],
        ["\xB6\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xE4"],
        ["\xB6\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xE5"],
        ["\xB6\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xE6"],
        ["\xB6\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xE7"],
        ["\xB6\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xE8"],
        ["\xB6\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xE9"],
        ["\xB6\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xEA"],
        ["\xB6\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xEB"],
        ["\xB6\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xEC"],
        ["\xB6\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xED"],
        ["\xB6\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xEE"],
        ["\xB6\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xEF"],
        ["\xB6\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xF0"],
        ["\xB6\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xF1"],
        ["\xB6\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xF2"],
        ["\xB6\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xF3"],
        ["\xB6\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xF4"],
        ["\xB6\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xF5"],
        ["\xB6\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xF6"],
        ["\xB6\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xF7"],
        ["\xB6\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xF8"],
        ["\xB6\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xF9"],
        ["\xB6\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xFA"],
        ["\xB6\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xFB"],
        ["\xB6\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8B\xFC"],
        ["\xB7\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x40"],
        ["\xB7\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x41"],
        ["\xB7\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x42"],
        ["\xB7\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x43"],
        ["\xB7\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x44"],
        ["\xB7\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x45"],
        ["\xB7\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x46"],
        ["\xB7\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x47"],
        ["\xB7\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x48"],
        ["\xB7\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x49"],
        ["\xB7\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x4A"],
        ["\xB7\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x4B"],
        ["\xB7\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x4C"],
        ["\xB7\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x4D"],
        ["\xB7\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x4E"],
        ["\xB7\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x4F"],
        ["\xB7\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x50"],
        ["\xB7\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x51"],
        ["\xB7\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x52"],
        ["\xB7\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x53"],
        ["\xB7\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x54"],
        ["\xB7\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x55"],
        ["\xB7\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x56"],
        ["\xB7\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x57"],
        ["\xB7\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x58"],
        ["\xB7\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x59"],
        ["\xB7\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x5A"],
        ["\xB7\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x5B"],
        ["\xB7\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x5C"],
        ["\xB7\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x5D"],
        ["\xB7\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x5E"],
        ["\xB7\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x5F"],
        ["\xB7\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x60"],
        ["\xB7\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x61"],
        ["\xB7\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x62"],
        ["\xB7\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x63"],
        ["\xB7\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x64"],
        ["\xB7\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x65"],
        ["\xB7\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x66"],
        ["\xB7\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x67"],
        ["\xB7\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x68"],
        ["\xB7\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x69"],
        ["\xB7\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x6A"],
        ["\xB7\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x6B"],
        ["\xB7\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x6C"],
        ["\xB7\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x6D"],
        ["\xB7\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x6E"],
        ["\xB7\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x6F"],
        ["\xB7\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x70"],
        ["\xB7\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x71"],
        ["\xB7\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x72"],
        ["\xB7\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x73"],
        ["\xB7\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x74"],
        ["\xB7\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x75"],
        ["\xB7\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x76"],
        ["\xB7\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x77"],
        ["\xB7\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x78"],
        ["\xB7\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x79"],
        ["\xF0\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x7A"],
        ["\xB7\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x7B"],
        ["\xB7\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x7C"],
        ["\xB7\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x7D"],
        ["\xB7\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x7E"],
        ["\xB7\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x80"],
        ["\xB7\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x81"],
        ["\xB7\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x82"],
        ["\xB7\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x83"],
        ["\xB7\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x84"],
        ["\xB7\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x85"],
        ["\xB7\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x86"],
        ["\xB7\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x87"],
        ["\xB7\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x88"],
        ["\xB7\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x89"],
        ["\xB7\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x8A"],
        ["\xB7\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x8B"],
        ["\xB7\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x8C"],
        ["\xB7\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x8D"],
        ["\xB7\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x8E"],
        ["\xB7\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x8F"],
        ["\xB7\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x90"],
        ["\xB7\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x91"],
        ["\xB7\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x92"],
        ["\xB7\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x93"],
        ["\xB7\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x94"],
        ["\xB7\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x95"],
        ["\xB7\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x96"],
        ["\xB7\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x97"],
        ["\xB7\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x98"],
        ["\xB7\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x99"],
        ["\xB7\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x9A"],
        ["\xB7\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x9B"],
        ["\xB7\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x9C"],
        ["\xB7\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x9D"],
        ["\xB7\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x9E"],
        ["\xB8\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\x9F"],
        ["\xB8\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xA0"],
        ["\xB8\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xA1"],
        ["\xB8\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xA2"],
        ["\xB8\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xA3"],
        ["\xB8\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xA4"],
        ["\xB8\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xA5"],
        ["\xB8\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xA6"],
        ["\xB8\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xA7"],
        ["\xB8\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xA8"],
        ["\xB8\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xA9"],
        ["\xB8\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xAA"],
        ["\xB8\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xAB"],
        ["\xB8\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xAC"],
        ["\xB8\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xAD"],
        ["\xB8\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xAE"],
        ["\xB8\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xAF"],
        ["\xB8\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xB0"],
        ["\xB8\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xB1"],
        ["\xB8\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xB2"],
        ["\xB8\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xB3"],
        ["\xB8\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xB4"],
        ["\xB8\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xB5"],
        ["\xB8\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xB6"],
        ["\xB8\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xB7"],
        ["\xB8\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xB8"],
        ["\xB8\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xB9"],
        ["\xB8\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xBA"],
        ["\xB8\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xBB"],
        ["\xB8\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xBC"],
        ["\xB8\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xBD"],
        ["\xB8\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xBE"],
        ["\xB8\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xBF"],
        ["\xB8\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xC0"],
        ["\xB8\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xC1"],
        ["\xB8\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xC2"],
        ["\xB8\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xC3"],
        ["\xB8\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xC4"],
        ["\xB8\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xC5"],
        ["\xB8\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xC6"],
        ["\xB8\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xC7"],
        ["\xB8\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xC8"],
        ["\xB8\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xC9"],
        ["\xB8\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xCA"],
        ["\xB8\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xCB"],
        ["\xB8\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xCC"],
        ["\xB8\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xCD"],
        ["\xB8\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xCE"],
        ["\xB8\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xCF"],
        ["\xB8\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xD0"],
        ["\xB8\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xD1"],
        ["\xB8\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xD2"],
        ["\xB8\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xD3"],
        ["\xB8\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xD4"],
        ["\xB8\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xD5"],
        ["\xB8\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xD6"],
        ["\xB8\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xD7"],
        ["\xB8\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xD8"],
        ["\xB8\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xD9"],
        ["\xB8\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xDA"],
        ["\xB8\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xDB"],
        ["\xB8\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xDC"],
        ["\xB8\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xDD"],
        ["\xB8\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xDE"],
        ["\xB8\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xDF"],
        ["\xB8\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xE0"],
        ["\xB8\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xE1"],
        ["\xB8\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xE2"],
        ["\xB8\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xE3"],
        ["\xB8\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xE4"],
        ["\xB8\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xE5"],
        ["\xB8\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xE6"],
        ["\xB8\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xE7"],
        ["\xB8\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xE8"],
        ["\xB8\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xE9"],
        ["\xB8\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xEA"],
        ["\xB8\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xEB"],
        ["\xB8\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xEC"],
        ["\xB8\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xED"],
        ["\xB8\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xEE"],
        ["\xB8\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xEF"],
        ["\xB8\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xF0"],
        ["\xB8\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xF1"],
        ["\xB8\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xF2"],
        ["\xB8\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xF3"],
        ["\xB8\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xF4"],
        ["\xB8\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xF5"],
        ["\xB8\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xF6"],
        ["\xB8\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xF7"],
        ["\xB8\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xF8"],
        ["\xB8\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xF9"],
        ["\xB8\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xFA"],
        ["\xB8\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xFB"],
        ["\xB8\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8C\xFC"],
        ["\xB9\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x40"],
        ["\xB9\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x41"],
        ["\xB9\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x42"],
        ["\xB9\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x43"],
        ["\xB9\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x44"],
        ["\xB9\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x45"],
        ["\xB9\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x46"],
        ["\xB9\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x47"],
        ["\xB9\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x48"],
        ["\xB9\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x49"],
        ["\xB9\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x4A"],
        ["\xB9\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x4B"],
        ["\xB9\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x4C"],
        ["\xB9\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x4D"],
        ["\xB9\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x4E"],
        ["\xB9\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x4F"],
        ["\xB9\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x50"],
        ["\xB9\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x51"],
        ["\xB9\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x52"],
        ["\xB9\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x53"],
        ["\xB9\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x54"],
        ["\xB9\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x55"],
        ["\x50\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x56"],
        ["\xB9\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x57"],
        ["\xB9\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x58"],
        ["\xB9\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x59"],
        ["\xB9\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x5A"],
        ["\xB9\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x5B"],
        ["\xB9\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x5C"],
        ["\xB9\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x5D"],
        ["\xB9\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x5E"],
        ["\xB9\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x5F"],
        ["\xB9\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x60"],
        ["\xB9\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x61"],
        ["\xB9\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x62"],
        ["\xB9\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x63"],
        ["\xB9\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x64"],
        ["\xB9\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x65"],
        ["\xB9\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x66"],
        ["\xB9\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x67"],
        ["\xB9\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x68"],
        ["\xB9\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x69"],
        ["\xB9\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x6A"],
        ["\xB9\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x6B"],
        ["\xB9\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x6C"],
        ["\xB9\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x6D"],
        ["\xB9\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x6E"],
        ["\xB9\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x6F"],
        ["\xB9\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x70"],
        ["\xB9\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x71"],
        ["\xB9\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x72"],
        ["\xB9\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x73"],
        ["\xB9\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x74"],
        ["\xB9\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x75"],
        ["\xB9\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x76"],
        ["\xB9\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x77"],
        ["\xB9\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x78"],
        ["\xB9\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x79"],
        ["\xB9\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x7A"],
        ["\xE2\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x7B"],
        ["\xB9\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x7C"],
        ["\xB9\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x7D"],
        ["\xB9\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x7E"],
        ["\xB9\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x80"],
        ["\xB9\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x81"],
        ["\xB9\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x82"],
        ["\xB9\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x83"],
        ["\xB9\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x84"],
        ["\xB9\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x85"],
        ["\xB9\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x86"],
        ["\xB9\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x87"],
        ["\xB9\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x88"],
        ["\xB9\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x89"],
        ["\xB9\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x8A"],
        ["\xB9\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x8B"],
        ["\xB9\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x8C"],
        ["\x6F\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x8D"],
        ["\xB9\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x8E"],
        ["\xB9\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x8F"],
        ["\xB9\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x90"],
        ["\xB9\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x91"],
        ["\xB9\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x92"],
        ["\xB9\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x93"],
        ["\xB9\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x94"],
        ["\xB9\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x95"],
        ["\xB9\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x96"],
        ["\xB9\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x97"],
        ["\xB9\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x98"],
        ["\xB9\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x99"],
        ["\xB9\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x9A"],
        ["\xB9\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x9B"],
        ["\xB9\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x9C"],
        ["\xB9\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x9D"],
        ["\xB9\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x9E"],
        ["\xBA\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\x9F"],
        ["\xBA\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xA0"],
        ["\xBA\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xA1"],
        ["\xBA\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xA2"],
        ["\xBA\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xA3"],
        ["\xBA\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xA4"],
        ["\xBA\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xA5"],
        ["\xBA\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xA6"],
        ["\xBA\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xA7"],
        ["\xBA\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xA8"],
        ["\xBA\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xA9"],
        ["\xBA\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xAA"],
        ["\xBA\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xAB"],
        ["\xBA\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xAC"],
        ["\xBA\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xAD"],
        ["\xBA\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xAE"],
        ["\xBA\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xAF"],
        ["\xBA\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xB0"],
        ["\xBA\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xB1"],
        ["\xBA\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xB2"],
        ["\xBA\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xB3"],
        ["\xBA\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xB4"],
        ["\xBA\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xB5"],
        ["\xBA\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xB6"],
        ["\xBA\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xB7"],
        ["\xBA\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xB8"],
        ["\xBA\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xB9"],
        ["\xBA\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xBA"],
        ["\xBA\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xBB"],
        ["\xBA\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xBC"],
        ["\xBA\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xBD"],
        ["\xBA\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xBE"],
        ["\xBA\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xBF"],
        ["\xBA\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xC0"],
        ["\xBA\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xC1"],
        ["\xBA\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xC2"],
        ["\xBA\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xC3"],
        ["\xBA\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xC4"],
        ["\xBA\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xC5"],
        ["\xBA\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xC6"],
        ["\xBA\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xC7"],
        ["\xBA\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xC8"],
        ["\xBA\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xC9"],
        ["\xBA\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xCA"],
        ["\xBA\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xCB"],
        ["\xBA\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xCC"],
        ["\xBA\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xCD"],
        ["\xBA\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xCE"],
        ["\xBA\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xCF"],
        ["\xBA\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xD0"],
        ["\xBA\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xD1"],
        ["\xBA\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xD2"],
        ["\xBA\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xD3"],
        ["\xBA\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xD4"],
        ["\xBA\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xD5"],
        ["\xBA\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xD6"],
        ["\xBA\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xD7"],
        ["\xBA\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xD8"],
        ["\xBA\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xD9"],
        ["\xBA\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xDA"],
        ["\xBA\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xDB"],
        ["\xBA\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xDC"],
        ["\xBA\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xDD"],
        ["\xBA\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xDE"],
        ["\xBA\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xDF"],
        ["\xBA\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xE0"],
        ["\xBA\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xE1"],
        ["\xBA\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xE2"],
        ["\xBA\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xE3"],
        ["\xBA\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xE4"],
        ["\xBA\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xE5"],
        ["\xBA\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xE6"],
        ["\xBA\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xE7"],
        ["\xBA\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xE8"],
        ["\xBA\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xE9"],
        ["\xBA\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xEA"],
        ["\xBA\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xEB"],
        ["\xBA\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xEC"],
        ["\xBA\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xED"],
        ["\xBA\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xEE"],
        ["\xBA\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xEF"],
        ["\xBA\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xF0"],
        ["\xBA\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xF1"],
        ["\xBA\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xF2"],
        ["\xBA\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xF3"],
        ["\xBA\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xF4"],
        ["\xBA\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xF5"],
        ["\xBA\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xF6"],
        ["\xBA\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xF7"],
        ["\xBA\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xF8"],
        ["\xBA\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xF9"],
        ["\xBA\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xFA"],
        ["\xBA\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xFB"],
        ["\xBA\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8D\xFC"],
        ["\xBB\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x40"],
        ["\xBB\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x41"],
        ["\xBB\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x42"],
        ["\xBB\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x43"],
        ["\xBB\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x44"],
        ["\xBB\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x45"],
        ["\xBB\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x46"],
        ["\xBB\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x47"],
        ["\xBB\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x48"],
        ["\xBB\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x49"],
        ["\xBB\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x4A"],
        ["\xBB\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x4B"],
        ["\xBB\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x4C"],
        ["\xBB\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x4D"],
        ["\xBB\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x4E"],
        ["\xBB\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x4F"],
        ["\xBB\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x50"],
        ["\xBB\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x51"],
        ["\xBB\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x52"],
        ["\xBB\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x53"],
        ["\xBB\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x54"],
        ["\xBB\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x55"],
        ["\xBB\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x56"],
        ["\xBB\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x57"],
        ["\xBB\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x58"],
        ["\xBB\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x59"],
        ["\xBB\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x5A"],
        ["\xBB\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x5B"],
        ["\xBB\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x5C"],
        ["\xBB\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x5D"],
        ["\xBB\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x5E"],
        ["\xBB\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x5F"],
        ["\xBB\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x60"],
        ["\xBB\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x61"],
        ["\xBB\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x62"],
        ["\xBB\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x63"],
        ["\xBB\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x64"],
        ["\xBB\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x65"],
        ["\xBB\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x66"],
        ["\xBB\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x67"],
        ["\xBB\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x68"],
        ["\xBB\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x69"],
        ["\xBB\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x6A"],
        ["\xBB\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x6B"],
        ["\xBB\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x6C"],
        ["\xBB\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x6D"],
        ["\xBB\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x6E"],
        ["\xBB\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x6F"],
        ["\xBB\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x70"],
        ["\xBB\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x71"],
        ["\xBB\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x72"],
        ["\xBB\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x73"],
        ["\xBB\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x74"],
        ["\xBB\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x75"],
        ["\xBB\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x76"],
        ["\xBB\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x77"],
        ["\xBB\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x78"],
        ["\xBB\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x79"],
        ["\xBB\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x7A"],
        ["\xBB\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x7B"],
        ["\xBB\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x7C"],
        ["\xBB\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x7D"],
        ["\xBB\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x7E"],
        ["\xBB\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x80"],
        ["\xBB\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x81"],
        ["\xBB\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x82"],
        ["\xBB\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x83"],
        ["\xBB\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x84"],
        ["\xBB\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x85"],
        ["\xBB\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x86"],
        ["\xBB\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x87"],
        ["\xBB\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x88"],
        ["\xBB\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x89"],
        ["\xBB\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x8A"],
        ["\xBB\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x8B"],
        ["\xBB\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x8C"],
        ["\xBB\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x8D"],
        ["\xBB\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x8E"],
        ["\xBB\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x8F"],
        ["\xBB\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x90"],
        ["\xBB\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x91"],
        ["\xBB\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x92"],
        ["\xBB\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x93"],
        ["\xBB\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x94"],
        ["\xBB\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x95"],
        ["\xBB\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x96"],
        ["\xBB\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x97"],
        ["\xBB\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x98"],
        ["\xBB\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x99"],
        ["\xBB\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x9A"],
        ["\xBB\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x9B"],
        ["\xBB\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x9C"],
        ["\xBB\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x9D"],
        ["\xBB\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x9E"],
        ["\xBC\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\x9F"],
        ["\xBC\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xA0"],
        ["\xBC\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xA1"],
        ["\xBC\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xA2"],
        ["\xBC\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xA3"],
        ["\xBC\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xA4"],
        ["\xBC\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xA5"],
        ["\xBC\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xA6"],
        ["\xBC\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xA7"],
        ["\xBC\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xA8"],
        ["\xBC\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xA9"],
        ["\xBC\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xAA"],
        ["\xBC\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xAB"],
        ["\xBC\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xAC"],
        ["\xBC\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xAD"],
        ["\xBC\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xAE"],
        ["\xBC\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xAF"],
        ["\xBC\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xB0"],
        ["\xBC\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xB1"],
        ["\xBC\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xB2"],
        ["\xBC\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xB3"],
        ["\xBC\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xB4"],
        ["\xBC\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xB5"],
        ["\xBC\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xB6"],
        ["\xBC\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xB7"],
        ["\xBC\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xB8"],
        ["\xBC\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xB9"],
        ["\xBC\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xBA"],
        ["\xBC\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xBB"],
        ["\xBC\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xBC"],
        ["\xBC\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xBD"],
        ["\xBC\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xBE"],
        ["\xBC\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xBF"],
        ["\xBC\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xC0"],
        ["\xBC\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xC1"],
        ["\xBC\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xC2"],
        ["\xBC\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xC3"],
        ["\xBC\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xC4"],
        ["\xBC\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xC5"],
        ["\xBC\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xC6"],
        ["\xE9\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xC7"],
        ["\xBC\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xC8"],
        ["\xBC\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xC9"],
        ["\xBC\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xCA"],
        ["\xBC\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xCB"],
        ["\xBC\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xCC"],
        ["\xBC\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xCD"],
        ["\xBC\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xCE"],
        ["\xBC\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xCF"],
        ["\xBC\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xD0"],
        ["\xBC\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xD1"],
        ["\xBC\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xD2"],
        ["\xBC\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xD3"],
        ["\xBC\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xD4"],
        ["\xBC\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xD5"],
        ["\xBC\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xD6"],
        ["\xBC\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xD7"],
        ["\xBC\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xD8"],
        ["\xBC\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xD9"],
        ["\xBC\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xDA"],
        ["\xBC\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xDB"],
        ["\xBC\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xDC"],
        ["\xBC\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xDD"],
        ["\xBC\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xDE"],
        ["\xBC\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xDF"],
        ["\xBC\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xE0"],
        ["\xBC\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xE1"],
        ["\xBC\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xE2"],
        ["\xBC\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xE3"],
        ["\xBC\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xE4"],
        ["\xBC\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xE5"],
        ["\xBC\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xE6"],
        ["\xBC\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xE7"],
        ["\xBC\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xE8"],
        ["\xBC\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xE9"],
        ["\xBC\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xEA"],
        ["\xBC\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xEB"],
        ["\xBC\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xEC"],
        ["\xBC\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xED"],
        ["\xBC\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xEE"],
        ["\xBC\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xEF"],
        ["\xBC\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xF0"],
        ["\xBC\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xF1"],
        ["\xBC\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xF2"],
        ["\xBC\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xF3"],
        ["\xBC\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xF4"],
        ["\xBC\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xF5"],
        ["\xBC\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xF6"],
        ["\xBC\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xF7"],
        ["\xBC\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xF8"],
        ["\xBC\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xF9"],
        ["\xBC\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xFA"],
        ["\xBC\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xFB"],
        ["\xBC\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8E\xFC"],
        ["\xBD\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x40"],
        ["\xBD\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x41"],
        ["\xBD\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x42"],
        ["\xBD\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x43"],
        ["\xBD\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x44"],
        ["\xBD\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x45"],
        ["\xBD\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x46"],
        ["\xBD\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x47"],
        ["\xBD\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x48"],
        ["\xBD\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x49"],
        ["\xBD\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x4A"],
        ["\xBD\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x4B"],
        ["\xBD\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x4C"],
        ["\xBD\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x4D"],
        ["\xBD\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x4E"],
        ["\xBD\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x4F"],
        ["\xBD\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x50"],
        ["\xBD\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x51"],
        ["\xBD\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x52"],
        ["\xBD\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x53"],
        ["\xBD\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x54"],
        ["\xBD\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x55"],
        ["\xBD\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x56"],
        ["\xBD\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x57"],
        ["\xBD\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x58"],
        ["\xBD\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x59"],
        ["\xBD\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x5A"],
        ["\xBD\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x5B"],
        ["\xBD\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x5C"],
        ["\xBD\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x5D"],
        ["\xBD\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x5E"],
        ["\xBD\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x5F"],
        ["\xBD\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x60"],
        ["\xBD\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x61"],
        ["\xBD\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x62"],
        ["\xBD\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x63"],
        ["\xBD\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x64"],
        ["\xBD\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x65"],
        ["\xBD\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x66"],
        ["\xBD\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x67"],
        ["\xBD\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x68"],
        ["\xBD\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x69"],
        ["\xBD\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x6A"],
        ["\xBD\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x6B"],
        ["\xBD\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x6C"],
        ["\xBD\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x6D"],
        ["\xBD\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x6E"],
        ["\xBD\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x6F"],
        ["\xBD\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x70"],
        ["\xBD\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x71"],
        ["\xBD\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x72"],
        ["\xBD\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x73"],
        ["\xBD\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x74"],
        ["\xBD\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x75"],
        ["\xBD\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x76"],
        ["\xBD\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x77"],
        ["\xBD\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x78"],
        ["\xBD\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x79"],
        ["\xBD\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x7A"],
        ["\xBD\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x7B"],
        ["\xBD\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x7C"],
        ["\xBD\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x7D"],
        ["\xBD\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x7E"],
        ["\xBD\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x80"],
        ["\xBD\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x81"],
        ["\xBD\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x82"],
        ["\xBD\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x83"],
        ["\xBD\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x84"],
        ["\xBD\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x85"],
        ["\xBD\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x86"],
        ["\xBD\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x87"],
        ["\xBD\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x88"],
        ["\xBD\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x89"],
        ["\xBD\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x8A"],
        ["\xBD\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x8B"],
        ["\xBD\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x8C"],
        ["\xBD\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x8D"],
        ["\xBD\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x8E"],
        ["\xBD\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x8F"],
        ["\xBD\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x90"],
        ["\xBD\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x91"],
        ["\xBD\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x92"],
        ["\xBD\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x93"],
        ["\xBD\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x94"],
        ["\xBD\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x95"],
        ["\xBD\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x96"],
        ["\xBD\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x97"],
        ["\xBD\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x98"],
        ["\xBD\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x99"],
        ["\xBD\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x9A"],
        ["\xBD\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x9B"],
        ["\xBD\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x9C"],
        ["\xBD\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x9D"],
        ["\xBD\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x9E"],
        ["\xBE\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\x9F"],
        ["\xBE\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xA0"],
        ["\xBE\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xA1"],
        ["\xBE\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xA2"],
        ["\xBE\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xA3"],
        ["\xBE\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xA4"],
        ["\xBE\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xA5"],
        ["\xBE\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xA6"],
        ["\xBE\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xA7"],
        ["\xBE\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xA8"],
        ["\xBE\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xA9"],
        ["\xBE\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xAA"],
        ["\xBE\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xAB"],
        ["\xBE\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xAC"],
        ["\xBE\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xAD"],
        ["\xBE\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xAE"],
        ["\xBE\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xAF"],
        ["\xBE\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xB0"],
        ["\xBE\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xB1"],
        ["\xBE\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xB2"],
        ["\xBE\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xB3"],
        ["\xBE\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xB4"],
        ["\xBE\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xB5"],
        ["\xBE\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xB6"],
        ["\xBE\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xB7"],
        ["\xBE\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xB8"],
        ["\xBE\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xB9"],
        ["\xBE\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xBA"],
        ["\xBE\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xBB"],
        ["\xBE\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xBC"],
        ["\xBE\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xBD"],
        ["\xBE\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xBE"],
        ["\xBE\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xBF"],
        ["\xBE\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xC0"],
        ["\xBE\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xC1"],
        ["\xBE\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xC2"],
        ["\xBE\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xC3"],
        ["\xBE\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xC4"],
        ["\xBE\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xC5"],
        ["\xBE\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xC6"],
        ["\xBE\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xC7"],
        ["\xBE\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xC8"],
        ["\xBE\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xC9"],
        ["\xBE\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xCA"],
        ["\xBE\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xCB"],
        ["\xBE\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xCC"],
        ["\xBE\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xCD"],
        ["\xBE\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xCE"],
        ["\xBE\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xCF"],
        ["\xBE\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xD0"],
        ["\xBE\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xD1"],
        ["\xBE\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xD2"],
        ["\xBE\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xD3"],
        ["\xBE\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xD4"],
        ["\xBE\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xD5"],
        ["\xBE\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xD6"],
        ["\xBE\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xD7"],
        ["\xBE\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xD8"],
        ["\xBE\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xD9"],
        ["\xBE\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xDA"],
        ["\xBE\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xDB"],
        ["\xBE\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xDC"],
        ["\xBE\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xDD"],
        ["\xBE\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xDE"],
        ["\xBE\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xDF"],
        ["\xBE\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xE0"],
        ["\xBE\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xE1"],
        ["\xBE\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xE2"],
        ["\xBE\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xE3"],
        ["\xBE\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xE4"],
        ["\xBE\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xE5"],
        ["\xBE\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xE6"],
        ["\xBE\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xE7"],
        ["\xBE\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xE8"],
        ["\xBE\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xE9"],
        ["\xBE\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xEA"],
        ["\xBE\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xEB"],
        ["\xBE\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xEC"],
        ["\xBE\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xED"],
        ["\xBE\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xEE"],
        ["\xBE\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xEF"],
        ["\xBE\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xF0"],
        ["\xBE\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xF1"],
        ["\xBE\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xF2"],
        ["\xBE\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xF3"],
        ["\xBE\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xF4"],
        ["\xBE\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xF5"],
        ["\xBE\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xF6"],
        ["\xBE\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xF7"],
        ["\xBE\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xF8"],
        ["\xBE\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xF9"],
        ["\xBE\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xFA"],
        ["\xBE\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xFB"],
        ["\xBE\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x8F\xFC"],
        ["\xBF\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x40"],
        ["\xBF\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x41"],
        ["\xBF\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x42"],
        ["\xBF\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x43"],
        ["\xBF\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x44"],
        ["\xBF\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x45"],
        ["\xBF\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x46"],
        ["\xBF\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x47"],
        ["\xBF\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x48"],
        ["\xBF\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x49"],
        ["\xBF\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x4A"],
        ["\xBF\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x4B"],
        ["\xBF\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x4C"],
        ["\xBF\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x4D"],
        ["\xBF\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x4E"],
        ["\xBF\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x4F"],
        ["\xBF\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x50"],
        ["\xBF\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x51"],
        ["\xBF\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x52"],
        ["\xBF\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x53"],
        ["\xBF\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x54"],
        ["\xBF\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x55"],
        ["\xBF\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x56"],
        ["\xBF\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x57"],
        ["\xBF\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x58"],
        ["\xBF\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x59"],
        ["\xBF\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x5A"],
        ["\xBF\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x5B"],
        ["\xBF\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x5C"],
        ["\xBF\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x5D"],
        ["\xBF\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x5E"],
        ["\xBF\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x5F"],
        ["\xBF\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x60"],
        ["\xBF\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x61"],
        ["\xBF\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x62"],
        ["\xBF\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x63"],
        ["\xBF\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x64"],
        ["\xBF\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x65"],
        ["\xBF\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x66"],
        ["\xBF\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x67"],
        ["\xBF\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x68"],
        ["\xBF\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x69"],
        ["\xBF\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x6A"],
        ["\xBF\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x6B"],
        ["\xBF\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x6C"],
        ["\xBF\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x6D"],
        ["\xBF\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x6E"],
        ["\xBF\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x6F"],
        ["\xBF\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x70"],
        ["\xBF\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x71"],
        ["\xBF\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x72"],
        ["\xBF\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x73"],
        ["\xBF\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x74"],
        ["\xBF\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x75"],
        ["\xBF\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x76"],
        ["\xBF\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x77"],
        ["\xF0\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x78"],
        ["\xBF\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x79"],
        ["\xBF\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x7A"],
        ["\xBF\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x7B"],
        ["\xBF\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x7C"],
        ["\xBF\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x7D"],
        ["\xBF\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x7E"],
        ["\xBF\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x80"],
        ["\xBF\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x81"],
        ["\xBF\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x82"],
        ["\xBF\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x83"],
        ["\xBF\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x84"],
        ["\xBF\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x85"],
        ["\xBF\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x86"],
        ["\xBF\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x87"],
        ["\xBF\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x88"],
        ["\xBF\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x89"],
        ["\xBF\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x8A"],
        ["\xBF\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x8B"],
        ["\xBF\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x8C"],
        ["\xBF\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x8D"],
        ["\xBF\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x8E"],
        ["\xBF\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x8F"],
        ["\xBF\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x90"],
        ["\xBF\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x91"],
        ["\xBF\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x92"],
        ["\xBF\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x93"],
        ["\xBF\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x94"],
        ["\xBF\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x95"],
        ["\xBF\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x96"],
        ["\xBF\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x97"],
        ["\xBF\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x98"],
        ["\xBF\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x99"],
        ["\xBF\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x9A"],
        ["\xBF\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x9B"],
        ["\xBF\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x9C"],
        ["\xBF\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x9D"],
        ["\xBF\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x9E"],
        ["\xC0\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\x9F"],
        ["\xC0\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xA0"],
        ["\xC0\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xA1"],
        ["\xC0\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xA2"],
        ["\xC0\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xA3"],
        ["\xC0\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xA4"],
        ["\xC0\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xA5"],
        ["\xC0\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xA6"],
        ["\xC0\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xA7"],
        ["\xC0\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xA8"],
        ["\xC0\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xA9"],
        ["\xC0\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xAA"],
        ["\xC0\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xAB"],
        ["\xC0\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xAC"],
        ["\xC0\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xAD"],
        ["\xC0\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xAE"],
        ["\xC0\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xAF"],
        ["\xC0\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xB0"],
        ["\xC0\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xB1"],
        ["\xC0\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xB2"],
        ["\xC0\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xB3"],
        ["\xC0\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xB4"],
        ["\xC0\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xB5"],
        ["\xC0\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xB6"],
        ["\xC0\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xB7"],
        ["\xC0\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xB8"],
        ["\xC0\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xB9"],
        ["\xC0\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xBA"],
        ["\xC0\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xBB"],
        ["\xC0\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xBC"],
        ["\xC0\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xBD"],
        ["\xC0\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xBE"],
        ["\xC0\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xBF"],
        ["\xC0\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xC0"],
        ["\xC0\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xC1"],
        ["\xC0\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xC2"],
        ["\xC0\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xC3"],
        ["\xC0\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xC4"],
        ["\xC0\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xC5"],
        ["\xC0\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xC6"],
        ["\xC0\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xC7"],
        ["\xC0\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xC8"],
        ["\xC0\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xC9"],
        ["\xC0\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xCA"],
        ["\xC0\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xCB"],
        ["\xC0\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xCC"],
        ["\xC0\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xCD"],
        ["\xC0\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xCE"],
        ["\xC0\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xCF"],
        ["\xC0\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xD0"],
        ["\xC0\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xD1"],
        ["\xC0\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xD2"],
        ["\xC0\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xD3"],
        ["\xC0\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xD4"],
        ["\xC0\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xD5"],
        ["\xC0\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xD6"],
        ["\xC0\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xD7"],
        ["\xC0\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xD8"],
        ["\xC0\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xD9"],
        ["\xC0\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xDA"],
        ["\xC0\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xDB"],
        ["\xC0\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xDC"],
        ["\xC0\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xDD"],
        ["\xC0\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xDE"],
        ["\xC0\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xDF"],
        ["\xC0\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xE0"],
        ["\xC0\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xE1"],
        ["\xC0\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xE2"],
        ["\xC0\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xE3"],
        ["\xC0\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xE4"],
        ["\xC0\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xE5"],
        ["\xC0\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xE6"],
        ["\xC0\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xE7"],
        ["\xC0\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xE8"],
        ["\xC0\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xE9"],
        ["\xC0\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xEA"],
        ["\xC0\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xEB"],
        ["\xC0\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xEC"],
        ["\xC0\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xED"],
        ["\xC0\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xEE"],
        ["\xC0\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xEF"],
        ["\xC0\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xF0"],
        ["\xC0\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xF1"],
        ["\xC0\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xF2"],
        ["\xC0\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xF3"],
        ["\xC0\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xF4"],
        ["\xC0\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xF5"],
        ["\xC0\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xF6"],
        ["\xC0\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xF7"],
        ["\xC0\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xF8"],
        ["\xC0\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xF9"],
        ["\xC0\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xFA"],
        ["\xC0\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xFB"],
        ["\xC0\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x90\xFC"],
        ["\xC1\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x40"],
        ["\xC1\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x41"],
        ["\xC1\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x42"],
        ["\xC1\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x43"],
        ["\xC1\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x44"],
        ["\xC1\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x45"],
        ["\xC1\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x46"],
        ["\xEC\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x47"],
        ["\xC1\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x48"],
        ["\xC1\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x49"],
        ["\xC1\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x4A"],
        ["\xC1\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x4B"],
        ["\xC1\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x4C"],
        ["\xC1\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x4D"],
        ["\xC1\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x4E"],
        ["\xC1\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x4F"],
        ["\xC1\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x50"],
        ["\xC1\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x51"],
        ["\xC1\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x52"],
        ["\xC1\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x53"],
        ["\xC1\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x54"],
        ["\xC1\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x55"],
        ["\xC1\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x56"],
        ["\xC1\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x57"],
        ["\xC1\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x58"],
        ["\xC1\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x59"],
        ["\xC1\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x5A"],
        ["\xC1\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x5B"],
        ["\xC1\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x5C"],
        ["\xC1\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x5D"],
        ["\xC1\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x5E"],
        ["\xC1\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x5F"],
        ["\xC1\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x60"],
        ["\xC1\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x61"],
        ["\xC1\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x62"],
        ["\xC1\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x63"],
        ["\xC1\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x64"],
        ["\xC1\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x65"],
        ["\xC1\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x66"],
        ["\xC1\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x67"],
        ["\xC1\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x68"],
        ["\xC1\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x69"],
        ["\xC1\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x6A"],
        ["\xC1\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x6B"],
        ["\xC1\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x6C"],
        ["\xC1\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x6D"],
        ["\xC1\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x6E"],
        ["\xC1\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x6F"],
        ["\xC1\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x70"],
        ["\xC1\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x71"],
        ["\xC1\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x72"],
        ["\xC1\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x73"],
        ["\xC1\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x74"],
        ["\xC1\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x75"],
        ["\xC1\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x76"],
        ["\xC1\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x77"],
        ["\xC1\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x78"],
        ["\xC1\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x79"],
        ["\xC1\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x7A"],
        ["\xC1\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x7B"],
        ["\xC1\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x7C"],
        ["\xC1\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x7D"],
        ["\xC1\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x7E"],
        ["\xC1\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x80"],
        ["\xC1\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x81"],
        ["\xC1\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x82"],
        ["\xC1\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x83"],
        ["\xC1\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x84"],
        ["\xC1\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x85"],
        ["\xC1\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x86"],
        ["\xC1\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x87"],
        ["\xC1\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x88"],
        ["\xC1\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x89"],
        ["\xC1\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x8A"],
        ["\xC1\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x8B"],
        ["\xC1\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x8C"],
        ["\xC1\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x8D"],
        ["\xC1\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x8E"],
        ["\xC1\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x8F"],
        ["\xC1\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x90"],
        ["\xC1\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x91"],
        ["\xC1\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x92"],
        ["\xC1\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x93"],
        ["\xC1\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x94"],
        ["\xC1\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x95"],
        ["\xC1\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x96"],
        ["\xC1\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x97"],
        ["\xC1\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x98"],
        ["\xC1\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x99"],
        ["\xC1\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x9A"],
        ["\xC1\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x9B"],
        ["\xC1\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x9C"],
        ["\xC1\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x9D"],
        ["\xC1\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x9E"],
        ["\xC2\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\x9F"],
        ["\xC2\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xA0"],
        ["\xC2\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xA1"],
        ["\xC2\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xA2"],
        ["\xC2\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xA3"],
        ["\xC2\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xA4"],
        ["\xC2\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xA5"],
        ["\xC2\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xA6"],
        ["\xC2\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xA7"],
        ["\xC2\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xA8"],
        ["\xC2\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xA9"],
        ["\xC2\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xAA"],
        ["\xC2\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xAB"],
        ["\xC2\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xAC"],
        ["\xC2\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xAD"],
        ["\xC2\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xAE"],
        ["\xC2\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xAF"],
        ["\xC2\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xB0"],
        ["\xC2\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xB1"],
        ["\xC2\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xB2"],
        ["\xC2\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xB3"],
        ["\xC2\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xB4"],
        ["\xC2\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xB5"],
        ["\xC2\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xB6"],
        ["\xC2\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xB7"],
        ["\xC2\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xB8"],
        ["\xC2\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xB9"],
        ["\xC2\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xBA"],
        ["\xC2\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xBB"],
        ["\xC2\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xBC"],
        ["\xC2\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xBD"],
        ["\xC2\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xBE"],
        ["\xC2\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xBF"],
        ["\xC2\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xC0"],
        ["\xC2\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xC1"],
        ["\xC2\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xC2"],
        ["\xC2\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xC3"],
        ["\xC2\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xC4"],
        ["\xC2\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xC5"],
        ["\xC2\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xC6"],
        ["\xC2\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xC7"],
        ["\xC2\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xC8"],
        ["\xC2\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xC9"],
        ["\xC2\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xCA"],
        ["\xC2\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xCB"],
        ["\xC2\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xCC"],
        ["\xC2\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xCD"],
        ["\xC2\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xCE"],
        ["\xC2\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xCF"],
        ["\xC2\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xD0"],
        ["\xC2\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xD1"],
        ["\xC2\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xD2"],
        ["\xC2\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xD3"],
        ["\xC2\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xD4"],
        ["\xC2\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xD5"],
        ["\xC2\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xD6"],
        ["\xC2\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xD7"],
        ["\xC2\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xD8"],
        ["\xC2\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xD9"],
        ["\xC2\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xDA"],
        ["\xC2\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xDB"],
        ["\xC2\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xDC"],
        ["\xC2\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xDD"],
        ["\xC2\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xDE"],
        ["\xC2\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xDF"],
        ["\xC2\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xE0"],
        ["\xC2\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xE1"],
        ["\xC2\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xE2"],
        ["\xC2\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xE3"],
        ["\xC2\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xE4"],
        ["\xC2\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xE5"],
        ["\xC2\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xE6"],
        ["\xC2\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xE7"],
        ["\xC2\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xE8"],
        ["\xC2\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xE9"],
        ["\xC2\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xEA"],
        ["\xC2\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xEB"],
        ["\xC2\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xEC"],
        ["\xC2\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xED"],
        ["\xC2\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xEE"],
        ["\xC2\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xEF"],
        ["\xC2\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xF0"],
        ["\xC2\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xF1"],
        ["\xC2\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xF2"],
        ["\xC2\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xF3"],
        ["\xC2\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xF4"],
        ["\xC2\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xF5"],
        ["\xC2\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xF6"],
        ["\xC2\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xF7"],
        ["\xC2\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xF8"],
        ["\xC2\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xF9"],
        ["\xC2\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xFA"],
        ["\xC2\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xFB"],
        ["\xC2\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x91\xFC"],
        ["\xC3\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x40"],
        ["\xC3\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x41"],
        ["\xC3\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x42"],
        ["\xC3\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x43"],
        ["\xC3\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x44"],
        ["\xC3\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x45"],
        ["\xC3\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x46"],
        ["\xC3\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x47"],
        ["\xC3\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x48"],
        ["\xC3\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x49"],
        ["\xC3\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x4A"],
        ["\xC3\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x4B"],
        ["\xC3\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x4C"],
        ["\xC3\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x4D"],
        ["\xC3\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x4E"],
        ["\xC3\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x4F"],
        ["\xC3\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x50"],
        ["\xC3\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x51"],
        ["\xC3\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x52"],
        ["\xC3\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x53"],
        ["\xC3\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x54"],
        ["\xC3\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x55"],
        ["\xC3\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x56"],
        ["\xC3\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x57"],
        ["\xC3\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x58"],
        ["\xC3\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x59"],
        ["\xC3\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x5A"],
        ["\xC3\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x5B"],
        ["\xC3\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x5C"],
        ["\xC3\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x5D"],
        ["\xC3\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x5E"],
        ["\xC3\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x5F"],
        ["\xC3\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x60"],
        ["\xC3\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x61"],
        ["\xC3\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x62"],
        ["\xC3\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x63"],
        ["\xC3\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x64"],
        ["\xC3\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x65"],
        ["\xC3\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x66"],
        ["\xC3\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x67"],
        ["\xC3\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x68"],
        ["\xC3\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x69"],
        ["\xC3\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x6A"],
        ["\xC3\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x6B"],
        ["\xC3\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x6C"],
        ["\xC3\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x6D"],
        ["\xC3\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x6E"],
        ["\xC3\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x6F"],
        ["\xC3\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x70"],
        ["\xC3\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x71"],
        ["\xC3\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x72"],
        ["\xC3\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x73"],
        ["\xC3\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x74"],
        ["\xC3\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x75"],
        ["\xC3\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x76"],
        ["\xC3\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x77"],
        ["\xC3\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x78"],
        ["\xC3\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x79"],
        ["\xC3\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x7A"],
        ["\xC3\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x7B"],
        ["\xC3\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x7C"],
        ["\xC3\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x7D"],
        ["\xC3\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x7E"],
        ["\xC3\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x80"],
        ["\xC3\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x81"],
        ["\xC3\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x82"],
        ["\xC3\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x83"],
        ["\xC3\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x84"],
        ["\xC3\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x85"],
        ["\xC3\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x86"],
        ["\xC3\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x87"],
        ["\xC3\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x88"],
        ["\xC3\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x89"],
        ["\xC3\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x8A"],
        ["\xC3\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x8B"],
        ["\xC3\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x8C"],
        ["\xC3\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x8D"],
        ["\xC3\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x8E"],
        ["\xC3\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x8F"],
        ["\xC3\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x90"],
        ["\xC3\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x91"],
        ["\xC3\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x92"],
        ["\xC3\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x93"],
        ["\xC3\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x94"],
        ["\xC3\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x95"],
        ["\xC3\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x96"],
        ["\xC3\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x97"],
        ["\xC3\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x98"],
        ["\xC3\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x99"],
        ["\xC3\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x9A"],
        ["\xC3\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x9B"],
        ["\xC3\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x9C"],
        ["\xC3\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x9D"],
        ["\xC3\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x9E"],
        ["\xC4\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\x9F"],
        ["\xC4\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xA0"],
        ["\xC4\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xA1"],
        ["\xC4\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xA2"],
        ["\xC4\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xA3"],
        ["\xC4\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xA4"],
        ["\xC4\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xA5"],
        ["\xC4\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xA6"],
        ["\xC4\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xA7"],
        ["\xC4\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xA8"],
        ["\xC4\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xA9"],
        ["\xC4\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xAA"],
        ["\xC4\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xAB"],
        ["\xC4\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xAC"],
        ["\xC4\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xAD"],
        ["\xC4\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xAE"],
        ["\xC4\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xAF"],
        ["\xC4\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xB0"],
        ["\xC4\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xB1"],
        ["\xC4\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xB2"],
        ["\xC4\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xB3"],
        ["\xC4\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xB4"],
        ["\xC4\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xB5"],
        ["\xC4\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xB6"],
        ["\xC4\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xB7"],
        ["\xC4\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xB8"],
        ["\xC4\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xB9"],
        ["\xC4\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xBA"],
        ["\xC4\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xBB"],
        ["\xC4\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xBC"],
        ["\xC4\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xBD"],
        ["\xC4\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xBE"],
        ["\xC4\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xBF"],
        ["\xC4\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xC0"],
        ["\xC4\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xC1"],
        ["\xC4\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xC2"],
        ["\xC4\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xC3"],
        ["\xC4\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xC4"],
        ["\xC4\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xC5"],
        ["\xC4\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xC6"],
        ["\xC4\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xC7"],
        ["\xC4\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xC8"],
        ["\xC4\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xC9"],
        ["\xC4\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xCA"],
        ["\x47\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xCB"],
        ["\xC4\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xCC"],
        ["\xC4\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xCD"],
        ["\xC4\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xCE"],
        ["\xC4\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xCF"],
        ["\xC4\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xD0"],
        ["\xC4\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xD1"],
        ["\xC4\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xD2"],
        ["\xC4\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xD3"],
        ["\xC4\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xD4"],
        ["\xC4\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xD5"],
        ["\xC4\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xD6"],
        ["\xC4\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xD7"],
        ["\xC4\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xD8"],
        ["\xD4\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xD9"],
        ["\xC4\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xDA"],
        ["\xC4\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xDB"],
        ["\xC4\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xDC"],
        ["\xC4\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xDD"],
        ["\xC4\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xDE"],
        ["\xC4\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xDF"],
        ["\xC4\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xE0"],
        ["\xC4\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xE1"],
        ["\xC4\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xE2"],
        ["\xC4\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xE3"],
        ["\xC4\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xE4"],
        ["\xC4\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xE5"],
        ["\xC4\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xE6"],
        ["\xC4\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xE7"],
        ["\xC4\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xE8"],
        ["\xC4\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xE9"],
        ["\xC4\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xEA"],
        ["\xC4\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xEB"],
        ["\xC4\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xEC"],
        ["\xC4\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xED"],
        ["\xC4\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xEE"],
        ["\xC4\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xEF"],
        ["\xC4\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xF0"],
        ["\xC4\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xF1"],
        ["\xC4\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xF2"],
        ["\xC4\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xF3"],
        ["\xC4\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xF4"],
        ["\xC4\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xF5"],
        ["\xC4\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xF6"],
        ["\xC4\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xF7"],
        ["\xC4\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xF8"],
        ["\xC4\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xF9"],
        ["\xC4\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xFA"],
        ["\xC4\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xFB"],
        ["\xC4\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x92\xFC"],
        ["\xC5\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x40"],
        ["\xC5\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x41"],
        ["\xC5\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x42"],
        ["\xC5\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x43"],
        ["\xC5\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x44"],
        ["\xC5\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x45"],
        ["\xC5\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x46"],
        ["\xC5\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x47"],
        ["\xC5\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x48"],
        ["\xC5\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x49"],
        ["\xC5\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x4A"],
        ["\xC5\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x4B"],
        ["\xC5\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x4C"],
        ["\xC5\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x4D"],
        ["\xC5\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x4E"],
        ["\xC5\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x4F"],
        ["\xC5\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x50"],
        ["\xC5\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x51"],
        ["\xC5\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x52"],
        ["\xC5\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x53"],
        ["\xC5\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x54"],
        ["\x47\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x55"],
        ["\xC5\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x56"],
        ["\xC5\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x57"],
        ["\xC5\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x58"],
        ["\xC5\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x59"],
        ["\xC5\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x5A"],
        ["\xC5\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x5B"],
        ["\xC5\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x5C"],
        ["\xC5\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x5D"],
        ["\x6C\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x5E"],
        ["\xC5\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x5F"],
        ["\xC5\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x60"],
        ["\xC5\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x61"],
        ["\xC5\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x62"],
        ["\xC5\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x63"],
        ["\xC5\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x64"],
        ["\xC5\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x65"],
        ["\xC5\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x66"],
        ["\xC5\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x67"],
        ["\xC5\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x68"],
        ["\xC5\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x69"],
        ["\xC5\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x6A"],
        ["\xC5\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x6B"],
        ["\xC5\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x6C"],
        ["\xC5\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x6D"],
        ["\xC5\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x6E"],
        ["\xC5\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x6F"],
        ["\xC5\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x70"],
        ["\xC5\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x71"],
        ["\xC5\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x72"],
        ["\xC5\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x73"],
        ["\xC5\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x74"],
        ["\xC5\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x75"],
        ["\xE2\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x76"],
        ["\xC5\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x77"],
        ["\xC5\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x78"],
        ["\xC5\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x79"],
        ["\xC5\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x7A"],
        ["\xC5\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x7B"],
        ["\xC5\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x7C"],
        ["\xC5\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x7D"],
        ["\xC5\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x7E"],
        ["\xC5\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x80"],
        ["\xC5\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x81"],
        ["\xC5\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x82"],
        ["\xC5\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x83"],
        ["\xC5\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x84"],
        ["\xC5\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x85"],
        ["\xC5\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x86"],
        ["\xC5\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x87"],
        ["\xC5\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x88"],
        ["\xC5\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x89"],
        ["\xC5\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x8A"],
        ["\xC5\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x8B"],
        ["\xC5\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x8C"],
        ["\xC5\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x8D"],
        ["\xDB\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x8E"],
        ["\xC5\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x8F"],
        ["\xC5\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x90"],
        ["\xC5\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x91"],
        ["\xC5\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x92"],
        ["\xDE\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x93"],
        ["\xC5\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x94"],
        ["\xC5\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x95"],
        ["\xC5\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x96"],
        ["\xC5\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x97"],
        ["\xC5\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x98"],
        ["\xC5\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x99"],
        ["\xC5\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x9A"],
        ["\xC5\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x9B"],
        ["\xC5\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x9C"],
        ["\xC5\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x9D"],
        ["\xC5\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x9E"],
        ["\xC6\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\x9F"],
        ["\xC6\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xA0"],
        ["\xC6\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xA1"],
        ["\xC6\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xA2"],
        ["\xC6\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xA3"],
        ["\xC6\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xA4"],
        ["\xC6\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xA5"],
        ["\xC6\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xA6"],
        ["\xC6\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xA7"],
        ["\xC6\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xA8"],
        ["\xC6\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xA9"],
        ["\xC6\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xAA"],
        ["\xC6\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xAB"],
        ["\xC6\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xAC"],
        ["\xC6\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xAD"],
        ["\xC6\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xAE"],
        ["\xC6\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xAF"],
        ["\xC6\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xB0"],
        ["\xC6\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xB1"],
        ["\xC6\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xB2"],
        ["\xC6\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xB3"],
        ["\xC6\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xB4"],
        ["\xC6\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xB5"],
        ["\xC6\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xB6"],
        ["\xC6\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xB7"],
        ["\xC6\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xB8"],
        ["\xC6\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xB9"],
        ["\xC6\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xBA"],
        ["\xC6\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xBB"],
        ["\xC6\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xBC"],
        ["\xC6\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xBD"],
        ["\xC6\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xBE"],
        ["\xC6\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xBF"],
        ["\xC6\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xC0"],
        ["\xC6\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xC1"],
        ["\xC6\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xC2"],
        ["\xC6\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xC3"],
        ["\xC6\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xC4"],
        ["\xC6\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xC5"],
        ["\xC6\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xC6"],
        ["\xC6\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xC7"],
        ["\xC6\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xC8"],
        ["\xC6\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xC9"],
        ["\xC6\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xCA"],
        ["\xC6\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xCB"],
        ["\xC6\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xCC"],
        ["\xC6\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xCD"],
        ["\xC6\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xCE"],
        ["\xC6\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xCF"],
        ["\xC6\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xD0"],
        ["\xC6\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xD1"],
        ["\xC6\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xD2"],
        ["\xC6\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xD3"],
        ["\xC6\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xD4"],
        ["\xC6\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xD5"],
        ["\xC6\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xD6"],
        ["\xC6\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xD7"],
        ["\xC6\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xD8"],
        ["\xC6\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xD9"],
        ["\xC6\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xDA"],
        ["\xC6\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xDB"],
        ["\xC6\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xDC"],
        ["\xC6\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xDD"],
        ["\xC6\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xDE"],
        ["\xC6\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xDF"],
        ["\xC6\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xE0"],
        ["\xC6\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xE1"],
        ["\xC6\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xE2"],
        ["\xC6\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xE3"],
        ["\xC6\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xE4"],
        ["\xC6\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xE5"],
        ["\xC6\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xE6"],
        ["\xC6\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xE7"],
        ["\xC6\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xE8"],
        ["\xC6\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xE9"],
        ["\xC6\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xEA"],
        ["\xC6\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xEB"],
        ["\xC6\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xEC"],
        ["\xC6\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xED"],
        ["\xC6\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xEE"],
        ["\xC6\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xEF"],
        ["\xC6\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xF0"],
        ["\xC6\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xF1"],
        ["\xC6\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xF2"],
        ["\xC6\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xF3"],
        ["\xED\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xF4"],
        ["\xC6\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xF5"],
        ["\xC6\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xF6"],
        ["\xC6\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xF7"],
        ["\xC6\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xF8"],
        ["\xC6\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xF9"],
        ["\xC6\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xFA"],
        ["\xC6\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xFB"],
        ["\xC6\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x93\xFC"],
        ["\xC7\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x40"],
        ["\xC7\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x41"],
        ["\xC7\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x42"],
        ["\xC7\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x43"],
        ["\xC7\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x44"],
        ["\xC7\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x45"],
        ["\xC7\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x46"],
        ["\xC7\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x47"],
        ["\xC7\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x48"],
        ["\xC7\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x49"],
        ["\xC7\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x4A"],
        ["\xC7\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x4B"],
        ["\xC7\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x4C"],
        ["\xC7\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x4D"],
        ["\xC7\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x4E"],
        ["\xC7\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x4F"],
        ["\xC7\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x50"],
        ["\xC7\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x51"],
        ["\xC7\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x52"],
        ["\xC7\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x53"],
        ["\xC7\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x54"],
        ["\xC7\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x55"],
        ["\xC7\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x56"],
        ["\xC7\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x57"],
        ["\xC7\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x58"],
        ["\xC7\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x59"],
        ["\xC7\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x5A"],
        ["\xC7\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x5B"],
        ["\xC7\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x5C"],
        ["\xC7\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x5D"],
        ["\xC7\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x5E"],
        ["\xC7\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x5F"],
        ["\xC7\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x60"],
        ["\xC7\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x61"],
        ["\xC7\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x62"],
        ["\xC7\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x63"],
        ["\xC7\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x64"],
        ["\xC7\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x65"],
        ["\xC7\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x66"],
        ["\xC7\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x67"],
        ["\xC7\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x68"],
        ["\xC7\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x69"],
        ["\xC7\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x6A"],
        ["\xC7\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x6B"],
        ["\xC7\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x6C"],
        ["\xC7\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x6D"],
        ["\xC7\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x6E"],
        ["\xC7\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x6F"],
        ["\xC7\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x70"],
        ["\xC7\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x71"],
        ["\xC7\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x72"],
        ["\xC7\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x73"],
        ["\xC7\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x74"],
        ["\xC7\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x75"],
        ["\xC7\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x76"],
        ["\xC7\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x77"],
        ["\xC7\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x78"],
        ["\xC7\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x79"],
        ["\xC7\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x7A"],
        ["\xC7\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x7B"],
        ["\xC7\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x7C"],
        ["\xC7\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x7D"],
        ["\xC7\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x7E"],
        ["\xC7\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x80"],
        ["\xC7\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x81"],
        ["\xC7\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x82"],
        ["\xC7\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x83"],
        ["\xC7\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x84"],
        ["\xC7\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x85"],
        ["\xC7\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x86"],
        ["\xC7\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x87"],
        ["\xEA\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x88"],
        ["\xC7\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x89"],
        ["\xC7\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x8A"],
        ["\xC7\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x8B"],
        ["\xC7\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x8C"],
        ["\xC7\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x8D"],
        ["\xC7\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x8E"],
        ["\xC7\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x8F"],
        ["\xC7\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x90"],
        ["\xC7\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x91"],
        ["\xC7\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x92"],
        ["\xC7\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x93"],
        ["\xC7\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x94"],
        ["\xC7\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x95"],
        ["\xC7\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x96"],
        ["\xC7\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x97"],
        ["\xC7\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x98"],
        ["\xC7\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x99"],
        ["\xC7\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x9A"],
        ["\xC7\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x9B"],
        ["\xC7\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x9C"],
        ["\xC7\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x9D"],
        ["\xC7\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x9E"],
        ["\xC8\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\x9F"],
        ["\xC8\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xA0"],
        ["\xC8\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xA1"],
        ["\xC8\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xA2"],
        ["\xC8\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xA3"],
        ["\xC8\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xA4"],
        ["\xC8\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xA5"],
        ["\xC8\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xA6"],
        ["\xC8\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xA7"],
        ["\xC8\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xA8"],
        ["\xC8\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xA9"],
        ["\xC8\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xAA"],
        ["\xC8\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xAB"],
        ["\xC8\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xAC"],
        ["\xC8\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xAD"],
        ["\xC8\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xAE"],
        ["\xC8\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xAF"],
        ["\xC8\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xB0"],
        ["\xC8\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xB1"],
        ["\xC8\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xB2"],
        ["\xC8\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xB3"],
        ["\xC8\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xB4"],
        ["\xC8\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xB5"],
        ["\xC8\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xB6"],
        ["\xC8\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xB7"],
        ["\xC8\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xB8"],
        ["\xC8\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xB9"],
        ["\xC8\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xBA"],
        ["\xC8\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xBB"],
        ["\xC8\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xBC"],
        ["\xC8\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xBD"],
        ["\xC8\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xBE"],
        ["\xC8\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xBF"],
        ["\xC8\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xC0"],
        ["\xC8\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xC1"],
        ["\xC8\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xC2"],
        ["\xC8\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xC3"],
        ["\xC8\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xC4"],
        ["\xC8\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xC5"],
        ["\xC8\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xC6"],
        ["\xC8\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xC7"],
        ["\xC8\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xC8"],
        ["\xC8\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xC9"],
        ["\xC8\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xCA"],
        ["\xC8\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xCB"],
        ["\xC8\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xCC"],
        ["\xC8\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xCD"],
        ["\xC8\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xCE"],
        ["\xC8\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xCF"],
        ["\xC8\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xD0"],
        ["\xC8\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xD1"],
        ["\xC8\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xD2"],
        ["\xC8\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xD3"],
        ["\xC8\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xD4"],
        ["\xC8\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xD5"],
        ["\xC8\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xD6"],
        ["\xC8\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xD7"],
        ["\xC8\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xD8"],
        ["\xC8\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xD9"],
        ["\xC8\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xDA"],
        ["\xC8\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xDB"],
        ["\xC8\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xDC"],
        ["\xC8\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xDD"],
        ["\xC8\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xDE"],
        ["\xC8\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xDF"],
        ["\xC8\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xE0"],
        ["\xC8\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xE1"],
        ["\xC8\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xE2"],
        ["\xC8\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xE3"],
        ["\xC8\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xE4"],
        ["\xC8\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xE5"],
        ["\xC8\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xE6"],
        ["\xC8\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xE7"],
        ["\xC8\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xE8"],
        ["\xC8\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xE9"],
        ["\xC8\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xEA"],
        ["\xC8\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xEB"],
        ["\xC8\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xEC"],
        ["\xC8\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xED"],
        ["\xC8\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xEE"],
        ["\xC8\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xEF"],
        ["\xC8\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xF0"],
        ["\xC8\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xF1"],
        ["\xC8\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xF2"],
        ["\xC8\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xF3"],
        ["\xC8\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xF4"],
        ["\xC8\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xF5"],
        ["\xC8\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xF6"],
        ["\xC8\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xF7"],
        ["\xC8\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xF8"],
        ["\xC8\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xF9"],
        ["\xC8\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xFA"],
        ["\xC8\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xFB"],
        ["\xC8\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x94\xFC"],
        ["\xC9\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x40"],
        ["\xC9\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x41"],
        ["\xC9\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x42"],
        ["\xC9\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x43"],
        ["\xC9\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x44"],
        ["\xC9\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x45"],
        ["\xC9\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x46"],
        ["\xC9\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x47"],
        ["\xC9\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x48"],
        ["\xC9\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x49"],
        ["\xC9\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x4A"],
        ["\xC9\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x4B"],
        ["\xC9\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x4C"],
        ["\xC9\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x4D"],
        ["\xC9\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x4E"],
        ["\xDB\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x4F"],
        ["\xC9\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x50"],
        ["\xC9\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x51"],
        ["\xC9\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x52"],
        ["\xC9\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x53"],
        ["\xC9\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x54"],
        ["\xC9\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x55"],
        ["\xC9\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x56"],
        ["\xC9\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x57"],
        ["\xC9\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x58"],
        ["\xC9\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x59"],
        ["\xC9\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x5A"],
        ["\xC9\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x5B"],
        ["\xC9\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x5C"],
        ["\xC9\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x5D"],
        ["\xC9\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x5E"],
        ["\xC9\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x5F"],
        ["\xC9\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x60"],
        ["\xC9\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x61"],
        ["\xC9\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x62"],
        ["\xC9\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x63"],
        ["\xC9\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x64"],
        ["\xC9\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x65"],
        ["\xC9\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x66"],
        ["\xC9\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x67"],
        ["\xC9\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x68"],
        ["\xC9\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x69"],
        ["\xC9\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x6A"],
        ["\xC9\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x6B"],
        ["\xC9\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x6C"],
        ["\xC9\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x6D"],
        ["\xC9\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x6E"],
        ["\xC9\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x6F"],
        ["\xC9\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x70"],
        ["\xC9\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x71"],
        ["\xC9\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x72"],
        ["\xC9\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x73"],
        ["\xC9\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x74"],
        ["\xC9\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x75"],
        ["\xC9\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x76"],
        ["\xC9\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x77"],
        ["\xC9\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x78"],
        ["\xC9\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x79"],
        ["\xC9\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x7A"],
        ["\xC9\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x7B"],
        ["\xC9\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x7C"],
        ["\xC9\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x7D"],
        ["\xC9\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x7E"],
        ["\xC9\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x80"],
        ["\xC9\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x81"],
        ["\xC9\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x82"],
        ["\xC9\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x83"],
        ["\xC9\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x84"],
        ["\xC9\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x85"],
        ["\xC9\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x86"],
        ["\xC9\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x87"],
        ["\xC9\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x88"],
        ["\xC9\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x89"],
        ["\xC9\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x8A"],
        ["\xC9\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x8B"],
        ["\xC9\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x8C"],
        ["\xC9\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x8D"],
        ["\xC9\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x8E"],
        ["\xC9\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x8F"],
        ["\xC9\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x90"],
        ["\xC9\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x91"],
        ["\xC9\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x92"],
        ["\xC9\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x93"],
        ["\xC9\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x94"],
        ["\xC9\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x95"],
        ["\xC9\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x96"],
        ["\xC9\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x97"],
        ["\xC9\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x98"],
        ["\xC9\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x99"],
        ["\xC9\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x9A"],
        ["\xC9\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x9B"],
        ["\xC9\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x9C"],
        ["\xC9\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x9D"],
        ["\xC9\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x9E"],
        ["\xCA\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\x9F"],
        ["\xCA\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xA0"],
        ["\xCA\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xA1"],
        ["\xCA\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xA2"],
        ["\xCA\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xA3"],
        ["\xCA\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xA4"],
        ["\xCA\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xA5"],
        ["\xCA\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xA6"],
        ["\xCA\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xA7"],
        ["\xCA\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xA8"],
        ["\xCA\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xA9"],
        ["\xCA\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xAA"],
        ["\xCA\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xAB"],
        ["\xCA\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xAC"],
        ["\xCA\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xAD"],
        ["\xCA\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xAE"],
        ["\xCA\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xAF"],
        ["\xCA\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xB0"],
        ["\xCA\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xB1"],
        ["\xCA\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xB2"],
        ["\xCA\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xB3"],
        ["\xCA\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xB4"],
        ["\xCA\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xB5"],
        ["\xCA\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xB6"],
        ["\xCA\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xB7"],
        ["\xCA\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xB8"],
        ["\xCA\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xB9"],
        ["\xCA\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xBA"],
        ["\xCA\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xBB"],
        ["\xCA\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xBC"],
        ["\xCA\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xBD"],
        ["\xCA\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xBE"],
        ["\xCA\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xBF"],
        ["\xCA\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xC0"],
        ["\xCA\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xC1"],
        ["\xCA\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xC2"],
        ["\xCA\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xC3"],
        ["\xCA\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xC4"],
        ["\xCA\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xC5"],
        ["\xCA\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xC6"],
        ["\xCA\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xC7"],
        ["\xCA\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xC8"],
        ["\xCA\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xC9"],
        ["\xCA\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xCA"],
        ["\xCA\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xCB"],
        ["\xCA\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xCC"],
        ["\xCA\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xCD"],
        ["\xCA\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xCE"],
        ["\xCA\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xCF"],
        ["\xCA\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xD0"],
        ["\xCA\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xD1"],
        ["\xCA\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xD2"],
        ["\xCA\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xD3"],
        ["\xCA\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xD4"],
        ["\xCA\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xD5"],
        ["\xCA\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xD6"],
        ["\xCA\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xD7"],
        ["\xCA\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xD8"],
        ["\xCA\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xD9"],
        ["\xCA\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xDA"],
        ["\xCA\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xDB"],
        ["\xCA\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xDC"],
        ["\xCA\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xDD"],
        ["\xCA\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xDE"],
        ["\xCA\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xDF"],
        ["\xCA\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xE0"],
        ["\xCA\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xE1"],
        ["\xCA\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xE2"],
        ["\xCA\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xE3"],
        ["\xCA\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xE4"],
        ["\xCA\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xE5"],
        ["\xCA\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xE6"],
        ["\xCA\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xE7"],
        ["\xCA\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xE8"],
        ["\xCA\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xE9"],
        ["\xCA\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xEA"],
        ["\xCA\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xEB"],
        ["\xCA\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xEC"],
        ["\xCA\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xED"],
        ["\xCA\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xEE"],
        ["\xCA\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xEF"],
        ["\xCA\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xF0"],
        ["\xCA\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xF1"],
        ["\xCA\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xF2"],
        ["\xCA\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xF3"],
        ["\xCA\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xF4"],
        ["\xCA\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xF5"],
        ["\xCA\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xF6"],
        ["\xCA\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xF7"],
        ["\xCA\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xF8"],
        ["\xCA\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xF9"],
        ["\xCA\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xFA"],
        ["\xCA\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xFB"],
        ["\xCA\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x95\xFC"],
        ["\xCB\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x40"],
        ["\xCB\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x41"],
        ["\xCB\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x42"],
        ["\xCB\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x43"],
        ["\xCB\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x44"],
        ["\xCB\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x45"],
        ["\xCB\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x46"],
        ["\xCB\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x47"],
        ["\xCB\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x48"],
        ["\xCB\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x49"],
        ["\xCB\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x4A"],
        ["\xCB\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x4B"],
        ["\xCB\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x4C"],
        ["\xCB\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x4D"],
        ["\xCB\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x4E"],
        ["\xCB\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x4F"],
        ["\xCB\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x50"],
        ["\xCB\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x51"],
        ["\xCB\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x52"],
        ["\xCB\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x53"],
        ["\xCB\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x54"],
        ["\xCB\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x55"],
        ["\xCB\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x56"],
        ["\xCB\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x57"],
        ["\xCB\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x58"],
        ["\xCB\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x59"],
        ["\xCB\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x5A"],
        ["\xCB\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x5B"],
        ["\xCB\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x5C"],
        ["\xCB\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x5D"],
        ["\xCB\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x5E"],
        ["\xCB\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x5F"],
        ["\xCB\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x60"],
        ["\xCB\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x61"],
        ["\xCB\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x62"],
        ["\xCB\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x63"],
        ["\xCB\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x64"],
        ["\xCB\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x65"],
        ["\xCB\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x66"],
        ["\xCB\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x67"],
        ["\xCB\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x68"],
        ["\xCB\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x69"],
        ["\xCB\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x6A"],
        ["\xCB\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x6B"],
        ["\xCB\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x6C"],
        ["\xCB\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x6D"],
        ["\xCB\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x6E"],
        ["\xCB\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x6F"],
        ["\xCB\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x70"],
        ["\xCB\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x71"],
        ["\xCB\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x72"],
        ["\xCB\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x73"],
        ["\xCB\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x74"],
        ["\xCB\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x75"],
        ["\xCB\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x76"],
        ["\xCB\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x77"],
        ["\xCB\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x78"],
        ["\xCB\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x79"],
        ["\xCB\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x7A"],
        ["\xCB\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x7B"],
        ["\xCB\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x7C"],
        ["\xCB\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x7D"],
        ["\xCB\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x7E"],
        ["\xCB\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x80"],
        ["\xCB\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x81"],
        ["\xCB\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x82"],
        ["\xCB\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x83"],
        ["\xCB\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x84"],
        ["\xCB\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x85"],
        ["\xCB\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x86"],
        ["\xCB\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x87"],
        ["\xCB\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x88"],
        ["\xCB\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x89"],
        ["\x54\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x8A"],
        ["\xCB\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x8B"],
        ["\xCB\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x8C"],
        ["\xCB\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x8D"],
        ["\xCB\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x8E"],
        ["\xCB\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x8F"],
        ["\xCB\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x90"],
        ["\xCB\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x91"],
        ["\xCB\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x92"],
        ["\xCB\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x93"],
        ["\xCB\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x94"],
        ["\xCB\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x95"],
        ["\xCB\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x96"],
        ["\xCB\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x97"],
        ["\xCB\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x98"],
        ["\xD0\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x99"],
        ["\xCB\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x9A"],
        ["\xCB\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x9B"],
        ["\xCB\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x9C"],
        ["\xCB\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x9D"],
        ["\xCB\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x9E"],
        ["\xCC\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\x9F"],
        ["\xCC\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xA0"],
        ["\xCC\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xA1"],
        ["\xCC\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xA2"],
        ["\xCC\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xA3"],
        ["\xCC\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xA4"],
        ["\xCC\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xA5"],
        ["\xCC\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xA6"],
        ["\xCC\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xA7"],
        ["\xCC\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xA8"],
        ["\xCC\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xA9"],
        ["\xCC\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xAA"],
        ["\xCC\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xAB"],
        ["\xCC\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xAC"],
        ["\xCC\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xAD"],
        ["\xCC\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xAE"],
        ["\xCC\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xAF"],
        ["\xCC\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xB0"],
        ["\xCC\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xB1"],
        ["\xCC\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xB2"],
        ["\xCC\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xB3"],
        ["\xCC\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xB4"],
        ["\xCC\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xB5"],
        ["\xCC\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xB6"],
        ["\xCC\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xB7"],
        ["\xCC\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xB8"],
        ["\xCC\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xB9"],
        ["\xCC\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xBA"],
        ["\xCC\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xBB"],
        ["\xCC\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xBC"],
        ["\xCC\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xBD"],
        ["\xCC\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xBE"],
        ["\xCC\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xBF"],
        ["\xCC\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xC0"],
        ["\xCC\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xC1"],
        ["\xCC\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xC2"],
        ["\xCC\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xC3"],
        ["\xCC\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xC4"],
        ["\xCC\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xC5"],
        ["\xCC\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xC6"],
        ["\xCC\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xC7"],
        ["\xCC\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xC8"],
        ["\xCC\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xC9"],
        ["\xCC\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xCA"],
        ["\x6F\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xCB"],
        ["\xCC\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xCC"],
        ["\xCC\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xCD"],
        ["\xCC\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xCE"],
        ["\xCC\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xCF"],
        ["\xCC\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xD0"],
        ["\xCC\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xD1"],
        ["\xCC\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xD2"],
        ["\xCC\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xD3"],
        ["\xCC\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xD4"],
        ["\xCC\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xD5"],
        ["\xCC\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xD6"],
        ["\xCC\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xD7"],
        ["\xCC\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xD8"],
        ["\xCC\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xD9"],
        ["\xCC\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xDA"],
        ["\xCC\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xDB"],
        ["\xCC\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xDC"],
        ["\xCC\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xDD"],
        ["\xCC\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xDE"],
        ["\xCC\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xDF"],
        ["\xCC\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xE0"],
        ["\xCC\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xE1"],
        ["\xCC\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xE2"],
        ["\xCC\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xE3"],
        ["\xCC\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xE4"],
        ["\xCC\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xE5"],
        ["\xCC\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xE6"],
        ["\xCC\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xE7"],
        ["\xCC\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xE8"],
        ["\xCC\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xE9"],
        ["\xCC\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xEA"],
        ["\xCC\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xEB"],
        ["\xCC\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xEC"],
        ["\xCC\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xED"],
        ["\xCC\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xEE"],
        ["\xCC\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xEF"],
        ["\xCC\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xF0"],
        ["\xCC\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xF1"],
        ["\xCC\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xF2"],
        ["\xCC\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xF3"],
        ["\xCC\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xF4"],
        ["\xCC\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xF5"],
        ["\xCC\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xF6"],
        ["\xE9\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xF7"],
        ["\xCC\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xF8"],
        ["\xCC\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xF9"],
        ["\xCC\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xFA"],
        ["\xCC\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xFB"],
        ["\xCC\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x96\xFC"],
        ["\xCD\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x40"],
        ["\xCD\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x41"],
        ["\xCD\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x42"],
        ["\xCD\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x43"],
        ["\xCD\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x44"],
        ["\xCD\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x45"],
        ["\xCD\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x46"],
        ["\xCD\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x47"],
        ["\xCD\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x48"],
        ["\xCD\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x49"],
        ["\xCD\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x4A"],
        ["\xCD\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x4B"],
        ["\xCD\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x4C"],
        ["\xCD\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x4D"],
        ["\xCD\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x4E"],
        ["\xCD\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x4F"],
        ["\xCD\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x50"],
        ["\xCD\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x51"],
        ["\xCD\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x52"],
        ["\xCD\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x53"],
        ["\xCD\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x54"],
        ["\xCD\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x55"],
        ["\xCD\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x56"],
        ["\xCD\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x57"],
        ["\xCD\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x58"],
        ["\xCD\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x59"],
        ["\xCD\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x5A"],
        ["\xCD\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x5B"],
        ["\xCD\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x5C"],
        ["\xCD\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x5D"],
        ["\xCD\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x5E"],
        ["\xCD\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x5F"],
        ["\xCD\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x60"],
        ["\xCD\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x61"],
        ["\xCD\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x62"],
        ["\xCD\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x63"],
        ["\xCD\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x64"],
        ["\xCD\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x65"],
        ["\xCD\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x66"],
        ["\xCD\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x67"],
        ["\xCD\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x68"],
        ["\xCD\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x69"],
        ["\xCD\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x6A"],
        ["\xCD\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x6B"],
        ["\xCD\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x6C"],
        ["\xCD\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x6D"],
        ["\xCD\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x6E"],
        ["\xCD\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x6F"],
        ["\xCD\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x70"],
        ["\xCD\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x71"],
        ["\xCD\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x72"],
        ["\xCD\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x73"],
        ["\xCD\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x74"],
        ["\xCD\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x75"],
        ["\xCD\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x76"],
        ["\xCD\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x77"],
        ["\xCD\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x78"],
        ["\x70\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x79"],
        ["\xCD\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x7A"],
        ["\xCD\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x7B"],
        ["\xCD\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x7C"],
        ["\xCD\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x7D"],
        ["\xCD\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x7E"],
        ["\xCD\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x80"],
        ["\xCD\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x81"],
        ["\xCD\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x82"],
        ["\xCD\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x83"],
        ["\xCD\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x84"],
        ["\xCD\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x85"],
        ["\xCD\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x86"],
        ["\xCD\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x87"],
        ["\xCD\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x88"],
        ["\xCD\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x89"],
        ["\xCD\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x8A"],
        ["\xCD\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x8B"],
        ["\xCD\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x8C"],
        ["\xCD\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x8D"],
        ["\xCD\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x8E"],
        ["\xCD\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x8F"],
        ["\xCD\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x90"],
        ["\xCD\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x91"],
        ["\xCD\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x92"],
        ["\xCD\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x93"],
        ["\xCD\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x94"],
        ["\xCD\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x95"],
        ["\xCD\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x96"],
        ["\xCD\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x97"],
        ["\xCD\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x98"],
        ["\xCD\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x99"],
        ["\xCD\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x9A"],
        ["\xCD\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x9B"],
        ["\xCD\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x9C"],
        ["\xCD\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x9D"],
        ["\xCD\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x9E"],
        ["\xCE\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\x9F"],
        ["\xCE\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xA0"],
        ["\xCE\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xA1"],
        ["\xCE\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xA2"],
        ["\xCE\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xA3"],
        ["\xCE\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xA4"],
        ["\xCE\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xA5"],
        ["\xCE\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xA6"],
        ["\xCE\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xA7"],
        ["\xCE\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xA8"],
        ["\xCE\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xA9"],
        ["\xCE\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xAA"],
        ["\xCE\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xAB"],
        ["\xCE\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xAC"],
        ["\xCE\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xAD"],
        ["\xCE\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xAE"],
        ["\xCE\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xAF"],
        ["\xCE\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xB0"],
        ["\xCE\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xB1"],
        ["\xCE\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xB2"],
        ["\xCE\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xB3"],
        ["\xCE\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xB4"],
        ["\xCE\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xB5"],
        ["\xCE\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xB6"],
        ["\xCE\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xB7"],
        ["\xCE\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xB8"],
        ["\xCE\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xB9"],
        ["\xCE\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xBA"],
        ["\xCE\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xBB"],
        ["\xCE\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xBC"],
        ["\xCE\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xBD"],
        ["\xCE\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xBE"],
        ["\xCE\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xBF"],
        ["\xCE\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xC0"],
        ["\xCE\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xC1"],
        ["\xCE\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xC2"],
        ["\xCE\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xC3"],
        ["\xCE\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xC4"],
        ["\xCE\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xC5"],
        ["\xCE\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xC6"],
        ["\xCE\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xC7"],
        ["\xCE\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xC8"],
        ["\xCE\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xC9"],
        ["\xCE\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xCA"],
        ["\xCE\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xCB"],
        ["\xCE\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xCC"],
        ["\xCE\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xCD"],
        ["\xCE\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xCE"],
        ["\xCE\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xCF"],
        ["\xCE\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xD0"],
        ["\xCE\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xD1"],
        ["\xCE\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xD2"],
        ["\xCE\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xD3"],
        ["\xCE\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xD4"],
        ["\xCE\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xD5"],
        ["\xCE\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xD6"],
        ["\xCE\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xD7"],
        ["\xCE\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xD8"],
        ["\xCE\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xD9"],
        ["\xCE\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xDA"],
        ["\xCE\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xDB"],
        ["\xCE\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xDC"],
        ["\xCE\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xDD"],
        ["\xCE\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xDE"],
        ["\xCE\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xDF"],
        ["\xCE\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xE0"],
        ["\xCE\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xE1"],
        ["\xCE\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xE2"],
        ["\xCE\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xE3"],
        ["\xCE\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xE4"],
        ["\xCE\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xE5"],
        ["\xCE\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xE6"],
        ["\xCE\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xE7"],
        ["\xCE\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xE8"],
        ["\xCE\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xE9"],
        ["\xCE\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xEA"],
        ["\xCE\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xEB"],
        ["\xCE\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xEC"],
        ["\xCE\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xED"],
        ["\xCE\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xEE"],
        ["\xCE\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xEF"],
        ["\xCE\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xF0"],
        ["\xCE\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xF1"],
        ["\xCE\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xF2"],
        ["\xCE\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xF3"],
        ["\xCE\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xF4"],
        ["\xCE\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xF5"],
        ["\xCE\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xF6"],
        ["\xCE\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xF7"],
        ["\xCE\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xF8"],
        ["\xCE\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xF9"],
        ["\xCE\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xFA"],
        ["\xCE\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xFB"],
        ["\xCE\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x97\xFC"],
        ["\xCF\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x40"],
        ["\xCF\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x41"],
        ["\xCF\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x42"],
        ["\xCF\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x43"],
        ["\xCF\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x44"],
        ["\xCF\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x45"],
        ["\xCF\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x46"],
        ["\xCF\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x47"],
        ["\xCF\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x48"],
        ["\xCF\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x49"],
        ["\xCF\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x4A"],
        ["\xCF\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x4B"],
        ["\xCF\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x4C"],
        ["\xCF\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x4D"],
        ["\xCF\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x4E"],
        ["\xCF\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x4F"],
        ["\xCF\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x50"],
        ["\xCF\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x51"],
        ["\xCF\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x52"],
        ["\xCF\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x53"],
        ["\xCF\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x54"],
        ["\xE4\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x55"],
        ["\xCF\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x56"],
        ["\xCF\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x57"],
        ["\xCF\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x58"],
        ["\xCF\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x59"],
        ["\xCF\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x5A"],
        ["\xCF\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x5B"],
        ["\xCF\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x5C"],
        ["\xCF\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x5D"],
        ["\xCF\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x5E"],
        ["\xCF\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x5F"],
        ["\xCF\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x60"],
        ["\xCF\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x61"],
        ["\xCF\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x62"],
        ["\xCF\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x63"],
        ["\xCF\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x64"],
        ["\xCF\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x65"],
        ["\xCF\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x66"],
        ["\xCF\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x67"],
        ["\xCF\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x68"],
        ["\xCF\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x69"],
        ["\xCF\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x6A"],
        ["\xCF\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x6B"],
        ["\xCF\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x6C"],
        ["\xCF\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x6D"],
        ["\xCF\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x6E"],
        ["\xCF\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x6F"],
        ["\xCF\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x70"],
        ["\xCF\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x71"],
        ["\xCF\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x72"],
        ["\xD0\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\x9F"],
        ["\xD0\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xA0"],
        ["\xD0\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xA1"],
        ["\xD0\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xA2"],
        ["\xD0\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xA3"],
        ["\xD0\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xA4"],
        ["\xD0\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xA5"],
        ["\xD0\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xA6"],
        ["\xD0\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xA7"],
        ["\xD0\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xA8"],
        ["\xD0\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xA9"],
        ["\xD0\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xAA"],
        ["\xD0\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xAB"],
        ["\xD0\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xAC"],
        ["\xD0\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xAD"],
        ["\xD0\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xAE"],
        ["\xD0\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xAF"],
        ["\xD0\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xB0"],
        ["\xD0\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xB1"],
        ["\xD0\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xB2"],
        ["\xD0\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xB3"],
        ["\xD0\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xB4"],
        ["\xD0\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xB5"],
        ["\xD0\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xB6"],
        ["\xD0\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xB7"],
        ["\xD0\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xB8"],
        ["\xD0\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xB9"],
        ["\xD0\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xBA"],
        ["\xD0\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xBB"],
        ["\xD0\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xBC"],
        ["\xD0\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xBD"],
        ["\xD0\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xBE"],
        ["\xD0\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xBF"],
        ["\xD0\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xC0"],
        ["\xD0\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xC1"],
        ["\xD0\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xC2"],
        ["\xD0\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xC3"],
        ["\xD0\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xC4"],
        ["\xD0\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xC5"],
        ["\xD0\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xC6"],
        ["\xD0\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xC7"],
        ["\xD0\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xC8"],
        ["\xD0\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xC9"],
        ["\xD0\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xCA"],
        ["\xD0\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xCB"],
        ["\xD0\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xCC"],
        ["\xD0\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xCD"],
        ["\xD0\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xCE"],
        ["\xD0\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xCF"],
        ["\xD0\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xD0"],
        ["\xD0\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xD1"],
        ["\xD0\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xD2"],
        ["\xD0\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xD3"],
        ["\xCB\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xD4"],
        ["\xD0\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xD5"],
        ["\xD0\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xD6"],
        ["\xD0\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xD7"],
        ["\xD0\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xD8"],
        ["\xD0\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xD9"],
        ["\xD0\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xDA"],
        ["\xD0\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xDB"],
        ["\xD0\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xDC"],
        ["\xD0\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xDD"],
        ["\xD0\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xDE"],
        ["\xD0\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xDF"],
        ["\xD0\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xE0"],
        ["\xD0\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xE1"],
        ["\xD0\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xE2"],
        ["\xD0\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xE3"],
        ["\xD0\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xE4"],
        ["\xD0\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xE5"],
        ["\xD0\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xE6"],
        ["\xD0\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xE7"],
        ["\xD0\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xE8"],
        ["\xD0\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xE9"],
        ["\xD0\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xEA"],
        ["\xD0\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xEB"],
        ["\xD0\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xEC"],
        ["\xD0\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xED"],
        ["\xD0\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xEE"],
        ["\xD0\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xEF"],
        ["\xD0\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xF0"],
        ["\xD0\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xF1"],
        ["\xD0\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xF2"],
        ["\xD0\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xF3"],
        ["\xD0\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xF4"],
        ["\xD0\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xF5"],
        ["\xD0\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xF6"],
        ["\xD0\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xF7"],
        ["\xD0\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xF8"],
        ["\xD0\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xF9"],
        ["\xD0\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xFA"],
        ["\xD0\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xFB"],
        ["\xD0\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x98\xFC"],
        ["\xD1\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x40"],
        ["\xD1\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x41"],
        ["\xD1\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x42"],
        ["\xD1\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x43"],
        ["\xD1\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x44"],
        ["\xD1\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x45"],
        ["\xD1\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x46"],
        ["\xD1\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x47"],
        ["\xD1\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x48"],
        ["\xD1\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x49"],
        ["\xD1\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x4A"],
        ["\xD1\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x4B"],
        ["\xD1\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x4C"],
        ["\xD1\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x4D"],
        ["\xD1\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x4E"],
        ["\xD1\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x4F"],
        ["\xD1\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x50"],
        ["\xD1\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x51"],
        ["\xD1\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x52"],
        ["\xD1\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x53"],
        ["\xD1\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x54"],
        ["\xD1\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x55"],
        ["\xD1\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x56"],
        ["\xD1\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x57"],
        ["\xD1\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x58"],
        ["\xD1\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x59"],
        ["\xD1\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x5A"],
        ["\xD1\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x5B"],
        ["\xD1\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x5C"],
        ["\xD1\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x5D"],
        ["\xD1\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x5E"],
        ["\xD1\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x5F"],
        ["\xD1\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x60"],
        ["\xD1\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x61"],
        ["\xD1\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x62"],
        ["\xD1\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x63"],
        ["\xD1\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x64"],
        ["\xD1\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x65"],
        ["\xD1\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x66"],
        ["\xD1\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x67"],
        ["\xD1\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x68"],
        ["\xD1\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x69"],
        ["\xD1\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x6A"],
        ["\xD1\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x6B"],
        ["\xD1\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x6C"],
        ["\xD1\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x6D"],
        ["\xD1\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x6E"],
        ["\xD1\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x6F"],
        ["\xD1\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x70"],
        ["\xD1\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x71"],
        ["\xD1\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x72"],
        ["\xD1\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x73"],
        ["\xD1\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x74"],
        ["\xD1\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x75"],
        ["\xD1\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x76"],
        ["\xD1\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x77"],
        ["\xD1\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x78"],
        ["\xD1\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x79"],
        ["\xD1\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x7A"],
        ["\xD1\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x7B"],
        ["\xD1\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x7C"],
        ["\xD1\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x7D"],
        ["\xD1\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x7E"],
        ["\xD1\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x80"],
        ["\xD1\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x81"],
        ["\xD1\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x82"],
        ["\xD1\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x83"],
        ["\xD1\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x84"],
        ["\xD1\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x85"],
        ["\xD1\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x86"],
        ["\xD1\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x87"],
        ["\xD1\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x88"],
        ["\xD1\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x89"],
        ["\xD1\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x8A"],
        ["\xD1\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x8B"],
        ["\xD1\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x8C"],
        ["\xD1\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x8D"],
        ["\xD1\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x8E"],
        ["\xD1\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x8F"],
        ["\xD1\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x90"],
        ["\xD1\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x91"],
        ["\xD1\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x92"],
        ["\xD1\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x93"],
        ["\xD1\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x94"],
        ["\xD1\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x95"],
        ["\xD1\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x96"],
        ["\xD1\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x97"],
        ["\xD1\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x98"],
        ["\xD1\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x99"],
        ["\xD1\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x9A"],
        ["\xD1\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x9B"],
        ["\xD1\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x9C"],
        ["\xD1\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x9D"],
        ["\xD1\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x9E"],
        ["\xD2\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\x9F"],
        ["\xD2\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xA0"],
        ["\xD2\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xA1"],
        ["\xD2\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xA2"],
        ["\xD2\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xA3"],
        ["\xD2\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xA4"],
        ["\xD2\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xA5"],
        ["\xD2\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xA6"],
        ["\xD2\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xA7"],
        ["\xD2\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xA8"],
        ["\xD2\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xA9"],
        ["\xD2\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xAA"],
        ["\xD2\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xAB"],
        ["\xD2\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xAC"],
        ["\xD2\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xAD"],
        ["\xD2\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xAE"],
        ["\xD2\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xAF"],
        ["\xD2\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xB0"],
        ["\xD2\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xB1"],
        ["\xD2\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xB2"],
        ["\xD2\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xB3"],
        ["\xD2\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xB4"],
        ["\xD2\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xB5"],
        ["\xD2\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xB6"],
        ["\xD2\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xB7"],
        ["\xD2\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xB8"],
        ["\xD2\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xB9"],
        ["\xD2\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xBA"],
        ["\xD2\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xBB"],
        ["\xD2\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xBC"],
        ["\xD2\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xBD"],
        ["\xD2\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xBE"],
        ["\xD2\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xBF"],
        ["\xD2\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xC0"],
        ["\xD2\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xC1"],
        ["\xD2\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xC2"],
        ["\xD2\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xC3"],
        ["\xD2\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xC4"],
        ["\xD2\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xC5"],
        ["\xD2\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xC6"],
        ["\xD2\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xC7"],
        ["\xD2\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xC8"],
        ["\xD2\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xC9"],
        ["\xD2\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xCA"],
        ["\xD2\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xCB"],
        ["\xD2\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xCC"],
        ["\xD2\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xCD"],
        ["\xD2\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xCE"],
        ["\xD2\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xCF"],
        ["\xD2\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xD0"],
        ["\xD2\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xD1"],
        ["\xD2\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xD2"],
        ["\xD2\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xD3"],
        ["\xD2\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xD4"],
        ["\xD2\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xD5"],
        ["\xD2\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xD6"],
        ["\xD2\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xD7"],
        ["\xD2\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xD8"],
        ["\xD2\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xD9"],
        ["\xD2\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xDA"],
        ["\xD2\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xDB"],
        ["\xD2\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xDC"],
        ["\xD2\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xDD"],
        ["\xD2\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xDE"],
        ["\xD2\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xDF"],
        ["\xD2\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xE0"],
        ["\xD2\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xE1"],
        ["\xD2\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xE2"],
        ["\xD2\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xE3"],
        ["\xD2\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xE4"],
        ["\xD2\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xE5"],
        ["\xD2\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xE6"],
        ["\xD2\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xE7"],
        ["\xD2\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xE8"],
        ["\xD2\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xE9"],
        ["\xD2\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xEA"],
        ["\xD2\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xEB"],
        ["\xD2\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xEC"],
        ["\xD2\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xED"],
        ["\xD2\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xEE"],
        ["\xD2\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xEF"],
        ["\xD2\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xF0"],
        ["\xD2\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xF1"],
        ["\xD2\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xF2"],
        ["\xD2\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xF3"],
        ["\xD2\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xF4"],
        ["\xD2\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xF5"],
        ["\xD2\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xF6"],
        ["\xD2\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xF7"],
        ["\xD2\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xF8"],
        ["\xD2\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xF9"],
        ["\xD2\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xFA"],
        ["\xD2\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xFB"],
        ["\xD2\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x99\xFC"],
        ["\xD3\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x40"],
        ["\xD3\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x41"],
        ["\xD3\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x42"],
        ["\xD3\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x43"],
        ["\xD3\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x44"],
        ["\xD3\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x45"],
        ["\xD3\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x46"],
        ["\xD3\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x47"],
        ["\xD3\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x48"],
        ["\xD3\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x49"],
        ["\xD3\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x4A"],
        ["\xD3\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x4B"],
        ["\xD3\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x4C"],
        ["\xD3\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x4D"],
        ["\xD3\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x4E"],
        ["\xD3\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x4F"],
        ["\xD3\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x50"],
        ["\xD3\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x51"],
        ["\xD3\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x52"],
        ["\xD3\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x53"],
        ["\xD3\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x54"],
        ["\xD3\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x55"],
        ["\xD3\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x56"],
        ["\xD3\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x57"],
        ["\xD3\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x58"],
        ["\xD3\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x59"],
        ["\xD3\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x5A"],
        ["\xD3\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x5B"],
        ["\xD3\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x5C"],
        ["\xD3\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x5D"],
        ["\xD3\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x5E"],
        ["\xD3\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x5F"],
        ["\xD3\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x60"],
        ["\xD3\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x61"],
        ["\xD3\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x62"],
        ["\xD3\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x63"],
        ["\xD3\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x64"],
        ["\xD3\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x65"],
        ["\xD3\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x66"],
        ["\xD3\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x67"],
        ["\xD3\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x68"],
        ["\xD3\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x69"],
        ["\xD3\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x6A"],
        ["\xD3\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x6B"],
        ["\xD3\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x6C"],
        ["\xD3\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x6D"],
        ["\xD3\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x6E"],
        ["\xD3\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x6F"],
        ["\xD3\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x70"],
        ["\xD3\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x71"],
        ["\xD3\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x72"],
        ["\xD3\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x73"],
        ["\xD3\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x74"],
        ["\xD3\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x75"],
        ["\xD3\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x76"],
        ["\xD3\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x77"],
        ["\xD3\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x78"],
        ["\xD3\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x79"],
        ["\xD3\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x7A"],
        ["\xD3\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x7B"],
        ["\xD3\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x7C"],
        ["\xD3\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x7D"],
        ["\xD3\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x7E"],
        ["\xD3\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x80"],
        ["\xD3\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x81"],
        ["\xD3\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x82"],
        ["\xD3\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x83"],
        ["\xD3\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x84"],
        ["\xD3\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x85"],
        ["\xD3\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x86"],
        ["\xD3\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x87"],
        ["\xD3\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x88"],
        ["\xD3\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x89"],
        ["\xD3\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x8A"],
        ["\xD3\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x8B"],
        ["\xD3\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x8C"],
        ["\xD3\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x8D"],
        ["\xD3\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x8E"],
        ["\xD3\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x8F"],
        ["\xD3\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x90"],
        ["\xD3\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x91"],
        ["\xD3\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x92"],
        ["\xD3\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x93"],
        ["\xD3\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x94"],
        ["\xD3\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x95"],
        ["\xD3\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x96"],
        ["\xD3\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x97"],
        ["\xD3\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x98"],
        ["\xD3\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x99"],
        ["\xD3\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x9A"],
        ["\xD3\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x9B"],
        ["\xD3\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x9C"],
        ["\xD3\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x9D"],
        ["\xD3\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x9E"],
        ["\xD4\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\x9F"],
        ["\xD4\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xA0"],
        ["\xD4\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xA1"],
        ["\xD4\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xA2"],
        ["\xD4\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xA3"],
        ["\xD4\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xA4"],
        ["\xD4\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xA5"],
        ["\xD4\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xA6"],
        ["\xD4\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xA7"],
        ["\xD4\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xA8"],
        ["\xD4\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xA9"],
        ["\xD4\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xAA"],
        ["\xD4\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xAB"],
        ["\xD4\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xAC"],
        ["\xD4\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xAD"],
        ["\xD4\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xAE"],
        ["\xD4\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xAF"],
        ["\xD4\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xB0"],
        ["\xD4\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xB1"],
        ["\xD4\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xB2"],
        ["\xD4\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xB3"],
        ["\xD4\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xB4"],
        ["\xD4\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xB5"],
        ["\xD4\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xB6"],
        ["\xD4\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xB7"],
        ["\xD4\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xB8"],
        ["\xD4\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xB9"],
        ["\xD4\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xBA"],
        ["\xD4\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xBB"],
        ["\xD4\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xBC"],
        ["\xD4\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xBD"],
        ["\xD4\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xBE"],
        ["\xD4\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xBF"],
        ["\xD4\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xC0"],
        ["\xD4\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xC1"],
        ["\xD4\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xC2"],
        ["\xD4\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xC3"],
        ["\xD4\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xC4"],
        ["\xD4\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xC5"],
        ["\xD4\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xC6"],
        ["\xD4\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xC7"],
        ["\xD4\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xC8"],
        ["\xD4\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xC9"],
        ["\xD4\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xCA"],
        ["\xD4\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xCB"],
        ["\xD4\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xCC"],
        ["\xD4\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xCD"],
        ["\xD4\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xCE"],
        ["\xD4\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xCF"],
        ["\xD4\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xD0"],
        ["\xD4\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xD1"],
        ["\xD4\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xD2"],
        ["\xD4\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xD3"],
        ["\xD4\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xD4"],
        ["\xD4\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xD5"],
        ["\xD4\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xD6"],
        ["\xD4\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xD7"],
        ["\xD4\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xD8"],
        ["\xD4\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xD9"],
        ["\xD4\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xDA"],
        ["\xD4\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xDB"],
        ["\xD4\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xDC"],
        ["\xD4\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xDD"],
        ["\xD4\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xDE"],
        ["\xD4\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xDF"],
        ["\xD4\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xE0"],
        ["\xD4\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xE1"],
        ["\xC4\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xE2"],
        ["\xD4\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xE3"],
        ["\xD4\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xE4"],
        ["\xD4\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xE5"],
        ["\xD4\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xE6"],
        ["\xD4\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xE7"],
        ["\xD4\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xE8"],
        ["\xD4\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xE9"],
        ["\xD4\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xEA"],
        ["\xD4\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xEB"],
        ["\xD4\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xEC"],
        ["\xD4\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xED"],
        ["\xD4\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xEE"],
        ["\xD4\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xEF"],
        ["\xD4\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xF0"],
        ["\xD4\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xF1"],
        ["\xD4\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xF2"],
        ["\xD4\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xF3"],
        ["\xD4\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xF4"],
        ["\xD4\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xF5"],
        ["\xD4\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xF6"],
        ["\xD4\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xF7"],
        ["\xD4\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xF8"],
        ["\xD4\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xF9"],
        ["\xD4\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xFA"],
        ["\xD4\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xFB"],
        ["\xD4\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9A\xFC"],
        ["\xD5\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x40"],
        ["\xD5\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x41"],
        ["\xD5\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x42"],
        ["\xD5\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x43"],
        ["\xD5\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x44"],
        ["\xD5\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x45"],
        ["\xD5\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x46"],
        ["\xD5\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x47"],
        ["\xD5\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x48"],
        ["\xD5\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x49"],
        ["\xD5\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x4A"],
        ["\xD5\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x4B"],
        ["\xD5\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x4C"],
        ["\xD5\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x4D"],
        ["\xD5\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x4E"],
        ["\xD5\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x4F"],
        ["\xD5\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x50"],
        ["\xD5\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x51"],
        ["\xD5\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x52"],
        ["\xD5\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x53"],
        ["\xD5\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x54"],
        ["\xD5\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x55"],
        ["\xD5\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x56"],
        ["\xD5\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x57"],
        ["\xD5\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x58"],
        ["\xD5\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x59"],
        ["\xD5\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x5A"],
        ["\xD5\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x5B"],
        ["\xD5\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x5C"],
        ["\xD5\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x5D"],
        ["\xD5\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x5E"],
        ["\xD5\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x5F"],
        ["\xD5\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x60"],
        ["\xD5\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x61"],
        ["\xD5\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x62"],
        ["\xD5\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x63"],
        ["\xD5\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x64"],
        ["\xD5\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x65"],
        ["\xD5\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x66"],
        ["\xD5\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x67"],
        ["\xD5\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x68"],
        ["\xD5\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x69"],
        ["\xD5\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x6A"],
        ["\xD5\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x6B"],
        ["\xD5\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x6C"],
        ["\xD5\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x6D"],
        ["\xD5\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x6E"],
        ["\xD5\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x6F"],
        ["\xD5\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x70"],
        ["\xD5\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x71"],
        ["\xD5\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x72"],
        ["\xD5\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x73"],
        ["\xD5\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x74"],
        ["\xD5\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x75"],
        ["\xD5\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x76"],
        ["\xD5\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x77"],
        ["\xD5\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x78"],
        ["\xD5\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x79"],
        ["\xD5\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x7A"],
        ["\xD5\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x7B"],
        ["\xD5\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x7C"],
        ["\xD5\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x7D"],
        ["\xD5\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x7E"],
        ["\xD5\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x80"],
        ["\xD5\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x81"],
        ["\xD5\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x82"],
        ["\xD5\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x83"],
        ["\xD5\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x84"],
        ["\xD5\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x85"],
        ["\xD5\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x86"],
        ["\xD5\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x87"],
        ["\xD5\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x88"],
        ["\xD5\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x89"],
        ["\xD5\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x8A"],
        ["\xD5\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x8B"],
        ["\xD5\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x8C"],
        ["\xD5\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x8D"],
        ["\xD5\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x8E"],
        ["\xD5\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x8F"],
        ["\xD5\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x90"],
        ["\xD5\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x91"],
        ["\xD5\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x92"],
        ["\xD5\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x93"],
        ["\xD5\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x94"],
        ["\xD5\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x95"],
        ["\xD5\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x96"],
        ["\xD5\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x97"],
        ["\xD5\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x98"],
        ["\xD5\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x99"],
        ["\xD5\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x9A"],
        ["\xD5\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x9B"],
        ["\xD5\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x9C"],
        ["\xD5\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x9D"],
        ["\xD5\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x9E"],
        ["\xD6\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\x9F"],
        ["\xD6\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xA0"],
        ["\xD6\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xA1"],
        ["\xD6\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xA2"],
        ["\xD6\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xA3"],
        ["\xD6\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xA4"],
        ["\xD6\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xA5"],
        ["\xD6\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xA6"],
        ["\xD6\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xA7"],
        ["\xD6\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xA8"],
        ["\xD6\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xA9"],
        ["\xD6\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xAA"],
        ["\xD6\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xAB"],
        ["\xD6\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xAC"],
        ["\xD6\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xAD"],
        ["\xD6\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xAE"],
        ["\xD6\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xAF"],
        ["\xD6\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xB0"],
        ["\xD6\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xB1"],
        ["\xD6\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xB2"],
        ["\xD6\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xB3"],
        ["\xD6\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xB4"],
        ["\xD6\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xB5"],
        ["\xD6\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xB6"],
        ["\xD6\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xB7"],
        ["\xD6\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xB8"],
        ["\xD6\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xB9"],
        ["\xD6\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xBA"],
        ["\xD6\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xBB"],
        ["\xD6\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xBC"],
        ["\xD6\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xBD"],
        ["\xD6\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xBE"],
        ["\xD6\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xBF"],
        ["\xD6\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xC0"],
        ["\xD6\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xC1"],
        ["\xD6\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xC2"],
        ["\xD6\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xC3"],
        ["\xD6\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xC4"],
        ["\xD6\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xC5"],
        ["\xD6\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xC6"],
        ["\xD6\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xC7"],
        ["\xD6\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xC8"],
        ["\xD6\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xC9"],
        ["\xD6\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xCA"],
        ["\xD6\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xCB"],
        ["\xD6\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xCC"],
        ["\xD6\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xCD"],
        ["\xD6\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xCE"],
        ["\xD6\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xCF"],
        ["\xD6\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xD0"],
        ["\xD6\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xD1"],
        ["\xD6\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xD2"],
        ["\xD6\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xD3"],
        ["\xD6\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xD4"],
        ["\xD6\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xD5"],
        ["\xD6\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xD6"],
        ["\xD6\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xD7"],
        ["\xD6\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xD8"],
        ["\xD6\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xD9"],
        ["\xD6\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xDA"],
        ["\xD6\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xDB"],
        ["\xD6\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xDC"],
        ["\xD6\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xDD"],
        ["\xD6\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xDE"],
        ["\xD6\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xDF"],
        ["\xD6\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xE0"],
        ["\xD6\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xE1"],
        ["\xD6\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xE2"],
        ["\xD6\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xE3"],
        ["\xD6\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xE4"],
        ["\xD6\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xE5"],
        ["\xD6\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xE6"],
        ["\xD6\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xE7"],
        ["\xD6\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xE8"],
        ["\xD6\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xE9"],
        ["\xD6\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xEA"],
        ["\xD6\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xEB"],
        ["\xD6\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xEC"],
        ["\xD6\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xED"],
        ["\xD6\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xEE"],
        ["\xD6\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xEF"],
        ["\xD6\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xF0"],
        ["\xD6\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xF1"],
        ["\xD6\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xF2"],
        ["\xD6\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xF3"],
        ["\xD6\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xF4"],
        ["\xD6\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xF5"],
        ["\xD6\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xF6"],
        ["\xD6\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xF7"],
        ["\xD6\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xF8"],
        ["\xD6\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xF9"],
        ["\xD6\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xFA"],
        ["\xD6\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xFB"],
        ["\xD6\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9B\xFC"],
        ["\xD7\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x40"],
        ["\xD7\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x41"],
        ["\xD7\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x42"],
        ["\xD7\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x43"],
        ["\xD7\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x44"],
        ["\xD7\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x45"],
        ["\xD7\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x46"],
        ["\xD7\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x47"],
        ["\xD7\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x48"],
        ["\xD7\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x49"],
        ["\xD7\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x4A"],
        ["\xD7\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x4B"],
        ["\xD7\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x4C"],
        ["\xD7\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x4D"],
        ["\xD7\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x4E"],
        ["\xD7\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x4F"],
        ["\xD7\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x50"],
        ["\xD7\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x51"],
        ["\xD7\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x52"],
        ["\xD7\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x53"],
        ["\xD7\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x54"],
        ["\xD7\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x55"],
        ["\xD7\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x56"],
        ["\xD7\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x57"],
        ["\xD7\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x58"],
        ["\xD7\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x59"],
        ["\xD7\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x5B"],
        ["\xD7\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x5C"],
        ["\xD7\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x5D"],
        ["\xD7\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x5E"],
        ["\xD7\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x5F"],
        ["\xD7\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x60"],
        ["\xD7\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x61"],
        ["\xD7\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x62"],
        ["\xD7\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x63"],
        ["\xD7\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x64"],
        ["\xD7\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x65"],
        ["\xD7\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x66"],
        ["\xD7\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x67"],
        ["\xD7\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x68"],
        ["\xD7\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x69"],
        ["\xD7\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x6A"],
        ["\xD7\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x6B"],
        ["\xD7\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x6C"],
        ["\xD7\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x6D"],
        ["\xD7\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x6E"],
        ["\xD7\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x6F"],
        ["\xD7\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x70"],
        ["\xD7\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x71"],
        ["\xD7\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x72"],
        ["\xD7\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x73"],
        ["\xD7\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x74"],
        ["\xD7\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x75"],
        ["\xD7\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x76"],
        ["\xD7\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x77"],
        ["\xD7\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x78"],
        ["\xD7\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x79"],
        ["\xD7\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x7A"],
        ["\xD7\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x7B"],
        ["\xD7\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x7C"],
        ["\xD7\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x7D"],
        ["\xD7\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x7E"],
        ["\xD7\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x80"],
        ["\xD7\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x81"],
        ["\xD7\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x82"],
        ["\xD7\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x83"],
        ["\xD7\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x84"],
        ["\xD7\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x85"],
        ["\xD7\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x86"],
        ["\xD7\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x87"],
        ["\xD7\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x88"],
        ["\xD7\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x89"],
        ["\xD7\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x8A"],
        ["\xD7\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x8B"],
        ["\xD7\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x8C"],
        ["\xD7\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x8D"],
        ["\xD7\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x8E"],
        ["\xD7\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x8F"],
        ["\xD7\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x90"],
        ["\xD7\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x91"],
        ["\xD7\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x92"],
        ["\xD7\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x93"],
        ["\xD7\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x94"],
        ["\xD7\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x95"],
        ["\xD7\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x96"],
        ["\xD7\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x97"],
        ["\xD7\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x98"],
        ["\xD7\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x99"],
        ["\xD7\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x9A"],
        ["\xD7\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x9B"],
        ["\xD7\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x9C"],
        ["\xD7\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x9D"],
        ["\xD7\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x9E"],
        ["\xD8\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x9F"],
        ["\xD8\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xA0"],
        ["\xD8\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xA1"],
        ["\xD8\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xA2"],
        ["\xD8\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xA3"],
        ["\xD8\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xA4"],
        ["\xD8\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xA5"],
        ["\xD8\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xA6"],
        ["\xD8\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xA7"],
        ["\xD8\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xA8"],
        ["\xD8\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xA9"],
        ["\xD8\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xAA"],
        ["\xD8\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xAB"],
        ["\xD8\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xAC"],
        ["\xD8\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xAD"],
        ["\xD8\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xAE"],
        ["\xD8\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xAF"],
        ["\xD8\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xB0"],
        ["\xD8\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xB1"],
        ["\xD8\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xB2"],
        ["\xD8\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xB3"],
        ["\xD8\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xB4"],
        ["\xD8\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xB5"],
        ["\xD8\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xB6"],
        ["\xD8\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xB7"],
        ["\xD8\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xB8"],
        ["\xD8\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xB9"],
        ["\xD8\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xBA"],
        ["\xD8\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xBB"],
        ["\xD8\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xBC"],
        ["\xD8\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xBD"],
        ["\xD8\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xBE"],
        ["\xD8\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xBF"],
        ["\xD8\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xC0"],
        ["\xD8\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xC1"],
        ["\xD8\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xC2"],
        ["\xD8\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xC3"],
        ["\xD8\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xC4"],
        ["\xD8\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xC5"],
        ["\xD8\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xC6"],
        ["\xD8\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xC7"],
        ["\xD8\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xC8"],
        ["\xD8\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xC9"],
        ["\xD8\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xCA"],
        ["\xD8\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xCB"],
        ["\xD8\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xCC"],
        ["\xD8\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xCD"],
        ["\xD8\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xCE"],
        ["\xD8\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xCF"],
        ["\xD8\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xD0"],
        ["\xD8\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xD1"],
        ["\xD8\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xD2"],
        ["\xD8\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xD3"],
        ["\xD8\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xD4"],
        ["\xD8\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xD5"],
        ["\xD8\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xD6"],
        ["\xD8\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xD7"],
        ["\xD8\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xD8"],
        ["\xD8\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xD9"],
        ["\xD8\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xDA"],
        ["\xD8\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xDB"],
        ["\xD8\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xDC"],
        ["\xD8\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xDD"],
        ["\xD8\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xDE"],
        ["\xD8\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xDF"],
        ["\xD8\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xE0"],
        ["\xD8\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xE1"],
        ["\xD8\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xE2"],
        ["\xD8\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xE3"],
        ["\xD8\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xE4"],
        ["\xD8\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xE5"],
        ["\xD8\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xE6"],
        ["\xD8\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xE7"],
        ["\xD8\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xE8"],
        ["\xD8\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xE9"],
        ["\xD8\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xEA"],
        ["\xD8\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xEB"],
        ["\xD8\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xEC"],
        ["\xD8\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xED"],
        ["\xD8\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xEE"],
        ["\xD8\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xEF"],
        ["\xD8\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xF0"],
        ["\xD8\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xF1"],
        ["\xD8\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xF2"],
        ["\xD8\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xF3"],
        ["\xD8\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xF4"],
        ["\xD8\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xF5"],
        ["\xD8\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xF6"],
        ["\xD8\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xF7"],
        ["\xD8\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xF8"],
        ["\xD8\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xF9"],
        ["\xD8\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xFA"],
        ["\xD8\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xFB"],
        ["\xD8\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\xFC"],
        ["\xD9\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x40"],
        ["\xD9\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x41"],
        ["\xD9\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x42"],
        ["\xD9\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x43"],
        ["\xD9\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x44"],
        ["\xD9\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x45"],
        ["\xD9\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x46"],
        ["\xD9\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x47"],
        ["\xD9\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x48"],
        ["\xD9\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x49"],
        ["\xD9\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x4A"],
        ["\xD9\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x4B"],
        ["\xD9\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x4C"],
        ["\xD9\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x4D"],
        ["\xD9\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x4E"],
        ["\xD9\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x4F"],
        ["\xD9\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x50"],
        ["\xD9\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x51"],
        ["\xD9\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x52"],
        ["\xD9\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x53"],
        ["\xD9\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x54"],
        ["\xD9\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x55"],
        ["\xD9\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x56"],
        ["\xD9\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x57"],
        ["\xD9\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x58"],
        ["\xD9\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x59"],
        ["\xD9\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x5A"],
        ["\xD9\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x5B"],
        ["\xD9\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x5C"],
        ["\xD9\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x5D"],
        ["\xD9\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x5E"],
        ["\xD9\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x5F"],
        ["\xD9\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x60"],
        ["\xD9\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x61"],
        ["\xD9\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x62"],
        ["\xD9\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x63"],
        ["\xD9\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x64"],
        ["\xD9\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x65"],
        ["\xD9\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x66"],
        ["\xD9\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x67"],
        ["\xD9\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x68"],
        ["\xD9\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x69"],
        ["\xD9\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x6A"],
        ["\xD9\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x6B"],
        ["\xD9\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x6C"],
        ["\xD9\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x6D"],
        ["\xD9\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x6E"],
        ["\xD9\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x6F"],
        ["\xD9\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x70"],
        ["\xD9\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x71"],
        ["\xD9\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x72"],
        ["\xD9\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x73"],
        ["\xD9\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x74"],
        ["\xD9\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x75"],
        ["\xD9\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x76"],
        ["\xD9\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x77"],
        ["\xD9\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x78"],
        ["\xD9\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x79"],
        ["\xD9\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x7A"],
        ["\xD9\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x7B"],
        ["\xD9\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x7C"],
        ["\xD9\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x7D"],
        ["\xD9\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x7E"],
        ["\xD9\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x80"],
        ["\xD9\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x81"],
        ["\xD9\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x82"],
        ["\xD9\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x83"],
        ["\xD9\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x84"],
        ["\xD9\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x85"],
        ["\xD9\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x86"],
        ["\xD9\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x87"],
        ["\xD9\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x88"],
        ["\xD9\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x89"],
        ["\xD9\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x8A"],
        ["\xD9\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x8B"],
        ["\xD9\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x8C"],
        ["\xD9\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x8D"],
        ["\xD9\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x8E"],
        ["\xD9\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x8F"],
        ["\xD9\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x90"],
        ["\xD9\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x91"],
        ["\xD9\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x92"],
        ["\xD9\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x93"],
        ["\xD9\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x94"],
        ["\xD9\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x95"],
        ["\xD9\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x96"],
        ["\xD9\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x97"],
        ["\xB3\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x98"],
        ["\xD9\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x99"],
        ["\xD9\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x9A"],
        ["\xD9\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x9B"],
        ["\xD9\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x9C"],
        ["\xD9\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x9D"],
        ["\xD9\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x9E"],
        ["\xDA\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\x9F"],
        ["\xDA\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xA0"],
        ["\xDA\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xA1"],
        ["\xDA\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xA2"],
        ["\xDA\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xA3"],
        ["\xDA\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xA4"],
        ["\xDA\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xA5"],
        ["\xDA\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xA6"],
        ["\xDA\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xA7"],
        ["\xDA\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xA8"],
        ["\xDA\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xA9"],
        ["\xDA\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xAA"],
        ["\xDA\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xAB"],
        ["\xDA\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xAC"],
        ["\xDA\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xAD"],
        ["\xDA\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xAE"],
        ["\xDA\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xAF"],
        ["\xDA\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xB0"],
        ["\xDA\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xB1"],
        ["\xDA\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xB2"],
        ["\xDA\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xB3"],
        ["\xDA\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xB4"],
        ["\xDA\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xB5"],
        ["\xDA\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xB6"],
        ["\xDA\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xB7"],
        ["\xDA\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xB8"],
        ["\xDA\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xB9"],
        ["\xDA\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xBA"],
        ["\xDA\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xBB"],
        ["\xDA\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xBC"],
        ["\xDA\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xBD"],
        ["\xDA\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xBE"],
        ["\xDA\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xBF"],
        ["\xDA\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xC0"],
        ["\xDA\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xC1"],
        ["\xDA\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xC2"],
        ["\xDA\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xC3"],
        ["\xDA\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xC4"],
        ["\xDA\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xC5"],
        ["\xDA\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xC6"],
        ["\xDA\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xC7"],
        ["\xDA\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xC8"],
        ["\xDA\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xC9"],
        ["\xDA\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xCA"],
        ["\xDA\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xCB"],
        ["\xDA\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xCC"],
        ["\xDA\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xCD"],
        ["\xDA\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xCE"],
        ["\xDA\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xCF"],
        ["\xDA\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xD0"],
        ["\xDA\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xD1"],
        ["\xDA\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xD2"],
        ["\xDA\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xD3"],
        ["\xDA\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xD4"],
        ["\xDA\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xD5"],
        ["\xDA\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xD6"],
        ["\xDA\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xD7"],
        ["\xDA\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xD8"],
        ["\xDA\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xD9"],
        ["\xDA\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xDA"],
        ["\xDA\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xDB"],
        ["\xDA\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xDC"],
        ["\xDA\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xDD"],
        ["\xDA\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xDE"],
        ["\xDA\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xDF"],
        ["\xDA\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xE0"],
        ["\xDA\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xE1"],
        ["\xDA\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xE2"],
        ["\xDA\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xE3"],
        ["\xDA\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xE4"],
        ["\xDA\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xE5"],
        ["\xDA\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xE6"],
        ["\xDA\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xE7"],
        ["\xDA\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xE8"],
        ["\xDA\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xE9"],
        ["\xDA\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xEA"],
        ["\xDA\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xEB"],
        ["\xDA\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xEC"],
        ["\xDA\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xED"],
        ["\xDA\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xEE"],
        ["\xDA\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xEF"],
        ["\xDA\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xF0"],
        ["\xDA\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xF1"],
        ["\xDA\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xF2"],
        ["\xDA\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xF3"],
        ["\xDA\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xF4"],
        ["\xDA\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xF5"],
        ["\xDA\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xF6"],
        ["\xDA\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xF7"],
        ["\xDA\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xF8"],
        ["\xDA\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xF9"],
        ["\xDA\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xFA"],
        ["\xDA\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xFB"],
        ["\xDA\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9D\xFC"],
        ["\xDB\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x40"],
        ["\xDB\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x41"],
        ["\xDB\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x42"],
        ["\xDB\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x43"],
        ["\xDB\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x44"],
        ["\xDB\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x45"],
        ["\xDB\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x46"],
        ["\xDB\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x47"],
        ["\xDB\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x48"],
        ["\xDB\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x49"],
        ["\xDB\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x4A"],
        ["\xDB\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x4B"],
        ["\xDB\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x4C"],
        ["\xDB\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x4D"],
        ["\xDB\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x4E"],
        ["\xDB\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x4F"],
        ["\xDB\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x50"],
        ["\xDB\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x51"],
        ["\xDB\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x52"],
        ["\xDB\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x53"],
        ["\xDB\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x54"],
        ["\xDB\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x55"],
        ["\xDB\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x56"],
        ["\xDB\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x57"],
        ["\xDB\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x58"],
        ["\xDB\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x59"],
        ["\xDB\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x5A"],
        ["\xDB\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x5B"],
        ["\xDB\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x5C"],
        ["\xDB\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x5D"],
        ["\xDB\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x5E"],
        ["\xDB\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x5F"],
        ["\xDB\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x60"],
        ["\xDB\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x61"],
        ["\xDB\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x62"],
        ["\xDB\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x63"],
        ["\xDB\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x64"],
        ["\xDB\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x65"],
        ["\xDB\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x66"],
        ["\xDB\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x67"],
        ["\xDB\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x68"],
        ["\xDB\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x69"],
        ["\xDB\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x6A"],
        ["\xDB\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x6B"],
        ["\xDB\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x6C"],
        ["\xDB\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x6D"],
        ["\xDB\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x6E"],
        ["\xDB\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x6F"],
        ["\xDB\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x70"],
        ["\xDB\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x71"],
        ["\xDB\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x72"],
        ["\xDB\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x73"],
        ["\xDB\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x74"],
        ["\xDB\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x75"],
        ["\xDB\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x76"],
        ["\xC9\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x77"],
        ["\xDB\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x78"],
        ["\xDB\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x79"],
        ["\xDB\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x7A"],
        ["\xDB\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x7B"],
        ["\xDB\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x7C"],
        ["\xDB\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x7D"],
        ["\xDB\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x7E"],
        ["\xDB\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x80"],
        ["\xDB\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x81"],
        ["\xDB\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x82"],
        ["\xDB\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x83"],
        ["\xDB\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x84"],
        ["\xDB\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x85"],
        ["\xDB\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x86"],
        ["\xDB\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x87"],
        ["\xDB\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x88"],
        ["\xDB\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x89"],
        ["\xDB\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x8A"],
        ["\xDB\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x8B"],
        ["\xDB\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x8C"],
        ["\xC5\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x8D"],
        ["\xDB\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x8E"],
        ["\xDB\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x8F"],
        ["\xDB\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x90"],
        ["\xDB\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x91"],
        ["\xDB\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x92"],
        ["\xDB\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x93"],
        ["\xDB\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x94"],
        ["\xDB\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x95"],
        ["\xDB\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x96"],
        ["\xDB\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x97"],
        ["\xDB\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x98"],
        ["\xDB\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x99"],
        ["\xDB\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x9A"],
        ["\xDB\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x9B"],
        ["\xDB\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x9C"],
        ["\xDB\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x9D"],
        ["\xDB\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x9E"],
        ["\xDC\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\x9F"],
        ["\xDC\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xA0"],
        ["\xDC\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xA1"],
        ["\xDC\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xA2"],
        ["\xDC\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xA3"],
        ["\xDC\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xA4"],
        ["\xDC\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xA5"],
        ["\xDC\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xA6"],
        ["\xDC\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xA7"],
        ["\xDC\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xA8"],
        ["\xDC\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xA9"],
        ["\xDC\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xAA"],
        ["\xDC\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xAB"],
        ["\xDC\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xAC"],
        ["\xDC\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xAD"],
        ["\xDC\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xAE"],
        ["\xDC\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xAF"],
        ["\xDC\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xB0"],
        ["\xDC\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xB1"],
        ["\xDC\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xB2"],
        ["\xDC\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xB3"],
        ["\xDC\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xB4"],
        ["\xDC\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xB5"],
        ["\xDC\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xB6"],
        ["\xDC\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xB7"],
        ["\xDC\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xB8"],
        ["\xDC\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xB9"],
        ["\xDC\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xBA"],
        ["\xDC\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xBB"],
        ["\xDC\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xBC"],
        ["\xDC\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xBD"],
        ["\xDC\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xBE"],
        ["\xDC\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xBF"],
        ["\xDC\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xC0"],
        ["\xDC\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xC1"],
        ["\xDC\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xC2"],
        ["\xDC\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xC3"],
        ["\xDC\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xC4"],
        ["\xDC\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xC5"],
        ["\xDC\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xC6"],
        ["\xDC\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xC7"],
        ["\xDC\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xC8"],
        ["\xDC\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xC9"],
        ["\xDC\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xCA"],
        ["\xDC\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xCB"],
        ["\xDC\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xCC"],
        ["\xDC\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xCD"],
        ["\xDC\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xCE"],
        ["\xDC\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xCF"],
        ["\xDC\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xD0"],
        ["\xDC\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xD1"],
        ["\xDC\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xD2"],
        ["\xDC\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xD3"],
        ["\xDC\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xD4"],
        ["\xDC\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xD5"],
        ["\xDC\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xD6"],
        ["\xDC\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xD7"],
        ["\xDC\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xD8"],
        ["\xDC\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xD9"],
        ["\xDC\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xDA"],
        ["\xDC\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xDB"],
        ["\xDC\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xDC"],
        ["\xDC\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xDD"],
        ["\xDC\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xDE"],
        ["\xDC\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xDF"],
        ["\xDC\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xE0"],
        ["\xDC\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xE1"],
        ["\xDC\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xE2"],
        ["\xDC\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xE3"],
        ["\xDC\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xE4"],
        ["\xDC\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xE5"],
        ["\xDC\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xE6"],
        ["\xDC\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xE7"],
        ["\xDC\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xE8"],
        ["\xDC\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xE9"],
        ["\xDC\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xEA"],
        ["\xDC\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xEB"],
        ["\xDC\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xEC"],
        ["\xDC\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xED"],
        ["\xDC\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xEE"],
        ["\xDC\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xEF"],
        ["\xDC\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xF0"],
        ["\xDC\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xF1"],
        ["\xDC\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xF2"],
        ["\xDC\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xF3"],
        ["\xDC\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xF4"],
        ["\xDC\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xF5"],
        ["\xDC\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xF6"],
        ["\xDC\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xF7"],
        ["\xDC\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xF8"],
        ["\xDC\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xF9"],
        ["\xDC\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xFA"],
        ["\xDC\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xFB"],
        ["\xDC\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9E\xFC"],
        ["\xDD\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x40"],
        ["\xDD\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x41"],
        ["\xDD\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x42"],
        ["\xDD\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x43"],
        ["\xDD\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x44"],
        ["\xDD\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x45"],
        ["\xDD\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x46"],
        ["\xDD\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x47"],
        ["\xDD\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x48"],
        ["\xDD\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x49"],
        ["\xDD\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x4A"],
        ["\xDD\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x4B"],
        ["\xDD\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x4C"],
        ["\xDD\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x4D"],
        ["\xDD\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x4E"],
        ["\xDD\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x4F"],
        ["\xDD\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x50"],
        ["\xDD\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x51"],
        ["\xDD\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x52"],
        ["\xDD\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x53"],
        ["\xDD\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x54"],
        ["\xDD\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x55"],
        ["\xDD\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x56"],
        ["\xDD\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x57"],
        ["\xDD\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x58"],
        ["\xDD\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x59"],
        ["\xDD\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x5A"],
        ["\xDD\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x5B"],
        ["\xDD\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x5C"],
        ["\xDD\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x5D"],
        ["\xDD\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x5E"],
        ["\xDD\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x5F"],
        ["\xDD\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x60"],
        ["\xDD\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x61"],
        ["\xDD\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x62"],
        ["\xDD\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x63"],
        ["\xDD\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x64"],
        ["\xDD\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x65"],
        ["\xDD\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x66"],
        ["\xDD\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x67"],
        ["\xDD\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x68"],
        ["\xDD\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x69"],
        ["\xDD\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x6A"],
        ["\xDD\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x6B"],
        ["\xDD\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x6C"],
        ["\xDD\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x6D"],
        ["\xDD\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x6E"],
        ["\xDD\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x6F"],
        ["\xDD\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x70"],
        ["\xDD\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x71"],
        ["\xDD\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x72"],
        ["\xDD\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x73"],
        ["\xDD\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x74"],
        ["\xDD\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x75"],
        ["\xDD\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x76"],
        ["\xDD\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x77"],
        ["\xDD\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x78"],
        ["\xDD\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x79"],
        ["\xDD\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x7A"],
        ["\xDD\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x7B"],
        ["\xDD\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x7C"],
        ["\xDD\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x7D"],
        ["\xDD\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x7E"],
        ["\xDD\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x80"],
        ["\xDD\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x81"],
        ["\xDD\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x82"],
        ["\xDD\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x83"],
        ["\xDD\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x84"],
        ["\xDD\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x85"],
        ["\xDD\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x86"],
        ["\xDD\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x87"],
        ["\xDD\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x88"],
        ["\xDD\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x89"],
        ["\xDD\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x8A"],
        ["\xDD\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x8B"],
        ["\xDD\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x8C"],
        ["\xDD\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x8D"],
        ["\xDD\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x8E"],
        ["\xDD\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x8F"],
        ["\xDD\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x90"],
        ["\xDD\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x91"],
        ["\xDD\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x92"],
        ["\xDD\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x93"],
        ["\xDD\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x94"],
        ["\xDD\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x95"],
        ["\xDD\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x96"],
        ["\xDD\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x97"],
        ["\xDD\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x98"],
        ["\xDD\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x99"],
        ["\xDD\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x9A"],
        ["\xDD\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x9B"],
        ["\xDD\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x9C"],
        ["\xDD\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x9D"],
        ["\xDD\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x9E"],
        ["\xDE\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\x9F"],
        ["\xDE\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xA0"],
        ["\xDE\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xA1"],
        ["\xDE\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xA2"],
        ["\xDE\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xA3"],
        ["\xDE\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xA4"],
        ["\xDE\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xA5"],
        ["\xDE\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xA6"],
        ["\xDE\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xA7"],
        ["\xDE\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xA8"],
        ["\xDE\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xA9"],
        ["\xDE\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xAA"],
        ["\xDE\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xAB"],
        ["\xDE\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xAC"],
        ["\xDE\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xAD"],
        ["\xDE\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xAE"],
        ["\xDE\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xAF"],
        ["\xDE\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xB0"],
        ["\xDE\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xB1"],
        ["\xDE\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xB2"],
        ["\xDE\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xB3"],
        ["\xDE\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xB4"],
        ["\xDE\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xB5"],
        ["\xDE\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xB6"],
        ["\xC5\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xB7"],
        ["\xDE\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xB8"],
        ["\xDE\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xB9"],
        ["\xDE\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xBA"],
        ["\xDE\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xBB"],
        ["\xDE\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xBC"],
        ["\xDE\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xBD"],
        ["\xDE\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xBE"],
        ["\xDE\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xBF"],
        ["\xDE\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xC0"],
        ["\xDE\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xC1"],
        ["\xDE\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xC2"],
        ["\xDE\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xC3"],
        ["\xDE\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xC4"],
        ["\xDE\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xC5"],
        ["\xDE\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xC6"],
        ["\xDE\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xC7"],
        ["\xDE\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xC8"],
        ["\xDE\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xC9"],
        ["\xDE\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xCA"],
        ["\xDE\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xCB"],
        ["\xDE\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xCC"],
        ["\xDE\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xCD"],
        ["\xDE\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xCE"],
        ["\xDE\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xCF"],
        ["\xDE\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xD0"],
        ["\xDE\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xD1"],
        ["\xDE\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xD2"],
        ["\xDE\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xD3"],
        ["\xDE\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xD4"],
        ["\xDE\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xD5"],
        ["\xDE\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xD6"],
        ["\xDE\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xD7"],
        ["\xDE\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xD8"],
        ["\xDE\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xD9"],
        ["\xDE\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xDA"],
        ["\xDE\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xDB"],
        ["\xDE\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xDC"],
        ["\xDE\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xDD"],
        ["\xDE\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xDE"],
        ["\xDE\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xDF"],
        ["\xDE\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xE0"],
        ["\xDE\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xE1"],
        ["\xDE\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xE2"],
        ["\xDE\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xE3"],
        ["\xDE\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xE4"],
        ["\xDE\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xE5"],
        ["\xDE\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xE6"],
        ["\xDE\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xE7"],
        ["\xDE\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xE8"],
        ["\xDE\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xE9"],
        ["\xDE\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xEA"],
        ["\xDE\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xEB"],
        ["\xDE\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xEC"],
        ["\xDE\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xED"],
        ["\xDE\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xEE"],
        ["\xDE\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xEF"],
        ["\xDE\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xF0"],
        ["\xDE\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xF1"],
        ["\xDE\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xF2"],
        ["\xB4\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xF3"],
        ["\xDE\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xF4"],
        ["\xDE\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xF5"],
        ["\xDE\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xF6"],
        ["\xDE\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xF7"],
        ["\xDE\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xF8"],
        ["\xDE\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xF9"],
        ["\xDE\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xFA"],
        ["\xDE\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xFB"],
        ["\xDE\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9F\xFC"],
        ["\xDF\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x40"],
        ["\xDF\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x41"],
        ["\xDF\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x42"],
        ["\xDF\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x43"],
        ["\xDF\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x44"],
        ["\xDF\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x45"],
        ["\xDF\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x46"],
        ["\xDF\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x47"],
        ["\xDF\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x48"],
        ["\xDF\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x49"],
        ["\xDF\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x4A"],
        ["\xDF\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x4B"],
        ["\xDF\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x4C"],
        ["\xDF\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x4D"],
        ["\xDF\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x4E"],
        ["\xDF\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x4F"],
        ["\xDF\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x50"],
        ["\xDF\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x51"],
        ["\xDF\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x52"],
        ["\xDF\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x53"],
        ["\xDF\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x54"],
        ["\xDF\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x55"],
        ["\xDF\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x56"],
        ["\xDF\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x57"],
        ["\xDF\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x58"],
        ["\xDF\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x59"],
        ["\xDF\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x5A"],
        ["\xDF\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x5B"],
        ["\xDF\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x5C"],
        ["\xDF\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x5D"],
        ["\xDF\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x5E"],
        ["\xDF\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x5F"],
        ["\xDF\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x60"],
        ["\xDF\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x61"],
        ["\xDF\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x62"],
        ["\xDF\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x63"],
        ["\xDF\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x64"],
        ["\xDF\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x65"],
        ["\xDF\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x66"],
        ["\xDF\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x67"],
        ["\xDF\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x68"],
        ["\xDF\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x69"],
        ["\xDF\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x6A"],
        ["\xDF\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x6B"],
        ["\xDF\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x6C"],
        ["\xDF\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x6D"],
        ["\xDF\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x6E"],
        ["\xDF\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x6F"],
        ["\xDF\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x70"],
        ["\xDF\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x71"],
        ["\xDF\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x72"],
        ["\xDF\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x73"],
        ["\xDF\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x74"],
        ["\xDF\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x75"],
        ["\xDF\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x76"],
        ["\xDF\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x77"],
        ["\xDF\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x78"],
        ["\xDF\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x79"],
        ["\xDF\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x7A"],
        ["\xDF\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x7B"],
        ["\xDF\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x7C"],
        ["\xDF\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x7D"],
        ["\xDF\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x7E"],
        ["\xDF\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x80"],
        ["\xDF\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x81"],
        ["\xDF\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x82"],
        ["\xDF\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x83"],
        ["\xDF\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x84"],
        ["\xDF\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x85"],
        ["\xDF\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x86"],
        ["\xDF\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x87"],
        ["\xDF\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x88"],
        ["\xDF\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x89"],
        ["\xDF\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x8A"],
        ["\xDF\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x8B"],
        ["\xDF\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x8C"],
        ["\xDF\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x8D"],
        ["\xDF\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x8E"],
        ["\xDF\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x8F"],
        ["\xDF\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x90"],
        ["\xDF\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x91"],
        ["\xDF\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x92"],
        ["\xDF\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x93"],
        ["\xDF\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x94"],
        ["\xDF\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x95"],
        ["\xDF\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x96"],
        ["\xDF\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x97"],
        ["\xDF\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x98"],
        ["\xDF\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x99"],
        ["\xDF\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x9A"],
        ["\xDF\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x9B"],
        ["\xDF\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x9C"],
        ["\xDF\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x9D"],
        ["\xDF\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x9E"],
        ["\xE0\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\x9F"],
        ["\xE0\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xA0"],
        ["\xE0\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\xE0\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\xE0\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\xE0\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\xE0\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\xE0\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\xE0\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\xE0\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\xE0\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\xE0\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\xE0\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\xE0\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xE0\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\xE0\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\xE0\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\xE0\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\xE0\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\xE0\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\xE0\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\xE0\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\xE0\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\xE0\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\xE0\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\xE0\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\xE0\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\xE0\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\xE0\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\xE0\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\xE0\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\xE0\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\xE0\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\xE0\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\xE0\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\xE0\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\xE0\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\xE0\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\xE0\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\xE0\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\xE0\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xE0\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xE0\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\xE0\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\xE0\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\xE0\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\xE0\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\xE0\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\xE0\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\xE0\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\xE0\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\xE0\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\xE0\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\xE0\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\xE0\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\xE0\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\xE0\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\xE0\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\xE0\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\xE0\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\xE0\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\xE0\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\xE0\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\xE0\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\xE0\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\xE0\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\xE0\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\xE0\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\xE0\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\xE0\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\xE0\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\xE0\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\xE0\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\xE0\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\xE0\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\xE0\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\xE0\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\xE0\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\xE0\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\xE0\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\xE0\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\xE0\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\xE0\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xE0\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\xE0\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\x59\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\xE0\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xE0\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\xE0\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xE0\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xE0\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xE0\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\xE0\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\xE0\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\xE1\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x40"],
        ["\xE1\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x41"],
        ["\xE1\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x42"],
        ["\xE1\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x43"],
        ["\xE1\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x44"],
        ["\xE1\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x45"],
        ["\xE1\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x46"],
        ["\xE1\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x47"],
        ["\xE1\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x48"],
        ["\xE1\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x49"],
        ["\xE1\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x4A"],
        ["\xE1\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x4B"],
        ["\xE1\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x4C"],
        ["\xE1\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x4D"],
        ["\xE1\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x4E"],
        ["\xE1\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x4F"],
        ["\xE1\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x50"],
        ["\xE1\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x51"],
        ["\xE1\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x52"],
        ["\xE1\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x53"],
        ["\xE1\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x54"],
        ["\xE1\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x55"],
        ["\xE1\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x56"],
        ["\xE1\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x57"],
        ["\xE1\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x58"],
        ["\xE1\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x59"],
        ["\xE1\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x5A"],
        ["\xE1\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x5B"],
        ["\xE1\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x5C"],
        ["\xE1\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x5D"],
        ["\xE1\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x5E"],
        ["\xE1\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x5F"],
        ["\xE1\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x60"],
        ["\xE1\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x61"],
        ["\xE1\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x62"],
        ["\xE1\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x63"],
        ["\xE1\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x64"],
        ["\xE1\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x65"],
        ["\xE1\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x66"],
        ["\xE1\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x67"],
        ["\xE1\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x68"],
        ["\xE1\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x69"],
        ["\xE1\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x6A"],
        ["\xE1\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x6B"],
        ["\xE1\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x6C"],
        ["\xE1\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x6D"],
        ["\xE1\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x6E"],
        ["\xE1\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x6F"],
        ["\xE1\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x70"],
        ["\xE1\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x71"],
        ["\xE1\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x72"],
        ["\xE1\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x73"],
        ["\xE1\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x74"],
        ["\xE1\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x75"],
        ["\xE1\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x76"],
        ["\xE1\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x77"],
        ["\xE1\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x78"],
        ["\xE1\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x79"],
        ["\xE1\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x7A"],
        ["\xE1\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x7B"],
        ["\xE1\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x7C"],
        ["\xE1\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x7D"],
        ["\xE1\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x7E"],
        ["\xE1\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x80"],
        ["\xE1\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x81"],
        ["\xE1\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x82"],
        ["\xE1\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x83"],
        ["\xE1\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x84"],
        ["\xE1\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x85"],
        ["\xE1\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x86"],
        ["\xE1\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x87"],
        ["\xE1\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x88"],
        ["\xE1\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x89"],
        ["\xE1\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x8A"],
        ["\xE1\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x8B"],
        ["\xE1\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x8C"],
        ["\xE1\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x8D"],
        ["\xE1\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x8E"],
        ["\xE1\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x8F"],
        ["\xE1\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x90"],
        ["\xE1\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x91"],
        ["\xE1\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x92"],
        ["\xE1\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x93"],
        ["\xE1\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x94"],
        ["\xE1\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x95"],
        ["\xE1\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x96"],
        ["\xE1\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x97"],
        ["\xE1\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x98"],
        ["\xE1\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x99"],
        ["\xE1\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x9A"],
        ["\xE1\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x9B"],
        ["\xE1\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x9C"],
        ["\xE1\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x9D"],
        ["\xE1\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x9E"],
        ["\xE2\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\x9F"],
        ["\xE2\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xA0"],
        ["\xE2\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\xE2\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\xE2\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\xE2\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\xE2\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\xE2\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\xE2\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\xE2\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\xE2\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\xE2\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\xE2\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\xE2\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\xE2\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\xE2\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\xE2\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\xE2\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\xE2\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\xE2\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\xE2\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\xE2\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\xE2\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\xE2\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\xE2\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\xE2\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\xE2\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\xE2\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\xE2\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\xE2\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\xE2\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\xE2\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\xE2\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\xE2\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\xE2\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\xE2\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\xE2\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\xE2\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\xE2\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\xE2\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\xE2\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\xE2\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\xE2\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\xE2\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\xE2\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\xE2\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\xE2\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\xE2\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\xE2\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\xE2\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\xE2\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\xE2\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\xE2\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\xE2\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\xE2\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\xE2\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\xE2\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\xE2\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\xE2\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\xE2\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\xE2\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\xE2\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\xE2\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\xE2\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\xE2\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\xE2\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\xE2\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\xE2\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\xE2\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\xE2\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\xE2\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\xB9\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\xE2\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\xC5\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\xE2\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\xE2\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\xE2\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\xE2\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\xE2\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\xE2\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\xE2\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\xE2\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\xE2\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\xE2\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\xE2\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\xE2\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\xE2\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\xE2\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\xE2\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\xE2\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\xE2\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\xE2\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\xE2\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\xE2\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\xE3\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x40"],
        ["\xE3\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x41"],
        ["\xE3\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x42"],
        ["\xE3\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x43"],
        ["\xE3\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x44"],
        ["\xE3\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x45"],
        ["\xE3\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x46"],
        ["\xE3\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x47"],
        ["\xE3\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x48"],
        ["\xE3\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x49"],
        ["\xE3\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x4A"],
        ["\xE3\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x4B"],
        ["\xE3\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x4C"],
        ["\xE3\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x4D"],
        ["\xE3\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x4E"],
        ["\xE3\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x4F"],
        ["\xE3\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x50"],
        ["\xE3\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x51"],
        ["\xE3\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x52"],
        ["\xE3\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x53"],
        ["\xE3\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x54"],
        ["\xE3\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x55"],
        ["\xE3\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x56"],
        ["\xE3\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x57"],
        ["\xE3\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x58"],
        ["\xE3\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x59"],
        ["\xE3\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x5A"],
        ["\xE3\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x5B"],
        ["\xE3\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x5C"],
        ["\xE3\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x5D"],
        ["\xE3\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x5E"],
        ["\xE3\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x5F"],
        ["\xE3\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x60"],
        ["\xE3\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x61"],
        ["\xE3\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x62"],
        ["\xE3\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x63"],
        ["\xE3\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x64"],
        ["\xE3\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x65"],
        ["\xE3\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x66"],
        ["\xE3\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x67"],
        ["\xE3\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x68"],
        ["\xE3\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x69"],
        ["\xE3\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x6A"],
        ["\xE3\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x6B"],
        ["\xE3\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x6C"],
        ["\xE3\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x6D"],
        ["\xE3\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x6E"],
        ["\xE3\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x6F"],
        ["\xE3\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],
        ["\xE3\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],
        ["\xE3\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],
        ["\xE3\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],
        ["\xE3\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],
        ["\xE3\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],
        ["\xE3\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],
        ["\xE3\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],
        ["\xE3\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],
        ["\xE3\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],
        ["\xE3\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],
        ["\xE3\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],
        ["\xE3\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\xB3\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],
        ["\xE3\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],
        ["\xE3\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],
        ["\xE3\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x81"],
        ["\xE3\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x82"],
        ["\xE3\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x83"],
        ["\xE3\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x84"],
        ["\xE3\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x85"],
        ["\xE3\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x86"],
        ["\xE3\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x87"],
        ["\xE3\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x88"],
        ["\xE3\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x89"],
        ["\xE3\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A"],
        ["\xE3\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B"],
        ["\xE3\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C"],
        ["\xE3\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x8D"],
        ["\xE3\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x8E"],
        ["\xE3\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F"],
        ["\xE3\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x90"],
        ["\xE3\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x91"],
        ["\xE3\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x92"],
        ["\xE3\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x93"],
        ["\xE3\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x94"],
        ["\xE3\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x95"],
        ["\xE3\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x96"],
        ["\xE3\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x97"],
        ["\xE3\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x98"],
        ["\xE3\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x99"],
        ["\xE3\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x9A"],
        ["\xE3\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x9B"],
        ["\xE3\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x9C"],
        ["\xE3\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D"],
        ["\xE3\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x9E"],
        ["\xE4\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\x9F"],
        ["\xE4\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xA0"],
        ["\xE4\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\xE4\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\xE4\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\xE4\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\xE4\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\xE4\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\xE4\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\xE4\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\xE4\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\xE4\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\xE4\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\xE4\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\xE4\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\xE4\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\xE4\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\xE4\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\xE4\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\xE4\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\xE4\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\xE4\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\xE4\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\xE4\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\xE4\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\xE4\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\xE4\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\xE4\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\xE4\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\xE4\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\xE4\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\xE4\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\xE4\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\xE4\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\xE4\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\xE4\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\xE4\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\xCF\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\xE4\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\xE4\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\xE4\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\xE4\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\xE4\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\xE4\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\xE4\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\xE4\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\xE4\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\xE4\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\xE4\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\xE4\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\xE4\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\xE4\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\xE4\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\xE4\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\xE4\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\xE4\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\xE4\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\xE4\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\xE4\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\xE4\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\xE4\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\xE4\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\xE4\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\xE4\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\xE4\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\xE4\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xE4\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\xE4\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xE4\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xE4\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xE4\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xE4\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xE4\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xE4\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xE4\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xE4\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\xE4\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\xE4\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\xE4\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\xE4\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\xE4\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\xE4\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xE4\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xE4\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xE4\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xE4\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xE4\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xE4\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xE4\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xE4\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xE4\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xE4\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\xE4\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\xE4\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\xE5\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x40"],
        ["\xE5\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x41"],
        ["\xE5\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x42"],
        ["\xE5\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x43"],
        ["\xE5\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x44"],
        ["\xE5\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x45"],
        ["\xE5\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x46"],
        ["\xE5\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x47"],
        ["\xE5\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x48"],
        ["\xE5\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x49"],
        ["\xE5\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x4A"],
        ["\xE5\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x4B"],
        ["\xE5\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x4C"],
        ["\xE5\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x4D"],
        ["\xE5\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x4E"],
        ["\xE5\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x4F"],
        ["\xE5\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x50"],
        ["\xE5\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x51"],
        ["\xE5\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x52"],
        ["\xE5\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x53"],
        ["\xE5\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x54"],
        ["\xE5\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x55"],
        ["\xE5\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x56"],
        ["\xE5\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x57"],
        ["\xE5\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x58"],
        ["\xE5\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x59"],
        ["\xE5\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x5A"],
        ["\xE5\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x5B"],
        ["\xE5\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x5C"],
        ["\xE5\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x5D"],
        ["\xE5\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x5E"],
        ["\xE5\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x5F"],
        ["\xE5\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x60"],
        ["\xE5\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x61"],
        ["\xE5\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x62"],
        ["\xE5\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x63"],
        ["\xE5\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x64"],
        ["\xE5\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x65"],
        ["\xE5\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x66"],
        ["\xE5\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x67"],
        ["\xE5\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x68"],
        ["\xE5\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x69"],
        ["\xE5\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x6A"],
        ["\xE5\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x6B"],
        ["\xE5\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x6C"],
        ["\xE5\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x6D"],
        ["\xE5\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x6E"],
        ["\xE5\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x6F"],
        ["\xE5\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x70"],
        ["\xE5\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x71"],
        ["\xE5\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x72"],
        ["\xE5\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x73"],
        ["\xE5\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x74"],
        ["\xE5\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x75"],
        ["\xE5\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x76"],
        ["\xE5\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x77"],
        ["\xE5\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],
        ["\xE5\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x79"],
        ["\xE5\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x7A"],
        ["\xE5\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x7B"],
        ["\xE5\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x7C"],
        ["\xE5\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x7D"],
        ["\xE5\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x7E"],
        ["\xE5\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x80"],
        ["\xE5\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x81"],
        ["\xE5\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x82"],
        ["\xE5\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x83"],
        ["\xE5\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x84"],
        ["\xE5\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x85"],
        ["\xE5\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x86"],
        ["\xE5\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x87"],
        ["\xE5\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x88"],
        ["\xE5\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x89"],
        ["\xE5\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A"],
        ["\xE5\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B"],
        ["\xE5\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C"],
        ["\xE5\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D"],
        ["\xE5\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E"],
        ["\xE5\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F"],
        ["\xE5\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x90"],
        ["\xE5\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x91"],
        ["\xE5\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x92"],
        ["\xE5\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x93"],
        ["\xE5\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x94"],
        ["\xE5\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x95"],
        ["\xE5\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x96"],
        ["\xE5\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x97"],
        ["\xE5\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x98"],
        ["\xE5\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x99"],
        ["\xE5\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x9A"],
        ["\xE5\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x9B"],
        ["\xE5\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x9C"],
        ["\xE5\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D"],
        ["\xE5\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x9E"],
        ["\xE6\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F"],
        ["\xE6\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0"],
        ["\xE6\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\xE6\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\xE6\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\xE6\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\xE6\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\xE6\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\xE6\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\xE6\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\xE6\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\xE6\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\xE6\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\xE6\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\xE6\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\xE6\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\xE6\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\xE6\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\xE6\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\xE6\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\xE6\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\xE6\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\xE6\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\xE6\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\xE6\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\xE6\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\xE6\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\xE6\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\xE6\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\xE6\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\xE6\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\xE6\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\xE6\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\xE6\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\xE6\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\xE6\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\xE6\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\xE6\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\xE6\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\xE6\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\xE6\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\xE6\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\xE6\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\xE6\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\xE6\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\xE6\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\xE6\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\xE6\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\xE6\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\xE6\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\xE6\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\xE6\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\xE6\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\xE6\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\xE6\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\xE6\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\xE6\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\xE6\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\xE6\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\xE6\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\xE6\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\xE6\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\xE6\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\xE6\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\xE6\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\xE6\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\xE6\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\xE6\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\xE6\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\xE6\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xE6\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xE6\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\xE6\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\xE6\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\xE6\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\xE6\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\xE6\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\xE6\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\xE6\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\xE6\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\xE6\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\xE6\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\xE6\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\xE6\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\xE6\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xE6\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\xE6\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\xE6\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\xE6\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xE6\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xE6\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xE6\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\xE6\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\xE6\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\xE7\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x40"],
        ["\xE7\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x41"],
        ["\xE7\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x42"],
        ["\xE7\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x43"],
        ["\xE7\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x44"],
        ["\xE7\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x45"],
        ["\xE7\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x46"],
        ["\xE7\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x47"],
        ["\xE7\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x48"],
        ["\xE7\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x49"],
        ["\xE7\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x4A"],
        ["\xE7\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x4B"],
        ["\xE7\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x4C"],
        ["\xE7\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x4D"],
        ["\xE7\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x4E"],
        ["\xE7\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x4F"],
        ["\xE7\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],
        ["\xE7\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x51"],
        ["\xE7\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x52"],
        ["\xE7\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x53"],
        ["\xE7\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x54"],
        ["\xE7\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x55"],
        ["\xE7\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x56"],
        ["\xE7\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x57"],
        ["\xE7\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x58"],
        ["\xE7\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x59"],
        ["\xE7\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x5A"],
        ["\xE7\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x5B"],
        ["\xE7\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x5C"],
        ["\xE7\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x5D"],
        ["\xE7\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x5E"],
        ["\xE7\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x5F"],
        ["\xE7\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x60"],
        ["\xE7\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x61"],
        ["\xE7\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x62"],
        ["\xE7\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x63"],
        ["\xE7\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x64"],
        ["\xE7\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x65"],
        ["\xE7\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x66"],
        ["\xE7\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x67"],
        ["\xE7\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x68"],
        ["\xE7\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],
        ["\xE7\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x6A"],
        ["\xE7\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x6B"],
        ["\xE7\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x6C"],
        ["\xE7\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x6D"],
        ["\xE7\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x6E"],
        ["\xE7\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x6F"],
        ["\xE7\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x70"],
        ["\xE7\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x71"],
        ["\xE7\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x72"],
        ["\xE7\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x73"],
        ["\xE7\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x74"],
        ["\xE7\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x75"],
        ["\xE7\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x76"],
        ["\xE7\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x77"],
        ["\xE7\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x78"],
        ["\xE7\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x79"],
        ["\xE7\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x7A"],
        ["\xE7\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x7B"],
        ["\xE7\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x7C"],
        ["\xE7\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x7D"],
        ["\xE7\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x7E"],
        ["\xE7\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x80"],
        ["\xE7\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x81"],
        ["\xE7\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x82"],
        ["\xE7\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x83"],
        ["\xE7\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x84"],
        ["\xE7\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x85"],
        ["\xE7\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x86"],
        ["\xE7\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x87"],
        ["\xE7\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x88"],
        ["\xE7\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x89"],
        ["\xE7\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x8A"],
        ["\xE7\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B"],
        ["\xE7\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x8C"],
        ["\xE7\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x8D"],
        ["\xE7\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x8E"],
        ["\xE7\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x8F"],
        ["\xE7\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x90"],
        ["\xE7\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x91"],
        ["\xE7\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x92"],
        ["\xE7\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x93"],
        ["\xE7\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x94"],
        ["\xE7\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x95"],
        ["\xE7\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x96"],
        ["\xE7\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x97"],
        ["\xE7\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x98"],
        ["\xE7\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x99"],
        ["\xE7\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x9A"],
        ["\xE7\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x9B"],
        ["\xE7\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x9C"],
        ["\xE7\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x9D"],
        ["\xE7\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x9E"],
        ["\xE8\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\x9F"],
        ["\xE8\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xA0"],
        ["\xE8\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\xE8\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\xE8\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\xE8\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\xE8\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\xE8\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\xE8\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\xE8\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\xE8\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\xE8\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\xE8\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\xE8\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\xE8\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\xE8\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\xE8\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\xE8\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\xE8\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\xE8\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\xE8\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\xE8\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\xE8\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\xE8\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\xE8\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\xE8\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\xE8\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\xE8\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\xE8\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\xE8\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\xE8\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\xE8\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\xE8\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\xE8\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xE8\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xE8\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xE8\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xE8\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xE8\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xE8\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xE8\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xE8\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xE8\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xE8\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\xE8\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\xE8\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\xE8\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\xE8\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\xE8\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\xE8\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\xE8\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\xE8\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\xE8\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\xE8\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\xE8\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\xE8\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\xE8\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\xE8\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\xE8\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\xE8\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\xE8\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\xE8\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\xE8\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\xE8\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\xE8\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\xE8\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\xE8\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\xE8\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\xE8\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\xE8\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\xE8\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\xE8\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\xE8\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\xE8\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\xE8\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\xE8\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\xE8\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\xE8\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\xE8\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\xE8\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\xE8\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\xE8\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\xE8\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\xE8\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\xE8\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\xE8\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\xE8\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\xE8\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\xE8\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\xE8\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\xE8\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\xE8\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\xE8\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\xE8\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\xE9\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x40"],
        ["\xBC\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x41"],
        ["\xE9\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x42"],
        ["\xE9\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x43"],
        ["\xE9\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x44"],
        ["\xE9\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x45"],
        ["\xE9\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x46"],
        ["\xE9\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x47"],
        ["\xE9\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x48"],
        ["\xE9\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x49"],
        ["\xE9\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x4A"],
        ["\xE9\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x4B"],
        ["\xE9\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x4C"],
        ["\xCC\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x4D"],
        ["\xE9\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x4E"],
        ["\xE9\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x4F"],
        ["\xE9\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x50"],
        ["\xE9\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x51"],
        ["\xE9\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x52"],
        ["\xE9\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x53"],
        ["\xE9\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x54"],
        ["\xE9\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x55"],
        ["\xE9\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x56"],
        ["\xE9\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x57"],
        ["\xE9\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x58"],
        ["\xE9\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x59"],
        ["\xE9\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x5A"],
        ["\xE9\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x5B"],
        ["\xE9\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x5C"],
        ["\xE9\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x5D"],
        ["\xE9\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x5E"],
        ["\xE9\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x5F"],
        ["\xE9\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x60"],
        ["\xE9\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x61"],
        ["\xE9\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x62"],
        ["\xE9\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x63"],
        ["\xE9\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x64"],
        ["\xE9\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x65"],
        ["\xE9\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x66"],
        ["\xE9\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x67"],
        ["\xE9\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x68"],
        ["\xE9\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x69"],
        ["\xE9\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x6A"],
        ["\xE9\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x6B"],
        ["\xE9\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x6C"],
        ["\xE9\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x6D"],
        ["\xE9\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x6E"],
        ["\xE9\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x6F"],
        ["\xE9\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x70"],
        ["\xE9\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x71"],
        ["\xE9\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x72"],
        ["\xE9\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x73"],
        ["\xE9\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x74"],
        ["\xE9\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x75"],
        ["\xE9\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x76"],
        ["\xE9\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x77"],
        ["\xE9\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x78"],
        ["\xB3\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x79"],
        ["\xE9\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x7A"],
        ["\xE9\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x7B"],
        ["\xE9\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x7C"],
        ["\xE9\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x7D"],
        ["\xE9\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x7E"],
        ["\xE9\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x80"],
        ["\xE9\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x81"],
        ["\xE9\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x82"],
        ["\xE9\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x83"],
        ["\xE9\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x84"],
        ["\xE9\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x85"],
        ["\xE9\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x86"],
        ["\xE9\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x87"],
        ["\xE9\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x88"],
        ["\xE9\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x89"],
        ["\xE9\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A"],
        ["\xE9\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B"],
        ["\xE9\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C"],
        ["\xE9\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D"],
        ["\xE9\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E"],
        ["\xE9\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F"],
        ["\xE9\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x90"],
        ["\xE9\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x91"],
        ["\xE9\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x92"],
        ["\xE9\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x93"],
        ["\xE9\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x94"],
        ["\xE9\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x95"],
        ["\xE9\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x96"],
        ["\xE9\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x97"],
        ["\xE9\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x98"],
        ["\xE9\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x99"],
        ["\xE9\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A"],
        ["\xE9\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B"],
        ["\xE9\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C"],
        ["\xE9\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D"],
        ["\xE9\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E"],
        ["\xEA\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F"],
        ["\xEA\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0"],
        ["\xEA\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\xC7\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\xEA\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\xEA\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\xEA\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\xEA\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\xEA\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\xEA\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\xEA\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\xEA\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\xEA\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\xEA\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\xEA\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\xEA\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\xEA\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\xEA\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\xEA\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\xEA\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\xEA\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\xEA\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\xEA\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\xEA\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\xEA\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\xEA\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\xEA\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\xEA\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\xEA\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\xEA\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\xEA\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\xEA\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\xEA\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\xEA\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\xEA\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\xEA\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\xEA\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\xEA\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\xEA\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\xEA\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\xEA\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\xEA\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\xEA\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\xEA\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\xEA\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\xEA\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\xEA\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\xEA\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\xEA\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\xEA\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\xEA\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\xEA\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\xEA\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\xEA\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\xEA\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\xEA\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\xEA\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\xEA\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\xEA\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\xEA\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\xEA\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\xEA\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\xEA\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\xEA\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\xEA\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\xEA\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\xEA\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\xEA\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\xEA\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\xEA\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\xEA\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\xEA\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\xEA\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\xEA\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\xEA\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\xEA\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\xEA\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\xEA\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\xEA\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\xEA\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\xEA\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\xEA\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\xEA\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\xEA\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\xEA\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\xEA\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\xEA\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\xEA\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\xEA\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\xEA\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\xEA\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\xEA\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\xEA\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\xEA\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\xEB\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x40"],
        ["\xEB\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x41"],
        ["\xEB\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x42"],
        ["\xEB\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x43"],
        ["\xEB\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x44"],
        ["\xEB\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x45"],
        ["\xEB\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x46"],
        ["\xEB\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x47"],
        ["\xEB\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x48"],
        ["\xEB\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x49"],
        ["\xEB\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x4A"],
        ["\xEB\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x4B"],
        ["\xEB\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x4C"],
        ["\xEB\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x4D"],
        ["\xEB\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x4E"],
        ["\xEB\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x4F"],
        ["\xEB\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x50"],
        ["\xEB\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x51"],
        ["\xEB\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x52"],
        ["\xEB\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x53"],
        ["\xEB\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x54"],
        ["\xEB\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x55"],
        ["\xEB\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x56"],
        ["\xEB\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x57"],
        ["\xEB\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x58"],
        ["\xEB\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x59"],
        ["\xEB\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x5A"],
        ["\xEB\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x5B"],
        ["\xEB\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x5C"],
        ["\xEB\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x5D"],
        ["\xEB\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x5E"],
        ["\xEB\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x5F"],
        ["\xEB\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x60"],
        ["\xEB\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x61"],
        ["\xEB\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x62"],
        ["\xEB\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x63"],
        ["\xEB\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x64"],
        ["\xEB\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x65"],
        ["\xEB\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x66"],
        ["\xEB\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x67"],
        ["\xEB\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x68"],
        ["\xEB\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x69"],
        ["\xEB\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x6A"],
        ["\xEB\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x6B"],
        ["\xEB\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x6C"],
        ["\xEB\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x6D"],
        ["\xEB\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x6E"],
        ["\xEB\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x6F"],
        ["\xEB\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x70"],
        ["\xEB\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x71"],
        ["\xEB\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x72"],
        ["\xEB\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x73"],
        ["\xEB\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x74"],
        ["\xEB\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x75"],
        ["\xEB\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x76"],
        ["\xEB\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x77"],
        ["\xEB\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x78"],
        ["\xEB\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x79"],
        ["\xEB\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x7A"],
        ["\xEB\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x7B"],
        ["\xB4\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x7C"],
        ["\xEB\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x7D"],
        ["\xEB\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x7E"],
        ["\xEB\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x80"],
        ["\xEB\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x81"],
        ["\xEB\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x82"],
        ["\xEB\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x83"],
        ["\xEB\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x84"],
        ["\xEB\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x85"],
        ["\xEB\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x86"],
        ["\xEB\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x87"],
        ["\xEB\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x88"],
        ["\xEB\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x89"],
        ["\xEB\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A"],
        ["\xEB\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B"],
        ["\xEB\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C"],
        ["\xEB\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D"],
        ["\xEB\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E"],
        ["\xEB\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F"],
        ["\xEB\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x90"],
        ["\xEB\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x91"],
        ["\xEB\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x92"],
        ["\xEB\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x93"],
        ["\xEB\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x94"],
        ["\xEB\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x95"],
        ["\xEB\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x96"],
        ["\xEB\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x97"],
        ["\xEB\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x98"],
        ["\xEB\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x99"],
        ["\xEB\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A"],
        ["\xEB\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B"],
        ["\xEB\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C"],
        ["\xEB\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D"],
        ["\xEB\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E"],
        ["\xEC\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F"],
        ["\xEC\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0"],
        ["\xEC\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\xEC\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],
        ["\xEC\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],
        ["\xEC\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],
        ["\xEC\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],
        ["\xEC\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\xEC\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\xEC\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\xEC\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\xEC\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],
        ["\xEC\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\xEC\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\xEC\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],
        ["\xEC\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\xEC\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\xEC\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\xEC\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],
        ["\xEC\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],
        ["\xEC\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\xEC\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\xEC\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\xEC\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],
        ["\xEC\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],
        ["\xEC\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\xEC\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\xEC\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\xEC\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],
        ["\xEC\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],
        ["\xEC\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],
        ["\xEC\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],
        ["\xEC\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],
        ["\xEC\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\xEC\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\xEC\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\xEC\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\xEC\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\xEC\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\xEC\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\xEC\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\xEC\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\xEC\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\xEC\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],
        ["\xC1\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],
        ["\xEC\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],
        ["\xEC\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],
        ["\xEC\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],
        ["\xEC\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\xEC\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\xEC\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\xEC\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\xEC\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\xEC\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\xEC\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\xEC\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\xEC\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\xEC\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\xEC\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\xEC\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\xEC\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\xEC\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\xEC\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\xEC\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],
        ["\xEC\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],
        ["\xEC\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\xEC\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],
        ["\xEC\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\xEC\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\xEC\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\xEC\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\xEC\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\xEC\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\xEC\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\xEC\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\xEC\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],
        ["\xEC\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],
        ["\xEC\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],
        ["\xEC\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],
        ["\xEC\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],
        ["\xEC\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\xEC\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\xEC\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\xEC\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\xEC\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\xEC\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\xEC\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\xEC\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xEC\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\xEC\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\xEC\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\xEC\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],
        ["\xEC\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],
        ["\xEC\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],
        ["\xED\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x40"],
        ["\xED\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x41"],
        ["\xED\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x42"],
        ["\xED\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x43"],
        ["\xED\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x44"],
        ["\xED\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x45"],
        ["\xED\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x46"],
        ["\xED\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x47"],
        ["\xED\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x48"],
        ["\xED\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x49"],
        ["\xED\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x4A"],
        ["\xED\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x4B"],
        ["\xED\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x4C"],
        ["\xED\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x4D"],
        ["\xED\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x4E"],
        ["\xED\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x4F"],
        ["\xED\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x50"],
        ["\xED\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x51"],
        ["\xED\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x52"],
        ["\xED\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x53"],
        ["\xED\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x54"],
        ["\xED\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x55"],
        ["\xED\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x56"],
        ["\xED\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x57"],
        ["\xED\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x58"],
        ["\xED\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x59"],
        ["\xED\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x5A"],
        ["\xED\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x5B"],
        ["\xED\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x5C"],
        ["\xED\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x5D"],
        ["\xED\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x5E"],
        ["\xED\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x5F"],
        ["\xED\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x60"],
        ["\xED\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x61"],
        ["\xED\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x62"],
        ["\xED\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x63"],
        ["\xED\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x64"],
        ["\xED\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x65"],
        ["\xED\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x66"],
        ["\xED\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x67"],
        ["\xED\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],
        ["\xED\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x69"],
        ["\xED\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x6A"],
        ["\xED\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x6B"],
        ["\xED\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x6C"],
        ["\xED\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x6D"],
        ["\xED\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x6E"],
        ["\xED\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x6F"],
        ["\xED\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x70"],
        ["\xED\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x71"],
        ["\xED\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x72"],
        ["\xED\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x73"],
        ["\xED\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x74"],
        ["\xED\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x75"],
        ["\xED\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x76"],
        ["\xED\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x77"],
        ["\xED\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x78"],
        ["\xED\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x79"],
        ["\xED\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x7A"],
        ["\xED\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x7B"],
        ["\xED\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x7C"],
        ["\xED\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x7D"],
        ["\xED\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x7E"],
        ["\xED\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x80"],
        ["\xED\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x81"],
        ["\xED\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x82"],
        ["\xED\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x83"],
        ["\xED\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x84"],
        ["\xED\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x85"],
        ["\xED\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x86"],
        ["\xED\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x87"],
        ["\xED\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x88"],
        ["\xED\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x89"],
        ["\xED\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A"],
        ["\xED\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B"],
        ["\xED\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C"],
        ["\xED\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D"],
        ["\xC6\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E"],
        ["\xED\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F"],
        ["\xED\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x90"],
        ["\xED\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x91"],
        ["\xED\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x92"],
        ["\xED\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x93"],
        ["\xED\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x94"],
        ["\xED\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x95"],
        ["\xED\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x96"],
        ["\xED\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x97"],
        ["\xED\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x98"],
        ["\xED\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x99"],
        ["\xED\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A"],
        ["\xED\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B"],
        ["\xED\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C"],
        ["\xED\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D"],
        ["\xED\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E"],
        ["\xEE\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F"],
        ["\xEE\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0"],
        ["\xEE\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\xEE\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],
        ["\xEE\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],
        ["\xEE\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],
        ["\xEE\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],
        ["\xEE\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],
        ["\xEE\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],
        ["\xEE\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],
        ["\xEE\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],
        ["\xEE\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\xEE\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\xEE\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],
        ["\xEE\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],
        ["\xEE\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],
        ["\xEE\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\xEE\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\xEE\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\xEE\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\xEE\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\xEE\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\xEE\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\xEE\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\xEE\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\xEE\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\xEE\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\xEE\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\xEE\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\xEE\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\xEE\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\xEE\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\xEE\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\xEE\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\xEE\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\xEE\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\xEE\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\xEE\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\xEE\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\xEE\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\xEE\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\xEE\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\xEE\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\xEE\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\xEE\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\xEE\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\xEE\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],
        ["\xEE\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],
        ["\xEE\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],
        ["\xEE\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\xEE\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\xEE\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\xEE\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\xEE\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\xEE\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\xEE\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\xEE\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\xEE\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\xEE\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\xEE\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],
        ["\xEE\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],
        ["\xEE\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],
        ["\xEE\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],
        ["\xEE\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],
        ["\xEE\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],
        ["\xEE\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\xEE\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],
        ["\xEE\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\xEE\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\xEE\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\xEE\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\xEE\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\xEE\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\xEE\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\xEE\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\xEE\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],
        ["\xEE\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],
        ["\xEE\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],
        ["\xEE\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],
        ["\xEE\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],
        ["\xEE\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],
        ["\xEE\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\xEE\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\xEE\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\xEE\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\xEE\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\xEE\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\xEE\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\xEE\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\xEE\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\xEE\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\xEE\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],
        ["\xEE\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],
        ["\xEE\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],
        ["\xEF\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x40"],
        ["\xEF\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x41"],
        ["\xEF\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x42"],
        ["\xEF\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x43"],
        ["\xEF\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x44"],
        ["\xEF\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x45"],
        ["\xEF\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x46"],
        ["\xEF\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x47"],
        ["\xEF\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x48"],
        ["\xEF\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x49"],
        ["\xEF\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x4A"],
        ["\xEF\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x4B"],
        ["\xEF\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x4C"],
        ["\xEF\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x4D"],
        ["\xEF\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x4E"],
        ["\xEF\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x4F"],
        ["\xEF\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x50"],
        ["\xEF\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x51"],
        ["\xEF\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x52"],
        ["\xEF\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x53"],
        ["\xEF\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x54"],
        ["\xEF\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x55"],
        ["\xEF\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x56"],
        ["\xEF\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x57"],
        ["\xEF\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x58"],
        ["\xEF\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x59"],
        ["\xEF\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x5A"],
        ["\xEF\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x5B"],
        ["\xEF\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x5C"],
        ["\xEF\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x5D"],
        ["\xEF\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x5E"],
        ["\xEF\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x5F"],
        ["\xEF\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x60"],
        ["\xEF\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x61"],
        ["\xEF\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x62"],
        ["\xEF\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x63"],
        ["\xEF\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x64"],
        ["\xEF\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x65"],
        ["\xEF\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x66"],
        ["\xEF\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x67"],
        ["\xEF\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x68"],
        ["\xEF\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x69"],
        ["\xEF\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x6A"],
        ["\xEF\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x6B"],
        ["\xEF\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x6C"],
        ["\xEF\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x6D"],
        ["\xEF\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x6E"],
        ["\xEF\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x6F"],
        ["\xEF\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x70"],
        ["\xEF\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x71"],
        ["\xEF\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x72"],
        ["\xEF\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x73"],
        ["\xEF\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x74"],
        ["\xEF\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x75"],
        ["\xEF\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x76"],
        ["\xEF\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x77"],
        ["\xEF\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x78"],
        ["\xEF\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x79"],
        ["\xEF\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x7A"],
        ["\xEF\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x7B"],
        ["\xEF\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x7C"],
        ["\xEF\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x7D"],
        ["\xEF\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x7E"],
        ["\xEF\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x80"],
        ["\xEF\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x81"],
        ["\xEF\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x82"],
        ["\xEF\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x83"],
        ["\xEF\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x84"],
        ["\xEF\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x85"],
        ["\xEF\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x86"],
        ["\xEF\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x87"],
        ["\xEF\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x88"],
        ["\xEF\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x89"],
        ["\xEF\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A"],
        ["\xEF\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B"],
        ["\xEF\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C"],
        ["\xEF\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D"],
        ["\xEF\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E"],
        ["\xEF\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F"],
        ["\xEF\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x90"],
        ["\xEF\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x91"],
        ["\xEF\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x92"],
        ["\xEF\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x93"],
        ["\xEF\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x94"],
        ["\xEF\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x95"],
        ["\xEF\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x96"],
        ["\xEF\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x97"],
        ["\xEF\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x98"],
        ["\xEF\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x99"],
        ["\xEF\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A"],
        ["\xEF\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B"],
        ["\xEF\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C"],
        ["\xEF\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D"],
        ["\xEF\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E"],
        ["\xF0\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F"],
        ["\xF0\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0"],
        ["\xF0\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\xF0\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],
        ["\xF0\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],
        ["\xF0\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],
        ["\xF0\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],
        ["\xF0\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],
        ["\xF0\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],
        ["\xF0\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],
        ["\xF0\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],
        ["\xF0\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\xF0\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xF0\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],
        ["\xF0\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],
        ["\xF0\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\xF0\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],
        ["\xF0\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\xF0\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],
        ["\xF0\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\xF0\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],
        ["\xF0\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],
        ["\xF0\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],
        ["\xF0\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],
        ["\xF0\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],
        ["\xF0\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\xF0\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],
        ["\xF0\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],
        ["\xF0\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],
        ["\xF0\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],
        ["\xF0\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],
        ["\xF0\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],
        ["\xF0\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],
        ["\xF0\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\xF0\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\xF0\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\xF0\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\xF0\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\xF0\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\xF0\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\xF0\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\xF0\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\xF0\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\xF0\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],
        ["\xF0\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],
        ["\xF0\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],
        ["\xF0\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],
        ["\xF0\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],
        ["\xF0\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],
        ["\xF0\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\xF0\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\xF0\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\xF0\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\xF0\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\xBF\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\xF0\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\xF0\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\xF0\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xF0\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xF0\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\xF0\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\xF0\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],
        ["\xF0\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],
        ["\xF0\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],
        ["\xF0\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],
        ["\xF0\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\xF0\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],
        ["\xF0\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\xF0\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\xF0\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\xF0\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\xF0\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\xF0\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\xF0\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\xF0\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\xF0\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],
        ["\xF0\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\xF0\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\xF0\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],
        ["\xF0\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],
        ["\xF0\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],
        ["\xF0\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\xF0\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\xB7\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\xF0\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\xF0\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\xF0\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\xF0\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\xF0\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\xF0\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\xF0\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xF0\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\xF0\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\xF0\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],
        ["\xF1\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x40"],
        ["\xF1\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x41"],
        ["\xF1\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x42"],
        ["\xF1\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x43"],
        ["\xF1\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x44"],
        ["\xF1\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x45"],
        ["\xF1\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x46"],
        ["\xF1\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x47"],
        ["\xF1\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x48"],
        ["\xF1\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x49"],
        ["\xF1\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x4A"],
        ["\xF1\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x4B"],
        ["\xF1\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x4C"],
        ["\xF1\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x4D"],
        ["\xF1\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x4E"],
        ["\xF1\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x4F"],
        ["\xF1\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x50"],
        ["\xF1\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x51"],
        ["\xF1\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x52"],
        ["\xF1\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x53"],
        ["\xF1\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x54"],
        ["\xF1\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x55"],
        ["\xF1\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x56"],
        ["\xF1\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x57"],
        ["\xF1\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x58"],
        ["\xF1\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x59"],
        ["\xF1\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x5A"],
        ["\xF1\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x5B"],
        ["\xF1\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x5C"],
        ["\xF1\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x5D"],
        ["\xF1\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x5E"],
        ["\xF1\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x5F"],
        ["\xF1\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x60"],
        ["\xF1\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x61"],
        ["\xF1\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x62"],
        ["\xF1\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x63"],
        ["\xF1\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x64"],
        ["\xF1\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x65"],
        ["\xF1\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x66"],
        ["\xF1\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x67"],
        ["\xF1\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x68"],
        ["\xF1\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x69"],
        ["\xF1\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x6A"],
        ["\xF1\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x6B"],
        ["\xF1\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x6C"],
        ["\xF1\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x6D"],
        ["\xF1\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x6E"],
        ["\xF1\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x6F"],
        ["\xF1\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x70"],
        ["\xF1\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x71"],
        ["\xF1\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x72"],
        ["\xF1\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x73"],
        ["\xF1\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x74"],
        ["\xF1\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x75"],
        ["\xF1\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x76"],
        ["\xF1\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x77"],
        ["\xF1\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x78"],
        ["\xF1\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x79"],
        ["\xF1\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x7A"],
        ["\xF1\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x7B"],
        ["\xF1\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x7C"],
        ["\xF1\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x7D"],
        ["\xF1\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x7E"],
        ["\xF1\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x80"],
        ["\xF1\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x81"],
        ["\xF1\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x82"],
        ["\xF1\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x83"],
        ["\xF1\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x84"],
        ["\xF1\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x85"],
        ["\xF1\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x86"],
        ["\xF1\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x87"],
        ["\xF1\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x88"],
        ["\xF1\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x89"],
        ["\xF1\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A"],
        ["\xF1\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B"],
        ["\xF1\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C"],
        ["\xF1\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D"],
        ["\xF1\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E"],
        ["\xF1\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F"],
        ["\xF1\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x90"],
        ["\xF1\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x91"],
        ["\xF1\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x92"],
        ["\xF1\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x93"],
        ["\xF1\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x94"],
        ["\xF1\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x95"],
        ["\xF1\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x96"],
        ["\xF1\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x97"],
        ["\xF1\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x98"],
        ["\xF1\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x99"],
        ["\xF1\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A"],
        ["\xF1\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B"],
        ["\xF1\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C"],
        ["\xF1\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D"],
        ["\xF1\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E"],
        ["\xF2\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F"],
        ["\xF2\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0"],
        ["\xF2\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\xF2\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],
        ["\xF2\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],
        ["\xF2\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],
        ["\xF2\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],
        ["\xF2\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],
        ["\xF2\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],
        ["\xF2\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],
        ["\xF2\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],
        ["\xF2\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],
        ["\xF2\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\xF2\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],
        ["\xF2\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],
        ["\xF2\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],
        ["\xF2\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],
        ["\xF2\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\xF2\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],
        ["\xF2\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],
        ["\xF2\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],
        ["\xF2\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],
        ["\xF2\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],
        ["\xF2\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],
        ["\xF2\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],
        ["\xF2\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],
        ["\xF2\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],
        ["\xF2\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],
        ["\xF2\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],
        ["\xF2\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],
        ["\xF2\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],
        ["\xF2\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],
        ["\xF2\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],
        ["\xF2\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\xF2\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\xF2\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\xF2\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\xF2\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\xF2\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\xF2\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\xF2\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\xF2\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\xF2\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\xF2\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],
        ["\xB0\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],
        ["\xF2\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],
        ["\xF2\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],
        ["\xF2\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],
        ["\xF2\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],
        ["\xF2\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\xF2\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\xF2\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\xF2\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\xF2\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\xF2\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\xF2\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\xF2\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\xF2\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\xF2\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\xF2\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],
        ["\xF2\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],
        ["\xF2\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],
        ["\xF2\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],
        ["\xF2\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],
        ["\xF2\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],
        ["\xF2\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\xF2\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],
        ["\xF2\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\xF2\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\xF2\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\xF2\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\xF2\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\xF2\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\xF2\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\xF2\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\xF2\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],
        ["\xF2\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],
        ["\xF2\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],
        ["\xF2\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],
        ["\xF2\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],
        ["\xF2\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],
        ["\xF2\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\xF2\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\xB2\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\xF2\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xF2\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\xF2\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\xF2\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\xF2\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\xF2\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\xF2\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\xF2\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],
        ["\xF2\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],
        ["\xF2\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],
        ["\xF3\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x40"],
        ["\xF3\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x41"],
        ["\xF3\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x42"],
        ["\xF3\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x43"],
        ["\xF3\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x44"],
        ["\xF3\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x45"],
        ["\xF3\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x46"],
        ["\xF3\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x47"],
        ["\xF3\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x48"],
        ["\xF3\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x49"],
        ["\xF3\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x4A"],
        ["\xF3\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x4B"],
        ["\xF3\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x4C"],
        ["\xF3\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x4D"],
        ["\xF3\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x4E"],
        ["\xF3\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x4F"],
        ["\xF3\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x50"],
        ["\xF3\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x51"],
        ["\xF3\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x52"],
        ["\xF3\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x53"],
        ["\xF3\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x54"],
        ["\xF3\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x55"],
        ["\xF3\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x56"],
        ["\xF3\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x57"],
        ["\xF3\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x58"],
        ["\xF3\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x59"],
        ["\xF3\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x5A"],
        ["\xF3\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x5B"],
        ["\xF3\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x5C"],
        ["\xF3\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x5D"],
        ["\xF3\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x5E"],
        ["\xF3\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x5F"],
        ["\xF3\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x60"],
        ["\xF3\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x61"],
        ["\xF3\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x62"],
        ["\xF3\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x63"],
        ["\xF3\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x64"],
        ["\xF3\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x65"],
        ["\xF3\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x66"],
        ["\xF3\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x67"],
        ["\xF3\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x68"],
        ["\xF3\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x69"],
        ["\xF3\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x6A"],
        ["\xF3\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x6B"],
        ["\xF3\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x6C"],
        ["\xF3\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x6D"],
        ["\xF3\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x6E"],
        ["\xF3\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x6F"],
        ["\xF3\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x70"],
        ["\xF3\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x71"],
        ["\xF3\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x72"],
        ["\xF3\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x73"],
        ["\xF3\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x74"],
        ["\xF3\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x75"],
        ["\xF3\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x76"],
        ["\xF3\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x77"],
        ["\xF3\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x78"],
        ["\xF3\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x79"],
        ["\xF3\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x7A"],
        ["\xF3\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x7B"],
        ["\xF3\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x7C"],
        ["\xF3\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x7D"],
        ["\xF3\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x7E"],
        ["\xF3\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x80"],
        ["\xF3\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x81"],
        ["\xF3\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x82"],
        ["\xF3\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x83"],
        ["\xF3\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x84"],
        ["\xF3\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x85"],
        ["\xF3\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x86"],
        ["\xF3\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x87"],
        ["\xF3\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x88"],
        ["\xF3\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x89"],
        ["\xF3\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x8A"],
        ["\xF3\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x8B"],
        ["\xF3\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x8C"],
        ["\xF3\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x8D"],
        ["\xF3\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x8E"],
        ["\xF3\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x8F"],
        ["\xF3\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x90"],
        ["\xF3\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x91"],
        ["\xF3\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x92"],
        ["\xF3\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x93"],
        ["\xF3\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x94"],
        ["\xF3\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x95"],
        ["\xF3\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x96"],
        ["\xF3\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x97"],
        ["\xF3\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x98"],
        ["\xF3\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x99"],
        ["\xF3\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x9A"],
        ["\xF3\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x9B"],
        ["\xF3\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x9C"],
        ["\xF3\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x9D"],
        ["\xF3\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x9E"],
        ["\xB6\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\x9F"],
        ["\xCB\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\xA0"],
        ["\xCD\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],
        ["\xE0\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],
        ["\x44\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],
        ["\x58\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],
        ["\x77\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x40"],
        ["\x77\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x41"],
        ["\x77\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x42"],
        ["\x77\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x43"],
        ["\x77\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x44"],
        ["\x77\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x45"],
        ["\x77\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x46"],
        ["\x77\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x47"],
        ["\x77\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x48"],
        ["\x77\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x49"],
        ["\x76\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x55"],
        ["\x76\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x56"],
        ["\x76\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x57"],
        ["\x5F\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x5C"],
        ["\x64\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x5D"],
        ["\x6A\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x5E"],
        ["\x69\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x5F"],
        ["\x62\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x60"],
        ["\x42\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x61"],
        ["\x70\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x62"],
        ["\x51\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x63"],
        ["\x70\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x64"],
        ["\x6A\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x65"],
        ["\x51\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x66"],
        ["\x4C\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x67"],
        ["\x41\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x68"],
        ["\x41\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x69"],
        ["\x43\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x6A"],
        ["\x41\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x6B"],
        ["\x41\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x6C"],
        ["\x41\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x6D"],
        ["\x42\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x6E"],
        ["\x42\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x6F"],
        ["\x42\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x70"],
        ["\x42\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x71"],
        ["\x42\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x72"],
        ["\x42\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x73"],
        ["\x42\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x74"],
        ["\x42\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x75"],
        ["\x43\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x76"],
        ["\x42\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x77"],
        ["\x42\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x78"],
        ["\x42\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x79"],
        ["\x42\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x7A"],
        ["\x42\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x7B"],
        ["\x43\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x7C"],
        ["\x43\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x7D"],
        ["\x43\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x7E"],
        ["\x43\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x80"],
        ["\x43\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x81"],
        ["\x43\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x82"],
        ["\x44\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x83"],
        ["\x44\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x84"],
        ["\x44\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x85"],
        ["\x44\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x86"],
        ["\x44\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x87"],
        ["\x44\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x88"],
        ["\x45\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x89"],
        ["\x45\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x8A"],
        ["\x45\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x8B"],
        ["\x45\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x8C"],
        ["\x45\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x8D"],
        ["\x45\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x8E"],
        ["\x45\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x8F"],
        ["\x45\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x90"],
        ["\x46\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x91"],
        ["\x46\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x92"],
        ["\x46\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x93"],
        ["\x45\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x94"],
        ["\x45\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x95"],
        ["\x48\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x96"],
        ["\x48\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x97"],
        ["\x48\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x98"],
        ["\x47\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x99"],
        ["\x47\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x9A"],
        ["\x48\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x9B"],
        ["\xC4\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x9C"],
        ["\x48\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x9D"],
        ["\x48\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x9E"],
        ["\x48\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\x9F"],
        ["\x48\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xA0"],
        ["\x48\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xA1"],
        ["\x48\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xA2"],
        ["\x48\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xA3"],
        ["\x49\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xA4"],
        ["\x49\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xA5"],
        ["\x49\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xA6"],
        ["\x4A\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xA7"],
        ["\x4A\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xA8"],
        ["\x4A\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xA9"],
        ["\x4A\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xAA"],
        ["\x4A\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xAB"],
        ["\x4A\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xAC"],
        ["\x4A\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xAD"],
        ["\x4B\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xAE"],
        ["\x4A\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xAF"],
        ["\x4B\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xB0"],
        ["\x4B\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xB1"],
        ["\x4B\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xB2"],
        ["\x4B\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xB3"],
        ["\x4B\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xB4"],
        ["\x4B\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xB5"],
        ["\x4B\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xB6"],
        ["\x4C\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xB7"],
        ["\x4C\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xB8"],
        ["\x4D\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xB9"],
        ["\x4D\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xBA"],
        ["\x4D\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xBB"],
        ["\x4D\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xBC"],
        ["\x4E\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xBD"],
        ["\x4D\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xBE"],
        ["\x4E\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xBF"],
        ["\x4E\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xC0"],
        ["\x4E\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xC1"],
        ["\x4E\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xC2"],
        ["\x4E\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xC3"],
        ["\x4E\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xC4"],
        ["\x4E\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xC5"],
        ["\x4E\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xC6"],
        ["\x4E\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xC7"],
        ["\x4F\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xC8"],
        ["\x4F\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xC9"],
        ["\x4F\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xCA"],
        ["\x50\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xCB"],
        ["\x4F\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xCC"],
        ["\x50\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xCD"],
        ["\x51\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xCE"],
        ["\x51\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xCF"],
        ["\xB9\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xD0"],
        ["\x51\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xD1"],
        ["\x51\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xD2"],
        ["\x51\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xD3"],
        ["\x51\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xD4"],
        ["\x51\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xD5"],
        ["\x52\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xD6"],
        ["\x51\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xD7"],
        ["\x51\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xD8"],
        ["\x51\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xD9"],
        ["\x51\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xDA"],
        ["\x51\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xDB"],
        ["\x51\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xDC"],
        ["\x51\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xDD"],
        ["\x52\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xDE"],
        ["\x52\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xDF"],
        ["\x52\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xE0"],
        ["\x70\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xE1"],
        ["\x53\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xE2"],
        ["\x52\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xE3"],
        ["\x53\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xE4"],
        ["\x53\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xE5"],
        ["\x53\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xE6"],
        ["\x70\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xE7"],
        ["\x70\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xE8"],
        ["\x53\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xE9"],
        ["\x70\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xEA"],
        ["\x52\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xEB"],
        ["\x70\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xEC"],
        ["\x70\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xED"],
        ["\x54\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xEE"],
        ["\x52\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xEF"],
        ["\x54\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xF0"],
        ["\x54\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xF1"],
        ["\x54\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xF2"],
        ["\x54\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xF3"],
        ["\x54\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xF4"],
        ["\x55\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xF5"],
        ["\x55\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xF6"],
        ["\x55\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xF7"],
        ["\x55\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xF8"],
        ["\x55\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xF9"],
        ["\x55\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xFA"],
        ["\x56\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xFB"],
        ["\x70\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFA\xFC"],
        ["\x56\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x40"],
        ["\x56\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x41"],
        ["\x56\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x42"],
        ["\x56\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x43"],
        ["\x70\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x44"],
        ["\x55\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x45"],
        ["\x56\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x46"],
        ["\x56\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x47"],
        ["\x56\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x48"],
        ["\x56\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x49"],
        ["\x56\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x4A"],
        ["\x56\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x4B"],
        ["\x57\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x4C"],
        ["\x57\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x4D"],
        ["\x57\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x4E"],
        ["\x57\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x4F"],
        ["\x57\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x50"],
        ["\x57\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x51"],
        ["\x57\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x52"],
        ["\x58\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x53"],
        ["\x58\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x54"],
        ["\x57\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x55"],
        ["\x57\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x56"],
        ["\x57\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x57"],
        ["\x70\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x58"],
        ["\x57\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x59"],
        ["\x58\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x5A"],
        ["\x58\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x5B"],
        ["\x58\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x5C"],
        ["\x58\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x5D"],
        ["\x58\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x5E"],
        ["\x58\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x5F"],
        ["\x59\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x60"],
        ["\x59\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x61"],
        ["\x59\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x62"],
        ["\x59\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x63"],
        ["\x5A\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x64"],
        ["\x59\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x65"],
        ["\x59\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x66"],
        ["\x59\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x67"],
        ["\x59\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x68"],
        ["\x59\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x69"],
        ["\x59\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x6A"],
        ["\x5A\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x6B"],
        ["\x59\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x6C"],
        ["\x59\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x6D"],
        ["\x5A\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x6E"],
        ["\x5A\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x6F"],
        ["\x5A\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x70"],
        ["\x5B\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x71"],
        ["\x5B\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x72"],
        ["\x5A\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x73"],
        ["\x5B\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x74"],
        ["\x5B\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x75"],
        ["\x5B\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x76"],
        ["\x44\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x77"],
        ["\x5B\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x78"],
        ["\x5C\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x79"],
        ["\x5C\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x7A"],
        ["\x5C\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x7B"],
        ["\x5C\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x7C"],
        ["\x70\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x7D"],
        ["\x5C\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x7E"],
        ["\x5C\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x80"],
        ["\x5C\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x81"],
        ["\x5C\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x82"],
        ["\x5C\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x83"],
        ["\x5D\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x84"],
        ["\x5D\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x85"],
        ["\x5D\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x86"],
        ["\x5D\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x87"],
        ["\x5E\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x88"],
        ["\x5E\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x89"],
        ["\x5E\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x8A"],
        ["\x5E\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x8B"],
        ["\x5F\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x8C"],
        ["\x5F\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x8D"],
        ["\x5F\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x8E"],
        ["\x5F\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x8F"],
        ["\x5F\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x90"],
        ["\x5F\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x91"],
        ["\x60\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x92"],
        ["\x61\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x93"],
        ["\x70\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x94"],
        ["\x61\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x95"],
        ["\x61\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x96"],
        ["\x62\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x97"],
        ["\x70\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x98"],
        ["\x70\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x99"],
        ["\x62\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x9A"],
        ["\x62\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x9B"],
        ["\x62\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x9C"],
        ["\x62\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x9D"],
        ["\x62\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x9E"],
        ["\x70\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\x9F"],
        ["\x63\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xA0"],
        ["\x63\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xA1"],
        ["\x63\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xA2"],
        ["\x64\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xA3"],
        ["\x64\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xA4"],
        ["\x64\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xA5"],
        ["\x65\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xA6"],
        ["\x6B\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xA7"],
        ["\x65\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xA8"],
        ["\x65\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xA9"],
        ["\x65\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xAA"],
        ["\x65\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xAB"],
        ["\x65\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xAC"],
        ["\x66\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xAD"],
        ["\x65\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xAE"],
        ["\x65\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xAF"],
        ["\x66\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xB0"],
        ["\x66\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xB1"],
        ["\x66\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xB2"],
        ["\x70\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xB3"],
        ["\x70\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xB4"],
        ["\x70\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xB5"],
        ["\x68\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xB6"],
        ["\x68\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xB7"],
        ["\x68\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xB8"],
        ["\x68\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xB9"],
        ["\x69\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xBA"],
        ["\x69\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xBB"],
        ["\x69\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xBC"],
        ["\x69\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xBD"],
        ["\x69\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xBE"],
        ["\x69\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xBF"],
        ["\x69\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xC0"],
        ["\x69\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xC1"],
        ["\x69\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xC2"],
        ["\x69\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xC3"],
        ["\x69\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xC4"],
        ["\x69\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xC5"],
        ["\x69\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xC6"],
        ["\x69\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xC7"],
        ["\x69\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xC8"],
        ["\x69\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xC9"],
        ["\x69\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xCA"],
        ["\x6B\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xCB"],
        ["\x6A\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xCC"],
        ["\x69\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xCD"],
        ["\x69\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xCE"],
        ["\x6A\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xCF"],
        ["\x6A\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xD0"],
        ["\x6A\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xD1"],
        ["\x6A\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xD2"],
        ["\x6B\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xD3"],
        ["\x6A\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xD4"],
        ["\x6A\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xD5"],
        ["\x6A\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xD6"],
        ["\x6A\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xD7"],
        ["\x6A\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xD8"],
        ["\x69\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xD9"],
        ["\x6B\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xDA"],
        ["\x6A\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xDB"],
        ["\x6A\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xDC"],
        ["\x6A\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xDD"],
        ["\x6A\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xDE"],
        ["\x6A\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xDF"],
        ["\x6A\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xE0"],
        ["\x6A\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xE1"],
        ["\x6A\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xE2"],
        ["\x6B\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xE3"],
        ["\x6B\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xE4"],
        ["\x6B\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xE5"],
        ["\x6B\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xE6"],
        ["\x6B\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xE7"],
        ["\x6B\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xE8"],
        ["\x68\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xE9"],
        ["\x68\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xEA"],
        ["\x68\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xEB"],
        ["\x68\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xEC"],
        ["\x6C\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xED"],
        ["\x6C\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xEE"],
        ["\x6C\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xEF"],
        ["\x6C\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xF0"],
        ["\x6C\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xF1"],
        ["\x6C\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xF2"],
        ["\x6C\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xF3"],
        ["\x6C\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xF4"],
        ["\x6C\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xF5"],
        ["\x6D\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xF6"],
        ["\x6D\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xF7"],
        ["\x6D\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xF8"],
        ["\x6D\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xF9"],
        ["\x5C\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xFA"],
        ["\x6D\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xFB"],
        ["\x6E\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFB\xFC"],
        ["\x6E\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFC\x40"],
        ["\x6E\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFC\x41"],
        ["\x6E\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFC\x42"],
        ["\x6E\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFC\x43"],
        ["\x6E\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFC\x44"],
        ["\x6E\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFC\x45"],
        ["\x6E\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFC\x46"],
        ["\x6F\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFC\x47"],
        ["\x6F\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFC\x48"],
        ["\x6F\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFC\x49"],
        ["\x6F\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFC\x4A"],
        ["\x6F\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\xFC\x4B"],
        ["\x76\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x76\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x76\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x76\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x76\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x76\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x76\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x76\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x78\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x76\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x76\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x76\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x76\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x76\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x76\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x79\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x45\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x45\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x45\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x45\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x45\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xC5\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4A\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4A\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4A\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xD7\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x9C\x5A"],
        ["\x4C\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x67\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x67\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x67\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x67\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x67\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x67\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x67\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x67\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x67\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x69\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x69\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x69\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x69\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6A\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6A\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6A\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6A\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x69\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x69\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6A\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x69\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6C\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6C\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6C\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6C\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6C\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6C\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6C\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6C\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xC5\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6C\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6C\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6D\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6D\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6D\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6D\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6D\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6D\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6D\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6D\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6D\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xB9\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xCC\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x70\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x70\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x70\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x41\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x42\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4A\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4A\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4A\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4A\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4A\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4A\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4A\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4A\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4B\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x44\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x45\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x45\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x45\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x45\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xAC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x45\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x46\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x47\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x48\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x49\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4A\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4A\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4C\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4D\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4E\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x4F\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x50\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xA5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x51\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x53\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x54\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x55\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x56\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xE4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x57\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x72\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x58\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xCD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x59\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xC9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xED",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5A\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xE5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xF6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5B\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x72\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xF2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5C\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xBD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xC3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xD5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xE2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5D\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xA2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xB5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xD4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xEA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xF9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5E\xFC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xB3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xB8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xE7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x5F\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xB0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xC6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xB7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xC4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x52\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x60\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xDD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x61\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xA4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xAD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xAE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xB2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xB4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xB6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xCB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xD0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xE6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xEE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x62\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xC5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xC8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xCE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xDB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xF0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x63\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xC7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xE3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xEB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xF1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xF7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xB1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xB9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xC1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xBF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xC2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x64\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xD2",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xD3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xD8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xDA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xE0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x65\xFB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xA6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xBC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xBE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xC0",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xCC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x66\xD6",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x67\xD9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x69\xF3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6A\xA1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6A\xA3",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6A\xEC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6B\xDE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xBA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x68\xCA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6C\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6D\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xCF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xD1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xDC",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xE1",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xE9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xF4",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xF8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xFA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6E\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xA7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xA8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xA9",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xAA",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xAB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xAF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xBB",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xD7",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xDF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xE8",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xEF",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xF5",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xFD",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x6F\xFE",'cp932ibm','jef9p',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        my @option_content = ();
        push(@option_content, qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}})        if exists $option->{'INPUT_LAYOUT'};
        push(@option_content, qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}})  if exists $option->{'OUTPUT_SHIFTING'};
        push(@option_content, qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}}) if exists $option->{'SPACE'};
        push(@option_content, qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}})   if exists $option->{'GETA'};
        $option_content = "{@option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
