package Acme::Insult::Pirate 1.0 {
    use v5.38;
    use HTTP::Tiny;

    #~ use JSON::Tiny qw[decode_json]; # Not needed here (yet)
    use URI;
    use parent 'Exporter';
    our %EXPORT_TAGS = ( all => [ our @EXPORT_OK = qw[insult] ] );
    #
    use overload '""' => sub ( $s, $u, $b ) { $s->{insult} // () };
    #
    sub _http (%params) {
        state $http
            //= HTTP::Tiny->new( default_headers => { Accept => 'application/json' }, agent => sprintf '%s/%.2f ', __PACKAGE__, our $VERSION );
        state $api //= URI->new('https://pirate.monkeyness.com/api/insult');

        #~ $api->query_form( %params );
        my $res = $http->get($api);    # {success} is true even when advice is not found but we'll at least know when we have valid JSON

        # This API only returns strings for now
        #~ $res->{success} ? decode_json( $res->{content} ) : ();
        $res->{success} ? { insult => $res->{content} } : ();
    }
    #
    sub insult (%args) { my $ref = _http(%args); $ref ? bless $ref, __PACKAGE__ : $ref }
}
1;
__END__

=encoding utf-8

=head1 NAME

Acme::Insult::Pirate - Programmatically Generate Pirate Themed Insults

=head1 SYNOPSIS

    use Acme::Insult::Pirate qw[insult];
    say insult( ); # stringify

=head1 DESCRIPTION

Acme::Insult::Pirate provides pirate themed 'insulting' statements generated by the Pirate Monkeyness Pirate Insult
API.

=head1 METHODS

These functions may be imported by name or wit' the C<:all> tag.

=head2 C<insult( [...] )>

Arr! Tear some rogue down.

    my $shade = insult( ); # Random insult
    print insult( ); # stringify

On success, an insult be returned as a blessed hash reference containin' the followin' data:

=over

=item C<insult>

The line ye best be throwin' at a scallywag.

=back

=head1 LICENSE & LEGAL

Copyright (C) Sanko Robinson.

This library is free software; you can redistribute it and/or modify it under the terms found in the Artistic License
2. Other copyrights, terms, and conditions may apply to data transmitted through this module.

Insults are generated by the L<Pirate Monkeyness Insult API|https://pirate.monkeyness.com/api.html>.

=head1 AUTHOR

Sanko Robinson E<lt>sanko@cpan.orgE<gt>

=head2 ...but why?

I'm inflicting this upon the world because L<oodler577|https://github.com/oodler577/> invited me to help expand Perl's
coverage of smaller open APIs. Blame them or L<join us|https://github.com/oodler577/FreePublicPerlAPIs> in the effort.

=cut
