use strict;
use warnings;
use Test::More;
use lib qw(./lib ./blib/lib);
require './t/600-lhost-code';

my $enginename = 'V5sendmail';
my $samplepath = sprintf("./set-of-emails/private/lhost-%s", lc $enginename);
my $enginetest = Sisimai::Lhost::Code->makeinquiry;
my $isexpected = {
    # INDEX => [['D.S.N.', 'replycode', 'REASON', 'hardbounce', 'toxic'], [...]]
    '1001'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1002'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]], # invalid domain name
    '1003'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1004'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1005'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1006'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1007'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1008'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1009'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1]],
    '1010'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1011'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1012'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1013'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1014'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1015'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1016'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1017'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1018'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1019'  => [['5.9.210', '550', 'filtered',        0, 1]],
    '1020'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1021'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1022'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1023'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1024'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1025'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1026'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],  # invalid domain name
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1027'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1028'  => [['5.9.133', '550', 'requireptr',      0, 0],
                ['5.9.213', '550', 'userunknown',     1, 1]],
    '1029'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1030'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1031'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1032'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1033'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1034'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1035'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1036'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1]],
    '1037'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1038'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1]],
    '1039'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1040'  => [['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1041'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1042'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1043'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1044'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1045'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1046'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1047'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1048'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1049'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1050'  => [['5.9.134', '553', 'blocked',         0, 0]],
    '1051'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]], # invalid domain name
    '1052'  => [['5.9.231', '550', 'systemerror',     0, 0],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1]],
    '1053'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1054'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1]],
    '1055'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1056'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1057'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1058'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1059'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1060'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1061'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1064'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1065'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1066'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.7.1',   '550', 'norelaying',      0, 1]],
    '1067'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1068'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1069'  => [['5.9.210', '550', 'filtered',        0, 1]],
    '1071'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1072'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1]],
    '1073'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1074'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1075'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1076'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1077'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1078'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1079'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1080'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1081'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1082'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1083'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1084'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1085'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1086'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1087'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1088'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1089'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1090'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1091'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1092'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1093'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1094'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1095'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1096'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1097'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1]],
    '1098'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1100'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1101'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1102'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1103'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1104'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1105'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1106'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1]],
    '1107'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1108'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1109'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1110'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1111'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1112'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1113'  => [['4.5.134', '421', 'blocked',         0, 0]],
    '1114'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1115'  => [['4.9.341', '421', 'networkerror',    0, 0]],
    '1116'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1117'  => [['4.9.133', '421', 'requireptr',      0, 0]],
    '1118'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1119'  => [['4.9.340', '421', 'expired',         0, 0]],
    '1120'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1121'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1122'  => [['4.5.134', '421', 'blocked',         0, 0]],
    '1123'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1124'  => [['4.9.340', '421', 'expired',         0, 0]],
    '1125'  => [['4.9.340', '421', 'expired',         0, 0]],
    '1126'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1127'  => [['4.9.340', '421', 'expired',         0, 0]],
    '1128'  => [['5.9.214', '550', 'norelaying',      0, 1]],
    '1129'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1130'  => [['4.9.340', '421', 'expired',         0, 0]],
    '1131'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1132'  => [['5.9.210', '550', 'filtered',        0, 1]],
    '1133'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1134'  => [['4.9.340', '421', 'expired',         0, 0]],
    '1135'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1136'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1137'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1138'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1139'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1140'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1]],
    '1141'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1142'  => [['5.9.213', '550', 'userunknown',     1, 1]],
    '1143'  => [['5.9.212', '550', 'hostunknown',     1, 1]],
    '1144'  => [['5.9.213', '550', 'userunknown',     1, 1],
                ['5.9.212', '550', 'hostunknown',     1, 1],
                ['5.9.213', '550', 'userunknown',     1, 1]],
};

plan 'skip_all', sprintf("%s not found", $samplepath) unless -d $samplepath;
$enginetest->($enginename, $isexpected, 1, 0);
done_testing;

