/*
    SPDX-License-Identifier: MPL-2.0
*/

/* Copyright (c) 2015 Brian R. Bondy. Distributed under the MPL2 license.
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#pragma once
/**
  *
  * Auto generated bad filters
  */
const char *badFingerprints[] = {
"ttp://",
"/walma",
"/micro",
".com/a",
"/ajax/",
"/jQuer",
"/jquer",
".mobil",
".com/l",
"/libra",
"/broke",
"/accou",
"ttps:/",
"/asset",
"/commo",
"/respo",
"/style",
"/js/sh",
"/gener",
"/store",
"/scrip",
"/Stati",
"/Commo",
"/js/li",
"/produ",
".com/s",
"/stati",
"static",
".com/j",
"/light",
"/homep",
"/site/",
"/class",
"/css/a",
"social",
"/socia",
"/playe",
".com/v",
"/serve",
".googl",
"google",
".com/p",
"/pagea",
"/conve",
"/widge",
".org/e",
"/tag/j",
".com/g",
".com/m",
"_widge",
"/googl",
"g.doub",
"double",
"search",
".com/b",
"/beaco",
".org/a",
"/provi",
"/gpt/p",
"/pubad",
"pubads",
".js?ca",
"&callb",
"politi",
"-sourc",
"-show-",
"/gampa",
"=728x9",
"/html/",
".net/p",
"_300x2",
"300x25",
"-300x2",
"/clien",
".min.j",
"yahoo.",
"/zz/co",
"/combo",
"/media",
"/conte",
"/p/com",
"classi",
"/ads/a",
"/ads-m",
"yimg.c",
"-conte",
"_index",
"/news/",
"/overl",
"/skins",
"/theme",
"-image",
"-searc",
"_searc",
"/css/s",
"/css/t",
"/event",
"/selec",
"/plugi",
"/track",
"/image",
"/heade",
"/toolb",
"/check",
"/rq/da",
"/darla",
"/metro",
"/defau",
"/deskt",
"/strea",
"stream",
"_site_",
"/build",
"video.",
"/video",
"/publi",
"-scrol",
"/inter",
"/instr",
"upload",
"-ifram",
"-promo",
"-skin-",
"/color",
".adser",
"/jsonp",
"/trans",
"/galle",
"/modul",
"_platf",
"/resou",
"/useri",
"/badge",
"/stora",
"/view/",
"/view-",
"/templ",
"-templ",
"-load-",
"&l=VID",
"video-",
"/banne",
"banner",
"/secur",
"/creat",
"creati",
"sticke",
"_yahoo",
"/deliv",
"/js/ga",
"/logo_",
"/local",
"/js/be",
"/js/to",
"/top_b",
"/home_",
"/searc",
"/js/se",
"/movie",
"/previ",
"/foote",
"/share",
"/exter",
"_ifram",
"/faceb",
".com/?",
"://ad.",
"/ads?a",
"/ifram",
"/doubl",
"ad.dou",
"/index",
"/ad_da",
"hosted",
"/custo",
"/ads/c",
".com/i",
"/embed",
"/ad_st",
"/gadge",
"/yahoo",
"/route",
"-galle",
"-foote",
"/yfpad",
".php?c",
"/newfo",
"/dp.ht",
"/world",
"/globa",
"/layou",
"-floor",
"/skin/",
"/disco",
"?modul",
"/utils",
"/compo",
"/contr",
"/conta",
"/exten",
"/json/",
"/proce",
"/recom",
"&type=",
"/mini-",
"_repor",
"/bundl",
"/front",
"/analy",
"/live.",
".com/d",
".html?",
"/amazo",
"amazon",
"images",
"_engin",
"//imag",
"/redir",
"/Clien",
"-adsys",
"_adcon",
"walmar",
"redire",
"micros",
"jQuery",
"jquery",
"mobile",
"com/li",
"librar",
"broker",
"tp://c",
"accoun",
"tps://",
"assets",
"common",
"respon",
"genera",
"store/",
"script",
"tatic/",
"Common",
"produc",
"com/js",
"homepa",
"ocial/",
"tp://p",
"player",
"serve/",
"ooglea",
"adserv",
"pagead",
"conver",
"widget",
"tag/js",
"oogle-",
"analyt",
"com/ga",
"tp://j",
"serve.",
".doubl",
"oublec",
"earch.",
"beacon",
"storag",
"provid",
"gpt/pu",
"js?cal",
"callba",
"defaul",
"recomm",
"olitic",
"source",
"secure",
"ubads.",
"gampad",
"728x90",
"oogle.",
"client",
"00x250",
"contro",
"bundle",
"min.js",
"tp://l",
"zz/com",
"combo?",
"styles",
"media/",
"conten",
"deskto",
"ads/ad",
"ads-mi",
"img.co",
"index/",
"generi",
"overla",
"skins/",
"share-",
"themes",
"earch/",
"earch-",
"css/sk",
"custom",
"select",
"style/",
"plugin",
"report",
"imagel",
"header",
"toolba",
"rq/dar",
"darla/",
"theme/",
"build/",
"public",
"Client",
"scroll",
"iframe",
"events",
"constr",
"jsonp/",
"galler",
"contri",
"module",
"platfo",
"resour",
"badge_",
"view/a",
"templa",
"treams",
"ideo-a",
"video/",
"view/t",
"publis",
"reativ",
"ticker",
"delive",
"logo_d",
"js/bea",
"top_ba",
"earch_",
"com/pr",
"previe",
"footer",
"extern",
"tatic.",
"facebo",
"d.doub",
"index.",
"com/ad",
"ad_dat",
"style_",
"embed/",
"instre",
"gadget",
"tream-",
"router",
"yfpado",
"newfor",
"global",
"layout",
"skin/d",
"index-",
"compon",
"tracke",
"proces",
"frontp",
"mazon.",
"mages-",
"com/im",
"mages/",
"engine",
"mazon-",
"adsyst",
"almart",
"edirec",
"icroso",
"query-",
"query.",
"om/lib",
"ibrary",
"ccount",
"ommon/",
"tyles/",
"enerat",
"cripts",
"roduct",
"om/js/",
"ontrol",
"omepag",
"cial/j",
"oglead",
"agead/",
"ag/js/",
"ogle-a",
"nalyti",
"dserve",
"erve.p",
"idgets",
"ublecl",
"arch.c",
"torage",
"rovide",
"pt/pub",
"s?call",
"allbac",
"efault",
"ecomme",
"bads.g",
"ampad/",
"frame/",
"ogle.c",
"0x250_",
"ahoo.c",
"p://l.",
"z/comb",
"ontent",
"esktop",
"ds/ads",
"ds-min",
"mg.com",
"ndex/l",
"eneric",
"verlay",
"ssets/",
"edia/t",
"hemes/",
"edia/p",
"ss/ski",
"eader-",
"oolbar",
"q/darl",
"ommon_",
"lugins",
"uild/j",
"ublic/",
"lugin/",
"/strip",
"frame-",
"allery",
"ontrib",
"latfor",
"esourc",
"ource/",
"emplat",
"reams/",
"tylesh",
"ublish",
"ecure/",
"eative",
"edia/s",
"eliver",
"0x250.",
"eacon/",
"s/beac",
"review",
"ooter-",
"frames",
"aceboo",
"frame_",
"frame.",
"framed",
"lient/",
"d_data",
"xterna",
"idgeta",
"nstrea",
"om/gad",
"adgets",
"query/",
"fpadob",
"lobal/",
"lobal-",
"odule/",
"odule-",
"ompone",
"rocess",
"rontpa",
"azon.c",
"ages-a",
"ages/G",
"lients",
"ages/I",
"dsyste",
"direct",
"crosof",
"brary/",
"mmon/r",
"nerate",
"ripts/",
"mepage",
"g.com/",
"uery.j",
"gleads",
"g/js/g",
"alytic",
"ads.g.",
"blecli",
"eacon.",
"ovider",
"t/puba",
"?callb",
"llback",
"commen",
"mpad/a",
"gle.co",
"gead/e",
"gead/j",
"gead/g",
"dgets/",
"hoo.co",
"ntent/",
"sktop-",
"ntent-",
"ntent_",
"erlay/",
"sets/s",
"s/skin",
"erlay.",
"ative/",
"s-min.",
"mmon/a",
"fault/",
"ugins/",
"ild/js",
"ntroll",
"strip_",
"rame/i",
"rame-m",
"erlay-",
"ugin/a",
"server",
"llery-",
"atform",
"fault_",
"eview/",
"mplate",
"sets/p",
"yleshe",
"blishe",
"livera",
"mmon/i",
"cebook",
"rame.h",
"gead/i",
"rames/",
"ternal",
"rame_a",
"dgetap",
"counts",
"rames_",
"m/js/a",
"llery/",
"padobj",
"m/lib/",
"mponen",
"ontpag",
"zon.co",
"ients/",
"system",
"irect.",
"rosoft",
"ssets.",
"store.",
"mon/re",
"ipts/s",
"epage/",
"leadse",
"/js/gp",
"lytics",
"ds.g.d",
"leclic",
"ubads_",
"lback=",
"epage_",
"ommend",
"pad/ad",
"on.com",
"le.com",
"ead/ex",
"ead/js",
"ead/ga",
"oo.com",
".com/z",
"tent/s",
"tent_i",
"tent-a",
".com/r",
"tent/b",
"tent/a",
"trolle",
"tent/i",
"erver.",
"tform_",
"gins/a",
"plate-",
"plates",
"leshee",
"ame.ht",
"ernal_",
"getapi",
"ounts/",
"adobje",
"ponent",
"plate/",
"update",
"com/a/",
"ntpage",
"n.com/",
"on/res",
"eadser",
"js/gpt",
"e.com/",
"s.g.do",
"eclick",
"bads_i",
"mmenda",
"ad/ads",
"ad/exp",
"ad/js/",
"ad/gad",
"o.com/",
"com/zz",
"com/rq",
"ent/ad",
"roller",
"esheet",
"me.htm",
"dobjec",
"ent/ba",
"onent/",
"om/a/1",
"dservi",
"com/pa",
".g.dou",
"click.",
"e.html",
"ads_im",
"mendat",
"d/ads?",
"om/ads",
"d/expa",
"d/gadg",
"om/zz/",
"om/rq/",
"click/",
"d/js/l",
"object",
"servic",
"om/pag",
"lick.n",
"ds_imp",
"endati",
"/ads?g",
"ww.goo",
"m/ads/",
"/expan",
"m/zz/c",
"m/rq/d",
"js/lid",
"ads?ad",
"bject.",
"ervice",
"m/page",
"ick.ne",
"s_impl",
"ndatio",
"ads?gd",
"w.goog",
"expans",
"s/lida",
"ds?ad_",
"expand",
"ject.j",
"rvices",
"ck.net",
"_impl_",
"dation",
"ds?gdf",
"xpansi",
"/lidar",
"s?ad_r",
"com/do",
"xpandi",
"ect.js",
"vices.",
"k.net/",
"partne",
"ations",
"s?gdfp",
"pansio",
"lidar.",
"?ad_ru",
"om/dou",
"pandin",
"ices.c",
"artner",
".net/g",
"?gdfp_",
"ansion",
"idar.j",
"ad_rul",
"m/doub",
"anding",
"tions/",
"ces.co",
"rtner.",
"net/ga",
"gdfp_r",
"nsion_",
"dar.js",
"d_rule",
"ions/a",
"es.com",
"tner.g",
"et/gam",
"dfp_re",
"agead2",
"sion_e",
"_rule=",
"s.com/",
"ner.go",
"t/gamp",
"fp_req",
"gead2.",
"ion_em",
"er.goo",
"p_req=",
"ead2.g",
"on_emb",
"r.goog",
"_req=1",
"ad2.go",
"n_embe",
"com/gp",
"req=1&",
"d2.goo",
"_embed",
"om/gpt",
"2.goog",
"embed.",
"m/gpt/",
"oogles",
"mbed.j",
"oglesy",
"bed.js",
"glesyn",
"lesynd",
"esyndi",
"syndic",
"yndica",
"ndicat",
"dicati",
"icatio",
"cation",
"ation.",
"tion.c",
"ion.co",
"atic/j",
"irects",
"atic/c",
"com/aa",
"/amzn_",
"_ads.j",
"/boots",
"intern",
"anner.",
"/gatew",
"/page/",
"/count",
"ocessa",
"/adser",
"adtech",
"/addyn",
"atic.a",
"channe",
"/messa",
"-publi",
"media.",
"/casal",
"aka-cd",
"/adtec",
".adver",
"/wrapp",
".com/c",
"/click",
"lick/s",
"om/adv",
"/adver",
"erver/",
"/pixel",
"/broad",
"broadc",
"_st.js",
"gemini",
"/stats",
"atic.e",
"/flash",
"/js/sw",
"/perfo",
"com/ss",
"?view=",
"ndex.h",
"&video",
"&partn",
"layer/",
"/confi",
"/data/",
"/testa",
"&custo",
"/frame",
"/js/jq",
"/dicti",
"&click",
"&view=",
"/curve",
"lates/",
"atives",
"odules",
"/loadi",
"/servi",
"/Event",
"/chann",
"/updat",
"ative.",
"view/c",
"/comme",
"contex",
"akamai",
"back=c",
"/?adra",
"-ad.js",
".ashx?",
".net/a",
"/adsco",
"/ads.p",
"/AdSer",
"lick.j",
"/textl",
"-right",
"-googl",
"/adcli",
"anner-",
"ault_p",
"&adid=",
"cript.",
"style.",
"/visit",
"event.",
"mmon/j",
"/js/co",
"x250_b",
"view-b",
"/today",
"ault_a",
"/cache",
"atic/g",
"/all_a",
"atic/h",
"/home/",
"atic/s",
"atic/b",
"atic/p",
"ww/ass",
"asset/",
"ww/js/",
"/sport",
"/tools",
"/calen",
"espons",
"_takeo",
"takeov",
"_butto",
"_botto",
"match.",
"interf",
"com/ip",
"/smart",
"click_",
"/weath",
"/house",
"?rando",
"/lives",
"p://cr",
"liver.",
"p://p.",
"/viewe",
"/group",
"/displ",
"/match",
"/main/",
"border",
"/delay",
"/src/a",
"_show_",
"/show.",
"/featu",
"discou",
"-banne",
"anner/",
"&displ",
"Query.",
"eader.",
"/linke",
"/lib/f",
"ytics/",
"?type=",
"/js/th",
"/third",
"tatic-",
"fronte",
"/js/in",
"tp://d",
"/js/ou",
"_layer",
"/user_",
"_panel",
"/2015/",
"ages/s",
"/2013/",
"oduct_",
"://fin",
"ages/c",
"mmon/s",
"mon/ad",
"_compa",
"ajax/g",
"/2014/",
"/profi",
"/home.",
"mmende",
"tore.h",
"?handl",
"domain",
"/img.a",
"/demo/",
"index_",
"sets/m",
"/adbox",
"://pro",
"/proxy",
"ayout_",
"_960_9",
"com/vi",
"visito",
"=ifram",
"/js/vi",
"/b.php",
"/blogs",
"?servi",
"/wordp",
"lightb",
"ndex.p",
"/?pid=",
"/pages",
"ages/b",
"/watch",
"/empty",
"/javas",
"cript/",
"ages/t",
"yahoo/",
"ages/d",
"ages/l",
"/listi",
"criteo",
"livery",
"/ajs.p",
"shared",
"ustom_",
"/Frame",
"ages/f",
"/bucke",
"orage/",
"/main-",
"/slide",
"/categ",
"/js/js",
"/basic",
"/js/la",
"_frame",
".php?a",
"/notif",
"/adi/e",
"/rtm?R",
"/uploa",
"mages.",
"ages.s",
"/10000",
"/show-",
"/matri",
"matrix",
"/ad/sp",
"/speci",
"/temp/",
"/js/ad",
"/js/bo",
"mediat",
"/ad/st",
"/form/",
"/ad/co",
"/price",
"extend",
"finger",
"om/adg",
"html?c",
"ads.ru",
"v8eyB8",
"d/js/a",
"/partn",
"/pub-c",
"/show_",
"/ads.j",
"lick/i",
"=dynam",
"/ads/s",
"gead/a",
"slotna",
"urce/c",
"/repor",
"_load_",
"irect_",
"_reque",
"/brows",
"_conte",
"/img/g",
"oducts",
"&affil",
"affili",
"type=a",
".net/n",
"html/g",
".php?i",
"/ad/cs",
"css/ad",
"/ad/js",
"/js/sc",
"/scrol",
"ead/im",
".php?w",
"anner3",
"/brand",
"/insta",
"/show/",
"p://j.",
"/api.p",
"/inclu",
"/feed/",
"ernal/",
"_house",
"/js/ne",
"/switc",
"s/ads.",
"/js/su",
"idget/",
"/js/ta",
"/webse",
"/direc",
"/ads1.",
"/dapms",
"ipts/j",
"&size=",
"/cdn.a",
"lisher",
"/post_",
".gif?a",
"idget.",
"perfec",
"/tumbl",
"/prod/",
"/landi",
"/posts",
"_post_",
"/vendo",
"ipts/t",
"/popov",
"/regis",
"yahoo_",
"/about",
"_data/",
"/splas",
"splash",
"/ad.ma",
".net/b",
"undles",
"/Conte",
"e.com.",
"/xvide",
"videos",
"/mobil",
"/v2/js",
"/cgi-b",
"/site_",
"/js/pa",
"/Video",
".php?r",
"/css/c",
"ons/ad",
"s/ads-",
"/ads-t",
"ommon-",
"consum",
"dgets.",
"&show_",
"gets/t",
"_respo",
"yles/a",
"ooter.",
"/promo",
"ipts/a",
"/shop/",
"news.c",
"blic/a",
"/audio",
"layer_",
"/ad/ad",
"eneral",
"/css/p",
"com/mi",
"/butto",
"/follo",
"xhamst",
"xhcdn.",
"track.",
"/js/ma",
"/2.htm",
"/ados.",
"/engin",
"/ads/l",
"ources",
"ublic_",
"ad/adx",
"_banne",
"anner_",
"/keywo",
"/auto_",
"share/",
"ipts/f",
"/unive",
"/bbcco",
"/iFram",
"msecnd",
"ngine_",
"_overl",
"ient/s",
"/sites",
"/blogg",
"/ads/d",
"/300x2",
"/reque",
"_promo",
"sponso",
"/compa",
"/js/sp",
"/notic",
"ooter_",
".php?u",
"nation",
"/domai",
"adcont",
"/img/2",
"Banner",
"js/lin",
"/wp-in",
"colors",
"about.",
"_googl",
"oogle_",
"_secti",
"/satel",
"/js/ac",
"mages2",
"ntents",
"/stand",
"clickt",
"&track",
"-onlin",
"online",
"promo.",
"forums",
"eviews",
"worlds",
"_campa",
"_custo",
"racked",
"-api.a",
".ads.l",
"/res/c",
"/core/",
"/res/b",
"/app/d",
"://a.a",
"_exter",
"/cms/j",
"/js/re",
"/js/po",
"/popup",
"/img/s",
"/js/yo",
"/html.",
"/hover",
"com/pe",
"/perso",
"odule=",
"/eleme",
"_stati",
"/relat",
"ages/1",
"/china",
"/a.htm",
"arch-a",
"/autos",
"/signu",
"-inter",
"inters",
"better",
"/money",
"/site-",
"/sampl",
"/page-",
"late-a",
"view/m",
"darla-",
"/dropd",
"/photo",
"ntribu",
"-page-",
"fault-",
"ustome",
"=searc",
"_foote",
"_gener",
"/core-",
"anners",
"tore/s",
"/under",
"/buyer",
"front/",
"/pool/",
"/beta-",
".aspx?",
"pornhu",
"phncdn",
"ommons",
"/premi",
"/large",
"/load-",
".engin",
"oublep",
"ipts/b",
"com/jq",
"uery.c",
"/netwo",
"/js/wi",
"-popup",
"/js/fo",
"/js/fr",
"promo-",
"/sales",
"/suppo",
".spons",
"_frien",
"feeds.",
"arch_a",
"sets/j",
"s/adsW",
".widge",
"backgr",
"_image",
"image.",
"electi",
"/os/mo",
"/users",
"?file=",
"/_uac/",
"/api/i",
"/intel",
"ayout.",
"/quick",
"28x90,",
"/rende",
"oducti",
"om/adl",
"/adlin",
"/_medi",
"_media",
"?actio",
"/netfl",
"/siteu",
"ogle.p",
"bp.blo",
"/files",
"/setti",
"/aax2/",
"ustom/",
"/break",
"eader_",
"edia/c",
"media_",
"-artic",
"/js/gi",
"/icon_",
"/daily",
"video_",
"/admin",
"/js/Br",
"leads-",
"/short",
"_right",
"&sz=97",
"com/da",
"/blank",
"/advie",
"atic.f",
"=banne",
".swf?c",
"optimi",
"&aduni",
"/adSer",
"js/sho",
"&googl",
"://syn",
"/pubma",
"gead/s",
"clicks",
"track/",
"/trade",
"anneri",
"cnet.c",
"/nativ",
"sets/t",
"sktop/",
"/cbsi/",
"/cnwk.",
"rackcd",
"onents",
"/stick",
"/form-",
"image-",
"yahoo-",
"ipts/c",
"intera",
"/st.js",
"/adblo",
".javas",
"/syndi",
"/yad.j",
"css/st",
"js/lib",
"/core.",
"espn.g",
"_video",
"/tower",
"/live/",
"/aclk?",
"turbob",
"?ad_id",
"&place",
"&adver",
"/devel",
"/float",
"/super",
"/utili",
"_popup",
"/bookm",
"/js/ca",
"/texta",
"/?sour",
"plate_",
".jp/ad",
"lobalb",
"indiat",
"uery.i",
"uery.p",
".lazyl",
".in/ad",
"/cdn.m",
"om/pro",
"/proje",
"/i.js?",
"netdna",
".adtec",
"oduct-",
"openx.",
"/w/1.0",
".gif?t",
"/invit",
"/marke",
"ages/h",
"/downl",
"/js/go",
"/livej",
"oller/",
"/maste",
"//flas",
"/flyer",
"idget_",
"-theme",
"edia/v",
"om/adc",
"/adcal",
"_blank",
"/ads.m",
"/targe",
"ws.ama",
"/chrom",
"uery-a",
"sets/w",
"-text-",
"/adman",
"/js/ex",
"com/ba",
"com/b?",
"/728x9",
"-2.htm",
"d/js/g",
"redtub",
"/porns",
"/min/a",
"/ads/w",
"/adfra",
"/commu",
"om/ima",
"ges/G/",
"/getad",
"/youpo",
"youpor",
"/busin",
"ents/a",
"ages/i",
"/modal",
"/clean",
"securi",
"com/?a",
"nytime",
"/adx/b",
"/taxon",
"sets/h",
"/views",
"/ad-vi",
"_Adver",
"/js/cs",
"ideo/a",
"/graph",
"/webtr",
"/js/an",
"sheets",
"ipts/p",
"&adsaf",
"/mainp",
"onstru",
"gins/c",
"/js/mi",
"ublici",
"/excel",
"&smart",
"adf.ly",
"/layer",
"englis",
"/fixed",
"sets/a",
"/css/o",
"/js/wo",
"_heade",
"/js/pu",
"idget?",
"edia/f",
".php?d",
"/js/we",
"live.j",
"/blog/",
"/main_",
"/js/at",
"atic/i",
"/img/d",
"/print",
"gets/l",
"ds/adf",
"page/a",
"s/ads/",
"/ads/y",
"/sandb",
"back=y",
"_displ",
"/your_",
"view/i",
"_dynam",
"_playe",
"medias",
"/affil",
"/wikia",
".net/_",
"/sasse",
"/backg",
"-backg",
"/oasis",
"/Porta",
"/Googl",
"php?co",
"ages.w",
"mazon_",
"mages1",
"_your_",
".banne",
"wikia.",
"/adeng",
"_ads_r",
"/adj/g",
"/hoots",
"/adome",
".net/v",
"/misc/",
".info/",
"/adsen",
"sets/d",
"_fixed",
"/subna",
"/devic",
"/outbr",
"uery.a",
"/sitei",
"/campa",
"/ancho",
"anchor",
"/purch",
"/play.",
"/adlog",
"/small",
"/rotat",
"/js/Po",
"/Uploa",
"/jsapi",
"/uds/a",
"/v2/de",
"_160x6",
"torren",
"/discu",
"://ban",
"ents/b",
"/onlin",
"/royal",
"/enter",
"/sitet",
"/singl",
"/membe",
"/intro",
"view.a",
"obal-a",
"tyle/b",
"om/add",
"onvert",
"/welco",
"://ox-",
"ww.for",
"/aduni",
".php?n",
"/forbe",
".com/w",
"feedbu",
"&widge",
"obal/a",
"/feeds",
"/quote",
"enviro",
"_partn",
"/app/a",
"/code/",
"watch-",
"/maxcd",
"indeed",
"/jobse",
"/desig",
"eporti",
"dule/a",
"/tags/",
"/js/fl",
"checkm",
"/livea",
"/syste",
"/chat/",
"/games",
"gets/s",
"/hostg",
".net/f",
"/img/1",
"pts/sh",
"/api/a",
"/css/m",
"/ads/g",
"/ads/v",
"ages/n",
"/windo",
"/Anima",
"wallpa",
"/adima",
"ages/a",
"/refer",
"/adgea",
"consol",
"atic/t",
"ayout/",
"annera",
"&zonei",
"/js/ab",
"/adimg",
"_main_",
"ages/r",
"/web/a",
"page_a",
"_asset",
"/filte",
"/ad_fo",
"/topba",
"/gamer",
"/ad.js",
"/ad/in",
"indexA",
"tripad",
"emes/t",
"atic/d",
"ajax/h",
"tatic_",
"_files",
"/dylan",
"ages/p",
"mother",
"ages/2",
"/p1.js",
"earch?",
"ader-a",
"p://po",
"/popad",
"/js/va",
"ages/u",
"sets/i",
"ages/g",
"=Displ",
"yahooa",
"ages/j",
"/js/sm",
"/ad_ne",
".openx",
"/jstag",
"/remot",
"/bridg",
"/adp-p",
"_ads.c",
"/extra",
"ages/B",
"/diff/",
"/adpla",
"layer.",
"/simpl",
"icker.",
"sascdn",
"atic/a",
"_home_",
"/defer",
"blackl",
"alleri",
"/hserv",
"/viewi",
"/size=",
"/rando",
"/site=",
"/pbkt/",
"/value",
"_adtag",
"=300x2",
"/adtag",
"/_js/a",
"_js/ad",
"/js/bc",
"_redes",
"page_p",
"faults",
"/cdn-c",
".net/i",
"/100x1",
"_skin_",
"oogleA",
"/js/pc",
"_ad.js",
"/open.",
".swf?p",
"/matom",
"/js/nj",
"ientsc",
"/vbull",
"/surve",
"site/i",
"/zedo.",
"/wp-co",
"ent/sk",
"/skin-",
"/dynam",
"/table",
"-layer",
"/colla",
"tracka",
"/carbo",
"ages/m",
"/forum",
"/baner",
"ww/del",
"/afr.p",
"blic/i",
"/infor",
"anner2",
"ntent.",
"edia/h",
"/stori",
"workin",
"/horiz",
"_sideb",
".strea",
"/na_st",
"career",
"gramma",
"/adifr",
"annerI",
"ets/pr",
".300x2",
"/quikr",
"ndinga",
"usatod",
"atic/u",
"/ganne",
"/pictu",
"ads.us",
"/adapt",
"anner?",
"ntentA",
".php?p",
"idgetn",
"&promo",
"/toppe",
"/adfox",
"/src/j",
"/block",
".swf?a",
"://del",
"sonp/p",
"/vast.",
"ad4.li",
"/?LR_P",
"LR_VID",
"/vast/",
".displ",
"worldr",
"_tile_",
"/realm",
"/RealM",
"/adstr",
"/shopp",
"/js/oo",
"/viewa",
"/poll.",
"casino",
"fantas",
"footba",
"-print",
"edia/w",
"/Inclu",
"/takeo",
"/~/med",
"/js/ea",
"/cdn/c",
"sets/r",
"/minif",
"/get_a",
"/Burst",
"/adsam",
"/2010/",
"/space",
"/Deskt",
"/Skins",
"kins/m",
"/dfp/p",
"/logo.",
"ntenta",
"/sideb",
"/adsby",
"/ads_r",
"warran",
"rame/t",
"gins/p",
"&small",
"ideo.p",
"mazona",
"redir/",
"&banne",
"/RM/Bo",
"/adsea",
"wistia",
"rame_s",
"embedd",
".net/c",
"/cdn/a",
"/resto",
"&utm_c",
"/ads/j",
"/pulse",
"_300_2",
"ps://d",
"/ads/i",
"_300x6",
"/jspla",
"/get_p",
"sunday",
"/?comp",
"//uplo",
"ploade",
"/img/l",
"/img/n",
"longta",
"_float",
".inter",
"/usera",
"inter/",
"ipts/l",
"/links",
"_surve",
"rame_c",
"/ad.ph",
"/ad/fi",
"/attac",
"/first",
"/newpo",
"/cms/i",
"/tag/s",
"_left_",
"microa",
"track_",
"ipts/g",
"/freec",
"/jobs/",
"/pp.js",
"/cross",
"/jenga",
"/autom",
".colle",
"news/t",
"/adj/w",
"/oncli",
"clicka",
"/js/ri",
"ages/w",
"gins/w",
"/perfe",
"=simpl",
"simply",
"/ad/lo",
"blishi",
"/compr",
"/outpu",
"_adver",
"120x60",
"/Local",
"blic/s",
"/js/sn",
"/ajax-",
"/lib/a",
"_leade",
"mbed/s",
"/img/h",
"/samsu",
"/offer",
"/livec",
"-small",
"ebooks",
"/link_",
"/api.a",
"ndex.a",
"/marqu",
"_theme",
"/queen",
"/Scrip",
"/Priva",
"/skin2",
"snapde",
"&adspa",
"/js/dl",
"/blues",
"/unity",
"/getvi",
"mgid.c",
"://ads",
"/fancy",
"_affil",
"/node/",
"/panel",
"/?key=",
"/actio",
"/anti_",
"/app/w",
"/homes",
"ts.vid",
"tmz.vo",
"/middl",
"/liber",
"prison",
"-house",
"-feed-",
"hollyw",
"/artic",
"/js/oa",
"/rcom-",
"/js/rc",
"/refre",
"sets/b",
"ages.i",
"/post-",
"/_scri",
"site/g",
"_sites",
"embed_",
"/img-c",
"/1/adn",
"com/pm",
"ets/pa",
"virtua",
"/api/b",
"/Image",
"/load_",
"distro",
"sets.b",
"/logos",
"future",
"/spark",
"/js/ms",
"/cssjs",
".ads.c",
"rame_r",
"/ck.ph",
"zoneid",
"/adv_l",
"/adv/l",
"_spons",
"/ads.h",
"/adv_b",
"local_",
"mmon/d",
"/js/wa",
".text-",
"image/",
"clickb",
"/gravi",
"/email",
"/radio",
"stacks",
"/api/o",
"chatur",
"edia/b",
"/cgi/a",
"/ads/e",
"/newsl",
"-newsl",
"html?a",
"-panel",
"json/a",
"/curre",
"treama",
"/adult",
"/servl",
"/digit",
"/paget",
"/js15.",
"profes",
"/ads_i",
"empire",
"/multi",
"/stock",
"/mini_",
"/js/im",
"image_",
"php?cl",
"/gazet",
".pl/ad",
"/info/",
"adv.ad",
"/pub/i",
"/jsads",
"/ads2/",
"edia/i",
".popup",
"llery_",
"PopUnd",
"movies",
"css/ta",
"/homeo",
"/j.ad?",
"/js/fa",
"atic/n",
"/ads/n",
"?link=",
"/spotl",
"ents/p",
"/Handl",
"-third",
"/colum",
"/seaso",
"/place",
"/deals",
"/menu/",
".click",
"28x90/",
"monste",
"/ads.s",
"/ads-s",
"/zdcse",
"rlay.j",
"sextub",
"/js/fu",
"/js.ad",
"/audie",
"v.fwmr",
"/ad/g/",
"oogle/",
"/exit.",
"ads/co",
"/ws/co",
"://oas",
"-news-",
"_doubl",
"_onlin",
"/js/do",
"/pagec",
"/artis",
"tent/f",
"/sitea",
"pop.js",
"html/s",
"/sid.h",
"/css/v",
"/inc_i",
"/advan",
"advanc",
"://fee",
"feedly",
"/adban",
"/getwe",
".php?g",
"/adp/a",
".adfor",
"/Widge",
"rule=1",
"/adcod",
"videop",
"clickl",
"ery.jc",
"/showf",
":8080/",
"/evere",
"_verti",
"/m.js?",
"/adnet",
"/door/",
"expert",
"/adins",
"/adscr",
"platea",
";ifram",
"gets/a",
"/pics.",
"/img/b",
"/dfp/d",
"/story",
"/swf/i",
"/inser",
"page_b",
"/inlin",
"_text_",
"rnal_a",
"dia/pl",
"/_part",
"_stick",
"vents_",
"ugins_",
"_dropd",
"arch/a",
"/adtim",
"/centr",
"/t.php",
"?wmid=",
"/right",
"/js/pp",
"_eleme",
"_prero",
"/js/tt",
"/pub/a",
"/adam/",
"-300x6",
"/vpaid",
"&adser",
"adsid4",
"/webma",
"om/adp",
"/sitem",
"/imgad",
"mazon/",
"_728x9",
"160x60",
"0x250b",
"gGoAQC",
"pts/sk",
"edia/g",
"/ecom/",
"/retri",
"site/a",
"/cobra",
"ajax/a",
"/nexp/",
"rocket",
"ipts/z",
"ages/e",
"imagec",
".247re",
"edia/a",
"ustom1",
"videoa",
"/mod_p",
"/game-",
"/spect",
"/api/p",
"/blog-",
"/Front",
"ooglef",
"/subsc",
"/Affil",
"/ticke",
"Statio",
"/skinn",
"_value",
"/other",
"/cente",
"/all/a",
"/firef",
"/opena",
"/exocl",
"-book-",
"/eagle",
"earcha",
"/js/_b",
"/img/c",
"eader2",
"/origi",
"/botto",
"/js/mw",
"tic/js",
"brandi",
"anner%",
"messag",
"regist",
"ads.js",
"countr",
"bootst",
"nterna",
"settin",
"nner.j",
"gatewa",
"perfor",
"cloudf",
"ation/",
"dtech.",
"articl",
"target",
"hannel",
"origin",
"standa",
"casale",
"edia.c",
"ka-cdn",
"adServ",
"advert",
"wrappe",
"ads.co",
"person",
"roadca",
"click%",
"emini.",
"stats.",
"ayer.p",
"flash/",
"dex.ht",
"config",
"referr",
"javasc",
"ayer/j",
"js/jqu",
"browse",
"dictio",
"includ",
"curveb",
"azonaw",
"tives/",
"dules/",
"loadin",
"vices/",
"rvice.",
"Events",
"screen",
"tive.j",
"ive.js",
"handle",
"omment",
"catego",
"ontext",
"counte",
"loaded",
"kamaih",
"ayer/s",
"ayer/m",
"?adraw",
"ets/js",
"random",
"lay.js",
"net/ad",
"AdServ",
"pubmat",
"ads.ph",
"adstra",
"2.html",
"ick.js",
"textli",
"hcdn.c",
"lassic",
"refres",
"ad/con",
"28x90_",
"erver-",
"univer",
"develo",
"survey",
"ticket",
"displa",
"scienc",
"rights",
"irecto",
"ncrypt",
"millio",
"digita",
"broadb",
"adclic",
"net/ac",
"tyle.c",
"ytimg.",
"home/_",
"0x250;",
"render",
"0x250/",
"layer-",
"elemen",
"mon/js",
"js/com",
"weathe",
"native",
"ts/ski",
"w/asse",
"iew-ba",
"market",
"lectio",
"viewer",
"networ",
"bucket",
"device",
"cache/",
"instan",
"tic/su",
"tic/ba",
"ack=cr",
"tools/",
"calend",
"sponse",
"akeove",
"button",
"bottom",
"home/n",
"nterfa",
"ipaddr",
"serial",
"intere",
"Conten",
"column",
"://cre",
"match_",
"show_a",
"featur",
"iscoun",
"first-",
"lazylo",
"tribut",
"racker",
"switch",
"linked",
"ds/com",
"js/thi",
"Frame.",
"ronten",
"Deskto",
"js/out",
"ayer.j",
"panel_",
"ges/si",
"a.html",
"adunit",
"ges/co",
"compar",
"stock/",
"ore.ht",
"img.ad",
"adbox.",
"ads/de",
"proxy.",
"filter",
"960_90",
"isitor",
"thirdp",
"ges-am",
"rotato",
"ssl-im",
"s.amaz",
"blogge",
"follow",
"rvice=",
"crossd",
"wordpr",
"ightbo",
"dex.ph",
"pages/",
"ges/bi",
"ges/to",
"ges/li",
"listin",
"rightt",
"riteo.",
"ivery/",
"ajs.ph",
"oneid=",
"vent.n",
"Animat",
"tation",
"marque",
"js/ini",
"slider",
"api.ph",
"notifi",
"adi/eb",
"rtm?Rt",
"flash_",
"pload/",
"ates/a",
"ad_ids",
"specia",
"ad/sta",
"form/s",
"tml?cl",
"ds.rub",
"projec",
"js/ads",
"rtner/",
"pub-co",
"rver/a",
"dynami",
"ads/st",
"cached",
"ead/ad",
"lotnam",
"reques",
"eport_",
"ducts/",
"ffilia",
"ype=ad",
"0x250&",
"tml/go",
"smarta",
"t.php?",
"php?id",
"pricer",
"ad/css",
"ss/ad.",
"js/scr",
"ad/img",
"house_",
"dapmsn",
"premiu",
"member",
"serve_",
"cdn.ad",
"price_",
"site_i",
"rightr",
"dget.p",
"erfect",
"action",
"tumblr",
"landin",
"ges/lo",
"vendor",
"ges/st",
"popove",
"expose",
"plash/",
"plash.",
"ndles/",
"nts/pr",
"ts/pro",
"obile/",
"obile-",
"files/",
"rtner=",
"europe",
"xvideo",
"v2/js/",
"ideos/",
"cgi-bi",
"ads/js",
"onsume",
"dget/r",
"show_b",
"home/s",
"promos",
"ages.a",
"net.co",
"js/vid",
"data/c",
"neral-",
"page-c",
"show_s",
"hamste",
"js/mai",
"ados.j",
"urces/",
"d/adx?",
"ivery.",
"keywor",
"auto_a",
"suppor",
"ript/o",
"files.",
"sponsi",
"bbccom",
"iFrame",
"graphi",
"secnd.",
"sites/",
"ads/di",
"ponsor",
"compan",
"foreig",
"design",
"notice",
"60x600",
"ationa",
"img/20",
"s/link",
"wp-inc",
"profil",
"olorsc",
"bubble",
"bout.c",
"clean.",
"submit",
"sectio",
"satell",
"tic.ad",
"privat",
"window",
"lickta",
"erver=",
"campai",
"nlines",
"romo.j",
"centra",
"ews.co",
"studen",
"ystems",
"busine",
"center",
"photos",
"orldse",
"api.ad",
"cdn.me",
"res/ba",
"//a.ad",
"audien",
"cms/js",
"js/pop",
"popup.",
"img/st",
"js/you",
"showst",
"open.j",
"loader",
"relate",
"acked_",
"ges/10",
"a.htm?",
"subnav",
"around",
"signup",
"nterst",
"upsell",
"extras",
"core/a",
"simple",
"proxy/",
"moneyb",
"promot",
"irect/",
"house-",
"valuec",
"text-a",
"iew/mo",
"arla-s",
"dropdo",
"unbloc",
"invite",
"page-p",
"stomer",
"downlo",
"home/b",
"nners.",
"dget/w",
"dget.j",
"buyer/",
"ront/a",
"beta-a",
"//prom",
"ornhub",
"hncdn.",
"nner.c",
"large.",
"ad/loa",
"ublepi",
"&rand=",
"om/jqu",
"brand/",
"vertic",
"master",
"commer",
"romo.c",
"friend",
"plash_",
"slides",
"show.c",
"lick_t",
"quick_",
"/adsWr",
"floati",
"popup_",
"ackgro",
"users/",
"_uac/a",
"gravit",
"api/in",
"intell",
"addyn/",
"romo.p",
"cobran",
"ck.php",
"ductio",
"300x60",
"m/adli",
"adlink",
"right_",
"posts_",
"blogsm",
"netfli",
"dtech_",
"ayer/o",
"p.blog",
"les/ad",
"aax2/a",
"stom/a",
"hared/",
"ates/b",
"ates/u",
"ivery_",
"links/",
"ates/m",
"xtende",
"dailym",
"js/Bri",
"eads--",
"middle",
"placem",
"sz=970",
"blank.",
"ad/adv",
"adview",
"&adurl",
"isher/",
"nner_a",
"swf?cl",
"ptimiz",
"ads.se",
"single",
"servin",
"s/show",
"ogle_c",
"ead/sh",
"traded",
"nnerid",
"i.js?o",
"outbra",
"ets/ta",
"ges/de",
"cnwk.1",
"ackcdn",
"nents/",
"sticky",
"everes",
"p://d.",
"adbloc",
"yad.js",
"pts/ta",
"spn.go",
"redesi",
"nts/ba",
"colleg",
"php?re",
"tic/sh",
"utilit",
"popup/",
"popup-",
"bookma",
"com/co",
"textad",
"?sourc",
"obalba",
"ndiati",
"atimes",
"ery.in",
"nterne",
"ad/com",
"mmons/",
"etdna-",
"heme/a",
"penx.n",
"w/1.0/",
"aspx?a",
"adsens",
"gif?ta",
"ets/ma",
"ges/ho",
"place-",
"liveja",
"ript/p",
"om/vid",
"ads/lo",
"dia/vi",
"about-",
"adcall",
"chrome",
"fancyb",
"webser",
"text-l",
"admana",
"shoppi",
"100002",
"Affili",
"js/goo",
"edtube",
"pornst",
"traffi",
"js/adf",
"s/adfr",
"adfram",
"js/red",
"commun",
"m/imag",
"es/G/0",
"ouporn",
"ges/in",
"ecurit",
"ytimes",
"adx/bi",
"taxono",
"ets/ho",
"views/",
"ad-vie",
"Advert",
"heets/",
"smartl",
"nner_f",
"adsafe",
".com.e",
"mainpa",
"nstruc",
"js/ad.",
"panel-",
"compre",
"blicid",
"img/sp",
"df.ly/",
"placeh",
"layers",
"ds/con",
"chinaa",
"adclie",
"nglish",
"js/fre",
"irectr",
"js/boo",
"js/adv",
"Widget",
"site-b",
"ad.php",
"neric_",
"tic/im",
"promo_",
"ads/ya",
"core.j",
"_scrip",
"sandbo",
"iew/im",
"welcom",
"nner_d",
"rt.com",
"basic-",
"asedRe",
"js/car",
"Google",
"adengi",
"spotli",
"ads_re",
"adj/gn",
"hootsu",
"rvice/",
"ges/ic",
"adomet",
"tic/ca",
"omainp",
"output",
"fixed_",
"css/ca",
"ediate",
"ad.js?",
"purcha",
"Upload",
"js/Pop",
"jsapi?",
"js/par",
"js/min",
"orrent",
"pts/bo",
"discus",
"inform",
"servle",
"Portal",
"forbes",
"pts/ad",
"w.forb",
"eeds.f",
"eedbur",
"adline",
"feeds/",
"ates/f",
"nviron",
"rtner_",
"Handle",
"rtners",
"ates/t",
"neral.",
"ad/log",
"code/p",
"js/web",
"atch-n",
"feed/j",
"tic/se",
"maxcdn",
"ndeed.",
"jobsea",
"portin",
"attach",
"ule/ad",
"news-a",
"storie",
"obile_",
"ystem/",
"ecom/m",
"games/",
"php?un",
"ages1/",
"dget/c",
"hostga",
"ts/sha",
"2015/a",
"minify",
"adgear",
"ads/vi",
"nner_i",
"home/a",
"nner/a",
"show_c",
"allpap",
"ads.mi",
"adimag",
"ges/ad",
"onsole",
"right3",
"nnerad",
"ad/ad.",
"om/ban",
"lic/as",
"Images",
"ges/ro",
"net/fl",
"js/ad_",
"ad_for",
"topbar",
"w/js/a",
"ad/ind",
"ripadv",
"hovera",
"ges/se",
"jax/ho",
"ets/li",
"ges/pr",
"other/",
"ges/20",
"subscr",
"third-",
"://pop",
"popads",
"ets/im",
"ges/gl",
"Displa",
"ges/ba",
"remote",
"bridge",
"user_a",
"ads.cs",
"unity/",
"adplay",
"rotati",
"ayer.s",
"ascdn.",
"api/ad",
"lackli",
"llerie",
"hserve",
"viewid",
"pbkt/h",
"ads/in",
"newsle",
"strate",
"firefo",
"premie",
"ges/te",
"logos/",
"net/im",
"100x10",
"ootbal",
"nline_",
"Image/",
"mage/2",
"entscr",
"vbulle",
"ite/im",
"wp-con",
"nt/ski",
"ploads",
"superb",
"js/lay",
"ges/ca",
"carbon",
"ges/ma",
"forum/",
"ates/v",
"w/deli",
"afr.ph",
"gid.co",
"tent.a",
"nners/",
"js/eas",
"ets/ad",
"orking",
"horizo",
"emaila",
"user_m",
"sideba",
"site-s",
"reamad",
"na_str",
"rammar",
"adifra",
"brands",
"rack.p",
"ads.go",
"quikr.",
"dingad",
"satoda",
"gannet",
"pictur",
"multia",
"clicku",
"php?pu",
"0x250,",
"topper",
"src/js",
"site-i",
"adfox.",
"block/",
"swf?ad",
"//deli",
"onp/pi",
"d4.liv",
"?LR_PU",
"R_VIDE",
"adaptv",
"orldre",
"realme",
"RealMe",
"adstre",
"js/sup",
"asino.",
"season",
"mended",
"Includ",
"~/medi",
"site_a",
"ayer_a",
"Bursti",
"adsame",
"nline/",
"js/rea",
"Skins/",
"flash-",
".php?k",
"arrant",
"ins/pa",
"php?ad",
"small_",
"deo.ph",
"dule=a",
"RM/Box",
"adsear",
"irtual",
"istia.",
"edia.n",
"app.me",
"ogleAd",
"jsplay",
"getad.",
"undays",
"?compr",
"ongtai",
"float.",
"ates/d",
"newpop",
"icroad",
"size=1",
"2013/a",
"automa",
"onclic",
"lickad",
"ins/wp",
"ery.ca",
"prerol",
"lishin",
"tags/v",
"nner.a",
"ashx?a",
"LocalA",
"photo/",
"type=o",
"leader",
"ges/fo",
"ervers",
"img/ho",
"samsun",
"layerA",
"ges/au",
"ges/we",
"pts/js",
"om/ipl",
"dex.as",
"hotcar",
"net/_a",
"html.n",
"Script",
"napdea",
"adspac",
"img/ch",
"getvid",
"stom/i",
"misc/a",
"ogle_a",
"mz.vo.",
"underw",
"ollywo",
"rcom-a",
"ets/in",
"admant",
"ript/b",
"ges/pa",
"ngine?",
"pts/li",
"nner/s",
"pts/po",
"lic/im",
"utures",
"js/ad-",
"ite/ge",
"cssjs/",
"ame_re",
"dserv.",
"adv_li",
"ads.ht",
"adv_bo",
"lickba",
"duct-a",
"ustomS",
"admin/",
"min/ad",
"nline-",
"js/mis",
"haturb",
"neral/",
"ogle_b",
"price/",
"dules_",
"ges/us",
"ges/am",
"rackad",
"mage/c",
"curren",
"reamat",
"js15.j",
"rofess",
"pl/ads",
"under.",
"ent/fl",
"hp?cli",
"dv.adv",
"pub/in",
"show_l",
"opUnde",
"photog",
"tents/",
"tribal",
"lick/a",
"ges/ab",
"ploadi",
"hared-",
"multim",
"cdn.vi",
"onster",
"zdcse.",
"extube",
"js/fun",
"nts/ad",
"ges/1.",
"ages.m",
"ript/a",
"scorev",
".fwmrm",
"ad/g/1",
"ogle/a",
"atic_a",
"exit.j",
"tic/po",
"php?na",
"nner_c",
"ws/com",
"js/dou",
"artist",
"erver?",
"enter.",
"groupo",
"yout/a",
"page-a",
"sitead",
"sid.ht",
"ss/sta",
"story_",
"ript/t",
"ss/adv",
"dvance",
"//feed",
"eedly.",
"adbann",
"adp/ad",
"click?",
"app/de",
"dailyn",
"ule=1&",
"inline",
"js/adc",
"adcode",
"edia.g",
"ick/im",
"ideopl",
"licklo",
"ry.jca",
"right-",
"main_a",
"dget.a",
"prod/t",
"promo/",
"js/adp",
"adinse",
"insert",
"age/ad",
"adscri",
"main/a",
"img/ba",
"ystem_",
"get_pr",
"ts/sho",
"post_i",
"mage/h",
"ges/dr",
"naukim",
"page-b",
"adtima",
"ages.y",
"php?g=",
"php?wm",
"rightn",
"js/pp.",
"dicate",
"pub/ad",
"heckm8",
"300_25",
"webmai",
"sitema",
"atch.c",
"erver_",
"dia/cm",
"shop/p",
"retrie",
"cdn-cg",
"nexp/d",
"ges/ex",
"tic/ht",
"247rea",
"dia/ad",
"js/cor",
"ideoad",
"ntentc",
"js/win",
"spectr",
"api/pr",
"oglefo",
"livesc",
"stom_v",
"ets/wi",
"skinni",
"foxspo",
"api/op",
"exocli",
"smart-",
"eagle-",
"topban",
"nner.h",
"randin",
"nner%2",
"essage",
"egistr",
".amazo",
"ountry",
"ootstr",
"etting",
"ner.js",
"ateway",
"erform",
"loudfr",
"rver.a",
"rticle",
"a-cdn-",
"dServe",
"dverti",
"rapper",
"ersona",
"oadcas",
"mini.y",
"ex.htm",
"lash/e",
"avascr",
"ules/c",
"s/jque",
"rowser",
"logger",
"iction",
"nclude",
"urveba",
"zonaws",
"ws.com",
"oading",
"es/con",
"annelS",
"s/init",
"es/pre",
"irefox",
"ategor",
"scount",
"ounter",
"oaded_",
"ices/a",
"struct",
"adrawd",
"t.com/",
"ts/js/",
"et/ads",
"ubmati",
"ds.php",
"cdn.co",
"extlin",
"d/css/",
"efresh",
"com/ma",
"nivers",
"evelop",
"tracks",
"isplay",
"cience",
"rector",
"illion",
"igital",
"roadba",
"dclick",
"et/acl",
"ds.htm",
"laceme",
"0x600_",
"timg.c",
"lement",
"on/js/",
"eather",
"load/a",
"p-cont",
"ection",
"ctions",
"ynamic",
"ompres",
"etwork",
"andler",
"ache/s",
"nstant",
"ools/c",
"alenda",
"keover",
"ottom_",
"andom=",
"terfac",
"paddre",
"nteres",
"//crea",
"ules/m",
"how_ad",
"eature",
"re.htm",
"uction",
"s/comm",
"azyloa",
"ribute",
"witcha",
"ender-",
"ds/sto",
"es/mai",
"ontend",
"yer.js",
"ottom.",
"ompare",
"ic/js/",
"hirdpa",
"es-ama",
"sktopM",
"otator",
"sl-ima",
"rossdo",
"ordpre",
"ghtbox",
"ex.php",
"es/big",
"es/top",
"es/lis",
"isting",
"iteo.c",
"very/a",
"js.php",
"nimati",
"ropdow",
"hostin",
"arquee",
"s/main",
"pi.php",
"di/eba",
"tm?Rtm",
"load/s",
"load/i",
"d_ids=",
"pecial",
"d/stat",
"s.rubi",
"roject",
"s/adsb",
"ub-con",
"onfig/",
"ver/ad",
"ds.js?",
"ached_",
"otname",
"ponse_",
"equest",
"filiat",
"indexx",
"00x100",
"annel4",
"martad",
"hp?id=",
"s/ad.c",
"d/imga",
"otific",
"ction=",
"apmsn.",
"remium",
"rice_p",
"arket.",
"et.com",
"es/glo",
"nding_",
"es/log",
"uttons",
"es/for",
"egiste",
"endor/",
"s/scri",
"s/popo",
"opover",
"amaihd",
"reroll",
"es/sty",
"ideos.",
"2/js/a",
"gi-bin",
"websta",
"ns/pag",
"ds/js/",
"nsumer",
"get/re",
"es/hom",
"es/pro",
"s/prom",
"websit",
"ts/img",
"amster",
"dos.js",
"eyword",
"rces/i",
"upport",
"iles.b",
"ponsiv",
"s/cont",
"raphic",
"ecnd.n",
"visit-",
"ompani",
"oreign",
"php?ui",
"ternat",
"tional",
"ms/js/",
"p-incl",
"rofile",
"utton_",
"lorsch",
"out.co",
"ges.ad",
"atelli",
"gle/ad",
"arketi",
"get.js",
"tandar",
"udienc",
"rivate",
"icktal",
"ampaig",
"ownloa",
"impact",
"omo.jp",
"nline.",
"entral",
"tudent",
"usines",
"d/logi",
"ource=",
"rces/j",
"s/popu",
"opup.j",
"mg/sta",
"annels",
"pen.js",
"elated",
"tersti",
"bile-a",
"xtras/",
"oneyba",
"romote",
"endor-",
"aluech",
"vents/",
"d-view",
"nblock",
"s/book",
"age-cr",
"ached/",
"ome/ba",
"ners.c",
"get/wi",
"romoti",
"rnhub.",
"ncdn.c",
"d/load",
"blepim",
"m/jque",
"rand/f",
"ertica",
"ommerc",
"ds.css",
"lidesh",
"omo.js",
"adsWra",
"loatin",
"ckgrou",
"lider.",
"uac/ad",
"ravity",
"ntelli",
"ddyn/3",
"omo.ph",
"obrand",
"otatio",
"ack.ph",
"k.php?",
"tories",
"00x600",
"ites/a",
"id.htm",
".blogs",
"logsmi",
"etflix",
"iles/a",
"es/adv",
"ax2/am",
"tes/us",
"es/use",
"ules/d",
"es/del",
"es/foo",
"tended",
"ared/m",
"s/Brig",
"ads--.",
"ache/c",
"z=970x",
"adurl=",
"wf?cli",
"timize",
"dunit=",
"erving",
"ad/sho",
"king.c",
"utbrai",
"nwk.1d",
"ckcdn.",
"ents/c",
"ts/ima",
"verest",
"dblock",
"pn.go.",
"edesig",
"esign/",
"ollege",
"hp?ref",
"d/comm",
"dbanne",
"lider-",
"om/com",
"balban",
"diatim",
"times.",
"rces/c",
"ternet",
"tdna-c",
"enx.ne",
"/1.0/j",
"/1.0/a",
"dsense",
"if?tag",
"ntext_",
"ts/mar",
"ivejas",
"m/vide",
"ia/vid",
"ancybo",
"ebserv",
"ext-li",
"dmanag",
"hoppin",
"s/goog",
"lank.h",
"dtube.",
"s/min/",
"ornsta",
"raffic",
"dframe",
"ommuni",
"s/G/01",
"uporn.",
"rnal/k",
"curity",
"ortals",
"dx/bin",
"ollow/",
"axonom",
"ts/hom",
"iews/a",
"dvert_",
"eferra",
"martli",
"share.",
"com.eg",
"ainpag",
"licida",
"es/cor",
"brasil",
"laceho",
"hinaad",
"dclien",
"s/free",
"rectre",
"s/adve",
"d.php?",
"ic/img",
"ore.js",
"andbox",
"elcome",
"ervlet",
"m/bann",
"iles/w",
"es/web",
"es/bac",
"dengin",
"potlig",
"dj/gn.",
"eo.php",
"ootsui",
"es/ico",
"&ifram",
"dometr",
"ainpar",
"dlink_",
"urchas",
"s/Popu",
"sapi?a",
"s/part",
"es/fon",
"rrentz",
"guardi",
"iscuss",
"mment-",
"tion/a",
"dServl",
".forbe",
"ntextu",
"eds.fe",
"edburn",
"eeds/w",
"tes/fr",
"nding/",
"vironm",
"ner_id",
"es/par",
"tners/",
"tes/tp",
"ules/a",
"deed.c",
"obsear",
"esigns",
"orting",
"es/cam",
"embers",
"ames/i",
"ostgat",
"woff?j",
"ared/i",
"age/ho",
"dgear.",
"ared/a",
"llpape",
"ds.min",
"dimage",
"es/ads",
"s/adse",
"tats.p",
"ipadvi",
"nerad/",
"es/sit",
"ic/ass",
"es/roo",
"et/fla",
"t/skin",
"opbar.",
"s/ad.j",
"d/inde",
"iles/p",
"ts/lif",
"adsapi",
"iles/b",
"ubscri",
"opads.",
"es/ban",
"emote_",
"dplaye",
"stem/a",
"scdn.c",
"dverto",
"es/com",
"pi/ads",
"ds.jso",
"acklis",
"leries",
"iewid=",
"bkt/hs",
"ilter.",
"ewslet",
"trateg",
"remier",
"et/ima",
"otball",
"es/200",
"ntscri",
"bullet",
"endor_",
"te/ima",
"loads/",
"s/laye",
"s/supe",
"opup-p",
"orum/i",
"fr.php",
"nforme",
"arketg",
"id.com",
"ent.ad",
"ts/adv",
"orizon",
"mailad",
"ser_me",
"idebar",
"eamads",
"a_stre",
"difram",
"ds.goo",
"ingads",
"atoday",
"annett",
"icture",
"ultiad",
"get.ph",
"hp?pub",
"lider_",
"0x600&",
"/adlib",
"rc/js/",
"wf?ad=",
"np/pid",
"4.live",
"LR_PUB",
"_VIDEO",
"rldred",
"ealmed",
"ealMed",
"s/adst",
"dstrea",
"telegr",
"dailyt",
"tomer/",
"s/easy",
"urstin",
"space.",
"ts/ad-",
"very/s",
"very/f",
"waterf",
"ds/vid",
"M/Box/",
"dsearc",
"radedo",
"dia.ne",
"pp.med",
"splaye",
"oaded.",
"lp.lon",
"ngtail",
"loat.j",
"otatin",
"tes/de",
"ools/p",
"twitch",
"iewer/",
"nclick",
"ickads",
"es/bit",
"ns/wp-",
"rfect-",
"rces/a",
"ther/a",
"ishing",
"utput.",
"es/adb",
"ner.as",
"dvert/",
"ages.e",
"nter.p",
"amsung",
"etriev",
"et/_ad",
"tml.ng",
"iles/j",
"apdeal",
"dspace",
"xposed",
"ts/liv",
"tom/in",
"es/sta",
"ites/d",
"ache/a",
"z.vo.l",
"llywoo",
"acker_",
"eaderb",
"lash/s",
"ome/ad",
"ipt/bl",
"es/sig",
"es/pag",
"ts/ads",
"ic/ima",
"very/c",
"annelb",
"dv_lib",
"dv_box",
"ickban",
"dmin/a",
"s/misc",
"aturba",
"es/sto",
"eral/a",
"urrent",
"ite_im",
"onsore",
"s/webm",
"ackads",
"age-ba",
"eamate",
"ads.ex",
"buysel",
"s15.js",
"ofessi",
"nt/fla",
"lash/a",
"yer/jw",
"dview.",
"v.advi",
"es/sid",
"pUnder",
"hotoga",
"ribalf",
"ight-a",
"s/doub",
"olumna",
"ultime",
"dn.vid",
"xit.js",
"dcse.m",
"nsole-",
"phanto",
"5min.c",
"corevi",
"onfigs",
"fwmrm.",
"d/g/1?",
"utomat",
"stia.n",
"ic/pop",
"inify/",
"ner_co",
"dvert.",
"iddle_",
"line_a",
"rtists",
"roupon",
"iteadv",
"ts/int",
"s/real",
"vanced",
"econom",
"edly.c",
"dp/adp",
"nlinet",
"ailyne",
"s/adco",
"deopla",
"y.jcar",
"get.as",
"s/adpu",
"line/a",
"dinser",
"ge/ads",
"dscrip",
"ts/wid",
"mg/ban",
"et_pre",
"ticky_",
"aukimg",
"themif",
"dverts",
"hp?wmi",
"s/pp.j",
"eckm8.",
"0x600/",
"00_250",
"ata/ca",
"tch.co",
"es/inf",
"ices/s",
"dn-cgi",
"exp/do",
"ic/htm",
"47real",
"ia/ads",
"s/core",
"popups",
"deoad.",
"tentca",
"pectru",
"pi/pro",
"ivesco",
"tiliti",
"ts/pop",
"kinnin",
"oxspor",
"xoclic",
"mart-a",
"opbann",
"ner.ht",
"geomet",
"crypt.",
"hrome-",
"benchm",
"goal.c",
"gistra",
"otstra",
"ttings",
"teway/",
"oudfro",
"s.json",
"ver.ad",
"-cdn-n",
"Server",
"vertis",
"ing.co",
"apper/",
"mpress",
"rsonal",
"s/font",
"adcast",
"ch.com",
"ini.ya",
"x.html",
"vascri",
"sense.",
"ctiona",
"frame?",
"rvebal",
"onaws.",
"s/live",
"er.js?",
"les/pr",
"s/vide",
"lient.",
"tegory",
"ticle_",
"unters",
"/main.",
"cture/",
"drawda",
"bmatic",
"s.php?",
"frame=",
"dn.com",
"xtlink",
"/login",
"ements",
"hardwa",
"oadban",
"t/aclk",
"splay-",
"s.html",
"d.com/",
"acemen",
"cludes",
"tname=",
"ript.j",
"tube.c",
"inpage",
"adlib/",
"ather-",
"l-imag",
"tent/p",
"ction/",
"namic_",
"s/logo",
"s/user",
"s/sign",
"s/home",
"lendar",
"om/int",
"erface",
"addres",
"terest",
"splay/",
"les/mo",
"ow_ads",
"s.com.",
"zyload",
"owser-",
"manage",
"s/stor",
"/init.",
"tent/d",
"s/styl",
"irdpar",
"s-amaz",
"tewayA",
"ebsite",
"blogsp",
"lient-",
"ossdom",
"rdpres",
"x.php?",
"s/list",
"teo.co",
"ery/aj",
"imatio",
"framew",
"opdown",
"osting",
"c/js/i",
"i/ebay",
"m?RtmC",
"tes/al",
"ecial_",
".rubic",
"adsbyg",
"b-conf",
"quest_",
"s/img/",
"s/js/a",
"iliate",
"/ad.cs",
"imgad?",
"clude/",
"tifica",
"bsearc",
"pmsn.j",
"er_id=",
"twork/",
"s/glob",
"ding_p",
"gister",
"er.htm",
"maihd.",
"s/icon",
"deos.c",
"splay.",
"i-bin/",
"untry_",
"s/site",
"ebstat",
"s/page",
"g/stat",
"/statu",
"mster.",
"ic.adz",
"adzerk",
"onsive",
"iversa",
"les/co",
"aphics",
"gitals",
"les/js",
"cnd.ne",
"query_",
"mpanio",
"r.php?",
"hp?uid",
"ernati",
"-inclu",
"orsche",
"ut.com",
"ngine/",
"tellit",
"rketin",
"andard",
"dience",
"cktale",
"mpaign",
"wnload",
"siness",
"ces/js",
"pup.js",
"s/side",
"ement.",
"erstit",
"s/foot",
"neybal",
"pport/",
"-view-",
"block-",
"me/ban",
"ories/",
"et/wid",
"et.js?",
"omotio",
"nhub.c",
"s/prem",
"emium-",
"c/js/p",
"lepimp",
"s/widg",
"rtical",
"mmerci",
"idesho",
"dsWrap",
"oating",
"kgroun",
"huffin",
"ac/adp",
"avity.",
"tream.",
"dyn/3.",
"mo.php",
"tion/b",
"d.html",
"atured",
"ogsmit",
"tflix.",
"x2/amz",
"ticles",
"ading.",
"/Brigh",
"ds--.j",
"f?clic",
"imized",
"ticle-",
"itchad",
"om/imp",
"ogle_s",
"d/show",
"ature/",
"tbrain",
"wk.1d/",
"kcdn.c",
"s/imag",
"n.go.c",
"albann",
"iatime",
"imes.c",
"s/bann",
"dna-cd",
"nx.net",
"1.0/js",
"1.0/ac",
"sense_",
"vejasm",
"min.co",
"a/vide",
"ncybox",
"bservi",
"opping",
"x600_b",
"ogle_t",
"ank.ht",
"rnstar",
"/min/t",
"afficj",
"rame.j",
"mmunit",
"/G/01/",
"porn.c",
"tion/l",
"rtals/",
"x/bin/",
"ather/",
"xonomy",
"ews/ad",
"nts/co",
"ferral",
"artlin",
"om.eg/",
"tructi",
"ction.",
"ucGl4b",
"icidad",
"eries/",
"rasile",
"acehol",
"ner%20",
"inaadc",
"ectrev",
"eed.co",
"c/js/a",
"/booki",
"c/img/",
"ssages",
"block_",
"block.",
"c/asse",
"splay_",
"rvlet/",
"s/back",
"otligh",
".php?t",
"otsuit",
"e/imag",
"ometry",
"sense/",
"rving.",
"inpark",
"s/inte",
"rchase",
"/Popup",
"api?au",
"n/js/a",
"rentz.",
"uardia",
"ernetb",
"Servle",
"s/js/p",
"lcome/",
"lcomea",
"textua",
"orbes.",
"et.php",
"ds.fee",
"dburne",
"space=",
"ather_",
"ironme",
"es/tpl",
"rving/",
"signs/",
"s/camp",
"tent/m",
"stgato",
"lpaper",
"s.min.",
"pbanne",
"es/fro",
"smart.",
"s/root",
"t/flas",
"s/topb",
"pbar.j",
"es/def",
"padvis",
"tion=a",
"conomi",
"bscrib",
"artads",
"vertor",
"cklist",
"kt/hse",
"lter.p",
"esign_",
"wslett",
"rategy",
"t/imag",
"tscrip",
"ulleti",
"twork_",
"tent/t",
"tent/u",
"oads/t",
"ment-a",
"ery/af",
"former",
"rizon.",
"amads.",
"_strea",
"tream_",
"ndlers",
"p/pid=",
".liver",
"R_PUBL",
"VIDEO_",
"ldredi",
"almedi",
"alMedi",
"omaint",
"x.php/",
"elegra",
"rsting",
"splay?",
"me/ads",
"pace.c",
"ktopMo",
"debar-",
"=970x9",
"ery/sp",
"ery/fl",
"adv.wp",
"adedou",
"namic/",
"lliona",
"sting_",
"p.medy",
"tworks",
"aded.n",
"p.long",
"gtailv",
"oat.js",
"tating",
"rizont",
"witch.",
"rforma",
"xt-lin",
"ces/ad",
"s/adbl",
"ndler/",
"debar.",
"ter.ph",
"nnels/",
"omoted",
"planet",
"trieve",
"ml.ng/",
"main_b",
"pdeal.",
".vo.ll",
"lywood",
"s/info",
"aderbo",
"ntend/",
"pover-",
"les/di",
"s/fore",
"bloomb",
"c/imag",
"ery/ck",
"s/adv_",
"v_libr",
"mmerce",
"/misc.",
"turbat",
"brand.",
"blocke",
"te_ima",
"nsored",
"gear.j",
"rrent/",
"amate.",
"ds.exo",
"lick.p",
"histat",
"uysell",
"fessio",
".advie",
"view.p",
"Under.",
"otogal",
"cript_",
"splayA",
"ibalfu",
"mbersh",
"yword_",
"ltimed",
"n.vidi",
"cse.mi",
"hantom",
"wmrm.n",
"/g/1?p",
"tia.ne",
"er_con",
"oads/b",
"vert.j",
"cript1",
"dly.co",
"ilynew",
"eoplay",
".jcaro",
"g/bann",
"ukimg.",
"stocki",
"ctureo",
"hemify",
"vertse",
"p?wmid",
"lcome_",
"ckm8.c",
"er.jsp",
"cluded",
"er.asp",
"refox_",
"n-cgi/",
"xp/dok",
"c/html",
"7realm",
"a/ads/",
"ectrum",
"ripts-",
"vescor",
"ilitie",
"inning",
"ces/se",
"xsport",
"oclick",
"framet",
"eometr",
"enchma",
"oal.co",
"com/st",
"tstrap",
"udfron",
"tion.p",
"er.adt",
"cdn-ns",
"ertisi",
"ng.com",
"pper/a",
"?click",
"ession",
"h.com/",
"ni.yah",
"ascrip",
"main.j",
"tionar",
"s/defa",
"veball",
"naws.c",
"anager",
"nters.",
"rawdat",
"adviso",
".json?",
"rver/j",
"es/js/",
"tlink.",
"in.com",
"970x90",
"cement",
"ardwar",
"chicag",
"manhat",
"knowle",
"adband",
"ludes/",
"ipt.js",
"ube.co",
"ommon.",
"com/if",
"/fonts",
"t/widg",
"tings/",
"presse",
"_libra",
"t-link",
"sports",
"m/inte",
"rface/",
"ddress",
"es/mod",
"w_ads_",
"r.htm?",
"rdpart",
"-amazo",
"logspo",
"ssdoma",
"dpress",
"sting/",
"eo.com",
"ry/ajs",
"mation",
"egory-",
"nder.j",
"login-",
"bay.co",
"/ebay.",
"?RtmCm",
"tyle/l",
"es/all",
"cial_a",
"rubico",
"dsbygo",
"-confi",
"erest.",
"liate=",
"ad.css",
"mgad?i",
"ificat",
"ear.js",
"msn.js",
"rfectm",
"ent/pr",
"ing_pa",
"r.html",
"aihd.n",
"rollin",
"/icons",
"eos.co",
"-bin/w",
"cataly",
"status",
"age-co",
"ster.c",
"ertise",
"c.adze",
"dzerk.",
"npage/",
".com/0",
"works/",
"ly.com",
"istats",
"versal",
"bar.js",
"nd.net",
"mate.c",
"panion",
"oter_l",
"p?uid=",
"er.php",
"unique",
"rnatio",
"nsive-",
".go.co",
"rschem",
"ellite",
"keting",
"mediaf",
"ace.co",
"kimg.c",
"ment.j",
"rstiti",
"observ",
"eyball",
"wser-s",
"ience/",
"nload_",
"e/bann",
"indust",
"nner/b",
"motion",
"hub.co",
"emium/",
"s/fron",
"mercia",
"deshow",
"sWrapp",
"ating_",
"yload-",
"ground",
"tured_",
"uffing",
"c/adpa",
"yn/3.0",
"ion/ba",
"gsmith",
".com.a",
"2/amzn",
"sharin",
"w_ads.",
"Bright",
"s--.js",
"sonobi",
"m/adse",
"mized-",
"nloads",
"nload-",
"tical.",
"init.m",
"lbanne",
"mes.co",
".com&r",
"na-cdn",
"x.net/",
".0/jst",
".0/acj",
"xMsMwo",
"ejasmi",
"bn.uol",
"gle_to",
"nk.htm",
"fficju",
"ame.js",
"munity",
"orn.co",
"/bin/a",
"identi",
"ices/j",
"view-m",
"ments/",
"erral_",
"ed.com",
"ructio",
"ries/m",
"asilei",
"rrent.",
"cidade",
"cehold",
"naadcl",
"ctrev.",
"se.min",
"bookin",
"sages.",
"play_a",
"arch_i",
"ries/b",
"tion.s",
"tlight",
"tsuite",
"anagem",
"npark.",
"ardian",
"paigns",
"r_cont",
"pi?aut",
"ense/s",
"entz.e",
"americ",
"capita",
"rvlet?",
"comead",
"extual",
"ia.net",
"rbes.c",
"s.feed",
"burner",
"ronmen",
"cripto",
"s/tpl/",
"es/sea",
"tgator",
"journe",
"pping.",
"how_co",
"ense.j",
"ads.ni",
"mart.j",
"opbar/",
"o.php?",
"scribe",
"lock_d",
"nload.",
"rtadse",
"ertori",
"liate-",
"t/hser",
"slette",
"sign_s",
"lletin",
"ent/pl",
"ent/th",
"ent/up",
"amic_a",
"rainbo",
"ry/afr",
"gaming",
"inside",
"ream_b",
"vidibl",
".vidib",
"iverai",
"_PUBLI",
"IDEO_I",
"dredif",
"lmedia",
"lMedia",
"ream_m",
"mainto",
"legrap",
"-bin/j",
"ndard_",
"stingP",
"lude/b",
"topMod",
"tals/0",
"ry/spc",
"ry/fl.",
"dv.wp.",
"dedoub",
"m/imp?",
"lionai",
".medya",
"ded.ne",
".longt",
"tailvi",
"izonta",
"itch.t",
"forman",
"/backs",
"lude/p",
"lock.j",
"jcarou",
"l.ng/a",
"deal.c",
"replac",
"cybox/",
"ries/s",
"liate_",
"vo.lln",
"derboa",
"/globe",
"loombe",
"ry/ck.",
"merce/",
"tend/a",
"misc.j",
"urbate",
"paign%",
"locker",
"e_imag",
"chroni",
"locald",
"vlet/v",
"s.exoc",
"lick.c",
"ick.ph",
"er%20a",
"otherl",
"iew.pl",
"togall",
"playAd",
"balfus",
"ages.b",
"bershi",
"timedi",
"iew.ph",
".php?s",
"dlers/",
"mrm.ne",
"g/1?pr",
"eleven",
"ert.js",
"italia",
"yles/e",
"ript1.",
"lynews",
"thenew",
"play.a",
"monkey",
"tical_",
"ts/con",
"joomla",
"tured-",
"emify.",
"ertser",
"come_a",
"tribun",
"km8.co",
"nloadf",
".php?m",
"ormer/",
"-cgi/p",
"pping/",
"pport.",
"22:200",
"escore",
"liates",
"liateC",
"lities",
"tic/ta",
"locked",
"nchmar",
"al.com",
"om/sta",
"strap/",
"ments.",
"dfront",
"r.adte",
"dia.co",
"ce.com",
"dn-ns.",
"rtisin",
"s.yimg",
"i.yaho",
"score/",
"ain.js",
"ionary",
"eball/",
"aws.co",
"nager.",
"carous",
"ent.js",
"awdata",
"s/js/c",
"a.net/",
"dvisor",
"ver/js",
"ation-",
"der.js",
"70x90%",
"rdware",
"hicago",
"anhatt",
"nowled",
"clickT",
"e.min.",
"y.com/",
"be.com",
"mmon.j",
"om/ifr",
"icons/",
"ressed",
"s/sear",
"click=",
"imedia",
"ter.co",
"ter_lo",
"ock.js",
"dparty",
"ogspot",
"sdomai",
"press.",
"ting/t",
"y/ajs.",
"com/go",
"_contr",
"ay.com",
"RtmCmd",
"s/all/",
"ript/l",
"ial_ad",
"ubicon",
"sbygoo",
"ipts/r",
"nfig/c",
"_ads_i",
"rn.com",
"rest.c",
"d.css?",
"gad?id",
"ficati",
"ads1.m",
"nt/pro",
"ng_pag",
"com/la",
"ihd.ne",
"d.net/",
"olling",
"os.com",
"atalys",
"scheme",
"tatus?",
".adzer",
"zerk.n",
"ersal.",
"bbc.co",
"go.com",
"udes/c",
"udes/j",
"ub.com",
"ate.co",
"phics.",
"s/js/s",
"ement/",
"round-",
"stitia",
"nager/",
"-link-",
"round/",
"ndustr",
"ner/ba",
"ipts/i",
"ercial",
"Wrappe",
"ffingt",
"/adpag",
"n/3.0/",
"ured_p",
"smithm",
"com.au",
"amzn_a",
"haring",
"edia_m",
"ailyma",
"rightc",
"onobi.",
"ized-b",
"Media/",
"sharet",
"ents/i",
"nagers",
"cript?",
"s/js/m",
"rtiser",
"nit.mi",
"ting_b",
"eshow/",
"a-cdn.",
".net/w",
"0/jsta",
"0/acj?",
"jasmin",
"uol.co",
"html?&",
"n.uol.",
"le_top",
"k.html",
"ficjun",
"ript/j",
"bin/ad",
"iew-ma",
"eting/",
"rral_b",
"sileir",
"eholde",
"aadcli",
"otions",
"art.js",
"ooking",
"ages.j",
"lay_ad",
"ion.sc",
"nageme",
"park.c",
"aigns/",
"i?auto",
"nse/se",
"badoo.",
"om/con",
"udes/a",
"udes/b",
"ediafi",
"ntz.eu",
"rdian.",
"merica",
"apital",
"xtual.",
"bes.co",
".feedb",
"urner.",
"onment",
"bet365",
"ourney",
"icktag",
"ow_com",
"nse.js",
"ds.nic",
"rtisem",
"page/b",
"load-e",
"tadser",
"fonts_",
"rtoria",
"photob",
"letter",
"nt/plu",
"nt/the",
"nt/upl",
"press-",
"ainbow",
"y/afr.",
"eam_br",
"eting.",
"idible",
"verail",
"PUBLIS",
"DEO_ID",
"rediff",
"eam_mj",
"ion.ph",
"aintoo",
"egraph",
"pts/co",
"eting-",
"tingPi",
"ters.j",
"ude/bu",
"opModu",
"als/0/",
".php?b",
"y/spcj",
"y/spc.",
"y/fl.j",
"v.wp.p",
"edoubl",
"ionair",
"medyan",
"lickth",
"ed.net",
"ailvid",
"ault/f",
"zontal",
"face/i",
"tch.tv",
"ormanc",
"load-n",
"dentit",
"ional/",
"ping.s",
"tent_s",
"videod",
"eal.co",
"rent.c",
"eplace",
"roundw",
"o.llnw",
"erboar",
"ript/i",
"tats.c",
"oomber",
"y/ck.p",
"brary3",
"end/ad",
"tend/w",
"isc.js",
"rbate.",
"hronic",
"gear.c",
"ocalda",
"let/vi",
".exocl",
"ick.co",
"ssiona",
"therle",
"ew.pl/",
"otiona",
"ional.",
"alfusi",
"ership",
"ew.php",
"ser-sc",
"ault/i",
"rm.net",
"/1?pro",
"ynews.",
"ities/",
"rtserv",
"ribune",
"m8.com",
"php?mo",
"dress.",
"cgi/pe",
"s/mod_",
"iates.",
"iateCr",
"ports.",
"chmark",
"m/stat",
"ers.js",
"front.",
".net/s",
".net/e",
"tserve",
"tech.d",
"ia.com",
"n-ns.a",
"dtechu",
"tising",
".yimg.",
".yahoo",
"s/conv",
"arouse",
"wdata/",
"visor.",
"er/js/",
"tion-2",
"0x90%7",
"nhatta",
"owledg",
"lickTA",
"ting/b",
".net/r",
"mon.js",
"m/ifra",
"/js/si",
"er.com",
"er_log",
"gspot.",
"ress.c",
"atic.n",
"ing/to",
".php?z",
"trap/j",
"js/cod",
"ebayrt",
"com/bi",
"ipt/li",
"biconp",
"bygoog",
"fig/ca",
"_impl.",
"te.com",
"est.co",
"ad?id=",
"ds1.ms",
"com/cl",
"g_page",
"om/lan",
"pts/re",
"hd.net",
"talyst",
"b.com/",
"ns/ads",
"nts/im",
".com/n",
"erk.ne",
"bc.co.",
"babble",
"des/js",
"show/i",
"titial",
"core/b",
"etter-",
"agemen",
"dustry",
"er/ban",
"pts/in",
"apper.",
"fingto",
"adpage",
"cons/i",
"mithme",
"/all/t",
"mzn_ad",
"ilymai",
"ightco",
"party/",
"nobi.c",
"zed-by",
"js/man",
"agers/",
"it.min",
"ing_ba",
"s.com%",
"-cdn.c",
"net/w/",
"asmin.",
"asmin/",
"ol.com",
".uol.c",
"tml?&c",
"icjunk",
"ipt/jq",
"in/adx",
"ew-man",
"ager.j",
"ts/com",
"om/goo",
"essed.",
"holder",
"tiser/",
"cheme/",
"ges.js",
"/spc.p",
"ark.cg",
"m.net/",
"pModul",
"?autol",
"se/sea",
"adoo.c",
"diafir",
"tz.eu/",
"erican",
"graph.",
"cons/a",
"rner.c",
"et365.",
"cktag=",
"w_comp",
"s.nico",
"tiseme",
"ck.com",
"rver.c",
"oad-ex",
"torial",
"hotobu",
"t/plug",
"t/them",
"t/uplo",
"am_bre",
"dible.",
"tisers",
"erail.",
"UBLISH",
"EO_ID=",
"ediff/",
"am_mjx",
"on.php",
"intool",
"ingPip",
"ntrol.",
"/spcjs",
"/fl.js",
".wp.pl",
"oubler",
"onaire",
"edyane",
"e_top_",
"ickthr",
"ilvide",
"rmance",
"entity",
"ehow.c",
"omain.",
"ent_so",
"rcial/",
"ult/fi",
".llnwd",
"rboard",
"rsal.h",
"omberg",
"bate.c",
"ronicl",
"ear.co",
"caldat",
"et/vie",
"ats.co",
"sional",
"ads_in",
"herles",
"com/am",
"w.pl/a",
"8.com/",
"lfusio",
"w.php?",
"er-scr",
"1?prof",
"ontal_",
"/3.0/7",
"y.com.",
"raphin",
"llings",
"hp?mod",
"gi/pe/",
"/ads/C",
"ateCre",
"onary/",
"orts.c",
"a.com/",
"r.com/",
"ront.n",
"ech.de",
"-ns.ad",
"techus",
"ising.",
".com%2",
"net/em",
"rousel",
"data/3",
".com/u",
"r/js/u",
"ts.com",
"ion-20",
"onvers",
"x90%7C",
"hattan",
"wledge",
"ickTAG",
"impl.j",
"s/comp",
"/cloud",
"rotate",
"spot.c",
"ess.co",
"ng/too",
"php?zo",
"Module",
"s/code",
"n.php?",
"bayrtm",
"pt/lib",
"iconpr",
"ygoogl",
"ig/ca-",
"k.com/",
"s1.msa",
"om/cli",
"_pages",
"t.min.",
"js/sit",
"s/js/b",
"rk.net",
".com.m",
"c.co.u",
"gins/u",
"board_",
"how.co",
"s/js/l",
"itial-",
"ore/ba",
"itial/",
"gement",
"r/bann",
"pper.j",
"ington",
"dpage.",
"ithmed",
"all/th",
"zn_ads",
"lymail",
"ghtcov",
"arty/a",
"obi.co",
"ed-by.",
".com/f",
"/women",
"ng_ban",
"js/cat",
"et/w/1",
"emes/s",
"gins/b",
"gins/m",
"l.com.",
"net/sc",
"cjunky",
"pt/jqu",
"w-mana",
"ger.js",
"m/goog",
"gins/t",
"et/ad/",
"gins/f",
"spc.ph",
"s/js/e",
"rk.cgi",
"gins/s",
"autolo",
"e/sear",
"doo.co",
"iafire",
"ising-",
"ner.co",
"tch-no",
"t365.c",
"ver.co",
"/cover",
"anion_",
".nicov",
"isemen",
"isor.c",
"active",
"ising/",
"ktag=h",
"otobuc",
"babylo",
"emes/e",
"ising_",
"m_brew",
"com/jp",
"ible.t",
"isers/",
"rail.c",
"BLISHE",
"m_mjx.",
"ntools",
"raph.c",
"ngPipe",
"emes/b",
"thunde",
"spcjs.",
"oads/v",
"wp.pl/",
"ubler.",
"dyanet",
"_top_e",
"ckthru",
"lvideo",
"ar.com",
"emes/d",
"emes/v",
"ins/pl",
"ntity-",
"mance_",
"emes/f",
"lt/fil",
"llnwd.",
"net/re",
"ricana",
"sal.ht",
"ts/rem",
"x250.j",
"mberg.",
"com/cr",
"onicle",
"orial.",
"itial_",
"aldata",
"t/view",
"erless",
"l/ads/",
"emes/o",
"fusion",
"r-scri",
"?prof=",
"emes/z",
"crypto",
"-adver",
"om/ada",
"i/pe/b",
"ads/Cr",
"orial/",
"teCrea",
"rts.co",
"emes/n",
"ont.ne",
"com/in",
"ch.de/",
"ns.adt",
"echus.",
"com%2F",
"ata/3.",
"/js/un",
"nversi",
"ow.com",
"ckTAG=",
"mpl.js",
"mes/ex",
"ins/sa",
"t/lib/",
"pot.co",
"ss.com",
"t/jque",
"g/tool",
"hp?zon",
"ayrtm.",
"conpro",
"ogle.j",
"g/ca-p",
"1.msad",
"et/ado",
".co.uk",
"-scrip",
"per.js",
"ngtonp",
"page.h",
"thmedi",
"ll/the",
"n_ads.",
"ymail.",
"ail.co",
"htcove",
"bi.com",
"d-by.r",
"m/clic",
"g_bann",
"t/w/1.",
"connec",
"ousel.",
".com.b",
"et/scr",
"junky.",
"-manag",
"tools.",
"pc.php",
"k.cgi?",
"/js/bg",
"ins/fa",
"utoloa",
"rch/as",
"afire.",
"ch-now",
"365.co",
"ins/ba",
"com/fr",
"nion_a",
"nicovi",
"sement",
"sor.co",
"kamai.",
"sing/a",
"com/di",
"tag=ht",
"tobuck",
"abylon",
"urces.",
"_brewe",
"ble.tv",
"LISHER",
"_mjx.a",
"aph.co",
".com/~",
"gPipe/",
"90%7C7",
"hunder",
"rch/ad",
"pcjs.p",
"m/ads.",
"p.pl/R",
"yaneta",
"top_ex",
"kthru=",
"ideo.c",
"mes/de",
"/codec",
"sing/p",
"ance_a",
"sing.j",
"t/file",
"lnwd.n",
"al.htm",
"s/remo",
"berg.c",
"mes/vi",
"ldata.",
"om/js1",
"rless.",
"om/cre",
"usion.",
"t/ad/g",
"mes/ze",
"m/adam",
"/pe/ba",
"ds/Cre",
"eCreat",
"imagef",
"versio",
"uery.m",
"or.com",
"nt.net",
"s.adte",
"chus.c",
"Creati",
"es/vid",
"h.de/?",
"ta/3.0",
"js/uni",
"w.com/",
"ments-",
"ns/sam",
"l.html",
"ot.com",
"/tool/",
"p?zone",
"yrtm.c",
"onproj",
"gle.js",
"/ca-pu",
"hmedia",
".msads",
"ipts/d",
"iles/2",
"t/ados",
"ement_",
"ement-",
"aolcdn",
"gtonpo",
"age.ht",
"l/them",
"azon-a",
"mail.c",
"tcoveE",
"i.com/",
"-by.ru",
"ag=htt",
"c.php?",
"cbsist",
"onnect",
"usel.j",
"com.br",
"t/scri",
"unky.n",
"nyt.co",
"usel.m",
"ools.c",
"toload",
"ch/asy",
"ments_",
"om%2Ff",
"65.com",
"om/fro",
"ion_ad",
"icovid",
"ents.j",
"ather.",
"ing.js",
"amai.n",
"ing/ad",
"om/dif",
"obucke",
"bylon.",
"brewer",
"le.tv/",
"il.com",
"ISHER_",
"mjx.ad",
"ph.co.",
"0%7C72",
"Pipe/a",
"cjs.ph",
".pl/RM",
"anetad",
"op_exp",
"deo.co",
"om/inf",
"nwd.ne",
"erg.co",
"es/vip",
"m/js15",
"less.c",
"m/crea",
"sion.c",
"pe/bag",
"s/Crea",
"ersion",
"t.net/",
"hus.co",
".de/?a",
"a/3.0/",
"s/univ",
"ca-pub",
"tool/y",
"?zonei",
"rtm.co",
"nproje",
"msads.",
"pts/da",
"olcdn.",
"tonpos",
"ge.htm",
"zon-ad",
"il.co.",
"coveEx",
"by.rub",
"%7C728",
"bsista",
"nnecti",
"sel.js",
"om.br/",
"l.com/",
"nky.ne",
"yt.com",
"om/mar",
"sel.mi",
"?zones",
"ols.co",
"oload=",
"h/asyn",
"m/fron",
"on_ad.",
"covide",
"nts.js",
"mai.ne",
"m/diff",
"ucket.",
"ylon.c",
"rewer/",
"e.tv/j",
"SHER_I",
"jx.ads",
"h.co.u",
"ipe/ad",
"pl/RM/",
"netads",
"p_exp.",
"_1280x",
"wd.net",
"ther.c",
"com/we",
"rg.com",
"s/vip/",
"com/j.",
"e.tv/p",
"e/bag2",
"/Creat",
"ativeB",
"us.com",
"de/?ad",
"ersalp",
"rsion.",
"a-pub-",
"ool/ya",
"com/de",
"tm.com",
"oject.",
"co.uk/",
"sads.n",
"net/st",
"lcdn.c",
"onpost",
"on-ads",
"l.co.u",
"oveExp",
"y.rubi",
"7C728x",
"sistat",
"ky.net",
"m/mark",
"net/ss",
"el.min",
"ls.com",
"/async",
"n_ad.j",
"ovideo",
"ai.net",
"cket.c",
"lon.co",
"ewer/b",
".tv/js",
"HER_ID",
"x.ads/",
"pe/adS",
"l/RM/B",
"etads.",
"_exp.j",
"com/?c",
"her.co",
"om/wel",
"/vip/t",
"om/j.a",
".tv/pr",
"/bag2?",
"tiveBa",
"m.com/",
"e/?adr",
"rsalpi",
"l.min.",
"sion.j",
"ol/yad",
"om/del",
"ject.c",
"om/par",
"com/pu",
"ads.ne",
"com/si",
"o.uk/m",
"o.uk/i",
"npost.",
"m/addy",
"n-adsy",
"veExpe",
"C728x9",
"istati",
"y.net/",
"async-",
"ideo.j",
"ket.co",
"wer/br",
"tv/jso",
"ER_ID=",
"e/adSe",
"tads.c",
"exp.js",
"om/?co",
"m/welc",
"m/j.ad",
"tv/pro",
"bag2?r",
"iveBan",
"ion.js",
"atic.c",
"salpix",
"l/yads",
"m/deli",
"com/rt",
"ect.co",
"m/part",
"om/pub",
"eExper",
"ds.net",
"om/sit",
"ds.com",
".uk/mo",
"post.c",
"ystem.",
".net/j",
"sync-a",
"deo.jp",
"com/pb",
"er/bre",
"v/json",
"com/?L",
"rver.b",
"m/?com",
"v/prod",
"ag2?r[",
"veBann",
"tic.co",
"alpixe",
"/yads/",
"om/rtm",
"ct.com",
"m/pub-",
"Experi",
"m/site",
"uk/mod",
"stem.c",
"fiverr",
"net/js",
"ync-ad",
"eo.jp/",
"om/pbk",
"r/brew",
"om/?LR",
"ver.bs",
"om/ad.",
"ost.co",
"g2?r[]",
"eBanne",
"ic.com",
"lpixel",
"yads/y",
"m/rtm?",
"om/ad/",
"k/modu",
"xperie",
"tem.co",
"iverr.",
"et/js/",
"nc-ads",
"o.jp/a",
"m/pbkt",
"/brew/",
"m/?LR_",
"er.bs?",
"m/ad.j",
"st.com",
"2?r[]=",
"imstor",
"pixel.",
"perien",
"em.com",
"verr.c",
"t/js/a",
".com/_",
"c-ads.",
".jp/as",
"&pvid=",
"rving-",
"mstore",
"ixel.j",
"erienc",
"om/aax",
"-ads.j",
"err.co",
"jp/ass",
"ion.st",
"ving-s",
"tore.b",
"xel.js",
"rience",
"m/aax2",
"rr.com",
"p/asse",
"on.str",
"ing-sy",
"ore.be",
"matic.",
"iences",
"com/ja",
"n.stre",
"ng-sys",
"re.bet",
"c.com/",
"hten.c",
"ences.",
"om/jav",
"mads.y",
"g-sys.",
"e.bet3",
".com/A",
"ads.ya",
"nces.j",
"m/java",
"-sys.c",
".bet36",
"com/Ad",
"ds.yah",
"ces.js",
"sys.co",
"et365a",
"om/AdS",
"s.yaho",
"bright",
"ys.com",
"t365af",
"m/AdSe",
"com/na",
"tcove.",
".com/B",
"365aff",
"cove.c",
"om/na_",
"com/Bu",
"65affi",
"ove.co",
"m/na_s",
"om/Bur",
"5affil",
"ve.com",
"m/Burs",
"ates.c",
"m/js/B",
"tes.co",
"com/Af",
"om/Aff",
"m/Affi",
"energy",
"l.yimg",
"mon/af",
"ins/us",
"ins/au",
"ings/a",
"Frame_",
"press/",
"ns/use",
"ns/aut",
"s/auto",
"tomati",
"data=a",
"ads/la",
"-ad-co",
"/ads/r",
"transa",
"oter.h",
"ads/re",
"ter.ht",
};

const char *badSubstrings[] = {"http", "www" };
