/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.css.parser.analyzer.ParseException;
import org.w3c.css.util.ApplContext;

public class InvalidParamException
extends ParseException {
    String errorType = null;
    private static HashMap<String, String[]> exceptionMessages = new HashMap();
    private static HashMap<String, int[]> exceptionOrder = new HashMap();

    public InvalidParamException() {
    }

    public InvalidParamException(String error, ApplContext ac) {
        super(ac.getMsg().getErrorString(error != null ? error : ""));
        this.errorType = error;
    }

    public InvalidParamException(String error, Object message, ApplContext ac) {
        super(InvalidParamException.processError(error, new String[]{message != null ? message.toString() : null}, ac));
        this.errorType = error;
    }

    public InvalidParamException(String error, String[] args, ApplContext ac) {
        super(InvalidParamException.processError(error, args, ac));
        this.errorType = error;
    }

    public InvalidParamException(String error, Object message1, Object message2, ApplContext ac) {
        super(InvalidParamException.processError(error, new String[]{message1 != null ? message1.toString() : null, message2 != null ? message2.toString() : null}, ac));
        this.errorType = error;
    }

    public String getErrorType() {
        return this.errorType;
    }

    private static String processError(String error, String[] args, ApplContext ac) {
        StringBuilder sb = new StringBuilder();
        String str = null;
        if (error != null) {
            str = ac.getMsg().getErrorString(error);
        }
        if (str == null) {
            return "can't find the error message for " + error;
        }
        int[] order = null;
        String[] msg_parts = null;
        boolean paramgenericorder = true;
        msg_parts = exceptionMessages.get(str);
        if (msg_parts != null) {
            order = exceptionOrder.get(str);
            if (order != null) {
                paramgenericorder = false;
            }
        } else {
            try {
                Pattern p = Pattern.compile("%s\\d?");
                msg_parts = p.split(str, -1);
                Matcher m = p.matcher(str);
                int nbparam = 0;
                order = new int[10];
                paramgenericorder = true;
                while (m.find()) {
                    String group = m.group();
                    if (group.length() > 2) {
                        if (nbparam == 0 || !paramgenericorder) {
                            int o;
                            paramgenericorder = false;
                            order[nbparam] = o = Integer.parseInt(group.substring(2));
                        }
                    } else if (!paramgenericorder) {
                        paramgenericorder = true;
                    }
                    ++nbparam;
                }
                if (!paramgenericorder) {
                    for (int i = 0; i < nbparam; ++i) {
                        if (order[i] > nbparam || order[i] == 0) {
                            paramgenericorder = true;
                            break;
                        }
                        for (int j = i + 1; j < nbparam; ++j) {
                            if (order[i] != order[j]) continue;
                            paramgenericorder = true;
                            break;
                        }
                        if (paramgenericorder) break;
                    }
                    exceptionOrder.put(str, order);
                }
                exceptionMessages.put(str, msg_parts);
            }
            catch (PatternSyntaxException p) {
                // empty catch block
            }
        }
        int j = 0;
        sb.append(msg_parts[0]);
        for (int i = 1; i < msg_parts.length; ++i) {
            if (j < args.length) {
                if (paramgenericorder) {
                    sb.append(args[j++]);
                } else {
                    sb.append(args[order[j++] - 1]);
                }
            }
            sb.append(msg_parts[i]);
        }
        return sb.toString();
    }
}

