/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.selectors;

import java.util.ArrayList;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.selectors.PseudoFunctionSelector;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionDir;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionHas;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionHost;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionHostContext;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionIs;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionLang;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionNot;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionNthChild;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionNthCol;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionNthLastChild;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionNthLastOfType;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionNthOfType;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionSlotted;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionWhere;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssProfile;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;

public class PseudoFactory {
    private static final String[] PSEUDOCLASS_CONSTANTSCSS3 = new String[]{"any-link", "link", "visited", "local-link", "target", "target-within", "scope", "hover", "active", "focus", "focus-visible", "focus-within", "current", "past", "future", "playing", "paused", "enabled", "disabled", "read-only", "read-write", "placeholder-shown", "default", "checked", "indeterminate", "blank", "valid", "invalid", "in-range", "out-of-range", "required", "optional", "user-invalid", "root", "empty", "first-child", "last-child", "only-child", "first-of-type", "last-of-type", "only-of-type", "left", "right", "first", "host", "fullscreen", "autofill", "defined"};
    private static final String[] PSEUDOCLASS_CONSTANTSCSS2 = new String[]{"link", "visited", "active", "focus", "hover", "first-child"};
    private static final String[] PSEUDOCLASS_CONSTANTSTV = new String[]{"link", "visited", "active", "focus", "first-child"};
    private static final String[] PSEUDOCLASS_CONSTANTSCSS1 = new String[]{"link", "visited", "active"};
    private static final String[] PSEUDOCLASS_CONSTANTS_MOBILE = new String[]{"link", "visited", "active", "focus"};
    private static final String[] PSEUDOELEMENT_CONSTANTSCSS3 = new String[]{"first-line", "first-letter", "selection", "target-text", "spelling-error", "grammar-error", "before", "after", "marker", "placeholder", "file-selector-button", "backdrop", "cue", "cue-region", "content", "shadow"};
    private static final String[] PSEUDOELEMENT_CONSTANTSCSS2 = new String[]{"first-line", "first-letter", "before", "after"};
    private static final String[] PSEUDOELEMENT_CONSTANTSCSS1 = new String[]{"first-line", "first-letter"};
    private static final String[] PSEUDOCLASS_FUNCTION_CONSTANTSCSS3 = new String[]{"nth-child", "nth-last-child", "nth-of-type", "nth-last-of-type", "lang", "not", "nth-col", "nth-last-col", "is", "where", "has", "dir", "host", "host-context", "slotted"};
    private static final String[] PSEUDOFUNCTION_CONSTANTSCSS2 = new String[]{"lang"};

    public static String[] getPseudoClass(CssVersion version, CssProfile profile) {
        switch (profile) {
            case TV: {
                return PSEUDOCLASS_CONSTANTSTV;
            }
            case MOBILE: {
                return PSEUDOCLASS_CONSTANTS_MOBILE;
            }
        }
        switch (version) {
            case CSS1: {
                return PSEUDOCLASS_CONSTANTSCSS1;
            }
            case CSS2: 
            case CSS21: {
                return PSEUDOCLASS_CONSTANTSCSS2;
            }
            case CSS3: {
                return PSEUDOCLASS_CONSTANTSCSS3;
            }
        }
        return null;
    }

    public static String[] getPseudoElement(CssVersion version) {
        switch (version) {
            case CSS2: 
            case CSS21: {
                return PSEUDOELEMENT_CONSTANTSCSS2;
            }
            case CSS3: {
                return PSEUDOELEMENT_CONSTANTSCSS3;
            }
            case CSS1: {
                return PSEUDOELEMENT_CONSTANTSCSS1;
            }
        }
        return null;
    }

    public static String[] getPseudoFunction(CssVersion version) {
        switch (version) {
            case CSS2: 
            case CSS21: {
                return PSEUDOFUNCTION_CONSTANTSCSS2;
            }
            case CSS3: {
                return PSEUDOCLASS_FUNCTION_CONSTANTSCSS3;
            }
        }
        return null;
    }

    public static String[] getPseudoElementExceptions(CssVersion version) {
        switch (version) {
            case CSS2: 
            case CSS21: 
            case CSS3: {
                return PSEUDOELEMENT_CONSTANTSCSS2;
            }
        }
        return null;
    }

    public static PseudoFunctionSelector newPseudoFunction(String name, String value, ApplContext ac) throws InvalidParamException {
        if (name == null) {
            throw new InvalidParamException("pseudo", "null pseudofunction", ac);
        }
        if (name.equals("not")) {
            return new PseudoFunctionNot(name, value);
        }
        if (name.equals("slotted")) {
            return new PseudoFunctionSlotted(name, value);
        }
        if (name.equals("host")) {
            return new PseudoFunctionSlotted(name, value);
        }
        if (name.equals("host-context")) {
            return new PseudoFunctionSlotted(name, value);
        }
        throw new InvalidParamException("pseudo", ":" + name, ac);
    }

    public static PseudoFunctionSelector newPseudoFunction(String name, ArrayList<CssSelectors> value, ApplContext ac) throws InvalidParamException {
        if (name == null) {
            throw new InvalidParamException("pseudo", "null pseudofunction", ac);
        }
        if (name.equals("not")) {
            return new PseudoFunctionNot(name, value);
        }
        if (name.equals("is")) {
            return new PseudoFunctionIs(name, value);
        }
        if (name.equals("where")) {
            return new PseudoFunctionWhere(name, value);
        }
        if (name.equals("has")) {
            return new PseudoFunctionHas(name, value);
        }
        if (name.equals("slotted")) {
            return new PseudoFunctionSlotted(name, value);
        }
        if (name.equals("host")) {
            return new PseudoFunctionHost(name, value);
        }
        if (name.equals("host-context")) {
            return new PseudoFunctionHostContext(name, value);
        }
        throw new InvalidParamException("pseudo", ":" + name, ac);
    }

    public static PseudoFunctionSelector newPseudoFunction(String name, CssExpression exp, ApplContext ac) throws InvalidParamException {
        if (name == null) {
            throw new InvalidParamException("pseudo", "null pseudofunction", ac);
        }
        if (name.equals("dir")) {
            return new PseudoFunctionDir(name, exp, ac);
        }
        if (name.equals("lang")) {
            return new PseudoFunctionLang(name, exp, ac);
        }
        if (name.equals("nth-col")) {
            return new PseudoFunctionNthCol(name, exp, ac);
        }
        if (name.equals("nth-last-col")) {
            return new PseudoFunctionNthCol(name, exp, ac);
        }
        throw new InvalidParamException("pseudo", ":" + name, ac);
    }

    public static PseudoFunctionSelector newPseudoFunction(String name, CssExpression exp, ArrayList<CssSelectors> selector_list, ApplContext ac) throws InvalidParamException {
        if (name == null) {
            throw new InvalidParamException("pseudo", "null pseudofunction", ac);
        }
        if (name.equals("nth-child")) {
            return new PseudoFunctionNthChild(name, exp, selector_list, ac);
        }
        if (name.equals("nth-last-child")) {
            return new PseudoFunctionNthLastChild(name, exp, selector_list, ac);
        }
        if (name.equals("nth-of-type")) {
            return new PseudoFunctionNthOfType(name, exp, selector_list, ac);
        }
        if (name.equals("nth-last-of-type")) {
            return new PseudoFunctionNthLastOfType(name, exp, selector_list, ac);
        }
        throw new InvalidParamException("pseudo", ":" + name, ac);
    }
}

