/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBackgroundSize
extends org.w3c.css.properties.css.CssBackgroundSize {
    private static CssIdent auto = CssIdent.getIdent("auto");
    private static CssIdent[] allowed_values = new CssIdent[3];

    public static boolean isMatchingIdent(CssIdent ident) {
        return CssBackgroundSize.getMatchingIdent(ident) != null;
    }

    public static CssIdent getMatchingIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssBackgroundSize() {
        this.value = auto;
    }

    public CssBackgroundSize(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        this.value = CssBackgroundSize.checkBackgroundSize(ac, expression, this);
    }

    public static CssValue checkBackgroundSize(ApplContext ac, CssExpression ex, CssProperty caller) throws InvalidParamException {
        return CssBackgroundSize.checkBackgroundSize(ac, ex, caller.getPropertyName());
    }

    public static CssValue checkBackgroundSize(ApplContext ac, CssExpression expression, String caller) throws InvalidParamException {
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        CssValueList vl = null;
        boolean is_complete = true;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val.getCheckableValue().checkEqualsZero(ac, caller);
                }
                case 4: 
                case 6: {
                    val.getCheckableValue().checkPositiveness(ac, caller);
                    if (is_complete) {
                        vl = new CssValueList();
                        vl.add(val);
                    } else {
                        vl.add(val);
                        values.add(vl);
                    }
                    is_complete = !is_complete;
                    break;
                }
                case 0: {
                    CssIdent id = val.getIdent();
                    if (CssIdent.isCssWide(id)) {
                        if (values.size() > 0 || expression.getCount() > 1) {
                            throw new InvalidParamException("value", val, caller, ac);
                        }
                        values.add(val);
                        break;
                    }
                    if (auto.equals(id)) {
                        if (is_complete) {
                            vl = new CssValueList();
                            vl.add(val);
                        } else {
                            vl.add(val);
                            values.add(vl);
                        }
                        is_complete = !is_complete;
                        break;
                    }
                    if (CssBackgroundSize.getMatchingIdent(id) != null && is_complete) {
                        values.add(val);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val, caller, ac);
                }
            }
            expression.next();
            if (expression.end()) continue;
            if (!is_complete && op == ',') {
                values.add(vl);
                is_complete = true;
            }
            if ((!is_complete || op == ',') && (is_complete || op == ' ')) continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        if (!is_complete) {
            values.add(vl);
        }
        if (values.size() == 1) {
            return (CssValue)values.get(0);
        }
        return new CssLayerList(values);
    }

    public CssBackgroundSize(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public boolean isDefault() {
        return auto == this.value;
    }

    static {
        CssBackgroundSize.allowed_values[0] = auto;
        CssBackgroundSize.allowed_values[1] = CssIdent.getIdent("cover");
        CssBackgroundSize.allowed_values[2] = CssIdent.getIdent("contain");
    }
}

