/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.log.format.Formatter;
import org.apache.log.output.AbstractOutputTarget;

public class StreamTarget
extends AbstractOutputTarget {
    private OutputStream m_outputStream;
    private String m_encoding;

    public StreamTarget(OutputStream outputStream, Formatter formatter, String encoding) {
        super(formatter);
        this.m_encoding = encoding;
        if (null != outputStream) {
            this.setOutputStream(outputStream);
            this.open();
        }
    }

    public StreamTarget(OutputStream outputStream, Formatter formatter) {
        this(outputStream, formatter, null);
    }

    protected synchronized void setOutputStream(OutputStream outputStream) {
        if (null == outputStream) {
            throw new NullPointerException("outputStream property must not be null");
        }
        this.m_outputStream = outputStream;
    }

    protected synchronized void write(String data) {
        OutputStream outputStream = this.m_outputStream;
        if (null == outputStream) {
            String message = "Attempted to write data '" + data + "' to Null OutputStream";
            this.getErrorHandler().error(message, null, null);
            return;
        }
        try {
            byte[] bytes = this.m_encoding == null ? data.getBytes() : data.getBytes(this.m_encoding);
            outputStream.write(bytes);
            outputStream.flush();
        }
        catch (IOException ioe) {
            String message = "Error writing data '" + data + "' to OutputStream";
            this.getErrorHandler().error(message, ioe, null);
        }
    }

    public synchronized void close() {
        super.close();
        this.shutdownStream();
    }

    protected synchronized void shutdownStream() {
        OutputStream outputStream = this.m_outputStream;
        this.m_outputStream = null;
        try {
            if (null != outputStream && System.out != outputStream && System.err != outputStream) {
                outputStream.close();
            }
        }
        catch (IOException ioe) {
            this.getErrorHandler().error("Error closing OutputStream", ioe, null);
        }
    }
}

