/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker.table;

import org.xml.sax.Locator;

final class ColumnRange {
    private final Locator locator;
    private final String element;
    private int left;
    private int right;
    private ColumnRange next;

    public ColumnRange(String element, Locator locator, int left, int right) {
        assert (right > left);
        this.element = element;
        this.locator = locator;
        this.left = left;
        this.right = right;
        this.next = null;
    }

    String getElement() {
        return this.element;
    }

    Locator getLocator() {
        return this.locator;
    }

    int hits(int column) {
        if (column < this.left) {
            return -1;
        }
        if (column >= this.right) {
            return 1;
        }
        return 0;
    }

    ColumnRange removeColumn(int column) {
        if (this.isSingleCol()) {
            return null;
        }
        if (column == this.left) {
            ++this.left;
            return this;
        }
        if (column + 1 == this.right) {
            --this.right;
            return this;
        }
        ColumnRange created = new ColumnRange(this.element, this.locator, column + 1, this.right);
        created.next = this.next;
        this.next = created;
        this.right = column;
        return created;
    }

    ColumnRange getNext() {
        return this.next;
    }

    void setNext(ColumnRange next) {
        this.next = next;
    }

    boolean isSingleCol() {
        return this.left + 1 == this.right;
    }

    public String toString() {
        if (this.isSingleCol()) {
            return Integer.toString(this.right);
        }
        return this.left + 1 + "\u2026" + this.right;
    }
}

