/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import nu.validator.checker.AttributeUtil;
import nu.validator.checker.Checker;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ConformingButObsoleteWarner
extends Checker {
    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if ("http://www.w3.org/1999/xhtml" == uri) {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attributeName = atts.getLocalName(i);
                if (!"aria-dropeffect".equals(attributeName) && !"aria-grabbed".equals(attributeName)) continue;
                this.warn("The \u201c" + attributeName + "\u201d attribute is deprecated and should not be used. Support for it is poor and is unlikely to improve.");
            }
            if ("img" == localName) {
                if (atts.getIndex("", "border") > -1) {
                    this.warn("The \u201cborder\u201d attribute is obsolete. Consider specifying \u201cimg { border: 0; }\u201d in CSS instead.");
                }
            } else if ("script" == localName) {
                String type;
                if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("javascript", atts.getValue("", "language")) && ((type = atts.getValue("", "type")) == null || AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("text/javascript", type))) {
                    this.warn("The \u201clanguage\u201d attribute on the \u201cscript\u201d element is obsolete. You can safely omit it.");
                }
            } else if ("a" == localName && atts.getIndex("", "name") > -1) {
                this.warn("The \u201cname\u201d attribute is obsolete. Consider putting an \u201cid\u201d attribute on the nearest container instead.");
            }
        }
    }
}

