/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.ErrorIterator;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.GenericSorter;
import net.sf.saxon.sort.SortKeyEvaluator;
import net.sf.saxon.sort.Sortable;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class SortedIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator,
Sortable {
    protected SequenceIterator base;
    protected SortKeyEvaluator sortKeyEvaluator;
    protected AtomicComparer[] comparators;
    protected int recordSize;
    protected Object[] nodeKeys;
    protected int count = -1;
    protected int position = 0;
    protected XPathContext context;
    private int hostLanguage;

    private SortedIterator() {
    }

    public SortedIterator(XPathContext context, SequenceIterator base, SortKeyEvaluator sortKeyEvaluator, AtomicComparer[] comparators) {
        this.context = context.newMinorContext();
        this.context.setOriginatingConstructType(2061);
        this.context.setCurrentIterator(base);
        this.base = base;
        this.sortKeyEvaluator = sortKeyEvaluator;
        this.comparators = new AtomicComparer[comparators.length];
        for (int n = 0; n < comparators.length; ++n) {
            this.comparators[n] = comparators[n].provideContext(context);
        }
        this.recordSize = comparators.length + 2;
    }

    public void setHostLanguage(int language) {
        this.hostLanguage = language;
    }

    public boolean hasNext() {
        if (this.position < 0) {
            return false;
        }
        if (this.count < 0) {
            if (this.base instanceof LookaheadIterator) {
                return ((LookaheadIterator)this.base).hasNext();
            }
            try {
                this.doSort();
                return this.count > 0;
            }
            catch (XPathException err) {
                this.count = -1;
                this.base = new ErrorIterator(err);
                return true;
            }
        }
        return this.position < this.count;
    }

    public Item next() throws XPathException {
        if (this.position < 0) {
            return null;
        }
        if (this.count < 0) {
            this.doSort();
        }
        if (this.position < this.count) {
            return (Item)this.nodeKeys[this.position++ * this.recordSize];
        }
        this.position = -1;
        return null;
    }

    public Item current() {
        if (this.position < 1) {
            return null;
        }
        return (Item)this.nodeKeys[(this.position - 1) * this.recordSize];
    }

    public int position() {
        return this.position;
    }

    public int getLastPosition() throws XPathException {
        if (this.count < 0) {
            this.doSort();
        }
        return this.count;
    }

    public void close() {
    }

    public SequenceIterator getAnother() throws XPathException {
        if (this.count < 0) {
            this.doSort();
        }
        SortedIterator s = new SortedIterator();
        s.base = this.base.getAnother();
        s.sortKeyEvaluator = this.sortKeyEvaluator;
        s.comparators = this.comparators;
        s.recordSize = this.recordSize;
        s.nodeKeys = this.nodeKeys;
        s.count = this.count;
        s.context = this.context;
        s.position = 0;
        return s;
    }

    public int getProperties() {
        return 2;
    }

    protected void buildArray() throws XPathException {
        Item item;
        int allocated = (this.base.getProperties() & 2) != 0 ? ((LastPositionFinder)this.base).getLastPosition() : 100;
        this.nodeKeys = new Object[allocated * this.recordSize];
        this.count = 0;
        while ((item = this.base.next()) != null) {
            if (this.count == allocated) {
                Object[] nk2 = new Object[(allocated *= 2) * this.recordSize];
                System.arraycopy(this.nodeKeys, 0, nk2, 0, this.count * this.recordSize);
                this.nodeKeys = nk2;
            }
            int k = this.count * this.recordSize;
            this.nodeKeys[k] = item;
            for (int n = 0; n < this.comparators.length; ++n) {
                this.nodeKeys[k + n + 1] = this.sortKeyEvaluator.evaluateSortKey(n, this.context);
            }
            this.nodeKeys[k + this.comparators.length + 1] = new Integer(this.count);
            ++this.count;
        }
        if (allocated * 2 < this.count || allocated - this.count > 2000) {
            Object[] nk2 = new Object[this.count * this.recordSize];
            System.arraycopy(this.nodeKeys, 0, nk2, 0, this.count * this.recordSize);
            this.nodeKeys = nk2;
        }
    }

    private void doSort() throws XPathException {
        this.buildArray();
        if (this.count < 2) {
            return;
        }
        try {
            GenericSorter.quickSort(0, this.count, this);
        }
        catch (ClassCastException e) {
            XPathException err = new XPathException("Non-comparable types found while sorting: " + e.getMessage());
            if (this.hostLanguage == 50) {
                err.setErrorCode("XTDE1030");
            } else {
                err.setErrorCode("XPTY0004");
            }
            throw err;
        }
    }

    public int compare(int a, int b) {
        int a1 = a * this.recordSize + 1;
        int b1 = b * this.recordSize + 1;
        try {
            for (int i = 0; i < this.comparators.length; ++i) {
                int comp = this.comparators[i].compareAtomicValues((AtomicValue)this.nodeKeys[a1 + i], (AtomicValue)this.nodeKeys[b1 + i]);
                if (comp == 0) continue;
                return comp;
            }
        }
        catch (NoDynamicContextException e) {
            throw new AssertionError((Object)("Sorting without dynamic context: " + e.getMessage()));
        }
        return (Integer)this.nodeKeys[a1 + this.comparators.length] - (Integer)this.nodeKeys[b1 + this.comparators.length];
    }

    public void swap(int a, int b) {
        int a1 = a * this.recordSize;
        int b1 = b * this.recordSize;
        for (int i = 0; i < this.recordSize; ++i) {
            Object temp = this.nodeKeys[a1 + i];
            this.nodeKeys[a1 + i] = this.nodeKeys[b1 + i];
            this.nodeKeys[b1 + i] = temp;
        }
    }
}

