/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public final class Comment
extends SimpleNodeConstructor {
    public int getInstructionNameCode() {
        return 138;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.COMMENT;
    }

    public int getCardinality() {
        return 16384;
    }

    public Expression copy() {
        Comment exp = new Comment();
        try {
            exp.setSelect(this.select.copy(), this.getExecutable().getConfiguration());
        }
        catch (XPathException err) {
            throw new UnsupportedOperationException(err.getMessage());
        }
        return exp;
    }

    public void localTypeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        String s;
        String s2;
        if (this.select instanceof Literal && !(s2 = this.checkContent(s = ((Literal)this.select).getValue().getStringValue(), visitor.getStaticContext().makeEarlyEvaluationContext())).equals(s)) {
            this.setSelect(new StringLiteral(s2), visitor.getConfiguration());
        }
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        String comment = ((Object)this.expandChildren(context)).toString();
        comment = this.checkContent(comment, context);
        SequenceReceiver out = context.getReceiver();
        out.comment(comment, this.locationId, 0);
        return null;
    }

    protected String checkContent(String comment, XPathContext context) throws XPathException {
        int hh;
        while ((hh = comment.indexOf("--")) >= 0) {
            if (this.isXSLT()) {
                comment = comment.substring(0, hh + 1) + ' ' + comment.substring(hh + 1);
                continue;
            }
            XPathException err = new XPathException("Invalid characters (--) in comment", this);
            err.setErrorCode("XQDY0072");
            err.setXPathContext(context);
            throw Comment.dynamicError(this, err, context);
        }
        if (comment.length() > 0 && comment.charAt(comment.length() - 1) == '-') {
            if (this.isXSLT()) {
                comment = comment + ' ';
            } else {
                XPathException err = new XPathException("Comment cannot end in '-'", this);
                err.setErrorCode("XQDY0072");
                err.setXPathContext(context);
                throw Comment.dynamicError(this, err, context);
            }
        }
        return comment;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("comment");
        this.getSelect().explain(out);
        out.endElement();
    }
}

