/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.oql.engine.api;

import java.lang.ref.WeakReference;
import java.util.Objects;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;

public final class ReferenceChain {
    private WeakReference<Object> obj;
    ReferenceChain next;
    private Heap heap;
    private long id;
    private char type;
    private static final char TYPE_INSTANCE = '\u0000';
    private static final char TYPE_CLASS = '\u0001';

    public ReferenceChain(Heap heap, Object obj, ReferenceChain next) {
        this.obj = new WeakReference<Object>(obj);
        this.next = next;
        this.heap = heap;
        if (obj instanceof Instance) {
            this.type = '\u0000';
            this.id = ((Instance)obj).getInstanceId();
        } else if (obj instanceof JavaClass) {
            this.type = '\u0001';
            this.id = ((JavaClass)obj).getJavaClassId();
        }
    }

    public Object getObj() {
        Object o = this.obj.get();
        if (o == null) {
            if (this.type == '\u0000') {
                o = this.heap.getInstanceByID(this.id);
            } else if (this.type == '\u0001') {
                o = this.heap.getJavaClassByID(this.id);
            }
            this.obj = new WeakReference(o);
        }
        return o;
    }

    public ReferenceChain getNext() {
        return this.next;
    }

    public boolean contains(Object obj) {
        ReferenceChain tmp = this;
        while (tmp != null) {
            if (tmp.getObj().equals(obj)) {
                return true;
            }
            tmp = tmp.next;
        }
        return false;
    }

    public int getDepth() {
        int count = 1;
        ReferenceChain tmp = this.next;
        while (tmp != null) {
            ++count;
            tmp = tmp.next;
        }
        return count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.obj instanceof Instance) {
            Instance inst = (Instance)this.obj;
            sb.append(inst.getJavaClass().getName()).append("#").append(inst.getInstanceNumber());
        } else if (this.obj instanceof JavaClass) {
            sb.append("class of ").append(((JavaClass)this.obj).getName());
        }
        sb.append(this.next != null ? "->" + this.next.toString() : "");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceChain other = (ReferenceChain)obj;
        if (!Objects.equals(obj, other.obj)) {
            return false;
        }
        return Objects.equals(this.next, other.next);
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + (this.obj != null ? this.obj.hashCode() : 0);
        hash = 79 * hash + (this.next != null ? this.next.hashCode() : 0);
        return hash;
    }
}

