import sys

# sys.platform.startswith(("sunos", "solaris")):
if sys.platform != "linux" and sys.platform != "win32" and sys.platform != "darwin":
    from typing import Final

    AF_LINK: Final[int]

    def getpagesize() -> int: ...
    def net_if_addrs() -> list[tuple[str, int, str, str | None, str | None, str | None]]: ...
    def net_if_flags(nic_name: str, /) -> list[str]: ...
    def net_if_is_running(nic_name: str, /) -> bool: ...
    def net_if_mtu(nic_name: str, /) -> int: ...
    def proc_priority_get(pid: int, /) -> int: ...
    def proc_priority_set(pid: int, priority: int, /) -> None: ...
    def users() -> list[tuple[str, str, str, float, int]]: ...

    version: Final[int]
    # They could be different between different versions of SunOS/Solaris:
    SSLEEP: Final[int]
    SRUN: Final[int]
    SZOMB: Final[int]
    SSTOP: Final[int]
    SIDL: Final[int]
    SONPROC: Final[int]
    SWAIT: Final[int]
    PRNODEV: Final[int]
    TCPS_CLOSED: Final[int]
    TCPS_CLOSING: Final[int]
    TCPS_CLOSE_WAIT: Final[int]
    TCPS_LISTEN: Final[int]
    TCPS_ESTABLISHED: Final[int]
    TCPS_SYN_SENT: Final[int]
    TCPS_SYN_RCVD: Final[int]
    TCPS_FIN_WAIT_1: Final[int]
    TCPS_FIN_WAIT_2: Final[int]
    TCPS_LAST_ACK: Final[int]
    TCPS_TIME_WAIT: Final[int]
    TCPS_IDLE: Final[int]
    TCPS_BOUND: Final[int]
    PSUTIL_CONN_NONE: Final = 128

    def proc_basic_info(pid: int, procfs_path: str, /) -> tuple[int, int, int, float, int, int, int, int, int, int, int, int]: ...
    def proc_cpu_num(pid: int, procfs_path: str, /) -> int: ...
    def proc_cpu_times(pid: int, procfs_path: str, /) -> tuple[float, float, float, float]: ...
    def proc_cred(pid: int, procfs_path: str, /) -> tuple[int, int, int, int, int, int]: ...
    def proc_environ(pid: int, procfs_path: str, /) -> dict[str, str]: ...
    def proc_memory_maps(pid: int, procfs_path: str, /) -> list[tuple[int, int, str, str, int, int, int]]: ...
    def proc_name_and_args(pid: int, procfs_path: str, /) -> tuple[str, list[str] | None]: ...
    def proc_num_ctx_switches(pid: int, procfs_path: str, /) -> tuple[int, int]: ...
    def query_process_thread(pid: int, tid: int, procfs_path: str, /) -> tuple[float, float]: ...
    def boot_time() -> float: ...
    def cpu_count_cores() -> int | None: ...
    def cpu_stats() -> tuple[int, int, int, int]: ...
    def disk_io_counters() -> dict[str, tuple[int, int, int, int, int, int]]: ...
    def disk_partitions() -> list[tuple[str, str, str, str]]: ...
    def net_connections(pid: int, /) -> list[tuple[int, int, int, tuple[str, int], tuple[str, int] | tuple[()], int, int]]: ...
    def net_if_stats() -> dict[str, tuple[bool, int, int, int]]: ...
    def net_io_counters() -> dict[str, tuple[int, int, int, int, int, int, int, int]]: ...
    def per_cpu_times() -> list[tuple[float, float, float, float]]: ...
    def swap_mem() -> tuple[int, int]: ...
    def check_pid_range(pid: int, /) -> None: ...
    def set_debug(value: bool, /) -> None: ...
