/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.CodeElement;
import io.github.dmlloyd.classfile.Signature;
import io.github.dmlloyd.classfile.TypeKind;
import io.github.dmlloyd.classfile.components.CodeLocalsShifter;
import io.github.dmlloyd.classfile.instruction.IncrementInstruction;
import io.github.dmlloyd.classfile.instruction.LoadInstruction;
import io.github.dmlloyd.classfile.instruction.LocalVariable;
import io.github.dmlloyd.classfile.instruction.LocalVariableType;
import io.github.dmlloyd.classfile.instruction.StoreInstruction;
import java.util.Arrays;

public final class CodeLocalsShifterImpl
implements CodeLocalsShifter {
    private int[] locals = new int[0];
    private final int fixed;

    public CodeLocalsShifterImpl(int fixed) {
        this.fixed = fixed;
    }

    @Override
    public void accept(CodeBuilder cob, CodeElement coe) {
        if (coe instanceof LoadInstruction) {
            LoadInstruction li = (LoadInstruction)coe;
            cob.loadLocal(li.typeKind(), this.shift(cob, li.slot(), li.typeKind()));
        } else if (coe instanceof StoreInstruction) {
            StoreInstruction si = (StoreInstruction)coe;
            cob.storeLocal(si.typeKind(), this.shift(cob, si.slot(), si.typeKind()));
        } else if (coe instanceof IncrementInstruction) {
            IncrementInstruction ii = (IncrementInstruction)coe;
            cob.iinc(this.shift(cob, ii.slot(), TypeKind.INT), ii.constant());
        } else if (coe instanceof LocalVariable) {
            LocalVariable lv = (LocalVariable)coe;
            cob.localVariable(this.shift(cob, lv.slot(), TypeKind.fromDescriptor(lv.type().stringValue())), lv.name(), lv.type(), lv.startScope(), lv.endScope());
        } else if (coe instanceof LocalVariableType) {
            TypeKind typeKind;
            LocalVariableType lvt = (LocalVariableType)coe;
            int n = lvt.slot();
            Signature signature = lvt.signatureSymbol();
            if (signature instanceof Signature.BaseTypeSig) {
                Signature.BaseTypeSig bsig = (Signature.BaseTypeSig)signature;
                typeKind = TypeKind.fromDescriptor(bsig.signatureString());
            } else {
                typeKind = TypeKind.REFERENCE;
            }
            cob.localVariableType(this.shift(cob, n, typeKind), lvt.name(), lvt.signature(), lvt.startScope(), lvt.endScope());
        } else {
            cob.with(coe);
        }
    }

    private int shift(CodeBuilder cob, int slot, TypeKind tk) {
        if (tk == TypeKind.VOID) {
            throw new IllegalArgumentException("Illegal local void type");
        }
        if (slot >= this.fixed) {
            int key = 2 * slot - this.fixed + tk.slotSize() - 1;
            if (key >= this.locals.length) {
                this.locals = Arrays.copyOf(this.locals, key + 20);
            }
            if ((slot = this.locals[key] - 1) < 0) {
                slot = cob.allocateLocal(tk);
                this.locals[key] = slot + 1;
                if (tk.slotSize() == 2) {
                    this.locals[key - 1] = slot + 1;
                }
            }
        }
        return slot;
    }
}

