/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.ext.DoubleByte;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.MS932;
import sun.nio.cs.ext.SJIS_0213;

public class MS932_0213
extends Charset {
    public MS932_0213() {
        super("x-MS932_0213", ExtendedCharsets.aliasesFor("MS932_0213"));
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof MS932 || charset instanceof MS932_0213;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected static class Encoder
    extends SJIS_0213.Encoder {
        static DoubleByte.Encoder encMS932 = (DoubleByte.Encoder)new MS932().newEncoder();

        protected Encoder(Charset charset) {
            super(charset);
        }

        @Override
        protected int encodeChar(char c) {
            int n = encMS932.encodeChar(c);
            if (n == 65533) {
                return super.encodeChar(c);
            }
            return n;
        }
    }

    protected static class Decoder
    extends SJIS_0213.Decoder {
        static DoubleByte.Decoder decMS932 = (DoubleByte.Decoder)new MS932().newDecoder();

        protected Decoder(Charset charset) {
            super(charset);
        }

        @Override
        protected char decodeDouble(int n, int n2) {
            char c = decMS932.decodeDouble(n, n2);
            if (c == '\ufffd') {
                return super.decodeDouble(n, n2);
            }
            return c;
        }
    }
}

