//
// Timezone.h
//
// $Id: //poco/1.4/Foundation/include/Poco/Timezone.h#1 $
//
// Library: Foundation
// Package: DateTime
// Module:  Timezone
//
// Definition of the Timezone class.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Foundation_Timezone_INCLUDED
#define Foundation_Timezone_INCLUDED


#include "Poco/Foundation.h"
#include "Poco/Timestamp.h"


namespace Poco {


class Foundation_API Timezone
	/// This class provides information about the current timezone.
{
public:
	static int utcOffset();
		/// Returns the offset of local time to UTC, in seconds.
		///     local time = UTC + utcOffset() + dst().
		
	static int dst();
		/// Returns the daylight saving time offset in seconds if
		/// daylight saving time is in use.
		///     local time = UTC + utcOffset() + dst().
	
	static bool isDst(const Timestamp& timestamp);
		/// Returns true if daylight saving time is in effect
		/// for the given time. Depending on the operating system
		/// platform this might only work reliably for certain
		/// date ranges, as the C library's localtime() function
		/// is used.
		
	static int tzd();
		/// Returns the time zone differential for the current timezone.
		/// The timezone differential is computed as utcOffset() + dst()
		/// and is expressed in seconds.
	
	static std::string name();
		/// Returns the timezone name currently in effect.
		
	static std::string standardName();
		/// Returns the timezone name if not daylight saving time is in effect.
		
	static std::string dstName();
		/// Returns the timezone name if daylight saving time is in effect.
};


} // namespace Poco


#endif // Foundation_Timezone_INCLUDED
